package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties for defining a <code>CfnStateMachineVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * CfnStateMachineVersionProps cfnStateMachineVersionProps = CfnStateMachineVersionProps.builder()
 *         .stateMachineArn("stateMachineArn")
 *         // the properties below are optional
 *         .description("description")
 *         .stateMachineRevisionId("stateMachineRevisionId")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachineversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachineversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:59.813Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.CfnStateMachineVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnStateMachineVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStateMachineVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the state machine.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachineversion.html#cfn-stepfunctions-statemachineversion-statemachinearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachineversion.html#cfn-stepfunctions-statemachineversion-statemachinearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStateMachineArn();

    /**
     * An optional description of the state machine version.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachineversion.html#cfn-stepfunctions-statemachineversion-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachineversion.html#cfn-stepfunctions-statemachineversion-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Identifier for a state machine revision, which is an immutable, read-only snapshot of a state machine’s definition and configuration.
     * <p>
     * Only publish the state machine version if the current state machine's revision ID matches the specified ID. Use this option to avoid publishing a version if the state machine has changed since you last updated it.
     * <p>
     * To specify the initial state machine revision, set the value as <code>INITIAL</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachineversion.html#cfn-stepfunctions-statemachineversion-statemachinerevisionid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-stepfunctions-statemachineversion.html#cfn-stepfunctions-statemachineversion-statemachinerevisionid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStateMachineRevisionId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStateMachineVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStateMachineVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStateMachineVersionProps> {
        java.lang.String stateMachineArn;
        java.lang.String description;
        java.lang.String stateMachineRevisionId;

        /**
         * Sets the value of {@link CfnStateMachineVersionProps#getStateMachineArn}
         * @param stateMachineArn The Amazon Resource Name (ARN) of the state machine. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateMachineArn(java.lang.String stateMachineArn) {
            this.stateMachineArn = stateMachineArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineVersionProps#getDescription}
         * @param description An optional description of the state machine version.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnStateMachineVersionProps#getStateMachineRevisionId}
         * @param stateMachineRevisionId Identifier for a state machine revision, which is an immutable, read-only snapshot of a state machine’s definition and configuration.
         *                               Only publish the state machine version if the current state machine's revision ID matches the specified ID. Use this option to avoid publishing a version if the state machine has changed since you last updated it.
         *                               <p>
         *                               To specify the initial state machine revision, set the value as <code>INITIAL</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateMachineRevisionId(java.lang.String stateMachineRevisionId) {
            this.stateMachineRevisionId = stateMachineRevisionId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStateMachineVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStateMachineVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStateMachineVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStateMachineVersionProps {
        private final java.lang.String stateMachineArn;
        private final java.lang.String description;
        private final java.lang.String stateMachineRevisionId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stateMachineArn = software.amazon.jsii.Kernel.get(this, "stateMachineArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stateMachineRevisionId = software.amazon.jsii.Kernel.get(this, "stateMachineRevisionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stateMachineArn = java.util.Objects.requireNonNull(builder.stateMachineArn, "stateMachineArn is required");
            this.description = builder.description;
            this.stateMachineRevisionId = builder.stateMachineRevisionId;
        }

        @Override
        public final java.lang.String getStateMachineArn() {
            return this.stateMachineArn;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getStateMachineRevisionId() {
            return this.stateMachineRevisionId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stateMachineArn", om.valueToTree(this.getStateMachineArn()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getStateMachineRevisionId() != null) {
                data.set("stateMachineRevisionId", om.valueToTree(this.getStateMachineRevisionId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.CfnStateMachineVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStateMachineVersionProps.Jsii$Proxy that = (CfnStateMachineVersionProps.Jsii$Proxy) o;

            if (!stateMachineArn.equals(that.stateMachineArn)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.stateMachineRevisionId != null ? this.stateMachineRevisionId.equals(that.stateMachineRevisionId) : that.stateMachineRevisionId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stateMachineArn.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.stateMachineRevisionId != null ? this.stateMachineRevisionId.hashCode() : 0);
            return result;
        }
    }
}
