package software.amazon.awscdk.services.stepfunctions;

/**
 * Values allowed in the retrier JitterStrategy field.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Parallel parallel = new Parallel(this, "Do the work in parallel");
 * // Add branches to be executed in parallel
 * Pass shipItem = new Pass(this, "ShipItem");
 * Pass sendInvoice = new Pass(this, "SendInvoice");
 * Pass restock = new Pass(this, "Restock");
 * parallel.branch(shipItem);
 * parallel.branch(sendInvoice);
 * parallel.branch(restock);
 * // Retry the whole workflow if something goes wrong with exponential backoff
 * parallel.addRetry(RetryProps.builder()
 *         .maxAttempts(1)
 *         .maxDelay(Duration.seconds(5))
 *         .jitterStrategy(JitterType.FULL)
 *         .build());
 * // How to recover from errors
 * Pass sendFailureNotification = new Pass(this, "SendFailureNotification");
 * parallel.addCatch(sendFailureNotification);
 * // What to do in case everything succeeded
 * Pass closeOrder = new Pass(this, "CloseOrder");
 * parallel.next(closeOrder);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:39:59.850Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.JitterType")
public enum JitterType {
    /**
     * Calculates the delay to be a random number between 0 and the computed backoff for the given retry attempt count.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FULL,
    /**
     * Calculates the delay to be the computed backoff for the given retry attempt count (equivalent to if Jitter was not declared - i.e. the default value).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
}
