package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Options to run an ECS task on EC2 in StepFunctions and ECS.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc = Vpc.fromLookup(this, "Vpc", VpcLookupOptions.builder()
 *         .isDefault(true)
 *         .build());
 * Cluster cluster = Cluster.Builder.create(this, "Ec2Cluster").vpc(vpc).build();
 * cluster.addCapacity("DefaultAutoScalingGroup", AddCapacityOptions.builder()
 *         .instanceType(new InstanceType("t2.micro"))
 *         .vpcSubnets(SubnetSelection.builder().subnetType(SubnetType.PUBLIC).build())
 *         .build());
 * TaskDefinition taskDefinition = TaskDefinition.Builder.create(this, "TD")
 *         .compatibility(Compatibility.EC2)
 *         .build();
 * taskDefinition.addContainer("TheContainer", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("foo/bar"))
 *         .memoryLimitMiB(256)
 *         .build());
 * EcsRunTask runTask = EcsRunTask.Builder.create(this, "Run")
 *         .integrationPattern(IntegrationPattern.RUN_JOB)
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .launchTarget(EcsEc2LaunchTarget.Builder.create()
 *                 .placementStrategies(List.of(PlacementStrategy.spreadAcrossInstances(), PlacementStrategy.packedByCpu(), PlacementStrategy.randomly()))
 *                 .placementConstraints(List.of(PlacementConstraint.memberOf("blieptuut")))
 *                 .build())
 *         .propagatedTagSource(PropagatedTagSource.TASK_DEFINITION)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:40:00.096Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.EcsEc2LaunchTargetOptions")
@software.amazon.jsii.Jsii.Proxy(EcsEc2LaunchTargetOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EcsEc2LaunchTargetOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Placement constraints.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> getPlacementConstraints() {
        return null;
    }

    /**
     * Placement strategies.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ecs.PlacementStrategy> getPlacementStrategies() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EcsEc2LaunchTargetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EcsEc2LaunchTargetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EcsEc2LaunchTargetOptions> {
        java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints;
        java.util.List<software.amazon.awscdk.services.ecs.PlacementStrategy> placementStrategies;

        /**
         * Sets the value of {@link EcsEc2LaunchTargetOptions#getPlacementConstraints}
         * @param placementConstraints Placement constraints.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder placementConstraints(java.util.List<? extends software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints) {
            this.placementConstraints = (java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint>)placementConstraints;
            return this;
        }

        /**
         * Sets the value of {@link EcsEc2LaunchTargetOptions#getPlacementStrategies}
         * @param placementStrategies Placement strategies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder placementStrategies(java.util.List<? extends software.amazon.awscdk.services.ecs.PlacementStrategy> placementStrategies) {
            this.placementStrategies = (java.util.List<software.amazon.awscdk.services.ecs.PlacementStrategy>)placementStrategies;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EcsEc2LaunchTargetOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EcsEc2LaunchTargetOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EcsEc2LaunchTargetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EcsEc2LaunchTargetOptions {
        private final java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> placementConstraints;
        private final java.util.List<software.amazon.awscdk.services.ecs.PlacementStrategy> placementStrategies;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.placementConstraints = software.amazon.jsii.Kernel.get(this, "placementConstraints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementConstraint.class)));
            this.placementStrategies = software.amazon.jsii.Kernel.get(this, "placementStrategies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PlacementStrategy.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.placementConstraints = (java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint>)builder.placementConstraints;
            this.placementStrategies = (java.util.List<software.amazon.awscdk.services.ecs.PlacementStrategy>)builder.placementStrategies;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.PlacementConstraint> getPlacementConstraints() {
            return this.placementConstraints;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ecs.PlacementStrategy> getPlacementStrategies() {
            return this.placementStrategies;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPlacementConstraints() != null) {
                data.set("placementConstraints", om.valueToTree(this.getPlacementConstraints()));
            }
            if (this.getPlacementStrategies() != null) {
                data.set("placementStrategies", om.valueToTree(this.getPlacementStrategies()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.EcsEc2LaunchTargetOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EcsEc2LaunchTargetOptions.Jsii$Proxy that = (EcsEc2LaunchTargetOptions.Jsii$Proxy) o;

            if (this.placementConstraints != null ? !this.placementConstraints.equals(that.placementConstraints) : that.placementConstraints != null) return false;
            return this.placementStrategies != null ? this.placementStrategies.equals(that.placementStrategies) : that.placementStrategies == null;
        }

        @Override
        public final int hashCode() {
            int result = this.placementConstraints != null ? this.placementConstraints.hashCode() : 0;
            result = 31 * result + (this.placementStrategies != null ? this.placementStrategies.hashCode() : 0);
            return result;
        }
    }
}
