package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Configuration for running an ECS task on Fargate.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc = Vpc.fromLookup(this, "Vpc", VpcLookupOptions.builder()
 *         .isDefault(true)
 *         .build());
 * Cluster cluster = Cluster.Builder.create(this, "FargateCluster").vpc(vpc).build();
 * TaskDefinition taskDefinition = TaskDefinition.Builder.create(this, "TD")
 *         .memoryMiB("512")
 *         .cpu("256")
 *         .compatibility(Compatibility.FARGATE)
 *         .build();
 * ContainerDefinition containerDefinition = taskDefinition.addContainer("TheContainer", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("foo/bar"))
 *         .memoryLimitMiB(256)
 *         .build());
 * EcsRunTask runTask = EcsRunTask.Builder.create(this, "RunFargate")
 *         .integrationPattern(IntegrationPattern.RUN_JOB)
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .assignPublicIp(true)
 *         .containerOverrides(List.of(ContainerOverride.builder()
 *                 .containerDefinition(containerDefinition)
 *                 .environment(List.of(TaskEnvironmentVariable.builder().name("SOME_KEY").value(JsonPath.stringAt("$.SomeKey")).build()))
 *                 .build()))
 *         .launchTarget(new EcsFargateLaunchTarget())
 *         .propagatedTagSource(PropagatedTagSource.TASK_DEFINITION)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/userguide/launch_types.html#launch-type-fargate">https://docs.aws.amazon.com/AmazonECS/latest/userguide/launch_types.html#launch-type-fargate</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:40:00.096Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.EcsFargateLaunchTarget")
public class EcsFargateLaunchTarget extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.tasks.IEcsLaunchTarget {

    protected EcsFargateLaunchTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsFargateLaunchTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EcsFargateLaunchTarget(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTargetOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { options });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EcsFargateLaunchTarget() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Called when the Fargate launch type configured on RunTask.
     * <p>
     * @param task This parameter is required.
     * @param launchTargetOptions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EcsLaunchTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EcsRunTask task, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.LaunchTargetBindOptions launchTargetOptions) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EcsLaunchTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(task, "task is required"), java.util.Objects.requireNonNull(launchTargetOptions, "launchTargetOptions is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTarget}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTarget> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTargetOptions.Builder options;

        private Builder() {
        }

        /**
         * Refers to a specific runtime environment for Fargate task infrastructure.
         * <p>
         * Fargate platform version is a combination of the kernel and container runtime versions.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html</a>
         * @param platformVersion Refers to a specific runtime environment for Fargate task infrastructure. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformVersion(final software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion) {
            this.options().platformVersion(platformVersion);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTarget}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTarget build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTarget(
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTargetOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.stepfunctions.tasks.EcsFargateLaunchTargetOptions.Builder();
            }
            return this.options;
        }
    }
}
