package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Guradrail settings for BedrockInvokeModel.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.bedrock.*;
 * FoundationModel model = FoundationModel.fromFoundationModelId(this, "Model", FoundationModelIdentifier.AMAZON_TITAN_TEXT_G1_EXPRESS_V1);
 * BedrockInvokeModel task = BedrockInvokeModel.Builder.create(this, "Prompt Model with guardrail")
 *         .model(model)
 *         .body(TaskInput.fromObject(Map.of(
 *                 "inputText", "Generate a list of five first names.",
 *                 "textGenerationConfig", Map.of(
 *                         "maxTokenCount", 100,
 *                         "temperature", 1))))
 *         .guardrail(Guardrail.enable("guardrailId", 1))
 *         .resultSelector(Map.of(
 *                 "names", JsonPath.stringAt("$.Body.results[0].outputText")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:40:00.248Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.Guardrail")
public class Guardrail extends software.amazon.jsii.JsiiObject {

    protected Guardrail(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Guardrail(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Enable guardrail.
     * <p>
     * @param identifier The id or arn of the guardrail. This parameter is required.
     * @param version The version of the guardrail. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.Guardrail enable(final @org.jetbrains.annotations.NotNull java.lang.String identifier, final @org.jetbrains.annotations.NotNull java.lang.Number version) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.Guardrail.class, "enable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.Guardrail.class), new Object[] { java.util.Objects.requireNonNull(identifier, "identifier is required"), java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * Enable guardrail with DRAFT version.
     * <p>
     * @param identifier The identifier of the guardrail. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.Guardrail enableDraft(final @org.jetbrains.annotations.NotNull java.lang.String identifier) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.Guardrail.class, "enableDraft", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.Guardrail.class), new Object[] { java.util.Objects.requireNonNull(identifier, "identifier is required") });
    }

    /**
     * The identitifier of guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getGuardrailIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "guardrailIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of guardrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getGuardrailVersion() {
        return software.amazon.jsii.Kernel.get(this, "guardrailVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
