package software.amazon.awscdk.services.wisdom;

/**
 * Properties for defining a <code>CfnAIPromptVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wisdom.*;
 * CfnAIPromptVersionProps cfnAIPromptVersionProps = CfnAIPromptVersionProps.builder()
 *         .aiPromptId("aiPromptId")
 *         .assistantId("assistantId")
 *         // the properties below are optional
 *         .modifiedTimeSeconds(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aipromptversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aipromptversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:40:00.845Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnAIPromptVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnAIPromptVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAIPromptVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The identifier of the Amazon Q in Connect AI prompt.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aipromptversion.html#cfn-wisdom-aipromptversion-aipromptid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aipromptversion.html#cfn-wisdom-aipromptversion-aipromptid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAiPromptId();

    /**
     * The identifier of the Amazon Q in Connect assistant.
     * <p>
     * Can be either the ID or the ARN. URLs cannot contain the ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aipromptversion.html#cfn-wisdom-aipromptversion-assistantid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aipromptversion.html#cfn-wisdom-aipromptversion-assistantid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAssistantId();

    /**
     * The time the AI Prompt version was last modified in seconds.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aipromptversion.html#cfn-wisdom-aipromptversion-modifiedtimeseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-aipromptversion.html#cfn-wisdom-aipromptversion-modifiedtimeseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getModifiedTimeSeconds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAIPromptVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAIPromptVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAIPromptVersionProps> {
        java.lang.String aiPromptId;
        java.lang.String assistantId;
        java.lang.Number modifiedTimeSeconds;

        /**
         * Sets the value of {@link CfnAIPromptVersionProps#getAiPromptId}
         * @param aiPromptId The identifier of the Amazon Q in Connect AI prompt. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder aiPromptId(java.lang.String aiPromptId) {
            this.aiPromptId = aiPromptId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIPromptVersionProps#getAssistantId}
         * @param assistantId The identifier of the Amazon Q in Connect assistant. This parameter is required.
         *                    Can be either the ID or the ARN. URLs cannot contain the ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assistantId(java.lang.String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        /**
         * Sets the value of {@link CfnAIPromptVersionProps#getModifiedTimeSeconds}
         * @param modifiedTimeSeconds The time the AI Prompt version was last modified in seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modifiedTimeSeconds(java.lang.Number modifiedTimeSeconds) {
            this.modifiedTimeSeconds = modifiedTimeSeconds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAIPromptVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAIPromptVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAIPromptVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAIPromptVersionProps {
        private final java.lang.String aiPromptId;
        private final java.lang.String assistantId;
        private final java.lang.Number modifiedTimeSeconds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.aiPromptId = software.amazon.jsii.Kernel.get(this, "aiPromptId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assistantId = software.amazon.jsii.Kernel.get(this, "assistantId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modifiedTimeSeconds = software.amazon.jsii.Kernel.get(this, "modifiedTimeSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.aiPromptId = java.util.Objects.requireNonNull(builder.aiPromptId, "aiPromptId is required");
            this.assistantId = java.util.Objects.requireNonNull(builder.assistantId, "assistantId is required");
            this.modifiedTimeSeconds = builder.modifiedTimeSeconds;
        }

        @Override
        public final java.lang.String getAiPromptId() {
            return this.aiPromptId;
        }

        @Override
        public final java.lang.String getAssistantId() {
            return this.assistantId;
        }

        @Override
        public final java.lang.Number getModifiedTimeSeconds() {
            return this.modifiedTimeSeconds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("aiPromptId", om.valueToTree(this.getAiPromptId()));
            data.set("assistantId", om.valueToTree(this.getAssistantId()));
            if (this.getModifiedTimeSeconds() != null) {
                data.set("modifiedTimeSeconds", om.valueToTree(this.getModifiedTimeSeconds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnAIPromptVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAIPromptVersionProps.Jsii$Proxy that = (CfnAIPromptVersionProps.Jsii$Proxy) o;

            if (!aiPromptId.equals(that.aiPromptId)) return false;
            if (!assistantId.equals(that.assistantId)) return false;
            return this.modifiedTimeSeconds != null ? this.modifiedTimeSeconds.equals(that.modifiedTimeSeconds) : that.modifiedTimeSeconds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.aiPromptId.hashCode();
            result = 31 * result + (this.assistantId.hashCode());
            result = 31 * result + (this.modifiedTimeSeconds != null ? this.modifiedTimeSeconds.hashCode() : 0);
            return result;
        }
    }
}
