package software.amazon.awscdk.services.wisdom;

/**
 * Properties for defining a <code>CfnKnowledgeBase</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.wisdom.*;
 * CfnKnowledgeBaseProps cfnKnowledgeBaseProps = CfnKnowledgeBaseProps.builder()
 *         .knowledgeBaseType("knowledgeBaseType")
 *         .name("name")
 *         // the properties below are optional
 *         .description("description")
 *         .renderingConfiguration(RenderingConfigurationProperty.builder()
 *                 .templateUri("templateUri")
 *                 .build())
 *         .serverSideEncryptionConfiguration(ServerSideEncryptionConfigurationProperty.builder()
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .sourceConfiguration(SourceConfigurationProperty.builder()
 *                 .appIntegrations(AppIntegrationsConfigurationProperty.builder()
 *                         .appIntegrationArn("appIntegrationArn")
 *                         // the properties below are optional
 *                         .objectFields(List.of("objectFields"))
 *                         .build())
 *                 .managedSourceConfiguration(ManagedSourceConfigurationProperty.builder()
 *                         .webCrawlerConfiguration(WebCrawlerConfigurationProperty.builder()
 *                                 .urlConfiguration(UrlConfigurationProperty.builder()
 *                                         .seedUrls(List.of(SeedUrlProperty.builder()
 *                                                 .url("url")
 *                                                 .build()))
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .crawlerLimits(CrawlerLimitsProperty.builder()
 *                                         .rateLimit(123)
 *                                         .build())
 *                                 .exclusionFilters(List.of("exclusionFilters"))
 *                                 .inclusionFilters(List.of("inclusionFilters"))
 *                                 .scope("scope")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vectorIngestionConfiguration(VectorIngestionConfigurationProperty.builder()
 *                 .chunkingConfiguration(ChunkingConfigurationProperty.builder()
 *                         .chunkingStrategy("chunkingStrategy")
 *                         // the properties below are optional
 *                         .fixedSizeChunkingConfiguration(FixedSizeChunkingConfigurationProperty.builder()
 *                                 .maxTokens(123)
 *                                 .overlapPercentage(123)
 *                                 .build())
 *                         .hierarchicalChunkingConfiguration(HierarchicalChunkingConfigurationProperty.builder()
 *                                 .levelConfigurations(List.of(HierarchicalChunkingLevelConfigurationProperty.builder()
 *                                         .maxTokens(123)
 *                                         .build()))
 *                                 .overlapTokens(123)
 *                                 .build())
 *                         .semanticChunkingConfiguration(SemanticChunkingConfigurationProperty.builder()
 *                                 .breakpointPercentileThreshold(123)
 *                                 .bufferSize(123)
 *                                 .maxTokens(123)
 *                                 .build())
 *                         .build())
 *                 .parsingConfiguration(ParsingConfigurationProperty.builder()
 *                         .parsingStrategy("parsingStrategy")
 *                         // the properties below are optional
 *                         .bedrockFoundationModelConfiguration(BedrockFoundationModelConfigurationProperty.builder()
 *                                 .modelArn("modelArn")
 *                                 // the properties below are optional
 *                                 .parsingPrompt(ParsingPromptProperty.builder()
 *                                         .parsingPromptText("parsingPromptText")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-05-22T23:40:00.870Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wisdom.CfnKnowledgeBaseProps")
@software.amazon.jsii.Jsii.Proxy(CfnKnowledgeBaseProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnKnowledgeBaseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of knowledge base.
     * <p>
     * Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge bases support integrations with third-party systems whose content is synchronized automatically.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-knowledgebasetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-knowledgebasetype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKnowledgeBaseType();

    /**
     * The name of the knowledge base.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The description.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Information about how to render the content.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-renderingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-renderingconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRenderingConfiguration() {
        return null;
    }

    /**
     * This customer managed key must have a policy that allows <code>kms:CreateGrant</code> and <code>kms:DescribeKey</code> permissions to the IAM identity using the key to invoke Wisdom.
     * <p>
     * For more information about setting up a customer managed key for Wisdom, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom for your instance</a> . For information about valid ID values, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-serversideencryptionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-serversideencryptionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getServerSideEncryptionConfiguration() {
        return null;
    }

    /**
     * The source of the knowledge base content.
     * <p>
     * Only set this argument for EXTERNAL or Managed knowledge bases.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-sourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-sourceconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSourceConfiguration() {
        return null;
    }

    /**
     * The tags used to organize, track, or control access for this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * Contains details about how to ingest the documents in a data source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-vectoringestionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wisdom-knowledgebase.html#cfn-wisdom-knowledgebase-vectoringestionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVectorIngestionConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnKnowledgeBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnKnowledgeBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnKnowledgeBaseProps> {
        java.lang.String knowledgeBaseType;
        java.lang.String name;
        java.lang.String description;
        java.lang.Object renderingConfiguration;
        java.lang.Object serverSideEncryptionConfiguration;
        java.lang.Object sourceConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object vectorIngestionConfiguration;

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getKnowledgeBaseType}
         * @param knowledgeBaseType The type of knowledge base. This parameter is required.
         *                          Only CUSTOM knowledge bases allow you to upload your own content. EXTERNAL knowledge bases support integrations with third-party systems whose content is synchronized automatically.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBaseType(java.lang.String knowledgeBaseType) {
            this.knowledgeBaseType = knowledgeBaseType;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getName}
         * @param name The name of the knowledge base. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getDescription}
         * @param description The description.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getRenderingConfiguration}
         * @param renderingConfiguration Information about how to render the content.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder renderingConfiguration(software.amazon.awscdk.IResolvable renderingConfiguration) {
            this.renderingConfiguration = renderingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getRenderingConfiguration}
         * @param renderingConfiguration Information about how to render the content.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder renderingConfiguration(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.RenderingConfigurationProperty renderingConfiguration) {
            this.renderingConfiguration = renderingConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getServerSideEncryptionConfiguration}
         * @param serverSideEncryptionConfiguration This customer managed key must have a policy that allows <code>kms:CreateGrant</code> and <code>kms:DescribeKey</code> permissions to the IAM identity using the key to invoke Wisdom.
         *                                          For more information about setting up a customer managed key for Wisdom, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom for your instance</a> . For information about valid ID values, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionConfiguration(software.amazon.awscdk.IResolvable serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getServerSideEncryptionConfiguration}
         * @param serverSideEncryptionConfiguration This customer managed key must have a policy that allows <code>kms:CreateGrant</code> and <code>kms:DescribeKey</code> permissions to the IAM identity using the key to invoke Wisdom.
         *                                          For more information about setting up a customer managed key for Wisdom, see <a href="https://docs.aws.amazon.com/connect/latest/adminguide/enable-wisdom.html">Enable Amazon Connect Wisdom for your instance</a> . For information about valid ID values, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId)</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideEncryptionConfiguration(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.ServerSideEncryptionConfigurationProperty serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getSourceConfiguration}
         * @param sourceConfiguration The source of the knowledge base content.
         *                            Only set this argument for EXTERNAL or Managed knowledge bases.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceConfiguration(software.amazon.awscdk.IResolvable sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getSourceConfiguration}
         * @param sourceConfiguration The source of the knowledge base content.
         *                            Only set this argument for EXTERNAL or Managed knowledge bases.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceConfiguration(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.SourceConfigurationProperty sourceConfiguration) {
            this.sourceConfiguration = sourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getTags}
         * @param tags The tags used to organize, track, or control access for this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getVectorIngestionConfiguration}
         * @param vectorIngestionConfiguration Contains details about how to ingest the documents in a data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorIngestionConfiguration(software.amazon.awscdk.IResolvable vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnKnowledgeBaseProps#getVectorIngestionConfiguration}
         * @param vectorIngestionConfiguration Contains details about how to ingest the documents in a data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vectorIngestionConfiguration(software.amazon.awscdk.services.wisdom.CfnKnowledgeBase.VectorIngestionConfigurationProperty vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnKnowledgeBaseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnKnowledgeBaseProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnKnowledgeBaseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnKnowledgeBaseProps {
        private final java.lang.String knowledgeBaseType;
        private final java.lang.String name;
        private final java.lang.String description;
        private final java.lang.Object renderingConfiguration;
        private final java.lang.Object serverSideEncryptionConfiguration;
        private final java.lang.Object sourceConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object vectorIngestionConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.knowledgeBaseType = software.amazon.jsii.Kernel.get(this, "knowledgeBaseType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.renderingConfiguration = software.amazon.jsii.Kernel.get(this, "renderingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serverSideEncryptionConfiguration = software.amazon.jsii.Kernel.get(this, "serverSideEncryptionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceConfiguration = software.amazon.jsii.Kernel.get(this, "sourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.vectorIngestionConfiguration = software.amazon.jsii.Kernel.get(this, "vectorIngestionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.knowledgeBaseType = java.util.Objects.requireNonNull(builder.knowledgeBaseType, "knowledgeBaseType is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.description = builder.description;
            this.renderingConfiguration = builder.renderingConfiguration;
            this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
            this.sourceConfiguration = builder.sourceConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.vectorIngestionConfiguration = builder.vectorIngestionConfiguration;
        }

        @Override
        public final java.lang.String getKnowledgeBaseType() {
            return this.knowledgeBaseType;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getRenderingConfiguration() {
            return this.renderingConfiguration;
        }

        @Override
        public final java.lang.Object getServerSideEncryptionConfiguration() {
            return this.serverSideEncryptionConfiguration;
        }

        @Override
        public final java.lang.Object getSourceConfiguration() {
            return this.sourceConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getVectorIngestionConfiguration() {
            return this.vectorIngestionConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("knowledgeBaseType", om.valueToTree(this.getKnowledgeBaseType()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getRenderingConfiguration() != null) {
                data.set("renderingConfiguration", om.valueToTree(this.getRenderingConfiguration()));
            }
            if (this.getServerSideEncryptionConfiguration() != null) {
                data.set("serverSideEncryptionConfiguration", om.valueToTree(this.getServerSideEncryptionConfiguration()));
            }
            if (this.getSourceConfiguration() != null) {
                data.set("sourceConfiguration", om.valueToTree(this.getSourceConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVectorIngestionConfiguration() != null) {
                data.set("vectorIngestionConfiguration", om.valueToTree(this.getVectorIngestionConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wisdom.CfnKnowledgeBaseProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnKnowledgeBaseProps.Jsii$Proxy that = (CfnKnowledgeBaseProps.Jsii$Proxy) o;

            if (!knowledgeBaseType.equals(that.knowledgeBaseType)) return false;
            if (!name.equals(that.name)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.renderingConfiguration != null ? !this.renderingConfiguration.equals(that.renderingConfiguration) : that.renderingConfiguration != null) return false;
            if (this.serverSideEncryptionConfiguration != null ? !this.serverSideEncryptionConfiguration.equals(that.serverSideEncryptionConfiguration) : that.serverSideEncryptionConfiguration != null) return false;
            if (this.sourceConfiguration != null ? !this.sourceConfiguration.equals(that.sourceConfiguration) : that.sourceConfiguration != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vectorIngestionConfiguration != null ? this.vectorIngestionConfiguration.equals(that.vectorIngestionConfiguration) : that.vectorIngestionConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.knowledgeBaseType.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.renderingConfiguration != null ? this.renderingConfiguration.hashCode() : 0);
            result = 31 * result + (this.serverSideEncryptionConfiguration != null ? this.serverSideEncryptionConfiguration.hashCode() : 0);
            result = 31 * result + (this.sourceConfiguration != null ? this.sourceConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vectorIngestionConfiguration != null ? this.vectorIngestionConfiguration.hashCode() : 0);
            return result;
        }
    }
}
