/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.batch;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.batch.DnsPolicy;
import software.amazon.awscdk.services.batch.EksContainerDefinition;
import software.amazon.awscdk.services.batch.EksJobDefinitionProps;
import software.amazon.awscdk.services.batch.IEksJobDefinition;
import software.amazon.awscdk.services.batch.IJobDefinition;
import software.amazon.awscdk.services.batch.RetryStrategy;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.EksJobDefinition")
public class EksJobDefinition
extends Resource
implements IEksJobDefinition,
IJobDefinition {
    public static final String PROPERTY_INJECTION_ID = (String)JsiiObject.jsiiStaticGet(EksJobDefinition.class, (String)"PROPERTY_INJECTION_ID", (NativeType)NativeType.forClass(String.class));

    protected EksJobDefinition(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EksJobDefinition(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public EksJobDefinition(@NotNull Construct scope, @NotNull String id, @NotNull EksJobDefinitionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IEksJobDefinition fromEksJobDefinitionArn(@NotNull Construct scope, @NotNull String id, @NotNull String eksJobDefinitionArn) {
        return (IEksJobDefinition)JsiiObject.jsiiStaticCall(EksJobDefinition.class, (String)"fromEksJobDefinitionArn", (NativeType)NativeType.forClass(IEksJobDefinition.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(eksJobDefinitionArn, "eksJobDefinitionArn is required")});
    }

    @Override
    public void addRetryStrategy(@NotNull RetryStrategy strategy) {
        Kernel.call((Object)this, (String)"addRetryStrategy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(strategy, "strategy is required")});
    }

    @Override
    @NotNull
    public EksContainerDefinition getContainer() {
        return (EksContainerDefinition)Kernel.get((Object)this, (String)"container", (NativeType)NativeType.forClass(EksContainerDefinition.class));
    }

    @Override
    @NotNull
    public String getJobDefinitionArn() {
        return (String)Kernel.get((Object)this, (String)"jobDefinitionArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getJobDefinitionName() {
        return (String)Kernel.get((Object)this, (String)"jobDefinitionName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public List<RetryStrategy> getRetryStrategies() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"retryStrategies", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(RetryStrategy.class))));
    }

    @Override
    @Nullable
    public DnsPolicy getDnsPolicy() {
        return (DnsPolicy)((Object)Kernel.get((Object)this, (String)"dnsPolicy", (NativeType)NativeType.forClass(DnsPolicy.class)));
    }

    @Override
    @Nullable
    public Map<String, Object> getParameters() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"parameters", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    @Override
    @Nullable
    public Number getRetryAttempts() {
        return (Number)Kernel.get((Object)this, (String)"retryAttempts", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public Number getSchedulingPriority() {
        return (Number)Kernel.get((Object)this, (String)"schedulingPriority", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public String getServiceAccount() {
        return (String)Kernel.get((Object)this, (String)"serviceAccount", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @Nullable
    public Duration getTimeout() {
        return (Duration)((Object)Kernel.get((Object)this, (String)"timeout", (NativeType)NativeType.forClass(Duration.class)));
    }

    @Override
    @Nullable
    public Boolean getUseHostNetwork() {
        return (Boolean)Kernel.get((Object)this, (String)"useHostNetwork", (NativeType)NativeType.forClass(Boolean.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<EksJobDefinition> {
        private final Construct scope;
        private final String id;
        private final EksJobDefinitionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new EksJobDefinitionProps.Builder();
        }

        public Builder jobDefinitionName(String jobDefinitionName) {
            this.props.jobDefinitionName(jobDefinitionName);
            return this;
        }

        public Builder parameters(Map<String, ? extends Object> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        public Builder retryStrategies(List<? extends RetryStrategy> retryStrategies) {
            this.props.retryStrategies(retryStrategies);
            return this;
        }

        public Builder schedulingPriority(Number schedulingPriority) {
            this.props.schedulingPriority(schedulingPriority);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder container(EksContainerDefinition container) {
            this.props.container(container);
            return this;
        }

        public Builder dnsPolicy(DnsPolicy dnsPolicy) {
            this.props.dnsPolicy(dnsPolicy);
            return this;
        }

        public Builder serviceAccount(String serviceAccount) {
            this.props.serviceAccount(serviceAccount);
            return this;
        }

        public Builder useHostNetwork(Boolean useHostNetwork) {
            this.props.useHostNetwork(useHostNetwork);
            return this;
        }

        public EksJobDefinition build() {
            return new EksJobDefinition(this.scope, this.id, this.props.build());
        }
    }
}

