/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.cloudwatch;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.cloudwatch.DashboardProps;
import software.amazon.awscdk.services.cloudwatch.IVariable;
import software.amazon.awscdk.services.cloudwatch.IWidget;
import software.amazon.awscdk.services.cloudwatch.PeriodOverride;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_cloudwatch.Dashboard")
public class Dashboard
extends Resource {
    public static final String PROPERTY_INJECTION_ID = (String)JsiiObject.jsiiStaticGet(Dashboard.class, (String)"PROPERTY_INJECTION_ID", (NativeType)NativeType.forClass(String.class));

    protected Dashboard(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Dashboard(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Dashboard(@NotNull Construct scope, @NotNull String id, @Nullable DashboardProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public Dashboard(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void addVariable(@NotNull IVariable variable) {
        Kernel.call((Object)this, (String)"addVariable", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(variable, "variable is required")});
    }

    public void addWidgets(IWidget ... widgets) {
        Kernel.call((Object)this, (String)"addWidgets", (NativeType)NativeType.VOID, (Object[])Arrays.stream(widgets).toArray(Object[]::new));
    }

    @NotNull
    public String getDashboardArn() {
        return (String)Kernel.get((Object)this, (String)"dashboardArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getDashboardName() {
        return (String)Kernel.get((Object)this, (String)"dashboardName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Dashboard> {
        private final Construct scope;
        private final String id;
        private DashboardProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder dashboardName(String dashboardName) {
            this.props().dashboardName(dashboardName);
            return this;
        }

        public Builder defaultInterval(Duration defaultInterval) {
            this.props().defaultInterval(defaultInterval);
            return this;
        }

        public Builder end(String end) {
            this.props().end(end);
            return this;
        }

        public Builder periodOverride(PeriodOverride periodOverride) {
            this.props().periodOverride(periodOverride);
            return this;
        }

        public Builder start(String start) {
            this.props().start(start);
            return this;
        }

        public Builder variables(List<? extends IVariable> variables) {
            this.props().variables(variables);
            return this;
        }

        public Builder widgets(List<? extends List<? extends IWidget>> widgets) {
            this.props().widgets(widgets);
            return this;
        }

        public Dashboard build() {
            return new Dashboard(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private DashboardProps.Builder props() {
            if (this.props == null) {
                this.props = new DashboardProps.Builder();
            }
            return this.props;
        }
    }
}

