/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.config;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.config.CfnConfigRule;
import software.amazon.awscdk.services.config.CfnConfigRuleProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_config.CfnConfigRule")
public class CfnConfigRule
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnConfigRule.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnConfigRule(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigRule(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnConfigRule(@NotNull Construct scope, @NotNull String id, @NotNull CfnConfigRuleProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrComplianceType() {
        return (String)Kernel.get((Object)this, (String)"attrComplianceType", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrConfigRuleId() {
        return (String)Kernel.get((Object)this, (String)"attrConfigRuleId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getSource() {
        return Kernel.get((Object)this, (String)"source", (NativeType)NativeType.forClass(Object.class));
    }

    public void setSource(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"source", (Object)Objects.requireNonNull(value, "source is required"));
    }

    public void setSource(@NotNull SourceProperty value) {
        Kernel.set((Object)this, (String)"source", (Object)Objects.requireNonNull(value, "source is required"));
    }

    @Nullable
    public Object getCompliance() {
        return Kernel.get((Object)this, (String)"compliance", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCompliance(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"compliance", (Object)value);
    }

    public void setCompliance(@Nullable ComplianceProperty value) {
        Kernel.set((Object)this, (String)"compliance", (Object)value);
    }

    @Nullable
    public String getConfigRuleName() {
        return (String)Kernel.get((Object)this, (String)"configRuleName", (NativeType)NativeType.forClass(String.class));
    }

    public void setConfigRuleName(@Nullable String value) {
        Kernel.set((Object)this, (String)"configRuleName", (Object)value);
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Object getEvaluationModes() {
        return Kernel.get((Object)this, (String)"evaluationModes", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEvaluationModes(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"evaluationModes", (Object)value);
    }

    public void setEvaluationModes(@Nullable List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof EvaluationModeConfigurationProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.config.CfnConfigRule.EvaluationModeConfigurationProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"evaluationModes", value);
    }

    @Nullable
    public Object getInputParameters() {
        return Kernel.get((Object)this, (String)"inputParameters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setInputParameters(@Nullable Object value) {
        Kernel.set((Object)this, (String)"inputParameters", (Object)value);
    }

    @Nullable
    public String getMaximumExecutionFrequency() {
        return (String)Kernel.get((Object)this, (String)"maximumExecutionFrequency", (NativeType)NativeType.forClass(String.class));
    }

    public void setMaximumExecutionFrequency(@Nullable String value) {
        Kernel.set((Object)this, (String)"maximumExecutionFrequency", (Object)value);
    }

    @Nullable
    public Object getScope() {
        return Kernel.get((Object)this, (String)"scope", (NativeType)NativeType.forClass(Object.class));
    }

    public void setScope(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"scope", (Object)value);
    }

    public void setScope(@Nullable ScopeProperty value) {
        Kernel.set((Object)this, (String)"scope", (Object)value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_config.CfnConfigRule.EvaluationModeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EvaluationModeConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMode() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EvaluationModeConfigurationProperty> {
            String mode;

            public Builder mode(String mode) {
                this.mode = mode;
                return this;
            }

            public EvaluationModeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnConfigRule> {
        private final Construct scope;
        private final String id;
        private final CfnConfigRuleProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnConfigRuleProps.Builder();
        }

        public Builder source(IResolvable source) {
            this.props.source(source);
            return this;
        }

        public Builder source(SourceProperty source) {
            this.props.source(source);
            return this;
        }

        public Builder compliance(IResolvable compliance) {
            this.props.compliance(compliance);
            return this;
        }

        public Builder compliance(ComplianceProperty compliance) {
            this.props.compliance(compliance);
            return this;
        }

        public Builder configRuleName(String configRuleName) {
            this.props.configRuleName(configRuleName);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder evaluationModes(IResolvable evaluationModes) {
            this.props.evaluationModes(evaluationModes);
            return this;
        }

        public Builder evaluationModes(List<? extends Object> evaluationModes) {
            this.props.evaluationModes(evaluationModes);
            return this;
        }

        public Builder inputParameters(Object inputParameters) {
            this.props.inputParameters(inputParameters);
            return this;
        }

        public Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
            this.props.maximumExecutionFrequency(maximumExecutionFrequency);
            return this;
        }

        public Builder scope(IResolvable scope) {
            this.props.scope(scope);
            return this;
        }

        public Builder scope(ScopeProperty scope) {
            this.props.scope(scope);
            return this;
        }

        public CfnConfigRule build() {
            return new CfnConfigRule(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_config.CfnConfigRule.SourceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceProperty
    extends JsiiSerializable {
        @NotNull
        public String getOwner();

        @Nullable
        default public Object getCustomPolicyDetails() {
            return null;
        }

        @Nullable
        default public Object getSourceDetails() {
            return null;
        }

        @Nullable
        default public String getSourceIdentifier() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourceProperty> {
            String owner;
            Object customPolicyDetails;
            Object sourceDetails;
            String sourceIdentifier;

            public Builder owner(String owner) {
                this.owner = owner;
                return this;
            }

            public Builder customPolicyDetails(IResolvable customPolicyDetails) {
                this.customPolicyDetails = customPolicyDetails;
                return this;
            }

            public Builder customPolicyDetails(CustomPolicyDetailsProperty customPolicyDetails) {
                this.customPolicyDetails = customPolicyDetails;
                return this;
            }

            public Builder sourceDetails(IResolvable sourceDetails) {
                this.sourceDetails = sourceDetails;
                return this;
            }

            public Builder sourceDetails(List<? extends Object> sourceDetails) {
                this.sourceDetails = sourceDetails;
                return this;
            }

            public Builder sourceIdentifier(String sourceIdentifier) {
                this.sourceIdentifier = sourceIdentifier;
                return this;
            }

            public SourceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_config.CfnConfigRule.SourceDetailProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SourceDetailProperty
    extends JsiiSerializable {
        @NotNull
        public String getEventSource();

        @NotNull
        public String getMessageType();

        @Nullable
        default public String getMaximumExecutionFrequency() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SourceDetailProperty> {
            String eventSource;
            String messageType;
            String maximumExecutionFrequency;

            public Builder eventSource(String eventSource) {
                this.eventSource = eventSource;
                return this;
            }

            public Builder messageType(String messageType) {
                this.messageType = messageType;
                return this;
            }

            public Builder maximumExecutionFrequency(String maximumExecutionFrequency) {
                this.maximumExecutionFrequency = maximumExecutionFrequency;
                return this;
            }

            public SourceDetailProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_config.CfnConfigRule.ScopeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScopeProperty
    extends JsiiSerializable {
        @Nullable
        default public String getComplianceResourceId() {
            return null;
        }

        @Nullable
        default public List<String> getComplianceResourceTypes() {
            return null;
        }

        @Nullable
        default public String getTagKey() {
            return null;
        }

        @Nullable
        default public String getTagValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScopeProperty> {
            String complianceResourceId;
            List<String> complianceResourceTypes;
            String tagKey;
            String tagValue;

            public Builder complianceResourceId(String complianceResourceId) {
                this.complianceResourceId = complianceResourceId;
                return this;
            }

            public Builder complianceResourceTypes(List<String> complianceResourceTypes) {
                this.complianceResourceTypes = complianceResourceTypes;
                return this;
            }

            public Builder tagKey(String tagKey) {
                this.tagKey = tagKey;
                return this;
            }

            public Builder tagValue(String tagValue) {
                this.tagValue = tagValue;
                return this;
            }

            public ScopeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_config.CfnConfigRule.CustomPolicyDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomPolicyDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEnableDebugLogDelivery() {
            return null;
        }

        @Nullable
        default public String getPolicyRuntime() {
            return null;
        }

        @Nullable
        default public String getPolicyText() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomPolicyDetailsProperty> {
            Object enableDebugLogDelivery;
            String policyRuntime;
            String policyText;

            public Builder enableDebugLogDelivery(Boolean enableDebugLogDelivery) {
                this.enableDebugLogDelivery = enableDebugLogDelivery;
                return this;
            }

            public Builder enableDebugLogDelivery(IResolvable enableDebugLogDelivery) {
                this.enableDebugLogDelivery = enableDebugLogDelivery;
                return this;
            }

            public Builder policyRuntime(String policyRuntime) {
                this.policyRuntime = policyRuntime;
                return this;
            }

            public Builder policyText(String policyText) {
                this.policyText = policyText;
                return this;
            }

            public CustomPolicyDetailsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_config.CfnConfigRule.ComplianceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ComplianceProperty
    extends JsiiSerializable {
        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ComplianceProperty> {
            String type;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public ComplianceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

