/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.ResourceProps;
import software.amazon.awscdk.services.cloudwatch.IMetric;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.dynamodb.ITable;
import software.amazon.awscdk.services.dynamodb.OperationsMetricOptions;
import software.amazon.awscdk.services.dynamodb.SystemErrorsForOperationsMetricOptions;
import software.amazon.awscdk.services.iam.AddToResourcePolicyResult;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.IResourceWithPolicy;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dynamodb.TableBase")
public abstract class TableBase
extends Resource
implements ITable,
IResourceWithPolicy {
    protected TableBase(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TableBase(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected TableBase(@NotNull Construct scope, @NotNull String id, @Nullable ResourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    protected TableBase(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public AddToResourcePolicyResult addToResourcePolicy(@NotNull PolicyStatement statement) {
        return (AddToResourcePolicyResult)Kernel.call((Object)this, (String)"addToResourcePolicy", (NativeType)NativeType.forClass(AddToResourcePolicyResult.class), (Object[])new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @Override
    @NotNull
    public Grant grantFullAccess(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantFullAccess", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantReadData(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantReadData", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantReadWriteData(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantReadWriteData", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantStream(@NotNull IGrantable grantee, String ... actions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantStream", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @Override
    @NotNull
    public Grant grantStreamRead(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantStreamRead", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantTableListStreams(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantTableListStreams", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantWriteData(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantWriteData", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @Override
    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)Kernel.call((Object)this, (String)"metric", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @Override
    @NotNull
    public Metric metricConditionalCheckFailedRequests(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricConditionalCheckFailedRequests", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricConditionalCheckFailedRequests() {
        return (Metric)Kernel.call((Object)this, (String)"metricConditionalCheckFailedRequests", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricConsumedReadCapacityUnits(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricConsumedReadCapacityUnits", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricConsumedReadCapacityUnits() {
        return (Metric)Kernel.call((Object)this, (String)"metricConsumedReadCapacityUnits", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricConsumedWriteCapacityUnits(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricConsumedWriteCapacityUnits", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricConsumedWriteCapacityUnits() {
        return (Metric)Kernel.call((Object)this, (String)"metricConsumedWriteCapacityUnits", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricSuccessfulRequestLatency(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricSuccessfulRequestLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricSuccessfulRequestLatency() {
        return (Metric)Kernel.call((Object)this, (String)"metricSuccessfulRequestLatency", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Deprecated
    @NotNull
    public Metric metricSystemErrors(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricSystemErrors", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Deprecated
    @NotNull
    public Metric metricSystemErrors() {
        return (Metric)Kernel.call((Object)this, (String)"metricSystemErrors", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public IMetric metricSystemErrorsForOperations(@Nullable SystemErrorsForOperationsMetricOptions props) {
        return (IMetric)Kernel.call((Object)this, (String)"metricSystemErrorsForOperations", (NativeType)NativeType.forClass(IMetric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public IMetric metricSystemErrorsForOperations() {
        return (IMetric)Kernel.call((Object)this, (String)"metricSystemErrorsForOperations", (NativeType)NativeType.forClass(IMetric.class), (Object[])new Object[0]);
    }

    @Override
    @Deprecated
    @NotNull
    public Metric metricThrottledRequests(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricThrottledRequests", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @Deprecated
    @NotNull
    public Metric metricThrottledRequests() {
        return (Metric)Kernel.call((Object)this, (String)"metricThrottledRequests", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    public Metric metricThrottledRequestsForOperation(@NotNull String operation, @Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricThrottledRequestsForOperation", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(operation, "operation is required"), props});
    }

    @NotNull
    public Metric metricThrottledRequestsForOperation(@NotNull String operation) {
        return (Metric)Kernel.call((Object)this, (String)"metricThrottledRequestsForOperation", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{Objects.requireNonNull(operation, "operation is required")});
    }

    @Override
    @NotNull
    public IMetric metricThrottledRequestsForOperations(@Nullable OperationsMetricOptions props) {
        return (IMetric)Kernel.call((Object)this, (String)"metricThrottledRequestsForOperations", (NativeType)NativeType.forClass(IMetric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public IMetric metricThrottledRequestsForOperations() {
        return (IMetric)Kernel.call((Object)this, (String)"metricThrottledRequestsForOperations", (NativeType)NativeType.forClass(IMetric.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public Metric metricUserErrors(@Nullable MetricOptions props) {
        return (Metric)Kernel.call((Object)this, (String)"metricUserErrors", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[]{props});
    }

    @Override
    @NotNull
    public Metric metricUserErrors() {
        return (Metric)Kernel.call((Object)this, (String)"metricUserErrors", (NativeType)NativeType.forClass(Metric.class), (Object[])new Object[0]);
    }

    @NotNull
    protected abstract Boolean getHasIndex();

    @NotNull
    protected List<String> getRegionalArns() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"regionalArns", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class))));
    }

    @Override
    @NotNull
    public abstract String getTableArn();

    @Override
    @NotNull
    public abstract String getTableName();

    @Override
    @Nullable
    public abstract IKey getEncryptionKey();

    @Override
    @Nullable
    public abstract String getTableStreamArn();

    @Nullable
    public abstract PolicyDocument getResourcePolicy();

    public abstract void setResourcePolicy(@Nullable PolicyDocument var1);
}

