/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ecs;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.services.ecs.AppProtocol;
import software.amazon.awscdk.services.ecs.NetworkMode;
import software.amazon.awscdk.services.ecs.PortMapping;
import software.amazon.awscdk.services.ecs.Protocol;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ecs.PortMap")
public class PortMap
extends JsiiObject {
    protected PortMap(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected PortMap(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public PortMap(@NotNull NetworkMode networkmode, @NotNull PortMapping pm) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(networkmode, "networkmode is required"), Objects.requireNonNull(pm, "pm is required")});
    }

    public void validate() {
        Kernel.call((Object)((Object)this), (String)"validate", (NativeType)NativeType.VOID, (Object[])new Object[0]);
    }

    @NotNull
    public NetworkMode getNetworkmode() {
        return (NetworkMode)((Object)Kernel.get((Object)((Object)this), (String)"networkmode", (NativeType)NativeType.forClass(NetworkMode.class)));
    }

    @NotNull
    public PortMapping getPortmapping() {
        return (PortMapping)Kernel.get((Object)((Object)this), (String)"portmapping", (NativeType)NativeType.forClass(PortMapping.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<PortMap> {
        private final NetworkMode networkmode;
        private final PortMapping.Builder pm;

        public static Builder create(NetworkMode networkmode) {
            return new Builder(networkmode);
        }

        private Builder(NetworkMode networkmode) {
            this.networkmode = networkmode;
            this.pm = new PortMapping.Builder();
        }

        public Builder containerPort(Number containerPort) {
            this.pm.containerPort(containerPort);
            return this;
        }

        public Builder appProtocol(AppProtocol appProtocol) {
            this.pm.appProtocol(appProtocol);
            return this;
        }

        public Builder containerPortRange(String containerPortRange) {
            this.pm.containerPortRange(containerPortRange);
            return this;
        }

        public Builder hostPort(Number hostPort) {
            this.pm.hostPort(hostPort);
            return this;
        }

        public Builder name(String name) {
            this.pm.name(name);
            return this;
        }

        public Builder protocol(Protocol protocol) {
            this.pm.protocol(protocol);
            return this;
        }

        public PortMap build() {
            return new PortMap(this.networkmode, this.pm.build());
        }
    }
}

