/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.glue;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.glue.CfnConnection;
import software.amazon.awscdk.services.glue.CfnConnectionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnConnection")
public class CfnConnection
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnConnection.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnConnection(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConnection(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnConnection(@NotNull Construct scope, @NotNull String id, @NotNull CfnConnectionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrId() {
        return (String)Kernel.get((Object)this, (String)"attrId", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public String getCatalogId() {
        return (String)Kernel.get((Object)this, (String)"catalogId", (NativeType)NativeType.forClass(String.class));
    }

    public void setCatalogId(@NotNull String value) {
        Kernel.set((Object)this, (String)"catalogId", (Object)Objects.requireNonNull(value, "catalogId is required"));
    }

    @NotNull
    public Object getConnectionInput() {
        return Kernel.get((Object)this, (String)"connectionInput", (NativeType)NativeType.forClass(Object.class));
    }

    public void setConnectionInput(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"connectionInput", (Object)Objects.requireNonNull(value, "connectionInput is required"));
    }

    public void setConnectionInput(@NotNull ConnectionInputProperty value) {
        Kernel.set((Object)this, (String)"connectionInput", (Object)Objects.requireNonNull(value, "connectionInput is required"));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnConnection> {
        private final Construct scope;
        private final String id;
        private final CfnConnectionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnConnectionProps.Builder();
        }

        public Builder catalogId(String catalogId) {
            this.props.catalogId(catalogId);
            return this;
        }

        public Builder connectionInput(IResolvable connectionInput) {
            this.props.connectionInput(connectionInput);
            return this;
        }

        public Builder connectionInput(ConnectionInputProperty connectionInput) {
            this.props.connectionInput(connectionInput);
            return this;
        }

        public CfnConnection build() {
            return new CfnConnection(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnConnection.PhysicalConnectionRequirementsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PhysicalConnectionRequirementsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAvailabilityZone() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroupIdList() {
            return null;
        }

        @Nullable
        default public String getSubnetId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PhysicalConnectionRequirementsProperty> {
            String availabilityZone;
            List<String> securityGroupIdList;
            String subnetId;

            public Builder availabilityZone(String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            public Builder securityGroupIdList(List<String> securityGroupIdList) {
                this.securityGroupIdList = securityGroupIdList;
                return this;
            }

            public Builder subnetId(String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            public PhysicalConnectionRequirementsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnConnection.OAuth2PropertiesInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OAuth2PropertiesInputProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAuthorizationCodeProperties() {
            return null;
        }

        @Nullable
        default public Object getOAuth2ClientApplication() {
            return null;
        }

        @Nullable
        default public Object getOAuth2Credentials() {
            return null;
        }

        @Nullable
        default public String getOAuth2GrantType() {
            return null;
        }

        @Nullable
        default public String getTokenUrl() {
            return null;
        }

        @Nullable
        default public Object getTokenUrlParametersMap() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OAuth2PropertiesInputProperty> {
            Object authorizationCodeProperties;
            Object oAuth2ClientApplication;
            Object oAuth2Credentials;
            String oAuth2GrantType;
            String tokenUrl;
            Object tokenUrlParametersMap;

            public Builder authorizationCodeProperties(IResolvable authorizationCodeProperties) {
                this.authorizationCodeProperties = authorizationCodeProperties;
                return this;
            }

            public Builder authorizationCodeProperties(AuthorizationCodePropertiesProperty authorizationCodeProperties) {
                this.authorizationCodeProperties = authorizationCodeProperties;
                return this;
            }

            public Builder oAuth2ClientApplication(IResolvable oAuth2ClientApplication) {
                this.oAuth2ClientApplication = oAuth2ClientApplication;
                return this;
            }

            public Builder oAuth2ClientApplication(OAuth2ClientApplicationProperty oAuth2ClientApplication) {
                this.oAuth2ClientApplication = oAuth2ClientApplication;
                return this;
            }

            public Builder oAuth2Credentials(IResolvable oAuth2Credentials) {
                this.oAuth2Credentials = oAuth2Credentials;
                return this;
            }

            public Builder oAuth2Credentials(OAuth2CredentialsProperty oAuth2Credentials) {
                this.oAuth2Credentials = oAuth2Credentials;
                return this;
            }

            public Builder oAuth2GrantType(String oAuth2GrantType) {
                this.oAuth2GrantType = oAuth2GrantType;
                return this;
            }

            public Builder tokenUrl(String tokenUrl) {
                this.tokenUrl = tokenUrl;
                return this;
            }

            public Builder tokenUrlParametersMap(Object tokenUrlParametersMap) {
                this.tokenUrlParametersMap = tokenUrlParametersMap;
                return this;
            }

            public OAuth2PropertiesInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnConnection.OAuth2CredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OAuth2CredentialsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAccessToken() {
            return null;
        }

        @Nullable
        default public String getJwtToken() {
            return null;
        }

        @Nullable
        default public String getRefreshToken() {
            return null;
        }

        @Nullable
        default public String getUserManagedClientApplicationClientSecret() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OAuth2CredentialsProperty> {
            String accessToken;
            String jwtToken;
            String refreshToken;
            String userManagedClientApplicationClientSecret;

            public Builder accessToken(String accessToken) {
                this.accessToken = accessToken;
                return this;
            }

            public Builder jwtToken(String jwtToken) {
                this.jwtToken = jwtToken;
                return this;
            }

            public Builder refreshToken(String refreshToken) {
                this.refreshToken = refreshToken;
                return this;
            }

            public Builder userManagedClientApplicationClientSecret(String userManagedClientApplicationClientSecret) {
                this.userManagedClientApplicationClientSecret = userManagedClientApplicationClientSecret;
                return this;
            }

            public OAuth2CredentialsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnConnection.OAuth2ClientApplicationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface OAuth2ClientApplicationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAwsManagedClientApplicationReference() {
            return null;
        }

        @Nullable
        default public String getUserManagedClientApplicationClientId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<OAuth2ClientApplicationProperty> {
            String awsManagedClientApplicationReference;
            String userManagedClientApplicationClientId;

            public Builder awsManagedClientApplicationReference(String awsManagedClientApplicationReference) {
                this.awsManagedClientApplicationReference = awsManagedClientApplicationReference;
                return this;
            }

            public Builder userManagedClientApplicationClientId(String userManagedClientApplicationClientId) {
                this.userManagedClientApplicationClientId = userManagedClientApplicationClientId;
                return this;
            }

            public OAuth2ClientApplicationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnConnection.ConnectionInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConnectionInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getConnectionType();

        @Nullable
        default public Object getAthenaProperties() {
            return null;
        }

        @Nullable
        default public Object getAuthenticationConfiguration() {
            return null;
        }

        @Nullable
        default public Object getConnectionProperties() {
            return null;
        }

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public List<String> getMatchCriteria() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getPhysicalConnectionRequirements() {
            return null;
        }

        @Nullable
        default public Object getPythonProperties() {
            return null;
        }

        @Nullable
        default public Object getSparkProperties() {
            return null;
        }

        @Nullable
        default public Object getValidateCredentials() {
            return null;
        }

        @Nullable
        default public List<String> getValidateForComputeEnvironments() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConnectionInputProperty> {
            String connectionType;
            Object athenaProperties;
            Object authenticationConfiguration;
            Object connectionProperties;
            String description;
            List<String> matchCriteria;
            String name;
            Object physicalConnectionRequirements;
            Object pythonProperties;
            Object sparkProperties;
            Object validateCredentials;
            List<String> validateForComputeEnvironments;

            public Builder connectionType(String connectionType) {
                this.connectionType = connectionType;
                return this;
            }

            public Builder athenaProperties(Object athenaProperties) {
                this.athenaProperties = athenaProperties;
                return this;
            }

            public Builder authenticationConfiguration(IResolvable authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            public Builder authenticationConfiguration(AuthenticationConfigurationInputProperty authenticationConfiguration) {
                this.authenticationConfiguration = authenticationConfiguration;
                return this;
            }

            public Builder connectionProperties(Object connectionProperties) {
                this.connectionProperties = connectionProperties;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder matchCriteria(List<String> matchCriteria) {
                this.matchCriteria = matchCriteria;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder physicalConnectionRequirements(IResolvable physicalConnectionRequirements) {
                this.physicalConnectionRequirements = physicalConnectionRequirements;
                return this;
            }

            public Builder physicalConnectionRequirements(PhysicalConnectionRequirementsProperty physicalConnectionRequirements) {
                this.physicalConnectionRequirements = physicalConnectionRequirements;
                return this;
            }

            public Builder pythonProperties(Object pythonProperties) {
                this.pythonProperties = pythonProperties;
                return this;
            }

            public Builder sparkProperties(Object sparkProperties) {
                this.sparkProperties = sparkProperties;
                return this;
            }

            public Builder validateCredentials(Boolean validateCredentials) {
                this.validateCredentials = validateCredentials;
                return this;
            }

            public Builder validateCredentials(IResolvable validateCredentials) {
                this.validateCredentials = validateCredentials;
                return this;
            }

            public Builder validateForComputeEnvironments(List<String> validateForComputeEnvironments) {
                this.validateForComputeEnvironments = validateForComputeEnvironments;
                return this;
            }

            public ConnectionInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnConnection.BasicAuthenticationCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface BasicAuthenticationCredentialsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPassword() {
            return null;
        }

        @Nullable
        default public String getUsername() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<BasicAuthenticationCredentialsProperty> {
            String password;
            String username;

            public Builder password(String password) {
                this.password = password;
                return this;
            }

            public Builder username(String username) {
                this.username = username;
                return this;
            }

            public BasicAuthenticationCredentialsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnConnection.AuthorizationCodePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthorizationCodePropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAuthorizationCode() {
            return null;
        }

        @Nullable
        default public String getRedirectUri() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthorizationCodePropertiesProperty> {
            String authorizationCode;
            String redirectUri;

            public Builder authorizationCode(String authorizationCode) {
                this.authorizationCode = authorizationCode;
                return this;
            }

            public Builder redirectUri(String redirectUri) {
                this.redirectUri = redirectUri;
                return this;
            }

            public AuthorizationCodePropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_glue.CfnConnection.AuthenticationConfigurationInputProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthenticationConfigurationInputProperty
    extends JsiiSerializable {
        @NotNull
        public String getAuthenticationType();

        @Nullable
        default public Object getBasicAuthenticationCredentials() {
            return null;
        }

        @Nullable
        default public Object getCustomAuthenticationCredentials() {
            return null;
        }

        @Nullable
        default public String getKmsKeyArn() {
            return null;
        }

        @Nullable
        default public Object getOAuth2Properties() {
            return null;
        }

        @Nullable
        default public String getSecretArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthenticationConfigurationInputProperty> {
            String authenticationType;
            Object basicAuthenticationCredentials;
            Object customAuthenticationCredentials;
            String kmsKeyArn;
            Object oAuth2Properties;
            String secretArn;

            public Builder authenticationType(String authenticationType) {
                this.authenticationType = authenticationType;
                return this;
            }

            public Builder basicAuthenticationCredentials(IResolvable basicAuthenticationCredentials) {
                this.basicAuthenticationCredentials = basicAuthenticationCredentials;
                return this;
            }

            public Builder basicAuthenticationCredentials(BasicAuthenticationCredentialsProperty basicAuthenticationCredentials) {
                this.basicAuthenticationCredentials = basicAuthenticationCredentials;
                return this;
            }

            public Builder customAuthenticationCredentials(Object customAuthenticationCredentials) {
                this.customAuthenticationCredentials = customAuthenticationCredentials;
                return this;
            }

            public Builder kmsKeyArn(String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            public Builder oAuth2Properties(IResolvable oAuth2Properties) {
                this.oAuth2Properties = oAuth2Properties;
                return this;
            }

            public Builder oAuth2Properties(OAuth2PropertiesInputProperty oAuth2Properties) {
                this.oAuth2Properties = oAuth2Properties;
                return this;
            }

            public Builder secretArn(String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            public AuthenticationConfigurationInputProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

