/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.imagebuilder;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration;
import software.amazon.awscdk.services.imagebuilder.CfnDistributionConfigurationProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_imagebuilder.CfnDistributionConfiguration")
public class CfnDistributionConfiguration
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnDistributionConfiguration.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnDistributionConfiguration(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDistributionConfiguration(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnDistributionConfiguration(@NotNull Construct scope, @NotNull String id, @NotNull CfnDistributionConfigurationProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)this, (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrName() {
        return (String)Kernel.get((Object)this, (String)"attrName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public Object getDistributions() {
        return Kernel.get((Object)this, (String)"distributions", (NativeType)NativeType.forClass(Object.class));
    }

    public void setDistributions(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"distributions", (Object)Objects.requireNonNull(value, "distributions is required"));
    }

    public void setDistributions(@NotNull List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof DistributionProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.imagebuilder.CfnDistributionConfiguration.DistributionProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"distributions", Objects.requireNonNull(value, "distributions is required"));
    }

    @NotNull
    public String getName() {
        return (String)Kernel.get((Object)this, (String)"name", (NativeType)NativeType.forClass(String.class));
    }

    public void setName(@NotNull String value) {
        Kernel.set((Object)this, (String)"name", (Object)Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)Kernel.get((Object)this, (String)"description", (NativeType)NativeType.forClass(String.class));
    }

    public void setDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"description", (Object)value);
    }

    @Nullable
    public Map<String, String> getTagsRaw() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    public void setTagsRaw(@Nullable Map<String, String> value) {
        Kernel.set((Object)this, (String)"tagsRaw", value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_imagebuilder.CfnDistributionConfiguration.DistributionProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DistributionProperty
    extends JsiiSerializable {
        @NotNull
        public String getRegion();

        @Nullable
        default public Object getAmiDistributionConfiguration() {
            return null;
        }

        @Nullable
        default public Object getContainerDistributionConfiguration() {
            return null;
        }

        @Nullable
        default public Object getFastLaunchConfigurations() {
            return null;
        }

        @Nullable
        default public Object getLaunchTemplateConfigurations() {
            return null;
        }

        @Nullable
        default public List<String> getLicenseConfigurationArns() {
            return null;
        }

        @Nullable
        default public Object getSsmParameterConfigurations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DistributionProperty> {
            String region;
            Object amiDistributionConfiguration;
            Object containerDistributionConfiguration;
            Object fastLaunchConfigurations;
            Object launchTemplateConfigurations;
            List<String> licenseConfigurationArns;
            Object ssmParameterConfigurations;

            public Builder region(String region) {
                this.region = region;
                return this;
            }

            public Builder amiDistributionConfiguration(Object amiDistributionConfiguration) {
                this.amiDistributionConfiguration = amiDistributionConfiguration;
                return this;
            }

            public Builder containerDistributionConfiguration(Object containerDistributionConfiguration) {
                this.containerDistributionConfiguration = containerDistributionConfiguration;
                return this;
            }

            public Builder fastLaunchConfigurations(IResolvable fastLaunchConfigurations) {
                this.fastLaunchConfigurations = fastLaunchConfigurations;
                return this;
            }

            public Builder fastLaunchConfigurations(List<? extends Object> fastLaunchConfigurations) {
                this.fastLaunchConfigurations = fastLaunchConfigurations;
                return this;
            }

            public Builder launchTemplateConfigurations(IResolvable launchTemplateConfigurations) {
                this.launchTemplateConfigurations = launchTemplateConfigurations;
                return this;
            }

            public Builder launchTemplateConfigurations(List<? extends Object> launchTemplateConfigurations) {
                this.launchTemplateConfigurations = launchTemplateConfigurations;
                return this;
            }

            public Builder licenseConfigurationArns(List<String> licenseConfigurationArns) {
                this.licenseConfigurationArns = licenseConfigurationArns;
                return this;
            }

            public Builder ssmParameterConfigurations(IResolvable ssmParameterConfigurations) {
                this.ssmParameterConfigurations = ssmParameterConfigurations;
                return this;
            }

            public Builder ssmParameterConfigurations(List<? extends Object> ssmParameterConfigurations) {
                this.ssmParameterConfigurations = ssmParameterConfigurations;
                return this;
            }

            public DistributionProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnDistributionConfiguration> {
        private final Construct scope;
        private final String id;
        private final CfnDistributionConfigurationProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnDistributionConfigurationProps.Builder();
        }

        public Builder distributions(IResolvable distributions) {
            this.props.distributions(distributions);
            return this;
        }

        public Builder distributions(List<? extends Object> distributions) {
            this.props.distributions(distributions);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnDistributionConfiguration build() {
            return new CfnDistributionConfiguration(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_imagebuilder.CfnDistributionConfiguration.TargetContainerRepositoryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TargetContainerRepositoryProperty
    extends JsiiSerializable {
        @Nullable
        default public String getRepositoryName() {
            return null;
        }

        @Nullable
        default public String getService() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TargetContainerRepositoryProperty> {
            String repositoryName;
            String service;

            public Builder repositoryName(String repositoryName) {
                this.repositoryName = repositoryName;
                return this;
            }

            public Builder service(String service) {
                this.service = service;
                return this;
            }

            public TargetContainerRepositoryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_imagebuilder.CfnDistributionConfiguration.SsmParameterConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SsmParameterConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getParameterName();

        @Nullable
        default public String getAmiAccountId() {
            return null;
        }

        @Nullable
        default public String getDataType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SsmParameterConfigurationProperty> {
            String parameterName;
            String amiAccountId;
            String dataType;

            public Builder parameterName(String parameterName) {
                this.parameterName = parameterName;
                return this;
            }

            public Builder amiAccountId(String amiAccountId) {
                this.amiAccountId = amiAccountId;
                return this;
            }

            public Builder dataType(String dataType) {
                this.dataType = dataType;
                return this;
            }

            public SsmParameterConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_imagebuilder.CfnDistributionConfiguration.LaunchTemplateConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchTemplateConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAccountId() {
            return null;
        }

        @Nullable
        default public String getLaunchTemplateId() {
            return null;
        }

        @Nullable
        default public Object getSetDefaultVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchTemplateConfigurationProperty> {
            String accountId;
            String launchTemplateId;
            Object setDefaultVersion;

            public Builder accountId(String accountId) {
                this.accountId = accountId;
                return this;
            }

            public Builder launchTemplateId(String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            public Builder setDefaultVersion(Boolean setDefaultVersion) {
                this.setDefaultVersion = setDefaultVersion;
                return this;
            }

            public Builder setDefaultVersion(IResolvable setDefaultVersion) {
                this.setDefaultVersion = setDefaultVersion;
                return this;
            }

            public LaunchTemplateConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_imagebuilder.CfnDistributionConfiguration.LaunchPermissionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LaunchPermissionConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getOrganizationalUnitArns() {
            return null;
        }

        @Nullable
        default public List<String> getOrganizationArns() {
            return null;
        }

        @Nullable
        default public List<String> getUserGroups() {
            return null;
        }

        @Nullable
        default public List<String> getUserIds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LaunchPermissionConfigurationProperty> {
            List<String> organizationalUnitArns;
            List<String> organizationArns;
            List<String> userGroups;
            List<String> userIds;

            public Builder organizationalUnitArns(List<String> organizationalUnitArns) {
                this.organizationalUnitArns = organizationalUnitArns;
                return this;
            }

            public Builder organizationArns(List<String> organizationArns) {
                this.organizationArns = organizationArns;
                return this;
            }

            public Builder userGroups(List<String> userGroups) {
                this.userGroups = userGroups;
                return this;
            }

            public Builder userIds(List<String> userIds) {
                this.userIds = userIds;
                return this;
            }

            public LaunchPermissionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_imagebuilder.CfnDistributionConfiguration.FastLaunchSnapshotConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FastLaunchSnapshotConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getTargetResourceCount() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FastLaunchSnapshotConfigurationProperty> {
            Number targetResourceCount;

            public Builder targetResourceCount(Number targetResourceCount) {
                this.targetResourceCount = targetResourceCount;
                return this;
            }

            public FastLaunchSnapshotConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_imagebuilder.CfnDistributionConfiguration.FastLaunchLaunchTemplateSpecificationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FastLaunchLaunchTemplateSpecificationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getLaunchTemplateId() {
            return null;
        }

        @Nullable
        default public String getLaunchTemplateName() {
            return null;
        }

        @Nullable
        default public String getLaunchTemplateVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FastLaunchLaunchTemplateSpecificationProperty> {
            String launchTemplateId;
            String launchTemplateName;
            String launchTemplateVersion;

            public Builder launchTemplateId(String launchTemplateId) {
                this.launchTemplateId = launchTemplateId;
                return this;
            }

            public Builder launchTemplateName(String launchTemplateName) {
                this.launchTemplateName = launchTemplateName;
                return this;
            }

            public Builder launchTemplateVersion(String launchTemplateVersion) {
                this.launchTemplateVersion = launchTemplateVersion;
                return this;
            }

            public FastLaunchLaunchTemplateSpecificationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_imagebuilder.CfnDistributionConfiguration.FastLaunchConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FastLaunchConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAccountId() {
            return null;
        }

        @Nullable
        default public Object getEnabled() {
            return null;
        }

        @Nullable
        default public Object getLaunchTemplate() {
            return null;
        }

        @Nullable
        default public Number getMaxParallelLaunches() {
            return null;
        }

        @Nullable
        default public Object getSnapshotConfiguration() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FastLaunchConfigurationProperty> {
            String accountId;
            Object enabled;
            Object launchTemplate;
            Number maxParallelLaunches;
            Object snapshotConfiguration;

            public Builder accountId(String accountId) {
                this.accountId = accountId;
                return this;
            }

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder launchTemplate(IResolvable launchTemplate) {
                this.launchTemplate = launchTemplate;
                return this;
            }

            public Builder launchTemplate(FastLaunchLaunchTemplateSpecificationProperty launchTemplate) {
                this.launchTemplate = launchTemplate;
                return this;
            }

            public Builder maxParallelLaunches(Number maxParallelLaunches) {
                this.maxParallelLaunches = maxParallelLaunches;
                return this;
            }

            public Builder snapshotConfiguration(IResolvable snapshotConfiguration) {
                this.snapshotConfiguration = snapshotConfiguration;
                return this;
            }

            public Builder snapshotConfiguration(FastLaunchSnapshotConfigurationProperty snapshotConfiguration) {
                this.snapshotConfiguration = snapshotConfiguration;
                return this;
            }

            public FastLaunchConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_imagebuilder.CfnDistributionConfiguration.ContainerDistributionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ContainerDistributionConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getContainerTags() {
            return null;
        }

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public Object getTargetRepository() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ContainerDistributionConfigurationProperty> {
            List<String> containerTags;
            String description;
            Object targetRepository;

            public Builder containerTags(List<String> containerTags) {
                this.containerTags = containerTags;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder targetRepository(IResolvable targetRepository) {
                this.targetRepository = targetRepository;
                return this;
            }

            public Builder targetRepository(TargetContainerRepositoryProperty targetRepository) {
                this.targetRepository = targetRepository;
                return this;
            }

            public ContainerDistributionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_imagebuilder.CfnDistributionConfiguration.AmiDistributionConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AmiDistributionConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAmiTags() {
            return null;
        }

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public String getKmsKeyId() {
            return null;
        }

        @Nullable
        default public Object getLaunchPermissionConfiguration() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public List<String> getTargetAccountIds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AmiDistributionConfigurationProperty> {
            Object amiTags;
            String description;
            String kmsKeyId;
            Object launchPermissionConfiguration;
            String name;
            List<String> targetAccountIds;

            public Builder amiTags(Map<String, String> amiTags) {
                this.amiTags = amiTags;
                return this;
            }

            public Builder amiTags(IResolvable amiTags) {
                this.amiTags = amiTags;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder kmsKeyId(String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            public Builder launchPermissionConfiguration(IResolvable launchPermissionConfiguration) {
                this.launchPermissionConfiguration = launchPermissionConfiguration;
                return this;
            }

            public Builder launchPermissionConfiguration(LaunchPermissionConfigurationProperty launchPermissionConfiguration) {
                this.launchPermissionConfiguration = launchPermissionConfiguration;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder targetAccountIds(List<String> targetAccountIds) {
                this.targetAccountIds = targetAccountIds;
                return this;
            }

            public AmiDistributionConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

