/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesisfirehose;

import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Size;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.kinesisfirehose.CommonDestinationProps;
import software.amazon.awscdk.services.kinesisfirehose.CommonDestinationS3Props;
import software.amazon.awscdk.services.kinesisfirehose.Compression;
import software.amazon.awscdk.services.kinesisfirehose.DestinationS3BackupProps;
import software.amazon.awscdk.services.kinesisfirehose.IDataProcessor;
import software.amazon.awscdk.services.kinesisfirehose.ILoggingConfig;
import software.amazon.awscdk.services.kinesisfirehose.S3BucketProps;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.S3BucketProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface S3BucketProps
extends JsiiSerializable,
CommonDestinationS3Props,
CommonDestinationProps {
    @Nullable
    default public String getFileExtension() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<S3BucketProps> {
        String fileExtension;
        Duration bufferingInterval;
        Size bufferingSize;
        Compression compression;
        String dataOutputPrefix;
        IKey encryptionKey;
        String errorOutputPrefix;
        ILoggingConfig loggingConfig;
        IDataProcessor processor;
        IRole role;
        DestinationS3BackupProps s3Backup;

        public Builder fileExtension(String fileExtension) {
            this.fileExtension = fileExtension;
            return this;
        }

        public Builder bufferingInterval(Duration bufferingInterval) {
            this.bufferingInterval = bufferingInterval;
            return this;
        }

        public Builder bufferingSize(Size bufferingSize) {
            this.bufferingSize = bufferingSize;
            return this;
        }

        public Builder compression(Compression compression) {
            this.compression = compression;
            return this;
        }

        public Builder dataOutputPrefix(String dataOutputPrefix) {
            this.dataOutputPrefix = dataOutputPrefix;
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public Builder errorOutputPrefix(String errorOutputPrefix) {
            this.errorOutputPrefix = errorOutputPrefix;
            return this;
        }

        public Builder loggingConfig(ILoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        public Builder processor(IDataProcessor processor) {
            this.processor = processor;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder s3Backup(DestinationS3BackupProps s3Backup) {
            this.s3Backup = s3Backup;
            return this;
        }

        public S3BucketProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

