/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.scheduler.targets;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.scheduler.ISchedule;
import software.amazon.awscdk.services.scheduler.IScheduleTarget;
import software.amazon.awscdk.services.scheduler.ScheduleTargetConfig;
import software.amazon.awscdk.services.scheduler.ScheduleTargetInput;
import software.amazon.awscdk.services.scheduler.targets.ScheduleTargetBase;
import software.amazon.awscdk.services.scheduler.targets.SqsSendMessageProps;
import software.amazon.awscdk.services.sqs.IQueue;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_scheduler_targets.SqsSendMessage")
public class SqsSendMessage
extends ScheduleTargetBase
implements IScheduleTarget {
    protected SqsSendMessage(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqsSendMessage(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public SqsSendMessage(@NotNull IQueue queue, @Nullable SqsSendMessageProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(queue, "queue is required"), props});
    }

    public SqsSendMessage(@NotNull IQueue queue) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(queue, "queue is required")});
    }

    @Override
    protected void addTargetActionToRole(@NotNull IRole role) {
        Kernel.call((Object)this, (String)"addTargetActionToRole", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(role, "role is required")});
    }

    @Override
    @NotNull
    protected ScheduleTargetConfig bindBaseTargetConfig(@NotNull ISchedule _schedule) {
        return (ScheduleTargetConfig)Kernel.call((Object)this, (String)"bindBaseTargetConfig", (NativeType)NativeType.forClass(ScheduleTargetConfig.class), (Object[])new Object[]{Objects.requireNonNull(_schedule, "_schedule is required")});
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<SqsSendMessage> {
        private final IQueue queue;
        private SqsSendMessageProps.Builder props;

        public static Builder create(IQueue queue) {
            return new Builder(queue);
        }

        private Builder(IQueue queue) {
            this.queue = queue;
        }

        public Builder deadLetterQueue(IQueue deadLetterQueue) {
            this.props().deadLetterQueue(deadLetterQueue);
            return this;
        }

        public Builder input(ScheduleTargetInput input) {
            this.props().input(input);
            return this;
        }

        public Builder maxEventAge(Duration maxEventAge) {
            this.props().maxEventAge(maxEventAge);
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.props().retryAttempts(retryAttempts);
            return this;
        }

        public Builder role(IRole role) {
            this.props().role(role);
            return this;
        }

        public Builder messageGroupId(String messageGroupId) {
            this.props().messageGroupId(messageGroupId);
            return this;
        }

        public SqsSendMessage build() {
            return new SqsSendMessage(this.queue, this.props != null ? this.props.build() : null);
        }

        private SqsSendMessageProps.Builder props() {
            if (this.props == null) {
                this.props = new SqsSendMessageProps.Builder();
            }
            return this.props;
        }
    }
}

