/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import software.amazon.awscdk.;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.apigateway.IModel;
import software.amazon.awscdk.services.apigateway.IRestApi;
import software.amazon.awscdk.services.apigateway.JsonSchema;
import software.amazon.awscdk.services.apigateway.ModelProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_apigateway.Model")
public class Model
extends Resource
implements IModel {
    public static final IModel EMPTY_MODEL = (IModel)JsiiObject.jsiiStaticGet(Model.class, (String)"EMPTY_MODEL", (NativeType)NativeType.forClass(IModel.class));
    public static final IModel ERROR_MODEL = (IModel)JsiiObject.jsiiStaticGet(Model.class, (String)"ERROR_MODEL", (NativeType)NativeType.forClass(IModel.class));
    public static final String PROPERTY_INJECTION_ID = (String)JsiiObject.jsiiStaticGet(Model.class, (String)"PROPERTY_INJECTION_ID", (NativeType)NativeType.forClass(String.class));

    protected Model(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Model(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public Model(@NotNull Construct scope, @NotNull String id, @NotNull ModelProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IModel fromModelName(@NotNull Construct scope, @NotNull String id, @NotNull String modelName) {
        return (IModel)JsiiObject.jsiiStaticCall(Model.class, (String)"fromModelName", (NativeType)NativeType.forClass(IModel.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(modelName, "modelName is required")});
    }

    @Override
    @NotNull
    public String getModelId() {
        return (String)Kernel.get((Object)this, (String)"modelId", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<Model> {
        private final Construct scope;
        private final String id;
        private final ModelProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new ModelProps.Builder();
        }

        public Builder schema(JsonSchema schema) {
            this.props.schema(schema);
            return this;
        }

        public Builder contentType(String contentType) {
            this.props.contentType(contentType);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder modelName(String modelName) {
            this.props.modelName(modelName);
            return this;
        }

        public Builder restApi(IRestApi restApi) {
            this.props.restApi(restApi);
            return this;
        }

        public Model build() {
            return new Model(this.scope, this.id, this.props.build());
        }
    }
}

