/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.appsync;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.ResourceProps;
import software.amazon.awscdk.services.appsync.ApiBase;
import software.amazon.awscdk.services.appsync.AppSyncAuthorizationType;
import software.amazon.awscdk.services.appsync.AppSyncDataSourceOptions;
import software.amazon.awscdk.services.appsync.AppSyncDynamoDbDataSource;
import software.amazon.awscdk.services.appsync.AppSyncEventBridgeDataSource;
import software.amazon.awscdk.services.appsync.AppSyncEventResource;
import software.amazon.awscdk.services.appsync.AppSyncHttpDataSource;
import software.amazon.awscdk.services.appsync.AppSyncHttpDataSourceOptions;
import software.amazon.awscdk.services.appsync.AppSyncLambdaDataSource;
import software.amazon.awscdk.services.appsync.AppSyncOpenSearchDataSource;
import software.amazon.awscdk.services.appsync.AppSyncRdsDataSource;
import software.amazon.awscdk.services.appsync.ChannelNamespace;
import software.amazon.awscdk.services.appsync.ChannelNamespaceOptions;
import software.amazon.awscdk.services.appsync.IEventApi;
import software.amazon.awscdk.services.dynamodb.ITable;
import software.amazon.awscdk.services.events.IEventBus;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.awscdk.services.opensearchservice.IDomain;
import software.amazon.awscdk.services.rds.IDatabaseCluster;
import software.amazon.awscdk.services.rds.IServerlessCluster;
import software.amazon.awscdk.services.secretsmanager.ISecret;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_appsync.EventApiBase")
public abstract class EventApiBase
extends ApiBase
implements IEventApi {
    protected EventApiBase(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EventApiBase(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    protected EventApiBase(@NotNull Construct scope, @NotNull String id, @Nullable ResourceProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    protected EventApiBase(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public ChannelNamespace addChannelNamespace(@NotNull String id, @Nullable ChannelNamespaceOptions options) {
        return (ChannelNamespace)Kernel.call((Object)this, (String)"addChannelNamespace", (NativeType)NativeType.forClass(ChannelNamespace.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), options});
    }

    @Override
    @NotNull
    public ChannelNamespace addChannelNamespace(@NotNull String id) {
        return (ChannelNamespace)Kernel.call((Object)this, (String)"addChannelNamespace", (NativeType)NativeType.forClass(ChannelNamespace.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required")});
    }

    @Override
    @NotNull
    public AppSyncDynamoDbDataSource addDynamoDbDataSource(@NotNull String id, @NotNull ITable table, @Nullable AppSyncDataSourceOptions options) {
        return (AppSyncDynamoDbDataSource)Kernel.call((Object)this, (String)"addDynamoDbDataSource", (NativeType)NativeType.forClass(AppSyncDynamoDbDataSource.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(table, "table is required"), options});
    }

    @Override
    @NotNull
    public AppSyncDynamoDbDataSource addDynamoDbDataSource(@NotNull String id, @NotNull ITable table) {
        return (AppSyncDynamoDbDataSource)Kernel.call((Object)this, (String)"addDynamoDbDataSource", (NativeType)NativeType.forClass(AppSyncDynamoDbDataSource.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(table, "table is required")});
    }

    @Override
    @NotNull
    public AppSyncEventBridgeDataSource addEventBridgeDataSource(@NotNull String id, @NotNull IEventBus eventBus, @Nullable AppSyncDataSourceOptions options) {
        return (AppSyncEventBridgeDataSource)Kernel.call((Object)this, (String)"addEventBridgeDataSource", (NativeType)NativeType.forClass(AppSyncEventBridgeDataSource.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(eventBus, "eventBus is required"), options});
    }

    @Override
    @NotNull
    public AppSyncEventBridgeDataSource addEventBridgeDataSource(@NotNull String id, @NotNull IEventBus eventBus) {
        return (AppSyncEventBridgeDataSource)Kernel.call((Object)this, (String)"addEventBridgeDataSource", (NativeType)NativeType.forClass(AppSyncEventBridgeDataSource.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(eventBus, "eventBus is required")});
    }

    @Override
    @NotNull
    public AppSyncHttpDataSource addHttpDataSource(@NotNull String id, @NotNull String endpoint, @Nullable AppSyncHttpDataSourceOptions options) {
        return (AppSyncHttpDataSource)Kernel.call((Object)this, (String)"addHttpDataSource", (NativeType)NativeType.forClass(AppSyncHttpDataSource.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(endpoint, "endpoint is required"), options});
    }

    @Override
    @NotNull
    public AppSyncHttpDataSource addHttpDataSource(@NotNull String id, @NotNull String endpoint) {
        return (AppSyncHttpDataSource)Kernel.call((Object)this, (String)"addHttpDataSource", (NativeType)NativeType.forClass(AppSyncHttpDataSource.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(endpoint, "endpoint is required")});
    }

    @Override
    @NotNull
    public AppSyncLambdaDataSource addLambdaDataSource(@NotNull String id, @NotNull IFunction lambdaFunction, @Nullable AppSyncDataSourceOptions options) {
        return (AppSyncLambdaDataSource)Kernel.call((Object)this, (String)"addLambdaDataSource", (NativeType)NativeType.forClass(AppSyncLambdaDataSource.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(lambdaFunction, "lambdaFunction is required"), options});
    }

    @Override
    @NotNull
    public AppSyncLambdaDataSource addLambdaDataSource(@NotNull String id, @NotNull IFunction lambdaFunction) {
        return (AppSyncLambdaDataSource)Kernel.call((Object)this, (String)"addLambdaDataSource", (NativeType)NativeType.forClass(AppSyncLambdaDataSource.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(lambdaFunction, "lambdaFunction is required")});
    }

    @Override
    @NotNull
    public AppSyncOpenSearchDataSource addOpenSearchDataSource(@NotNull String id, @NotNull IDomain domain, @Nullable AppSyncDataSourceOptions options) {
        return (AppSyncOpenSearchDataSource)Kernel.call((Object)this, (String)"addOpenSearchDataSource", (NativeType)NativeType.forClass(AppSyncOpenSearchDataSource.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(domain, "domain is required"), options});
    }

    @Override
    @NotNull
    public AppSyncOpenSearchDataSource addOpenSearchDataSource(@NotNull String id, @NotNull IDomain domain) {
        return (AppSyncOpenSearchDataSource)Kernel.call((Object)this, (String)"addOpenSearchDataSource", (NativeType)NativeType.forClass(AppSyncOpenSearchDataSource.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(domain, "domain is required")});
    }

    @Override
    @NotNull
    public AppSyncRdsDataSource addRdsDataSource(@NotNull String id, @NotNull Object serverlessCluster, @NotNull ISecret secretStore, @Nullable String databaseName, @Nullable AppSyncDataSourceOptions options) {
        if (Configuration.getRuntimeTypeChecking() && !(serverlessCluster instanceof IDatabaseCluster) && !(serverlessCluster instanceof IServerlessCluster) && !serverlessCluster.getClass().equals(JsiiObject.class)) {
            throw new IllegalArgumentException("Expected " + "serverlessCluster" + " to be one of: software.amazon.awscdk.services.rds.IDatabaseCluster, software.amazon.awscdk.services.rds.IServerlessCluster; received " + serverlessCluster.getClass());
        }
        return (AppSyncRdsDataSource)Kernel.call((Object)this, (String)"addRdsDataSource", (NativeType)NativeType.forClass(AppSyncRdsDataSource.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(serverlessCluster, "serverlessCluster is required"), Objects.requireNonNull(secretStore, "secretStore is required"), databaseName, options});
    }

    @Override
    @NotNull
    public AppSyncRdsDataSource addRdsDataSource(@NotNull String id, @NotNull Object serverlessCluster, @NotNull ISecret secretStore, @Nullable String databaseName) {
        if (Configuration.getRuntimeTypeChecking() && !(serverlessCluster instanceof IDatabaseCluster) && !(serverlessCluster instanceof IServerlessCluster) && !serverlessCluster.getClass().equals(JsiiObject.class)) {
            throw new IllegalArgumentException("Expected " + "serverlessCluster" + " to be one of: software.amazon.awscdk.services.rds.IDatabaseCluster, software.amazon.awscdk.services.rds.IServerlessCluster; received " + serverlessCluster.getClass());
        }
        return (AppSyncRdsDataSource)Kernel.call((Object)this, (String)"addRdsDataSource", (NativeType)NativeType.forClass(AppSyncRdsDataSource.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(serverlessCluster, "serverlessCluster is required"), Objects.requireNonNull(secretStore, "secretStore is required"), databaseName});
    }

    @Override
    @NotNull
    public AppSyncRdsDataSource addRdsDataSource(@NotNull String id, @NotNull Object serverlessCluster, @NotNull ISecret secretStore) {
        if (Configuration.getRuntimeTypeChecking() && !(serverlessCluster instanceof IDatabaseCluster) && !(serverlessCluster instanceof IServerlessCluster) && !serverlessCluster.getClass().equals(JsiiObject.class)) {
            throw new IllegalArgumentException("Expected " + "serverlessCluster" + " to be one of: software.amazon.awscdk.services.rds.IDatabaseCluster, software.amazon.awscdk.services.rds.IServerlessCluster; received " + serverlessCluster.getClass());
        }
        return (AppSyncRdsDataSource)Kernel.call((Object)this, (String)"addRdsDataSource", (NativeType)NativeType.forClass(AppSyncRdsDataSource.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(serverlessCluster, "serverlessCluster is required"), Objects.requireNonNull(secretStore, "secretStore is required")});
    }

    @Override
    @NotNull
    public Grant grant(@NotNull IGrantable grantee, @NotNull AppSyncEventResource resources, String ... actions) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grant", (NativeType)NativeType.forClass(Grant.class), (Object[])Stream.concat(Arrays.stream(new Object[]{Objects.requireNonNull(grantee, "grantee is required"), Objects.requireNonNull(resources, "resources is required")}), Arrays.stream(actions)).toArray(Object[]::new)));
    }

    @Override
    @NotNull
    public Grant grantConnect(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantConnect", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantPublish(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantPublish", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantPublishAndSubscribe(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantPublishAndSubscribe", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public Grant grantSubscribe(@NotNull IGrantable grantee) {
        return (Grant)((Object)Kernel.call((Object)this, (String)"grantSubscribe", (NativeType)NativeType.forClass(Grant.class), (Object[])new Object[]{Objects.requireNonNull(grantee, "grantee is required")}));
    }

    @Override
    @NotNull
    public abstract List<AppSyncAuthorizationType> getAuthProviderTypes();

    @Override
    @NotNull
    public abstract String getHttpDns();

    @Override
    @NotNull
    public abstract String getRealtimeDns();
}

