/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.batch;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggable;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.batch.CfnJobDefinition;
import software.amazon.awscdk.services.batch.CfnJobDefinitionProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition")
public class CfnJobDefinition
extends CfnResource
implements IInspectable,
ITaggable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnJobDefinition.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnJobDefinition(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnJobDefinition(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnJobDefinition(@NotNull Construct scope, @NotNull String id, @NotNull CfnJobDefinitionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrJobDefinitionArn() {
        return (String)Kernel.get((Object)this, (String)"attrJobDefinitionArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @Override
    @NotNull
    public TagManager getTags() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @NotNull
    public String getType() {
        return (String)Kernel.get((Object)this, (String)"type", (NativeType)NativeType.forClass(String.class));
    }

    public void setType(@NotNull String value) {
        Kernel.set((Object)this, (String)"type", (Object)Objects.requireNonNull(value, "type is required"));
    }

    @Nullable
    public Object getConsumableResourceProperties() {
        return Kernel.get((Object)this, (String)"consumableResourceProperties", (NativeType)NativeType.forClass(Object.class));
    }

    public void setConsumableResourceProperties(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"consumableResourceProperties", (Object)value);
    }

    public void setConsumableResourceProperties(@Nullable ConsumableResourcePropertiesProperty value) {
        Kernel.set((Object)this, (String)"consumableResourceProperties", (Object)value);
    }

    @Nullable
    public Object getContainerProperties() {
        return Kernel.get((Object)this, (String)"containerProperties", (NativeType)NativeType.forClass(Object.class));
    }

    public void setContainerProperties(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"containerProperties", (Object)value);
    }

    public void setContainerProperties(@Nullable ContainerPropertiesProperty value) {
        Kernel.set((Object)this, (String)"containerProperties", (Object)value);
    }

    @Nullable
    public Object getEcsProperties() {
        return Kernel.get((Object)this, (String)"ecsProperties", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEcsProperties(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"ecsProperties", (Object)value);
    }

    public void setEcsProperties(@Nullable EcsPropertiesProperty value) {
        Kernel.set((Object)this, (String)"ecsProperties", (Object)value);
    }

    @Nullable
    public Object getEksProperties() {
        return Kernel.get((Object)this, (String)"eksProperties", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEksProperties(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"eksProperties", (Object)value);
    }

    public void setEksProperties(@Nullable EksPropertiesProperty value) {
        Kernel.set((Object)this, (String)"eksProperties", (Object)value);
    }

    @Nullable
    public String getJobDefinitionName() {
        return (String)Kernel.get((Object)this, (String)"jobDefinitionName", (NativeType)NativeType.forClass(String.class));
    }

    public void setJobDefinitionName(@Nullable String value) {
        Kernel.set((Object)this, (String)"jobDefinitionName", (Object)value);
    }

    @Nullable
    public Object getNodeProperties() {
        return Kernel.get((Object)this, (String)"nodeProperties", (NativeType)NativeType.forClass(Object.class));
    }

    public void setNodeProperties(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"nodeProperties", (Object)value);
    }

    public void setNodeProperties(@Nullable NodePropertiesProperty value) {
        Kernel.set((Object)this, (String)"nodeProperties", (Object)value);
    }

    @Nullable
    public Object getParameters() {
        return Kernel.get((Object)this, (String)"parameters", (NativeType)NativeType.forClass(Object.class));
    }

    public void setParameters(@Nullable Object value) {
        Kernel.set((Object)this, (String)"parameters", (Object)value);
    }

    @Nullable
    public List<String> getPlatformCapabilities() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"platformCapabilities", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setPlatformCapabilities(@Nullable List<String> value) {
        Kernel.set((Object)this, (String)"platformCapabilities", value);
    }

    @Nullable
    public Object getPropagateTags() {
        return Kernel.get((Object)this, (String)"propagateTags", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPropagateTags(@Nullable Boolean value) {
        Kernel.set((Object)this, (String)"propagateTags", (Object)value);
    }

    public void setPropagateTags(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"propagateTags", (Object)value);
    }

    @Nullable
    public Object getRetryStrategy() {
        return Kernel.get((Object)this, (String)"retryStrategy", (NativeType)NativeType.forClass(Object.class));
    }

    public void setRetryStrategy(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"retryStrategy", (Object)value);
    }

    public void setRetryStrategy(@Nullable RetryStrategyProperty value) {
        Kernel.set((Object)this, (String)"retryStrategy", (Object)value);
    }

    @Nullable
    public Number getSchedulingPriority() {
        return (Number)Kernel.get((Object)this, (String)"schedulingPriority", (NativeType)NativeType.forClass(Number.class));
    }

    public void setSchedulingPriority(@Nullable Number value) {
        Kernel.set((Object)this, (String)"schedulingPriority", (Object)value);
    }

    @Nullable
    public Object getTagsRaw() {
        return Kernel.get((Object)this, (String)"tagsRaw", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTagsRaw(@Nullable Object value) {
        Kernel.set((Object)this, (String)"tagsRaw", (Object)value);
    }

    @Nullable
    public Object getTimeout() {
        return Kernel.get((Object)this, (String)"timeout", (NativeType)NativeType.forClass(Object.class));
    }

    public void setTimeout(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"timeout", (Object)value);
    }

    public void setTimeout(@Nullable TimeoutProperty value) {
        Kernel.set((Object)this, (String)"timeout", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnJobDefinition> {
        private final Construct scope;
        private final String id;
        private final CfnJobDefinitionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnJobDefinitionProps.Builder();
        }

        public Builder type(String type) {
            this.props.type(type);
            return this;
        }

        public Builder consumableResourceProperties(IResolvable consumableResourceProperties) {
            this.props.consumableResourceProperties(consumableResourceProperties);
            return this;
        }

        public Builder consumableResourceProperties(ConsumableResourcePropertiesProperty consumableResourceProperties) {
            this.props.consumableResourceProperties(consumableResourceProperties);
            return this;
        }

        public Builder containerProperties(IResolvable containerProperties) {
            this.props.containerProperties(containerProperties);
            return this;
        }

        public Builder containerProperties(ContainerPropertiesProperty containerProperties) {
            this.props.containerProperties(containerProperties);
            return this;
        }

        public Builder ecsProperties(IResolvable ecsProperties) {
            this.props.ecsProperties(ecsProperties);
            return this;
        }

        public Builder ecsProperties(EcsPropertiesProperty ecsProperties) {
            this.props.ecsProperties(ecsProperties);
            return this;
        }

        public Builder eksProperties(IResolvable eksProperties) {
            this.props.eksProperties(eksProperties);
            return this;
        }

        public Builder eksProperties(EksPropertiesProperty eksProperties) {
            this.props.eksProperties(eksProperties);
            return this;
        }

        public Builder jobDefinitionName(String jobDefinitionName) {
            this.props.jobDefinitionName(jobDefinitionName);
            return this;
        }

        public Builder nodeProperties(IResolvable nodeProperties) {
            this.props.nodeProperties(nodeProperties);
            return this;
        }

        public Builder nodeProperties(NodePropertiesProperty nodeProperties) {
            this.props.nodeProperties(nodeProperties);
            return this;
        }

        public Builder parameters(Object parameters) {
            this.props.parameters(parameters);
            return this;
        }

        public Builder platformCapabilities(List<String> platformCapabilities) {
            this.props.platformCapabilities(platformCapabilities);
            return this;
        }

        public Builder propagateTags(Boolean propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        public Builder propagateTags(IResolvable propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        public Builder retryStrategy(IResolvable retryStrategy) {
            this.props.retryStrategy(retryStrategy);
            return this;
        }

        public Builder retryStrategy(RetryStrategyProperty retryStrategy) {
            this.props.retryStrategy(retryStrategy);
            return this;
        }

        public Builder schedulingPriority(Number schedulingPriority) {
            this.props.schedulingPriority(schedulingPriority);
            return this;
        }

        public Builder tags(Object tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder timeout(IResolvable timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder timeout(TimeoutProperty timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public CfnJobDefinition build() {
            return new CfnJobDefinition(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.VolumesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VolumesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getEfsVolumeConfiguration() {
            return null;
        }

        @Nullable
        default public Object getHost() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VolumesProperty> {
            Object efsVolumeConfiguration;
            Object host;
            String name;

            public Builder efsVolumeConfiguration(IResolvable efsVolumeConfiguration) {
                this.efsVolumeConfiguration = efsVolumeConfiguration;
                return this;
            }

            public Builder efsVolumeConfiguration(EfsVolumeConfigurationProperty efsVolumeConfiguration) {
                this.efsVolumeConfiguration = efsVolumeConfiguration;
                return this;
            }

            public Builder host(IResolvable host) {
                this.host = host;
                return this;
            }

            public Builder host(VolumesHostProperty host) {
                this.host = host;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public VolumesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.VolumesHostProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VolumesHostProperty
    extends JsiiSerializable {
        @Nullable
        default public String getSourcePath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VolumesHostProperty> {
            String sourcePath;

            public Builder sourcePath(String sourcePath) {
                this.sourcePath = sourcePath;
                return this;
            }

            public VolumesHostProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.UlimitProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface UlimitProperty
    extends JsiiSerializable {
        @NotNull
        public Number getHardLimit();

        @NotNull
        public String getName();

        @NotNull
        public Number getSoftLimit();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<UlimitProperty> {
            Number hardLimit;
            String name;
            Number softLimit;

            public Builder hardLimit(Number hardLimit) {
                this.hardLimit = hardLimit;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder softLimit(Number softLimit) {
                this.softLimit = softLimit;
                return this;
            }

            public UlimitProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.TmpfsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TmpfsProperty
    extends JsiiSerializable {
        @NotNull
        public String getContainerPath();

        @NotNull
        public Number getSize();

        @Nullable
        default public List<String> getMountOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TmpfsProperty> {
            String containerPath;
            Number size;
            List<String> mountOptions;

            public Builder containerPath(String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            public Builder size(Number size) {
                this.size = size;
                return this;
            }

            public Builder mountOptions(List<String> mountOptions) {
                this.mountOptions = mountOptions;
                return this;
            }

            public TmpfsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.TimeoutProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TimeoutProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getAttemptDurationSeconds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TimeoutProperty> {
            Number attemptDurationSeconds;

            public Builder attemptDurationSeconds(Number attemptDurationSeconds) {
                this.attemptDurationSeconds = attemptDurationSeconds;
                return this;
            }

            public TimeoutProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.TaskContainerPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TaskContainerPropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getImage();

        @Nullable
        default public List<String> getCommand() {
            return null;
        }

        @Nullable
        default public Object getDependsOn() {
            return null;
        }

        @Nullable
        default public Object getEnvironment() {
            return null;
        }

        @Nullable
        default public Object getEssential() {
            return null;
        }

        @Nullable
        default public Object getFirelensConfiguration() {
            return null;
        }

        @Nullable
        default public Object getLinuxParameters() {
            return null;
        }

        @Nullable
        default public Object getLogConfiguration() {
            return null;
        }

        @Nullable
        default public Object getMountPoints() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getPrivileged() {
            return null;
        }

        @Nullable
        default public Object getReadonlyRootFilesystem() {
            return null;
        }

        @Nullable
        default public Object getRepositoryCredentials() {
            return null;
        }

        @Nullable
        default public Object getResourceRequirements() {
            return null;
        }

        @Nullable
        default public Object getSecrets() {
            return null;
        }

        @Nullable
        default public Object getUlimits() {
            return null;
        }

        @Nullable
        default public String getUser() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TaskContainerPropertiesProperty> {
            String image;
            List<String> command;
            Object dependsOn;
            Object environment;
            Object essential;
            Object firelensConfiguration;
            Object linuxParameters;
            Object logConfiguration;
            Object mountPoints;
            String name;
            Object privileged;
            Object readonlyRootFilesystem;
            Object repositoryCredentials;
            Object resourceRequirements;
            Object secrets;
            Object ulimits;
            String user;

            public Builder image(String image) {
                this.image = image;
                return this;
            }

            public Builder command(List<String> command) {
                this.command = command;
                return this;
            }

            public Builder dependsOn(IResolvable dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            public Builder dependsOn(List<? extends Object> dependsOn) {
                this.dependsOn = dependsOn;
                return this;
            }

            public Builder environment(IResolvable environment) {
                this.environment = environment;
                return this;
            }

            public Builder environment(List<? extends Object> environment) {
                this.environment = environment;
                return this;
            }

            public Builder essential(Boolean essential) {
                this.essential = essential;
                return this;
            }

            public Builder essential(IResolvable essential) {
                this.essential = essential;
                return this;
            }

            public Builder firelensConfiguration(IResolvable firelensConfiguration) {
                this.firelensConfiguration = firelensConfiguration;
                return this;
            }

            public Builder firelensConfiguration(FirelensConfigurationProperty firelensConfiguration) {
                this.firelensConfiguration = firelensConfiguration;
                return this;
            }

            public Builder linuxParameters(IResolvable linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            public Builder linuxParameters(LinuxParametersProperty linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            public Builder logConfiguration(IResolvable logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            public Builder logConfiguration(LogConfigurationProperty logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            public Builder mountPoints(IResolvable mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            public Builder mountPoints(List<? extends Object> mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder privileged(Boolean privileged) {
                this.privileged = privileged;
                return this;
            }

            public Builder privileged(IResolvable privileged) {
                this.privileged = privileged;
                return this;
            }

            public Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            public Builder readonlyRootFilesystem(IResolvable readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            public Builder repositoryCredentials(IResolvable repositoryCredentials) {
                this.repositoryCredentials = repositoryCredentials;
                return this;
            }

            public Builder repositoryCredentials(RepositoryCredentialsProperty repositoryCredentials) {
                this.repositoryCredentials = repositoryCredentials;
                return this;
            }

            public Builder resourceRequirements(IResolvable resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            public Builder resourceRequirements(List<? extends Object> resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            public Builder secrets(IResolvable secrets) {
                this.secrets = secrets;
                return this;
            }

            public Builder secrets(List<? extends Object> secrets) {
                this.secrets = secrets;
                return this;
            }

            public Builder ulimits(IResolvable ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            public Builder ulimits(List<? extends Object> ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            public Builder user(String user) {
                this.user = user;
                return this;
            }

            public TaskContainerPropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.TaskContainerDependencyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TaskContainerDependencyProperty
    extends JsiiSerializable {
        @NotNull
        public String getCondition();

        @NotNull
        public String getContainerName();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<TaskContainerDependencyProperty> {
            String condition;
            String containerName;

            public Builder condition(String condition) {
                this.condition = condition;
                return this;
            }

            public Builder containerName(String containerName) {
                this.containerName = containerName;
                return this;
            }

            public TaskContainerDependencyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.SecurityContextProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SecurityContextProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAllowPrivilegeEscalation() {
            return null;
        }

        @Nullable
        default public Object getPrivileged() {
            return null;
        }

        @Nullable
        default public Object getReadOnlyRootFilesystem() {
            return null;
        }

        @Nullable
        default public Number getRunAsGroup() {
            return null;
        }

        @Nullable
        default public Object getRunAsNonRoot() {
            return null;
        }

        @Nullable
        default public Number getRunAsUser() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SecurityContextProperty> {
            Object allowPrivilegeEscalation;
            Object privileged;
            Object readOnlyRootFilesystem;
            Number runAsGroup;
            Object runAsNonRoot;
            Number runAsUser;

            public Builder allowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
                this.allowPrivilegeEscalation = allowPrivilegeEscalation;
                return this;
            }

            public Builder allowPrivilegeEscalation(IResolvable allowPrivilegeEscalation) {
                this.allowPrivilegeEscalation = allowPrivilegeEscalation;
                return this;
            }

            public Builder privileged(Boolean privileged) {
                this.privileged = privileged;
                return this;
            }

            public Builder privileged(IResolvable privileged) {
                this.privileged = privileged;
                return this;
            }

            public Builder readOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
                this.readOnlyRootFilesystem = readOnlyRootFilesystem;
                return this;
            }

            public Builder readOnlyRootFilesystem(IResolvable readOnlyRootFilesystem) {
                this.readOnlyRootFilesystem = readOnlyRootFilesystem;
                return this;
            }

            public Builder runAsGroup(Number runAsGroup) {
                this.runAsGroup = runAsGroup;
                return this;
            }

            public Builder runAsNonRoot(Boolean runAsNonRoot) {
                this.runAsNonRoot = runAsNonRoot;
                return this;
            }

            public Builder runAsNonRoot(IResolvable runAsNonRoot) {
                this.runAsNonRoot = runAsNonRoot;
                return this;
            }

            public Builder runAsUser(Number runAsUser) {
                this.runAsUser = runAsUser;
                return this;
            }

            public SecurityContextProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.SecretProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface SecretProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @NotNull
        public String getValueFrom();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<SecretProperty> {
            String name;
            String valueFrom;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder valueFrom(String valueFrom) {
                this.valueFrom = valueFrom;
                return this;
            }

            public SecretProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.RuntimePlatformProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RuntimePlatformProperty
    extends JsiiSerializable {
        @Nullable
        default public String getCpuArchitecture() {
            return null;
        }

        @Nullable
        default public String getOperatingSystemFamily() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RuntimePlatformProperty> {
            String cpuArchitecture;
            String operatingSystemFamily;

            public Builder cpuArchitecture(String cpuArchitecture) {
                this.cpuArchitecture = cpuArchitecture;
                return this;
            }

            public Builder operatingSystemFamily(String operatingSystemFamily) {
                this.operatingSystemFamily = operatingSystemFamily;
                return this;
            }

            public RuntimePlatformProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.RetryStrategyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RetryStrategyProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getAttempts() {
            return null;
        }

        @Nullable
        default public Object getEvaluateOnExit() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RetryStrategyProperty> {
            Number attempts;
            Object evaluateOnExit;

            public Builder attempts(Number attempts) {
                this.attempts = attempts;
                return this;
            }

            public Builder evaluateOnExit(IResolvable evaluateOnExit) {
                this.evaluateOnExit = evaluateOnExit;
                return this;
            }

            public Builder evaluateOnExit(List<? extends Object> evaluateOnExit) {
                this.evaluateOnExit = evaluateOnExit;
                return this;
            }

            public RetryStrategyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.ResourcesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourcesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getLimits() {
            return null;
        }

        @Nullable
        default public Object getRequests() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourcesProperty> {
            Object limits;
            Object requests;

            public Builder limits(Object limits) {
                this.limits = limits;
                return this;
            }

            public Builder requests(Object requests) {
                this.requests = requests;
                return this;
            }

            public ResourcesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.ResourceRequirementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourceRequirementProperty
    extends JsiiSerializable {
        @Nullable
        default public String getType() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourceRequirementProperty> {
            String type;
            String value;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public ResourceRequirementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.RepositoryCredentialsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RepositoryCredentialsProperty
    extends JsiiSerializable {
        @NotNull
        public String getCredentialsParameter();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RepositoryCredentialsProperty> {
            String credentialsParameter;

            public Builder credentialsParameter(String credentialsParameter) {
                this.credentialsParameter = credentialsParameter;
                return this;
            }

            public RepositoryCredentialsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.PodPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PodPropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getContainers() {
            return null;
        }

        @Nullable
        default public String getDnsPolicy() {
            return null;
        }

        @Nullable
        default public Object getHostNetwork() {
            return null;
        }

        @Nullable
        default public Object getImagePullSecrets() {
            return null;
        }

        @Nullable
        default public Object getInitContainers() {
            return null;
        }

        @Nullable
        default public Object getMetadata() {
            return null;
        }

        @Nullable
        default public String getServiceAccountName() {
            return null;
        }

        @Nullable
        default public Object getShareProcessNamespace() {
            return null;
        }

        @Nullable
        default public Object getVolumes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PodPropertiesProperty> {
            Object containers;
            String dnsPolicy;
            Object hostNetwork;
            Object imagePullSecrets;
            Object initContainers;
            Object metadata;
            String serviceAccountName;
            Object shareProcessNamespace;
            Object volumes;

            public Builder containers(IResolvable containers) {
                this.containers = containers;
                return this;
            }

            public Builder containers(List<? extends Object> containers) {
                this.containers = containers;
                return this;
            }

            public Builder dnsPolicy(String dnsPolicy) {
                this.dnsPolicy = dnsPolicy;
                return this;
            }

            public Builder hostNetwork(Boolean hostNetwork) {
                this.hostNetwork = hostNetwork;
                return this;
            }

            public Builder hostNetwork(IResolvable hostNetwork) {
                this.hostNetwork = hostNetwork;
                return this;
            }

            public Builder imagePullSecrets(IResolvable imagePullSecrets) {
                this.imagePullSecrets = imagePullSecrets;
                return this;
            }

            public Builder imagePullSecrets(List<? extends Object> imagePullSecrets) {
                this.imagePullSecrets = imagePullSecrets;
                return this;
            }

            public Builder initContainers(IResolvable initContainers) {
                this.initContainers = initContainers;
                return this;
            }

            public Builder initContainers(List<? extends Object> initContainers) {
                this.initContainers = initContainers;
                return this;
            }

            public Builder metadata(IResolvable metadata) {
                this.metadata = metadata;
                return this;
            }

            public Builder metadata(MetadataProperty metadata) {
                this.metadata = metadata;
                return this;
            }

            public Builder serviceAccountName(String serviceAccountName) {
                this.serviceAccountName = serviceAccountName;
                return this;
            }

            public Builder shareProcessNamespace(Boolean shareProcessNamespace) {
                this.shareProcessNamespace = shareProcessNamespace;
                return this;
            }

            public Builder shareProcessNamespace(IResolvable shareProcessNamespace) {
                this.shareProcessNamespace = shareProcessNamespace;
                return this;
            }

            public Builder volumes(IResolvable volumes) {
                this.volumes = volumes;
                return this;
            }

            public Builder volumes(List<? extends Object> volumes) {
                this.volumes = volumes;
                return this;
            }

            public PodPropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.NodeRangePropertyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NodeRangePropertyProperty
    extends JsiiSerializable {
        @NotNull
        public String getTargetNodes();

        @Nullable
        default public Object getConsumableResourceProperties() {
            return null;
        }

        @Nullable
        default public Object getContainer() {
            return null;
        }

        @Nullable
        default public Object getEcsProperties() {
            return null;
        }

        @Nullable
        default public Object getEksProperties() {
            return null;
        }

        @Nullable
        default public List<String> getInstanceTypes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NodeRangePropertyProperty> {
            String targetNodes;
            Object consumableResourceProperties;
            Object container;
            Object ecsProperties;
            Object eksProperties;
            List<String> instanceTypes;

            public Builder targetNodes(String targetNodes) {
                this.targetNodes = targetNodes;
                return this;
            }

            public Builder consumableResourceProperties(IResolvable consumableResourceProperties) {
                this.consumableResourceProperties = consumableResourceProperties;
                return this;
            }

            public Builder consumableResourceProperties(ConsumableResourcePropertiesProperty consumableResourceProperties) {
                this.consumableResourceProperties = consumableResourceProperties;
                return this;
            }

            public Builder container(IResolvable container) {
                this.container = container;
                return this;
            }

            public Builder container(ContainerPropertiesProperty container) {
                this.container = container;
                return this;
            }

            public Builder ecsProperties(IResolvable ecsProperties) {
                this.ecsProperties = ecsProperties;
                return this;
            }

            public Builder ecsProperties(MultiNodeEcsPropertiesProperty ecsProperties) {
                this.ecsProperties = ecsProperties;
                return this;
            }

            public Builder eksProperties(IResolvable eksProperties) {
                this.eksProperties = eksProperties;
                return this;
            }

            public Builder eksProperties(EksPropertiesProperty eksProperties) {
                this.eksProperties = eksProperties;
                return this;
            }

            public Builder instanceTypes(List<String> instanceTypes) {
                this.instanceTypes = instanceTypes;
                return this;
            }

            public NodeRangePropertyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.NodePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NodePropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMainNode();

        @NotNull
        public Object getNodeRangeProperties();

        @NotNull
        public Number getNumNodes();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NodePropertiesProperty> {
            Number mainNode;
            Object nodeRangeProperties;
            Number numNodes;

            public Builder mainNode(Number mainNode) {
                this.mainNode = mainNode;
                return this;
            }

            public Builder nodeRangeProperties(IResolvable nodeRangeProperties) {
                this.nodeRangeProperties = nodeRangeProperties;
                return this;
            }

            public Builder nodeRangeProperties(List<? extends Object> nodeRangeProperties) {
                this.nodeRangeProperties = nodeRangeProperties;
                return this;
            }

            public Builder numNodes(Number numNodes) {
                this.numNodes = numNodes;
                return this;
            }

            public NodePropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface NetworkConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAssignPublicIp() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            String assignPublicIp;

            public Builder assignPublicIp(String assignPublicIp) {
                this.assignPublicIp = assignPublicIp;
                return this;
            }

            public NetworkConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.MultiNodeEcsTaskPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MultiNodeEcsTaskPropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getContainers() {
            return null;
        }

        @Nullable
        default public Object getEnableExecuteCommand() {
            return null;
        }

        @Nullable
        default public String getExecutionRoleArn() {
            return null;
        }

        @Nullable
        default public String getIpcMode() {
            return null;
        }

        @Nullable
        default public String getPidMode() {
            return null;
        }

        @Nullable
        default public String getTaskRoleArn() {
            return null;
        }

        @Nullable
        default public Object getVolumes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MultiNodeEcsTaskPropertiesProperty> {
            Object containers;
            Object enableExecuteCommand;
            String executionRoleArn;
            String ipcMode;
            String pidMode;
            String taskRoleArn;
            Object volumes;

            public Builder containers(IResolvable containers) {
                this.containers = containers;
                return this;
            }

            public Builder containers(List<? extends Object> containers) {
                this.containers = containers;
                return this;
            }

            public Builder enableExecuteCommand(Boolean enableExecuteCommand) {
                this.enableExecuteCommand = enableExecuteCommand;
                return this;
            }

            public Builder enableExecuteCommand(IResolvable enableExecuteCommand) {
                this.enableExecuteCommand = enableExecuteCommand;
                return this;
            }

            public Builder executionRoleArn(String executionRoleArn) {
                this.executionRoleArn = executionRoleArn;
                return this;
            }

            public Builder ipcMode(String ipcMode) {
                this.ipcMode = ipcMode;
                return this;
            }

            public Builder pidMode(String pidMode) {
                this.pidMode = pidMode;
                return this;
            }

            public Builder taskRoleArn(String taskRoleArn) {
                this.taskRoleArn = taskRoleArn;
                return this;
            }

            public Builder volumes(IResolvable volumes) {
                this.volumes = volumes;
                return this;
            }

            public Builder volumes(List<? extends Object> volumes) {
                this.volumes = volumes;
                return this;
            }

            public MultiNodeEcsTaskPropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.MultiNodeEcsPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MultiNodeEcsPropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public Object getTaskProperties();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MultiNodeEcsPropertiesProperty> {
            Object taskProperties;

            public Builder taskProperties(IResolvable taskProperties) {
                this.taskProperties = taskProperties;
                return this;
            }

            public Builder taskProperties(List<? extends Object> taskProperties) {
                this.taskProperties = taskProperties;
                return this;
            }

            public MultiNodeEcsPropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.MountPointsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MountPointsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContainerPath() {
            return null;
        }

        @Nullable
        default public Object getReadOnly() {
            return null;
        }

        @Nullable
        default public String getSourceVolume() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MountPointsProperty> {
            String containerPath;
            Object readOnly;
            String sourceVolume;

            public Builder containerPath(String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            public Builder readOnly(Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            public Builder readOnly(IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            public Builder sourceVolume(String sourceVolume) {
                this.sourceVolume = sourceVolume;
                return this;
            }

            public MountPointsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.MountPointProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MountPointProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContainerPath() {
            return null;
        }

        @Nullable
        default public Object getReadOnly() {
            return null;
        }

        @Nullable
        default public String getSourceVolume() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MountPointProperty> {
            String containerPath;
            Object readOnly;
            String sourceVolume;

            public Builder containerPath(String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            public Builder readOnly(Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            public Builder readOnly(IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            public Builder sourceVolume(String sourceVolume) {
                this.sourceVolume = sourceVolume;
                return this;
            }

            public MountPointProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.MetadataProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface MetadataProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getLabels() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<MetadataProperty> {
            Object labels;

            public Builder labels(Object labels) {
                this.labels = labels;
                return this;
            }

            public MetadataProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.LogConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LogConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getLogDriver();

        @Nullable
        default public Object getOptions() {
            return null;
        }

        @Nullable
        default public Object getSecretOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LogConfigurationProperty> {
            String logDriver;
            Object options;
            Object secretOptions;

            public Builder logDriver(String logDriver) {
                this.logDriver = logDriver;
                return this;
            }

            public Builder options(Object options) {
                this.options = options;
                return this;
            }

            public Builder secretOptions(IResolvable secretOptions) {
                this.secretOptions = secretOptions;
                return this;
            }

            public Builder secretOptions(List<? extends Object> secretOptions) {
                this.secretOptions = secretOptions;
                return this;
            }

            public LogConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.LinuxParametersProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LinuxParametersProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getDevices() {
            return null;
        }

        @Nullable
        default public Object getInitProcessEnabled() {
            return null;
        }

        @Nullable
        default public Number getMaxSwap() {
            return null;
        }

        @Nullable
        default public Number getSharedMemorySize() {
            return null;
        }

        @Nullable
        default public Number getSwappiness() {
            return null;
        }

        @Nullable
        default public Object getTmpfs() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LinuxParametersProperty> {
            Object devices;
            Object initProcessEnabled;
            Number maxSwap;
            Number sharedMemorySize;
            Number swappiness;
            Object tmpfs;

            public Builder devices(IResolvable devices) {
                this.devices = devices;
                return this;
            }

            public Builder devices(List<? extends Object> devices) {
                this.devices = devices;
                return this;
            }

            public Builder initProcessEnabled(Boolean initProcessEnabled) {
                this.initProcessEnabled = initProcessEnabled;
                return this;
            }

            public Builder initProcessEnabled(IResolvable initProcessEnabled) {
                this.initProcessEnabled = initProcessEnabled;
                return this;
            }

            public Builder maxSwap(Number maxSwap) {
                this.maxSwap = maxSwap;
                return this;
            }

            public Builder sharedMemorySize(Number sharedMemorySize) {
                this.sharedMemorySize = sharedMemorySize;
                return this;
            }

            public Builder swappiness(Number swappiness) {
                this.swappiness = swappiness;
                return this;
            }

            public Builder tmpfs(IResolvable tmpfs) {
                this.tmpfs = tmpfs;
                return this;
            }

            public Builder tmpfs(List<? extends Object> tmpfs) {
                this.tmpfs = tmpfs;
                return this;
            }

            public LinuxParametersProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.JobTimeoutProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface JobTimeoutProperty
    extends JsiiSerializable {
        @Nullable
        default public Number getAttemptDurationSeconds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<JobTimeoutProperty> {
            Number attemptDurationSeconds;

            public Builder attemptDurationSeconds(Number attemptDurationSeconds) {
                this.attemptDurationSeconds = attemptDurationSeconds;
                return this;
            }

            public JobTimeoutProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.ImagePullSecretProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ImagePullSecretProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ImagePullSecretProperty> {
            String name;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public ImagePullSecretProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.HostPathProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface HostPathProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<HostPathProperty> {
            String path;

            public Builder path(String path) {
                this.path = path;
                return this;
            }

            public HostPathProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.FirelensConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FirelensConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getType();

        @Nullable
        default public Object getOptions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FirelensConfigurationProperty> {
            String type;
            Object options;

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public Builder options(Map<String, String> options) {
                this.options = options;
                return this;
            }

            public Builder options(IResolvable options) {
                this.options = options;
                return this;
            }

            public FirelensConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.FargatePlatformConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FargatePlatformConfigurationProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPlatformVersion() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FargatePlatformConfigurationProperty> {
            String platformVersion;

            public Builder platformVersion(String platformVersion) {
                this.platformVersion = platformVersion;
                return this;
            }

            public FargatePlatformConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.EvaluateOnExitProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EvaluateOnExitProperty
    extends JsiiSerializable {
        @NotNull
        public String getAction();

        @Nullable
        default public String getOnExitCode() {
            return null;
        }

        @Nullable
        default public String getOnReason() {
            return null;
        }

        @Nullable
        default public String getOnStatusReason() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EvaluateOnExitProperty> {
            String action;
            String onExitCode;
            String onReason;
            String onStatusReason;

            public Builder action(String action) {
                this.action = action;
                return this;
            }

            public Builder onExitCode(String onExitCode) {
                this.onExitCode = onExitCode;
                return this;
            }

            public Builder onReason(String onReason) {
                this.onReason = onReason;
                return this;
            }

            public Builder onStatusReason(String onStatusReason) {
                this.onStatusReason = onStatusReason;
                return this;
            }

            public EvaluateOnExitProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.EphemeralStorageProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EphemeralStorageProperty
    extends JsiiSerializable {
        @NotNull
        public Number getSizeInGiB();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EphemeralStorageProperty> {
            Number sizeInGiB;

            public Builder sizeInGiB(Number sizeInGiB) {
                this.sizeInGiB = sizeInGiB;
                return this;
            }

            public EphemeralStorageProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.EnvironmentProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EnvironmentProperty
    extends JsiiSerializable {
        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EnvironmentProperty> {
            String name;
            String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public EnvironmentProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.EmptyDirProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EmptyDirProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMedium() {
            return null;
        }

        @Nullable
        default public String getSizeLimit() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EmptyDirProperty> {
            String medium;
            String sizeLimit;

            public Builder medium(String medium) {
                this.medium = medium;
                return this;
            }

            public Builder sizeLimit(String sizeLimit) {
                this.sizeLimit = sizeLimit;
                return this;
            }

            public EmptyDirProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.EksVolumeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EksVolumeProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @Nullable
        default public Object getEmptyDir() {
            return null;
        }

        @Nullable
        default public Object getHostPath() {
            return null;
        }

        @Nullable
        default public Object getPersistentVolumeClaim() {
            return null;
        }

        @Nullable
        default public Object getSecret() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EksVolumeProperty> {
            String name;
            Object emptyDir;
            Object hostPath;
            Object persistentVolumeClaim;
            Object secret;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder emptyDir(IResolvable emptyDir) {
                this.emptyDir = emptyDir;
                return this;
            }

            public Builder emptyDir(EmptyDirProperty emptyDir) {
                this.emptyDir = emptyDir;
                return this;
            }

            public Builder hostPath(IResolvable hostPath) {
                this.hostPath = hostPath;
                return this;
            }

            public Builder hostPath(HostPathProperty hostPath) {
                this.hostPath = hostPath;
                return this;
            }

            public Builder persistentVolumeClaim(IResolvable persistentVolumeClaim) {
                this.persistentVolumeClaim = persistentVolumeClaim;
                return this;
            }

            public Builder persistentVolumeClaim(EksPersistentVolumeClaimProperty persistentVolumeClaim) {
                this.persistentVolumeClaim = persistentVolumeClaim;
                return this;
            }

            public Builder secret(IResolvable secret) {
                this.secret = secret;
                return this;
            }

            public Builder secret(EksSecretProperty secret) {
                this.secret = secret;
                return this;
            }

            public EksVolumeProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.EksSecretProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EksSecretProperty
    extends JsiiSerializable {
        @NotNull
        public String getSecretName();

        @Nullable
        default public Object getOptional() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EksSecretProperty> {
            String secretName;
            Object optional;

            public Builder secretName(String secretName) {
                this.secretName = secretName;
                return this;
            }

            public Builder optional(Boolean optional) {
                this.optional = optional;
                return this;
            }

            public Builder optional(IResolvable optional) {
                this.optional = optional;
                return this;
            }

            public EksSecretProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.EksPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EksPropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getPodProperties() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EksPropertiesProperty> {
            Object podProperties;

            public Builder podProperties(IResolvable podProperties) {
                this.podProperties = podProperties;
                return this;
            }

            public Builder podProperties(PodPropertiesProperty podProperties) {
                this.podProperties = podProperties;
                return this;
            }

            public EksPropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.EksPersistentVolumeClaimProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EksPersistentVolumeClaimProperty
    extends JsiiSerializable {
        @NotNull
        public String getClaimName();

        @Nullable
        default public Object getReadOnly() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EksPersistentVolumeClaimProperty> {
            String claimName;
            Object readOnly;

            public Builder claimName(String claimName) {
                this.claimName = claimName;
                return this;
            }

            public Builder readOnly(Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            public Builder readOnly(IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            public EksPersistentVolumeClaimProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.EksContainerVolumeMountProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EksContainerVolumeMountProperty
    extends JsiiSerializable {
        @Nullable
        default public String getMountPath() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getReadOnly() {
            return null;
        }

        @Nullable
        default public String getSubPath() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EksContainerVolumeMountProperty> {
            String mountPath;
            String name;
            Object readOnly;
            String subPath;

            public Builder mountPath(String mountPath) {
                this.mountPath = mountPath;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder readOnly(Boolean readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            public Builder readOnly(IResolvable readOnly) {
                this.readOnly = readOnly;
                return this;
            }

            public Builder subPath(String subPath) {
                this.subPath = subPath;
                return this;
            }

            public EksContainerVolumeMountProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.EksContainerProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EksContainerProperty
    extends JsiiSerializable {
        @NotNull
        public String getImage();

        @Nullable
        default public List<String> getArgs() {
            return null;
        }

        @Nullable
        default public List<String> getCommand() {
            return null;
        }

        @Nullable
        default public Object getEnv() {
            return null;
        }

        @Nullable
        default public String getImagePullPolicy() {
            return null;
        }

        @Nullable
        default public String getName() {
            return null;
        }

        @Nullable
        default public Object getResources() {
            return null;
        }

        @Nullable
        default public Object getSecurityContext() {
            return null;
        }

        @Nullable
        default public Object getVolumeMounts() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EksContainerProperty> {
            String image;
            List<String> args;
            List<String> command;
            Object env;
            String imagePullPolicy;
            String name;
            Object resources;
            Object securityContext;
            Object volumeMounts;

            public Builder image(String image) {
                this.image = image;
                return this;
            }

            public Builder args(List<String> args) {
                this.args = args;
                return this;
            }

            public Builder command(List<String> command) {
                this.command = command;
                return this;
            }

            public Builder env(IResolvable env) {
                this.env = env;
                return this;
            }

            public Builder env(List<? extends Object> env) {
                this.env = env;
                return this;
            }

            public Builder imagePullPolicy(String imagePullPolicy) {
                this.imagePullPolicy = imagePullPolicy;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder resources(IResolvable resources) {
                this.resources = resources;
                return this;
            }

            public Builder resources(ResourcesProperty resources) {
                this.resources = resources;
                return this;
            }

            public Builder securityContext(IResolvable securityContext) {
                this.securityContext = securityContext;
                return this;
            }

            public Builder securityContext(SecurityContextProperty securityContext) {
                this.securityContext = securityContext;
                return this;
            }

            public Builder volumeMounts(IResolvable volumeMounts) {
                this.volumeMounts = volumeMounts;
                return this;
            }

            public Builder volumeMounts(List<? extends Object> volumeMounts) {
                this.volumeMounts = volumeMounts;
                return this;
            }

            public EksContainerProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.EksContainerEnvironmentVariableProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EksContainerEnvironmentVariableProperty
    extends JsiiSerializable {
        @NotNull
        public String getName();

        @Nullable
        default public String getValue() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EksContainerEnvironmentVariableProperty> {
            String name;
            String value;

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public EksContainerEnvironmentVariableProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.EfsVolumeConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EfsVolumeConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public String getFileSystemId();

        @Nullable
        default public Object getAuthorizationConfig() {
            return null;
        }

        @Nullable
        default public String getRootDirectory() {
            return null;
        }

        @Nullable
        default public String getTransitEncryption() {
            return null;
        }

        @Nullable
        default public Number getTransitEncryptionPort() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EfsVolumeConfigurationProperty> {
            String fileSystemId;
            Object authorizationConfig;
            String rootDirectory;
            String transitEncryption;
            Number transitEncryptionPort;

            public Builder fileSystemId(String fileSystemId) {
                this.fileSystemId = fileSystemId;
                return this;
            }

            public Builder authorizationConfig(IResolvable authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            public Builder authorizationConfig(AuthorizationConfigProperty authorizationConfig) {
                this.authorizationConfig = authorizationConfig;
                return this;
            }

            public Builder rootDirectory(String rootDirectory) {
                this.rootDirectory = rootDirectory;
                return this;
            }

            public Builder transitEncryption(String transitEncryption) {
                this.transitEncryption = transitEncryption;
                return this;
            }

            public Builder transitEncryptionPort(Number transitEncryptionPort) {
                this.transitEncryptionPort = transitEncryptionPort;
                return this;
            }

            public EfsVolumeConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.EcsTaskPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EcsTaskPropertiesProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getContainers() {
            return null;
        }

        @Nullable
        default public Object getEnableExecuteCommand() {
            return null;
        }

        @Nullable
        default public Object getEphemeralStorage() {
            return null;
        }

        @Nullable
        default public String getExecutionRoleArn() {
            return null;
        }

        @Nullable
        default public String getIpcMode() {
            return null;
        }

        @Nullable
        default public Object getNetworkConfiguration() {
            return null;
        }

        @Nullable
        default public String getPidMode() {
            return null;
        }

        @Nullable
        default public String getPlatformVersion() {
            return null;
        }

        @Nullable
        default public Object getRuntimePlatform() {
            return null;
        }

        @Nullable
        default public String getTaskRoleArn() {
            return null;
        }

        @Nullable
        default public Object getVolumes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EcsTaskPropertiesProperty> {
            Object containers;
            Object enableExecuteCommand;
            Object ephemeralStorage;
            String executionRoleArn;
            String ipcMode;
            Object networkConfiguration;
            String pidMode;
            String platformVersion;
            Object runtimePlatform;
            String taskRoleArn;
            Object volumes;

            public Builder containers(IResolvable containers) {
                this.containers = containers;
                return this;
            }

            public Builder containers(List<? extends Object> containers) {
                this.containers = containers;
                return this;
            }

            public Builder enableExecuteCommand(Boolean enableExecuteCommand) {
                this.enableExecuteCommand = enableExecuteCommand;
                return this;
            }

            public Builder enableExecuteCommand(IResolvable enableExecuteCommand) {
                this.enableExecuteCommand = enableExecuteCommand;
                return this;
            }

            public Builder ephemeralStorage(IResolvable ephemeralStorage) {
                this.ephemeralStorage = ephemeralStorage;
                return this;
            }

            public Builder ephemeralStorage(EphemeralStorageProperty ephemeralStorage) {
                this.ephemeralStorage = ephemeralStorage;
                return this;
            }

            public Builder executionRoleArn(String executionRoleArn) {
                this.executionRoleArn = executionRoleArn;
                return this;
            }

            public Builder ipcMode(String ipcMode) {
                this.ipcMode = ipcMode;
                return this;
            }

            public Builder networkConfiguration(IResolvable networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            public Builder networkConfiguration(NetworkConfigurationProperty networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            public Builder pidMode(String pidMode) {
                this.pidMode = pidMode;
                return this;
            }

            public Builder platformVersion(String platformVersion) {
                this.platformVersion = platformVersion;
                return this;
            }

            public Builder runtimePlatform(IResolvable runtimePlatform) {
                this.runtimePlatform = runtimePlatform;
                return this;
            }

            public Builder runtimePlatform(RuntimePlatformProperty runtimePlatform) {
                this.runtimePlatform = runtimePlatform;
                return this;
            }

            public Builder taskRoleArn(String taskRoleArn) {
                this.taskRoleArn = taskRoleArn;
                return this;
            }

            public Builder volumes(IResolvable volumes) {
                this.volumes = volumes;
                return this;
            }

            public Builder volumes(List<? extends Object> volumes) {
                this.volumes = volumes;
                return this;
            }

            public EcsTaskPropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.EcsPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EcsPropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public Object getTaskProperties();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EcsPropertiesProperty> {
            Object taskProperties;

            public Builder taskProperties(IResolvable taskProperties) {
                this.taskProperties = taskProperties;
                return this;
            }

            public Builder taskProperties(List<? extends Object> taskProperties) {
                this.taskProperties = taskProperties;
                return this;
            }

            public EcsPropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.DeviceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DeviceProperty
    extends JsiiSerializable {
        @Nullable
        default public String getContainerPath() {
            return null;
        }

        @Nullable
        default public String getHostPath() {
            return null;
        }

        @Nullable
        default public List<String> getPermissions() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DeviceProperty> {
            String containerPath;
            String hostPath;
            List<String> permissions;

            public Builder containerPath(String containerPath) {
                this.containerPath = containerPath;
                return this;
            }

            public Builder hostPath(String hostPath) {
                this.hostPath = hostPath;
                return this;
            }

            public Builder permissions(List<String> permissions) {
                this.permissions = permissions;
                return this;
            }

            public DeviceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.ContainerPropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ContainerPropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public String getImage();

        @Nullable
        default public List<String> getCommand() {
            return null;
        }

        @Nullable
        default public Object getEnableExecuteCommand() {
            return null;
        }

        @Nullable
        default public Object getEnvironment() {
            return null;
        }

        @Nullable
        default public Object getEphemeralStorage() {
            return null;
        }

        @Nullable
        default public String getExecutionRoleArn() {
            return null;
        }

        @Nullable
        default public Object getFargatePlatformConfiguration() {
            return null;
        }

        @Nullable
        default public String getInstanceType() {
            return null;
        }

        @Nullable
        default public String getJobRoleArn() {
            return null;
        }

        @Nullable
        default public Object getLinuxParameters() {
            return null;
        }

        @Nullable
        default public Object getLogConfiguration() {
            return null;
        }

        @Nullable
        default public Number getMemory() {
            return null;
        }

        @Nullable
        default public Object getMountPoints() {
            return null;
        }

        @Nullable
        default public Object getNetworkConfiguration() {
            return null;
        }

        @Nullable
        default public Object getPrivileged() {
            return null;
        }

        @Nullable
        default public Object getReadonlyRootFilesystem() {
            return null;
        }

        @Nullable
        default public Object getRepositoryCredentials() {
            return null;
        }

        @Nullable
        default public Object getResourceRequirements() {
            return null;
        }

        @Nullable
        default public Object getRuntimePlatform() {
            return null;
        }

        @Nullable
        default public Object getSecrets() {
            return null;
        }

        @Nullable
        default public Object getUlimits() {
            return null;
        }

        @Nullable
        default public String getUser() {
            return null;
        }

        @Nullable
        default public Number getVcpus() {
            return null;
        }

        @Nullable
        default public Object getVolumes() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ContainerPropertiesProperty> {
            String image;
            List<String> command;
            Object enableExecuteCommand;
            Object environment;
            Object ephemeralStorage;
            String executionRoleArn;
            Object fargatePlatformConfiguration;
            String instanceType;
            String jobRoleArn;
            Object linuxParameters;
            Object logConfiguration;
            Number memory;
            Object mountPoints;
            Object networkConfiguration;
            Object privileged;
            Object readonlyRootFilesystem;
            Object repositoryCredentials;
            Object resourceRequirements;
            Object runtimePlatform;
            Object secrets;
            Object ulimits;
            String user;
            Number vcpus;
            Object volumes;

            public Builder image(String image) {
                this.image = image;
                return this;
            }

            public Builder command(List<String> command) {
                this.command = command;
                return this;
            }

            public Builder enableExecuteCommand(Boolean enableExecuteCommand) {
                this.enableExecuteCommand = enableExecuteCommand;
                return this;
            }

            public Builder enableExecuteCommand(IResolvable enableExecuteCommand) {
                this.enableExecuteCommand = enableExecuteCommand;
                return this;
            }

            public Builder environment(IResolvable environment) {
                this.environment = environment;
                return this;
            }

            public Builder environment(List<? extends Object> environment) {
                this.environment = environment;
                return this;
            }

            public Builder ephemeralStorage(IResolvable ephemeralStorage) {
                this.ephemeralStorage = ephemeralStorage;
                return this;
            }

            public Builder ephemeralStorage(EphemeralStorageProperty ephemeralStorage) {
                this.ephemeralStorage = ephemeralStorage;
                return this;
            }

            public Builder executionRoleArn(String executionRoleArn) {
                this.executionRoleArn = executionRoleArn;
                return this;
            }

            public Builder fargatePlatformConfiguration(IResolvable fargatePlatformConfiguration) {
                this.fargatePlatformConfiguration = fargatePlatformConfiguration;
                return this;
            }

            public Builder fargatePlatformConfiguration(FargatePlatformConfigurationProperty fargatePlatformConfiguration) {
                this.fargatePlatformConfiguration = fargatePlatformConfiguration;
                return this;
            }

            public Builder instanceType(String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            public Builder jobRoleArn(String jobRoleArn) {
                this.jobRoleArn = jobRoleArn;
                return this;
            }

            public Builder linuxParameters(IResolvable linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            public Builder linuxParameters(LinuxParametersProperty linuxParameters) {
                this.linuxParameters = linuxParameters;
                return this;
            }

            public Builder logConfiguration(IResolvable logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            public Builder logConfiguration(LogConfigurationProperty logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            public Builder memory(Number memory) {
                this.memory = memory;
                return this;
            }

            public Builder mountPoints(IResolvable mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            public Builder mountPoints(List<? extends Object> mountPoints) {
                this.mountPoints = mountPoints;
                return this;
            }

            public Builder networkConfiguration(IResolvable networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            public Builder networkConfiguration(NetworkConfigurationProperty networkConfiguration) {
                this.networkConfiguration = networkConfiguration;
                return this;
            }

            public Builder privileged(Boolean privileged) {
                this.privileged = privileged;
                return this;
            }

            public Builder privileged(IResolvable privileged) {
                this.privileged = privileged;
                return this;
            }

            public Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            public Builder readonlyRootFilesystem(IResolvable readonlyRootFilesystem) {
                this.readonlyRootFilesystem = readonlyRootFilesystem;
                return this;
            }

            public Builder repositoryCredentials(IResolvable repositoryCredentials) {
                this.repositoryCredentials = repositoryCredentials;
                return this;
            }

            public Builder repositoryCredentials(RepositoryCredentialsProperty repositoryCredentials) {
                this.repositoryCredentials = repositoryCredentials;
                return this;
            }

            public Builder resourceRequirements(IResolvable resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            public Builder resourceRequirements(List<? extends Object> resourceRequirements) {
                this.resourceRequirements = resourceRequirements;
                return this;
            }

            public Builder runtimePlatform(IResolvable runtimePlatform) {
                this.runtimePlatform = runtimePlatform;
                return this;
            }

            public Builder runtimePlatform(RuntimePlatformProperty runtimePlatform) {
                this.runtimePlatform = runtimePlatform;
                return this;
            }

            public Builder secrets(IResolvable secrets) {
                this.secrets = secrets;
                return this;
            }

            public Builder secrets(List<? extends Object> secrets) {
                this.secrets = secrets;
                return this;
            }

            public Builder ulimits(IResolvable ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            public Builder ulimits(List<? extends Object> ulimits) {
                this.ulimits = ulimits;
                return this;
            }

            public Builder user(String user) {
                this.user = user;
                return this;
            }

            public Builder vcpus(Number vcpus) {
                this.vcpus = vcpus;
                return this;
            }

            public Builder volumes(IResolvable volumes) {
                this.volumes = volumes;
                return this;
            }

            public Builder volumes(List<? extends Object> volumes) {
                this.volumes = volumes;
                return this;
            }

            public ContainerPropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.ConsumableResourceRequirementProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConsumableResourceRequirementProperty
    extends JsiiSerializable {
        @NotNull
        public String getConsumableResource();

        @NotNull
        public Number getQuantity();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConsumableResourceRequirementProperty> {
            String consumableResource;
            Number quantity;

            public Builder consumableResource(String consumableResource) {
                this.consumableResource = consumableResource;
                return this;
            }

            public Builder quantity(Number quantity) {
                this.quantity = quantity;
                return this;
            }

            public ConsumableResourceRequirementProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.ConsumableResourcePropertiesProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ConsumableResourcePropertiesProperty
    extends JsiiSerializable {
        @NotNull
        public Object getConsumableResourceList();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ConsumableResourcePropertiesProperty> {
            Object consumableResourceList;

            public Builder consumableResourceList(IResolvable consumableResourceList) {
                this.consumableResourceList = consumableResourceList;
                return this;
            }

            public Builder consumableResourceList(List<? extends Object> consumableResourceList) {
                this.consumableResourceList = consumableResourceList;
                return this;
            }

            public ConsumableResourcePropertiesProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_batch.CfnJobDefinition.AuthorizationConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AuthorizationConfigProperty
    extends JsiiSerializable {
        @Nullable
        default public String getAccessPointId() {
            return null;
        }

        @Nullable
        default public String getIam() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AuthorizationConfigProperty> {
            String accessPointId;
            String iam;

            public Builder accessPointId(String accessPointId) {
                this.accessPointId = accessPointId;
                return this;
            }

            public Builder iam(String iam) {
                this.iam = iam;
                return this;
            }

            public AuthorizationConfigProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

