/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.dynamodb;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.services.dynamodb.Attribute;
import software.amazon.awscdk.services.dynamodb.Billing;
import software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexPropsV2;
import software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps;
import software.amazon.awscdk.services.dynamodb.PointInTimeRecoverySpecification;
import software.amazon.awscdk.services.dynamodb.ReplicaTableProps;
import software.amazon.awscdk.services.dynamodb.StreamViewType;
import software.amazon.awscdk.services.dynamodb.TableClass;
import software.amazon.awscdk.services.dynamodb.TableEncryptionV2;
import software.amazon.awscdk.services.dynamodb.TableOptionsV2;
import software.amazon.awscdk.services.dynamodb.TablePropsV2;
import software.amazon.awscdk.services.dynamodb.WarmThroughput;
import software.amazon.awscdk.services.iam.PolicyDocument;
import software.amazon.awscdk.services.kinesis.IStream;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_dynamodb.TablePropsV2")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface TablePropsV2
extends JsiiSerializable,
TableOptionsV2 {
    @NotNull
    public Attribute getPartitionKey();

    @Nullable
    default public Billing getBilling() {
        return null;
    }

    @Nullable
    default public StreamViewType getDynamoStream() {
        return null;
    }

    @Nullable
    default public TableEncryptionV2 getEncryption() {
        return null;
    }

    @Nullable
    default public List<GlobalSecondaryIndexPropsV2> getGlobalSecondaryIndexes() {
        return null;
    }

    @Nullable
    default public List<LocalSecondaryIndexProps> getLocalSecondaryIndexes() {
        return null;
    }

    @Nullable
    default public RemovalPolicy getRemovalPolicy() {
        return null;
    }

    @Nullable
    default public List<ReplicaTableProps> getReplicas() {
        return null;
    }

    @Nullable
    default public Attribute getSortKey() {
        return null;
    }

    @Nullable
    default public String getTableName() {
        return null;
    }

    @Nullable
    default public String getTimeToLiveAttribute() {
        return null;
    }

    @Nullable
    default public WarmThroughput getWarmThroughput() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<TablePropsV2> {
        Attribute partitionKey;
        Billing billing;
        StreamViewType dynamoStream;
        TableEncryptionV2 encryption;
        List<GlobalSecondaryIndexPropsV2> globalSecondaryIndexes;
        List<LocalSecondaryIndexProps> localSecondaryIndexes;
        RemovalPolicy removalPolicy;
        List<ReplicaTableProps> replicas;
        Attribute sortKey;
        String tableName;
        String timeToLiveAttribute;
        WarmThroughput warmThroughput;
        Boolean contributorInsights;
        Boolean deletionProtection;
        IStream kinesisStream;
        Boolean pointInTimeRecovery;
        PointInTimeRecoverySpecification pointInTimeRecoverySpecification;
        PolicyDocument resourcePolicy;
        TableClass tableClass;
        List<CfnTag> tags;

        public Builder partitionKey(Attribute partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public Builder billing(Billing billing) {
            this.billing = billing;
            return this;
        }

        public Builder dynamoStream(StreamViewType dynamoStream) {
            this.dynamoStream = dynamoStream;
            return this;
        }

        public Builder encryption(TableEncryptionV2 encryption) {
            this.encryption = encryption;
            return this;
        }

        public Builder globalSecondaryIndexes(List<? extends GlobalSecondaryIndexPropsV2> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = globalSecondaryIndexes;
            return this;
        }

        public Builder localSecondaryIndexes(List<? extends LocalSecondaryIndexProps> localSecondaryIndexes) {
            this.localSecondaryIndexes = localSecondaryIndexes;
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        public Builder replicas(List<? extends ReplicaTableProps> replicas) {
            this.replicas = replicas;
            return this;
        }

        public Builder sortKey(Attribute sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder timeToLiveAttribute(String timeToLiveAttribute) {
            this.timeToLiveAttribute = timeToLiveAttribute;
            return this;
        }

        public Builder warmThroughput(WarmThroughput warmThroughput) {
            this.warmThroughput = warmThroughput;
            return this;
        }

        public Builder contributorInsights(Boolean contributorInsights) {
            this.contributorInsights = contributorInsights;
            return this;
        }

        public Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public Builder kinesisStream(IStream kinesisStream) {
            this.kinesisStream = kinesisStream;
            return this;
        }

        @Deprecated
        public Builder pointInTimeRecovery(Boolean pointInTimeRecovery) {
            this.pointInTimeRecovery = pointInTimeRecovery;
            return this;
        }

        public Builder pointInTimeRecoverySpecification(PointInTimeRecoverySpecification pointInTimeRecoverySpecification) {
            this.pointInTimeRecoverySpecification = pointInTimeRecoverySpecification;
            return this;
        }

        public Builder resourcePolicy(PolicyDocument resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        public Builder tableClass(TableClass tableClass) {
            this.tableClass = tableClass;
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        public TablePropsV2 build() {
            return new Jsii.Proxy(this);
        }
    }
}

