/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kafkaconnect;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.CfnTag;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.kafkaconnect.CfnConnector;
import software.amazon.awscdk.services.kafkaconnect.CfnConnectorProps;
import software.amazon.jsii.Configuration;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector")
public class CfnConnector
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnConnector.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnConnector(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConnector(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnConnector(@NotNull Construct scope, @NotNull String id, @NotNull CfnConnectorProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrConnectorArn() {
        return (String)Kernel.get((Object)this, (String)"attrConnectorArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getCapacity() {
        return Kernel.get((Object)this, (String)"capacity", (NativeType)NativeType.forClass(Object.class));
    }

    public void setCapacity(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"capacity", (Object)Objects.requireNonNull(value, "capacity is required"));
    }

    public void setCapacity(@NotNull CapacityProperty value) {
        Kernel.set((Object)this, (String)"capacity", (Object)Objects.requireNonNull(value, "capacity is required"));
    }

    @NotNull
    public Object getConnectorConfiguration() {
        return Kernel.get((Object)this, (String)"connectorConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setConnectorConfiguration(@NotNull Map<String, String> value) {
        Kernel.set((Object)this, (String)"connectorConfiguration", Objects.requireNonNull(value, "connectorConfiguration is required"));
    }

    public void setConnectorConfiguration(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"connectorConfiguration", (Object)Objects.requireNonNull(value, "connectorConfiguration is required"));
    }

    @NotNull
    public String getConnectorName() {
        return (String)Kernel.get((Object)this, (String)"connectorName", (NativeType)NativeType.forClass(String.class));
    }

    public void setConnectorName(@NotNull String value) {
        Kernel.set((Object)this, (String)"connectorName", (Object)Objects.requireNonNull(value, "connectorName is required"));
    }

    @NotNull
    public Object getKafkaCluster() {
        return Kernel.get((Object)this, (String)"kafkaCluster", (NativeType)NativeType.forClass(Object.class));
    }

    public void setKafkaCluster(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"kafkaCluster", (Object)Objects.requireNonNull(value, "kafkaCluster is required"));
    }

    public void setKafkaCluster(@NotNull KafkaClusterProperty value) {
        Kernel.set((Object)this, (String)"kafkaCluster", (Object)Objects.requireNonNull(value, "kafkaCluster is required"));
    }

    @NotNull
    public Object getKafkaClusterClientAuthentication() {
        return Kernel.get((Object)this, (String)"kafkaClusterClientAuthentication", (NativeType)NativeType.forClass(Object.class));
    }

    public void setKafkaClusterClientAuthentication(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"kafkaClusterClientAuthentication", (Object)Objects.requireNonNull(value, "kafkaClusterClientAuthentication is required"));
    }

    public void setKafkaClusterClientAuthentication(@NotNull KafkaClusterClientAuthenticationProperty value) {
        Kernel.set((Object)this, (String)"kafkaClusterClientAuthentication", (Object)Objects.requireNonNull(value, "kafkaClusterClientAuthentication is required"));
    }

    @NotNull
    public Object getKafkaClusterEncryptionInTransit() {
        return Kernel.get((Object)this, (String)"kafkaClusterEncryptionInTransit", (NativeType)NativeType.forClass(Object.class));
    }

    public void setKafkaClusterEncryptionInTransit(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"kafkaClusterEncryptionInTransit", (Object)Objects.requireNonNull(value, "kafkaClusterEncryptionInTransit is required"));
    }

    public void setKafkaClusterEncryptionInTransit(@NotNull KafkaClusterEncryptionInTransitProperty value) {
        Kernel.set((Object)this, (String)"kafkaClusterEncryptionInTransit", (Object)Objects.requireNonNull(value, "kafkaClusterEncryptionInTransit is required"));
    }

    @NotNull
    public String getKafkaConnectVersion() {
        return (String)Kernel.get((Object)this, (String)"kafkaConnectVersion", (NativeType)NativeType.forClass(String.class));
    }

    public void setKafkaConnectVersion(@NotNull String value) {
        Kernel.set((Object)this, (String)"kafkaConnectVersion", (Object)Objects.requireNonNull(value, "kafkaConnectVersion is required"));
    }

    @NotNull
    public Object getPlugins() {
        return Kernel.get((Object)this, (String)"plugins", (NativeType)NativeType.forClass(Object.class));
    }

    public void setPlugins(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"plugins", (Object)Objects.requireNonNull(value, "plugins is required"));
    }

    public void setPlugins(@NotNull List<Object> value) {
        if (Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); ++__idx_ac66f0) {
                Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (__val_ac66f0 instanceof IResolvable || __val_ac66f0 instanceof PluginProperty || __val_ac66f0.getClass().equals(JsiiObject.class)) continue;
                throw new IllegalArgumentException("Expected " + "value" + ".get(" + __idx_ac66f0 + ")" + " to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.kafkaconnect.CfnConnector.PluginProperty; received " + __val_ac66f0.getClass());
            }
        }
        Kernel.set((Object)this, (String)"plugins", Objects.requireNonNull(value, "plugins is required"));
    }

    @NotNull
    public String getServiceExecutionRoleArn() {
        return (String)Kernel.get((Object)this, (String)"serviceExecutionRoleArn", (NativeType)NativeType.forClass(String.class));
    }

    public void setServiceExecutionRoleArn(@NotNull String value) {
        Kernel.set((Object)this, (String)"serviceExecutionRoleArn", (Object)Objects.requireNonNull(value, "serviceExecutionRoleArn is required"));
    }

    @Nullable
    public String getConnectorDescription() {
        return (String)Kernel.get((Object)this, (String)"connectorDescription", (NativeType)NativeType.forClass(String.class));
    }

    public void setConnectorDescription(@Nullable String value) {
        Kernel.set((Object)this, (String)"connectorDescription", (Object)value);
    }

    @Nullable
    public Object getLogDelivery() {
        return Kernel.get((Object)this, (String)"logDelivery", (NativeType)NativeType.forClass(Object.class));
    }

    public void setLogDelivery(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"logDelivery", (Object)value);
    }

    public void setLogDelivery(@Nullable LogDeliveryProperty value) {
        Kernel.set((Object)this, (String)"logDelivery", (Object)value);
    }

    @Nullable
    public List<CfnTag> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(CfnTag.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<CfnTag> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    @Nullable
    public Object getWorkerConfiguration() {
        return Kernel.get((Object)this, (String)"workerConfiguration", (NativeType)NativeType.forClass(Object.class));
    }

    public void setWorkerConfiguration(@Nullable IResolvable value) {
        Kernel.set((Object)this, (String)"workerConfiguration", (Object)value);
    }

    public void setWorkerConfiguration(@Nullable WorkerConfigurationProperty value) {
        Kernel.set((Object)this, (String)"workerConfiguration", (Object)value);
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.PluginProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface PluginProperty
    extends JsiiSerializable {
        @NotNull
        public Object getCustomPlugin();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<PluginProperty> {
            Object customPlugin;

            public Builder customPlugin(IResolvable customPlugin) {
                this.customPlugin = customPlugin;
                return this;
            }

            public Builder customPlugin(CustomPluginProperty customPlugin) {
                this.customPlugin = customPlugin;
                return this;
            }

            public PluginProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnConnector> {
        private final Construct scope;
        private final String id;
        private final CfnConnectorProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnConnectorProps.Builder();
        }

        public Builder capacity(IResolvable capacity) {
            this.props.capacity(capacity);
            return this;
        }

        public Builder capacity(CapacityProperty capacity) {
            this.props.capacity(capacity);
            return this;
        }

        public Builder connectorConfiguration(Map<String, String> connectorConfiguration) {
            this.props.connectorConfiguration(connectorConfiguration);
            return this;
        }

        public Builder connectorConfiguration(IResolvable connectorConfiguration) {
            this.props.connectorConfiguration(connectorConfiguration);
            return this;
        }

        public Builder connectorName(String connectorName) {
            this.props.connectorName(connectorName);
            return this;
        }

        public Builder kafkaCluster(IResolvable kafkaCluster) {
            this.props.kafkaCluster(kafkaCluster);
            return this;
        }

        public Builder kafkaCluster(KafkaClusterProperty kafkaCluster) {
            this.props.kafkaCluster(kafkaCluster);
            return this;
        }

        public Builder kafkaClusterClientAuthentication(IResolvable kafkaClusterClientAuthentication) {
            this.props.kafkaClusterClientAuthentication(kafkaClusterClientAuthentication);
            return this;
        }

        public Builder kafkaClusterClientAuthentication(KafkaClusterClientAuthenticationProperty kafkaClusterClientAuthentication) {
            this.props.kafkaClusterClientAuthentication(kafkaClusterClientAuthentication);
            return this;
        }

        public Builder kafkaClusterEncryptionInTransit(IResolvable kafkaClusterEncryptionInTransit) {
            this.props.kafkaClusterEncryptionInTransit(kafkaClusterEncryptionInTransit);
            return this;
        }

        public Builder kafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransitProperty kafkaClusterEncryptionInTransit) {
            this.props.kafkaClusterEncryptionInTransit(kafkaClusterEncryptionInTransit);
            return this;
        }

        public Builder kafkaConnectVersion(String kafkaConnectVersion) {
            this.props.kafkaConnectVersion(kafkaConnectVersion);
            return this;
        }

        public Builder plugins(IResolvable plugins) {
            this.props.plugins(plugins);
            return this;
        }

        public Builder plugins(List<? extends Object> plugins) {
            this.props.plugins(plugins);
            return this;
        }

        public Builder serviceExecutionRoleArn(String serviceExecutionRoleArn) {
            this.props.serviceExecutionRoleArn(serviceExecutionRoleArn);
            return this;
        }

        public Builder connectorDescription(String connectorDescription) {
            this.props.connectorDescription(connectorDescription);
            return this;
        }

        public Builder logDelivery(IResolvable logDelivery) {
            this.props.logDelivery(logDelivery);
            return this;
        }

        public Builder logDelivery(LogDeliveryProperty logDelivery) {
            this.props.logDelivery(logDelivery);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder workerConfiguration(IResolvable workerConfiguration) {
            this.props.workerConfiguration(workerConfiguration);
            return this;
        }

        public Builder workerConfiguration(WorkerConfigurationProperty workerConfiguration) {
            this.props.workerConfiguration(workerConfiguration);
            return this;
        }

        public CfnConnector build() {
            return new CfnConnector(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.WorkerLogDeliveryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WorkerLogDeliveryProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getCloudWatchLogs() {
            return null;
        }

        @Nullable
        default public Object getFirehose() {
            return null;
        }

        @Nullable
        default public Object getS3() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WorkerLogDeliveryProperty> {
            Object cloudWatchLogs;
            Object firehose;
            Object s3;

            public Builder cloudWatchLogs(IResolvable cloudWatchLogs) {
                this.cloudWatchLogs = cloudWatchLogs;
                return this;
            }

            public Builder cloudWatchLogs(CloudWatchLogsLogDeliveryProperty cloudWatchLogs) {
                this.cloudWatchLogs = cloudWatchLogs;
                return this;
            }

            public Builder firehose(IResolvable firehose) {
                this.firehose = firehose;
                return this;
            }

            public Builder firehose(FirehoseLogDeliveryProperty firehose) {
                this.firehose = firehose;
                return this;
            }

            public Builder s3(IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            public Builder s3(S3LogDeliveryProperty s3) {
                this.s3 = s3;
                return this;
            }

            public WorkerLogDeliveryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.WorkerConfigurationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface WorkerConfigurationProperty
    extends JsiiSerializable {
        @NotNull
        public Number getRevision();

        @NotNull
        public String getWorkerConfigurationArn();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<WorkerConfigurationProperty> {
            Number revision;
            String workerConfigurationArn;

            public Builder revision(Number revision) {
                this.revision = revision;
                return this;
            }

            public Builder workerConfigurationArn(String workerConfigurationArn) {
                this.workerConfigurationArn = workerConfigurationArn;
                return this;
            }

            public WorkerConfigurationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.VpcProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VpcProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSecurityGroups();

        @NotNull
        public List<String> getSubnets();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VpcProperty> {
            List<String> securityGroups;
            List<String> subnets;

            public Builder securityGroups(List<String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            public Builder subnets(List<String> subnets) {
                this.subnets = subnets;
                return this;
            }

            public VpcProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.ScaleOutPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScaleOutPolicyProperty
    extends JsiiSerializable {
        @NotNull
        public Number getCpuUtilizationPercentage();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScaleOutPolicyProperty> {
            Number cpuUtilizationPercentage;

            public Builder cpuUtilizationPercentage(Number cpuUtilizationPercentage) {
                this.cpuUtilizationPercentage = cpuUtilizationPercentage;
                return this;
            }

            public ScaleOutPolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.ScaleInPolicyProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScaleInPolicyProperty
    extends JsiiSerializable {
        @NotNull
        public Number getCpuUtilizationPercentage();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScaleInPolicyProperty> {
            Number cpuUtilizationPercentage;

            public Builder cpuUtilizationPercentage(Number cpuUtilizationPercentage) {
                this.cpuUtilizationPercentage = cpuUtilizationPercentage;
                return this;
            }

            public ScaleInPolicyProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.S3LogDeliveryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3LogDeliveryProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        @Nullable
        default public String getBucket() {
            return null;
        }

        @Nullable
        default public String getPrefix() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3LogDeliveryProperty> {
            Object enabled;
            String bucket;
            String prefix;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder bucket(String bucket) {
                this.bucket = bucket;
                return this;
            }

            public Builder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public S3LogDeliveryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.ProvisionedCapacityProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProvisionedCapacityProperty
    extends JsiiSerializable {
        @NotNull
        public Number getWorkerCount();

        @Nullable
        default public Number getMcuCount() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProvisionedCapacityProperty> {
            Number workerCount;
            Number mcuCount;

            public Builder workerCount(Number workerCount) {
                this.workerCount = workerCount;
                return this;
            }

            public Builder mcuCount(Number mcuCount) {
                this.mcuCount = mcuCount;
                return this;
            }

            public ProvisionedCapacityProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.LogDeliveryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface LogDeliveryProperty
    extends JsiiSerializable {
        @NotNull
        public Object getWorkerLogDelivery();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<LogDeliveryProperty> {
            Object workerLogDelivery;

            public Builder workerLogDelivery(IResolvable workerLogDelivery) {
                this.workerLogDelivery = workerLogDelivery;
                return this;
            }

            public Builder workerLogDelivery(WorkerLogDeliveryProperty workerLogDelivery) {
                this.workerLogDelivery = workerLogDelivery;
                return this;
            }

            public LogDeliveryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.KafkaClusterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KafkaClusterProperty
    extends JsiiSerializable {
        @NotNull
        public Object getApacheKafkaCluster();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KafkaClusterProperty> {
            Object apacheKafkaCluster;

            public Builder apacheKafkaCluster(IResolvable apacheKafkaCluster) {
                this.apacheKafkaCluster = apacheKafkaCluster;
                return this;
            }

            public Builder apacheKafkaCluster(ApacheKafkaClusterProperty apacheKafkaCluster) {
                this.apacheKafkaCluster = apacheKafkaCluster;
                return this;
            }

            public KafkaClusterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.KafkaClusterEncryptionInTransitProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KafkaClusterEncryptionInTransitProperty
    extends JsiiSerializable {
        @NotNull
        public String getEncryptionType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KafkaClusterEncryptionInTransitProperty> {
            String encryptionType;

            public Builder encryptionType(String encryptionType) {
                this.encryptionType = encryptionType;
                return this;
            }

            public KafkaClusterEncryptionInTransitProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.KafkaClusterClientAuthenticationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface KafkaClusterClientAuthenticationProperty
    extends JsiiSerializable {
        @NotNull
        public String getAuthenticationType();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<KafkaClusterClientAuthenticationProperty> {
            String authenticationType;

            public Builder authenticationType(String authenticationType) {
                this.authenticationType = authenticationType;
                return this;
            }

            public KafkaClusterClientAuthenticationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.FirehoseLogDeliveryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface FirehoseLogDeliveryProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        @Nullable
        default public String getDeliveryStream() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<FirehoseLogDeliveryProperty> {
            Object enabled;
            String deliveryStream;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder deliveryStream(String deliveryStream) {
                this.deliveryStream = deliveryStream;
                return this;
            }

            public FirehoseLogDeliveryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.CustomPluginProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CustomPluginProperty
    extends JsiiSerializable {
        @NotNull
        public String getCustomPluginArn();

        @NotNull
        public Number getRevision();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CustomPluginProperty> {
            String customPluginArn;
            Number revision;

            public Builder customPluginArn(String customPluginArn) {
                this.customPluginArn = customPluginArn;
                return this;
            }

            public Builder revision(Number revision) {
                this.revision = revision;
                return this;
            }

            public CustomPluginProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.CloudWatchLogsLogDeliveryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CloudWatchLogsLogDeliveryProperty
    extends JsiiSerializable {
        @NotNull
        public Object getEnabled();

        @Nullable
        default public String getLogGroup() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CloudWatchLogsLogDeliveryProperty> {
            Object enabled;
            String logGroup;

            public Builder enabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder enabled(IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder logGroup(String logGroup) {
                this.logGroup = logGroup;
                return this;
            }

            public CloudWatchLogsLogDeliveryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.CapacityProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CapacityProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getAutoScaling() {
            return null;
        }

        @Nullable
        default public Object getProvisionedCapacity() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CapacityProperty> {
            Object autoScaling;
            Object provisionedCapacity;

            public Builder autoScaling(IResolvable autoScaling) {
                this.autoScaling = autoScaling;
                return this;
            }

            public Builder autoScaling(AutoScalingProperty autoScaling) {
                this.autoScaling = autoScaling;
                return this;
            }

            public Builder provisionedCapacity(IResolvable provisionedCapacity) {
                this.provisionedCapacity = provisionedCapacity;
                return this;
            }

            public Builder provisionedCapacity(ProvisionedCapacityProperty provisionedCapacity) {
                this.provisionedCapacity = provisionedCapacity;
                return this;
            }

            public CapacityProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.AutoScalingProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface AutoScalingProperty
    extends JsiiSerializable {
        @NotNull
        public Number getMaxWorkerCount();

        @NotNull
        public Number getMcuCount();

        @NotNull
        public Number getMinWorkerCount();

        @NotNull
        public Object getScaleInPolicy();

        @NotNull
        public Object getScaleOutPolicy();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<AutoScalingProperty> {
            Number maxWorkerCount;
            Number mcuCount;
            Number minWorkerCount;
            Object scaleInPolicy;
            Object scaleOutPolicy;

            public Builder maxWorkerCount(Number maxWorkerCount) {
                this.maxWorkerCount = maxWorkerCount;
                return this;
            }

            public Builder mcuCount(Number mcuCount) {
                this.mcuCount = mcuCount;
                return this;
            }

            public Builder minWorkerCount(Number minWorkerCount) {
                this.minWorkerCount = minWorkerCount;
                return this;
            }

            public Builder scaleInPolicy(IResolvable scaleInPolicy) {
                this.scaleInPolicy = scaleInPolicy;
                return this;
            }

            public Builder scaleInPolicy(ScaleInPolicyProperty scaleInPolicy) {
                this.scaleInPolicy = scaleInPolicy;
                return this;
            }

            public Builder scaleOutPolicy(IResolvable scaleOutPolicy) {
                this.scaleOutPolicy = scaleOutPolicy;
                return this;
            }

            public Builder scaleOutPolicy(ScaleOutPolicyProperty scaleOutPolicy) {
                this.scaleOutPolicy = scaleOutPolicy;
                return this;
            }

            public AutoScalingProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_kafkaconnect.CfnConnector.ApacheKafkaClusterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ApacheKafkaClusterProperty
    extends JsiiSerializable {
        @NotNull
        public String getBootstrapServers();

        @NotNull
        public Object getVpc();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ApacheKafkaClusterProperty> {
            String bootstrapServers;
            Object vpc;

            public Builder bootstrapServers(String bootstrapServers) {
                this.bootstrapServers = bootstrapServers;
                return this;
            }

            public Builder vpc(IResolvable vpc) {
                this.vpc = vpc;
                return this;
            }

            public Builder vpc(VpcProperty vpc) {
                this.vpc = vpc;
                return this;
            }

            public ApacheKafkaClusterProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

