/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ses;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.ses.ConfigurationSetEventDestination;
import software.amazon.awscdk.services.ses.ConfigurationSetEventDestinationOptions;
import software.amazon.awscdk.services.ses.ConfigurationSetProps;
import software.amazon.awscdk.services.ses.ConfigurationSetTlsPolicy;
import software.amazon.awscdk.services.ses.HttpsPolicy;
import software.amazon.awscdk.services.ses.IConfigurationSet;
import software.amazon.awscdk.services.ses.IDedicatedIpPool;
import software.amazon.awscdk.services.ses.SuppressionReasons;
import software.amazon.awscdk.services.ses.VdmOptions;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_ses.ConfigurationSet")
public class ConfigurationSet
extends Resource
implements IConfigurationSet {
    public static final String PROPERTY_INJECTION_ID = (String)JsiiObject.jsiiStaticGet(ConfigurationSet.class, (String)"PROPERTY_INJECTION_ID", (NativeType)NativeType.forClass(String.class));

    protected ConfigurationSet(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ConfigurationSet(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public ConfigurationSet(@NotNull Construct scope, @NotNull String id, @Nullable ConfigurationSetProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public ConfigurationSet(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IConfigurationSet fromConfigurationSetName(@NotNull Construct scope, @NotNull String id, @NotNull String configurationSetName) {
        return (IConfigurationSet)JsiiObject.jsiiStaticCall(ConfigurationSet.class, (String)"fromConfigurationSetName", (NativeType)NativeType.forClass(IConfigurationSet.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(configurationSetName, "configurationSetName is required")});
    }

    @NotNull
    public ConfigurationSetEventDestination addEventDestination(@NotNull String id, @NotNull ConfigurationSetEventDestinationOptions options) {
        return (ConfigurationSetEventDestination)Kernel.call((Object)this, (String)"addEventDestination", (NativeType)NativeType.forClass(ConfigurationSetEventDestination.class), (Object[])new Object[]{Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public String getConfigurationSetName() {
        return (String)Kernel.get((Object)this, (String)"configurationSetName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<ConfigurationSet> {
        private final Construct scope;
        private final String id;
        private ConfigurationSetProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder configurationSetName(String configurationSetName) {
            this.props().configurationSetName(configurationSetName);
            return this;
        }

        public Builder customTrackingHttpsPolicy(HttpsPolicy customTrackingHttpsPolicy) {
            this.props().customTrackingHttpsPolicy(customTrackingHttpsPolicy);
            return this;
        }

        public Builder customTrackingRedirectDomain(String customTrackingRedirectDomain) {
            this.props().customTrackingRedirectDomain(customTrackingRedirectDomain);
            return this;
        }

        public Builder dedicatedIpPool(IDedicatedIpPool dedicatedIpPool) {
            this.props().dedicatedIpPool(dedicatedIpPool);
            return this;
        }

        public Builder disableSuppressionList(Boolean disableSuppressionList) {
            this.props().disableSuppressionList(disableSuppressionList);
            return this;
        }

        public Builder maxDeliveryDuration(Duration maxDeliveryDuration) {
            this.props().maxDeliveryDuration(maxDeliveryDuration);
            return this;
        }

        public Builder reputationMetrics(Boolean reputationMetrics) {
            this.props().reputationMetrics(reputationMetrics);
            return this;
        }

        public Builder sendingEnabled(Boolean sendingEnabled) {
            this.props().sendingEnabled(sendingEnabled);
            return this;
        }

        public Builder suppressionReasons(SuppressionReasons suppressionReasons) {
            this.props().suppressionReasons(suppressionReasons);
            return this;
        }

        public Builder tlsPolicy(ConfigurationSetTlsPolicy tlsPolicy) {
            this.props().tlsPolicy(tlsPolicy);
            return this;
        }

        public Builder vdmOptions(VdmOptions vdmOptions) {
            this.props().vdmOptions(vdmOptions);
            return this;
        }

        public ConfigurationSet build() {
            return new ConfigurationSet(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private ConfigurationSetProps.Builder props() {
            if (this.props == null) {
                this.props = new ConfigurationSetProps.Builder();
            }
            return this.props;
        }
    }
}

