/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.events.IConnection;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.stepfunctions.Credentials;
import software.amazon.awscdk.services.stepfunctions.IntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.QueryLanguage;
import software.amazon.awscdk.services.stepfunctions.TaskInput;
import software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig;
import software.amazon.awscdk.services.stepfunctions.TaskStateBase;
import software.amazon.awscdk.services.stepfunctions.Timeout;
import software.amazon.awscdk.services.stepfunctions.tasks.HttpInvokeJsonPathProps;
import software.amazon.awscdk.services.stepfunctions.tasks.HttpInvokeJsonataProps;
import software.amazon.awscdk.services.stepfunctions.tasks.HttpInvokeProps;
import software.amazon.awscdk.services.stepfunctions.tasks.URLEncodingFormat;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="aws-cdk-lib.aws_stepfunctions_tasks.HttpInvoke")
public class HttpInvoke
extends TaskStateBase {
    protected HttpInvoke(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpInvoke(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public HttpInvoke(@NotNull Construct scope, @NotNull String id, @NotNull HttpInvokeProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static HttpInvoke jsonata(@NotNull Construct scope, @NotNull String id, @NotNull HttpInvokeJsonataProps props) {
        return (HttpInvoke)JsiiObject.jsiiStaticCall(HttpInvoke.class, (String)"jsonata", (NativeType)NativeType.forClass(HttpInvoke.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static HttpInvoke jsonPath(@NotNull Construct scope, @NotNull String id, @NotNull HttpInvokeJsonPathProps props) {
        return (HttpInvoke)JsiiObject.jsiiStaticCall(HttpInvoke.class, (String)"jsonPath", (NativeType)NativeType.forClass(HttpInvoke.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    protected List<PolicyStatement> buildTaskPolicyStatements() {
        return Collections.unmodifiableList((List)Kernel.call((Object)this, (String)"buildTaskPolicyStatements", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(PolicyStatement.class)), (Object[])new Object[0]));
    }

    @Override
    @Nullable
    protected TaskMetricsConfig getTaskMetrics() {
        return (TaskMetricsConfig)Kernel.get((Object)this, (String)"taskMetrics", (NativeType)NativeType.forClass(TaskMetricsConfig.class));
    }

    @Override
    @Nullable
    protected List<PolicyStatement> getTaskPolicies() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"taskPolicies", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(PolicyStatement.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<HttpInvoke> {
        private final Construct scope;
        private final String id;
        private final HttpInvokeProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new HttpInvokeProps.Builder();
        }

        public Builder comment(String comment) {
            this.props.comment(comment);
            return this;
        }

        public Builder queryLanguage(QueryLanguage queryLanguage) {
            this.props.queryLanguage(queryLanguage);
            return this;
        }

        public Builder stateName(String stateName) {
            this.props.stateName(stateName);
            return this;
        }

        public Builder credentials(Credentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        @Deprecated
        public Builder heartbeat(Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        public Builder heartbeatTimeout(Timeout heartbeatTimeout) {
            this.props.heartbeatTimeout(heartbeatTimeout);
            return this;
        }

        public Builder integrationPattern(IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        public Builder taskTimeout(Timeout taskTimeout) {
            this.props.taskTimeout(taskTimeout);
            return this;
        }

        @Deprecated
        public Builder timeout(Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public Builder assign(Map<String, ? extends Object> assign) {
            this.props.assign(assign);
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        public Builder outputs(Object outputs) {
            this.props.outputs(outputs);
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        public Builder resultSelector(Map<String, ? extends Object> resultSelector) {
            this.props.resultSelector(resultSelector);
            return this;
        }

        public Builder apiEndpoint(TaskInput apiEndpoint) {
            this.props.apiEndpoint(apiEndpoint);
            return this;
        }

        public Builder apiRoot(String apiRoot) {
            this.props.apiRoot(apiRoot);
            return this;
        }

        public Builder connection(IConnection connection) {
            this.props.connection(connection);
            return this;
        }

        public Builder method(TaskInput method) {
            this.props.method(method);
            return this;
        }

        public Builder body(TaskInput body) {
            this.props.body(body);
            return this;
        }

        public Builder headers(TaskInput headers) {
            this.props.headers(headers);
            return this;
        }

        public Builder queryStringParameters(TaskInput queryStringParameters) {
            this.props.queryStringParameters(queryStringParameters);
            return this;
        }

        public Builder urlEncodingFormat(URLEncodingFormat urlEncodingFormat) {
            this.props.urlEncodingFormat(urlEncodingFormat);
            return this;
        }

        public HttpInvoke build() {
            return new HttpInvoke(this.scope, this.id, this.props.build());
        }
    }
}

