package software.amazon.awscdk;

/**
 * Represents file path ignoring behavior.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * IgnoreStrategy ignoreStrategy = IgnoreStrategy.fromCopyOptions(CopyOptions.builder()
 *         .exclude(List.of("exclude"))
 *         .follow(SymlinkFollowMode.NEVER)
 *         .ignoreMode(IgnoreMode.GLOB)
 *         .build(), "absoluteRootPath");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:09.947Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.IgnoreStrategy")
public abstract class IgnoreStrategy extends software.amazon.jsii.JsiiObject {

    protected IgnoreStrategy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IgnoreStrategy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected IgnoreStrategy() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Ignores file paths based on the <a href="https://docs.docker.com/engine/reference/builder/#dockerignore-file"><code>.dockerignore specification</code></a>.
     * <p>
     * @return <code>DockerIgnorePattern</code> associated with the given patterns.
     * @param absoluteRootPath the absolute path to the root directory of the paths to be considered. This parameter is required.
     * @param patterns This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.DockerIgnoreStrategy docker(final @org.jetbrains.annotations.NotNull java.lang.String absoluteRootPath, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> patterns) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.IgnoreStrategy.class, "docker", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.DockerIgnoreStrategy.class), new Object[] { java.util.Objects.requireNonNull(absoluteRootPath, "absoluteRootPath is required"), java.util.Objects.requireNonNull(patterns, "patterns is required") });
    }

    /**
     * Creates an IgnoreStrategy based on the <code>ignoreMode</code> and <code>exclude</code> in a <code>CopyOptions</code>.
     * <p>
     * @return <code>IgnoreStrategy</code> based on the <code>CopyOptions</code>
     * @param options the <code>CopyOptions</code> to create the <code>IgnoreStrategy</code> from. This parameter is required.
     * @param absoluteRootPath the absolute path to the root directory of the paths to be considered. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.IgnoreStrategy fromCopyOptions(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CopyOptions options, final @org.jetbrains.annotations.NotNull java.lang.String absoluteRootPath) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.IgnoreStrategy.class, "fromCopyOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IgnoreStrategy.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required"), java.util.Objects.requireNonNull(absoluteRootPath, "absoluteRootPath is required") });
    }

    /**
     * Ignores file paths based on the <a href="https://git-scm.com/docs/gitignore"><code>.gitignore specification</code></a>.
     * <p>
     * @return <code>GitIgnorePattern</code> associated with the given patterns.
     * @param absoluteRootPath the absolute path to the root directory of the paths to be considered. This parameter is required.
     * @param patterns This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.GitIgnoreStrategy git(final @org.jetbrains.annotations.NotNull java.lang.String absoluteRootPath, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> patterns) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.IgnoreStrategy.class, "git", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.GitIgnoreStrategy.class), new Object[] { java.util.Objects.requireNonNull(absoluteRootPath, "absoluteRootPath is required"), java.util.Objects.requireNonNull(patterns, "patterns is required") });
    }

    /**
     * Ignores file paths based on simple glob patterns.
     * <p>
     * @return <code>GlobIgnorePattern</code> associated with the given patterns.
     * @param absoluteRootPath the absolute path to the root directory of the paths to be considered. This parameter is required.
     * @param patterns This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.GlobIgnoreStrategy glob(final @org.jetbrains.annotations.NotNull java.lang.String absoluteRootPath, final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> patterns) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.IgnoreStrategy.class, "glob", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.GlobIgnoreStrategy.class), new Object[] { java.util.Objects.requireNonNull(absoluteRootPath, "absoluteRootPath is required"), java.util.Objects.requireNonNull(patterns, "patterns is required") });
    }

    /**
     * Adds another pattern.
     * <p>
     * @param pattern This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract void add(final @org.jetbrains.annotations.NotNull java.lang.String pattern);

    /**
     * Determines whether a given file path should be ignored or not.
     * <p>
     * @return <code>true</code> if the file should be ignored
     * @param absoluteFilePath absolute file path to be assessed against the pattern. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.Boolean ignores(final @org.jetbrains.annotations.NotNull java.lang.String absoluteFilePath);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.IgnoreStrategy {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Adds another pattern.
         * <p>
         * @param pattern This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void add(final @org.jetbrains.annotations.NotNull java.lang.String pattern) {
            software.amazon.jsii.Kernel.call(this, "add", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(pattern, "pattern is required") });
        }

        /**
         * Determines whether a given file path should be ignored or not.
         * <p>
         * @return <code>true</code> if the file should be ignored
         * @param absoluteFilePath absolute file path to be assessed against the pattern. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.Boolean ignores(final @org.jetbrains.annotations.NotNull java.lang.String absoluteFilePath) {
            return software.amazon.jsii.Kernel.call(this, "ignores", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { java.util.Objects.requireNonNull(absoluteFilePath, "absoluteFilePath is required") });
        }
    }
}
