package software.amazon.awscdk;

/**
 * Lazily produce a value.
 * <p>
 * Can be used to return a string, list or numeric value whose actual value
 * will only be calculated later, during synthesis.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:09.950Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.Lazy")
public class Lazy extends software.amazon.jsii.JsiiObject {

    protected Lazy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Lazy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Defer the one-time calculation of an arbitrarily typed value to synthesis time.
     * <p>
     * Use this if you want to render an object to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * The inner function will only be invoked one time and cannot depend on
     * resolution context.
     * <p>
     * @param producer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable any(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IStableAnyProducer producer, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.LazyAnyValueOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Lazy.class, "any", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required"), options });
    }

    /**
     * Defer the one-time calculation of an arbitrarily typed value to synthesis time.
     * <p>
     * Use this if you want to render an object to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * The inner function will only be invoked one time and cannot depend on
     * resolution context.
     * <p>
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable any(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IStableAnyProducer producer) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Lazy.class, "any", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") });
    }

    /**
     * Defer the one-time calculation of a list value to synthesis time.
     * <p>
     * Use this if you want to render a list to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * If you are simply looking to force a value to a <code>string[]</code> type and don't need
     * the calculation to be deferred, use <code>Token.asList()</code> instead.
     * <p>
     * The inner function will only be invoked once, and the resolved value
     * cannot depend on the Stack the Token is used in.
     * <p>
     * @param producer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> list(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IStableListProducer producer, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.LazyListValueOptions options) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Lazy.class, "list", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required"), options }));
    }

    /**
     * Defer the one-time calculation of a list value to synthesis time.
     * <p>
     * Use this if you want to render a list to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * If you are simply looking to force a value to a <code>string[]</code> type and don't need
     * the calculation to be deferred, use <code>Token.asList()</code> instead.
     * <p>
     * The inner function will only be invoked once, and the resolved value
     * cannot depend on the Stack the Token is used in.
     * <p>
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> list(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IStableListProducer producer) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Lazy.class, "list", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") }));
    }

    /**
     * Defer the one-time calculation of a number value to synthesis time.
     * <p>
     * Use this if you want to render a number to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * If you are simply looking to force a value to a <code>number</code> type and don't need
     * the calculation to be deferred, use <code>Token.asNumber()</code> instead.
     * <p>
     * The inner function will only be invoked once, and the resolved value
     * cannot depend on the Stack the Token is used in.
     * <p>
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Number number(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IStableNumberProducer producer) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Lazy.class, "number", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") });
    }

    /**
     * Defer the one-time calculation of a string value to synthesis time.
     * <p>
     * Use this if you want to render a string to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * If you are simply looking to force a value to a <code>string</code> type and don't need
     * the calculation to be deferred, use <code>Token.asString()</code> instead.
     * <p>
     * The inner function will only be invoked once, and the resolved value
     * cannot depend on the Stack the Token is used in.
     * <p>
     * @param producer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String string(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IStableStringProducer producer, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.LazyStringValueOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Lazy.class, "string", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required"), options });
    }

    /**
     * Defer the one-time calculation of a string value to synthesis time.
     * <p>
     * Use this if you want to render a string to a template whose actual value depends on
     * some state mutation that may happen after the construct has been created.
     * <p>
     * If you are simply looking to force a value to a <code>string</code> type and don't need
     * the calculation to be deferred, use <code>Token.asString()</code> instead.
     * <p>
     * The inner function will only be invoked once, and the resolved value
     * cannot depend on the Stack the Token is used in.
     * <p>
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String string(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IStableStringProducer producer) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Lazy.class, "string", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") });
    }

    /**
     * Defer the calculation of an untyped value to synthesis time.
     * <p>
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use <code>Lazy.any()</code> instead.
     * <p>
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     * <p>
     * @param producer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable uncachedAny(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IAnyProducer producer, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.LazyAnyValueOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Lazy.class, "uncachedAny", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required"), options });
    }

    /**
     * Defer the calculation of an untyped value to synthesis time.
     * <p>
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use <code>Lazy.any()</code> instead.
     * <p>
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     * <p>
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable uncachedAny(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IAnyProducer producer) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Lazy.class, "uncachedAny", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") });
    }

    /**
     * Defer the calculation of a list value to synthesis time.
     * <p>
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use <code>Lazy.list()</code> instead.
     * <p>
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     * <p>
     * @param producer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> uncachedList(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IListProducer producer, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.LazyListValueOptions options) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Lazy.class, "uncachedList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required"), options }));
    }

    /**
     * Defer the calculation of a list value to synthesis time.
     * <p>
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use <code>Lazy.list()</code> instead.
     * <p>
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     * <p>
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> uncachedList(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IListProducer producer) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Lazy.class, "uncachedList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") }));
    }

    /**
     * Defer the calculation of a number value to synthesis time.
     * <p>
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use <code>Lazy.number()</code> instead.
     * <p>
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     * <p>
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Number uncachedNumber(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.INumberProducer producer) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Lazy.class, "uncachedNumber", software.amazon.jsii.NativeType.forClass(java.lang.Number.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") });
    }

    /**
     * Defer the calculation of a string value to synthesis time.
     * <p>
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use <code>Lazy.string()</code> instead.
     * <p>
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     * <p>
     * @param producer This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String uncachedString(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IStringProducer producer, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.LazyStringValueOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Lazy.class, "uncachedString", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required"), options });
    }

    /**
     * Defer the calculation of a string value to synthesis time.
     * <p>
     * Use of this function is not recommended; unless you know you need it for sure, you
     * probably don't. Use <code>Lazy.string()</code> instead.
     * <p>
     * The inner function may be invoked multiple times during synthesis. You
     * should only use this method if the returned value depends on variables
     * that may change during the Aspect application phase of synthesis, or if
     * the value depends on the Stack the value is being used in. Both of these
     * cases are rare, and only ever occur for AWS Construct Library authors.
     * <p>
     * @param producer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String uncachedString(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IStringProducer producer) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.Lazy.class, "uncachedString", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(producer, "producer is required") });
    }
}
