package software.amazon.awscdk.cloud_assembly_schema;

/**
 * A file asset.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloud_assembly_schema.*;
 * Object assumeRoleAdditionalOptions;
 * FileAsset fileAsset = FileAsset.builder()
 *         .destinations(Map.of(
 *                 "destinationsKey", FileDestination.builder()
 *                         .bucketName("bucketName")
 *                         .objectKey("objectKey")
 *                         // the properties below are optional
 *                         .assumeRoleAdditionalOptions(Map.of(
 *                                 "assumeRoleAdditionalOptionsKey", assumeRoleAdditionalOptions))
 *                         .assumeRoleArn("assumeRoleArn")
 *                         .assumeRoleExternalId("assumeRoleExternalId")
 *                         .region("region")
 *                         .build()))
 *         .source(FileSource.builder()
 *                 .executable(List.of("executable"))
 *                 .packaging(FileAssetPackaging.FILE)
 *                 .path("path")
 *                 .build())
 *         // the properties below are optional
 *         .displayName("displayName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:27.532Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.FileAsset")
@software.amazon.jsii.Jsii.Proxy(FileAsset.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface FileAsset extends software.amazon.jsii.JsiiSerializable {

    /**
     * Destinations for this file asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.FileDestination> getDestinations();

    /**
     * Source description for file assets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.cloud_assembly_schema.FileSource getSource();

    /**
     * A display name for this asset.
     * <p>
     * Default: - The identifier will be used as the display name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FileAsset}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FileAsset}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<FileAsset> {
        java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.FileDestination> destinations;
        software.amazon.awscdk.cloud_assembly_schema.FileSource source;
        java.lang.String displayName;

        /**
         * Sets the value of {@link FileAsset#getDestinations}
         * @param destinations Destinations for this file asset. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder destinations(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.cloud_assembly_schema.FileDestination> destinations) {
            this.destinations = (java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.FileDestination>)destinations;
            return this;
        }

        /**
         * Sets the value of {@link FileAsset#getSource}
         * @param source Source description for file assets. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(software.amazon.awscdk.cloud_assembly_schema.FileSource source) {
            this.source = source;
            return this;
        }

        /**
         * Sets the value of {@link FileAsset#getDisplayName}
         * @param displayName A display name for this asset.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FileAsset}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public FileAsset build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FileAsset}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileAsset {
        private final java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.FileDestination> destinations;
        private final software.amazon.awscdk.cloud_assembly_schema.FileSource source;
        private final java.lang.String displayName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinations = software.amazon.jsii.Kernel.get(this, "destinations", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.FileDestination.class)));
            this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.FileSource.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinations = (java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.FileDestination>)java.util.Objects.requireNonNull(builder.destinations, "destinations is required");
            this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
            this.displayName = builder.displayName;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.FileDestination> getDestinations() {
            return this.destinations;
        }

        @Override
        public final software.amazon.awscdk.cloud_assembly_schema.FileSource getSource() {
            return this.source;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinations", om.valueToTree(this.getDestinations()));
            data.set("source", om.valueToTree(this.getSource()));
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloud_assembly_schema.FileAsset"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FileAsset.Jsii$Proxy that = (FileAsset.Jsii$Proxy) o;

            if (!destinations.equals(that.destinations)) return false;
            if (!source.equals(that.source)) return false;
            return this.displayName != null ? this.displayName.equals(that.displayName) : that.displayName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destinations.hashCode();
            result = 31 * result + (this.source.hashCode());
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            return result;
        }
    }
}
