package software.amazon.awscdk.pipelines;

/**
 * Options to pass to <code>addWave</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * CodePipeline pipeline = CodePipeline.Builder.create(this, "Pipeline")
 *         .synth(ShellStep.Builder.create("Synth")
 *                 .input(CodePipelineSource.connection("my-org/my-app", "main", ConnectionSourceOptions.builder()
 *                         .connectionArn("arn:aws:codestar-connections:us-east-1:222222222222:connection/7d2469ff-514a-4e4f-9003-5ca4a43cdc41")
 *                         .build()))
 *                 .commands(List.of("npm ci", "npm run build", "npx cdk synth"))
 *                 .build())
 *         // Turn this on because the pipeline uses Docker image assets
 *         .dockerEnabledForSelfMutation(true)
 *         .build();
 * pipeline.addWave("MyWave", WaveOptions.builder()
 *         .post(List.of(
 *             CodeBuildStep.Builder.create("RunApproval")
 *                     .commands(List.of("command-from-image"))
 *                     .buildEnvironment(BuildEnvironment.builder()
 *                             // The user of a Docker image asset in the pipeline requires turning on
 *                             // 'dockerEnabledForSelfMutation'.
 *                             .buildImage(LinuxBuildImage.fromAsset(this, "Image", DockerImageAssetProps.builder()
 *                                     .directory("./docker-image")
 *                                     .build()))
 *                             .build())
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:27.712Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.pipelines.WaveOptions")
@software.amazon.jsii.Jsii.Proxy(WaveOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WaveOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Additional steps to run after all of the stages in the wave.
     * <p>
     * Default: - No additional steps
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.pipelines.Step> getPost() {
        return null;
    }

    /**
     * Additional steps to run before any of the stages in the wave.
     * <p>
     * Default: - No additional steps
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.pipelines.Step> getPre() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WaveOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WaveOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WaveOptions> {
        java.util.List<software.amazon.awscdk.pipelines.Step> post;
        java.util.List<software.amazon.awscdk.pipelines.Step> pre;

        /**
         * Sets the value of {@link WaveOptions#getPost}
         * @param post Additional steps to run after all of the stages in the wave.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder post(java.util.List<? extends software.amazon.awscdk.pipelines.Step> post) {
            this.post = (java.util.List<software.amazon.awscdk.pipelines.Step>)post;
            return this;
        }

        /**
         * Sets the value of {@link WaveOptions#getPre}
         * @param pre Additional steps to run before any of the stages in the wave.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder pre(java.util.List<? extends software.amazon.awscdk.pipelines.Step> pre) {
            this.pre = (java.util.List<software.amazon.awscdk.pipelines.Step>)pre;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WaveOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WaveOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WaveOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WaveOptions {
        private final java.util.List<software.amazon.awscdk.pipelines.Step> post;
        private final java.util.List<software.amazon.awscdk.pipelines.Step> pre;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.post = software.amazon.jsii.Kernel.get(this, "post", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class)));
            this.pre = software.amazon.jsii.Kernel.get(this, "pre", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.pipelines.Step.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.post = (java.util.List<software.amazon.awscdk.pipelines.Step>)builder.post;
            this.pre = (java.util.List<software.amazon.awscdk.pipelines.Step>)builder.pre;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.pipelines.Step> getPost() {
            return this.post;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.pipelines.Step> getPre() {
            return this.pre;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPost() != null) {
                data.set("post", om.valueToTree(this.getPost()));
            }
            if (this.getPre() != null) {
                data.set("pre", om.valueToTree(this.getPre()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.pipelines.WaveOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WaveOptions.Jsii$Proxy that = (WaveOptions.Jsii$Proxy) o;

            if (this.post != null ? !this.post.equals(that.post) : that.post != null) return false;
            return this.pre != null ? this.pre.equals(that.pre) : that.pre == null;
        }

        @Override
        public final int hashCode() {
            int result = this.post != null ? this.post.hashCode() : 0;
            result = 31 * result + (this.pre != null ? this.pre.hashCode() : 0);
            return result;
        }
    }
}
