package software.amazon.awscdk.services.amazonmq;

/**
 * A <em>broker</em> is a message broker environment running on Amazon MQ .
 * <p>
 * It is the basic building block of Amazon MQ .
 * <p>
 * The <code>AWS::AmazonMQ::Broker</code> resource lets you create Amazon MQ for ActiveMQ and Amazon MQ for RabbitMQ brokers, add configuration changes or modify users for a speified ActiveMQ broker, return information about the specified broker, and delete the broker. For more information, see <a href="https://docs.aws.amazon.com//amazon-mq/latest/developer-guide/amazon-mq-how-it-works.html">How Amazon MQ works</a> in the <em>Amazon MQ Developer Guide</em> .
 * <p>
 * <ul>
 * <li><code>ec2:CreateNetworkInterface</code></li>
 * </ul>
 * <p>
 * This permission is required to allow Amazon MQ to create an elastic network interface (ENI) on behalf of your account.
 * <p>
 * <ul>
 * <li><code>ec2:CreateNetworkInterfacePermission</code></li>
 * </ul>
 * <p>
 * This permission is required to attach the ENI to the broker instance.
 * <p>
 * <ul>
 * <li><code>ec2:DeleteNetworkInterface</code></li>
 * <li><code>ec2:DeleteNetworkInterfacePermission</code></li>
 * <li><code>ec2:DetachNetworkInterface</code></li>
 * <li><code>ec2:DescribeInternetGateways</code></li>
 * <li><code>ec2:DescribeNetworkInterfaces</code></li>
 * <li><code>ec2:DescribeNetworkInterfacePermissions</code></li>
 * <li><code>ec2:DescribeRouteTables</code></li>
 * <li><code>ec2:DescribeSecurityGroups</code></li>
 * <li><code>ec2:DescribeSubnets</code></li>
 * <li><code>ec2:DescribeVpcs</code></li>
 * </ul>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.amazonmq.*;
 * CfnBroker cfnBroker = CfnBroker.Builder.create(this, "MyCfnBroker")
 *         .brokerName("brokerName")
 *         .deploymentMode("deploymentMode")
 *         .engineType("engineType")
 *         .hostInstanceType("hostInstanceType")
 *         .publiclyAccessible(false)
 *         .users(List.of(UserProperty.builder()
 *                 .password("password")
 *                 .username("username")
 *                 // the properties below are optional
 *                 .consoleAccess(false)
 *                 .groups(List.of("groups"))
 *                 .jolokiaApiAccess("jolokiaApiAccess")
 *                 .replicationUser(false)
 *                 .build()))
 *         // the properties below are optional
 *         .authenticationStrategy("authenticationStrategy")
 *         .autoMinorVersionUpgrade(false)
 *         .configuration(ConfigurationIdProperty.builder()
 *                 .id("id")
 *                 .revision(123)
 *                 .build())
 *         .dataReplicationMode("dataReplicationMode")
 *         .dataReplicationPrimaryBrokerArn("dataReplicationPrimaryBrokerArn")
 *         .encryptionOptions(EncryptionOptionsProperty.builder()
 *                 .useAwsOwnedKey(false)
 *                 // the properties below are optional
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .engineVersion("engineVersion")
 *         .ldapServerMetadata(LdapServerMetadataProperty.builder()
 *                 .hosts(List.of("hosts"))
 *                 .roleBase("roleBase")
 *                 .roleSearchMatching("roleSearchMatching")
 *                 .serviceAccountPassword("serviceAccountPassword")
 *                 .serviceAccountUsername("serviceAccountUsername")
 *                 .userBase("userBase")
 *                 .userSearchMatching("userSearchMatching")
 *                 // the properties below are optional
 *                 .roleName("roleName")
 *                 .roleSearchSubtree(false)
 *                 .userRoleName("userRoleName")
 *                 .userSearchSubtree(false)
 *                 .build())
 *         .logs(LogListProperty.builder()
 *                 .audit(false)
 *                 .general(false)
 *                 .build())
 *         .maintenanceWindowStartTime(MaintenanceWindowProperty.builder()
 *                 .dayOfWeek("dayOfWeek")
 *                 .timeOfDay("timeOfDay")
 *                 .timeZone("timeZone")
 *                 .build())
 *         .securityGroups(List.of("securityGroups"))
 *         .storageType("storageType")
 *         .subnetIds(List.of("subnetIds"))
 *         .tags(List.of(TagsEntryProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:10.105Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amazonmq.CfnBroker")
public class CfnBroker extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnBroker(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBroker(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.amazonmq.CfnBroker.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnBroker(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.amazonmq.CfnBrokerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The AMQP endpoints of each broker instance as a list of strings.
     * <p>
     * <code>amqp+ssl://b-4aada85d-a80c-4be0-9d30-e344a01b921e-1.mq.eu-central-amazonaws.com:5671</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrAmqpEndpoints() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrAmqpEndpoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon MQ broker.
     * <p>
     * <code>arn:aws:mq:us-east-2:123456789012:broker:MyBroker:b-1234a5b6-78cd-901e-2fgh-3i45j6k178l9</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID that Amazon MQ generates for the configuration.
     * <p>
     * <code>c-1234a5b6-78cd-901e-2fgh-3i45j6k178l9</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConfigurationId() {
        return software.amazon.jsii.Kernel.get(this, "attrConfigurationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The revision number of the configuration.
     * <p>
     * <code>1</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrConfigurationRevision() {
        return software.amazon.jsii.Kernel.get(this, "attrConfigurationRevision", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * Required.
     * <p>
     * The unique ID that Amazon MQ generates for the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IP addresses of each broker instance as a list of strings. Does not apply to RabbitMQ brokers.
     * <p>
     * <code>['198.51.100.2', '203.0.113.9']</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrIpAddresses() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrIpAddresses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The MQTT endpoints of each broker instance as a list of strings.
     * <p>
     * <code>mqtt+ssl://b-4aada85d-a80c-4be0-9d30-e344a01b921e-1.mq.eu-central-amazonaws.com:8883</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrMqttEndpoints() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrMqttEndpoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The OpenWire endpoints of each broker instance as a list of strings.
     * <p>
     * <code>ssl://b-4aada85d-a80c-4be0-9d30-e344a01b921e-1.mq.eu-central-amazonaws.com:61617</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrOpenWireEndpoints() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrOpenWireEndpoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The STOMP endpoints of each broker instance as a list of strings.
     * <p>
     * <code>stomp+ssl://b-4aada85d-a80c-4be0-9d30-e344a01b921e-1.mq.eu-central-amazonaws.com:61614</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrStompEndpoints() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrStompEndpoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The WSS endpoints of each broker instance as a list of strings.
     * <p>
     * <code>wss://b-4aada85d-a80c-4be0-9d30-e344a01b921e-1.mq.eu-central-amazonaws.com:61619</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrWssEndpoints() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrWssEndpoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the broker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBrokerName() {
        return software.amazon.jsii.Kernel.get(this, "brokerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the broker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBrokerName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "brokerName", java.util.Objects.requireNonNull(value, "brokerName is required"));
    }

    /**
     * The deployment mode of the broker.
     * <p>
     * Available values:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDeploymentMode() {
        return software.amazon.jsii.Kernel.get(this, "deploymentMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The deployment mode of the broker.
     * <p>
     * Available values:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentMode(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deploymentMode", java.util.Objects.requireNonNull(value, "deploymentMode is required"));
    }

    /**
     * The type of broker engine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEngineType() {
        return software.amazon.jsii.Kernel.get(this, "engineType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of broker engine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineType", java.util.Objects.requireNonNull(value, "engineType is required"));
    }

    /**
     * The broker's instance type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getHostInstanceType() {
        return software.amazon.jsii.Kernel.get(this, "hostInstanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The broker's instance type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHostInstanceType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "hostInstanceType", java.util.Objects.requireNonNull(value, "hostInstanceType is required"));
    }

    /**
     * Enables connections from applications outside of the VPC that hosts the broker's subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getPubliclyAccessible() {
        return software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enables connections from applications outside of the VPC that hosts the broker's subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", java.util.Objects.requireNonNull(value, "publiclyAccessible is required"));
    }

    /**
     * Enables connections from applications outside of the VPC that hosts the broker's subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", java.util.Objects.requireNonNull(value, "publiclyAccessible is required"));
    }

    /**
     * The list of broker users (persons or applications) who can access queues and topics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getUsers() {
        return software.amazon.jsii.Kernel.get(this, "users", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The list of broker users (persons or applications) who can access queues and topics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUsers(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "users", java.util.Objects.requireNonNull(value, "users is required"));
    }

    /**
     * The list of broker users (persons or applications) who can access queues and topics.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUsers(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.amazonmq.CfnBroker.UserProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.amazonmq.CfnBroker.UserProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "users", java.util.Objects.requireNonNull(value, "users is required"));
    }

    /**
     * Optional.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAuthenticationStrategy() {
        return software.amazon.jsii.Kernel.get(this, "authenticationStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Optional.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthenticationStrategy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authenticationStrategy", value);
    }

    /**
     * Enables automatic upgrades to new minor versions for brokers, as new broker engine versions are released and supported by Amazon MQ.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoMinorVersionUpgrade() {
        return software.amazon.jsii.Kernel.get(this, "autoMinorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enables automatic upgrades to new minor versions for brokers, as new broker engine versions are released and supported by Amazon MQ.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoMinorVersionUpgrade(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "autoMinorVersionUpgrade", value);
    }

    /**
     * Enables automatic upgrades to new minor versions for brokers, as new broker engine versions are released and supported by Amazon MQ.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoMinorVersionUpgrade(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoMinorVersionUpgrade", value);
    }

    /**
     * A list of information about the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of information about the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * A list of information about the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amazonmq.CfnBroker.ConfigurationIdProperty value) {
        software.amazon.jsii.Kernel.set(this, "configuration", value);
    }

    /**
     * Defines whether this broker is a part of a data replication pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDataReplicationMode() {
        return software.amazon.jsii.Kernel.get(this, "dataReplicationMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Defines whether this broker is a part of a data replication pair.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataReplicationMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataReplicationMode", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the primary broker that is used to replicate data from in a data replication pair, and is applied to the replica broker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDataReplicationPrimaryBrokerArn() {
        return software.amazon.jsii.Kernel.get(this, "dataReplicationPrimaryBrokerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the primary broker that is used to replicate data from in a data replication pair, and is applied to the replica broker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataReplicationPrimaryBrokerArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dataReplicationPrimaryBrokerArn", value);
    }

    /**
     * Encryption options for the broker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionOptions() {
        return software.amazon.jsii.Kernel.get(this, "encryptionOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Encryption options for the broker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encryptionOptions", value);
    }

    /**
     * Encryption options for the broker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amazonmq.CfnBroker.EncryptionOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "encryptionOptions", value);
    }

    /**
     * The version of the broker engine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the broker engine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineVersion", value);
    }

    /**
     * Optional.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLdapServerMetadata() {
        return software.amazon.jsii.Kernel.get(this, "ldapServerMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Optional.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLdapServerMetadata(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ldapServerMetadata", value);
    }

    /**
     * Optional.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLdapServerMetadata(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amazonmq.CfnBroker.LdapServerMetadataProperty value) {
        software.amazon.jsii.Kernel.set(this, "ldapServerMetadata", value);
    }

    /**
     * Enables Amazon CloudWatch logging for brokers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogs() {
        return software.amazon.jsii.Kernel.get(this, "logs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Enables Amazon CloudWatch logging for brokers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logs", value);
    }

    /**
     * Enables Amazon CloudWatch logging for brokers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogs(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amazonmq.CfnBroker.LogListProperty value) {
        software.amazon.jsii.Kernel.set(this, "logs", value);
    }

    /**
     * The scheduled time period relative to UTC during which Amazon MQ begins to apply pending updates or patches to the broker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMaintenanceWindowStartTime() {
        return software.amazon.jsii.Kernel.get(this, "maintenanceWindowStartTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The scheduled time period relative to UTC during which Amazon MQ begins to apply pending updates or patches to the broker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenanceWindowStartTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "maintenanceWindowStartTime", value);
    }

    /**
     * The scheduled time period relative to UTC during which Amazon MQ begins to apply pending updates or patches to the broker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaintenanceWindowStartTime(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amazonmq.CfnBroker.MaintenanceWindowProperty value) {
        software.amazon.jsii.Kernel.set(this, "maintenanceWindowStartTime", value);
    }

    /**
     * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroups(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "securityGroups", value);
    }

    /**
     * The broker's storage type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStorageType() {
        return software.amazon.jsii.Kernel.get(this, "storageType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The broker's storage type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "storageType", value);
    }

    /**
     * The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubnetIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "subnetIds", value);
    }

    /**
     * An array of key-value pairs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.amazonmq.CfnBroker.TagsEntryProperty> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.amazonmq.CfnBroker.TagsEntryProperty>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.amazonmq.CfnBroker.TagsEntryProperty.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An array of key-value pairs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.amazonmq.CfnBroker.TagsEntryProperty> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A list of information about the configuration.
     * <p>
     * <blockquote>
     * <p>
     * Does not apply to RabbitMQ brokers.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amazonmq.*;
     * ConfigurationIdProperty configurationIdProperty = ConfigurationIdProperty.builder()
     *         .id("id")
     *         .revision(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-configurationid.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-configurationid.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amazonmq.CfnBroker.ConfigurationIdProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationIdProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationIdProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique ID that Amazon MQ generates for the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-configurationid.html#cfn-amazonmq-broker-configurationid-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-configurationid.html#cfn-amazonmq-broker-configurationid-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The revision number of the configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-configurationid.html#cfn-amazonmq-broker-configurationid-revision">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-configurationid.html#cfn-amazonmq-broker-configurationid-revision</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getRevision();

        /**
         * @return a {@link Builder} of {@link ConfigurationIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationIdProperty> {
            java.lang.String id;
            java.lang.Number revision;

            /**
             * Sets the value of {@link ConfigurationIdProperty#getId}
             * @param id The unique ID that Amazon MQ generates for the configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationIdProperty#getRevision}
             * @param revision The revision number of the configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder revision(java.lang.Number revision) {
                this.revision = revision;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationIdProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigurationIdProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigurationIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationIdProperty {
            private final java.lang.String id;
            private final java.lang.Number revision;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.revision = software.amazon.jsii.Kernel.get(this, "revision", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.revision = java.util.Objects.requireNonNull(builder.revision, "revision is required");
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.Number getRevision() {
                return this.revision;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("revision", om.valueToTree(this.getRevision()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amazonmq.CfnBroker.ConfigurationIdProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationIdProperty.Jsii$Proxy that = (ConfigurationIdProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                return this.revision.equals(that.revision);
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.revision.hashCode());
                return result;
            }
        }
    }
    /**
     * Encryption options for the broker.
     * <p>
     * <blockquote>
     * <p>
     * Does not apply to RabbitMQ brokers.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amazonmq.*;
     * EncryptionOptionsProperty encryptionOptionsProperty = EncryptionOptionsProperty.builder()
     *         .useAwsOwnedKey(false)
     *         // the properties below are optional
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-encryptionoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-encryptionoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amazonmq.CfnBroker.EncryptionOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables the use of an AWS owned CMK using AWS KMS (KMS).
         * <p>
         * Set to <code>true</code> by default, if no value is provided, for example, for RabbitMQ brokers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-encryptionoptions.html#cfn-amazonmq-broker-encryptionoptions-useawsownedkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-encryptionoptions.html#cfn-amazonmq-broker-encryptionoptions-useawsownedkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getUseAwsOwnedKey();

        /**
         * The customer master key (CMK) to use for the A AWS KMS (KMS).
         * <p>
         * This key is used to encrypt your data at rest. If not provided, Amazon MQ will use a default CMK to encrypt your data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-encryptionoptions.html#cfn-amazonmq-broker-encryptionoptions-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-encryptionoptions.html#cfn-amazonmq-broker-encryptionoptions-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionOptionsProperty> {
            java.lang.Object useAwsOwnedKey;
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link EncryptionOptionsProperty#getUseAwsOwnedKey}
             * @param useAwsOwnedKey Enables the use of an AWS owned CMK using AWS KMS (KMS). This parameter is required.
             *                       Set to <code>true</code> by default, if no value is provided, for example, for RabbitMQ brokers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useAwsOwnedKey(java.lang.Boolean useAwsOwnedKey) {
                this.useAwsOwnedKey = useAwsOwnedKey;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionOptionsProperty#getUseAwsOwnedKey}
             * @param useAwsOwnedKey Enables the use of an AWS owned CMK using AWS KMS (KMS). This parameter is required.
             *                       Set to <code>true</code> by default, if no value is provided, for example, for RabbitMQ brokers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useAwsOwnedKey(software.amazon.awscdk.IResolvable useAwsOwnedKey) {
                this.useAwsOwnedKey = useAwsOwnedKey;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionOptionsProperty#getKmsKeyId}
             * @param kmsKeyId The customer master key (CMK) to use for the A AWS KMS (KMS).
             *                 This key is used to encrypt your data at rest. If not provided, Amazon MQ will use a default CMK to encrypt your data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionOptionsProperty {
            private final java.lang.Object useAwsOwnedKey;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.useAwsOwnedKey = software.amazon.jsii.Kernel.get(this, "useAwsOwnedKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.useAwsOwnedKey = java.util.Objects.requireNonNull(builder.useAwsOwnedKey, "useAwsOwnedKey is required");
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.Object getUseAwsOwnedKey() {
                return this.useAwsOwnedKey;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("useAwsOwnedKey", om.valueToTree(this.getUseAwsOwnedKey()));
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amazonmq.CfnBroker.EncryptionOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionOptionsProperty.Jsii$Proxy that = (EncryptionOptionsProperty.Jsii$Proxy) o;

                if (!useAwsOwnedKey.equals(that.useAwsOwnedKey)) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.useAwsOwnedKey.hashCode();
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Optional. The metadata of the LDAP server used to authenticate and authorize connections to the broker.
     * <p>
     * <blockquote>
     * <p>
     * Does not apply to RabbitMQ brokers.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amazonmq.*;
     * LdapServerMetadataProperty ldapServerMetadataProperty = LdapServerMetadataProperty.builder()
     *         .hosts(List.of("hosts"))
     *         .roleBase("roleBase")
     *         .roleSearchMatching("roleSearchMatching")
     *         .serviceAccountPassword("serviceAccountPassword")
     *         .serviceAccountUsername("serviceAccountUsername")
     *         .userBase("userBase")
     *         .userSearchMatching("userSearchMatching")
     *         // the properties below are optional
     *         .roleName("roleName")
     *         .roleSearchSubtree(false)
     *         .userRoleName("userRoleName")
     *         .userSearchSubtree(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amazonmq.CfnBroker.LdapServerMetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(LdapServerMetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LdapServerMetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the location of the LDAP server such as AWS Directory Service for Microsoft Active Directory .
         * <p>
         * Optional failover server.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-hosts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-hosts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getHosts();

        /**
         * The distinguished name of the node in the directory information tree (DIT) to search for roles or groups.
         * <p>
         * For example, <code>ou=group</code> , <code>ou=corp</code> , <code>dc=corp</code> , <code>dc=example</code> , <code>dc=com</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolebase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolebase</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleBase();

        /**
         * The LDAP search filter used to find roles within the roleBase.
         * <p>
         * The distinguished name of the user matched by userSearchMatching is substituted into the <code>{0}</code> placeholder in the search filter. The client's username is substituted into the <code>{1}</code> placeholder. For example, if you set this option to <code>(member=uid={1})</code> for the user janedoe, the search filter becomes <code>(member=uid=janedoe)</code> after string substitution. It matches all role entries that have a member attribute equal to <code>uid=janedoe</code> under the subtree selected by the <code>RoleBases</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolesearchmatching">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolesearchmatching</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleSearchMatching();

        /**
         * Service account password.
         * <p>
         * A service account is an account in your LDAP server that has access to initiate a connection. For example, <code>cn=admin</code> , <code>dc=corp</code> , <code>dc=example</code> , <code>dc=com</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-serviceaccountpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-serviceaccountpassword</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServiceAccountPassword();

        /**
         * Service account username.
         * <p>
         * A service account is an account in your LDAP server that has access to initiate a connection. For example, <code>cn=admin</code> , <code>ou=corp</code> , <code>dc=corp</code> , <code>dc=example</code> , <code>dc=com</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-serviceaccountusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-serviceaccountusername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getServiceAccountUsername();

        /**
         * Select a particular subtree of the directory information tree (DIT) to search for user entries.
         * <p>
         * The subtree is specified by a DN, which specifies the base node of the subtree. For example, by setting this option to <code>ou=Users</code> , <code>ou=corp</code> , <code>dc=corp</code> , <code>dc=example</code> , <code>dc=com</code> , the search for user entries is restricted to the subtree beneath <code>ou=Users</code> , <code>ou=corp</code> , <code>dc=corp</code> , <code>dc=example</code> , <code>dc=com</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-userbase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-userbase</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserBase();

        /**
         * The LDAP search filter used to find users within the <code>userBase</code> .
         * <p>
         * The client's username is substituted into the <code>{0}</code> placeholder in the search filter. For example, if this option is set to <code>(uid={0})</code> and the received username is <code>janedoe</code> , the search filter becomes <code>(uid=janedoe)</code> after string substitution. It will result in matching an entry like <code>uid=janedoe</code> , <code>ou=Users</code> , <code>ou=corp</code> , <code>dc=corp</code> , <code>dc=example</code> , <code>dc=com</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-usersearchmatching">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-usersearchmatching</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUserSearchMatching();

        /**
         * The group name attribute in a role entry whose value is the name of that role.
         * <p>
         * For example, you can specify <code>cn</code> for a group entry's common name. If authentication succeeds, then the user is assigned the the value of the <code>cn</code> attribute for each role entry that they are a member of.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleName() {
            return null;
        }

        /**
         * The directory search scope for the role.
         * <p>
         * If set to true, scope is to search the entire subtree.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolesearchsubtree">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-rolesearchsubtree</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRoleSearchSubtree() {
            return null;
        }

        /**
         * The name of the LDAP attribute in the user's directory entry for the user's group membership.
         * <p>
         * In some cases, user roles may be identified by the value of an attribute in the user's directory entry. The <code>UserRoleName</code> option allows you to provide the name of this attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-userrolename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-userrolename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserRoleName() {
            return null;
        }

        /**
         * The directory search scope for the user.
         * <p>
         * If set to true, scope is to search the entire subtree.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-usersearchsubtree">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-ldapservermetadata.html#cfn-amazonmq-broker-ldapservermetadata-usersearchsubtree</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUserSearchSubtree() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LdapServerMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LdapServerMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LdapServerMetadataProperty> {
            java.util.List<java.lang.String> hosts;
            java.lang.String roleBase;
            java.lang.String roleSearchMatching;
            java.lang.String serviceAccountPassword;
            java.lang.String serviceAccountUsername;
            java.lang.String userBase;
            java.lang.String userSearchMatching;
            java.lang.String roleName;
            java.lang.Object roleSearchSubtree;
            java.lang.String userRoleName;
            java.lang.Object userSearchSubtree;

            /**
             * Sets the value of {@link LdapServerMetadataProperty#getHosts}
             * @param hosts Specifies the location of the LDAP server such as AWS Directory Service for Microsoft Active Directory . This parameter is required.
             *              Optional failover server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hosts(java.util.List<java.lang.String> hosts) {
                this.hosts = hosts;
                return this;
            }

            /**
             * Sets the value of {@link LdapServerMetadataProperty#getRoleBase}
             * @param roleBase The distinguished name of the node in the directory information tree (DIT) to search for roles or groups. This parameter is required.
             *                 For example, <code>ou=group</code> , <code>ou=corp</code> , <code>dc=corp</code> , <code>dc=example</code> , <code>dc=com</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleBase(java.lang.String roleBase) {
                this.roleBase = roleBase;
                return this;
            }

            /**
             * Sets the value of {@link LdapServerMetadataProperty#getRoleSearchMatching}
             * @param roleSearchMatching The LDAP search filter used to find roles within the roleBase. This parameter is required.
             *                           The distinguished name of the user matched by userSearchMatching is substituted into the <code>{0}</code> placeholder in the search filter. The client's username is substituted into the <code>{1}</code> placeholder. For example, if you set this option to <code>(member=uid={1})</code> for the user janedoe, the search filter becomes <code>(member=uid=janedoe)</code> after string substitution. It matches all role entries that have a member attribute equal to <code>uid=janedoe</code> under the subtree selected by the <code>RoleBases</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleSearchMatching(java.lang.String roleSearchMatching) {
                this.roleSearchMatching = roleSearchMatching;
                return this;
            }

            /**
             * Sets the value of {@link LdapServerMetadataProperty#getServiceAccountPassword}
             * @param serviceAccountPassword Service account password. This parameter is required.
             *                               A service account is an account in your LDAP server that has access to initiate a connection. For example, <code>cn=admin</code> , <code>dc=corp</code> , <code>dc=example</code> , <code>dc=com</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccountPassword(java.lang.String serviceAccountPassword) {
                this.serviceAccountPassword = serviceAccountPassword;
                return this;
            }

            /**
             * Sets the value of {@link LdapServerMetadataProperty#getServiceAccountUsername}
             * @param serviceAccountUsername Service account username. This parameter is required.
             *                               A service account is an account in your LDAP server that has access to initiate a connection. For example, <code>cn=admin</code> , <code>ou=corp</code> , <code>dc=corp</code> , <code>dc=example</code> , <code>dc=com</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceAccountUsername(java.lang.String serviceAccountUsername) {
                this.serviceAccountUsername = serviceAccountUsername;
                return this;
            }

            /**
             * Sets the value of {@link LdapServerMetadataProperty#getUserBase}
             * @param userBase Select a particular subtree of the directory information tree (DIT) to search for user entries. This parameter is required.
             *                 The subtree is specified by a DN, which specifies the base node of the subtree. For example, by setting this option to <code>ou=Users</code> , <code>ou=corp</code> , <code>dc=corp</code> , <code>dc=example</code> , <code>dc=com</code> , the search for user entries is restricted to the subtree beneath <code>ou=Users</code> , <code>ou=corp</code> , <code>dc=corp</code> , <code>dc=example</code> , <code>dc=com</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userBase(java.lang.String userBase) {
                this.userBase = userBase;
                return this;
            }

            /**
             * Sets the value of {@link LdapServerMetadataProperty#getUserSearchMatching}
             * @param userSearchMatching The LDAP search filter used to find users within the <code>userBase</code> . This parameter is required.
             *                           The client's username is substituted into the <code>{0}</code> placeholder in the search filter. For example, if this option is set to <code>(uid={0})</code> and the received username is <code>janedoe</code> , the search filter becomes <code>(uid=janedoe)</code> after string substitution. It will result in matching an entry like <code>uid=janedoe</code> , <code>ou=Users</code> , <code>ou=corp</code> , <code>dc=corp</code> , <code>dc=example</code> , <code>dc=com</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userSearchMatching(java.lang.String userSearchMatching) {
                this.userSearchMatching = userSearchMatching;
                return this;
            }

            /**
             * Sets the value of {@link LdapServerMetadataProperty#getRoleName}
             * @param roleName The group name attribute in a role entry whose value is the name of that role.
             *                 For example, you can specify <code>cn</code> for a group entry's common name. If authentication succeeds, then the user is assigned the the value of the <code>cn</code> attribute for each role entry that they are a member of.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleName(java.lang.String roleName) {
                this.roleName = roleName;
                return this;
            }

            /**
             * Sets the value of {@link LdapServerMetadataProperty#getRoleSearchSubtree}
             * @param roleSearchSubtree The directory search scope for the role.
             *                          If set to true, scope is to search the entire subtree.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleSearchSubtree(java.lang.Boolean roleSearchSubtree) {
                this.roleSearchSubtree = roleSearchSubtree;
                return this;
            }

            /**
             * Sets the value of {@link LdapServerMetadataProperty#getRoleSearchSubtree}
             * @param roleSearchSubtree The directory search scope for the role.
             *                          If set to true, scope is to search the entire subtree.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleSearchSubtree(software.amazon.awscdk.IResolvable roleSearchSubtree) {
                this.roleSearchSubtree = roleSearchSubtree;
                return this;
            }

            /**
             * Sets the value of {@link LdapServerMetadataProperty#getUserRoleName}
             * @param userRoleName The name of the LDAP attribute in the user's directory entry for the user's group membership.
             *                     In some cases, user roles may be identified by the value of an attribute in the user's directory entry. The <code>UserRoleName</code> option allows you to provide the name of this attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userRoleName(java.lang.String userRoleName) {
                this.userRoleName = userRoleName;
                return this;
            }

            /**
             * Sets the value of {@link LdapServerMetadataProperty#getUserSearchSubtree}
             * @param userSearchSubtree The directory search scope for the user.
             *                          If set to true, scope is to search the entire subtree.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userSearchSubtree(java.lang.Boolean userSearchSubtree) {
                this.userSearchSubtree = userSearchSubtree;
                return this;
            }

            /**
             * Sets the value of {@link LdapServerMetadataProperty#getUserSearchSubtree}
             * @param userSearchSubtree The directory search scope for the user.
             *                          If set to true, scope is to search the entire subtree.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userSearchSubtree(software.amazon.awscdk.IResolvable userSearchSubtree) {
                this.userSearchSubtree = userSearchSubtree;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LdapServerMetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LdapServerMetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LdapServerMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LdapServerMetadataProperty {
            private final java.util.List<java.lang.String> hosts;
            private final java.lang.String roleBase;
            private final java.lang.String roleSearchMatching;
            private final java.lang.String serviceAccountPassword;
            private final java.lang.String serviceAccountUsername;
            private final java.lang.String userBase;
            private final java.lang.String userSearchMatching;
            private final java.lang.String roleName;
            private final java.lang.Object roleSearchSubtree;
            private final java.lang.String userRoleName;
            private final java.lang.Object userSearchSubtree;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hosts = software.amazon.jsii.Kernel.get(this, "hosts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.roleBase = software.amazon.jsii.Kernel.get(this, "roleBase", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleSearchMatching = software.amazon.jsii.Kernel.get(this, "roleSearchMatching", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceAccountPassword = software.amazon.jsii.Kernel.get(this, "serviceAccountPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceAccountUsername = software.amazon.jsii.Kernel.get(this, "serviceAccountUsername", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userBase = software.amazon.jsii.Kernel.get(this, "userBase", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userSearchMatching = software.amazon.jsii.Kernel.get(this, "userSearchMatching", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleName = software.amazon.jsii.Kernel.get(this, "roleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleSearchSubtree = software.amazon.jsii.Kernel.get(this, "roleSearchSubtree", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.userRoleName = software.amazon.jsii.Kernel.get(this, "userRoleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userSearchSubtree = software.amazon.jsii.Kernel.get(this, "userSearchSubtree", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hosts = java.util.Objects.requireNonNull(builder.hosts, "hosts is required");
                this.roleBase = java.util.Objects.requireNonNull(builder.roleBase, "roleBase is required");
                this.roleSearchMatching = java.util.Objects.requireNonNull(builder.roleSearchMatching, "roleSearchMatching is required");
                this.serviceAccountPassword = java.util.Objects.requireNonNull(builder.serviceAccountPassword, "serviceAccountPassword is required");
                this.serviceAccountUsername = java.util.Objects.requireNonNull(builder.serviceAccountUsername, "serviceAccountUsername is required");
                this.userBase = java.util.Objects.requireNonNull(builder.userBase, "userBase is required");
                this.userSearchMatching = java.util.Objects.requireNonNull(builder.userSearchMatching, "userSearchMatching is required");
                this.roleName = builder.roleName;
                this.roleSearchSubtree = builder.roleSearchSubtree;
                this.userRoleName = builder.userRoleName;
                this.userSearchSubtree = builder.userSearchSubtree;
            }

            @Override
            public final java.util.List<java.lang.String> getHosts() {
                return this.hosts;
            }

            @Override
            public final java.lang.String getRoleBase() {
                return this.roleBase;
            }

            @Override
            public final java.lang.String getRoleSearchMatching() {
                return this.roleSearchMatching;
            }

            @Override
            public final java.lang.String getServiceAccountPassword() {
                return this.serviceAccountPassword;
            }

            @Override
            public final java.lang.String getServiceAccountUsername() {
                return this.serviceAccountUsername;
            }

            @Override
            public final java.lang.String getUserBase() {
                return this.userBase;
            }

            @Override
            public final java.lang.String getUserSearchMatching() {
                return this.userSearchMatching;
            }

            @Override
            public final java.lang.String getRoleName() {
                return this.roleName;
            }

            @Override
            public final java.lang.Object getRoleSearchSubtree() {
                return this.roleSearchSubtree;
            }

            @Override
            public final java.lang.String getUserRoleName() {
                return this.userRoleName;
            }

            @Override
            public final java.lang.Object getUserSearchSubtree() {
                return this.userSearchSubtree;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hosts", om.valueToTree(this.getHosts()));
                data.set("roleBase", om.valueToTree(this.getRoleBase()));
                data.set("roleSearchMatching", om.valueToTree(this.getRoleSearchMatching()));
                data.set("serviceAccountPassword", om.valueToTree(this.getServiceAccountPassword()));
                data.set("serviceAccountUsername", om.valueToTree(this.getServiceAccountUsername()));
                data.set("userBase", om.valueToTree(this.getUserBase()));
                data.set("userSearchMatching", om.valueToTree(this.getUserSearchMatching()));
                if (this.getRoleName() != null) {
                    data.set("roleName", om.valueToTree(this.getRoleName()));
                }
                if (this.getRoleSearchSubtree() != null) {
                    data.set("roleSearchSubtree", om.valueToTree(this.getRoleSearchSubtree()));
                }
                if (this.getUserRoleName() != null) {
                    data.set("userRoleName", om.valueToTree(this.getUserRoleName()));
                }
                if (this.getUserSearchSubtree() != null) {
                    data.set("userSearchSubtree", om.valueToTree(this.getUserSearchSubtree()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amazonmq.CfnBroker.LdapServerMetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LdapServerMetadataProperty.Jsii$Proxy that = (LdapServerMetadataProperty.Jsii$Proxy) o;

                if (!hosts.equals(that.hosts)) return false;
                if (!roleBase.equals(that.roleBase)) return false;
                if (!roleSearchMatching.equals(that.roleSearchMatching)) return false;
                if (!serviceAccountPassword.equals(that.serviceAccountPassword)) return false;
                if (!serviceAccountUsername.equals(that.serviceAccountUsername)) return false;
                if (!userBase.equals(that.userBase)) return false;
                if (!userSearchMatching.equals(that.userSearchMatching)) return false;
                if (this.roleName != null ? !this.roleName.equals(that.roleName) : that.roleName != null) return false;
                if (this.roleSearchSubtree != null ? !this.roleSearchSubtree.equals(that.roleSearchSubtree) : that.roleSearchSubtree != null) return false;
                if (this.userRoleName != null ? !this.userRoleName.equals(that.userRoleName) : that.userRoleName != null) return false;
                return this.userSearchSubtree != null ? this.userSearchSubtree.equals(that.userSearchSubtree) : that.userSearchSubtree == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hosts.hashCode();
                result = 31 * result + (this.roleBase.hashCode());
                result = 31 * result + (this.roleSearchMatching.hashCode());
                result = 31 * result + (this.serviceAccountPassword.hashCode());
                result = 31 * result + (this.serviceAccountUsername.hashCode());
                result = 31 * result + (this.userBase.hashCode());
                result = 31 * result + (this.userSearchMatching.hashCode());
                result = 31 * result + (this.roleName != null ? this.roleName.hashCode() : 0);
                result = 31 * result + (this.roleSearchSubtree != null ? this.roleSearchSubtree.hashCode() : 0);
                result = 31 * result + (this.userRoleName != null ? this.userRoleName.hashCode() : 0);
                result = 31 * result + (this.userSearchSubtree != null ? this.userSearchSubtree.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The list of information about logs to be enabled for the specified broker.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amazonmq.*;
     * LogListProperty logListProperty = LogListProperty.builder()
     *         .audit(false)
     *         .general(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-loglist.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-loglist.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amazonmq.CfnBroker.LogListProperty")
    @software.amazon.jsii.Jsii.Proxy(LogListProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogListProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enables audit logging.
         * <p>
         * Every user management action made using JMX or the ActiveMQ Web Console is logged. Does not apply to RabbitMQ brokers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-loglist.html#cfn-amazonmq-broker-loglist-audit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-loglist.html#cfn-amazonmq-broker-loglist-audit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAudit() {
            return null;
        }

        /**
         * Enables general logging.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-loglist.html#cfn-amazonmq-broker-loglist-general">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-loglist.html#cfn-amazonmq-broker-loglist-general</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGeneral() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogListProperty> {
            java.lang.Object audit;
            java.lang.Object general;

            /**
             * Sets the value of {@link LogListProperty#getAudit}
             * @param audit Enables audit logging.
             *              Every user management action made using JMX or the ActiveMQ Web Console is logged. Does not apply to RabbitMQ brokers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audit(java.lang.Boolean audit) {
                this.audit = audit;
                return this;
            }

            /**
             * Sets the value of {@link LogListProperty#getAudit}
             * @param audit Enables audit logging.
             *              Every user management action made using JMX or the ActiveMQ Web Console is logged. Does not apply to RabbitMQ brokers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder audit(software.amazon.awscdk.IResolvable audit) {
                this.audit = audit;
                return this;
            }

            /**
             * Sets the value of {@link LogListProperty#getGeneral}
             * @param general Enables general logging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder general(java.lang.Boolean general) {
                this.general = general;
                return this;
            }

            /**
             * Sets the value of {@link LogListProperty#getGeneral}
             * @param general Enables general logging.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder general(software.amazon.awscdk.IResolvable general) {
                this.general = general;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogListProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogListProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogListProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogListProperty {
            private final java.lang.Object audit;
            private final java.lang.Object general;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.audit = software.amazon.jsii.Kernel.get(this, "audit", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.general = software.amazon.jsii.Kernel.get(this, "general", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.audit = builder.audit;
                this.general = builder.general;
            }

            @Override
            public final java.lang.Object getAudit() {
                return this.audit;
            }

            @Override
            public final java.lang.Object getGeneral() {
                return this.general;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAudit() != null) {
                    data.set("audit", om.valueToTree(this.getAudit()));
                }
                if (this.getGeneral() != null) {
                    data.set("general", om.valueToTree(this.getGeneral()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amazonmq.CfnBroker.LogListProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogListProperty.Jsii$Proxy that = (LogListProperty.Jsii$Proxy) o;

                if (this.audit != null ? !this.audit.equals(that.audit) : that.audit != null) return false;
                return this.general != null ? this.general.equals(that.general) : that.general == null;
            }

            @Override
            public final int hashCode() {
                int result = this.audit != null ? this.audit.hashCode() : 0;
                result = 31 * result + (this.general != null ? this.general.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The parameters that determine the <code>WeeklyStartTime</code> to apply pending updates or patches to the broker.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amazonmq.*;
     * MaintenanceWindowProperty maintenanceWindowProperty = MaintenanceWindowProperty.builder()
     *         .dayOfWeek("dayOfWeek")
     *         .timeOfDay("timeOfDay")
     *         .timeZone("timeZone")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amazonmq.CfnBroker.MaintenanceWindowProperty")
    @software.amazon.jsii.Jsii.Proxy(MaintenanceWindowProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MaintenanceWindowProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The day of the week.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html#cfn-amazonmq-broker-maintenancewindow-dayofweek">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html#cfn-amazonmq-broker-maintenancewindow-dayofweek</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDayOfWeek();

        /**
         * The time, in 24-hour format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html#cfn-amazonmq-broker-maintenancewindow-timeofday">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html#cfn-amazonmq-broker-maintenancewindow-timeofday</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTimeOfDay();

        /**
         * The time zone, UTC by default, in either the Country/City format, or the UTC offset format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html#cfn-amazonmq-broker-maintenancewindow-timezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-maintenancewindow.html#cfn-amazonmq-broker-maintenancewindow-timezone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTimeZone();

        /**
         * @return a {@link Builder} of {@link MaintenanceWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MaintenanceWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MaintenanceWindowProperty> {
            java.lang.String dayOfWeek;
            java.lang.String timeOfDay;
            java.lang.String timeZone;

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getDayOfWeek}
             * @param dayOfWeek The day of the week. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dayOfWeek(java.lang.String dayOfWeek) {
                this.dayOfWeek = dayOfWeek;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getTimeOfDay}
             * @param timeOfDay The time, in 24-hour format. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeOfDay(java.lang.String timeOfDay) {
                this.timeOfDay = timeOfDay;
                return this;
            }

            /**
             * Sets the value of {@link MaintenanceWindowProperty#getTimeZone}
             * @param timeZone The time zone, UTC by default, in either the Country/City format, or the UTC offset format. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeZone(java.lang.String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MaintenanceWindowProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MaintenanceWindowProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MaintenanceWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MaintenanceWindowProperty {
            private final java.lang.String dayOfWeek;
            private final java.lang.String timeOfDay;
            private final java.lang.String timeZone;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dayOfWeek = software.amazon.jsii.Kernel.get(this, "dayOfWeek", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeOfDay = software.amazon.jsii.Kernel.get(this, "timeOfDay", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeZone = software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dayOfWeek = java.util.Objects.requireNonNull(builder.dayOfWeek, "dayOfWeek is required");
                this.timeOfDay = java.util.Objects.requireNonNull(builder.timeOfDay, "timeOfDay is required");
                this.timeZone = java.util.Objects.requireNonNull(builder.timeZone, "timeZone is required");
            }

            @Override
            public final java.lang.String getDayOfWeek() {
                return this.dayOfWeek;
            }

            @Override
            public final java.lang.String getTimeOfDay() {
                return this.timeOfDay;
            }

            @Override
            public final java.lang.String getTimeZone() {
                return this.timeZone;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dayOfWeek", om.valueToTree(this.getDayOfWeek()));
                data.set("timeOfDay", om.valueToTree(this.getTimeOfDay()));
                data.set("timeZone", om.valueToTree(this.getTimeZone()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amazonmq.CfnBroker.MaintenanceWindowProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MaintenanceWindowProperty.Jsii$Proxy that = (MaintenanceWindowProperty.Jsii$Proxy) o;

                if (!dayOfWeek.equals(that.dayOfWeek)) return false;
                if (!timeOfDay.equals(that.timeOfDay)) return false;
                return this.timeZone.equals(that.timeZone);
            }

            @Override
            public final int hashCode() {
                int result = this.dayOfWeek.hashCode();
                result = 31 * result + (this.timeOfDay.hashCode());
                result = 31 * result + (this.timeZone.hashCode());
                return result;
            }
        }
    }
    /**
     * A key-value pair to associate with the broker.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amazonmq.*;
     * TagsEntryProperty tagsEntryProperty = TagsEntryProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-tagsentry.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-tagsentry.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amazonmq.CfnBroker.TagsEntryProperty")
    @software.amazon.jsii.Jsii.Proxy(TagsEntryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagsEntryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key in a key-value pair.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-tagsentry.html#cfn-amazonmq-broker-tagsentry-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-tagsentry.html#cfn-amazonmq-broker-tagsentry-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The value in a key-value pair.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-tagsentry.html#cfn-amazonmq-broker-tagsentry-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-tagsentry.html#cfn-amazonmq-broker-tagsentry-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link TagsEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagsEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagsEntryProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link TagsEntryProperty#getKey}
             * @param key The key in a key-value pair. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TagsEntryProperty#getValue}
             * @param value The value in a key-value pair. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagsEntryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagsEntryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagsEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagsEntryProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amazonmq.CfnBroker.TagsEntryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagsEntryProperty.Jsii$Proxy that = (TagsEntryProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * The list of broker users (persons or applications) who can access queues and topics.
     * <p>
     * For Amazon MQ for RabbitMQ brokers, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent broker users are created via the RabbitMQ web console or by using the RabbitMQ management API.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amazonmq.*;
     * UserProperty userProperty = UserProperty.builder()
     *         .password("password")
     *         .username("username")
     *         // the properties below are optional
     *         .consoleAccess(false)
     *         .groups(List.of("groups"))
     *         .jolokiaApiAccess("jolokiaApiAccess")
     *         .replicationUser(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amazonmq.CfnBroker.UserProperty")
    @software.amazon.jsii.Jsii.Proxy(UserProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UserProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The password of the user.
         * <p>
         * This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-password">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-password</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPassword();

        /**
         * The username of the broker user.
         * <p>
         * For Amazon MQ for ActiveMQ brokers, this value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). For Amazon MQ for RabbitMQ brokers, this value can contain only alphanumeric characters, dashes, periods, underscores (- . _). This value must not contain a tilde (~) character. Amazon MQ prohibts using guest as a valid usename. This value must be 2-100 characters long.
         * <p>
         * <blockquote>
         * <p>
         * Do not add personally identifiable information (PII) or other confidential or sensitive information in broker usernames. Broker usernames are accessible to other AWS services, including CloudWatch Logs . Broker usernames are not intended to be used for private or sensitive data.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-username">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-username</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUsername();

        /**
         * Enables access to the ActiveMQ web console for the ActiveMQ user.
         * <p>
         * Does not apply to RabbitMQ brokers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-consoleaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-consoleaccess</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConsoleAccess() {
            return null;
        }

        /**
         * The list of groups (20 maximum) to which the ActiveMQ user belongs.
         * <p>
         * This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long. Does not apply to RabbitMQ brokers.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-groups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-groups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGroups() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-jolokiaapiaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-jolokiaapiaccess</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getJolokiaApiAccess() {
            return null;
        }

        /**
         * Defines if this user is intended for CRDR replication purposes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-replicationuser">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amazonmq-broker-user.html#cfn-amazonmq-broker-user-replicationuser</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getReplicationUser() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UserProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UserProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UserProperty> {
            java.lang.String password;
            java.lang.String username;
            java.lang.Object consoleAccess;
            java.util.List<java.lang.String> groups;
            java.lang.String jolokiaApiAccess;
            java.lang.Object replicationUser;

            /**
             * Sets the value of {@link UserProperty#getPassword}
             * @param password The password of the user. This parameter is required.
             *                 This value must be at least 12 characters long, must contain at least 4 unique characters, and must not contain commas, colons, or equal signs (,:=).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder password(java.lang.String password) {
                this.password = password;
                return this;
            }

            /**
             * Sets the value of {@link UserProperty#getUsername}
             * @param username The username of the broker user. This parameter is required.
             *                 For Amazon MQ for ActiveMQ brokers, this value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). For Amazon MQ for RabbitMQ brokers, this value can contain only alphanumeric characters, dashes, periods, underscores (- . _). This value must not contain a tilde (~) character. Amazon MQ prohibts using guest as a valid usename. This value must be 2-100 characters long.
             *                 <p>
             *                 <blockquote>
             *                 <p>
             *                 Do not add personally identifiable information (PII) or other confidential or sensitive information in broker usernames. Broker usernames are accessible to other AWS services, including CloudWatch Logs . Broker usernames are not intended to be used for private or sensitive data.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder username(java.lang.String username) {
                this.username = username;
                return this;
            }

            /**
             * Sets the value of {@link UserProperty#getConsoleAccess}
             * @param consoleAccess Enables access to the ActiveMQ web console for the ActiveMQ user.
             *                      Does not apply to RabbitMQ brokers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consoleAccess(java.lang.Boolean consoleAccess) {
                this.consoleAccess = consoleAccess;
                return this;
            }

            /**
             * Sets the value of {@link UserProperty#getConsoleAccess}
             * @param consoleAccess Enables access to the ActiveMQ web console for the ActiveMQ user.
             *                      Does not apply to RabbitMQ brokers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder consoleAccess(software.amazon.awscdk.IResolvable consoleAccess) {
                this.consoleAccess = consoleAccess;
                return this;
            }

            /**
             * Sets the value of {@link UserProperty#getGroups}
             * @param groups The list of groups (20 maximum) to which the ActiveMQ user belongs.
             *               This value can contain only alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long. Does not apply to RabbitMQ brokers.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groups(java.util.List<java.lang.String> groups) {
                this.groups = groups;
                return this;
            }

            /**
             * Sets the value of {@link UserProperty#getJolokiaApiAccess}
             * @param jolokiaApiAccess the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jolokiaApiAccess(java.lang.String jolokiaApiAccess) {
                this.jolokiaApiAccess = jolokiaApiAccess;
                return this;
            }

            /**
             * Sets the value of {@link UserProperty#getReplicationUser}
             * @param replicationUser Defines if this user is intended for CRDR replication purposes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicationUser(java.lang.Boolean replicationUser) {
                this.replicationUser = replicationUser;
                return this;
            }

            /**
             * Sets the value of {@link UserProperty#getReplicationUser}
             * @param replicationUser Defines if this user is intended for CRDR replication purposes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replicationUser(software.amazon.awscdk.IResolvable replicationUser) {
                this.replicationUser = replicationUser;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UserProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UserProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UserProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserProperty {
            private final java.lang.String password;
            private final java.lang.String username;
            private final java.lang.Object consoleAccess;
            private final java.util.List<java.lang.String> groups;
            private final java.lang.String jolokiaApiAccess;
            private final java.lang.Object replicationUser;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.password = software.amazon.jsii.Kernel.get(this, "password", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.username = software.amazon.jsii.Kernel.get(this, "username", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.consoleAccess = software.amazon.jsii.Kernel.get(this, "consoleAccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.groups = software.amazon.jsii.Kernel.get(this, "groups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.jolokiaApiAccess = software.amazon.jsii.Kernel.get(this, "jolokiaApiAccess", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.replicationUser = software.amazon.jsii.Kernel.get(this, "replicationUser", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.password = java.util.Objects.requireNonNull(builder.password, "password is required");
                this.username = java.util.Objects.requireNonNull(builder.username, "username is required");
                this.consoleAccess = builder.consoleAccess;
                this.groups = builder.groups;
                this.jolokiaApiAccess = builder.jolokiaApiAccess;
                this.replicationUser = builder.replicationUser;
            }

            @Override
            public final java.lang.String getPassword() {
                return this.password;
            }

            @Override
            public final java.lang.String getUsername() {
                return this.username;
            }

            @Override
            public final java.lang.Object getConsoleAccess() {
                return this.consoleAccess;
            }

            @Override
            public final java.util.List<java.lang.String> getGroups() {
                return this.groups;
            }

            @Override
            public final java.lang.String getJolokiaApiAccess() {
                return this.jolokiaApiAccess;
            }

            @Override
            public final java.lang.Object getReplicationUser() {
                return this.replicationUser;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("password", om.valueToTree(this.getPassword()));
                data.set("username", om.valueToTree(this.getUsername()));
                if (this.getConsoleAccess() != null) {
                    data.set("consoleAccess", om.valueToTree(this.getConsoleAccess()));
                }
                if (this.getGroups() != null) {
                    data.set("groups", om.valueToTree(this.getGroups()));
                }
                if (this.getJolokiaApiAccess() != null) {
                    data.set("jolokiaApiAccess", om.valueToTree(this.getJolokiaApiAccess()));
                }
                if (this.getReplicationUser() != null) {
                    data.set("replicationUser", om.valueToTree(this.getReplicationUser()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amazonmq.CfnBroker.UserProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UserProperty.Jsii$Proxy that = (UserProperty.Jsii$Proxy) o;

                if (!password.equals(that.password)) return false;
                if (!username.equals(that.username)) return false;
                if (this.consoleAccess != null ? !this.consoleAccess.equals(that.consoleAccess) : that.consoleAccess != null) return false;
                if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) return false;
                if (this.jolokiaApiAccess != null ? !this.jolokiaApiAccess.equals(that.jolokiaApiAccess) : that.jolokiaApiAccess != null) return false;
                return this.replicationUser != null ? this.replicationUser.equals(that.replicationUser) : that.replicationUser == null;
            }

            @Override
            public final int hashCode() {
                int result = this.password.hashCode();
                result = 31 * result + (this.username.hashCode());
                result = 31 * result + (this.consoleAccess != null ? this.consoleAccess.hashCode() : 0);
                result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
                result = 31 * result + (this.jolokiaApiAccess != null ? this.jolokiaApiAccess.hashCode() : 0);
                result = 31 * result + (this.replicationUser != null ? this.replicationUser.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.amazonmq.CfnBroker}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.amazonmq.CfnBroker> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.amazonmq.CfnBrokerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.amazonmq.CfnBrokerProps.Builder();
        }

        /**
         * The name of the broker.
         * <p>
         * This value must be unique in your AWS account , 1-50 characters long, must contain only letters, numbers, dashes, and underscores, and must not contain white spaces, brackets, wildcard characters, or special characters.
         * <p>
         * <blockquote>
         * <p>
         * Do not add personally identifiable information (PII) or other confidential or sensitive information in broker names. Broker names are accessible to other AWS services, including C CloudWatch Logs . Broker names are not intended to be used for private or sensitive data.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-brokername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-brokername</a>
         * @param brokerName The name of the broker. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder brokerName(final java.lang.String brokerName) {
            this.props.brokerName(brokerName);
            return this;
        }

        /**
         * The deployment mode of the broker. Available values:.
         * <p>
         * <ul>
         * <li><code>SINGLE_INSTANCE</code></li>
         * <li><code>ACTIVE_STANDBY_MULTI_AZ</code></li>
         * <li><code>CLUSTER_MULTI_AZ</code></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-deploymentmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-deploymentmode</a>
         * @param deploymentMode The deployment mode of the broker. Available values:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentMode(final java.lang.String deploymentMode) {
            this.props.deploymentMode(deploymentMode);
            return this;
        }

        /**
         * The type of broker engine.
         * <p>
         * Currently, Amazon MQ supports <code>ACTIVEMQ</code> and <code>RABBITMQ</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-enginetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-enginetype</a>
         * @param engineType The type of broker engine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineType(final java.lang.String engineType) {
            this.props.engineType(engineType);
            return this;
        }

        /**
         * The broker's instance type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-hostinstancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-hostinstancetype</a>
         * @param hostInstanceType The broker's instance type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostInstanceType(final java.lang.String hostInstanceType) {
            this.props.hostInstanceType(hostInstanceType);
            return this;
        }

        /**
         * Enables connections from applications outside of the VPC that hosts the broker's subnets.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-publiclyaccessible</a>
         * @param publiclyAccessible Enables connections from applications outside of the VPC that hosts the broker's subnets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final java.lang.Boolean publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }
        /**
         * Enables connections from applications outside of the VPC that hosts the broker's subnets.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-publiclyaccessible</a>
         * @param publiclyAccessible Enables connections from applications outside of the VPC that hosts the broker's subnets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final software.amazon.awscdk.IResolvable publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }

        /**
         * The list of broker users (persons or applications) who can access queues and topics.
         * <p>
         * For Amazon MQ for RabbitMQ brokers, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent RabbitMQ users are created by via the RabbitMQ web console or by using the RabbitMQ management API.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-users">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-users</a>
         * @param users The list of broker users (persons or applications) who can access queues and topics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder users(final software.amazon.awscdk.IResolvable users) {
            this.props.users(users);
            return this;
        }
        /**
         * The list of broker users (persons or applications) who can access queues and topics.
         * <p>
         * For Amazon MQ for RabbitMQ brokers, one and only one administrative user is accepted and created when a broker is first provisioned. All subsequent RabbitMQ users are created by via the RabbitMQ web console or by using the RabbitMQ management API.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-users">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-users</a>
         * @param users The list of broker users (persons or applications) who can access queues and topics. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder users(final java.util.List<? extends java.lang.Object> users) {
            this.props.users(users);
            return this;
        }

        /**
         * Optional.
         * <p>
         * The authentication strategy used to secure the broker. The default is <code>SIMPLE</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-authenticationstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-authenticationstrategy</a>
         * @param authenticationStrategy Optional. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationStrategy(final java.lang.String authenticationStrategy) {
            this.props.authenticationStrategy(authenticationStrategy);
            return this;
        }

        /**
         * Enables automatic upgrades to new minor versions for brokers, as new broker engine versions are released and supported by Amazon MQ.
         * <p>
         * Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-autominorversionupgrade">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-autominorversionupgrade</a>
         * @param autoMinorVersionUpgrade Enables automatic upgrades to new minor versions for brokers, as new broker engine versions are released and supported by Amazon MQ. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(final java.lang.Boolean autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }
        /**
         * Enables automatic upgrades to new minor versions for brokers, as new broker engine versions are released and supported by Amazon MQ.
         * <p>
         * Automatic upgrades occur during the scheduled maintenance window of the broker or after a manual broker reboot.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-autominorversionupgrade">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-autominorversionupgrade</a>
         * @param autoMinorVersionUpgrade Enables automatic upgrades to new minor versions for brokers, as new broker engine versions are released and supported by Amazon MQ. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(final software.amazon.awscdk.IResolvable autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        /**
         * A list of information about the configuration.
         * <p>
         * Does not apply to RabbitMQ brokers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-configuration</a>
         * @param configuration A list of information about the configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.IResolvable configuration) {
            this.props.configuration(configuration);
            return this;
        }
        /**
         * A list of information about the configuration.
         * <p>
         * Does not apply to RabbitMQ brokers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-configuration</a>
         * @param configuration A list of information about the configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(final software.amazon.awscdk.services.amazonmq.CfnBroker.ConfigurationIdProperty configuration) {
            this.props.configuration(configuration);
            return this;
        }

        /**
         * Defines whether this broker is a part of a data replication pair.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-datareplicationmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-datareplicationmode</a>
         * @param dataReplicationMode Defines whether this broker is a part of a data replication pair. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataReplicationMode(final java.lang.String dataReplicationMode) {
            this.props.dataReplicationMode(dataReplicationMode);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the primary broker that is used to replicate data from in a data replication pair, and is applied to the replica broker.
         * <p>
         * Must be set when dataReplicationMode is set to CRDR.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-datareplicationprimarybrokerarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-datareplicationprimarybrokerarn</a>
         * @param dataReplicationPrimaryBrokerArn The Amazon Resource Name (ARN) of the primary broker that is used to replicate data from in a data replication pair, and is applied to the replica broker. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataReplicationPrimaryBrokerArn(final java.lang.String dataReplicationPrimaryBrokerArn) {
            this.props.dataReplicationPrimaryBrokerArn(dataReplicationPrimaryBrokerArn);
            return this;
        }

        /**
         * Encryption options for the broker.
         * <p>
         * Does not apply to RabbitMQ brokers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-encryptionoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-encryptionoptions</a>
         * @param encryptionOptions Encryption options for the broker. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionOptions(final software.amazon.awscdk.IResolvable encryptionOptions) {
            this.props.encryptionOptions(encryptionOptions);
            return this;
        }
        /**
         * Encryption options for the broker.
         * <p>
         * Does not apply to RabbitMQ brokers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-encryptionoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-encryptionoptions</a>
         * @param encryptionOptions Encryption options for the broker. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionOptions(final software.amazon.awscdk.services.amazonmq.CfnBroker.EncryptionOptionsProperty encryptionOptions) {
            this.props.encryptionOptions(encryptionOptions);
            return this;
        }

        /**
         * The version of the broker engine.
         * <p>
         * For a list of supported engine versions, see <a href="https://docs.aws.amazon.com/amazon-mq/latest/developer-guide/broker-engine.html">Engine</a> in the <em>Amazon MQ Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-engineversion</a>
         * @param engineVersion The version of the broker engine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(final java.lang.String engineVersion) {
            this.props.engineVersion(engineVersion);
            return this;
        }

        /**
         * Optional.
         * <p>
         * The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-ldapservermetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-ldapservermetadata</a>
         * @param ldapServerMetadata Optional. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ldapServerMetadata(final software.amazon.awscdk.IResolvable ldapServerMetadata) {
            this.props.ldapServerMetadata(ldapServerMetadata);
            return this;
        }
        /**
         * Optional.
         * <p>
         * The metadata of the LDAP server used to authenticate and authorize connections to the broker. Does not apply to RabbitMQ brokers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-ldapservermetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-ldapservermetadata</a>
         * @param ldapServerMetadata Optional. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ldapServerMetadata(final software.amazon.awscdk.services.amazonmq.CfnBroker.LdapServerMetadataProperty ldapServerMetadata) {
            this.props.ldapServerMetadata(ldapServerMetadata);
            return this;
        }

        /**
         * Enables Amazon CloudWatch logging for brokers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-logs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-logs</a>
         * @param logs Enables Amazon CloudWatch logging for brokers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logs(final software.amazon.awscdk.IResolvable logs) {
            this.props.logs(logs);
            return this;
        }
        /**
         * Enables Amazon CloudWatch logging for brokers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-logs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-logs</a>
         * @param logs Enables Amazon CloudWatch logging for brokers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logs(final software.amazon.awscdk.services.amazonmq.CfnBroker.LogListProperty logs) {
            this.props.logs(logs);
            return this;
        }

        /**
         * The scheduled time period relative to UTC during which Amazon MQ begins to apply pending updates or patches to the broker.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-maintenancewindowstarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-maintenancewindowstarttime</a>
         * @param maintenanceWindowStartTime The scheduled time period relative to UTC during which Amazon MQ begins to apply pending updates or patches to the broker. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindowStartTime(final software.amazon.awscdk.IResolvable maintenanceWindowStartTime) {
            this.props.maintenanceWindowStartTime(maintenanceWindowStartTime);
            return this;
        }
        /**
         * The scheduled time period relative to UTC during which Amazon MQ begins to apply pending updates or patches to the broker.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-maintenancewindowstarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-maintenancewindowstarttime</a>
         * @param maintenanceWindowStartTime The scheduled time period relative to UTC during which Amazon MQ begins to apply pending updates or patches to the broker. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maintenanceWindowStartTime(final software.amazon.awscdk.services.amazonmq.CfnBroker.MaintenanceWindowProperty maintenanceWindowStartTime) {
            this.props.maintenanceWindowStartTime(maintenanceWindowStartTime);
            return this;
        }

        /**
         * The list of rules (1 minimum, 125 maximum) that authorize connections to brokers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-securitygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-securitygroups</a>
         * @param securityGroups The list of rules (1 minimum, 125 maximum) that authorize connections to brokers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<java.lang.String> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * The broker's storage type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-storagetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-storagetype</a>
         * @param storageType The broker's storage type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageType(final java.lang.String storageType) {
            this.props.storageType(storageType);
            return this;
        }

        /**
         * The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones.
         * <p>
         * If you specify more than one subnet, the subnets must be in different Availability Zones. Amazon MQ will not be able to create VPC endpoints for your broker with multiple subnets in the same Availability Zone. A SINGLE_INSTANCE deployment requires one subnet (for example, the default subnet). An ACTIVE_STANDBY_MULTI_AZ deployment (ACTIVEMQ) requires two subnets. A CLUSTER_MULTI_AZ deployment (RABBITMQ) has no subnet requirements when deployed with public accessibility, deployment without public accessibility requires at least one subnet.
         * <p>
         * <blockquote>
         * <p>
         * If you specify subnets in a shared VPC for a RabbitMQ broker, the associated VPC to which the specified subnets belong must be owned by your AWS account . Amazon MQ will not be able to create VPC enpoints in VPCs that are not owned by your AWS account .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-subnetids</a>
         * @param subnetIds The list of groups that define which subnets and IP ranges the broker can use from different Availability Zones. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(final java.util.List<java.lang.String> subnetIds) {
            this.props.subnetIds(subnetIds);
            return this;
        }

        /**
         * An array of key-value pairs.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the <em>Billing and Cost Management User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html#cfn-amazonmq-broker-tags</a>
         * @param tags An array of key-value pairs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.services.amazonmq.CfnBroker.TagsEntryProperty> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.amazonmq.CfnBroker}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.amazonmq.CfnBroker build() {
            return new software.amazon.awscdk.services.amazonmq.CfnBroker(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
