package software.amazon.awscdk.services.amplifyuibuilder;

/**
 * The AWS::AmplifyUIBuilder::Component resource specifies a component within an Amplify app.
 * <p>
 * A component is a user interface (UI) element that you can customize. Use <code>ComponentChild</code> to configure an instance of a <code>Component</code> . A <code>ComponentChild</code> instance inherits the configuration of the main <code>Component</code> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:10.152Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnComponent")
public class CfnComponent extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnComponent(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnComponent(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnComponent(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.amplifyuibuilder.CfnComponentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnComponent(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The time that the component was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID of the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time that the component was modified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrModifiedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrModifiedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The unique ID of the Amplify app associated with the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAppId() {
        return software.amazon.jsii.Kernel.get(this, "appId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID of the Amplify app associated with the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAppId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "appId", value);
    }

    /**
     * The information to connect a component's properties to data at runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getBindingProperties() {
        return software.amazon.jsii.Kernel.get(this, "bindingProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The information to connect a component's properties to data at runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBindingProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "bindingProperties", value);
    }

    /**
     * The information to connect a component's properties to data at runtime.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBindingProperties(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentBindingPropertiesValueProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentBindingPropertiesValueProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "bindingProperties", value);
    }

    /**
     * A list of the component's <code>ComponentChild</code> instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getChildren() {
        return software.amazon.jsii.Kernel.get(this, "children", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of the component's <code>ComponentChild</code> instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChildren(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "children", value);
    }

    /**
     * A list of the component's <code>ComponentChild</code> instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setChildren(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentChildProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentChildProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "children", value);
    }

    /**
     * The data binding configuration for the component's properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCollectionProperties() {
        return software.amazon.jsii.Kernel.get(this, "collectionProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The data binding configuration for the component's properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCollectionProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "collectionProperties", value);
    }

    /**
     * The data binding configuration for the component's properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCollectionProperties(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentDataConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentDataConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "collectionProperties", value);
    }

    /**
     * The type of the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getComponentType() {
        return software.amazon.jsii.Kernel.get(this, "componentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComponentType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "componentType", value);
    }

    /**
     * The name of the backend environment that is a part of the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentName() {
        return software.amazon.jsii.Kernel.get(this, "environmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the backend environment that is a part of the Amplify app.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironmentName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "environmentName", value);
    }

    /**
     * Describes the events that can be raised on the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEvents() {
        return software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the events that can be raised on the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEvents(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "events", value);
    }

    /**
     * Describes the events that can be raised on the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEvents(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentEventProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentEventProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "events", value);
    }

    /**
     * The name of the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * Describes the component's properties that can be overriden in a customized instance of the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOverrides() {
        return software.amazon.jsii.Kernel.get(this, "overrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the component's properties that can be overriden in a customized instance of the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOverrides(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "overrides", value);
    }

    /**
     * Describes the component's properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getProperties() {
        return software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Describes the component's properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "properties", value);
    }

    /**
     * Describes the component's properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProperties(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentPropertyProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentPropertyProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "properties", value);
    }

    /**
     * The schema version of the component when it was imported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSchemaVersion() {
        return software.amazon.jsii.Kernel.get(this, "schemaVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The schema version of the component when it was imported.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchemaVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "schemaVersion", value);
    }

    /**
     * The unique ID of the component in its original source system, such as Figma.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceId() {
        return software.amazon.jsii.Kernel.get(this, "sourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID of the component in its original source system, such as Figma.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceId", value);
    }

    /**
     * One or more key-value pairs to use when tagging the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * One or more key-value pairs to use when tagging the component.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * A list of the component's variants.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVariants() {
        return software.amazon.jsii.Kernel.get(this, "variants", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of the component's variants.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVariants(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "variants", value);
    }

    /**
     * A list of the component's variants.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVariants(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentVariantProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentVariantProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "variants", value);
    }
    /**
     * Represents the event action configuration for an element of a <code>Component</code> or <code>ComponentChild</code> .
     * <p>
     * Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components. <code>ActionParameters</code> defines the action that is performed when an event occurs on the component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * ComponentPropertyProperty componentPropertyProperty_;
     * ActionParametersProperty actionParametersProperty = ActionParametersProperty.builder()
     *         .anchor(ComponentPropertyProperty.builder()
     *                 .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .bindings(Map.of(
     *                         "bindingsKey", FormBindingElementProperty.builder()
     *                                 .element("element")
     *                                 .property("property")
     *                                 .build()))
     *                 .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .componentName("componentName")
     *                 .concat(List.of(componentPropertyProperty_))
     *                 .condition(ComponentConditionPropertyProperty.builder()
     *                         .else(componentPropertyProperty_)
     *                         .field("field")
     *                         .operand("operand")
     *                         .operandType("operandType")
     *                         .operator("operator")
     *                         .property("property")
     *                         .then(componentPropertyProperty_)
     *                         .build())
     *                 .configured(false)
     *                 .defaultValue("defaultValue")
     *                 .event("event")
     *                 .importedValue("importedValue")
     *                 .model("model")
     *                 .property("property")
     *                 .type("type")
     *                 .userAttribute("userAttribute")
     *                 .value("value")
     *                 .build())
     *         .fields(Map.of(
     *                 "fieldsKey", ComponentPropertyProperty.builder()
     *                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .bindings(Map.of(
     *                                 "bindingsKey", FormBindingElementProperty.builder()
     *                                         .element("element")
     *                                         .property("property")
     *                                         .build()))
     *                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .componentName("componentName")
     *                         .concat(List.of(componentPropertyProperty_))
     *                         .condition(ComponentConditionPropertyProperty.builder()
     *                                 .else(componentPropertyProperty_)
     *                                 .field("field")
     *                                 .operand("operand")
     *                                 .operandType("operandType")
     *                                 .operator("operator")
     *                                 .property("property")
     *                                 .then(componentPropertyProperty_)
     *                                 .build())
     *                         .configured(false)
     *                         .defaultValue("defaultValue")
     *                         .event("event")
     *                         .importedValue("importedValue")
     *                         .model("model")
     *                         .property("property")
     *                         .type("type")
     *                         .userAttribute("userAttribute")
     *                         .value("value")
     *                         .build()))
     *         .global(ComponentPropertyProperty.builder()
     *                 .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .bindings(Map.of(
     *                         "bindingsKey", FormBindingElementProperty.builder()
     *                                 .element("element")
     *                                 .property("property")
     *                                 .build()))
     *                 .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .componentName("componentName")
     *                 .concat(List.of(componentPropertyProperty_))
     *                 .condition(ComponentConditionPropertyProperty.builder()
     *                         .else(componentPropertyProperty_)
     *                         .field("field")
     *                         .operand("operand")
     *                         .operandType("operandType")
     *                         .operator("operator")
     *                         .property("property")
     *                         .then(componentPropertyProperty_)
     *                         .build())
     *                 .configured(false)
     *                 .defaultValue("defaultValue")
     *                 .event("event")
     *                 .importedValue("importedValue")
     *                 .model("model")
     *                 .property("property")
     *                 .type("type")
     *                 .userAttribute("userAttribute")
     *                 .value("value")
     *                 .build())
     *         .id(ComponentPropertyProperty.builder()
     *                 .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .bindings(Map.of(
     *                         "bindingsKey", FormBindingElementProperty.builder()
     *                                 .element("element")
     *                                 .property("property")
     *                                 .build()))
     *                 .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .componentName("componentName")
     *                 .concat(List.of(componentPropertyProperty_))
     *                 .condition(ComponentConditionPropertyProperty.builder()
     *                         .else(componentPropertyProperty_)
     *                         .field("field")
     *                         .operand("operand")
     *                         .operandType("operandType")
     *                         .operator("operator")
     *                         .property("property")
     *                         .then(componentPropertyProperty_)
     *                         .build())
     *                 .configured(false)
     *                 .defaultValue("defaultValue")
     *                 .event("event")
     *                 .importedValue("importedValue")
     *                 .model("model")
     *                 .property("property")
     *                 .type("type")
     *                 .userAttribute("userAttribute")
     *                 .value("value")
     *                 .build())
     *         .model("model")
     *         .state(MutationActionSetStateParameterProperty.builder()
     *                 .componentName("componentName")
     *                 .property("property")
     *                 .set(ComponentPropertyProperty.builder()
     *                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .bindings(Map.of(
     *                                 "bindingsKey", FormBindingElementProperty.builder()
     *                                         .element("element")
     *                                         .property("property")
     *                                         .build()))
     *                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .componentName("componentName")
     *                         .concat(List.of(componentPropertyProperty_))
     *                         .condition(ComponentConditionPropertyProperty.builder()
     *                                 .else(componentPropertyProperty_)
     *                                 .field("field")
     *                                 .operand("operand")
     *                                 .operandType("operandType")
     *                                 .operator("operator")
     *                                 .property("property")
     *                                 .then(componentPropertyProperty_)
     *                                 .build())
     *                         .configured(false)
     *                         .defaultValue("defaultValue")
     *                         .event("event")
     *                         .importedValue("importedValue")
     *                         .model("model")
     *                         .property("property")
     *                         .type("type")
     *                         .userAttribute("userAttribute")
     *                         .value("value")
     *                         .build())
     *                 .build())
     *         .target(ComponentPropertyProperty.builder()
     *                 .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .bindings(Map.of(
     *                         "bindingsKey", FormBindingElementProperty.builder()
     *                                 .element("element")
     *                                 .property("property")
     *                                 .build()))
     *                 .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .componentName("componentName")
     *                 .concat(List.of(componentPropertyProperty_))
     *                 .condition(ComponentConditionPropertyProperty.builder()
     *                         .else(componentPropertyProperty_)
     *                         .field("field")
     *                         .operand("operand")
     *                         .operandType("operandType")
     *                         .operator("operator")
     *                         .property("property")
     *                         .then(componentPropertyProperty_)
     *                         .build())
     *                 .configured(false)
     *                 .defaultValue("defaultValue")
     *                 .event("event")
     *                 .importedValue("importedValue")
     *                 .model("model")
     *                 .property("property")
     *                 .type("type")
     *                 .userAttribute("userAttribute")
     *                 .value("value")
     *                 .build())
     *         .type(ComponentPropertyProperty.builder()
     *                 .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .bindings(Map.of(
     *                         "bindingsKey", FormBindingElementProperty.builder()
     *                                 .element("element")
     *                                 .property("property")
     *                                 .build()))
     *                 .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .componentName("componentName")
     *                 .concat(List.of(componentPropertyProperty_))
     *                 .condition(ComponentConditionPropertyProperty.builder()
     *                         .else(componentPropertyProperty_)
     *                         .field("field")
     *                         .operand("operand")
     *                         .operandType("operandType")
     *                         .operator("operator")
     *                         .property("property")
     *                         .then(componentPropertyProperty_)
     *                         .build())
     *                 .configured(false)
     *                 .defaultValue("defaultValue")
     *                 .event("event")
     *                 .importedValue("importedValue")
     *                 .model("model")
     *                 .property("property")
     *                 .type("type")
     *                 .userAttribute("userAttribute")
     *                 .value("value")
     *                 .build())
     *         .url(ComponentPropertyProperty.builder()
     *                 .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .bindings(Map.of(
     *                         "bindingsKey", FormBindingElementProperty.builder()
     *                                 .element("element")
     *                                 .property("property")
     *                                 .build()))
     *                 .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .componentName("componentName")
     *                 .concat(List.of(componentPropertyProperty_))
     *                 .condition(ComponentConditionPropertyProperty.builder()
     *                         .else(componentPropertyProperty_)
     *                         .field("field")
     *                         .operand("operand")
     *                         .operandType("operandType")
     *                         .operator("operator")
     *                         .property("property")
     *                         .then(componentPropertyProperty_)
     *                         .build())
     *                 .configured(false)
     *                 .defaultValue("defaultValue")
     *                 .event("event")
     *                 .importedValue("importedValue")
     *                 .model("model")
     *                 .property("property")
     *                 .type("type")
     *                 .userAttribute("userAttribute")
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ActionParametersProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionParametersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionParametersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The HTML anchor link to the location to open.
         * <p>
         * Specify this value for a navigation action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-anchor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-anchor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnchor() {
            return null;
        }

        /**
         * A dictionary of key-value pairs mapping Amplify Studio properties to fields in a data model.
         * <p>
         * Use when the action performs an operation on an Amplify DataStore model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-fields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-fields</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFields() {
            return null;
        }

        /**
         * Specifies whether the user should be signed out globally.
         * <p>
         * Specify this value for an auth sign out action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-global">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-global</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGlobal() {
            return null;
        }

        /**
         * The unique ID of the component that the <code>ActionParameters</code> apply to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getId() {
            return null;
        }

        /**
         * The name of the data model.
         * <p>
         * Use when the action performs an operation on an Amplify DataStore model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-model">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-model</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getModel() {
            return null;
        }

        /**
         * A key-value pair that specifies the state property name and its initial value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getState() {
            return null;
        }

        /**
         * The element within the same component to modify when the action occurs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-target">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-target</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTarget() {
            return null;
        }

        /**
         * The type of navigation action.
         * <p>
         * Valid values are <code>url</code> and <code>anchor</code> . This value is required for a navigation action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getType() {
            return null;
        }

        /**
         * The URL to the location to open.
         * <p>
         * Specify this value for a navigation action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-actionparameters.html#cfn-amplifyuibuilder-component-actionparameters-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionParametersProperty> {
            java.lang.Object anchor;
            java.lang.Object fields;
            java.lang.Object global;
            java.lang.Object id;
            java.lang.String model;
            java.lang.Object state;
            java.lang.Object target;
            java.lang.Object type;
            java.lang.Object url;

            /**
             * Sets the value of {@link ActionParametersProperty#getAnchor}
             * @param anchor The HTML anchor link to the location to open.
             *               Specify this value for a navigation action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder anchor(software.amazon.awscdk.IResolvable anchor) {
                this.anchor = anchor;
                return this;
            }

            /**
             * Sets the value of {@link ActionParametersProperty#getAnchor}
             * @param anchor The HTML anchor link to the location to open.
             *               Specify this value for a navigation action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder anchor(software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentPropertyProperty anchor) {
                this.anchor = anchor;
                return this;
            }

            /**
             * Sets the value of {@link ActionParametersProperty#getFields}
             * @param fields A dictionary of key-value pairs mapping Amplify Studio properties to fields in a data model.
             *               Use when the action performs an operation on an Amplify DataStore model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fields(software.amazon.awscdk.IResolvable fields) {
                this.fields = fields;
                return this;
            }

            /**
             * Sets the value of {@link ActionParametersProperty#getFields}
             * @param fields A dictionary of key-value pairs mapping Amplify Studio properties to fields in a data model.
             *               Use when the action performs an operation on an Amplify DataStore model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fields(java.util.Map<java.lang.String, ? extends java.lang.Object> fields) {
                this.fields = fields;
                return this;
            }

            /**
             * Sets the value of {@link ActionParametersProperty#getGlobal}
             * @param global Specifies whether the user should be signed out globally.
             *               Specify this value for an auth sign out action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder global(software.amazon.awscdk.IResolvable global) {
                this.global = global;
                return this;
            }

            /**
             * Sets the value of {@link ActionParametersProperty#getGlobal}
             * @param global Specifies whether the user should be signed out globally.
             *               Specify this value for an auth sign out action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder global(software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentPropertyProperty global) {
                this.global = global;
                return this;
            }

            /**
             * Sets the value of {@link ActionParametersProperty#getId}
             * @param id The unique ID of the component that the <code>ActionParameters</code> apply to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(software.amazon.awscdk.IResolvable id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link ActionParametersProperty#getId}
             * @param id The unique ID of the component that the <code>ActionParameters</code> apply to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentPropertyProperty id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link ActionParametersProperty#getModel}
             * @param model The name of the data model.
             *              Use when the action performs an operation on an Amplify DataStore model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder model(java.lang.String model) {
                this.model = model;
                return this;
            }

            /**
             * Sets the value of {@link ActionParametersProperty#getState}
             * @param state A key-value pair that specifies the state property name and its initial value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(software.amazon.awscdk.IResolvable state) {
                this.state = state;
                return this;
            }

            /**
             * Sets the value of {@link ActionParametersProperty#getState}
             * @param state A key-value pair that specifies the state property name and its initial value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.MutationActionSetStateParameterProperty state) {
                this.state = state;
                return this;
            }

            /**
             * Sets the value of {@link ActionParametersProperty#getTarget}
             * @param target The element within the same component to modify when the action occurs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(software.amazon.awscdk.IResolvable target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link ActionParametersProperty#getTarget}
             * @param target The element within the same component to modify when the action occurs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentPropertyProperty target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link ActionParametersProperty#getType}
             * @param type The type of navigation action.
             *             Valid values are <code>url</code> and <code>anchor</code> . This value is required for a navigation action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(software.amazon.awscdk.IResolvable type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ActionParametersProperty#getType}
             * @param type The type of navigation action.
             *             Valid values are <code>url</code> and <code>anchor</code> . This value is required for a navigation action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentPropertyProperty type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ActionParametersProperty#getUrl}
             * @param url The URL to the location to open.
             *            Specify this value for a navigation action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(software.amazon.awscdk.IResolvable url) {
                this.url = url;
                return this;
            }

            /**
             * Sets the value of {@link ActionParametersProperty#getUrl}
             * @param url The URL to the location to open.
             *            Specify this value for a navigation action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentPropertyProperty url) {
                this.url = url;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionParametersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionParametersProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionParametersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionParametersProperty {
            private final java.lang.Object anchor;
            private final java.lang.Object fields;
            private final java.lang.Object global;
            private final java.lang.Object id;
            private final java.lang.String model;
            private final java.lang.Object state;
            private final java.lang.Object target;
            private final java.lang.Object type;
            private final java.lang.Object url;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.anchor = software.amazon.jsii.Kernel.get(this, "anchor", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fields = software.amazon.jsii.Kernel.get(this, "fields", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.global = software.amazon.jsii.Kernel.get(this, "global", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.model = software.amazon.jsii.Kernel.get(this, "model", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.anchor = builder.anchor;
                this.fields = builder.fields;
                this.global = builder.global;
                this.id = builder.id;
                this.model = builder.model;
                this.state = builder.state;
                this.target = builder.target;
                this.type = builder.type;
                this.url = builder.url;
            }

            @Override
            public final java.lang.Object getAnchor() {
                return this.anchor;
            }

            @Override
            public final java.lang.Object getFields() {
                return this.fields;
            }

            @Override
            public final java.lang.Object getGlobal() {
                return this.global;
            }

            @Override
            public final java.lang.Object getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getModel() {
                return this.model;
            }

            @Override
            public final java.lang.Object getState() {
                return this.state;
            }

            @Override
            public final java.lang.Object getTarget() {
                return this.target;
            }

            @Override
            public final java.lang.Object getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getUrl() {
                return this.url;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnchor() != null) {
                    data.set("anchor", om.valueToTree(this.getAnchor()));
                }
                if (this.getFields() != null) {
                    data.set("fields", om.valueToTree(this.getFields()));
                }
                if (this.getGlobal() != null) {
                    data.set("global", om.valueToTree(this.getGlobal()));
                }
                if (this.getId() != null) {
                    data.set("id", om.valueToTree(this.getId()));
                }
                if (this.getModel() != null) {
                    data.set("model", om.valueToTree(this.getModel()));
                }
                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }
                if (this.getTarget() != null) {
                    data.set("target", om.valueToTree(this.getTarget()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ActionParametersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionParametersProperty.Jsii$Proxy that = (ActionParametersProperty.Jsii$Proxy) o;

                if (this.anchor != null ? !this.anchor.equals(that.anchor) : that.anchor != null) return false;
                if (this.fields != null ? !this.fields.equals(that.fields) : that.fields != null) return false;
                if (this.global != null ? !this.global.equals(that.global) : that.global != null) return false;
                if (this.id != null ? !this.id.equals(that.id) : that.id != null) return false;
                if (this.model != null ? !this.model.equals(that.model) : that.model != null) return false;
                if (this.state != null ? !this.state.equals(that.state) : that.state != null) return false;
                if (this.target != null ? !this.target.equals(that.target) : that.target != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.url != null ? this.url.equals(that.url) : that.url == null;
            }

            @Override
            public final int hashCode() {
                int result = this.anchor != null ? this.anchor.hashCode() : 0;
                result = 31 * result + (this.fields != null ? this.fields.hashCode() : 0);
                result = 31 * result + (this.global != null ? this.global.hashCode() : 0);
                result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
                result = 31 * result + (this.model != null ? this.model.hashCode() : 0);
                result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
                result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ComponentBindingPropertiesValueProperties</code> property specifies the data binding configuration for a specific property using data stored in AWS .
     * <p>
     * For AWS connected properties, you can bind a property to data stored in an Amazon S3 bucket, an Amplify DataStore model or an authenticated user attribute.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * PredicateProperty predicateProperty_;
     * ComponentBindingPropertiesValuePropertiesProperty componentBindingPropertiesValuePropertiesProperty = ComponentBindingPropertiesValuePropertiesProperty.builder()
     *         .bucket("bucket")
     *         .defaultValue("defaultValue")
     *         .field("field")
     *         .key("key")
     *         .model("model")
     *         .predicates(List.of(PredicateProperty.builder()
     *                 .and(List.of(predicateProperty_))
     *                 .field("field")
     *                 .operand("operand")
     *                 .operandType("operandType")
     *                 .operator("operator")
     *                 .or(List.of(predicateProperty_))
     *                 .build()))
     *         .slotName("slotName")
     *         .userAttribute("userAttribute")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentBindingPropertiesValuePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentBindingPropertiesValuePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentBindingPropertiesValuePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalueproperties-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalueproperties-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucket() {
            return null;
        }

        /**
         * The default value to assign to the property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalueproperties-defaultvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalueproperties-defaultvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultValue() {
            return null;
        }

        /**
         * The field to bind the data to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalueproperties-field">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalueproperties-field</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getField() {
            return null;
        }

        /**
         * The storage key for an Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalueproperties-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalueproperties-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKey() {
            return null;
        }

        /**
         * An Amplify DataStore model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalueproperties-model">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalueproperties-model</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getModel() {
            return null;
        }

        /**
         * A list of predicates for binding a component's properties to data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalueproperties-predicates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalueproperties-predicates</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredicates() {
            return null;
        }

        /**
         * The name of a component slot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalueproperties-slotname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalueproperties-slotname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSlotName() {
            return null;
        }

        /**
         * An authenticated user attribute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalueproperties-userattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalueproperties.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalueproperties-userattribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserAttribute() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentBindingPropertiesValuePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentBindingPropertiesValuePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentBindingPropertiesValuePropertiesProperty> {
            java.lang.String bucket;
            java.lang.String defaultValue;
            java.lang.String field;
            java.lang.String key;
            java.lang.String model;
            java.lang.Object predicates;
            java.lang.String slotName;
            java.lang.String userAttribute;

            /**
             * Sets the value of {@link ComponentBindingPropertiesValuePropertiesProperty#getBucket}
             * @param bucket An Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link ComponentBindingPropertiesValuePropertiesProperty#getDefaultValue}
             * @param defaultValue The default value to assign to the property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(java.lang.String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Sets the value of {@link ComponentBindingPropertiesValuePropertiesProperty#getField}
             * @param field The field to bind the data to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder field(java.lang.String field) {
                this.field = field;
                return this;
            }

            /**
             * Sets the value of {@link ComponentBindingPropertiesValuePropertiesProperty#getKey}
             * @param key The storage key for an Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link ComponentBindingPropertiesValuePropertiesProperty#getModel}
             * @param model An Amplify DataStore model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder model(java.lang.String model) {
                this.model = model;
                return this;
            }

            /**
             * Sets the value of {@link ComponentBindingPropertiesValuePropertiesProperty#getPredicates}
             * @param predicates A list of predicates for binding a component's properties to data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predicates(software.amazon.awscdk.IResolvable predicates) {
                this.predicates = predicates;
                return this;
            }

            /**
             * Sets the value of {@link ComponentBindingPropertiesValuePropertiesProperty#getPredicates}
             * @param predicates A list of predicates for binding a component's properties to data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predicates(java.util.List<? extends java.lang.Object> predicates) {
                this.predicates = predicates;
                return this;
            }

            /**
             * Sets the value of {@link ComponentBindingPropertiesValuePropertiesProperty#getSlotName}
             * @param slotName The name of a component slot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slotName(java.lang.String slotName) {
                this.slotName = slotName;
                return this;
            }

            /**
             * Sets the value of {@link ComponentBindingPropertiesValuePropertiesProperty#getUserAttribute}
             * @param userAttribute An authenticated user attribute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userAttribute(java.lang.String userAttribute) {
                this.userAttribute = userAttribute;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentBindingPropertiesValuePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentBindingPropertiesValuePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentBindingPropertiesValuePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentBindingPropertiesValuePropertiesProperty {
            private final java.lang.String bucket;
            private final java.lang.String defaultValue;
            private final java.lang.String field;
            private final java.lang.String key;
            private final java.lang.String model;
            private final java.lang.Object predicates;
            private final java.lang.String slotName;
            private final java.lang.String userAttribute;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultValue = software.amazon.jsii.Kernel.get(this, "defaultValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.field = software.amazon.jsii.Kernel.get(this, "field", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.model = software.amazon.jsii.Kernel.get(this, "model", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.predicates = software.amazon.jsii.Kernel.get(this, "predicates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.slotName = software.amazon.jsii.Kernel.get(this, "slotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userAttribute = software.amazon.jsii.Kernel.get(this, "userAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = builder.bucket;
                this.defaultValue = builder.defaultValue;
                this.field = builder.field;
                this.key = builder.key;
                this.model = builder.model;
                this.predicates = builder.predicates;
                this.slotName = builder.slotName;
                this.userAttribute = builder.userAttribute;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getDefaultValue() {
                return this.defaultValue;
            }

            @Override
            public final java.lang.String getField() {
                return this.field;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getModel() {
                return this.model;
            }

            @Override
            public final java.lang.Object getPredicates() {
                return this.predicates;
            }

            @Override
            public final java.lang.String getSlotName() {
                return this.slotName;
            }

            @Override
            public final java.lang.String getUserAttribute() {
                return this.userAttribute;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucket() != null) {
                    data.set("bucket", om.valueToTree(this.getBucket()));
                }
                if (this.getDefaultValue() != null) {
                    data.set("defaultValue", om.valueToTree(this.getDefaultValue()));
                }
                if (this.getField() != null) {
                    data.set("field", om.valueToTree(this.getField()));
                }
                if (this.getKey() != null) {
                    data.set("key", om.valueToTree(this.getKey()));
                }
                if (this.getModel() != null) {
                    data.set("model", om.valueToTree(this.getModel()));
                }
                if (this.getPredicates() != null) {
                    data.set("predicates", om.valueToTree(this.getPredicates()));
                }
                if (this.getSlotName() != null) {
                    data.set("slotName", om.valueToTree(this.getSlotName()));
                }
                if (this.getUserAttribute() != null) {
                    data.set("userAttribute", om.valueToTree(this.getUserAttribute()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentBindingPropertiesValuePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentBindingPropertiesValuePropertiesProperty.Jsii$Proxy that = (ComponentBindingPropertiesValuePropertiesProperty.Jsii$Proxy) o;

                if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) return false;
                if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) return false;
                if (this.field != null ? !this.field.equals(that.field) : that.field != null) return false;
                if (this.key != null ? !this.key.equals(that.key) : that.key != null) return false;
                if (this.model != null ? !this.model.equals(that.model) : that.model != null) return false;
                if (this.predicates != null ? !this.predicates.equals(that.predicates) : that.predicates != null) return false;
                if (this.slotName != null ? !this.slotName.equals(that.slotName) : that.slotName != null) return false;
                return this.userAttribute != null ? this.userAttribute.equals(that.userAttribute) : that.userAttribute == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket != null ? this.bucket.hashCode() : 0;
                result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
                result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
                result = 31 * result + (this.model != null ? this.model.hashCode() : 0);
                result = 31 * result + (this.predicates != null ? this.predicates.hashCode() : 0);
                result = 31 * result + (this.slotName != null ? this.slotName.hashCode() : 0);
                result = 31 * result + (this.userAttribute != null ? this.userAttribute.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ComponentBindingPropertiesValue</code> property specifies the data binding configuration for a component at runtime.
     * <p>
     * You can use <code>ComponentBindingPropertiesValue</code> to add exposed properties to a component to allow different values to be entered when a component is reused in different places in an app.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * PredicateProperty predicateProperty_;
     * ComponentBindingPropertiesValueProperty componentBindingPropertiesValueProperty = ComponentBindingPropertiesValueProperty.builder()
     *         .bindingProperties(ComponentBindingPropertiesValuePropertiesProperty.builder()
     *                 .bucket("bucket")
     *                 .defaultValue("defaultValue")
     *                 .field("field")
     *                 .key("key")
     *                 .model("model")
     *                 .predicates(List.of(PredicateProperty.builder()
     *                         .and(List.of(predicateProperty_))
     *                         .field("field")
     *                         .operand("operand")
     *                         .operandType("operandType")
     *                         .operator("operator")
     *                         .or(List.of(predicateProperty_))
     *                         .build()))
     *                 .slotName("slotName")
     *                 .userAttribute("userAttribute")
     *                 .build())
     *         .defaultValue("defaultValue")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentBindingPropertiesValueProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentBindingPropertiesValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentBindingPropertiesValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Describes the properties to customize with data at runtime.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalue.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalue-bindingproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalue.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalue-bindingproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBindingProperties() {
            return null;
        }

        /**
         * The default value of the property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalue.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalue-defaultvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalue.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalue-defaultvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultValue() {
            return null;
        }

        /**
         * The property type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalue.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalue-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentbindingpropertiesvalue.html#cfn-amplifyuibuilder-component-componentbindingpropertiesvalue-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentBindingPropertiesValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentBindingPropertiesValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentBindingPropertiesValueProperty> {
            java.lang.Object bindingProperties;
            java.lang.String defaultValue;
            java.lang.String type;

            /**
             * Sets the value of {@link ComponentBindingPropertiesValueProperty#getBindingProperties}
             * @param bindingProperties Describes the properties to customize with data at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bindingProperties(software.amazon.awscdk.IResolvable bindingProperties) {
                this.bindingProperties = bindingProperties;
                return this;
            }

            /**
             * Sets the value of {@link ComponentBindingPropertiesValueProperty#getBindingProperties}
             * @param bindingProperties Describes the properties to customize with data at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bindingProperties(software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentBindingPropertiesValuePropertiesProperty bindingProperties) {
                this.bindingProperties = bindingProperties;
                return this;
            }

            /**
             * Sets the value of {@link ComponentBindingPropertiesValueProperty#getDefaultValue}
             * @param defaultValue The default value of the property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(java.lang.String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Sets the value of {@link ComponentBindingPropertiesValueProperty#getType}
             * @param type The property type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentBindingPropertiesValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentBindingPropertiesValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentBindingPropertiesValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentBindingPropertiesValueProperty {
            private final java.lang.Object bindingProperties;
            private final java.lang.String defaultValue;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bindingProperties = software.amazon.jsii.Kernel.get(this, "bindingProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultValue = software.amazon.jsii.Kernel.get(this, "defaultValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bindingProperties = builder.bindingProperties;
                this.defaultValue = builder.defaultValue;
                this.type = builder.type;
            }

            @Override
            public final java.lang.Object getBindingProperties() {
                return this.bindingProperties;
            }

            @Override
            public final java.lang.String getDefaultValue() {
                return this.defaultValue;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBindingProperties() != null) {
                    data.set("bindingProperties", om.valueToTree(this.getBindingProperties()));
                }
                if (this.getDefaultValue() != null) {
                    data.set("defaultValue", om.valueToTree(this.getDefaultValue()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentBindingPropertiesValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentBindingPropertiesValueProperty.Jsii$Proxy that = (ComponentBindingPropertiesValueProperty.Jsii$Proxy) o;

                if (this.bindingProperties != null ? !this.bindingProperties.equals(that.bindingProperties) : that.bindingProperties != null) return false;
                if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bindingProperties != null ? this.bindingProperties.hashCode() : 0;
                result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ComponentChild</code> property specifies a nested UI configuration within a parent <code>Component</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * ComponentChildProperty componentChildProperty_;
     * ComponentPropertyProperty componentPropertyProperty_;
     * ComponentChildProperty componentChildProperty = ComponentChildProperty.builder()
     *         .componentType("componentType")
     *         .name("name")
     *         .properties(Map.of(
     *                 "propertiesKey", ComponentPropertyProperty.builder()
     *                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .bindings(Map.of(
     *                                 "bindingsKey", FormBindingElementProperty.builder()
     *                                         .element("element")
     *                                         .property("property")
     *                                         .build()))
     *                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .componentName("componentName")
     *                         .concat(List.of(componentPropertyProperty_))
     *                         .condition(ComponentConditionPropertyProperty.builder()
     *                                 .else(componentPropertyProperty_)
     *                                 .field("field")
     *                                 .operand("operand")
     *                                 .operandType("operandType")
     *                                 .operator("operator")
     *                                 .property("property")
     *                                 .then(componentPropertyProperty_)
     *                                 .build())
     *                         .configured(false)
     *                         .defaultValue("defaultValue")
     *                         .event("event")
     *                         .importedValue("importedValue")
     *                         .model("model")
     *                         .property("property")
     *                         .type("type")
     *                         .userAttribute("userAttribute")
     *                         .value("value")
     *                         .build()))
     *         // the properties below are optional
     *         .children(List.of(componentChildProperty_))
     *         .events(Map.of(
     *                 "eventsKey", ComponentEventProperty.builder()
     *                         .action("action")
     *                         .bindingEvent("bindingEvent")
     *                         .parameters(ActionParametersProperty.builder()
     *                                 .anchor(ComponentPropertyProperty.builder()
     *                                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                                 .property("property")
     *                                                 // the properties below are optional
     *                                                 .field("field")
     *                                                 .build())
     *                                         .bindings(Map.of(
     *                                                 "bindingsKey", FormBindingElementProperty.builder()
     *                                                         .element("element")
     *                                                         .property("property")
     *                                                         .build()))
     *                                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                                 .property("property")
     *                                                 // the properties below are optional
     *                                                 .field("field")
     *                                                 .build())
     *                                         .componentName("componentName")
     *                                         .concat(List.of(componentPropertyProperty_))
     *                                         .condition(ComponentConditionPropertyProperty.builder()
     *                                                 .else(componentPropertyProperty_)
     *                                                 .field("field")
     *                                                 .operand("operand")
     *                                                 .operandType("operandType")
     *                                                 .operator("operator")
     *                                                 .property("property")
     *                                                 .then(componentPropertyProperty_)
     *                                                 .build())
     *                                         .configured(false)
     *                                         .defaultValue("defaultValue")
     *                                         .event("event")
     *                                         .importedValue("importedValue")
     *                                         .model("model")
     *                                         .property("property")
     *                                         .type("type")
     *                                         .userAttribute("userAttribute")
     *                                         .value("value")
     *                                         .build())
     *                                 .fields(Map.of(
     *                                         "fieldsKey", ComponentPropertyProperty.builder()
     *                                                 .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                                         .property("property")
     *                                                         // the properties below are optional
     *                                                         .field("field")
     *                                                         .build())
     *                                                 .bindings(Map.of(
     *                                                         "bindingsKey", FormBindingElementProperty.builder()
     *                                                                 .element("element")
     *                                                                 .property("property")
     *                                                                 .build()))
     *                                                 .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                                         .property("property")
     *                                                         // the properties below are optional
     *                                                         .field("field")
     *                                                         .build())
     *                                                 .componentName("componentName")
     *                                                 .concat(List.of(componentPropertyProperty_))
     *                                                 .condition(ComponentConditionPropertyProperty.builder()
     *                                                         .else(componentPropertyProperty_)
     *                                                         .field("field")
     *                                                         .operand("operand")
     *                                                         .operandType("operandType")
     *                                                         .operator("operator")
     *                                                         .property("property")
     *                                                         .then(componentPropertyProperty_)
     *                                                         .build())
     *                                                 .configured(false)
     *                                                 .defaultValue("defaultValue")
     *                                                 .event("event")
     *                                                 .importedValue("importedValue")
     *                                                 .model("model")
     *                                                 .property("property")
     *                                                 .type("type")
     *                                                 .userAttribute("userAttribute")
     *                                                 .value("value")
     *                                                 .build()))
     *                                 .global(ComponentPropertyProperty.builder()
     *                                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                                 .property("property")
     *                                                 // the properties below are optional
     *                                                 .field("field")
     *                                                 .build())
     *                                         .bindings(Map.of(
     *                                                 "bindingsKey", FormBindingElementProperty.builder()
     *                                                         .element("element")
     *                                                         .property("property")
     *                                                         .build()))
     *                                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                                 .property("property")
     *                                                 // the properties below are optional
     *                                                 .field("field")
     *                                                 .build())
     *                                         .componentName("componentName")
     *                                         .concat(List.of(componentPropertyProperty_))
     *                                         .condition(ComponentConditionPropertyProperty.builder()
     *                                                 .else(componentPropertyProperty_)
     *                                                 .field("field")
     *                                                 .operand("operand")
     *                                                 .operandType("operandType")
     *                                                 .operator("operator")
     *                                                 .property("property")
     *                                                 .then(componentPropertyProperty_)
     *                                                 .build())
     *                                         .configured(false)
     *                                         .defaultValue("defaultValue")
     *                                         .event("event")
     *                                         .importedValue("importedValue")
     *                                         .model("model")
     *                                         .property("property")
     *                                         .type("type")
     *                                         .userAttribute("userAttribute")
     *                                         .value("value")
     *                                         .build())
     *                                 .id(ComponentPropertyProperty.builder()
     *                                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                                 .property("property")
     *                                                 // the properties below are optional
     *                                                 .field("field")
     *                                                 .build())
     *                                         .bindings(Map.of(
     *                                                 "bindingsKey", FormBindingElementProperty.builder()
     *                                                         .element("element")
     *                                                         .property("property")
     *                                                         .build()))
     *                                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                                 .property("property")
     *                                                 // the properties below are optional
     *                                                 .field("field")
     *                                                 .build())
     *                                         .componentName("componentName")
     *                                         .concat(List.of(componentPropertyProperty_))
     *                                         .condition(ComponentConditionPropertyProperty.builder()
     *                                                 .else(componentPropertyProperty_)
     *                                                 .field("field")
     *                                                 .operand("operand")
     *                                                 .operandType("operandType")
     *                                                 .operator("operator")
     *                                                 .property("property")
     *                                                 .then(componentPropertyProperty_)
     *                                                 .build())
     *                                         .configured(false)
     *                                         .defaultValue("defaultValue")
     *                                         .event("event")
     *                                         .importedValue("importedValue")
     *                                         .model("model")
     *                                         .property("property")
     *                                         .type("type")
     *                                         .userAttribute("userAttribute")
     *                                         .value("value")
     *                                         .build())
     *                                 .model("model")
     *                                 .state(MutationActionSetStateParameterProperty.builder()
     *                                         .componentName("componentName")
     *                                         .property("property")
     *                                         .set(ComponentPropertyProperty.builder()
     *                                                 .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                                         .property("property")
     *                                                         // the properties below are optional
     *                                                         .field("field")
     *                                                         .build())
     *                                                 .bindings(Map.of(
     *                                                         "bindingsKey", FormBindingElementProperty.builder()
     *                                                                 .element("element")
     *                                                                 .property("property")
     *                                                                 .build()))
     *                                                 .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                                         .property("property")
     *                                                         // the properties below are optional
     *                                                         .field("field")
     *                                                         .build())
     *                                                 .componentName("componentName")
     *                                                 .concat(List.of(componentPropertyProperty_))
     *                                                 .condition(ComponentConditionPropertyProperty.builder()
     *                                                         .else(componentPropertyProperty_)
     *                                                         .field("field")
     *                                                         .operand("operand")
     *                                                         .operandType("operandType")
     *                                                         .operator("operator")
     *                                                         .property("property")
     *                                                         .then(componentPropertyProperty_)
     *                                                         .build())
     *                                                 .configured(false)
     *                                                 .defaultValue("defaultValue")
     *                                                 .event("event")
     *                                                 .importedValue("importedValue")
     *                                                 .model("model")
     *                                                 .property("property")
     *                                                 .type("type")
     *                                                 .userAttribute("userAttribute")
     *                                                 .value("value")
     *                                                 .build())
     *                                         .build())
     *                                 .target(ComponentPropertyProperty.builder()
     *                                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                                 .property("property")
     *                                                 // the properties below are optional
     *                                                 .field("field")
     *                                                 .build())
     *                                         .bindings(Map.of(
     *                                                 "bindingsKey", FormBindingElementProperty.builder()
     *                                                         .element("element")
     *                                                         .property("property")
     *                                                         .build()))
     *                                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                                 .property("property")
     *                                                 // the properties below are optional
     *                                                 .field("field")
     *                                                 .build())
     *                                         .componentName("componentName")
     *                                         .concat(List.of(componentPropertyProperty_))
     *                                         .condition(ComponentConditionPropertyProperty.builder()
     *                                                 .else(componentPropertyProperty_)
     *                                                 .field("field")
     *                                                 .operand("operand")
     *                                                 .operandType("operandType")
     *                                                 .operator("operator")
     *                                                 .property("property")
     *                                                 .then(componentPropertyProperty_)
     *                                                 .build())
     *                                         .configured(false)
     *                                         .defaultValue("defaultValue")
     *                                         .event("event")
     *                                         .importedValue("importedValue")
     *                                         .model("model")
     *                                         .property("property")
     *                                         .type("type")
     *                                         .userAttribute("userAttribute")
     *                                         .value("value")
     *                                         .build())
     *                                 .type(ComponentPropertyProperty.builder()
     *                                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                                 .property("property")
     *                                                 // the properties below are optional
     *                                                 .field("field")
     *                                                 .build())
     *                                         .bindings(Map.of(
     *                                                 "bindingsKey", FormBindingElementProperty.builder()
     *                                                         .element("element")
     *                                                         .property("property")
     *                                                         .build()))
     *                                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                                 .property("property")
     *                                                 // the properties below are optional
     *                                                 .field("field")
     *                                                 .build())
     *                                         .componentName("componentName")
     *                                         .concat(List.of(componentPropertyProperty_))
     *                                         .condition(ComponentConditionPropertyProperty.builder()
     *                                                 .else(componentPropertyProperty_)
     *                                                 .field("field")
     *                                                 .operand("operand")
     *                                                 .operandType("operandType")
     *                                                 .operator("operator")
     *                                                 .property("property")
     *                                                 .then(componentPropertyProperty_)
     *                                                 .build())
     *                                         .configured(false)
     *                                         .defaultValue("defaultValue")
     *                                         .event("event")
     *                                         .importedValue("importedValue")
     *                                         .model("model")
     *                                         .property("property")
     *                                         .type("type")
     *                                         .userAttribute("userAttribute")
     *                                         .value("value")
     *                                         .build())
     *                                 .url(ComponentPropertyProperty.builder()
     *                                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                                 .property("property")
     *                                                 // the properties below are optional
     *                                                 .field("field")
     *                                                 .build())
     *                                         .bindings(Map.of(
     *                                                 "bindingsKey", FormBindingElementProperty.builder()
     *                                                         .element("element")
     *                                                         .property("property")
     *                                                         .build()))
     *                                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                                 .property("property")
     *                                                 // the properties below are optional
     *                                                 .field("field")
     *                                                 .build())
     *                                         .componentName("componentName")
     *                                         .concat(List.of(componentPropertyProperty_))
     *                                         .condition(ComponentConditionPropertyProperty.builder()
     *                                                 .else(componentPropertyProperty_)
     *                                                 .field("field")
     *                                                 .operand("operand")
     *                                                 .operandType("operandType")
     *                                                 .operator("operator")
     *                                                 .property("property")
     *                                                 .then(componentPropertyProperty_)
     *                                                 .build())
     *                                         .configured(false)
     *                                         .defaultValue("defaultValue")
     *                                         .event("event")
     *                                         .importedValue("importedValue")
     *                                         .model("model")
     *                                         .property("property")
     *                                         .type("type")
     *                                         .userAttribute("userAttribute")
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         .build()))
     *         .sourceId("sourceId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentchild.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentchild.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentChildProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentChildProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentChildProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of the child component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentchild.html#cfn-amplifyuibuilder-component-componentchild-componenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentchild.html#cfn-amplifyuibuilder-component-componentchild-componenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComponentType();

        /**
         * The name of the child component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentchild.html#cfn-amplifyuibuilder-component-componentchild-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentchild.html#cfn-amplifyuibuilder-component-componentchild-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Describes the properties of the child component.
         * <p>
         * You can't specify <code>tags</code> as a valid property for <code>properties</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentchild.html#cfn-amplifyuibuilder-component-componentchild-properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentchild.html#cfn-amplifyuibuilder-component-componentchild-properties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getProperties();

        /**
         * The list of <code>ComponentChild</code> instances for this component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentchild.html#cfn-amplifyuibuilder-component-componentchild-children">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentchild.html#cfn-amplifyuibuilder-component-componentchild-children</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getChildren() {
            return null;
        }

        /**
         * Describes the events that can be raised on the child component.
         * <p>
         * Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentchild.html#cfn-amplifyuibuilder-component-componentchild-events">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentchild.html#cfn-amplifyuibuilder-component-componentchild-events</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEvents() {
            return null;
        }

        /**
         * The unique ID of the child component in its original source system, such as Figma.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentchild.html#cfn-amplifyuibuilder-component-componentchild-sourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentchild.html#cfn-amplifyuibuilder-component-componentchild-sourceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSourceId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentChildProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentChildProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentChildProperty> {
            java.lang.String componentType;
            java.lang.String name;
            java.lang.Object properties;
            java.lang.Object children;
            java.lang.Object events;
            java.lang.String sourceId;

            /**
             * Sets the value of {@link ComponentChildProperty#getComponentType}
             * @param componentType The type of the child component. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentType(java.lang.String componentType) {
                this.componentType = componentType;
                return this;
            }

            /**
             * Sets the value of {@link ComponentChildProperty#getName}
             * @param name The name of the child component. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ComponentChildProperty#getProperties}
             * @param properties Describes the properties of the child component. This parameter is required.
             *                   You can't specify <code>tags</code> as a valid property for <code>properties</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.IResolvable properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link ComponentChildProperty#getProperties}
             * @param properties Describes the properties of the child component. This parameter is required.
             *                   You can't specify <code>tags</code> as a valid property for <code>properties</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(java.util.Map<java.lang.String, ? extends java.lang.Object> properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link ComponentChildProperty#getChildren}
             * @param children The list of <code>ComponentChild</code> instances for this component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder children(software.amazon.awscdk.IResolvable children) {
                this.children = children;
                return this;
            }

            /**
             * Sets the value of {@link ComponentChildProperty#getChildren}
             * @param children The list of <code>ComponentChild</code> instances for this component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder children(java.util.List<? extends java.lang.Object> children) {
                this.children = children;
                return this;
            }

            /**
             * Sets the value of {@link ComponentChildProperty#getEvents}
             * @param events Describes the events that can be raised on the child component.
             *               Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(software.amazon.awscdk.IResolvable events) {
                this.events = events;
                return this;
            }

            /**
             * Sets the value of {@link ComponentChildProperty#getEvents}
             * @param events Describes the events that can be raised on the child component.
             *               Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(java.util.Map<java.lang.String, ? extends java.lang.Object> events) {
                this.events = events;
                return this;
            }

            /**
             * Sets the value of {@link ComponentChildProperty#getSourceId}
             * @param sourceId The unique ID of the child component in its original source system, such as Figma.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceId(java.lang.String sourceId) {
                this.sourceId = sourceId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentChildProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentChildProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentChildProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentChildProperty {
            private final java.lang.String componentType;
            private final java.lang.String name;
            private final java.lang.Object properties;
            private final java.lang.Object children;
            private final java.lang.Object events;
            private final java.lang.String sourceId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.componentType = software.amazon.jsii.Kernel.get(this, "componentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.children = software.amazon.jsii.Kernel.get(this, "children", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceId = software.amazon.jsii.Kernel.get(this, "sourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.componentType = java.util.Objects.requireNonNull(builder.componentType, "componentType is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.properties = java.util.Objects.requireNonNull(builder.properties, "properties is required");
                this.children = builder.children;
                this.events = builder.events;
                this.sourceId = builder.sourceId;
            }

            @Override
            public final java.lang.String getComponentType() {
                return this.componentType;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getProperties() {
                return this.properties;
            }

            @Override
            public final java.lang.Object getChildren() {
                return this.children;
            }

            @Override
            public final java.lang.Object getEvents() {
                return this.events;
            }

            @Override
            public final java.lang.String getSourceId() {
                return this.sourceId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("componentType", om.valueToTree(this.getComponentType()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("properties", om.valueToTree(this.getProperties()));
                if (this.getChildren() != null) {
                    data.set("children", om.valueToTree(this.getChildren()));
                }
                if (this.getEvents() != null) {
                    data.set("events", om.valueToTree(this.getEvents()));
                }
                if (this.getSourceId() != null) {
                    data.set("sourceId", om.valueToTree(this.getSourceId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentChildProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentChildProperty.Jsii$Proxy that = (ComponentChildProperty.Jsii$Proxy) o;

                if (!componentType.equals(that.componentType)) return false;
                if (!name.equals(that.name)) return false;
                if (!properties.equals(that.properties)) return false;
                if (this.children != null ? !this.children.equals(that.children) : that.children != null) return false;
                if (this.events != null ? !this.events.equals(that.events) : that.events != null) return false;
                return this.sourceId != null ? this.sourceId.equals(that.sourceId) : that.sourceId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.componentType.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.properties.hashCode());
                result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
                result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
                result = 31 * result + (this.sourceId != null ? this.sourceId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ComponentConditionProperty</code> property specifies a conditional expression for setting a component property.
     * <p>
     * Use <code>ComponentConditionProperty</code> to set a property to different values conditionally, based on the value of another property.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * ComponentConditionPropertyProperty componentConditionPropertyProperty_;
     * ComponentPropertyProperty componentPropertyProperty_;
     * ComponentConditionPropertyProperty componentConditionPropertyProperty = ComponentConditionPropertyProperty.builder()
     *         .else(ComponentPropertyProperty.builder()
     *                 .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .bindings(Map.of(
     *                         "bindingsKey", FormBindingElementProperty.builder()
     *                                 .element("element")
     *                                 .property("property")
     *                                 .build()))
     *                 .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .componentName("componentName")
     *                 .concat(List.of(componentPropertyProperty_))
     *                 .condition(componentConditionPropertyProperty_)
     *                 .configured(false)
     *                 .defaultValue("defaultValue")
     *                 .event("event")
     *                 .importedValue("importedValue")
     *                 .model("model")
     *                 .property("property")
     *                 .type("type")
     *                 .userAttribute("userAttribute")
     *                 .value("value")
     *                 .build())
     *         .field("field")
     *         .operand("operand")
     *         .operandType("operandType")
     *         .operator("operator")
     *         .property("property")
     *         .then(ComponentPropertyProperty.builder()
     *                 .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .bindings(Map.of(
     *                         "bindingsKey", FormBindingElementProperty.builder()
     *                                 .element("element")
     *                                 .property("property")
     *                                 .build()))
     *                 .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .componentName("componentName")
     *                 .concat(List.of(componentPropertyProperty_))
     *                 .condition(componentConditionPropertyProperty_)
     *                 .configured(false)
     *                 .defaultValue("defaultValue")
     *                 .event("event")
     *                 .importedValue("importedValue")
     *                 .model("model")
     *                 .property("property")
     *                 .type("type")
     *                 .userAttribute("userAttribute")
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentconditionproperty.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentconditionproperty.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentConditionPropertyProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentConditionPropertyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentConditionPropertyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value to assign to the property if the condition is not met.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentconditionproperty.html#cfn-amplifyuibuilder-component-componentconditionproperty-else">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentconditionproperty.html#cfn-amplifyuibuilder-component-componentconditionproperty-else</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getElseValue() {
            return null;
        }

        /**
         * The name of a field.
         * <p>
         * Specify this when the property is a data model.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentconditionproperty.html#cfn-amplifyuibuilder-component-componentconditionproperty-field">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentconditionproperty.html#cfn-amplifyuibuilder-component-componentconditionproperty-field</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getField() {
            return null;
        }

        /**
         * The value of the property to evaluate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentconditionproperty.html#cfn-amplifyuibuilder-component-componentconditionproperty-operand">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentconditionproperty.html#cfn-amplifyuibuilder-component-componentconditionproperty-operand</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOperand() {
            return null;
        }

        /**
         * The type of the property to evaluate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentconditionproperty.html#cfn-amplifyuibuilder-component-componentconditionproperty-operandtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentconditionproperty.html#cfn-amplifyuibuilder-component-componentconditionproperty-operandtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOperandType() {
            return null;
        }

        /**
         * The operator to use to perform the evaluation, such as <code>eq</code> to represent equals.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentconditionproperty.html#cfn-amplifyuibuilder-component-componentconditionproperty-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentconditionproperty.html#cfn-amplifyuibuilder-component-componentconditionproperty-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOperator() {
            return null;
        }

        /**
         * The name of the conditional property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentconditionproperty.html#cfn-amplifyuibuilder-component-componentconditionproperty-property">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentconditionproperty.html#cfn-amplifyuibuilder-component-componentconditionproperty-property</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProperty() {
            return null;
        }

        /**
         * The value to assign to the property if the condition is met.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentconditionproperty.html#cfn-amplifyuibuilder-component-componentconditionproperty-then">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentconditionproperty.html#cfn-amplifyuibuilder-component-componentconditionproperty-then</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getThen() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentConditionPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentConditionPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentConditionPropertyProperty> {
            java.lang.Object elseValue;
            java.lang.String field;
            java.lang.String operand;
            java.lang.String operandType;
            java.lang.String operator;
            java.lang.String property;
            java.lang.Object then;

            /**
             * Sets the value of {@link ComponentConditionPropertyProperty#getElseValue}
             * @param elseValue The value to assign to the property if the condition is not met.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elseValue(software.amazon.awscdk.IResolvable elseValue) {
                this.elseValue = elseValue;
                return this;
            }

            /**
             * Sets the value of {@link ComponentConditionPropertyProperty#getElseValue}
             * @param elseValue The value to assign to the property if the condition is not met.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder elseValue(software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentPropertyProperty elseValue) {
                this.elseValue = elseValue;
                return this;
            }

            /**
             * Sets the value of {@link ComponentConditionPropertyProperty#getField}
             * @param field The name of a field.
             *              Specify this when the property is a data model.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder field(java.lang.String field) {
                this.field = field;
                return this;
            }

            /**
             * Sets the value of {@link ComponentConditionPropertyProperty#getOperand}
             * @param operand The value of the property to evaluate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operand(java.lang.String operand) {
                this.operand = operand;
                return this;
            }

            /**
             * Sets the value of {@link ComponentConditionPropertyProperty#getOperandType}
             * @param operandType The type of the property to evaluate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operandType(java.lang.String operandType) {
                this.operandType = operandType;
                return this;
            }

            /**
             * Sets the value of {@link ComponentConditionPropertyProperty#getOperator}
             * @param operator The operator to use to perform the evaluation, such as <code>eq</code> to represent equals.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link ComponentConditionPropertyProperty#getProperty}
             * @param property The name of the conditional property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder property(java.lang.String property) {
                this.property = property;
                return this;
            }

            /**
             * Sets the value of {@link ComponentConditionPropertyProperty#getThen}
             * @param then The value to assign to the property if the condition is met.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder then(software.amazon.awscdk.IResolvable then) {
                this.then = then;
                return this;
            }

            /**
             * Sets the value of {@link ComponentConditionPropertyProperty#getThen}
             * @param then The value to assign to the property if the condition is met.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder then(software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentPropertyProperty then) {
                this.then = then;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentConditionPropertyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentConditionPropertyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentConditionPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentConditionPropertyProperty {
            private final java.lang.Object elseValue;
            private final java.lang.String field;
            private final java.lang.String operand;
            private final java.lang.String operandType;
            private final java.lang.String operator;
            private final java.lang.String property;
            private final java.lang.Object then;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.elseValue = software.amazon.jsii.Kernel.get(this, "else", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.field = software.amazon.jsii.Kernel.get(this, "field", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.operand = software.amazon.jsii.Kernel.get(this, "operand", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.operandType = software.amazon.jsii.Kernel.get(this, "operandType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.property = software.amazon.jsii.Kernel.get(this, "property", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.then = software.amazon.jsii.Kernel.get(this, "then", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.elseValue = builder.elseValue;
                this.field = builder.field;
                this.operand = builder.operand;
                this.operandType = builder.operandType;
                this.operator = builder.operator;
                this.property = builder.property;
                this.then = builder.then;
            }

            @Override
            public final java.lang.Object getElseValue() {
                return this.elseValue;
            }

            @Override
            public final java.lang.String getField() {
                return this.field;
            }

            @Override
            public final java.lang.String getOperand() {
                return this.operand;
            }

            @Override
            public final java.lang.String getOperandType() {
                return this.operandType;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.lang.String getProperty() {
                return this.property;
            }

            @Override
            public final java.lang.Object getThen() {
                return this.then;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getElseValue() != null) {
                    data.set("else", om.valueToTree(this.getElseValue()));
                }
                if (this.getField() != null) {
                    data.set("field", om.valueToTree(this.getField()));
                }
                if (this.getOperand() != null) {
                    data.set("operand", om.valueToTree(this.getOperand()));
                }
                if (this.getOperandType() != null) {
                    data.set("operandType", om.valueToTree(this.getOperandType()));
                }
                if (this.getOperator() != null) {
                    data.set("operator", om.valueToTree(this.getOperator()));
                }
                if (this.getProperty() != null) {
                    data.set("property", om.valueToTree(this.getProperty()));
                }
                if (this.getThen() != null) {
                    data.set("then", om.valueToTree(this.getThen()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentConditionPropertyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentConditionPropertyProperty.Jsii$Proxy that = (ComponentConditionPropertyProperty.Jsii$Proxy) o;

                if (this.elseValue != null ? !this.elseValue.equals(that.elseValue) : that.elseValue != null) return false;
                if (this.field != null ? !this.field.equals(that.field) : that.field != null) return false;
                if (this.operand != null ? !this.operand.equals(that.operand) : that.operand != null) return false;
                if (this.operandType != null ? !this.operandType.equals(that.operandType) : that.operandType != null) return false;
                if (this.operator != null ? !this.operator.equals(that.operator) : that.operator != null) return false;
                if (this.property != null ? !this.property.equals(that.property) : that.property != null) return false;
                return this.then != null ? this.then.equals(that.then) : that.then == null;
            }

            @Override
            public final int hashCode() {
                int result = this.elseValue != null ? this.elseValue.hashCode() : 0;
                result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
                result = 31 * result + (this.operand != null ? this.operand.hashCode() : 0);
                result = 31 * result + (this.operandType != null ? this.operandType.hashCode() : 0);
                result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
                result = 31 * result + (this.property != null ? this.property.hashCode() : 0);
                result = 31 * result + (this.then != null ? this.then.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ComponentDataConfiguration</code> property specifies the configuration for binding a component's properties to data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * PredicateProperty predicateProperty_;
     * ComponentDataConfigurationProperty componentDataConfigurationProperty = ComponentDataConfigurationProperty.builder()
     *         .model("model")
     *         // the properties below are optional
     *         .identifiers(List.of("identifiers"))
     *         .predicate(PredicateProperty.builder()
     *                 .and(List.of(predicateProperty_))
     *                 .field("field")
     *                 .operand("operand")
     *                 .operandType("operandType")
     *                 .operator("operator")
     *                 .or(List.of(predicateProperty_))
     *                 .build())
     *         .sort(List.of(SortPropertyProperty.builder()
     *                 .direction("direction")
     *                 .field("field")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentdataconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentdataconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentDataConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentDataConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentDataConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the data model to use to bind data to a component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentdataconfiguration.html#cfn-amplifyuibuilder-component-componentdataconfiguration-model">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentdataconfiguration.html#cfn-amplifyuibuilder-component-componentdataconfiguration-model</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getModel();

        /**
         * A list of IDs to use to bind data to a component.
         * <p>
         * Use this property to bind specifically chosen data, rather than data retrieved from a query.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentdataconfiguration.html#cfn-amplifyuibuilder-component-componentdataconfiguration-identifiers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentdataconfiguration.html#cfn-amplifyuibuilder-component-componentdataconfiguration-identifiers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIdentifiers() {
            return null;
        }

        /**
         * Represents the conditional logic to use when binding data to a component.
         * <p>
         * Use this property to retrieve only a subset of the data in a collection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentdataconfiguration.html#cfn-amplifyuibuilder-component-componentdataconfiguration-predicate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentdataconfiguration.html#cfn-amplifyuibuilder-component-componentdataconfiguration-predicate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPredicate() {
            return null;
        }

        /**
         * Describes how to sort the component's properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentdataconfiguration.html#cfn-amplifyuibuilder-component-componentdataconfiguration-sort">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentdataconfiguration.html#cfn-amplifyuibuilder-component-componentdataconfiguration-sort</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentDataConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentDataConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentDataConfigurationProperty> {
            java.lang.String model;
            java.util.List<java.lang.String> identifiers;
            java.lang.Object predicate;
            java.lang.Object sort;

            /**
             * Sets the value of {@link ComponentDataConfigurationProperty#getModel}
             * @param model The name of the data model to use to bind data to a component. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder model(java.lang.String model) {
                this.model = model;
                return this;
            }

            /**
             * Sets the value of {@link ComponentDataConfigurationProperty#getIdentifiers}
             * @param identifiers A list of IDs to use to bind data to a component.
             *                    Use this property to bind specifically chosen data, rather than data retrieved from a query.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identifiers(java.util.List<java.lang.String> identifiers) {
                this.identifiers = identifiers;
                return this;
            }

            /**
             * Sets the value of {@link ComponentDataConfigurationProperty#getPredicate}
             * @param predicate Represents the conditional logic to use when binding data to a component.
             *                  Use this property to retrieve only a subset of the data in a collection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predicate(software.amazon.awscdk.IResolvable predicate) {
                this.predicate = predicate;
                return this;
            }

            /**
             * Sets the value of {@link ComponentDataConfigurationProperty#getPredicate}
             * @param predicate Represents the conditional logic to use when binding data to a component.
             *                  Use this property to retrieve only a subset of the data in a collection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder predicate(software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.PredicateProperty predicate) {
                this.predicate = predicate;
                return this;
            }

            /**
             * Sets the value of {@link ComponentDataConfigurationProperty#getSort}
             * @param sort Describes how to sort the component's properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sort(software.amazon.awscdk.IResolvable sort) {
                this.sort = sort;
                return this;
            }

            /**
             * Sets the value of {@link ComponentDataConfigurationProperty#getSort}
             * @param sort Describes how to sort the component's properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sort(java.util.List<? extends java.lang.Object> sort) {
                this.sort = sort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentDataConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentDataConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentDataConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentDataConfigurationProperty {
            private final java.lang.String model;
            private final java.util.List<java.lang.String> identifiers;
            private final java.lang.Object predicate;
            private final java.lang.Object sort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.model = software.amazon.jsii.Kernel.get(this, "model", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.identifiers = software.amazon.jsii.Kernel.get(this, "identifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.predicate = software.amazon.jsii.Kernel.get(this, "predicate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sort = software.amazon.jsii.Kernel.get(this, "sort", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.model = java.util.Objects.requireNonNull(builder.model, "model is required");
                this.identifiers = builder.identifiers;
                this.predicate = builder.predicate;
                this.sort = builder.sort;
            }

            @Override
            public final java.lang.String getModel() {
                return this.model;
            }

            @Override
            public final java.util.List<java.lang.String> getIdentifiers() {
                return this.identifiers;
            }

            @Override
            public final java.lang.Object getPredicate() {
                return this.predicate;
            }

            @Override
            public final java.lang.Object getSort() {
                return this.sort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("model", om.valueToTree(this.getModel()));
                if (this.getIdentifiers() != null) {
                    data.set("identifiers", om.valueToTree(this.getIdentifiers()));
                }
                if (this.getPredicate() != null) {
                    data.set("predicate", om.valueToTree(this.getPredicate()));
                }
                if (this.getSort() != null) {
                    data.set("sort", om.valueToTree(this.getSort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentDataConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentDataConfigurationProperty.Jsii$Proxy that = (ComponentDataConfigurationProperty.Jsii$Proxy) o;

                if (!model.equals(that.model)) return false;
                if (this.identifiers != null ? !this.identifiers.equals(that.identifiers) : that.identifiers != null) return false;
                if (this.predicate != null ? !this.predicate.equals(that.predicate) : that.predicate != null) return false;
                return this.sort != null ? this.sort.equals(that.sort) : that.sort == null;
            }

            @Override
            public final int hashCode() {
                int result = this.model.hashCode();
                result = 31 * result + (this.identifiers != null ? this.identifiers.hashCode() : 0);
                result = 31 * result + (this.predicate != null ? this.predicate.hashCode() : 0);
                result = 31 * result + (this.sort != null ? this.sort.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ComponentEvent</code> property specifies the configuration of an event.
     * <p>
     * You can bind an event and a corresponding action to a <code>Component</code> or a <code>ComponentChild</code> . A button click is an example of an event.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * ComponentPropertyProperty componentPropertyProperty_;
     * ComponentEventProperty componentEventProperty = ComponentEventProperty.builder()
     *         .action("action")
     *         .bindingEvent("bindingEvent")
     *         .parameters(ActionParametersProperty.builder()
     *                 .anchor(ComponentPropertyProperty.builder()
     *                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .bindings(Map.of(
     *                                 "bindingsKey", FormBindingElementProperty.builder()
     *                                         .element("element")
     *                                         .property("property")
     *                                         .build()))
     *                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .componentName("componentName")
     *                         .concat(List.of(componentPropertyProperty_))
     *                         .condition(ComponentConditionPropertyProperty.builder()
     *                                 .else(componentPropertyProperty_)
     *                                 .field("field")
     *                                 .operand("operand")
     *                                 .operandType("operandType")
     *                                 .operator("operator")
     *                                 .property("property")
     *                                 .then(componentPropertyProperty_)
     *                                 .build())
     *                         .configured(false)
     *                         .defaultValue("defaultValue")
     *                         .event("event")
     *                         .importedValue("importedValue")
     *                         .model("model")
     *                         .property("property")
     *                         .type("type")
     *                         .userAttribute("userAttribute")
     *                         .value("value")
     *                         .build())
     *                 .fields(Map.of(
     *                         "fieldsKey", ComponentPropertyProperty.builder()
     *                                 .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                         .property("property")
     *                                         // the properties below are optional
     *                                         .field("field")
     *                                         .build())
     *                                 .bindings(Map.of(
     *                                         "bindingsKey", FormBindingElementProperty.builder()
     *                                                 .element("element")
     *                                                 .property("property")
     *                                                 .build()))
     *                                 .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                         .property("property")
     *                                         // the properties below are optional
     *                                         .field("field")
     *                                         .build())
     *                                 .componentName("componentName")
     *                                 .concat(List.of(componentPropertyProperty_))
     *                                 .condition(ComponentConditionPropertyProperty.builder()
     *                                         .else(componentPropertyProperty_)
     *                                         .field("field")
     *                                         .operand("operand")
     *                                         .operandType("operandType")
     *                                         .operator("operator")
     *                                         .property("property")
     *                                         .then(componentPropertyProperty_)
     *                                         .build())
     *                                 .configured(false)
     *                                 .defaultValue("defaultValue")
     *                                 .event("event")
     *                                 .importedValue("importedValue")
     *                                 .model("model")
     *                                 .property("property")
     *                                 .type("type")
     *                                 .userAttribute("userAttribute")
     *                                 .value("value")
     *                                 .build()))
     *                 .global(ComponentPropertyProperty.builder()
     *                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .bindings(Map.of(
     *                                 "bindingsKey", FormBindingElementProperty.builder()
     *                                         .element("element")
     *                                         .property("property")
     *                                         .build()))
     *                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .componentName("componentName")
     *                         .concat(List.of(componentPropertyProperty_))
     *                         .condition(ComponentConditionPropertyProperty.builder()
     *                                 .else(componentPropertyProperty_)
     *                                 .field("field")
     *                                 .operand("operand")
     *                                 .operandType("operandType")
     *                                 .operator("operator")
     *                                 .property("property")
     *                                 .then(componentPropertyProperty_)
     *                                 .build())
     *                         .configured(false)
     *                         .defaultValue("defaultValue")
     *                         .event("event")
     *                         .importedValue("importedValue")
     *                         .model("model")
     *                         .property("property")
     *                         .type("type")
     *                         .userAttribute("userAttribute")
     *                         .value("value")
     *                         .build())
     *                 .id(ComponentPropertyProperty.builder()
     *                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .bindings(Map.of(
     *                                 "bindingsKey", FormBindingElementProperty.builder()
     *                                         .element("element")
     *                                         .property("property")
     *                                         .build()))
     *                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .componentName("componentName")
     *                         .concat(List.of(componentPropertyProperty_))
     *                         .condition(ComponentConditionPropertyProperty.builder()
     *                                 .else(componentPropertyProperty_)
     *                                 .field("field")
     *                                 .operand("operand")
     *                                 .operandType("operandType")
     *                                 .operator("operator")
     *                                 .property("property")
     *                                 .then(componentPropertyProperty_)
     *                                 .build())
     *                         .configured(false)
     *                         .defaultValue("defaultValue")
     *                         .event("event")
     *                         .importedValue("importedValue")
     *                         .model("model")
     *                         .property("property")
     *                         .type("type")
     *                         .userAttribute("userAttribute")
     *                         .value("value")
     *                         .build())
     *                 .model("model")
     *                 .state(MutationActionSetStateParameterProperty.builder()
     *                         .componentName("componentName")
     *                         .property("property")
     *                         .set(ComponentPropertyProperty.builder()
     *                                 .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                         .property("property")
     *                                         // the properties below are optional
     *                                         .field("field")
     *                                         .build())
     *                                 .bindings(Map.of(
     *                                         "bindingsKey", FormBindingElementProperty.builder()
     *                                                 .element("element")
     *                                                 .property("property")
     *                                                 .build()))
     *                                 .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                         .property("property")
     *                                         // the properties below are optional
     *                                         .field("field")
     *                                         .build())
     *                                 .componentName("componentName")
     *                                 .concat(List.of(componentPropertyProperty_))
     *                                 .condition(ComponentConditionPropertyProperty.builder()
     *                                         .else(componentPropertyProperty_)
     *                                         .field("field")
     *                                         .operand("operand")
     *                                         .operandType("operandType")
     *                                         .operator("operator")
     *                                         .property("property")
     *                                         .then(componentPropertyProperty_)
     *                                         .build())
     *                                 .configured(false)
     *                                 .defaultValue("defaultValue")
     *                                 .event("event")
     *                                 .importedValue("importedValue")
     *                                 .model("model")
     *                                 .property("property")
     *                                 .type("type")
     *                                 .userAttribute("userAttribute")
     *                                 .value("value")
     *                                 .build())
     *                         .build())
     *                 .target(ComponentPropertyProperty.builder()
     *                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .bindings(Map.of(
     *                                 "bindingsKey", FormBindingElementProperty.builder()
     *                                         .element("element")
     *                                         .property("property")
     *                                         .build()))
     *                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .componentName("componentName")
     *                         .concat(List.of(componentPropertyProperty_))
     *                         .condition(ComponentConditionPropertyProperty.builder()
     *                                 .else(componentPropertyProperty_)
     *                                 .field("field")
     *                                 .operand("operand")
     *                                 .operandType("operandType")
     *                                 .operator("operator")
     *                                 .property("property")
     *                                 .then(componentPropertyProperty_)
     *                                 .build())
     *                         .configured(false)
     *                         .defaultValue("defaultValue")
     *                         .event("event")
     *                         .importedValue("importedValue")
     *                         .model("model")
     *                         .property("property")
     *                         .type("type")
     *                         .userAttribute("userAttribute")
     *                         .value("value")
     *                         .build())
     *                 .type(ComponentPropertyProperty.builder()
     *                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .bindings(Map.of(
     *                                 "bindingsKey", FormBindingElementProperty.builder()
     *                                         .element("element")
     *                                         .property("property")
     *                                         .build()))
     *                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .componentName("componentName")
     *                         .concat(List.of(componentPropertyProperty_))
     *                         .condition(ComponentConditionPropertyProperty.builder()
     *                                 .else(componentPropertyProperty_)
     *                                 .field("field")
     *                                 .operand("operand")
     *                                 .operandType("operandType")
     *                                 .operator("operator")
     *                                 .property("property")
     *                                 .then(componentPropertyProperty_)
     *                                 .build())
     *                         .configured(false)
     *                         .defaultValue("defaultValue")
     *                         .event("event")
     *                         .importedValue("importedValue")
     *                         .model("model")
     *                         .property("property")
     *                         .type("type")
     *                         .userAttribute("userAttribute")
     *                         .value("value")
     *                         .build())
     *                 .url(ComponentPropertyProperty.builder()
     *                         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .bindings(Map.of(
     *                                 "bindingsKey", FormBindingElementProperty.builder()
     *                                         .element("element")
     *                                         .property("property")
     *                                         .build()))
     *                         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                                 .property("property")
     *                                 // the properties below are optional
     *                                 .field("field")
     *                                 .build())
     *                         .componentName("componentName")
     *                         .concat(List.of(componentPropertyProperty_))
     *                         .condition(ComponentConditionPropertyProperty.builder()
     *                                 .else(componentPropertyProperty_)
     *                                 .field("field")
     *                                 .operand("operand")
     *                                 .operandType("operandType")
     *                                 .operator("operator")
     *                                 .property("property")
     *                                 .then(componentPropertyProperty_)
     *                                 .build())
     *                         .configured(false)
     *                         .defaultValue("defaultValue")
     *                         .event("event")
     *                         .importedValue("importedValue")
     *                         .model("model")
     *                         .property("property")
     *                         .type("type")
     *                         .userAttribute("userAttribute")
     *                         .value("value")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentevent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentevent.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentEventProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentEventProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentEventProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to perform when a specific event is raised.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentevent.html#cfn-amplifyuibuilder-component-componentevent-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentevent.html#cfn-amplifyuibuilder-component-componentevent-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
            return null;
        }

        /**
         * Binds an event to an action on a component.
         * <p>
         * When you specify a <code>bindingEvent</code> , the event is called when the action is performed.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentevent.html#cfn-amplifyuibuilder-component-componentevent-bindingevent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentevent.html#cfn-amplifyuibuilder-component-componentevent-bindingevent</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBindingEvent() {
            return null;
        }

        /**
         * Describes information about the action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentevent.html#cfn-amplifyuibuilder-component-componentevent-parameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentevent.html#cfn-amplifyuibuilder-component-componentevent-parameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentEventProperty> {
            java.lang.String action;
            java.lang.String bindingEvent;
            java.lang.Object parameters;

            /**
             * Sets the value of {@link ComponentEventProperty#getAction}
             * @param action The action to perform when a specific event is raised.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link ComponentEventProperty#getBindingEvent}
             * @param bindingEvent Binds an event to an action on a component.
             *                     When you specify a <code>bindingEvent</code> , the event is called when the action is performed.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bindingEvent(java.lang.String bindingEvent) {
                this.bindingEvent = bindingEvent;
                return this;
            }

            /**
             * Sets the value of {@link ComponentEventProperty#getParameters}
             * @param parameters Describes information about the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.IResolvable parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Sets the value of {@link ComponentEventProperty#getParameters}
             * @param parameters Describes information about the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameters(software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ActionParametersProperty parameters) {
                this.parameters = parameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentEventProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentEventProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentEventProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentEventProperty {
            private final java.lang.String action;
            private final java.lang.String bindingEvent;
            private final java.lang.Object parameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bindingEvent = software.amazon.jsii.Kernel.get(this, "bindingEvent", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = builder.action;
                this.bindingEvent = builder.bindingEvent;
                this.parameters = builder.parameters;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getBindingEvent() {
                return this.bindingEvent;
            }

            @Override
            public final java.lang.Object getParameters() {
                return this.parameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAction() != null) {
                    data.set("action", om.valueToTree(this.getAction()));
                }
                if (this.getBindingEvent() != null) {
                    data.set("bindingEvent", om.valueToTree(this.getBindingEvent()));
                }
                if (this.getParameters() != null) {
                    data.set("parameters", om.valueToTree(this.getParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentEventProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentEventProperty.Jsii$Proxy that = (ComponentEventProperty.Jsii$Proxy) o;

                if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
                if (this.bindingEvent != null ? !this.bindingEvent.equals(that.bindingEvent) : that.bindingEvent != null) return false;
                return this.parameters != null ? this.parameters.equals(that.parameters) : that.parameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action != null ? this.action.hashCode() : 0;
                result = 31 * result + (this.bindingEvent != null ? this.bindingEvent.hashCode() : 0);
                result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ComponentPropertyBindingProperties</code> property specifies a component property to associate with a binding property.
     * <p>
     * This enables exposed properties on the top level component to propagate data to the component's property values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * ComponentPropertyBindingPropertiesProperty componentPropertyBindingPropertiesProperty = ComponentPropertyBindingPropertiesProperty.builder()
     *         .property("property")
     *         // the properties below are optional
     *         .field("field")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentpropertybindingproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentpropertybindingproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentPropertyBindingPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentPropertyBindingPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentPropertyBindingPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The component property to bind to the data field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentpropertybindingproperties.html#cfn-amplifyuibuilder-component-componentpropertybindingproperties-property">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentpropertybindingproperties.html#cfn-amplifyuibuilder-component-componentpropertybindingproperties-property</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProperty();

        /**
         * The data field to bind the property to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentpropertybindingproperties.html#cfn-amplifyuibuilder-component-componentpropertybindingproperties-field">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentpropertybindingproperties.html#cfn-amplifyuibuilder-component-componentpropertybindingproperties-field</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getField() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentPropertyBindingPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentPropertyBindingPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentPropertyBindingPropertiesProperty> {
            java.lang.String property;
            java.lang.String field;

            /**
             * Sets the value of {@link ComponentPropertyBindingPropertiesProperty#getProperty}
             * @param property The component property to bind to the data field. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder property(java.lang.String property) {
                this.property = property;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyBindingPropertiesProperty#getField}
             * @param field The data field to bind the property to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder field(java.lang.String field) {
                this.field = field;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentPropertyBindingPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentPropertyBindingPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentPropertyBindingPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentPropertyBindingPropertiesProperty {
            private final java.lang.String property;
            private final java.lang.String field;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.property = software.amazon.jsii.Kernel.get(this, "property", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.field = software.amazon.jsii.Kernel.get(this, "field", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.property = java.util.Objects.requireNonNull(builder.property, "property is required");
                this.field = builder.field;
            }

            @Override
            public final java.lang.String getProperty() {
                return this.property;
            }

            @Override
            public final java.lang.String getField() {
                return this.field;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("property", om.valueToTree(this.getProperty()));
                if (this.getField() != null) {
                    data.set("field", om.valueToTree(this.getField()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentPropertyBindingPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentPropertyBindingPropertiesProperty.Jsii$Proxy that = (ComponentPropertyBindingPropertiesProperty.Jsii$Proxy) o;

                if (!property.equals(that.property)) return false;
                return this.field != null ? this.field.equals(that.field) : that.field == null;
            }

            @Override
            public final int hashCode() {
                int result = this.property.hashCode();
                result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ComponentProperty</code> property specifies the configuration for all of a component's properties.
     * <p>
     * Use <code>ComponentProperty</code> to specify the values to render or bind by default.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * ComponentPropertyProperty componentPropertyProperty_;
     * ComponentPropertyProperty componentPropertyProperty = ComponentPropertyProperty.builder()
     *         .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                 .property("property")
     *                 // the properties below are optional
     *                 .field("field")
     *                 .build())
     *         .bindings(Map.of(
     *                 "bindingsKey", FormBindingElementProperty.builder()
     *                         .element("element")
     *                         .property("property")
     *                         .build()))
     *         .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                 .property("property")
     *                 // the properties below are optional
     *                 .field("field")
     *                 .build())
     *         .componentName("componentName")
     *         .concat(List.of(componentPropertyProperty_))
     *         .condition(ComponentConditionPropertyProperty.builder()
     *                 .else(componentPropertyProperty_)
     *                 .field("field")
     *                 .operand("operand")
     *                 .operandType("operandType")
     *                 .operator("operator")
     *                 .property("property")
     *                 .then(componentPropertyProperty_)
     *                 .build())
     *         .configured(false)
     *         .defaultValue("defaultValue")
     *         .event("event")
     *         .importedValue("importedValue")
     *         .model("model")
     *         .property("property")
     *         .type("type")
     *         .userAttribute("userAttribute")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentPropertyProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentPropertyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentPropertyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The information to bind the component property to data at runtime.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-bindingproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-bindingproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBindingProperties() {
            return null;
        }

        /**
         * The information to bind the component property to form data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-bindings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-bindings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBindings() {
            return null;
        }

        /**
         * The information to bind the component property to data at runtime.
         * <p>
         * Use this for collection components.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-collectionbindingproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-collectionbindingproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCollectionBindingProperties() {
            return null;
        }

        /**
         * The name of the component that is affected by an event.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-componentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-componentname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentName() {
            return null;
        }

        /**
         * A list of component properties to concatenate to create the value to assign to this component property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-concat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-concat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConcat() {
            return null;
        }

        /**
         * The conditional expression to use to assign a value to the component property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCondition() {
            return null;
        }

        /**
         * Specifies whether the user configured the property in Amplify Studio after importing it.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-configured">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-configured</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigured() {
            return null;
        }

        /**
         * The default value to assign to the component property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-defaultvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-defaultvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultValue() {
            return null;
        }

        /**
         * An event that occurs in your app.
         * <p>
         * Use this for workflow data binding.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-event">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-event</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEvent() {
            return null;
        }

        /**
         * The default value assigned to the property when the component is imported into an app.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-importedvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-importedvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImportedValue() {
            return null;
        }

        /**
         * The data model to use to assign a value to the component property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-model">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-model</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getModel() {
            return null;
        }

        /**
         * The name of the component's property that is affected by an event.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-property">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-property</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProperty() {
            return null;
        }

        /**
         * The component type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * An authenticated user attribute to use to assign a value to the component property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-userattribute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-userattribute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserAttribute() {
            return null;
        }

        /**
         * The value to assign to the component property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentproperty.html#cfn-amplifyuibuilder-component-componentproperty-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentPropertyProperty> {
            java.lang.Object bindingProperties;
            java.lang.Object bindings;
            java.lang.Object collectionBindingProperties;
            java.lang.String componentName;
            java.lang.Object concat;
            java.lang.Object condition;
            java.lang.Object configured;
            java.lang.String defaultValue;
            java.lang.String event;
            java.lang.String importedValue;
            java.lang.String model;
            java.lang.String property;
            java.lang.String type;
            java.lang.String userAttribute;
            java.lang.String value;

            /**
             * Sets the value of {@link ComponentPropertyProperty#getBindingProperties}
             * @param bindingProperties The information to bind the component property to data at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bindingProperties(software.amazon.awscdk.IResolvable bindingProperties) {
                this.bindingProperties = bindingProperties;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getBindingProperties}
             * @param bindingProperties The information to bind the component property to data at runtime.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bindingProperties(software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentPropertyBindingPropertiesProperty bindingProperties) {
                this.bindingProperties = bindingProperties;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getBindings}
             * @param bindings The information to bind the component property to form data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bindings(software.amazon.awscdk.IResolvable bindings) {
                this.bindings = bindings;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getBindings}
             * @param bindings The information to bind the component property to form data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bindings(java.util.Map<java.lang.String, ? extends java.lang.Object> bindings) {
                this.bindings = bindings;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getCollectionBindingProperties}
             * @param collectionBindingProperties The information to bind the component property to data at runtime.
             *                                    Use this for collection components.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder collectionBindingProperties(software.amazon.awscdk.IResolvable collectionBindingProperties) {
                this.collectionBindingProperties = collectionBindingProperties;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getCollectionBindingProperties}
             * @param collectionBindingProperties The information to bind the component property to data at runtime.
             *                                    Use this for collection components.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder collectionBindingProperties(software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentPropertyBindingPropertiesProperty collectionBindingProperties) {
                this.collectionBindingProperties = collectionBindingProperties;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getComponentName}
             * @param componentName The name of the component that is affected by an event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentName(java.lang.String componentName) {
                this.componentName = componentName;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getConcat}
             * @param concat A list of component properties to concatenate to create the value to assign to this component property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder concat(software.amazon.awscdk.IResolvable concat) {
                this.concat = concat;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getConcat}
             * @param concat A list of component properties to concatenate to create the value to assign to this component property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder concat(java.util.List<? extends java.lang.Object> concat) {
                this.concat = concat;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getCondition}
             * @param condition The conditional expression to use to assign a value to the component property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(software.amazon.awscdk.IResolvable condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getCondition}
             * @param condition The conditional expression to use to assign a value to the component property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentConditionPropertyProperty condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getConfigured}
             * @param configured Specifies whether the user configured the property in Amplify Studio after importing it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configured(java.lang.Boolean configured) {
                this.configured = configured;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getConfigured}
             * @param configured Specifies whether the user configured the property in Amplify Studio after importing it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configured(software.amazon.awscdk.IResolvable configured) {
                this.configured = configured;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getDefaultValue}
             * @param defaultValue The default value to assign to the component property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(java.lang.String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getEvent}
             * @param event An event that occurs in your app.
             *              Use this for workflow data binding.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder event(java.lang.String event) {
                this.event = event;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getImportedValue}
             * @param importedValue The default value assigned to the property when the component is imported into an app.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder importedValue(java.lang.String importedValue) {
                this.importedValue = importedValue;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getModel}
             * @param model The data model to use to assign a value to the component property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder model(java.lang.String model) {
                this.model = model;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getProperty}
             * @param property The name of the component's property that is affected by an event.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder property(java.lang.String property) {
                this.property = property;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getType}
             * @param type The component type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getUserAttribute}
             * @param userAttribute An authenticated user attribute to use to assign a value to the component property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userAttribute(java.lang.String userAttribute) {
                this.userAttribute = userAttribute;
                return this;
            }

            /**
             * Sets the value of {@link ComponentPropertyProperty#getValue}
             * @param value The value to assign to the component property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentPropertyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentPropertyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentPropertyProperty {
            private final java.lang.Object bindingProperties;
            private final java.lang.Object bindings;
            private final java.lang.Object collectionBindingProperties;
            private final java.lang.String componentName;
            private final java.lang.Object concat;
            private final java.lang.Object condition;
            private final java.lang.Object configured;
            private final java.lang.String defaultValue;
            private final java.lang.String event;
            private final java.lang.String importedValue;
            private final java.lang.String model;
            private final java.lang.String property;
            private final java.lang.String type;
            private final java.lang.String userAttribute;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bindingProperties = software.amazon.jsii.Kernel.get(this, "bindingProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bindings = software.amazon.jsii.Kernel.get(this, "bindings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.collectionBindingProperties = software.amazon.jsii.Kernel.get(this, "collectionBindingProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.componentName = software.amazon.jsii.Kernel.get(this, "componentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.concat = software.amazon.jsii.Kernel.get(this, "concat", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.configured = software.amazon.jsii.Kernel.get(this, "configured", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultValue = software.amazon.jsii.Kernel.get(this, "defaultValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.event = software.amazon.jsii.Kernel.get(this, "event", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.importedValue = software.amazon.jsii.Kernel.get(this, "importedValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.model = software.amazon.jsii.Kernel.get(this, "model", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.property = software.amazon.jsii.Kernel.get(this, "property", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userAttribute = software.amazon.jsii.Kernel.get(this, "userAttribute", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bindingProperties = builder.bindingProperties;
                this.bindings = builder.bindings;
                this.collectionBindingProperties = builder.collectionBindingProperties;
                this.componentName = builder.componentName;
                this.concat = builder.concat;
                this.condition = builder.condition;
                this.configured = builder.configured;
                this.defaultValue = builder.defaultValue;
                this.event = builder.event;
                this.importedValue = builder.importedValue;
                this.model = builder.model;
                this.property = builder.property;
                this.type = builder.type;
                this.userAttribute = builder.userAttribute;
                this.value = builder.value;
            }

            @Override
            public final java.lang.Object getBindingProperties() {
                return this.bindingProperties;
            }

            @Override
            public final java.lang.Object getBindings() {
                return this.bindings;
            }

            @Override
            public final java.lang.Object getCollectionBindingProperties() {
                return this.collectionBindingProperties;
            }

            @Override
            public final java.lang.String getComponentName() {
                return this.componentName;
            }

            @Override
            public final java.lang.Object getConcat() {
                return this.concat;
            }

            @Override
            public final java.lang.Object getCondition() {
                return this.condition;
            }

            @Override
            public final java.lang.Object getConfigured() {
                return this.configured;
            }

            @Override
            public final java.lang.String getDefaultValue() {
                return this.defaultValue;
            }

            @Override
            public final java.lang.String getEvent() {
                return this.event;
            }

            @Override
            public final java.lang.String getImportedValue() {
                return this.importedValue;
            }

            @Override
            public final java.lang.String getModel() {
                return this.model;
            }

            @Override
            public final java.lang.String getProperty() {
                return this.property;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getUserAttribute() {
                return this.userAttribute;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBindingProperties() != null) {
                    data.set("bindingProperties", om.valueToTree(this.getBindingProperties()));
                }
                if (this.getBindings() != null) {
                    data.set("bindings", om.valueToTree(this.getBindings()));
                }
                if (this.getCollectionBindingProperties() != null) {
                    data.set("collectionBindingProperties", om.valueToTree(this.getCollectionBindingProperties()));
                }
                if (this.getComponentName() != null) {
                    data.set("componentName", om.valueToTree(this.getComponentName()));
                }
                if (this.getConcat() != null) {
                    data.set("concat", om.valueToTree(this.getConcat()));
                }
                if (this.getCondition() != null) {
                    data.set("condition", om.valueToTree(this.getCondition()));
                }
                if (this.getConfigured() != null) {
                    data.set("configured", om.valueToTree(this.getConfigured()));
                }
                if (this.getDefaultValue() != null) {
                    data.set("defaultValue", om.valueToTree(this.getDefaultValue()));
                }
                if (this.getEvent() != null) {
                    data.set("event", om.valueToTree(this.getEvent()));
                }
                if (this.getImportedValue() != null) {
                    data.set("importedValue", om.valueToTree(this.getImportedValue()));
                }
                if (this.getModel() != null) {
                    data.set("model", om.valueToTree(this.getModel()));
                }
                if (this.getProperty() != null) {
                    data.set("property", om.valueToTree(this.getProperty()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }
                if (this.getUserAttribute() != null) {
                    data.set("userAttribute", om.valueToTree(this.getUserAttribute()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentPropertyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentPropertyProperty.Jsii$Proxy that = (ComponentPropertyProperty.Jsii$Proxy) o;

                if (this.bindingProperties != null ? !this.bindingProperties.equals(that.bindingProperties) : that.bindingProperties != null) return false;
                if (this.bindings != null ? !this.bindings.equals(that.bindings) : that.bindings != null) return false;
                if (this.collectionBindingProperties != null ? !this.collectionBindingProperties.equals(that.collectionBindingProperties) : that.collectionBindingProperties != null) return false;
                if (this.componentName != null ? !this.componentName.equals(that.componentName) : that.componentName != null) return false;
                if (this.concat != null ? !this.concat.equals(that.concat) : that.concat != null) return false;
                if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) return false;
                if (this.configured != null ? !this.configured.equals(that.configured) : that.configured != null) return false;
                if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) return false;
                if (this.event != null ? !this.event.equals(that.event) : that.event != null) return false;
                if (this.importedValue != null ? !this.importedValue.equals(that.importedValue) : that.importedValue != null) return false;
                if (this.model != null ? !this.model.equals(that.model) : that.model != null) return false;
                if (this.property != null ? !this.property.equals(that.property) : that.property != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                if (this.userAttribute != null ? !this.userAttribute.equals(that.userAttribute) : that.userAttribute != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bindingProperties != null ? this.bindingProperties.hashCode() : 0;
                result = 31 * result + (this.bindings != null ? this.bindings.hashCode() : 0);
                result = 31 * result + (this.collectionBindingProperties != null ? this.collectionBindingProperties.hashCode() : 0);
                result = 31 * result + (this.componentName != null ? this.componentName.hashCode() : 0);
                result = 31 * result + (this.concat != null ? this.concat.hashCode() : 0);
                result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
                result = 31 * result + (this.configured != null ? this.configured.hashCode() : 0);
                result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                result = 31 * result + (this.event != null ? this.event.hashCode() : 0);
                result = 31 * result + (this.importedValue != null ? this.importedValue.hashCode() : 0);
                result = 31 * result + (this.model != null ? this.model.hashCode() : 0);
                result = 31 * result + (this.property != null ? this.property.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.userAttribute != null ? this.userAttribute.hashCode() : 0);
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>ComponentVariant</code> property specifies the style configuration of a unique variation of a main component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * Object overrides;
     * ComponentVariantProperty componentVariantProperty = ComponentVariantProperty.builder()
     *         .overrides(overrides)
     *         .variantValues(Map.of(
     *                 "variantValuesKey", "variantValues"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentvariant.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentvariant.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentVariantProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentVariantProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentVariantProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The properties of the component variant that can be overriden when customizing an instance of the component.
         * <p>
         * You can't specify <code>tags</code> as a valid property for <code>overrides</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentvariant.html#cfn-amplifyuibuilder-component-componentvariant-overrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentvariant.html#cfn-amplifyuibuilder-component-componentvariant-overrides</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOverrides() {
            return null;
        }

        /**
         * The combination of variants that comprise this variant.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentvariant.html#cfn-amplifyuibuilder-component-componentvariant-variantvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-componentvariant.html#cfn-amplifyuibuilder-component-componentvariant-variantvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVariantValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentVariantProperty> {
            java.lang.Object overrides;
            java.lang.Object variantValues;

            /**
             * Sets the value of {@link ComponentVariantProperty#getOverrides}
             * @param overrides The properties of the component variant that can be overriden when customizing an instance of the component.
             *                  You can't specify <code>tags</code> as a valid property for <code>overrides</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder overrides(java.lang.Object overrides) {
                this.overrides = overrides;
                return this;
            }

            /**
             * Sets the value of {@link ComponentVariantProperty#getVariantValues}
             * @param variantValues The combination of variants that comprise this variant.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variantValues(java.util.Map<java.lang.String, java.lang.String> variantValues) {
                this.variantValues = variantValues;
                return this;
            }

            /**
             * Sets the value of {@link ComponentVariantProperty#getVariantValues}
             * @param variantValues The combination of variants that comprise this variant.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder variantValues(software.amazon.awscdk.IResolvable variantValues) {
                this.variantValues = variantValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentVariantProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentVariantProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentVariantProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentVariantProperty {
            private final java.lang.Object overrides;
            private final java.lang.Object variantValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.overrides = software.amazon.jsii.Kernel.get(this, "overrides", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.variantValues = software.amazon.jsii.Kernel.get(this, "variantValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.overrides = builder.overrides;
                this.variantValues = builder.variantValues;
            }

            @Override
            public final java.lang.Object getOverrides() {
                return this.overrides;
            }

            @Override
            public final java.lang.Object getVariantValues() {
                return this.variantValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOverrides() != null) {
                    data.set("overrides", om.valueToTree(this.getOverrides()));
                }
                if (this.getVariantValues() != null) {
                    data.set("variantValues", om.valueToTree(this.getVariantValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.ComponentVariantProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentVariantProperty.Jsii$Proxy that = (ComponentVariantProperty.Jsii$Proxy) o;

                if (this.overrides != null ? !this.overrides.equals(that.overrides) : that.overrides != null) return false;
                return this.variantValues != null ? this.variantValues.equals(that.variantValues) : that.variantValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.overrides != null ? this.overrides.hashCode() : 0;
                result = 31 * result + (this.variantValues != null ? this.variantValues.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Describes how to bind a component property to form data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * FormBindingElementProperty formBindingElementProperty = FormBindingElementProperty.builder()
     *         .element("element")
     *         .property("property")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-formbindingelement.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-formbindingelement.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.FormBindingElementProperty")
    @software.amazon.jsii.Jsii.Proxy(FormBindingElementProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FormBindingElementProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the component to retrieve a value from.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-formbindingelement.html#cfn-amplifyuibuilder-component-formbindingelement-element">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-formbindingelement.html#cfn-amplifyuibuilder-component-formbindingelement-element</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getElement();

        /**
         * The property to retrieve a value from.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-formbindingelement.html#cfn-amplifyuibuilder-component-formbindingelement-property">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-formbindingelement.html#cfn-amplifyuibuilder-component-formbindingelement-property</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProperty();

        /**
         * @return a {@link Builder} of {@link FormBindingElementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FormBindingElementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FormBindingElementProperty> {
            java.lang.String element;
            java.lang.String property;

            /**
             * Sets the value of {@link FormBindingElementProperty#getElement}
             * @param element The name of the component to retrieve a value from. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder element(java.lang.String element) {
                this.element = element;
                return this;
            }

            /**
             * Sets the value of {@link FormBindingElementProperty#getProperty}
             * @param property The property to retrieve a value from. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder property(java.lang.String property) {
                this.property = property;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FormBindingElementProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FormBindingElementProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FormBindingElementProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FormBindingElementProperty {
            private final java.lang.String element;
            private final java.lang.String property;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.element = software.amazon.jsii.Kernel.get(this, "element", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.property = software.amazon.jsii.Kernel.get(this, "property", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.element = java.util.Objects.requireNonNull(builder.element, "element is required");
                this.property = java.util.Objects.requireNonNull(builder.property, "property is required");
            }

            @Override
            public final java.lang.String getElement() {
                return this.element;
            }

            @Override
            public final java.lang.String getProperty() {
                return this.property;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("element", om.valueToTree(this.getElement()));
                data.set("property", om.valueToTree(this.getProperty()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.FormBindingElementProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FormBindingElementProperty.Jsii$Proxy that = (FormBindingElementProperty.Jsii$Proxy) o;

                if (!element.equals(that.element)) return false;
                return this.property.equals(that.property);
            }

            @Override
            public final int hashCode() {
                int result = this.element.hashCode();
                result = 31 * result + (this.property.hashCode());
                return result;
            }
        }
    }
    /**
     * Represents the state configuration when an action modifies a property of another element within the same component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * ComponentPropertyProperty componentPropertyProperty_;
     * MutationActionSetStateParameterProperty mutationActionSetStateParameterProperty = MutationActionSetStateParameterProperty.builder()
     *         .componentName("componentName")
     *         .property("property")
     *         .set(ComponentPropertyProperty.builder()
     *                 .bindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .bindings(Map.of(
     *                         "bindingsKey", FormBindingElementProperty.builder()
     *                                 .element("element")
     *                                 .property("property")
     *                                 .build()))
     *                 .collectionBindingProperties(ComponentPropertyBindingPropertiesProperty.builder()
     *                         .property("property")
     *                         // the properties below are optional
     *                         .field("field")
     *                         .build())
     *                 .componentName("componentName")
     *                 .concat(List.of(componentPropertyProperty_))
     *                 .condition(ComponentConditionPropertyProperty.builder()
     *                         .else(componentPropertyProperty_)
     *                         .field("field")
     *                         .operand("operand")
     *                         .operandType("operandType")
     *                         .operator("operator")
     *                         .property("property")
     *                         .then(componentPropertyProperty_)
     *                         .build())
     *                 .configured(false)
     *                 .defaultValue("defaultValue")
     *                 .event("event")
     *                 .importedValue("importedValue")
     *                 .model("model")
     *                 .property("property")
     *                 .type("type")
     *                 .userAttribute("userAttribute")
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-mutationactionsetstateparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-mutationactionsetstateparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.MutationActionSetStateParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(MutationActionSetStateParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MutationActionSetStateParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the component that is being modified.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-mutationactionsetstateparameter.html#cfn-amplifyuibuilder-component-mutationactionsetstateparameter-componentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-mutationactionsetstateparameter.html#cfn-amplifyuibuilder-component-mutationactionsetstateparameter-componentname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getComponentName();

        /**
         * The name of the component property to apply the state configuration to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-mutationactionsetstateparameter.html#cfn-amplifyuibuilder-component-mutationactionsetstateparameter-property">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-mutationactionsetstateparameter.html#cfn-amplifyuibuilder-component-mutationactionsetstateparameter-property</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProperty();

        /**
         * The state configuration to assign to the property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-mutationactionsetstateparameter.html#cfn-amplifyuibuilder-component-mutationactionsetstateparameter-set">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-mutationactionsetstateparameter.html#cfn-amplifyuibuilder-component-mutationactionsetstateparameter-set</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSet();

        /**
         * @return a {@link Builder} of {@link MutationActionSetStateParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MutationActionSetStateParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MutationActionSetStateParameterProperty> {
            java.lang.String componentName;
            java.lang.String property;
            java.lang.Object set;

            /**
             * Sets the value of {@link MutationActionSetStateParameterProperty#getComponentName}
             * @param componentName The name of the component that is being modified. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentName(java.lang.String componentName) {
                this.componentName = componentName;
                return this;
            }

            /**
             * Sets the value of {@link MutationActionSetStateParameterProperty#getProperty}
             * @param property The name of the component property to apply the state configuration to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder property(java.lang.String property) {
                this.property = property;
                return this;
            }

            /**
             * Sets the value of {@link MutationActionSetStateParameterProperty#getSet}
             * @param set The state configuration to assign to the property. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder set(software.amazon.awscdk.IResolvable set) {
                this.set = set;
                return this;
            }

            /**
             * Sets the value of {@link MutationActionSetStateParameterProperty#getSet}
             * @param set The state configuration to assign to the property. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder set(software.amazon.awscdk.services.amplifyuibuilder.CfnComponent.ComponentPropertyProperty set) {
                this.set = set;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MutationActionSetStateParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MutationActionSetStateParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MutationActionSetStateParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MutationActionSetStateParameterProperty {
            private final java.lang.String componentName;
            private final java.lang.String property;
            private final java.lang.Object set;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.componentName = software.amazon.jsii.Kernel.get(this, "componentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.property = software.amazon.jsii.Kernel.get(this, "property", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.set = software.amazon.jsii.Kernel.get(this, "set", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.componentName = java.util.Objects.requireNonNull(builder.componentName, "componentName is required");
                this.property = java.util.Objects.requireNonNull(builder.property, "property is required");
                this.set = java.util.Objects.requireNonNull(builder.set, "set is required");
            }

            @Override
            public final java.lang.String getComponentName() {
                return this.componentName;
            }

            @Override
            public final java.lang.String getProperty() {
                return this.property;
            }

            @Override
            public final java.lang.Object getSet() {
                return this.set;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("componentName", om.valueToTree(this.getComponentName()));
                data.set("property", om.valueToTree(this.getProperty()));
                data.set("set", om.valueToTree(this.getSet()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.MutationActionSetStateParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MutationActionSetStateParameterProperty.Jsii$Proxy that = (MutationActionSetStateParameterProperty.Jsii$Proxy) o;

                if (!componentName.equals(that.componentName)) return false;
                if (!property.equals(that.property)) return false;
                return this.set.equals(that.set);
            }

            @Override
            public final int hashCode() {
                int result = this.componentName.hashCode();
                result = 31 * result + (this.property.hashCode());
                result = 31 * result + (this.set.hashCode());
                return result;
            }
        }
    }
    /**
     * The <code>Predicate</code> property specifies information for generating Amplify DataStore queries.
     * <p>
     * Use <code>Predicate</code> to retrieve a subset of the data in a collection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * PredicateProperty predicateProperty_;
     * PredicateProperty predicateProperty = PredicateProperty.builder()
     *         .and(List.of(predicateProperty_))
     *         .field("field")
     *         .operand("operand")
     *         .operandType("operandType")
     *         .operator("operator")
     *         .or(List.of(predicateProperty_))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-predicate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-predicate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.PredicateProperty")
    @software.amazon.jsii.Jsii.Proxy(PredicateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PredicateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of predicates to combine logically.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-predicate.html#cfn-amplifyuibuilder-component-predicate-and">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-predicate.html#cfn-amplifyuibuilder-component-predicate-and</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnd() {
            return null;
        }

        /**
         * The field to query.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-predicate.html#cfn-amplifyuibuilder-component-predicate-field">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-predicate.html#cfn-amplifyuibuilder-component-predicate-field</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getField() {
            return null;
        }

        /**
         * The value to use when performing the evaluation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-predicate.html#cfn-amplifyuibuilder-component-predicate-operand">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-predicate.html#cfn-amplifyuibuilder-component-predicate-operand</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOperand() {
            return null;
        }

        /**
         * The type of value to use when performing the evaluation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-predicate.html#cfn-amplifyuibuilder-component-predicate-operandtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-predicate.html#cfn-amplifyuibuilder-component-predicate-operandtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOperandType() {
            return null;
        }

        /**
         * The operator to use to perform the evaluation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-predicate.html#cfn-amplifyuibuilder-component-predicate-operator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-predicate.html#cfn-amplifyuibuilder-component-predicate-operator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOperator() {
            return null;
        }

        /**
         * A list of predicates to combine logically.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-predicate.html#cfn-amplifyuibuilder-component-predicate-or">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-predicate.html#cfn-amplifyuibuilder-component-predicate-or</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOr() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PredicateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PredicateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PredicateProperty> {
            java.lang.Object and;
            java.lang.String field;
            java.lang.String operand;
            java.lang.String operandType;
            java.lang.String operator;
            java.lang.Object or;

            /**
             * Sets the value of {@link PredicateProperty#getAnd}
             * @param and A list of predicates to combine logically.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder and(software.amazon.awscdk.IResolvable and) {
                this.and = and;
                return this;
            }

            /**
             * Sets the value of {@link PredicateProperty#getAnd}
             * @param and A list of predicates to combine logically.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder and(java.util.List<? extends java.lang.Object> and) {
                this.and = and;
                return this;
            }

            /**
             * Sets the value of {@link PredicateProperty#getField}
             * @param field The field to query.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder field(java.lang.String field) {
                this.field = field;
                return this;
            }

            /**
             * Sets the value of {@link PredicateProperty#getOperand}
             * @param operand The value to use when performing the evaluation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operand(java.lang.String operand) {
                this.operand = operand;
                return this;
            }

            /**
             * Sets the value of {@link PredicateProperty#getOperandType}
             * @param operandType The type of value to use when performing the evaluation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operandType(java.lang.String operandType) {
                this.operandType = operandType;
                return this;
            }

            /**
             * Sets the value of {@link PredicateProperty#getOperator}
             * @param operator The operator to use to perform the evaluation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder operator(java.lang.String operator) {
                this.operator = operator;
                return this;
            }

            /**
             * Sets the value of {@link PredicateProperty#getOr}
             * @param or A list of predicates to combine logically.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder or(software.amazon.awscdk.IResolvable or) {
                this.or = or;
                return this;
            }

            /**
             * Sets the value of {@link PredicateProperty#getOr}
             * @param or A list of predicates to combine logically.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder or(java.util.List<? extends java.lang.Object> or) {
                this.or = or;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PredicateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PredicateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PredicateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PredicateProperty {
            private final java.lang.Object and;
            private final java.lang.String field;
            private final java.lang.String operand;
            private final java.lang.String operandType;
            private final java.lang.String operator;
            private final java.lang.Object or;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.and = software.amazon.jsii.Kernel.get(this, "and", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.field = software.amazon.jsii.Kernel.get(this, "field", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.operand = software.amazon.jsii.Kernel.get(this, "operand", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.operandType = software.amazon.jsii.Kernel.get(this, "operandType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.operator = software.amazon.jsii.Kernel.get(this, "operator", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.or = software.amazon.jsii.Kernel.get(this, "or", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.and = builder.and;
                this.field = builder.field;
                this.operand = builder.operand;
                this.operandType = builder.operandType;
                this.operator = builder.operator;
                this.or = builder.or;
            }

            @Override
            public final java.lang.Object getAnd() {
                return this.and;
            }

            @Override
            public final java.lang.String getField() {
                return this.field;
            }

            @Override
            public final java.lang.String getOperand() {
                return this.operand;
            }

            @Override
            public final java.lang.String getOperandType() {
                return this.operandType;
            }

            @Override
            public final java.lang.String getOperator() {
                return this.operator;
            }

            @Override
            public final java.lang.Object getOr() {
                return this.or;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnd() != null) {
                    data.set("and", om.valueToTree(this.getAnd()));
                }
                if (this.getField() != null) {
                    data.set("field", om.valueToTree(this.getField()));
                }
                if (this.getOperand() != null) {
                    data.set("operand", om.valueToTree(this.getOperand()));
                }
                if (this.getOperandType() != null) {
                    data.set("operandType", om.valueToTree(this.getOperandType()));
                }
                if (this.getOperator() != null) {
                    data.set("operator", om.valueToTree(this.getOperator()));
                }
                if (this.getOr() != null) {
                    data.set("or", om.valueToTree(this.getOr()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.PredicateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PredicateProperty.Jsii$Proxy that = (PredicateProperty.Jsii$Proxy) o;

                if (this.and != null ? !this.and.equals(that.and) : that.and != null) return false;
                if (this.field != null ? !this.field.equals(that.field) : that.field != null) return false;
                if (this.operand != null ? !this.operand.equals(that.operand) : that.operand != null) return false;
                if (this.operandType != null ? !this.operandType.equals(that.operandType) : that.operandType != null) return false;
                if (this.operator != null ? !this.operator.equals(that.operator) : that.operator != null) return false;
                return this.or != null ? this.or.equals(that.or) : that.or == null;
            }

            @Override
            public final int hashCode() {
                int result = this.and != null ? this.and.hashCode() : 0;
                result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
                result = 31 * result + (this.operand != null ? this.operand.hashCode() : 0);
                result = 31 * result + (this.operandType != null ? this.operandType.hashCode() : 0);
                result = 31 * result + (this.operator != null ? this.operator.hashCode() : 0);
                result = 31 * result + (this.or != null ? this.or.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>SortProperty</code> property specifies how to sort the data that you bind to a component.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.amplifyuibuilder.*;
     * SortPropertyProperty sortPropertyProperty = SortPropertyProperty.builder()
     *         .direction("direction")
     *         .field("field")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-sortproperty.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-sortproperty.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.SortPropertyProperty")
    @software.amazon.jsii.Jsii.Proxy(SortPropertyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SortPropertyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The direction of the sort, either ascending or descending.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-sortproperty.html#cfn-amplifyuibuilder-component-sortproperty-direction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-sortproperty.html#cfn-amplifyuibuilder-component-sortproperty-direction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDirection();

        /**
         * The field to perform the sort on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-sortproperty.html#cfn-amplifyuibuilder-component-sortproperty-field">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplifyuibuilder-component-sortproperty.html#cfn-amplifyuibuilder-component-sortproperty-field</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getField();

        /**
         * @return a {@link Builder} of {@link SortPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SortPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SortPropertyProperty> {
            java.lang.String direction;
            java.lang.String field;

            /**
             * Sets the value of {@link SortPropertyProperty#getDirection}
             * @param direction The direction of the sort, either ascending or descending. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder direction(java.lang.String direction) {
                this.direction = direction;
                return this;
            }

            /**
             * Sets the value of {@link SortPropertyProperty#getField}
             * @param field The field to perform the sort on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder field(java.lang.String field) {
                this.field = field;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SortPropertyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SortPropertyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SortPropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SortPropertyProperty {
            private final java.lang.String direction;
            private final java.lang.String field;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.direction = software.amazon.jsii.Kernel.get(this, "direction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.field = software.amazon.jsii.Kernel.get(this, "field", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.direction = java.util.Objects.requireNonNull(builder.direction, "direction is required");
                this.field = java.util.Objects.requireNonNull(builder.field, "field is required");
            }

            @Override
            public final java.lang.String getDirection() {
                return this.direction;
            }

            @Override
            public final java.lang.String getField() {
                return this.field;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("direction", om.valueToTree(this.getDirection()));
                data.set("field", om.valueToTree(this.getField()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplifyuibuilder.CfnComponent.SortPropertyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SortPropertyProperty.Jsii$Proxy that = (SortPropertyProperty.Jsii$Proxy) o;

                if (!direction.equals(that.direction)) return false;
                return this.field.equals(that.field);
            }

            @Override
            public final int hashCode() {
                int result = this.direction.hashCode();
                result = 31 * result + (this.field.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.amplifyuibuilder.CfnComponent}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.amplifyuibuilder.CfnComponent> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.amplifyuibuilder.CfnComponentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The unique ID of the Amplify app associated with the component.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-appid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-appid</a>
         * @param appId The unique ID of the Amplify app associated with the component. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appId(final java.lang.String appId) {
            this.props().appId(appId);
            return this;
        }

        /**
         * The information to connect a component's properties to data at runtime.
         * <p>
         * You can't specify <code>tags</code> as a valid property for <code>bindingProperties</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-bindingproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-bindingproperties</a>
         * @param bindingProperties The information to connect a component's properties to data at runtime. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bindingProperties(final software.amazon.awscdk.IResolvable bindingProperties) {
            this.props().bindingProperties(bindingProperties);
            return this;
        }
        /**
         * The information to connect a component's properties to data at runtime.
         * <p>
         * You can't specify <code>tags</code> as a valid property for <code>bindingProperties</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-bindingproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-bindingproperties</a>
         * @param bindingProperties The information to connect a component's properties to data at runtime. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bindingProperties(final java.util.Map<java.lang.String, ? extends java.lang.Object> bindingProperties) {
            this.props().bindingProperties(bindingProperties);
            return this;
        }

        /**
         * A list of the component's <code>ComponentChild</code> instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-children">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-children</a>
         * @param children A list of the component's <code>ComponentChild</code> instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder children(final software.amazon.awscdk.IResolvable children) {
            this.props().children(children);
            return this;
        }
        /**
         * A list of the component's <code>ComponentChild</code> instances.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-children">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-children</a>
         * @param children A list of the component's <code>ComponentChild</code> instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder children(final java.util.List<? extends java.lang.Object> children) {
            this.props().children(children);
            return this;
        }

        /**
         * The data binding configuration for the component's properties.
         * <p>
         * Use this for a collection component. You can't specify <code>tags</code> as a valid property for <code>collectionProperties</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-collectionproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-collectionproperties</a>
         * @param collectionProperties The data binding configuration for the component's properties. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionProperties(final software.amazon.awscdk.IResolvable collectionProperties) {
            this.props().collectionProperties(collectionProperties);
            return this;
        }
        /**
         * The data binding configuration for the component's properties.
         * <p>
         * Use this for a collection component. You can't specify <code>tags</code> as a valid property for <code>collectionProperties</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-collectionproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-collectionproperties</a>
         * @param collectionProperties The data binding configuration for the component's properties. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionProperties(final java.util.Map<java.lang.String, ? extends java.lang.Object> collectionProperties) {
            this.props().collectionProperties(collectionProperties);
            return this;
        }

        /**
         * The type of the component.
         * <p>
         * This can be an Amplify custom UI component or another custom component.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-componenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-componenttype</a>
         * @param componentType The type of the component. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder componentType(final java.lang.String componentType) {
            this.props().componentType(componentType);
            return this;
        }

        /**
         * The name of the backend environment that is a part of the Amplify app.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-environmentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-environmentname</a>
         * @param environmentName The name of the backend environment that is a part of the Amplify app. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentName(final java.lang.String environmentName) {
            this.props().environmentName(environmentName);
            return this;
        }

        /**
         * Describes the events that can be raised on the component.
         * <p>
         * Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-events">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-events</a>
         * @param events Describes the events that can be raised on the component. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(final software.amazon.awscdk.IResolvable events) {
            this.props().events(events);
            return this;
        }
        /**
         * Describes the events that can be raised on the component.
         * <p>
         * Use for the workflow feature in Amplify Studio that allows you to bind events and actions to components.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-events">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-events</a>
         * @param events Describes the events that can be raised on the component. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder events(final java.util.Map<java.lang.String, ? extends java.lang.Object> events) {
            this.props().events(events);
            return this;
        }

        /**
         * The name of the component.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-name</a>
         * @param name The name of the component. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props().name(name);
            return this;
        }

        /**
         * Describes the component's properties that can be overriden in a customized instance of the component.
         * <p>
         * You can't specify <code>tags</code> as a valid property for <code>overrides</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-overrides">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-overrides</a>
         * @param overrides Describes the component's properties that can be overriden in a customized instance of the component. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder overrides(final java.lang.Object overrides) {
            this.props().overrides(overrides);
            return this;
        }

        /**
         * Describes the component's properties.
         * <p>
         * You can't specify <code>tags</code> as a valid property for <code>properties</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-properties</a>
         * @param properties Describes the component's properties. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(final software.amazon.awscdk.IResolvable properties) {
            this.props().properties(properties);
            return this;
        }
        /**
         * Describes the component's properties.
         * <p>
         * You can't specify <code>tags</code> as a valid property for <code>properties</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-properties</a>
         * @param properties Describes the component's properties. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder properties(final java.util.Map<java.lang.String, ? extends java.lang.Object> properties) {
            this.props().properties(properties);
            return this;
        }

        /**
         * The schema version of the component when it was imported.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-schemaversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-schemaversion</a>
         * @param schemaVersion The schema version of the component when it was imported. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaVersion(final java.lang.String schemaVersion) {
            this.props().schemaVersion(schemaVersion);
            return this;
        }

        /**
         * The unique ID of the component in its original source system, such as Figma.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-sourceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-sourceid</a>
         * @param sourceId The unique ID of the component in its original source system, such as Figma. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceId(final java.lang.String sourceId) {
            this.props().sourceId(sourceId);
            return this;
        }

        /**
         * One or more key-value pairs to use when tagging the component.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-tags</a>
         * @param tags One or more key-value pairs to use when tagging the component. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * A list of the component's variants.
         * <p>
         * A variant is a unique style configuration of a main component.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-variants">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-variants</a>
         * @param variants A list of the component's variants. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variants(final software.amazon.awscdk.IResolvable variants) {
            this.props().variants(variants);
            return this;
        }
        /**
         * A list of the component's variants.
         * <p>
         * A variant is a unique style configuration of a main component.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-variants">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplifyuibuilder-component.html#cfn-amplifyuibuilder-component-variants</a>
         * @param variants A list of the component's variants. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variants(final java.util.List<? extends java.lang.Object> variants) {
            this.props().variants(variants);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.amplifyuibuilder.CfnComponent}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.amplifyuibuilder.CfnComponent build() {
            return new software.amazon.awscdk.services.amplifyuibuilder.CfnComponent(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.amplifyuibuilder.CfnComponentProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.amplifyuibuilder.CfnComponentProps.Builder();
            }
            return this.props;
        }
    }
}
