package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * Object acmCertificateForExampleCom;
 * RestApi restApi;
 * DomainName.Builder.create(this, "custom-domain")
 *         .domainName("example.com")
 *         .certificate(acmCertificateForExampleCom)
 *         .mapping(restApi)
 *         .basePath("orders/v1/api")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:10.366Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.DomainNameProps")
@software.amazon.jsii.Jsii.Proxy(DomainNameProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DomainNameProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.DomainNameOptions {

    /**
     * If specified, all requests to this domain will be mapped to the production deployment of this API.
     * <p>
     * If you wish to map this domain to multiple APIs
     * with different base paths, use <code>addBasePathMapping</code> or <code>addApiMapping</code>.
     * <p>
     * Default: - you will have to call `addBasePathMapping` to map this domain to
     * API endpoints.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.IRestApi getMapping() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DomainNameProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DomainNameProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DomainNameProps> {
        software.amazon.awscdk.services.apigateway.IRestApi mapping;
        software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        java.lang.String domainName;
        java.lang.String basePath;
        software.amazon.awscdk.services.apigateway.EndpointType endpointType;
        software.amazon.awscdk.services.apigateway.MTLSConfig mtls;
        software.amazon.awscdk.services.apigateway.SecurityPolicy securityPolicy;

        /**
         * Sets the value of {@link DomainNameProps#getMapping}
         * @param mapping If specified, all requests to this domain will be mapped to the production deployment of this API.
         *                If you wish to map this domain to multiple APIs
         *                with different base paths, use <code>addBasePathMapping</code> or <code>addApiMapping</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapping(software.amazon.awscdk.services.apigateway.IRestApi mapping) {
            this.mapping = mapping;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameProps#getCertificate}
         * @param certificate The reference to an AWS-managed certificate for use by the edge-optimized endpoint for the domain name. This parameter is required.
         *                    For "EDGE" domain names, the certificate
         *                    needs to be in the US East (N. Virginia) region.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameProps#getDomainName}
         * @param domainName The custom domain name for your API. This parameter is required.
         *                   Uppercase letters are not supported.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameProps#getBasePath}
         * @param basePath The base path name that callers of the API must provide in the URL after the domain name (e.g. <code>example.com/base-path</code>). If you specify this property, it can't be an empty string.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder basePath(java.lang.String basePath) {
            this.basePath = basePath;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameProps#getEndpointType}
         * @param endpointType The type of endpoint for this DomainName.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointType(software.amazon.awscdk.services.apigateway.EndpointType endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameProps#getMtls}
         * @param mtls The mutual TLS authentication configuration for a custom domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mtls(software.amazon.awscdk.services.apigateway.MTLSConfig mtls) {
            this.mtls = mtls;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameProps#getSecurityPolicy}
         * @param securityPolicy The Transport Layer Security (TLS) version + cipher suite for this domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityPolicy(software.amazon.awscdk.services.apigateway.SecurityPolicy securityPolicy) {
            this.securityPolicy = securityPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DomainNameProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DomainNameProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DomainNameProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainNameProps {
        private final software.amazon.awscdk.services.apigateway.IRestApi mapping;
        private final software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private final java.lang.String domainName;
        private final java.lang.String basePath;
        private final software.amazon.awscdk.services.apigateway.EndpointType endpointType;
        private final software.amazon.awscdk.services.apigateway.MTLSConfig mtls;
        private final software.amazon.awscdk.services.apigateway.SecurityPolicy securityPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mapping = software.amazon.jsii.Kernel.get(this, "mapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IRestApi.class));
            this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.ICertificate.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.basePath = software.amazon.jsii.Kernel.get(this, "basePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.endpointType = software.amazon.jsii.Kernel.get(this, "endpointType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.EndpointType.class));
            this.mtls = software.amazon.jsii.Kernel.get(this, "mtls", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.MTLSConfig.class));
            this.securityPolicy = software.amazon.jsii.Kernel.get(this, "securityPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.SecurityPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mapping = builder.mapping;
            this.certificate = java.util.Objects.requireNonNull(builder.certificate, "certificate is required");
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.basePath = builder.basePath;
            this.endpointType = builder.endpointType;
            this.mtls = builder.mtls;
            this.securityPolicy = builder.securityPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.IRestApi getMapping() {
            return this.mapping;
        }

        @Override
        public final software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
            return this.certificate;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.String getBasePath() {
            return this.basePath;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.EndpointType getEndpointType() {
            return this.endpointType;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.MTLSConfig getMtls() {
            return this.mtls;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.SecurityPolicy getSecurityPolicy() {
            return this.securityPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMapping() != null) {
                data.set("mapping", om.valueToTree(this.getMapping()));
            }
            data.set("certificate", om.valueToTree(this.getCertificate()));
            data.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getBasePath() != null) {
                data.set("basePath", om.valueToTree(this.getBasePath()));
            }
            if (this.getEndpointType() != null) {
                data.set("endpointType", om.valueToTree(this.getEndpointType()));
            }
            if (this.getMtls() != null) {
                data.set("mtls", om.valueToTree(this.getMtls()));
            }
            if (this.getSecurityPolicy() != null) {
                data.set("securityPolicy", om.valueToTree(this.getSecurityPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.DomainNameProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DomainNameProps.Jsii$Proxy that = (DomainNameProps.Jsii$Proxy) o;

            if (this.mapping != null ? !this.mapping.equals(that.mapping) : that.mapping != null) return false;
            if (!certificate.equals(that.certificate)) return false;
            if (!domainName.equals(that.domainName)) return false;
            if (this.basePath != null ? !this.basePath.equals(that.basePath) : that.basePath != null) return false;
            if (this.endpointType != null ? !this.endpointType.equals(that.endpointType) : that.endpointType != null) return false;
            if (this.mtls != null ? !this.mtls.equals(that.mtls) : that.mtls != null) return false;
            return this.securityPolicy != null ? this.securityPolicy.equals(that.securityPolicy) : that.securityPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.mapping != null ? this.mapping.hashCode() : 0;
            result = 31 * result + (this.certificate.hashCode());
            result = 31 * result + (this.domainName.hashCode());
            result = 31 * result + (this.basePath != null ? this.basePath.hashCode() : 0);
            result = 31 * result + (this.endpointType != null ? this.endpointType.hashCode() : 0);
            result = 31 * result + (this.mtls != null ? this.mtls.hashCode() : 0);
            result = 31 * result + (this.securityPolicy != null ? this.securityPolicy.hashCode() : 0);
            return result;
        }
    }
}
