package software.amazon.awscdk.services.apigatewayv2;

/**
 * Create a new API Gateway HTTP API endpoint.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpLambdaIntegration;
 * Function booksDefaultFn;
 * HttpLambdaIntegration booksIntegration = new HttpLambdaIntegration("BooksIntegration", booksDefaultFn);
 * HttpApi httpApi = new HttpApi(this, "HttpApi");
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/books")
 *         .methods(List.of(HttpMethod.GET))
 *         .integration(booksIntegration)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:10.577Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.HttpApi")
public class HttpApi extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.apigatewayv2.IHttpApi, software.amazon.awscdk.services.apigatewayv2.IApi {

    protected HttpApi(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpApi(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigatewayv2.HttpApi.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.HttpApiProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpApi(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import an existing HTTP API into this CDK app.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IHttpApi fromHttpApiAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpApiAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigatewayv2.HttpApi.class, "fromHttpApiAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IHttpApi.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Add multiple routes that uses the same configuration.
     * <p>
     * The routes all go to the same path, but for different
     * methods.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.apigatewayv2.HttpRoute> addRoutes(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.AddRoutesOptions options) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "addRoutes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRoute.class)), new Object[] { java.util.Objects.requireNonNull(options, "options is required") }));
    }

    /**
     * Add a new stage.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpStage addStage(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpStageOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpStage.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Add a new VpcLink.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.VpcLink addVpcLink(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.VpcLinkProps options) {
        return software.amazon.jsii.Kernel.call(this, "addVpcLink", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.VpcLink.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Get the "execute-api" ARN.
     * <p>
     * When 'ANY' is passed to the method, an ARN with the method set to '*' is obtained.
     * <p>
     * @param method
     * @param path
     * @param stage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method, final @org.jetbrains.annotations.Nullable java.lang.String path, final @org.jetbrains.annotations.Nullable java.lang.String stage) {
        return software.amazon.jsii.Kernel.call(this, "arnForExecuteApi", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { method, path, stage });
    }

    /**
     * Get the "execute-api" ARN.
     * <p>
     * When 'ANY' is passed to the method, an ARN with the method set to '*' is obtained.
     * <p>
     * @param method
     * @param path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method, final @org.jetbrains.annotations.Nullable java.lang.String path) {
        return software.amazon.jsii.Kernel.call(this, "arnForExecuteApi", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { method, path });
    }

    /**
     * Get the "execute-api" ARN.
     * <p>
     * When 'ANY' is passed to the method, an ARN with the method set to '*' is obtained.
     * <p>
     * @param method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi(final @org.jetbrains.annotations.Nullable java.lang.String method) {
        return software.amazon.jsii.Kernel.call(this, "arnForExecuteApi", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { method });
    }

    /**
     * Get the "execute-api" ARN.
     * <p>
     * When 'ANY' is passed to the method, an ARN with the method set to '*' is obtained.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.lang.String arnForExecuteApi() {
        return software.amazon.jsii.Kernel.call(this, "arnForExecuteApi", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return the given named metric for this Api Gateway.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this Api Gateway.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Metric for the number of client-side errors captured in a given period.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClientError(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricClientError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the number of client-side errors captured in a given period.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricClientError() {
        return software.amazon.jsii.Kernel.call(this, "metricClientError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the total number API requests in a given period.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCount(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the total number API requests in a given period.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCount() {
        return software.amazon.jsii.Kernel.call(this, "metricCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the amount of data processed in bytes.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDataProcessed(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricDataProcessed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the amount of data processed in bytes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDataProcessed() {
        return software.amazon.jsii.Kernel.call(this, "metricDataProcessed", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the time between when API Gateway relays a request to the backend and when it receives a response from the backend.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIntegrationLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricIntegrationLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the time between when API Gateway relays a request to the backend and when it receives a response from the backend.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricIntegrationLatency() {
        return software.amazon.jsii.Kernel.call(this, "metricIntegrationLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * The time between when API Gateway receives a request from a client and when it returns a response to the client.
     * <p>
     * The latency includes the integration latency and other API Gateway overhead.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLatency(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * The time between when API Gateway receives a request from a client and when it returns a response to the client.
     * <p>
     * The latency includes the integration latency and other API Gateway overhead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricLatency() {
        return software.amazon.jsii.Kernel.call(this, "metricLatency", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Metric for the number of server-side errors captured in a given period.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricServerError(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricServerError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * Metric for the number of server-side errors captured in a given period.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricServerError() {
        return software.amazon.jsii.Kernel.call(this, "metricServerError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * Get the default endpoint for this API.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "apiEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of this API Gateway API.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getApiId() {
        return software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the HTTP API.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#aws-resource-apigatewayv2-api-return-values">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-api.html#aws-resource-apigatewayv2-api-return-values</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getHttpApiId() {
        return software.amazon.jsii.Kernel.get(this, "httpApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Default OIDC scopes attached to all routes in the gateway, unless explicitly configured on the route.
     * <p>
     * The scopes are used with a COGNITO_USER_POOLS authorizer to authorize the method invocation.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDefaultAuthorizationScopes() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "defaultAuthorizationScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Default Authorizer applied to all routes in the gateway.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer getDefaultAuthorizer() {
        return software.amazon.jsii.Kernel.get(this, "defaultAuthorizer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer.class));
    }

    /**
     * The default stage of this API.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.IHttpStage getDefaultStage() {
        return software.amazon.jsii.Kernel.get(this, "defaultStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IHttpStage.class));
    }

    /**
     * Specifies whether clients can invoke this HTTP API by using the default execute-api endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getDisableExecuteApiEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "disableExecuteApiEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A human friendly name for this HTTP API.
     * <p>
     * Note that this is different from <code>httpApiId</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHttpApiName() {
        return software.amazon.jsii.Kernel.get(this, "httpApiName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Get the URL to the default stage of this API.
     * <p>
     * Returns <code>undefined</code> if <code>createDefaultStage</code> is unset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
        return software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigatewayv2.HttpApi}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigatewayv2.HttpApi> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.apigatewayv2.HttpApiProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Name for the HTTP API resource.
         * <p>
         * Default: - id of the HttpApi construct.
         * <p>
         * @return {@code this}
         * @param apiName Name for the HTTP API resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiName(final java.lang.String apiName) {
            this.props().apiName(apiName);
            return this;
        }

        /**
         * Specifies a CORS configuration for an API.
         * <p>
         * Default: - CORS disabled.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html</a>
         * @param corsPreflight Specifies a CORS configuration for an API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder corsPreflight(final software.amazon.awscdk.services.apigatewayv2.CorsPreflightOptions corsPreflight) {
            this.props().corsPreflight(corsPreflight);
            return this;
        }

        /**
         * Whether a default stage and deployment should be automatically created.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param createDefaultStage Whether a default stage and deployment should be automatically created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder createDefaultStage(final java.lang.Boolean createDefaultStage) {
            this.props().createDefaultStage(createDefaultStage);
            return this;
        }

        /**
         * Default OIDC scopes attached to all routes in the gateway, unless explicitly configured on the route.
         * <p>
         * The scopes are used with a COGNITO_USER_POOLS authorizer to authorize the method invocation.
         * <p>
         * Default: - no default authorization scopes
         * <p>
         * @return {@code this}
         * @param defaultAuthorizationScopes Default OIDC scopes attached to all routes in the gateway, unless explicitly configured on the route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAuthorizationScopes(final java.util.List<java.lang.String> defaultAuthorizationScopes) {
            this.props().defaultAuthorizationScopes(defaultAuthorizationScopes);
            return this;
        }

        /**
         * Default Authorizer applied to all routes in the gateway.
         * <p>
         * Default: - no default authorizer
         * <p>
         * @return {@code this}
         * @param defaultAuthorizer Default Authorizer applied to all routes in the gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAuthorizer(final software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer defaultAuthorizer) {
            this.props().defaultAuthorizer(defaultAuthorizer);
            return this;
        }

        /**
         * Configure a custom domain with the API mapping resource to the HTTP API.
         * <p>
         * Default: - no default domain mapping configured. meaningless if `createDefaultStage` is `false`.
         * <p>
         * @return {@code this}
         * @param defaultDomainMapping Configure a custom domain with the API mapping resource to the HTTP API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultDomainMapping(final software.amazon.awscdk.services.apigatewayv2.DomainMappingOptions defaultDomainMapping) {
            this.props().defaultDomainMapping(defaultDomainMapping);
            return this;
        }

        /**
         * An integration that will be configured on the catch-all route ($default).
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param defaultIntegration An integration that will be configured on the catch-all route ($default). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIntegration(final software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration defaultIntegration) {
            this.props().defaultIntegration(defaultIntegration);
            return this;
        }

        /**
         * The description of the API.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param description The description of the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * Specifies whether clients can invoke your API using the default endpoint.
         * <p>
         * By default, clients can invoke your API with the default
         * <code>https://{api_id}.execute-api.{region}.amazonaws.com</code> endpoint. Set this to
         * true if you would like clients to use your custom domain name.
         * <p>
         * Default: false execute-api endpoint enabled.
         * <p>
         * @return {@code this}
         * @param disableExecuteApiEndpoint Specifies whether clients can invoke your API using the default endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableExecuteApiEndpoint(final java.lang.Boolean disableExecuteApiEndpoint) {
            this.props().disableExecuteApiEndpoint(disableExecuteApiEndpoint);
            return this;
        }

        /**
         * The IP address types that can invoke the API.
         * <p>
         * Default: undefined - AWS default is IPV4
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-ip-address-type.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-ip-address-type.html</a>
         * @param ipAddressType The IP address types that can invoke the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(final software.amazon.awscdk.services.apigatewayv2.IpAddressType ipAddressType) {
            this.props().ipAddressType(ipAddressType);
            return this;
        }

        /**
         * Whether to set the default route selection expression for the API.
         * <p>
         * When enabled, "${request.method} ${request.path}" is set as the default route selection expression.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param routeSelectionExpression Whether to set the default route selection expression for the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeSelectionExpression(final java.lang.Boolean routeSelectionExpression) {
            this.props().routeSelectionExpression(routeSelectionExpression);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigatewayv2.HttpApi}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigatewayv2.HttpApi build() {
            return new software.amazon.awscdk.services.apigatewayv2.HttpApi(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigatewayv2.HttpApiProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigatewayv2.HttpApiProps.Builder();
            }
            return this.props;
        }
    }
}
