package software.amazon.awscdk.services.apigatewayv2;

/**
 * The integration properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * import software.amazon.awscdk.services.iam.*;
 * Role role;
 * WebSocketApi webSocketApi;
 * WebSocketIntegrationProps webSocketIntegrationProps = WebSocketIntegrationProps.builder()
 *         .integrationType(WebSocketIntegrationType.AWS_PROXY)
 *         .integrationUri("integrationUri")
 *         .webSocketApi(webSocketApi)
 *         // the properties below are optional
 *         .contentHandling(ContentHandling.CONVERT_TO_BINARY)
 *         .credentialsRole(role)
 *         .integrationMethod("integrationMethod")
 *         .passthroughBehavior(PassthroughBehavior.WHEN_NO_MATCH)
 *         .requestParameters(Map.of(
 *                 "requestParametersKey", "requestParameters"))
 *         .requestTemplates(Map.of(
 *                 "requestTemplatesKey", "requestTemplates"))
 *         .templateSelectionExpression("templateSelectionExpression")
 *         .timeout(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:10.635Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.WebSocketIntegrationProps")
@software.amazon.jsii.Jsii.Proxy(WebSocketIntegrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WebSocketIntegrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Integration type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationType getIntegrationType();

    /**
     * Integration URI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getIntegrationUri();

    /**
     * The WebSocket API to which this integration should be bound.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IWebSocketApi getWebSocketApi();

    /**
     * Specifies how to handle response payload content type conversions.
     * <p>
     * Default: - The response payload will be passed through from the integration response to
     * the route response or method response without modification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.ContentHandling getContentHandling() {
        return null;
    }

    /**
     * Specifies the IAM role required for the integration.
     * <p>
     * Default: - No IAM role required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getCredentialsRole() {
        return null;
    }

    /**
     * Specifies the integration's HTTP method type.
     * <p>
     * Default: - No HTTP method required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIntegrationMethod() {
        return null;
    }

    /**
     * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource.
     * <p>
     * There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
     * NEVER.
     * <p>
     * Default: - No passthrough behavior required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.PassthroughBehavior getPassthroughBehavior() {
        return null;
    }

    /**
     * The request parameters that API Gateway sends with the backend request.
     * <p>
     * Specify request parameters as key-value pairs (string-to-string
     * mappings), with a destination as the key and a source as the value.
     * <p>
     * Default: - No request parameters required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getRequestParameters() {
        return null;
    }

    /**
     * A map of Apache Velocity templates that are applied on the request payload.
     * <p>
     * <blockquote><pre>
     *   { "application/json": "{ \"statusCode\": 200 }" }
     * </pre></blockquote>
     * <p>
     * Default: - No request templates required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getRequestTemplates() {
        return null;
    }

    /**
     * The template selection expression for the integration.
     * <p>
     * Default: - No template selection expression required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTemplateSelectionExpression() {
        return null;
    }

    /**
     * The maximum amount of time an integration will run before it returns without a response.
     * <p>
     * Must be between 50 milliseconds and 29 seconds.
     * <p>
     * Default: Duration.seconds(29)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WebSocketIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebSocketIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WebSocketIntegrationProps> {
        software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationType integrationType;
        java.lang.String integrationUri;
        software.amazon.awscdk.services.apigatewayv2.IWebSocketApi webSocketApi;
        software.amazon.awscdk.services.apigatewayv2.ContentHandling contentHandling;
        software.amazon.awscdk.services.iam.IRole credentialsRole;
        java.lang.String integrationMethod;
        software.amazon.awscdk.services.apigatewayv2.PassthroughBehavior passthroughBehavior;
        java.util.Map<java.lang.String, java.lang.String> requestParameters;
        java.util.Map<java.lang.String, java.lang.String> requestTemplates;
        java.lang.String templateSelectionExpression;
        software.amazon.awscdk.Duration timeout;

        /**
         * Sets the value of {@link WebSocketIntegrationProps#getIntegrationType}
         * @param integrationType Integration type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationType(software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationType integrationType) {
            this.integrationType = integrationType;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketIntegrationProps#getIntegrationUri}
         * @param integrationUri Integration URI. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationUri(java.lang.String integrationUri) {
            this.integrationUri = integrationUri;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketIntegrationProps#getWebSocketApi}
         * @param webSocketApi The WebSocket API to which this integration should be bound. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webSocketApi(software.amazon.awscdk.services.apigatewayv2.IWebSocketApi webSocketApi) {
            this.webSocketApi = webSocketApi;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketIntegrationProps#getContentHandling}
         * @param contentHandling Specifies how to handle response payload content type conversions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentHandling(software.amazon.awscdk.services.apigatewayv2.ContentHandling contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketIntegrationProps#getCredentialsRole}
         * @param credentialsRole Specifies the IAM role required for the integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsRole(software.amazon.awscdk.services.iam.IRole credentialsRole) {
            this.credentialsRole = credentialsRole;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketIntegrationProps#getIntegrationMethod}
         * @param integrationMethod Specifies the integration's HTTP method type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationMethod(java.lang.String integrationMethod) {
            this.integrationMethod = integrationMethod;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketIntegrationProps#getPassthroughBehavior}
         * @param passthroughBehavior Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource.
         *                            There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
         *                            NEVER.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passthroughBehavior(software.amazon.awscdk.services.apigatewayv2.PassthroughBehavior passthroughBehavior) {
            this.passthroughBehavior = passthroughBehavior;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketIntegrationProps#getRequestParameters}
         * @param requestParameters The request parameters that API Gateway sends with the backend request.
         *                          Specify request parameters as key-value pairs (string-to-string
         *                          mappings), with a destination as the key and a source as the value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(java.util.Map<java.lang.String, java.lang.String> requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketIntegrationProps#getRequestTemplates}
         * @param requestTemplates A map of Apache Velocity templates that are applied on the request payload.
         *                         <blockquote><pre>
         *                           { "application/json": "{ \"statusCode\": 200 }" }
         *                         </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestTemplates(java.util.Map<java.lang.String, java.lang.String> requestTemplates) {
            this.requestTemplates = requestTemplates;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketIntegrationProps#getTemplateSelectionExpression}
         * @param templateSelectionExpression The template selection expression for the integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateSelectionExpression(java.lang.String templateSelectionExpression) {
            this.templateSelectionExpression = templateSelectionExpression;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketIntegrationProps#getTimeout}
         * @param timeout The maximum amount of time an integration will run before it returns without a response.
         *                Must be between 50 milliseconds and 29 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebSocketIntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WebSocketIntegrationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebSocketIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebSocketIntegrationProps {
        private final software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationType integrationType;
        private final java.lang.String integrationUri;
        private final software.amazon.awscdk.services.apigatewayv2.IWebSocketApi webSocketApi;
        private final software.amazon.awscdk.services.apigatewayv2.ContentHandling contentHandling;
        private final software.amazon.awscdk.services.iam.IRole credentialsRole;
        private final java.lang.String integrationMethod;
        private final software.amazon.awscdk.services.apigatewayv2.PassthroughBehavior passthroughBehavior;
        private final java.util.Map<java.lang.String, java.lang.String> requestParameters;
        private final java.util.Map<java.lang.String, java.lang.String> requestTemplates;
        private final java.lang.String templateSelectionExpression;
        private final software.amazon.awscdk.Duration timeout;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.integrationType = software.amazon.jsii.Kernel.get(this, "integrationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationType.class));
            this.integrationUri = software.amazon.jsii.Kernel.get(this, "integrationUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.webSocketApi = software.amazon.jsii.Kernel.get(this, "webSocketApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IWebSocketApi.class));
            this.contentHandling = software.amazon.jsii.Kernel.get(this, "contentHandling", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.ContentHandling.class));
            this.credentialsRole = software.amazon.jsii.Kernel.get(this, "credentialsRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.integrationMethod = software.amazon.jsii.Kernel.get(this, "integrationMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.passthroughBehavior = software.amazon.jsii.Kernel.get(this, "passthroughBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.PassthroughBehavior.class));
            this.requestParameters = software.amazon.jsii.Kernel.get(this, "requestParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.requestTemplates = software.amazon.jsii.Kernel.get(this, "requestTemplates", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.templateSelectionExpression = software.amazon.jsii.Kernel.get(this, "templateSelectionExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.integrationType = java.util.Objects.requireNonNull(builder.integrationType, "integrationType is required");
            this.integrationUri = java.util.Objects.requireNonNull(builder.integrationUri, "integrationUri is required");
            this.webSocketApi = java.util.Objects.requireNonNull(builder.webSocketApi, "webSocketApi is required");
            this.contentHandling = builder.contentHandling;
            this.credentialsRole = builder.credentialsRole;
            this.integrationMethod = builder.integrationMethod;
            this.passthroughBehavior = builder.passthroughBehavior;
            this.requestParameters = builder.requestParameters;
            this.requestTemplates = builder.requestTemplates;
            this.templateSelectionExpression = builder.templateSelectionExpression;
            this.timeout = builder.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.WebSocketIntegrationType getIntegrationType() {
            return this.integrationType;
        }

        @Override
        public final java.lang.String getIntegrationUri() {
            return this.integrationUri;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IWebSocketApi getWebSocketApi() {
            return this.webSocketApi;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.ContentHandling getContentHandling() {
            return this.contentHandling;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getCredentialsRole() {
            return this.credentialsRole;
        }

        @Override
        public final java.lang.String getIntegrationMethod() {
            return this.integrationMethod;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.PassthroughBehavior getPassthroughBehavior() {
            return this.passthroughBehavior;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getRequestParameters() {
            return this.requestParameters;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getRequestTemplates() {
            return this.requestTemplates;
        }

        @Override
        public final java.lang.String getTemplateSelectionExpression() {
            return this.templateSelectionExpression;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("integrationType", om.valueToTree(this.getIntegrationType()));
            data.set("integrationUri", om.valueToTree(this.getIntegrationUri()));
            data.set("webSocketApi", om.valueToTree(this.getWebSocketApi()));
            if (this.getContentHandling() != null) {
                data.set("contentHandling", om.valueToTree(this.getContentHandling()));
            }
            if (this.getCredentialsRole() != null) {
                data.set("credentialsRole", om.valueToTree(this.getCredentialsRole()));
            }
            if (this.getIntegrationMethod() != null) {
                data.set("integrationMethod", om.valueToTree(this.getIntegrationMethod()));
            }
            if (this.getPassthroughBehavior() != null) {
                data.set("passthroughBehavior", om.valueToTree(this.getPassthroughBehavior()));
            }
            if (this.getRequestParameters() != null) {
                data.set("requestParameters", om.valueToTree(this.getRequestParameters()));
            }
            if (this.getRequestTemplates() != null) {
                data.set("requestTemplates", om.valueToTree(this.getRequestTemplates()));
            }
            if (this.getTemplateSelectionExpression() != null) {
                data.set("templateSelectionExpression", om.valueToTree(this.getTemplateSelectionExpression()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.WebSocketIntegrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebSocketIntegrationProps.Jsii$Proxy that = (WebSocketIntegrationProps.Jsii$Proxy) o;

            if (!integrationType.equals(that.integrationType)) return false;
            if (!integrationUri.equals(that.integrationUri)) return false;
            if (!webSocketApi.equals(that.webSocketApi)) return false;
            if (this.contentHandling != null ? !this.contentHandling.equals(that.contentHandling) : that.contentHandling != null) return false;
            if (this.credentialsRole != null ? !this.credentialsRole.equals(that.credentialsRole) : that.credentialsRole != null) return false;
            if (this.integrationMethod != null ? !this.integrationMethod.equals(that.integrationMethod) : that.integrationMethod != null) return false;
            if (this.passthroughBehavior != null ? !this.passthroughBehavior.equals(that.passthroughBehavior) : that.passthroughBehavior != null) return false;
            if (this.requestParameters != null ? !this.requestParameters.equals(that.requestParameters) : that.requestParameters != null) return false;
            if (this.requestTemplates != null ? !this.requestTemplates.equals(that.requestTemplates) : that.requestTemplates != null) return false;
            if (this.templateSelectionExpression != null ? !this.templateSelectionExpression.equals(that.templateSelectionExpression) : that.templateSelectionExpression != null) return false;
            return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
        }

        @Override
        public final int hashCode() {
            int result = this.integrationType.hashCode();
            result = 31 * result + (this.integrationUri.hashCode());
            result = 31 * result + (this.webSocketApi.hashCode());
            result = 31 * result + (this.contentHandling != null ? this.contentHandling.hashCode() : 0);
            result = 31 * result + (this.credentialsRole != null ? this.credentialsRole.hashCode() : 0);
            result = 31 * result + (this.integrationMethod != null ? this.integrationMethod.hashCode() : 0);
            result = 31 * result + (this.passthroughBehavior != null ? this.passthroughBehavior.hashCode() : 0);
            result = 31 * result + (this.requestParameters != null ? this.requestParameters.hashCode() : 0);
            result = 31 * result + (this.requestTemplates != null ? this.requestTemplates.hashCode() : 0);
            result = 31 * result + (this.templateSelectionExpression != null ? this.templateSelectionExpression.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            return result;
        }
    }
}
