package software.amazon.awscdk.services.appmesh;

/**
 * Creates a gateway route.
 * <p>
 * A gateway route is attached to a virtual gateway and routes traffic to an existing virtual service. If a route matches a request, it can distribute traffic to a target virtual service.
 * <p>
 * For more information about gateway routes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/gateway-routes.html">Gateway routes</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * CfnGatewayRoute cfnGatewayRoute = CfnGatewayRoute.Builder.create(this, "MyCfnGatewayRoute")
 *         .meshName("meshName")
 *         .spec(GatewayRouteSpecProperty.builder()
 *                 .grpcRoute(GrpcGatewayRouteProperty.builder()
 *                         .action(GrpcGatewayRouteActionProperty.builder()
 *                                 .target(GatewayRouteTargetProperty.builder()
 *                                         .virtualService(GatewayRouteVirtualServiceProperty.builder()
 *                                                 .virtualServiceName("virtualServiceName")
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .port(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .rewrite(GrpcGatewayRouteRewriteProperty.builder()
 *                                         .hostname(GatewayRouteHostnameRewriteProperty.builder()
 *                                                 .defaultTargetHostname("defaultTargetHostname")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .match(GrpcGatewayRouteMatchProperty.builder()
 *                                 .hostname(GatewayRouteHostnameMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .suffix("suffix")
 *                                         .build())
 *                                 .metadata(List.of(GrpcGatewayRouteMetadataProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .invert(false)
 *                                         .match(GatewayRouteMetadataMatchProperty.builder()
 *                                                 .exact("exact")
 *                                                 .prefix("prefix")
 *                                                 .range(GatewayRouteRangeMatchProperty.builder()
 *                                                         .end(123)
 *                                                         .start(123)
 *                                                         .build())
 *                                                 .regex("regex")
 *                                                 .suffix("suffix")
 *                                                 .build())
 *                                         .build()))
 *                                 .port(123)
 *                                 .serviceName("serviceName")
 *                                 .build())
 *                         .build())
 *                 .http2Route(HttpGatewayRouteProperty.builder()
 *                         .action(HttpGatewayRouteActionProperty.builder()
 *                                 .target(GatewayRouteTargetProperty.builder()
 *                                         .virtualService(GatewayRouteVirtualServiceProperty.builder()
 *                                                 .virtualServiceName("virtualServiceName")
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .port(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .rewrite(HttpGatewayRouteRewriteProperty.builder()
 *                                         .hostname(GatewayRouteHostnameRewriteProperty.builder()
 *                                                 .defaultTargetHostname("defaultTargetHostname")
 *                                                 .build())
 *                                         .path(HttpGatewayRoutePathRewriteProperty.builder()
 *                                                 .exact("exact")
 *                                                 .build())
 *                                         .prefix(HttpGatewayRoutePrefixRewriteProperty.builder()
 *                                                 .defaultPrefix("defaultPrefix")
 *                                                 .value("value")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .match(HttpGatewayRouteMatchProperty.builder()
 *                                 .headers(List.of(HttpGatewayRouteHeaderProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .invert(false)
 *                                         .match(HttpGatewayRouteHeaderMatchProperty.builder()
 *                                                 .exact("exact")
 *                                                 .prefix("prefix")
 *                                                 .range(GatewayRouteRangeMatchProperty.builder()
 *                                                         .end(123)
 *                                                         .start(123)
 *                                                         .build())
 *                                                 .regex("regex")
 *                                                 .suffix("suffix")
 *                                                 .build())
 *                                         .build()))
 *                                 .hostname(GatewayRouteHostnameMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .suffix("suffix")
 *                                         .build())
 *                                 .method("method")
 *                                 .path(HttpPathMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .regex("regex")
 *                                         .build())
 *                                 .port(123)
 *                                 .prefix("prefix")
 *                                 .queryParameters(List.of(QueryParameterProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .match(HttpQueryParameterMatchProperty.builder()
 *                                                 .exact("exact")
 *                                                 .build())
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .httpRoute(HttpGatewayRouteProperty.builder()
 *                         .action(HttpGatewayRouteActionProperty.builder()
 *                                 .target(GatewayRouteTargetProperty.builder()
 *                                         .virtualService(GatewayRouteVirtualServiceProperty.builder()
 *                                                 .virtualServiceName("virtualServiceName")
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .port(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .rewrite(HttpGatewayRouteRewriteProperty.builder()
 *                                         .hostname(GatewayRouteHostnameRewriteProperty.builder()
 *                                                 .defaultTargetHostname("defaultTargetHostname")
 *                                                 .build())
 *                                         .path(HttpGatewayRoutePathRewriteProperty.builder()
 *                                                 .exact("exact")
 *                                                 .build())
 *                                         .prefix(HttpGatewayRoutePrefixRewriteProperty.builder()
 *                                                 .defaultPrefix("defaultPrefix")
 *                                                 .value("value")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .match(HttpGatewayRouteMatchProperty.builder()
 *                                 .headers(List.of(HttpGatewayRouteHeaderProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .invert(false)
 *                                         .match(HttpGatewayRouteHeaderMatchProperty.builder()
 *                                                 .exact("exact")
 *                                                 .prefix("prefix")
 *                                                 .range(GatewayRouteRangeMatchProperty.builder()
 *                                                         .end(123)
 *                                                         .start(123)
 *                                                         .build())
 *                                                 .regex("regex")
 *                                                 .suffix("suffix")
 *                                                 .build())
 *                                         .build()))
 *                                 .hostname(GatewayRouteHostnameMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .suffix("suffix")
 *                                         .build())
 *                                 .method("method")
 *                                 .path(HttpPathMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .regex("regex")
 *                                         .build())
 *                                 .port(123)
 *                                 .prefix("prefix")
 *                                 .queryParameters(List.of(QueryParameterProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .match(HttpQueryParameterMatchProperty.builder()
 *                                                 .exact("exact")
 *                                                 .build())
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .priority(123)
 *                 .build())
 *         .virtualGatewayName("virtualGatewayName")
 *         // the properties below are optional
 *         .gatewayRouteName("gatewayRouteName")
 *         .meshOwner("meshOwner")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:11.026Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute")
public class CfnGatewayRoute extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnGatewayRoute(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGatewayRoute(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnGatewayRoute(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.CfnGatewayRouteProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The full Amazon Resource Name (ARN) for the gateway route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the gateway route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGatewayRouteName() {
        return software.amazon.jsii.Kernel.get(this, "attrGatewayRouteName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the service mesh that the gateway route resides in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMeshName() {
        return software.amazon.jsii.Kernel.get(this, "attrMeshName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS IAM account ID of the service mesh owner.
     * <p>
     * If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMeshOwner() {
        return software.amazon.jsii.Kernel.get(this, "attrMeshOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IAM account ID of the resource owner.
     * <p>
     * If the account ID is not your own, then it's the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceOwner() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the gateway route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUid() {
        return software.amazon.jsii.Kernel.get(this, "attrUid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the virtual gateway that the gateway route is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVirtualGatewayName() {
        return software.amazon.jsii.Kernel.get(this, "attrVirtualGatewayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the service mesh that the resource resides in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMeshName() {
        return software.amazon.jsii.Kernel.get(this, "meshName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the service mesh that the resource resides in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMeshName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "meshName", java.util.Objects.requireNonNull(value, "meshName is required"));
    }

    /**
     * The specifications of the gateway route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSpec() {
        return software.amazon.jsii.Kernel.get(this, "spec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The specifications of the gateway route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpec(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "spec", java.util.Objects.requireNonNull(value, "spec is required"));
    }

    /**
     * The specifications of the gateway route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpec(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteSpecProperty value) {
        software.amazon.jsii.Kernel.set(this, "spec", java.util.Objects.requireNonNull(value, "spec is required"));
    }

    /**
     * The virtual gateway that the gateway route is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVirtualGatewayName() {
        return software.amazon.jsii.Kernel.get(this, "virtualGatewayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The virtual gateway that the gateway route is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVirtualGatewayName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "virtualGatewayName", java.util.Objects.requireNonNull(value, "virtualGatewayName is required"));
    }

    /**
     * The name of the gateway route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGatewayRouteName() {
        return software.amazon.jsii.Kernel.get(this, "gatewayRouteName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the gateway route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGatewayRouteName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "gatewayRouteName", value);
    }

    /**
     * The AWS IAM account ID of the service mesh owner.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMeshOwner() {
        return software.amazon.jsii.Kernel.get(this, "meshOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS IAM account ID of the service mesh owner.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMeshOwner(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "meshOwner", value);
    }

    /**
     * Optional metadata that you can apply to the gateway route to assist with categorization and organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Optional metadata that you can apply to the gateway route to assist with categorization and organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * An object representing the gateway route host name to match.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GatewayRouteHostnameMatchProperty gatewayRouteHostnameMatchProperty = GatewayRouteHostnameMatchProperty.builder()
     *         .exact("exact")
     *         .suffix("suffix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutehostnamematch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutehostnamematch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GatewayRouteHostnameMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(GatewayRouteHostnameMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GatewayRouteHostnameMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The exact host name to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutehostnamematch.html#cfn-appmesh-gatewayroute-gatewayroutehostnamematch-exact">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutehostnamematch.html#cfn-appmesh-gatewayroute-gatewayroutehostnamematch-exact</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExact() {
            return null;
        }

        /**
         * The specified ending characters of the host name to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutehostnamematch.html#cfn-appmesh-gatewayroute-gatewayroutehostnamematch-suffix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutehostnamematch.html#cfn-appmesh-gatewayroute-gatewayroutehostnamematch-suffix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuffix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GatewayRouteHostnameMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GatewayRouteHostnameMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GatewayRouteHostnameMatchProperty> {
            java.lang.String exact;
            java.lang.String suffix;

            /**
             * Sets the value of {@link GatewayRouteHostnameMatchProperty#getExact}
             * @param exact The exact host name to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exact(java.lang.String exact) {
                this.exact = exact;
                return this;
            }

            /**
             * Sets the value of {@link GatewayRouteHostnameMatchProperty#getSuffix}
             * @param suffix The specified ending characters of the host name to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder suffix(java.lang.String suffix) {
                this.suffix = suffix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GatewayRouteHostnameMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GatewayRouteHostnameMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GatewayRouteHostnameMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayRouteHostnameMatchProperty {
            private final java.lang.String exact;
            private final java.lang.String suffix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exact = software.amazon.jsii.Kernel.get(this, "exact", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.suffix = software.amazon.jsii.Kernel.get(this, "suffix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exact = builder.exact;
                this.suffix = builder.suffix;
            }

            @Override
            public final java.lang.String getExact() {
                return this.exact;
            }

            @Override
            public final java.lang.String getSuffix() {
                return this.suffix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExact() != null) {
                    data.set("exact", om.valueToTree(this.getExact()));
                }
                if (this.getSuffix() != null) {
                    data.set("suffix", om.valueToTree(this.getSuffix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GatewayRouteHostnameMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GatewayRouteHostnameMatchProperty.Jsii$Proxy that = (GatewayRouteHostnameMatchProperty.Jsii$Proxy) o;

                if (this.exact != null ? !this.exact.equals(that.exact) : that.exact != null) return false;
                return this.suffix != null ? this.suffix.equals(that.suffix) : that.suffix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exact != null ? this.exact.hashCode() : 0;
                result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object representing the gateway route host name to rewrite.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GatewayRouteHostnameRewriteProperty gatewayRouteHostnameRewriteProperty = GatewayRouteHostnameRewriteProperty.builder()
     *         .defaultTargetHostname("defaultTargetHostname")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutehostnamerewrite.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutehostnamerewrite.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GatewayRouteHostnameRewriteProperty")
    @software.amazon.jsii.Jsii.Proxy(GatewayRouteHostnameRewriteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GatewayRouteHostnameRewriteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default target host name to write to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutehostnamerewrite.html#cfn-appmesh-gatewayroute-gatewayroutehostnamerewrite-defaulttargethostname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutehostnamerewrite.html#cfn-appmesh-gatewayroute-gatewayroutehostnamerewrite-defaulttargethostname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultTargetHostname() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GatewayRouteHostnameRewriteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GatewayRouteHostnameRewriteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GatewayRouteHostnameRewriteProperty> {
            java.lang.String defaultTargetHostname;

            /**
             * Sets the value of {@link GatewayRouteHostnameRewriteProperty#getDefaultTargetHostname}
             * @param defaultTargetHostname The default target host name to write to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultTargetHostname(java.lang.String defaultTargetHostname) {
                this.defaultTargetHostname = defaultTargetHostname;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GatewayRouteHostnameRewriteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GatewayRouteHostnameRewriteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GatewayRouteHostnameRewriteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayRouteHostnameRewriteProperty {
            private final java.lang.String defaultTargetHostname;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultTargetHostname = software.amazon.jsii.Kernel.get(this, "defaultTargetHostname", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultTargetHostname = builder.defaultTargetHostname;
            }

            @Override
            public final java.lang.String getDefaultTargetHostname() {
                return this.defaultTargetHostname;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultTargetHostname() != null) {
                    data.set("defaultTargetHostname", om.valueToTree(this.getDefaultTargetHostname()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GatewayRouteHostnameRewriteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GatewayRouteHostnameRewriteProperty.Jsii$Proxy that = (GatewayRouteHostnameRewriteProperty.Jsii$Proxy) o;

                return this.defaultTargetHostname != null ? this.defaultTargetHostname.equals(that.defaultTargetHostname) : that.defaultTargetHostname == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultTargetHostname != null ? this.defaultTargetHostname.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object representing the method header to be matched.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GatewayRouteMetadataMatchProperty gatewayRouteMetadataMatchProperty = GatewayRouteMetadataMatchProperty.builder()
     *         .exact("exact")
     *         .prefix("prefix")
     *         .range(GatewayRouteRangeMatchProperty.builder()
     *                 .end(123)
     *                 .start(123)
     *                 .build())
     *         .regex("regex")
     *         .suffix("suffix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GatewayRouteMetadataMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(GatewayRouteMetadataMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GatewayRouteMetadataMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The exact method header to be matched on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html#cfn-appmesh-gatewayroute-gatewayroutemetadatamatch-exact">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html#cfn-appmesh-gatewayroute-gatewayroutemetadatamatch-exact</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExact() {
            return null;
        }

        /**
         * The specified beginning characters of the method header to be matched on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html#cfn-appmesh-gatewayroute-gatewayroutemetadatamatch-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html#cfn-appmesh-gatewayroute-gatewayroutemetadatamatch-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * An object that represents the range of values to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html#cfn-appmesh-gatewayroute-gatewayroutemetadatamatch-range">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html#cfn-appmesh-gatewayroute-gatewayroutemetadatamatch-range</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRange() {
            return null;
        }

        /**
         * The regex used to match the method header.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html#cfn-appmesh-gatewayroute-gatewayroutemetadatamatch-regex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html#cfn-appmesh-gatewayroute-gatewayroutemetadatamatch-regex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegex() {
            return null;
        }

        /**
         * The specified ending characters of the method header to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html#cfn-appmesh-gatewayroute-gatewayroutemetadatamatch-suffix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutemetadatamatch.html#cfn-appmesh-gatewayroute-gatewayroutemetadatamatch-suffix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuffix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GatewayRouteMetadataMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GatewayRouteMetadataMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GatewayRouteMetadataMatchProperty> {
            java.lang.String exact;
            java.lang.String prefix;
            java.lang.Object range;
            java.lang.String regex;
            java.lang.String suffix;

            /**
             * Sets the value of {@link GatewayRouteMetadataMatchProperty#getExact}
             * @param exact The exact method header to be matched on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exact(java.lang.String exact) {
                this.exact = exact;
                return this;
            }

            /**
             * Sets the value of {@link GatewayRouteMetadataMatchProperty#getPrefix}
             * @param prefix The specified beginning characters of the method header to be matched on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link GatewayRouteMetadataMatchProperty#getRange}
             * @param range An object that represents the range of values to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder range(software.amazon.awscdk.IResolvable range) {
                this.range = range;
                return this;
            }

            /**
             * Sets the value of {@link GatewayRouteMetadataMatchProperty#getRange}
             * @param range An object that represents the range of values to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder range(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteRangeMatchProperty range) {
                this.range = range;
                return this;
            }

            /**
             * Sets the value of {@link GatewayRouteMetadataMatchProperty#getRegex}
             * @param regex The regex used to match the method header.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regex(java.lang.String regex) {
                this.regex = regex;
                return this;
            }

            /**
             * Sets the value of {@link GatewayRouteMetadataMatchProperty#getSuffix}
             * @param suffix The specified ending characters of the method header to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder suffix(java.lang.String suffix) {
                this.suffix = suffix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GatewayRouteMetadataMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GatewayRouteMetadataMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GatewayRouteMetadataMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayRouteMetadataMatchProperty {
            private final java.lang.String exact;
            private final java.lang.String prefix;
            private final java.lang.Object range;
            private final java.lang.String regex;
            private final java.lang.String suffix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exact = software.amazon.jsii.Kernel.get(this, "exact", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.range = software.amazon.jsii.Kernel.get(this, "range", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.regex = software.amazon.jsii.Kernel.get(this, "regex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.suffix = software.amazon.jsii.Kernel.get(this, "suffix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exact = builder.exact;
                this.prefix = builder.prefix;
                this.range = builder.range;
                this.regex = builder.regex;
                this.suffix = builder.suffix;
            }

            @Override
            public final java.lang.String getExact() {
                return this.exact;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.Object getRange() {
                return this.range;
            }

            @Override
            public final java.lang.String getRegex() {
                return this.regex;
            }

            @Override
            public final java.lang.String getSuffix() {
                return this.suffix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExact() != null) {
                    data.set("exact", om.valueToTree(this.getExact()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getRange() != null) {
                    data.set("range", om.valueToTree(this.getRange()));
                }
                if (this.getRegex() != null) {
                    data.set("regex", om.valueToTree(this.getRegex()));
                }
                if (this.getSuffix() != null) {
                    data.set("suffix", om.valueToTree(this.getSuffix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GatewayRouteMetadataMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GatewayRouteMetadataMatchProperty.Jsii$Proxy that = (GatewayRouteMetadataMatchProperty.Jsii$Proxy) o;

                if (this.exact != null ? !this.exact.equals(that.exact) : that.exact != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                if (this.range != null ? !this.range.equals(that.range) : that.range != null) return false;
                if (this.regex != null ? !this.regex.equals(that.regex) : that.regex != null) return false;
                return this.suffix != null ? this.suffix.equals(that.suffix) : that.suffix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exact != null ? this.exact.hashCode() : 0;
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.range != null ? this.range.hashCode() : 0);
                result = 31 * result + (this.regex != null ? this.regex.hashCode() : 0);
                result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the range of values to match on.
     * <p>
     * The first character of the range is included in the range, though the last character is not. For example, if the range specified were 1-100, only values 1-99 would be matched.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GatewayRouteRangeMatchProperty gatewayRouteRangeMatchProperty = GatewayRouteRangeMatchProperty.builder()
     *         .end(123)
     *         .start(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayrouterangematch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayrouterangematch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GatewayRouteRangeMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(GatewayRouteRangeMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GatewayRouteRangeMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The end of the range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayrouterangematch.html#cfn-appmesh-gatewayroute-gatewayrouterangematch-end">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayrouterangematch.html#cfn-appmesh-gatewayroute-gatewayrouterangematch-end</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getEnd();

        /**
         * The start of the range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayrouterangematch.html#cfn-appmesh-gatewayroute-gatewayrouterangematch-start">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayrouterangematch.html#cfn-appmesh-gatewayroute-gatewayrouterangematch-start</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getStart();

        /**
         * @return a {@link Builder} of {@link GatewayRouteRangeMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GatewayRouteRangeMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GatewayRouteRangeMatchProperty> {
            java.lang.Number end;
            java.lang.Number start;

            /**
             * Sets the value of {@link GatewayRouteRangeMatchProperty#getEnd}
             * @param end The end of the range. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder end(java.lang.Number end) {
                this.end = end;
                return this;
            }

            /**
             * Sets the value of {@link GatewayRouteRangeMatchProperty#getStart}
             * @param start The start of the range. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder start(java.lang.Number start) {
                this.start = start;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GatewayRouteRangeMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GatewayRouteRangeMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GatewayRouteRangeMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayRouteRangeMatchProperty {
            private final java.lang.Number end;
            private final java.lang.Number start;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.end = software.amazon.jsii.Kernel.get(this, "end", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.start = software.amazon.jsii.Kernel.get(this, "start", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.end = java.util.Objects.requireNonNull(builder.end, "end is required");
                this.start = java.util.Objects.requireNonNull(builder.start, "start is required");
            }

            @Override
            public final java.lang.Number getEnd() {
                return this.end;
            }

            @Override
            public final java.lang.Number getStart() {
                return this.start;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("end", om.valueToTree(this.getEnd()));
                data.set("start", om.valueToTree(this.getStart()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GatewayRouteRangeMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GatewayRouteRangeMatchProperty.Jsii$Proxy that = (GatewayRouteRangeMatchProperty.Jsii$Proxy) o;

                if (!end.equals(that.end)) return false;
                return this.start.equals(that.start);
            }

            @Override
            public final int hashCode() {
                int result = this.end.hashCode();
                result = 31 * result + (this.start.hashCode());
                return result;
            }
        }
    }
    /**
     * An object that represents a gateway route specification.
     * <p>
     * Specify one gateway route type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GatewayRouteSpecProperty gatewayRouteSpecProperty = GatewayRouteSpecProperty.builder()
     *         .grpcRoute(GrpcGatewayRouteProperty.builder()
     *                 .action(GrpcGatewayRouteActionProperty.builder()
     *                         .target(GatewayRouteTargetProperty.builder()
     *                                 .virtualService(GatewayRouteVirtualServiceProperty.builder()
     *                                         .virtualServiceName("virtualServiceName")
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .port(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .rewrite(GrpcGatewayRouteRewriteProperty.builder()
     *                                 .hostname(GatewayRouteHostnameRewriteProperty.builder()
     *                                         .defaultTargetHostname("defaultTargetHostname")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .match(GrpcGatewayRouteMatchProperty.builder()
     *                         .hostname(GatewayRouteHostnameMatchProperty.builder()
     *                                 .exact("exact")
     *                                 .suffix("suffix")
     *                                 .build())
     *                         .metadata(List.of(GrpcGatewayRouteMetadataProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .invert(false)
     *                                 .match(GatewayRouteMetadataMatchProperty.builder()
     *                                         .exact("exact")
     *                                         .prefix("prefix")
     *                                         .range(GatewayRouteRangeMatchProperty.builder()
     *                                                 .end(123)
     *                                                 .start(123)
     *                                                 .build())
     *                                         .regex("regex")
     *                                         .suffix("suffix")
     *                                         .build())
     *                                 .build()))
     *                         .port(123)
     *                         .serviceName("serviceName")
     *                         .build())
     *                 .build())
     *         .http2Route(HttpGatewayRouteProperty.builder()
     *                 .action(HttpGatewayRouteActionProperty.builder()
     *                         .target(GatewayRouteTargetProperty.builder()
     *                                 .virtualService(GatewayRouteVirtualServiceProperty.builder()
     *                                         .virtualServiceName("virtualServiceName")
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .port(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .rewrite(HttpGatewayRouteRewriteProperty.builder()
     *                                 .hostname(GatewayRouteHostnameRewriteProperty.builder()
     *                                         .defaultTargetHostname("defaultTargetHostname")
     *                                         .build())
     *                                 .path(HttpGatewayRoutePathRewriteProperty.builder()
     *                                         .exact("exact")
     *                                         .build())
     *                                 .prefix(HttpGatewayRoutePrefixRewriteProperty.builder()
     *                                         .defaultPrefix("defaultPrefix")
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .match(HttpGatewayRouteMatchProperty.builder()
     *                         .headers(List.of(HttpGatewayRouteHeaderProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .invert(false)
     *                                 .match(HttpGatewayRouteHeaderMatchProperty.builder()
     *                                         .exact("exact")
     *                                         .prefix("prefix")
     *                                         .range(GatewayRouteRangeMatchProperty.builder()
     *                                                 .end(123)
     *                                                 .start(123)
     *                                                 .build())
     *                                         .regex("regex")
     *                                         .suffix("suffix")
     *                                         .build())
     *                                 .build()))
     *                         .hostname(GatewayRouteHostnameMatchProperty.builder()
     *                                 .exact("exact")
     *                                 .suffix("suffix")
     *                                 .build())
     *                         .method("method")
     *                         .path(HttpPathMatchProperty.builder()
     *                                 .exact("exact")
     *                                 .regex("regex")
     *                                 .build())
     *                         .port(123)
     *                         .prefix("prefix")
     *                         .queryParameters(List.of(QueryParameterProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .match(HttpQueryParameterMatchProperty.builder()
     *                                         .exact("exact")
     *                                         .build())
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .httpRoute(HttpGatewayRouteProperty.builder()
     *                 .action(HttpGatewayRouteActionProperty.builder()
     *                         .target(GatewayRouteTargetProperty.builder()
     *                                 .virtualService(GatewayRouteVirtualServiceProperty.builder()
     *                                         .virtualServiceName("virtualServiceName")
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .port(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .rewrite(HttpGatewayRouteRewriteProperty.builder()
     *                                 .hostname(GatewayRouteHostnameRewriteProperty.builder()
     *                                         .defaultTargetHostname("defaultTargetHostname")
     *                                         .build())
     *                                 .path(HttpGatewayRoutePathRewriteProperty.builder()
     *                                         .exact("exact")
     *                                         .build())
     *                                 .prefix(HttpGatewayRoutePrefixRewriteProperty.builder()
     *                                         .defaultPrefix("defaultPrefix")
     *                                         .value("value")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .match(HttpGatewayRouteMatchProperty.builder()
     *                         .headers(List.of(HttpGatewayRouteHeaderProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .invert(false)
     *                                 .match(HttpGatewayRouteHeaderMatchProperty.builder()
     *                                         .exact("exact")
     *                                         .prefix("prefix")
     *                                         .range(GatewayRouteRangeMatchProperty.builder()
     *                                                 .end(123)
     *                                                 .start(123)
     *                                                 .build())
     *                                         .regex("regex")
     *                                         .suffix("suffix")
     *                                         .build())
     *                                 .build()))
     *                         .hostname(GatewayRouteHostnameMatchProperty.builder()
     *                                 .exact("exact")
     *                                 .suffix("suffix")
     *                                 .build())
     *                         .method("method")
     *                         .path(HttpPathMatchProperty.builder()
     *                                 .exact("exact")
     *                                 .regex("regex")
     *                                 .build())
     *                         .port(123)
     *                         .prefix("prefix")
     *                         .queryParameters(List.of(QueryParameterProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .match(HttpQueryParameterMatchProperty.builder()
     *                                         .exact("exact")
     *                                         .build())
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .priority(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GatewayRouteSpecProperty")
    @software.amazon.jsii.Jsii.Proxy(GatewayRouteSpecProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GatewayRouteSpecProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents the specification of a gRPC gateway route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html#cfn-appmesh-gatewayroute-gatewayroutespec-grpcroute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html#cfn-appmesh-gatewayroute-gatewayroutespec-grpcroute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGrpcRoute() {
            return null;
        }

        /**
         * An object that represents the specification of an HTTP/2 gateway route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html#cfn-appmesh-gatewayroute-gatewayroutespec-http2route">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html#cfn-appmesh-gatewayroute-gatewayroutespec-http2route</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttp2Route() {
            return null;
        }

        /**
         * An object that represents the specification of an HTTP gateway route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html#cfn-appmesh-gatewayroute-gatewayroutespec-httproute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html#cfn-appmesh-gatewayroute-gatewayroutespec-httproute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttpRoute() {
            return null;
        }

        /**
         * The ordering of the gateway routes spec.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html#cfn-appmesh-gatewayroute-gatewayroutespec-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutespec.html#cfn-appmesh-gatewayroute-gatewayroutespec-priority</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GatewayRouteSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GatewayRouteSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GatewayRouteSpecProperty> {
            java.lang.Object grpcRoute;
            java.lang.Object http2Route;
            java.lang.Object httpRoute;
            java.lang.Number priority;

            /**
             * Sets the value of {@link GatewayRouteSpecProperty#getGrpcRoute}
             * @param grpcRoute An object that represents the specification of a gRPC gateway route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grpcRoute(software.amazon.awscdk.IResolvable grpcRoute) {
                this.grpcRoute = grpcRoute;
                return this;
            }

            /**
             * Sets the value of {@link GatewayRouteSpecProperty#getGrpcRoute}
             * @param grpcRoute An object that represents the specification of a gRPC gateway route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grpcRoute(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GrpcGatewayRouteProperty grpcRoute) {
                this.grpcRoute = grpcRoute;
                return this;
            }

            /**
             * Sets the value of {@link GatewayRouteSpecProperty#getHttp2Route}
             * @param http2Route An object that represents the specification of an HTTP/2 gateway route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http2Route(software.amazon.awscdk.IResolvable http2Route) {
                this.http2Route = http2Route;
                return this;
            }

            /**
             * Sets the value of {@link GatewayRouteSpecProperty#getHttp2Route}
             * @param http2Route An object that represents the specification of an HTTP/2 gateway route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http2Route(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteProperty http2Route) {
                this.http2Route = http2Route;
                return this;
            }

            /**
             * Sets the value of {@link GatewayRouteSpecProperty#getHttpRoute}
             * @param httpRoute An object that represents the specification of an HTTP gateway route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpRoute(software.amazon.awscdk.IResolvable httpRoute) {
                this.httpRoute = httpRoute;
                return this;
            }

            /**
             * Sets the value of {@link GatewayRouteSpecProperty#getHttpRoute}
             * @param httpRoute An object that represents the specification of an HTTP gateway route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpRoute(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteProperty httpRoute) {
                this.httpRoute = httpRoute;
                return this;
            }

            /**
             * Sets the value of {@link GatewayRouteSpecProperty#getPriority}
             * @param priority The ordering of the gateway routes spec.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GatewayRouteSpecProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GatewayRouteSpecProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GatewayRouteSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayRouteSpecProperty {
            private final java.lang.Object grpcRoute;
            private final java.lang.Object http2Route;
            private final java.lang.Object httpRoute;
            private final java.lang.Number priority;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.grpcRoute = software.amazon.jsii.Kernel.get(this, "grpcRoute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.http2Route = software.amazon.jsii.Kernel.get(this, "http2Route", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.httpRoute = software.amazon.jsii.Kernel.get(this, "httpRoute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.grpcRoute = builder.grpcRoute;
                this.http2Route = builder.http2Route;
                this.httpRoute = builder.httpRoute;
                this.priority = builder.priority;
            }

            @Override
            public final java.lang.Object getGrpcRoute() {
                return this.grpcRoute;
            }

            @Override
            public final java.lang.Object getHttp2Route() {
                return this.http2Route;
            }

            @Override
            public final java.lang.Object getHttpRoute() {
                return this.httpRoute;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGrpcRoute() != null) {
                    data.set("grpcRoute", om.valueToTree(this.getGrpcRoute()));
                }
                if (this.getHttp2Route() != null) {
                    data.set("http2Route", om.valueToTree(this.getHttp2Route()));
                }
                if (this.getHttpRoute() != null) {
                    data.set("httpRoute", om.valueToTree(this.getHttpRoute()));
                }
                if (this.getPriority() != null) {
                    data.set("priority", om.valueToTree(this.getPriority()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GatewayRouteSpecProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GatewayRouteSpecProperty.Jsii$Proxy that = (GatewayRouteSpecProperty.Jsii$Proxy) o;

                if (this.grpcRoute != null ? !this.grpcRoute.equals(that.grpcRoute) : that.grpcRoute != null) return false;
                if (this.http2Route != null ? !this.http2Route.equals(that.http2Route) : that.http2Route != null) return false;
                if (this.httpRoute != null ? !this.httpRoute.equals(that.httpRoute) : that.httpRoute != null) return false;
                return this.priority != null ? this.priority.equals(that.priority) : that.priority == null;
            }

            @Override
            public final int hashCode() {
                int result = this.grpcRoute != null ? this.grpcRoute.hashCode() : 0;
                result = 31 * result + (this.http2Route != null ? this.http2Route.hashCode() : 0);
                result = 31 * result + (this.httpRoute != null ? this.httpRoute.hashCode() : 0);
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a gateway route target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GatewayRouteTargetProperty gatewayRouteTargetProperty = GatewayRouteTargetProperty.builder()
     *         .virtualService(GatewayRouteVirtualServiceProperty.builder()
     *                 .virtualServiceName("virtualServiceName")
     *                 .build())
     *         // the properties below are optional
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutetarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutetarget.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GatewayRouteTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(GatewayRouteTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GatewayRouteTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents a virtual service gateway route target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutetarget.html#cfn-appmesh-gatewayroute-gatewayroutetarget-virtualservice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutetarget.html#cfn-appmesh-gatewayroute-gatewayroutetarget-virtualservice</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getVirtualService();

        /**
         * The port number of the gateway route target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutetarget.html#cfn-appmesh-gatewayroute-gatewayroutetarget-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutetarget.html#cfn-appmesh-gatewayroute-gatewayroutetarget-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GatewayRouteTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GatewayRouteTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GatewayRouteTargetProperty> {
            java.lang.Object virtualService;
            java.lang.Number port;

            /**
             * Sets the value of {@link GatewayRouteTargetProperty#getVirtualService}
             * @param virtualService An object that represents a virtual service gateway route target. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder virtualService(software.amazon.awscdk.IResolvable virtualService) {
                this.virtualService = virtualService;
                return this;
            }

            /**
             * Sets the value of {@link GatewayRouteTargetProperty#getVirtualService}
             * @param virtualService An object that represents a virtual service gateway route target. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder virtualService(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteVirtualServiceProperty virtualService) {
                this.virtualService = virtualService;
                return this;
            }

            /**
             * Sets the value of {@link GatewayRouteTargetProperty#getPort}
             * @param port The port number of the gateway route target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GatewayRouteTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GatewayRouteTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GatewayRouteTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayRouteTargetProperty {
            private final java.lang.Object virtualService;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.virtualService = software.amazon.jsii.Kernel.get(this, "virtualService", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.virtualService = java.util.Objects.requireNonNull(builder.virtualService, "virtualService is required");
                this.port = builder.port;
            }

            @Override
            public final java.lang.Object getVirtualService() {
                return this.virtualService;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("virtualService", om.valueToTree(this.getVirtualService()));
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GatewayRouteTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GatewayRouteTargetProperty.Jsii$Proxy that = (GatewayRouteTargetProperty.Jsii$Proxy) o;

                if (!virtualService.equals(that.virtualService)) return false;
                return this.port != null ? this.port.equals(that.port) : that.port == null;
            }

            @Override
            public final int hashCode() {
                int result = this.virtualService.hashCode();
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the virtual service that traffic is routed to.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GatewayRouteVirtualServiceProperty gatewayRouteVirtualServiceProperty = GatewayRouteVirtualServiceProperty.builder()
     *         .virtualServiceName("virtualServiceName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutevirtualservice.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutevirtualservice.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GatewayRouteVirtualServiceProperty")
    @software.amazon.jsii.Jsii.Proxy(GatewayRouteVirtualServiceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GatewayRouteVirtualServiceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the virtual service that traffic is routed to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutevirtualservice.html#cfn-appmesh-gatewayroute-gatewayroutevirtualservice-virtualservicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-gatewayroutevirtualservice.html#cfn-appmesh-gatewayroute-gatewayroutevirtualservice-virtualservicename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVirtualServiceName();

        /**
         * @return a {@link Builder} of {@link GatewayRouteVirtualServiceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GatewayRouteVirtualServiceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GatewayRouteVirtualServiceProperty> {
            java.lang.String virtualServiceName;

            /**
             * Sets the value of {@link GatewayRouteVirtualServiceProperty#getVirtualServiceName}
             * @param virtualServiceName The name of the virtual service that traffic is routed to. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder virtualServiceName(java.lang.String virtualServiceName) {
                this.virtualServiceName = virtualServiceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GatewayRouteVirtualServiceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GatewayRouteVirtualServiceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GatewayRouteVirtualServiceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GatewayRouteVirtualServiceProperty {
            private final java.lang.String virtualServiceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.virtualServiceName = software.amazon.jsii.Kernel.get(this, "virtualServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.virtualServiceName = java.util.Objects.requireNonNull(builder.virtualServiceName, "virtualServiceName is required");
            }

            @Override
            public final java.lang.String getVirtualServiceName() {
                return this.virtualServiceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("virtualServiceName", om.valueToTree(this.getVirtualServiceName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GatewayRouteVirtualServiceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GatewayRouteVirtualServiceProperty.Jsii$Proxy that = (GatewayRouteVirtualServiceProperty.Jsii$Proxy) o;

                return this.virtualServiceName.equals(that.virtualServiceName);
            }

            @Override
            public final int hashCode() {
                int result = this.virtualServiceName.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents the action to take if a match is determined.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GrpcGatewayRouteActionProperty grpcGatewayRouteActionProperty = GrpcGatewayRouteActionProperty.builder()
     *         .target(GatewayRouteTargetProperty.builder()
     *                 .virtualService(GatewayRouteVirtualServiceProperty.builder()
     *                         .virtualServiceName("virtualServiceName")
     *                         .build())
     *                 // the properties below are optional
     *                 .port(123)
     *                 .build())
     *         // the properties below are optional
     *         .rewrite(GrpcGatewayRouteRewriteProperty.builder()
     *                 .hostname(GatewayRouteHostnameRewriteProperty.builder()
     *                         .defaultTargetHostname("defaultTargetHostname")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayrouteaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayrouteaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GrpcGatewayRouteActionProperty")
    @software.amazon.jsii.Jsii.Proxy(GrpcGatewayRouteActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrpcGatewayRouteActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents the target that traffic is routed to when a request matches the gateway route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayrouteaction.html#cfn-appmesh-gatewayroute-grpcgatewayrouteaction-target">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayrouteaction.html#cfn-appmesh-gatewayroute-grpcgatewayrouteaction-target</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTarget();

        /**
         * The gateway route action to rewrite.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayrouteaction.html#cfn-appmesh-gatewayroute-grpcgatewayrouteaction-rewrite">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayrouteaction.html#cfn-appmesh-gatewayroute-grpcgatewayrouteaction-rewrite</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRewrite() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GrpcGatewayRouteActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrpcGatewayRouteActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrpcGatewayRouteActionProperty> {
            java.lang.Object target;
            java.lang.Object rewrite;

            /**
             * Sets the value of {@link GrpcGatewayRouteActionProperty#getTarget}
             * @param target An object that represents the target that traffic is routed to when a request matches the gateway route. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(software.amazon.awscdk.IResolvable target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link GrpcGatewayRouteActionProperty#getTarget}
             * @param target An object that represents the target that traffic is routed to when a request matches the gateway route. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteTargetProperty target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link GrpcGatewayRouteActionProperty#getRewrite}
             * @param rewrite The gateway route action to rewrite.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rewrite(software.amazon.awscdk.IResolvable rewrite) {
                this.rewrite = rewrite;
                return this;
            }

            /**
             * Sets the value of {@link GrpcGatewayRouteActionProperty#getRewrite}
             * @param rewrite The gateway route action to rewrite.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rewrite(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GrpcGatewayRouteRewriteProperty rewrite) {
                this.rewrite = rewrite;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrpcGatewayRouteActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrpcGatewayRouteActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrpcGatewayRouteActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcGatewayRouteActionProperty {
            private final java.lang.Object target;
            private final java.lang.Object rewrite;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rewrite = software.amazon.jsii.Kernel.get(this, "rewrite", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
                this.rewrite = builder.rewrite;
            }

            @Override
            public final java.lang.Object getTarget() {
                return this.target;
            }

            @Override
            public final java.lang.Object getRewrite() {
                return this.rewrite;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("target", om.valueToTree(this.getTarget()));
                if (this.getRewrite() != null) {
                    data.set("rewrite", om.valueToTree(this.getRewrite()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GrpcGatewayRouteActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrpcGatewayRouteActionProperty.Jsii$Proxy that = (GrpcGatewayRouteActionProperty.Jsii$Proxy) o;

                if (!target.equals(that.target)) return false;
                return this.rewrite != null ? this.rewrite.equals(that.rewrite) : that.rewrite == null;
            }

            @Override
            public final int hashCode() {
                int result = this.target.hashCode();
                result = 31 * result + (this.rewrite != null ? this.rewrite.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the criteria for determining a request match.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GrpcGatewayRouteMatchProperty grpcGatewayRouteMatchProperty = GrpcGatewayRouteMatchProperty.builder()
     *         .hostname(GatewayRouteHostnameMatchProperty.builder()
     *                 .exact("exact")
     *                 .suffix("suffix")
     *                 .build())
     *         .metadata(List.of(GrpcGatewayRouteMetadataProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .invert(false)
     *                 .match(GatewayRouteMetadataMatchProperty.builder()
     *                         .exact("exact")
     *                         .prefix("prefix")
     *                         .range(GatewayRouteRangeMatchProperty.builder()
     *                                 .end(123)
     *                                 .start(123)
     *                                 .build())
     *                         .regex("regex")
     *                         .suffix("suffix")
     *                         .build())
     *                 .build()))
     *         .port(123)
     *         .serviceName("serviceName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutematch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutematch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GrpcGatewayRouteMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(GrpcGatewayRouteMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrpcGatewayRouteMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The gateway route host name to be matched on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutematch.html#cfn-appmesh-gatewayroute-grpcgatewayroutematch-hostname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutematch.html#cfn-appmesh-gatewayroute-grpcgatewayroutematch-hostname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHostname() {
            return null;
        }

        /**
         * The gateway route metadata to be matched on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutematch.html#cfn-appmesh-gatewayroute-grpcgatewayroutematch-metadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutematch.html#cfn-appmesh-gatewayroute-grpcgatewayroutematch-metadata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetadata() {
            return null;
        }

        /**
         * The gateway route port to be matched on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutematch.html#cfn-appmesh-gatewayroute-grpcgatewayroutematch-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutematch.html#cfn-appmesh-gatewayroute-grpcgatewayroutematch-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * The fully qualified domain name for the service to match from the request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutematch.html#cfn-appmesh-gatewayroute-grpcgatewayroutematch-servicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutematch.html#cfn-appmesh-gatewayroute-grpcgatewayroutematch-servicename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GrpcGatewayRouteMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrpcGatewayRouteMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrpcGatewayRouteMatchProperty> {
            java.lang.Object hostname;
            java.lang.Object metadata;
            java.lang.Number port;
            java.lang.String serviceName;

            /**
             * Sets the value of {@link GrpcGatewayRouteMatchProperty#getHostname}
             * @param hostname The gateway route host name to be matched on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostname(software.amazon.awscdk.IResolvable hostname) {
                this.hostname = hostname;
                return this;
            }

            /**
             * Sets the value of {@link GrpcGatewayRouteMatchProperty#getHostname}
             * @param hostname The gateway route host name to be matched on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostname(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteHostnameMatchProperty hostname) {
                this.hostname = hostname;
                return this;
            }

            /**
             * Sets the value of {@link GrpcGatewayRouteMatchProperty#getMetadata}
             * @param metadata The gateway route metadata to be matched on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadata(software.amazon.awscdk.IResolvable metadata) {
                this.metadata = metadata;
                return this;
            }

            /**
             * Sets the value of {@link GrpcGatewayRouteMatchProperty#getMetadata}
             * @param metadata The gateway route metadata to be matched on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadata(java.util.List<? extends java.lang.Object> metadata) {
                this.metadata = metadata;
                return this;
            }

            /**
             * Sets the value of {@link GrpcGatewayRouteMatchProperty#getPort}
             * @param port The gateway route port to be matched on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link GrpcGatewayRouteMatchProperty#getServiceName}
             * @param serviceName The fully qualified domain name for the service to match from the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceName(java.lang.String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrpcGatewayRouteMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrpcGatewayRouteMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrpcGatewayRouteMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcGatewayRouteMatchProperty {
            private final java.lang.Object hostname;
            private final java.lang.Object metadata;
            private final java.lang.Number port;
            private final java.lang.String serviceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hostname = software.amazon.jsii.Kernel.get(this, "hostname", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hostname = builder.hostname;
                this.metadata = builder.metadata;
                this.port = builder.port;
                this.serviceName = builder.serviceName;
            }

            @Override
            public final java.lang.Object getHostname() {
                return this.hostname;
            }

            @Override
            public final java.lang.Object getMetadata() {
                return this.metadata;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getServiceName() {
                return this.serviceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHostname() != null) {
                    data.set("hostname", om.valueToTree(this.getHostname()));
                }
                if (this.getMetadata() != null) {
                    data.set("metadata", om.valueToTree(this.getMetadata()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getServiceName() != null) {
                    data.set("serviceName", om.valueToTree(this.getServiceName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GrpcGatewayRouteMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrpcGatewayRouteMatchProperty.Jsii$Proxy that = (GrpcGatewayRouteMatchProperty.Jsii$Proxy) o;

                if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) return false;
                if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                return this.serviceName != null ? this.serviceName.equals(that.serviceName) : that.serviceName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hostname != null ? this.hostname.hashCode() : 0;
                result = 31 * result + (this.metadata != null ? this.metadata.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object representing the metadata of the gateway route.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GrpcGatewayRouteMetadataProperty grpcGatewayRouteMetadataProperty = GrpcGatewayRouteMetadataProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .invert(false)
     *         .match(GatewayRouteMetadataMatchProperty.builder()
     *                 .exact("exact")
     *                 .prefix("prefix")
     *                 .range(GatewayRouteRangeMatchProperty.builder()
     *                         .end(123)
     *                         .start(123)
     *                         .build())
     *                 .regex("regex")
     *                 .suffix("suffix")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutemetadata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutemetadata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GrpcGatewayRouteMetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(GrpcGatewayRouteMetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrpcGatewayRouteMetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the gateway route metadata.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutemetadata.html#cfn-appmesh-gatewayroute-grpcgatewayroutemetadata-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutemetadata.html#cfn-appmesh-gatewayroute-grpcgatewayroutemetadata-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Specify <code>True</code> to match anything except the match criteria.
         * <p>
         * The default value is <code>False</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutemetadata.html#cfn-appmesh-gatewayroute-grpcgatewayroutemetadata-invert">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutemetadata.html#cfn-appmesh-gatewayroute-grpcgatewayroutemetadata-invert</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInvert() {
            return null;
        }

        /**
         * The criteria for determining a metadata match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutemetadata.html#cfn-appmesh-gatewayroute-grpcgatewayroutemetadata-match">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroutemetadata.html#cfn-appmesh-gatewayroute-grpcgatewayroutemetadata-match</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMatch() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GrpcGatewayRouteMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrpcGatewayRouteMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrpcGatewayRouteMetadataProperty> {
            java.lang.String name;
            java.lang.Object invert;
            java.lang.Object match;

            /**
             * Sets the value of {@link GrpcGatewayRouteMetadataProperty#getName}
             * @param name A name for the gateway route metadata. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link GrpcGatewayRouteMetadataProperty#getInvert}
             * @param invert Specify <code>True</code> to match anything except the match criteria.
             *               The default value is <code>False</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invert(java.lang.Boolean invert) {
                this.invert = invert;
                return this;
            }

            /**
             * Sets the value of {@link GrpcGatewayRouteMetadataProperty#getInvert}
             * @param invert Specify <code>True</code> to match anything except the match criteria.
             *               The default value is <code>False</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invert(software.amazon.awscdk.IResolvable invert) {
                this.invert = invert;
                return this;
            }

            /**
             * Sets the value of {@link GrpcGatewayRouteMetadataProperty#getMatch}
             * @param match The criteria for determining a metadata match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.IResolvable match) {
                this.match = match;
                return this;
            }

            /**
             * Sets the value of {@link GrpcGatewayRouteMetadataProperty#getMatch}
             * @param match The criteria for determining a metadata match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteMetadataMatchProperty match) {
                this.match = match;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrpcGatewayRouteMetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrpcGatewayRouteMetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrpcGatewayRouteMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcGatewayRouteMetadataProperty {
            private final java.lang.String name;
            private final java.lang.Object invert;
            private final java.lang.Object match;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.invert = software.amazon.jsii.Kernel.get(this, "invert", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.match = software.amazon.jsii.Kernel.get(this, "match", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.invert = builder.invert;
                this.match = builder.match;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getInvert() {
                return this.invert;
            }

            @Override
            public final java.lang.Object getMatch() {
                return this.match;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getInvert() != null) {
                    data.set("invert", om.valueToTree(this.getInvert()));
                }
                if (this.getMatch() != null) {
                    data.set("match", om.valueToTree(this.getMatch()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GrpcGatewayRouteMetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrpcGatewayRouteMetadataProperty.Jsii$Proxy that = (GrpcGatewayRouteMetadataProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.invert != null ? !this.invert.equals(that.invert) : that.invert != null) return false;
                return this.match != null ? this.match.equals(that.match) : that.match == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.invert != null ? this.invert.hashCode() : 0);
                result = 31 * result + (this.match != null ? this.match.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a gRPC gateway route.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GrpcGatewayRouteProperty grpcGatewayRouteProperty = GrpcGatewayRouteProperty.builder()
     *         .action(GrpcGatewayRouteActionProperty.builder()
     *                 .target(GatewayRouteTargetProperty.builder()
     *                         .virtualService(GatewayRouteVirtualServiceProperty.builder()
     *                                 .virtualServiceName("virtualServiceName")
     *                                 .build())
     *                         // the properties below are optional
     *                         .port(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .rewrite(GrpcGatewayRouteRewriteProperty.builder()
     *                         .hostname(GatewayRouteHostnameRewriteProperty.builder()
     *                                 .defaultTargetHostname("defaultTargetHostname")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .match(GrpcGatewayRouteMatchProperty.builder()
     *                 .hostname(GatewayRouteHostnameMatchProperty.builder()
     *                         .exact("exact")
     *                         .suffix("suffix")
     *                         .build())
     *                 .metadata(List.of(GrpcGatewayRouteMetadataProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .invert(false)
     *                         .match(GatewayRouteMetadataMatchProperty.builder()
     *                                 .exact("exact")
     *                                 .prefix("prefix")
     *                                 .range(GatewayRouteRangeMatchProperty.builder()
     *                                         .end(123)
     *                                         .start(123)
     *                                         .build())
     *                                 .regex("regex")
     *                                 .suffix("suffix")
     *                                 .build())
     *                         .build()))
     *                 .port(123)
     *                 .serviceName("serviceName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GrpcGatewayRouteProperty")
    @software.amazon.jsii.Jsii.Proxy(GrpcGatewayRouteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrpcGatewayRouteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents the action to take if a match is determined.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroute.html#cfn-appmesh-gatewayroute-grpcgatewayroute-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroute.html#cfn-appmesh-gatewayroute-grpcgatewayroute-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAction();

        /**
         * An object that represents the criteria for determining a request match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroute.html#cfn-appmesh-gatewayroute-grpcgatewayroute-match">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayroute.html#cfn-appmesh-gatewayroute-grpcgatewayroute-match</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMatch();

        /**
         * @return a {@link Builder} of {@link GrpcGatewayRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrpcGatewayRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrpcGatewayRouteProperty> {
            java.lang.Object action;
            java.lang.Object match;

            /**
             * Sets the value of {@link GrpcGatewayRouteProperty#getAction}
             * @param action An object that represents the action to take if a match is determined. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.IResolvable action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link GrpcGatewayRouteProperty#getAction}
             * @param action An object that represents the action to take if a match is determined. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GrpcGatewayRouteActionProperty action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link GrpcGatewayRouteProperty#getMatch}
             * @param match An object that represents the criteria for determining a request match. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.IResolvable match) {
                this.match = match;
                return this;
            }

            /**
             * Sets the value of {@link GrpcGatewayRouteProperty#getMatch}
             * @param match An object that represents the criteria for determining a request match. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GrpcGatewayRouteMatchProperty match) {
                this.match = match;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrpcGatewayRouteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrpcGatewayRouteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrpcGatewayRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcGatewayRouteProperty {
            private final java.lang.Object action;
            private final java.lang.Object match;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.match = software.amazon.jsii.Kernel.get(this, "match", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.match = java.util.Objects.requireNonNull(builder.match, "match is required");
            }

            @Override
            public final java.lang.Object getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Object getMatch() {
                return this.match;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("match", om.valueToTree(this.getMatch()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GrpcGatewayRouteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrpcGatewayRouteProperty.Jsii$Proxy that = (GrpcGatewayRouteProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                return this.match.equals(that.match);
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.match.hashCode());
                return result;
            }
        }
    }
    /**
     * An object that represents the gateway route to rewrite.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GrpcGatewayRouteRewriteProperty grpcGatewayRouteRewriteProperty = GrpcGatewayRouteRewriteProperty.builder()
     *         .hostname(GatewayRouteHostnameRewriteProperty.builder()
     *                 .defaultTargetHostname("defaultTargetHostname")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayrouterewrite.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayrouterewrite.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GrpcGatewayRouteRewriteProperty")
    @software.amazon.jsii.Jsii.Proxy(GrpcGatewayRouteRewriteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrpcGatewayRouteRewriteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The host name of the gateway route to rewrite.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayrouterewrite.html#cfn-appmesh-gatewayroute-grpcgatewayrouterewrite-hostname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-grpcgatewayrouterewrite.html#cfn-appmesh-gatewayroute-grpcgatewayrouterewrite-hostname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHostname() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GrpcGatewayRouteRewriteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrpcGatewayRouteRewriteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrpcGatewayRouteRewriteProperty> {
            java.lang.Object hostname;

            /**
             * Sets the value of {@link GrpcGatewayRouteRewriteProperty#getHostname}
             * @param hostname The host name of the gateway route to rewrite.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostname(software.amazon.awscdk.IResolvable hostname) {
                this.hostname = hostname;
                return this;
            }

            /**
             * Sets the value of {@link GrpcGatewayRouteRewriteProperty#getHostname}
             * @param hostname The host name of the gateway route to rewrite.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostname(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteHostnameRewriteProperty hostname) {
                this.hostname = hostname;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrpcGatewayRouteRewriteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrpcGatewayRouteRewriteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrpcGatewayRouteRewriteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcGatewayRouteRewriteProperty {
            private final java.lang.Object hostname;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hostname = software.amazon.jsii.Kernel.get(this, "hostname", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hostname = builder.hostname;
            }

            @Override
            public final java.lang.Object getHostname() {
                return this.hostname;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHostname() != null) {
                    data.set("hostname", om.valueToTree(this.getHostname()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.GrpcGatewayRouteRewriteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrpcGatewayRouteRewriteProperty.Jsii$Proxy that = (GrpcGatewayRouteRewriteProperty.Jsii$Proxy) o;

                return this.hostname != null ? this.hostname.equals(that.hostname) : that.hostname == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hostname != null ? this.hostname.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents the action to take if a match is determined.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpGatewayRouteActionProperty httpGatewayRouteActionProperty = HttpGatewayRouteActionProperty.builder()
     *         .target(GatewayRouteTargetProperty.builder()
     *                 .virtualService(GatewayRouteVirtualServiceProperty.builder()
     *                         .virtualServiceName("virtualServiceName")
     *                         .build())
     *                 // the properties below are optional
     *                 .port(123)
     *                 .build())
     *         // the properties below are optional
     *         .rewrite(HttpGatewayRouteRewriteProperty.builder()
     *                 .hostname(GatewayRouteHostnameRewriteProperty.builder()
     *                         .defaultTargetHostname("defaultTargetHostname")
     *                         .build())
     *                 .path(HttpGatewayRoutePathRewriteProperty.builder()
     *                         .exact("exact")
     *                         .build())
     *                 .prefix(HttpGatewayRoutePrefixRewriteProperty.builder()
     *                         .defaultPrefix("defaultPrefix")
     *                         .value("value")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpGatewayRouteActionProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpGatewayRouteActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpGatewayRouteActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents the target that traffic is routed to when a request matches the gateway route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteaction.html#cfn-appmesh-gatewayroute-httpgatewayrouteaction-target">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteaction.html#cfn-appmesh-gatewayroute-httpgatewayrouteaction-target</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTarget();

        /**
         * The gateway route action to rewrite.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteaction.html#cfn-appmesh-gatewayroute-httpgatewayrouteaction-rewrite">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteaction.html#cfn-appmesh-gatewayroute-httpgatewayrouteaction-rewrite</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRewrite() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpGatewayRouteActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpGatewayRouteActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpGatewayRouteActionProperty> {
            java.lang.Object target;
            java.lang.Object rewrite;

            /**
             * Sets the value of {@link HttpGatewayRouteActionProperty#getTarget}
             * @param target An object that represents the target that traffic is routed to when a request matches the gateway route. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(software.amazon.awscdk.IResolvable target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteActionProperty#getTarget}
             * @param target An object that represents the target that traffic is routed to when a request matches the gateway route. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteTargetProperty target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteActionProperty#getRewrite}
             * @param rewrite The gateway route action to rewrite.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rewrite(software.amazon.awscdk.IResolvable rewrite) {
                this.rewrite = rewrite;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteActionProperty#getRewrite}
             * @param rewrite The gateway route action to rewrite.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rewrite(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteRewriteProperty rewrite) {
                this.rewrite = rewrite;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpGatewayRouteActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpGatewayRouteActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpGatewayRouteActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpGatewayRouteActionProperty {
            private final java.lang.Object target;
            private final java.lang.Object rewrite;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rewrite = software.amazon.jsii.Kernel.get(this, "rewrite", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
                this.rewrite = builder.rewrite;
            }

            @Override
            public final java.lang.Object getTarget() {
                return this.target;
            }

            @Override
            public final java.lang.Object getRewrite() {
                return this.rewrite;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("target", om.valueToTree(this.getTarget()));
                if (this.getRewrite() != null) {
                    data.set("rewrite", om.valueToTree(this.getRewrite()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpGatewayRouteActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpGatewayRouteActionProperty.Jsii$Proxy that = (HttpGatewayRouteActionProperty.Jsii$Proxy) o;

                if (!target.equals(that.target)) return false;
                return this.rewrite != null ? this.rewrite.equals(that.rewrite) : that.rewrite == null;
            }

            @Override
            public final int hashCode() {
                int result = this.target.hashCode();
                result = 31 * result + (this.rewrite != null ? this.rewrite.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the method and value to match with the header value sent in a request.
     * <p>
     * Specify one match method.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpGatewayRouteHeaderMatchProperty httpGatewayRouteHeaderMatchProperty = HttpGatewayRouteHeaderMatchProperty.builder()
     *         .exact("exact")
     *         .prefix("prefix")
     *         .range(GatewayRouteRangeMatchProperty.builder()
     *                 .end(123)
     *                 .start(123)
     *                 .build())
     *         .regex("regex")
     *         .suffix("suffix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpGatewayRouteHeaderMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpGatewayRouteHeaderMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpGatewayRouteHeaderMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value sent by the client must match the specified value exactly.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html#cfn-appmesh-gatewayroute-httpgatewayrouteheadermatch-exact">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html#cfn-appmesh-gatewayroute-httpgatewayrouteheadermatch-exact</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExact() {
            return null;
        }

        /**
         * The value sent by the client must begin with the specified characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html#cfn-appmesh-gatewayroute-httpgatewayrouteheadermatch-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html#cfn-appmesh-gatewayroute-httpgatewayrouteheadermatch-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * An object that represents the range of values to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html#cfn-appmesh-gatewayroute-httpgatewayrouteheadermatch-range">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html#cfn-appmesh-gatewayroute-httpgatewayrouteheadermatch-range</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRange() {
            return null;
        }

        /**
         * The value sent by the client must include the specified characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html#cfn-appmesh-gatewayroute-httpgatewayrouteheadermatch-regex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html#cfn-appmesh-gatewayroute-httpgatewayrouteheadermatch-regex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegex() {
            return null;
        }

        /**
         * The value sent by the client must end with the specified characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html#cfn-appmesh-gatewayroute-httpgatewayrouteheadermatch-suffix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheadermatch.html#cfn-appmesh-gatewayroute-httpgatewayrouteheadermatch-suffix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuffix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpGatewayRouteHeaderMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpGatewayRouteHeaderMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpGatewayRouteHeaderMatchProperty> {
            java.lang.String exact;
            java.lang.String prefix;
            java.lang.Object range;
            java.lang.String regex;
            java.lang.String suffix;

            /**
             * Sets the value of {@link HttpGatewayRouteHeaderMatchProperty#getExact}
             * @param exact The value sent by the client must match the specified value exactly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exact(java.lang.String exact) {
                this.exact = exact;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteHeaderMatchProperty#getPrefix}
             * @param prefix The value sent by the client must begin with the specified characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteHeaderMatchProperty#getRange}
             * @param range An object that represents the range of values to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder range(software.amazon.awscdk.IResolvable range) {
                this.range = range;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteHeaderMatchProperty#getRange}
             * @param range An object that represents the range of values to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder range(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteRangeMatchProperty range) {
                this.range = range;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteHeaderMatchProperty#getRegex}
             * @param regex The value sent by the client must include the specified characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regex(java.lang.String regex) {
                this.regex = regex;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteHeaderMatchProperty#getSuffix}
             * @param suffix The value sent by the client must end with the specified characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder suffix(java.lang.String suffix) {
                this.suffix = suffix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpGatewayRouteHeaderMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpGatewayRouteHeaderMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpGatewayRouteHeaderMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpGatewayRouteHeaderMatchProperty {
            private final java.lang.String exact;
            private final java.lang.String prefix;
            private final java.lang.Object range;
            private final java.lang.String regex;
            private final java.lang.String suffix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exact = software.amazon.jsii.Kernel.get(this, "exact", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.range = software.amazon.jsii.Kernel.get(this, "range", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.regex = software.amazon.jsii.Kernel.get(this, "regex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.suffix = software.amazon.jsii.Kernel.get(this, "suffix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exact = builder.exact;
                this.prefix = builder.prefix;
                this.range = builder.range;
                this.regex = builder.regex;
                this.suffix = builder.suffix;
            }

            @Override
            public final java.lang.String getExact() {
                return this.exact;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.Object getRange() {
                return this.range;
            }

            @Override
            public final java.lang.String getRegex() {
                return this.regex;
            }

            @Override
            public final java.lang.String getSuffix() {
                return this.suffix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExact() != null) {
                    data.set("exact", om.valueToTree(this.getExact()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getRange() != null) {
                    data.set("range", om.valueToTree(this.getRange()));
                }
                if (this.getRegex() != null) {
                    data.set("regex", om.valueToTree(this.getRegex()));
                }
                if (this.getSuffix() != null) {
                    data.set("suffix", om.valueToTree(this.getSuffix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpGatewayRouteHeaderMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpGatewayRouteHeaderMatchProperty.Jsii$Proxy that = (HttpGatewayRouteHeaderMatchProperty.Jsii$Proxy) o;

                if (this.exact != null ? !this.exact.equals(that.exact) : that.exact != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                if (this.range != null ? !this.range.equals(that.range) : that.range != null) return false;
                if (this.regex != null ? !this.regex.equals(that.regex) : that.regex != null) return false;
                return this.suffix != null ? this.suffix.equals(that.suffix) : that.suffix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exact != null ? this.exact.hashCode() : 0;
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.range != null ? this.range.hashCode() : 0);
                result = 31 * result + (this.regex != null ? this.regex.hashCode() : 0);
                result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the HTTP header in the gateway route.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpGatewayRouteHeaderProperty httpGatewayRouteHeaderProperty = HttpGatewayRouteHeaderProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .invert(false)
     *         .match(HttpGatewayRouteHeaderMatchProperty.builder()
     *                 .exact("exact")
     *                 .prefix("prefix")
     *                 .range(GatewayRouteRangeMatchProperty.builder()
     *                         .end(123)
     *                         .start(123)
     *                         .build())
     *                 .regex("regex")
     *                 .suffix("suffix")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheader.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheader.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpGatewayRouteHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpGatewayRouteHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpGatewayRouteHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the HTTP header in the gateway route that will be matched on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheader.html#cfn-appmesh-gatewayroute-httpgatewayrouteheader-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheader.html#cfn-appmesh-gatewayroute-httpgatewayrouteheader-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Specify <code>True</code> to match anything except the match criteria.
         * <p>
         * The default value is <code>False</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheader.html#cfn-appmesh-gatewayroute-httpgatewayrouteheader-invert">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheader.html#cfn-appmesh-gatewayroute-httpgatewayrouteheader-invert</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInvert() {
            return null;
        }

        /**
         * An object that represents the method and value to match with the header value sent in a request.
         * <p>
         * Specify one match method.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheader.html#cfn-appmesh-gatewayroute-httpgatewayrouteheader-match">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteheader.html#cfn-appmesh-gatewayroute-httpgatewayrouteheader-match</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMatch() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpGatewayRouteHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpGatewayRouteHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpGatewayRouteHeaderProperty> {
            java.lang.String name;
            java.lang.Object invert;
            java.lang.Object match;

            /**
             * Sets the value of {@link HttpGatewayRouteHeaderProperty#getName}
             * @param name A name for the HTTP header in the gateway route that will be matched on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteHeaderProperty#getInvert}
             * @param invert Specify <code>True</code> to match anything except the match criteria.
             *               The default value is <code>False</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invert(java.lang.Boolean invert) {
                this.invert = invert;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteHeaderProperty#getInvert}
             * @param invert Specify <code>True</code> to match anything except the match criteria.
             *               The default value is <code>False</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invert(software.amazon.awscdk.IResolvable invert) {
                this.invert = invert;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteHeaderProperty#getMatch}
             * @param match An object that represents the method and value to match with the header value sent in a request.
             *              Specify one match method.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.IResolvable match) {
                this.match = match;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteHeaderProperty#getMatch}
             * @param match An object that represents the method and value to match with the header value sent in a request.
             *              Specify one match method.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteHeaderMatchProperty match) {
                this.match = match;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpGatewayRouteHeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpGatewayRouteHeaderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpGatewayRouteHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpGatewayRouteHeaderProperty {
            private final java.lang.String name;
            private final java.lang.Object invert;
            private final java.lang.Object match;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.invert = software.amazon.jsii.Kernel.get(this, "invert", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.match = software.amazon.jsii.Kernel.get(this, "match", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.invert = builder.invert;
                this.match = builder.match;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getInvert() {
                return this.invert;
            }

            @Override
            public final java.lang.Object getMatch() {
                return this.match;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getInvert() != null) {
                    data.set("invert", om.valueToTree(this.getInvert()));
                }
                if (this.getMatch() != null) {
                    data.set("match", om.valueToTree(this.getMatch()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpGatewayRouteHeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpGatewayRouteHeaderProperty.Jsii$Proxy that = (HttpGatewayRouteHeaderProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.invert != null ? !this.invert.equals(that.invert) : that.invert != null) return false;
                return this.match != null ? this.match.equals(that.match) : that.match == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.invert != null ? this.invert.hashCode() : 0);
                result = 31 * result + (this.match != null ? this.match.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the criteria for determining a request match.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpGatewayRouteMatchProperty httpGatewayRouteMatchProperty = HttpGatewayRouteMatchProperty.builder()
     *         .headers(List.of(HttpGatewayRouteHeaderProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .invert(false)
     *                 .match(HttpGatewayRouteHeaderMatchProperty.builder()
     *                         .exact("exact")
     *                         .prefix("prefix")
     *                         .range(GatewayRouteRangeMatchProperty.builder()
     *                                 .end(123)
     *                                 .start(123)
     *                                 .build())
     *                         .regex("regex")
     *                         .suffix("suffix")
     *                         .build())
     *                 .build()))
     *         .hostname(GatewayRouteHostnameMatchProperty.builder()
     *                 .exact("exact")
     *                 .suffix("suffix")
     *                 .build())
     *         .method("method")
     *         .path(HttpPathMatchProperty.builder()
     *                 .exact("exact")
     *                 .regex("regex")
     *                 .build())
     *         .port(123)
     *         .prefix("prefix")
     *         .queryParameters(List.of(QueryParameterProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .match(HttpQueryParameterMatchProperty.builder()
     *                         .exact("exact")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpGatewayRouteMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpGatewayRouteMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpGatewayRouteMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The client request headers to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-headers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-headers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeaders() {
            return null;
        }

        /**
         * The host name to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-hostname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-hostname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHostname() {
            return null;
        }

        /**
         * The method to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-method">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-method</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMethod() {
            return null;
        }

        /**
         * The path to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPath() {
            return null;
        }

        /**
         * The port number to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * Specifies the path to match requests with.
         * <p>
         * This parameter must always start with <code>/</code> , which by itself matches all requests to the virtual service name. You can also match for path-based routing of requests. For example, if your virtual service name is <code>my-service.local</code> and you want the route to match requests to <code>my-service.local/metrics</code> , your prefix should be <code>/metrics</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * The query parameter to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-queryparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutematch.html#cfn-appmesh-gatewayroute-httpgatewayroutematch-queryparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryParameters() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpGatewayRouteMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpGatewayRouteMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpGatewayRouteMatchProperty> {
            java.lang.Object headers;
            java.lang.Object hostname;
            java.lang.String method;
            java.lang.Object path;
            java.lang.Number port;
            java.lang.String prefix;
            java.lang.Object queryParameters;

            /**
             * Sets the value of {@link HttpGatewayRouteMatchProperty#getHeaders}
             * @param headers The client request headers to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(software.amazon.awscdk.IResolvable headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteMatchProperty#getHeaders}
             * @param headers The client request headers to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(java.util.List<? extends java.lang.Object> headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteMatchProperty#getHostname}
             * @param hostname The host name to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostname(software.amazon.awscdk.IResolvable hostname) {
                this.hostname = hostname;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteMatchProperty#getHostname}
             * @param hostname The host name to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostname(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteHostnameMatchProperty hostname) {
                this.hostname = hostname;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteMatchProperty#getMethod}
             * @param method The method to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder method(java.lang.String method) {
                this.method = method;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteMatchProperty#getPath}
             * @param path The path to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(software.amazon.awscdk.IResolvable path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteMatchProperty#getPath}
             * @param path The path to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpPathMatchProperty path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteMatchProperty#getPort}
             * @param port The port number to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteMatchProperty#getPrefix}
             * @param prefix Specifies the path to match requests with.
             *               This parameter must always start with <code>/</code> , which by itself matches all requests to the virtual service name. You can also match for path-based routing of requests. For example, if your virtual service name is <code>my-service.local</code> and you want the route to match requests to <code>my-service.local/metrics</code> , your prefix should be <code>/metrics</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteMatchProperty#getQueryParameters}
             * @param queryParameters The query parameter to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryParameters(software.amazon.awscdk.IResolvable queryParameters) {
                this.queryParameters = queryParameters;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteMatchProperty#getQueryParameters}
             * @param queryParameters The query parameter to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryParameters(java.util.List<? extends java.lang.Object> queryParameters) {
                this.queryParameters = queryParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpGatewayRouteMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpGatewayRouteMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpGatewayRouteMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpGatewayRouteMatchProperty {
            private final java.lang.Object headers;
            private final java.lang.Object hostname;
            private final java.lang.String method;
            private final java.lang.Object path;
            private final java.lang.Number port;
            private final java.lang.String prefix;
            private final java.lang.Object queryParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.hostname = software.amazon.jsii.Kernel.get(this, "hostname", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queryParameters = software.amazon.jsii.Kernel.get(this, "queryParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.headers = builder.headers;
                this.hostname = builder.hostname;
                this.method = builder.method;
                this.path = builder.path;
                this.port = builder.port;
                this.prefix = builder.prefix;
                this.queryParameters = builder.queryParameters;
            }

            @Override
            public final java.lang.Object getHeaders() {
                return this.headers;
            }

            @Override
            public final java.lang.Object getHostname() {
                return this.hostname;
            }

            @Override
            public final java.lang.String getMethod() {
                return this.method;
            }

            @Override
            public final java.lang.Object getPath() {
                return this.path;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.Object getQueryParameters() {
                return this.queryParameters;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHeaders() != null) {
                    data.set("headers", om.valueToTree(this.getHeaders()));
                }
                if (this.getHostname() != null) {
                    data.set("hostname", om.valueToTree(this.getHostname()));
                }
                if (this.getMethod() != null) {
                    data.set("method", om.valueToTree(this.getMethod()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getQueryParameters() != null) {
                    data.set("queryParameters", om.valueToTree(this.getQueryParameters()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpGatewayRouteMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpGatewayRouteMatchProperty.Jsii$Proxy that = (HttpGatewayRouteMatchProperty.Jsii$Proxy) o;

                if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) return false;
                if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) return false;
                if (this.method != null ? !this.method.equals(that.method) : that.method != null) return false;
                if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                return this.queryParameters != null ? this.queryParameters.equals(that.queryParameters) : that.queryParameters == null;
            }

            @Override
            public final int hashCode() {
                int result = this.headers != null ? this.headers.hashCode() : 0;
                result = 31 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
                result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.queryParameters != null ? this.queryParameters.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the path to rewrite.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpGatewayRoutePathRewriteProperty httpGatewayRoutePathRewriteProperty = HttpGatewayRoutePathRewriteProperty.builder()
     *         .exact("exact")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutepathrewrite.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutepathrewrite.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpGatewayRoutePathRewriteProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpGatewayRoutePathRewriteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpGatewayRoutePathRewriteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The exact path to rewrite.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutepathrewrite.html#cfn-appmesh-gatewayroute-httpgatewayroutepathrewrite-exact">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroutepathrewrite.html#cfn-appmesh-gatewayroute-httpgatewayroutepathrewrite-exact</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExact() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpGatewayRoutePathRewriteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpGatewayRoutePathRewriteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpGatewayRoutePathRewriteProperty> {
            java.lang.String exact;

            /**
             * Sets the value of {@link HttpGatewayRoutePathRewriteProperty#getExact}
             * @param exact The exact path to rewrite.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exact(java.lang.String exact) {
                this.exact = exact;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpGatewayRoutePathRewriteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpGatewayRoutePathRewriteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpGatewayRoutePathRewriteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpGatewayRoutePathRewriteProperty {
            private final java.lang.String exact;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exact = software.amazon.jsii.Kernel.get(this, "exact", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exact = builder.exact;
            }

            @Override
            public final java.lang.String getExact() {
                return this.exact;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExact() != null) {
                    data.set("exact", om.valueToTree(this.getExact()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpGatewayRoutePathRewriteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpGatewayRoutePathRewriteProperty.Jsii$Proxy that = (HttpGatewayRoutePathRewriteProperty.Jsii$Proxy) o;

                return this.exact != null ? this.exact.equals(that.exact) : that.exact == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exact != null ? this.exact.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object representing the beginning characters of the route to rewrite.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpGatewayRoutePrefixRewriteProperty httpGatewayRoutePrefixRewriteProperty = HttpGatewayRoutePrefixRewriteProperty.builder()
     *         .defaultPrefix("defaultPrefix")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteprefixrewrite.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteprefixrewrite.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpGatewayRoutePrefixRewriteProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpGatewayRoutePrefixRewriteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpGatewayRoutePrefixRewriteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The default prefix used to replace the incoming route prefix when rewritten.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteprefixrewrite.html#cfn-appmesh-gatewayroute-httpgatewayrouteprefixrewrite-defaultprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteprefixrewrite.html#cfn-appmesh-gatewayroute-httpgatewayrouteprefixrewrite-defaultprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultPrefix() {
            return null;
        }

        /**
         * The value used to replace the incoming route prefix when rewritten.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteprefixrewrite.html#cfn-appmesh-gatewayroute-httpgatewayrouteprefixrewrite-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouteprefixrewrite.html#cfn-appmesh-gatewayroute-httpgatewayrouteprefixrewrite-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpGatewayRoutePrefixRewriteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpGatewayRoutePrefixRewriteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpGatewayRoutePrefixRewriteProperty> {
            java.lang.String defaultPrefix;
            java.lang.String value;

            /**
             * Sets the value of {@link HttpGatewayRoutePrefixRewriteProperty#getDefaultPrefix}
             * @param defaultPrefix The default prefix used to replace the incoming route prefix when rewritten.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultPrefix(java.lang.String defaultPrefix) {
                this.defaultPrefix = defaultPrefix;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRoutePrefixRewriteProperty#getValue}
             * @param value The value used to replace the incoming route prefix when rewritten.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpGatewayRoutePrefixRewriteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpGatewayRoutePrefixRewriteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpGatewayRoutePrefixRewriteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpGatewayRoutePrefixRewriteProperty {
            private final java.lang.String defaultPrefix;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.defaultPrefix = software.amazon.jsii.Kernel.get(this, "defaultPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.defaultPrefix = builder.defaultPrefix;
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getDefaultPrefix() {
                return this.defaultPrefix;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDefaultPrefix() != null) {
                    data.set("defaultPrefix", om.valueToTree(this.getDefaultPrefix()));
                }
                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpGatewayRoutePrefixRewriteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpGatewayRoutePrefixRewriteProperty.Jsii$Proxy that = (HttpGatewayRoutePrefixRewriteProperty.Jsii$Proxy) o;

                if (this.defaultPrefix != null ? !this.defaultPrefix.equals(that.defaultPrefix) : that.defaultPrefix != null) return false;
                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.defaultPrefix != null ? this.defaultPrefix.hashCode() : 0;
                result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents an HTTP gateway route.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpGatewayRouteProperty httpGatewayRouteProperty = HttpGatewayRouteProperty.builder()
     *         .action(HttpGatewayRouteActionProperty.builder()
     *                 .target(GatewayRouteTargetProperty.builder()
     *                         .virtualService(GatewayRouteVirtualServiceProperty.builder()
     *                                 .virtualServiceName("virtualServiceName")
     *                                 .build())
     *                         // the properties below are optional
     *                         .port(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .rewrite(HttpGatewayRouteRewriteProperty.builder()
     *                         .hostname(GatewayRouteHostnameRewriteProperty.builder()
     *                                 .defaultTargetHostname("defaultTargetHostname")
     *                                 .build())
     *                         .path(HttpGatewayRoutePathRewriteProperty.builder()
     *                                 .exact("exact")
     *                                 .build())
     *                         .prefix(HttpGatewayRoutePrefixRewriteProperty.builder()
     *                                 .defaultPrefix("defaultPrefix")
     *                                 .value("value")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .match(HttpGatewayRouteMatchProperty.builder()
     *                 .headers(List.of(HttpGatewayRouteHeaderProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .invert(false)
     *                         .match(HttpGatewayRouteHeaderMatchProperty.builder()
     *                                 .exact("exact")
     *                                 .prefix("prefix")
     *                                 .range(GatewayRouteRangeMatchProperty.builder()
     *                                         .end(123)
     *                                         .start(123)
     *                                         .build())
     *                                 .regex("regex")
     *                                 .suffix("suffix")
     *                                 .build())
     *                         .build()))
     *                 .hostname(GatewayRouteHostnameMatchProperty.builder()
     *                         .exact("exact")
     *                         .suffix("suffix")
     *                         .build())
     *                 .method("method")
     *                 .path(HttpPathMatchProperty.builder()
     *                         .exact("exact")
     *                         .regex("regex")
     *                         .build())
     *                 .port(123)
     *                 .prefix("prefix")
     *                 .queryParameters(List.of(QueryParameterProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .match(HttpQueryParameterMatchProperty.builder()
     *                                 .exact("exact")
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpGatewayRouteProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpGatewayRouteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpGatewayRouteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents the action to take if a match is determined.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroute.html#cfn-appmesh-gatewayroute-httpgatewayroute-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroute.html#cfn-appmesh-gatewayroute-httpgatewayroute-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAction();

        /**
         * An object that represents the criteria for determining a request match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroute.html#cfn-appmesh-gatewayroute-httpgatewayroute-match">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayroute.html#cfn-appmesh-gatewayroute-httpgatewayroute-match</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMatch();

        /**
         * @return a {@link Builder} of {@link HttpGatewayRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpGatewayRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpGatewayRouteProperty> {
            java.lang.Object action;
            java.lang.Object match;

            /**
             * Sets the value of {@link HttpGatewayRouteProperty#getAction}
             * @param action An object that represents the action to take if a match is determined. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.IResolvable action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteProperty#getAction}
             * @param action An object that represents the action to take if a match is determined. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteActionProperty action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteProperty#getMatch}
             * @param match An object that represents the criteria for determining a request match. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.IResolvable match) {
                this.match = match;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteProperty#getMatch}
             * @param match An object that represents the criteria for determining a request match. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRouteMatchProperty match) {
                this.match = match;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpGatewayRouteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpGatewayRouteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpGatewayRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpGatewayRouteProperty {
            private final java.lang.Object action;
            private final java.lang.Object match;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.match = software.amazon.jsii.Kernel.get(this, "match", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.match = java.util.Objects.requireNonNull(builder.match, "match is required");
            }

            @Override
            public final java.lang.Object getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Object getMatch() {
                return this.match;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("match", om.valueToTree(this.getMatch()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpGatewayRouteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpGatewayRouteProperty.Jsii$Proxy that = (HttpGatewayRouteProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                return this.match.equals(that.match);
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.match.hashCode());
                return result;
            }
        }
    }
    /**
     * An object representing the gateway route to rewrite.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpGatewayRouteRewriteProperty httpGatewayRouteRewriteProperty = HttpGatewayRouteRewriteProperty.builder()
     *         .hostname(GatewayRouteHostnameRewriteProperty.builder()
     *                 .defaultTargetHostname("defaultTargetHostname")
     *                 .build())
     *         .path(HttpGatewayRoutePathRewriteProperty.builder()
     *                 .exact("exact")
     *                 .build())
     *         .prefix(HttpGatewayRoutePrefixRewriteProperty.builder()
     *                 .defaultPrefix("defaultPrefix")
     *                 .value("value")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouterewrite.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouterewrite.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpGatewayRouteRewriteProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpGatewayRouteRewriteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpGatewayRouteRewriteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The host name to rewrite.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouterewrite.html#cfn-appmesh-gatewayroute-httpgatewayrouterewrite-hostname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouterewrite.html#cfn-appmesh-gatewayroute-httpgatewayrouterewrite-hostname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHostname() {
            return null;
        }

        /**
         * The path to rewrite.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouterewrite.html#cfn-appmesh-gatewayroute-httpgatewayrouterewrite-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouterewrite.html#cfn-appmesh-gatewayroute-httpgatewayrouterewrite-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPath() {
            return null;
        }

        /**
         * The specified beginning characters to rewrite.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouterewrite.html#cfn-appmesh-gatewayroute-httpgatewayrouterewrite-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpgatewayrouterewrite.html#cfn-appmesh-gatewayroute-httpgatewayrouterewrite-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpGatewayRouteRewriteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpGatewayRouteRewriteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpGatewayRouteRewriteProperty> {
            java.lang.Object hostname;
            java.lang.Object path;
            java.lang.Object prefix;

            /**
             * Sets the value of {@link HttpGatewayRouteRewriteProperty#getHostname}
             * @param hostname The host name to rewrite.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostname(software.amazon.awscdk.IResolvable hostname) {
                this.hostname = hostname;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteRewriteProperty#getHostname}
             * @param hostname The host name to rewrite.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hostname(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteHostnameRewriteProperty hostname) {
                this.hostname = hostname;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteRewriteProperty#getPath}
             * @param path The path to rewrite.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(software.amazon.awscdk.IResolvable path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteRewriteProperty#getPath}
             * @param path The path to rewrite.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePathRewriteProperty path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteRewriteProperty#getPrefix}
             * @param prefix The specified beginning characters to rewrite.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(software.amazon.awscdk.IResolvable prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link HttpGatewayRouteRewriteProperty#getPrefix}
             * @param prefix The specified beginning characters to rewrite.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpGatewayRoutePrefixRewriteProperty prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpGatewayRouteRewriteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpGatewayRouteRewriteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpGatewayRouteRewriteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpGatewayRouteRewriteProperty {
            private final java.lang.Object hostname;
            private final java.lang.Object path;
            private final java.lang.Object prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hostname = software.amazon.jsii.Kernel.get(this, "hostname", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hostname = builder.hostname;
                this.path = builder.path;
                this.prefix = builder.prefix;
            }

            @Override
            public final java.lang.Object getHostname() {
                return this.hostname;
            }

            @Override
            public final java.lang.Object getPath() {
                return this.path;
            }

            @Override
            public final java.lang.Object getPrefix() {
                return this.prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHostname() != null) {
                    data.set("hostname", om.valueToTree(this.getHostname()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpGatewayRouteRewriteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpGatewayRouteRewriteProperty.Jsii$Proxy that = (HttpGatewayRouteRewriteProperty.Jsii$Proxy) o;

                if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) return false;
                if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hostname != null ? this.hostname.hashCode() : 0;
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object representing the path to match in the request.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpPathMatchProperty httpPathMatchProperty = HttpPathMatchProperty.builder()
     *         .exact("exact")
     *         .regex("regex")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httppathmatch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httppathmatch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpPathMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpPathMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpPathMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The exact path to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httppathmatch.html#cfn-appmesh-gatewayroute-httppathmatch-exact">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httppathmatch.html#cfn-appmesh-gatewayroute-httppathmatch-exact</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExact() {
            return null;
        }

        /**
         * The regex used to match the path.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httppathmatch.html#cfn-appmesh-gatewayroute-httppathmatch-regex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httppathmatch.html#cfn-appmesh-gatewayroute-httppathmatch-regex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegex() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpPathMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpPathMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpPathMatchProperty> {
            java.lang.String exact;
            java.lang.String regex;

            /**
             * Sets the value of {@link HttpPathMatchProperty#getExact}
             * @param exact The exact path to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exact(java.lang.String exact) {
                this.exact = exact;
                return this;
            }

            /**
             * Sets the value of {@link HttpPathMatchProperty#getRegex}
             * @param regex The regex used to match the path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regex(java.lang.String regex) {
                this.regex = regex;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpPathMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpPathMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpPathMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpPathMatchProperty {
            private final java.lang.String exact;
            private final java.lang.String regex;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exact = software.amazon.jsii.Kernel.get(this, "exact", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.regex = software.amazon.jsii.Kernel.get(this, "regex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exact = builder.exact;
                this.regex = builder.regex;
            }

            @Override
            public final java.lang.String getExact() {
                return this.exact;
            }

            @Override
            public final java.lang.String getRegex() {
                return this.regex;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExact() != null) {
                    data.set("exact", om.valueToTree(this.getExact()));
                }
                if (this.getRegex() != null) {
                    data.set("regex", om.valueToTree(this.getRegex()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpPathMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpPathMatchProperty.Jsii$Proxy that = (HttpPathMatchProperty.Jsii$Proxy) o;

                if (this.exact != null ? !this.exact.equals(that.exact) : that.exact != null) return false;
                return this.regex != null ? this.regex.equals(that.regex) : that.regex == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exact != null ? this.exact.hashCode() : 0;
                result = 31 * result + (this.regex != null ? this.regex.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object representing the query parameter to match.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpQueryParameterMatchProperty httpQueryParameterMatchProperty = HttpQueryParameterMatchProperty.builder()
     *         .exact("exact")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpqueryparametermatch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpqueryparametermatch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpQueryParameterMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpQueryParameterMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpQueryParameterMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The exact query parameter to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpqueryparametermatch.html#cfn-appmesh-gatewayroute-httpqueryparametermatch-exact">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-httpqueryparametermatch.html#cfn-appmesh-gatewayroute-httpqueryparametermatch-exact</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExact() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpQueryParameterMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpQueryParameterMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpQueryParameterMatchProperty> {
            java.lang.String exact;

            /**
             * Sets the value of {@link HttpQueryParameterMatchProperty#getExact}
             * @param exact The exact query parameter to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exact(java.lang.String exact) {
                this.exact = exact;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpQueryParameterMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpQueryParameterMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpQueryParameterMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpQueryParameterMatchProperty {
            private final java.lang.String exact;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exact = software.amazon.jsii.Kernel.get(this, "exact", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exact = builder.exact;
            }

            @Override
            public final java.lang.String getExact() {
                return this.exact;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExact() != null) {
                    data.set("exact", om.valueToTree(this.getExact()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.HttpQueryParameterMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpQueryParameterMatchProperty.Jsii$Proxy that = (HttpQueryParameterMatchProperty.Jsii$Proxy) o;

                return this.exact != null ? this.exact.equals(that.exact) : that.exact == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exact != null ? this.exact.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents the query parameter in the request.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * QueryParameterProperty queryParameterProperty = QueryParameterProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .match(HttpQueryParameterMatchProperty.builder()
     *                 .exact("exact")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-queryparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-queryparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRoute.QueryParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(QueryParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the query parameter that will be matched on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-queryparameter.html#cfn-appmesh-gatewayroute-queryparameter-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-queryparameter.html#cfn-appmesh-gatewayroute-queryparameter-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The query parameter to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-queryparameter.html#cfn-appmesh-gatewayroute-queryparameter-match">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-gatewayroute-queryparameter.html#cfn-appmesh-gatewayroute-queryparameter-match</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMatch() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link QueryParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueryParameterProperty> {
            java.lang.String name;
            java.lang.Object match;

            /**
             * Sets the value of {@link QueryParameterProperty#getName}
             * @param name A name for the query parameter that will be matched on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link QueryParameterProperty#getMatch}
             * @param match The query parameter to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.IResolvable match) {
                this.match = match;
                return this;
            }

            /**
             * Sets the value of {@link QueryParameterProperty#getMatch}
             * @param match The query parameter to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.HttpQueryParameterMatchProperty match) {
                this.match = match;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueryParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueryParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryParameterProperty {
            private final java.lang.String name;
            private final java.lang.Object match;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.match = software.amazon.jsii.Kernel.get(this, "match", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.match = builder.match;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getMatch() {
                return this.match;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getMatch() != null) {
                    data.set("match", om.valueToTree(this.getMatch()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRoute.QueryParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryParameterProperty.Jsii$Proxy that = (QueryParameterProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.match != null ? this.match.equals(that.match) : that.match == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.match != null ? this.match.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appmesh.CfnGatewayRoute}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appmesh.CfnGatewayRoute> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appmesh.CfnGatewayRouteProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appmesh.CfnGatewayRouteProps.Builder();
        }

        /**
         * The name of the service mesh that the resource resides in.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-meshname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-meshname</a>
         * @param meshName The name of the service mesh that the resource resides in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshName(final java.lang.String meshName) {
            this.props.meshName(meshName);
            return this;
        }

        /**
         * The specifications of the gateway route.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-spec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-spec</a>
         * @param spec The specifications of the gateway route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spec(final software.amazon.awscdk.IResolvable spec) {
            this.props.spec(spec);
            return this;
        }
        /**
         * The specifications of the gateway route.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-spec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-spec</a>
         * @param spec The specifications of the gateway route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spec(final software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteSpecProperty spec) {
            this.props.spec(spec);
            return this;
        }

        /**
         * The virtual gateway that the gateway route is associated with.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-virtualgatewayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-virtualgatewayname</a>
         * @param virtualGatewayName The virtual gateway that the gateway route is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualGatewayName(final java.lang.String virtualGatewayName) {
            this.props.virtualGatewayName(virtualGatewayName);
            return this;
        }

        /**
         * The name of the gateway route.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-gatewayroutename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-gatewayroutename</a>
         * @param gatewayRouteName The name of the gateway route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayRouteName(final java.lang.String gatewayRouteName) {
            this.props.gatewayRouteName(gatewayRouteName);
            return this;
        }

        /**
         * The AWS IAM account ID of the service mesh owner.
         * <p>
         * If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-meshowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-meshowner</a>
         * @param meshOwner The AWS IAM account ID of the service mesh owner. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshOwner(final java.lang.String meshOwner) {
            this.props.meshOwner(meshOwner);
            return this;
        }

        /**
         * Optional metadata that you can apply to the gateway route to assist with categorization and organization.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-tags</a>
         * @param tags Optional metadata that you can apply to the gateway route to assist with categorization and organization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appmesh.CfnGatewayRoute}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appmesh.CfnGatewayRoute build() {
            return new software.amazon.awscdk.services.appmesh.CfnGatewayRoute(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
