package software.amazon.awscdk.services.appmesh;

/**
 * Creates a route that is associated with a virtual router.
 * <p>
 * You can route several different protocols and define a retry policy for a route. Traffic can be routed to one or more virtual nodes.
 * <p>
 * For more information about routes, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/routes.html">Routes</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * CfnRoute cfnRoute = CfnRoute.Builder.create(this, "MyCfnRoute")
 *         .meshName("meshName")
 *         .spec(RouteSpecProperty.builder()
 *                 .grpcRoute(GrpcRouteProperty.builder()
 *                         .action(GrpcRouteActionProperty.builder()
 *                                 .weightedTargets(List.of(WeightedTargetProperty.builder()
 *                                         .virtualNode("virtualNode")
 *                                         .weight(123)
 *                                         // the properties below are optional
 *                                         .port(123)
 *                                         .build()))
 *                                 .build())
 *                         .match(GrpcRouteMatchProperty.builder()
 *                                 .metadata(List.of(GrpcRouteMetadataProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .invert(false)
 *                                         .match(GrpcRouteMetadataMatchMethodProperty.builder()
 *                                                 .exact("exact")
 *                                                 .prefix("prefix")
 *                                                 .range(MatchRangeProperty.builder()
 *                                                         .end(123)
 *                                                         .start(123)
 *                                                         .build())
 *                                                 .regex("regex")
 *                                                 .suffix("suffix")
 *                                                 .build())
 *                                         .build()))
 *                                 .methodName("methodName")
 *                                 .port(123)
 *                                 .serviceName("serviceName")
 *                                 .build())
 *                         // the properties below are optional
 *                         .retryPolicy(GrpcRetryPolicyProperty.builder()
 *                                 .maxRetries(123)
 *                                 .perRetryTimeout(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .grpcRetryEvents(List.of("grpcRetryEvents"))
 *                                 .httpRetryEvents(List.of("httpRetryEvents"))
 *                                 .tcpRetryEvents(List.of("tcpRetryEvents"))
 *                                 .build())
 *                         .timeout(GrpcTimeoutProperty.builder()
 *                                 .idle(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .perRequest(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .http2Route(HttpRouteProperty.builder()
 *                         .action(HttpRouteActionProperty.builder()
 *                                 .weightedTargets(List.of(WeightedTargetProperty.builder()
 *                                         .virtualNode("virtualNode")
 *                                         .weight(123)
 *                                         // the properties below are optional
 *                                         .port(123)
 *                                         .build()))
 *                                 .build())
 *                         .match(HttpRouteMatchProperty.builder()
 *                                 .headers(List.of(HttpRouteHeaderProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .invert(false)
 *                                         .match(HeaderMatchMethodProperty.builder()
 *                                                 .exact("exact")
 *                                                 .prefix("prefix")
 *                                                 .range(MatchRangeProperty.builder()
 *                                                         .end(123)
 *                                                         .start(123)
 *                                                         .build())
 *                                                 .regex("regex")
 *                                                 .suffix("suffix")
 *                                                 .build())
 *                                         .build()))
 *                                 .method("method")
 *                                 .path(HttpPathMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .regex("regex")
 *                                         .build())
 *                                 .port(123)
 *                                 .prefix("prefix")
 *                                 .queryParameters(List.of(QueryParameterProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .match(HttpQueryParameterMatchProperty.builder()
 *                                                 .exact("exact")
 *                                                 .build())
 *                                         .build()))
 *                                 .scheme("scheme")
 *                                 .build())
 *                         // the properties below are optional
 *                         .retryPolicy(HttpRetryPolicyProperty.builder()
 *                                 .maxRetries(123)
 *                                 .perRetryTimeout(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .httpRetryEvents(List.of("httpRetryEvents"))
 *                                 .tcpRetryEvents(List.of("tcpRetryEvents"))
 *                                 .build())
 *                         .timeout(HttpTimeoutProperty.builder()
 *                                 .idle(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .perRequest(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .httpRoute(HttpRouteProperty.builder()
 *                         .action(HttpRouteActionProperty.builder()
 *                                 .weightedTargets(List.of(WeightedTargetProperty.builder()
 *                                         .virtualNode("virtualNode")
 *                                         .weight(123)
 *                                         // the properties below are optional
 *                                         .port(123)
 *                                         .build()))
 *                                 .build())
 *                         .match(HttpRouteMatchProperty.builder()
 *                                 .headers(List.of(HttpRouteHeaderProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .invert(false)
 *                                         .match(HeaderMatchMethodProperty.builder()
 *                                                 .exact("exact")
 *                                                 .prefix("prefix")
 *                                                 .range(MatchRangeProperty.builder()
 *                                                         .end(123)
 *                                                         .start(123)
 *                                                         .build())
 *                                                 .regex("regex")
 *                                                 .suffix("suffix")
 *                                                 .build())
 *                                         .build()))
 *                                 .method("method")
 *                                 .path(HttpPathMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .regex("regex")
 *                                         .build())
 *                                 .port(123)
 *                                 .prefix("prefix")
 *                                 .queryParameters(List.of(QueryParameterProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .match(HttpQueryParameterMatchProperty.builder()
 *                                                 .exact("exact")
 *                                                 .build())
 *                                         .build()))
 *                                 .scheme("scheme")
 *                                 .build())
 *                         // the properties below are optional
 *                         .retryPolicy(HttpRetryPolicyProperty.builder()
 *                                 .maxRetries(123)
 *                                 .perRetryTimeout(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .httpRetryEvents(List.of("httpRetryEvents"))
 *                                 .tcpRetryEvents(List.of("tcpRetryEvents"))
 *                                 .build())
 *                         .timeout(HttpTimeoutProperty.builder()
 *                                 .idle(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .perRequest(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .priority(123)
 *                 .tcpRoute(TcpRouteProperty.builder()
 *                         .action(TcpRouteActionProperty.builder()
 *                                 .weightedTargets(List.of(WeightedTargetProperty.builder()
 *                                         .virtualNode("virtualNode")
 *                                         .weight(123)
 *                                         // the properties below are optional
 *                                         .port(123)
 *                                         .build()))
 *                                 .build())
 *                         // the properties below are optional
 *                         .match(TcpRouteMatchProperty.builder()
 *                                 .port(123)
 *                                 .build())
 *                         .timeout(TcpTimeoutProperty.builder()
 *                                 .idle(DurationProperty.builder()
 *                                         .unit("unit")
 *                                         .value(123)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .virtualRouterName("virtualRouterName")
 *         // the properties below are optional
 *         .meshOwner("meshOwner")
 *         .routeName("routeName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:11.057Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute")
public class CfnRoute extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnRoute(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnRoute(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appmesh.CfnRoute.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnRoute(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.CfnRouteProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The full Amazon Resource Name (ARN) for the route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the service mesh that the route resides in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMeshName() {
        return software.amazon.jsii.Kernel.get(this, "attrMeshName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS IAM account ID of the service mesh owner.
     * <p>
     * If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrMeshOwner() {
        return software.amazon.jsii.Kernel.get(this, "attrMeshOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS IAM account ID of the resource owner.
     * <p>
     * If the account ID is not your own, then it's the ID of the mesh owner or of another account that the mesh is shared with. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with Shared Meshes</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrResourceOwner() {
        return software.amazon.jsii.Kernel.get(this, "attrResourceOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRouteName() {
        return software.amazon.jsii.Kernel.get(this, "attrRouteName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier for the route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUid() {
        return software.amazon.jsii.Kernel.get(this, "attrUid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the virtual router that the route is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVirtualRouterName() {
        return software.amazon.jsii.Kernel.get(this, "attrVirtualRouterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the service mesh to create the route in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMeshName() {
        return software.amazon.jsii.Kernel.get(this, "meshName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the service mesh to create the route in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMeshName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "meshName", java.util.Objects.requireNonNull(value, "meshName is required"));
    }

    /**
     * The route specification to apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSpec() {
        return software.amazon.jsii.Kernel.get(this, "spec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The route specification to apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpec(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "spec", java.util.Objects.requireNonNull(value, "spec is required"));
    }

    /**
     * The route specification to apply.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSpec(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.CfnRoute.RouteSpecProperty value) {
        software.amazon.jsii.Kernel.set(this, "spec", java.util.Objects.requireNonNull(value, "spec is required"));
    }

    /**
     * The name of the virtual router in which to create the route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getVirtualRouterName() {
        return software.amazon.jsii.Kernel.get(this, "virtualRouterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the virtual router in which to create the route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVirtualRouterName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "virtualRouterName", java.util.Objects.requireNonNull(value, "virtualRouterName is required"));
    }

    /**
     * The AWS IAM account ID of the service mesh owner.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getMeshOwner() {
        return software.amazon.jsii.Kernel.get(this, "meshOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS IAM account ID of the service mesh owner.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMeshOwner(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "meshOwner", value);
    }

    /**
     * The name to use for the route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRouteName() {
        return software.amazon.jsii.Kernel.get(this, "routeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name to use for the route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRouteName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "routeName", value);
    }

    /**
     * Optional metadata that you can apply to the route to assist with categorization and organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Optional metadata that you can apply to the route to assist with categorization and organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * An object that represents a duration of time.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * DurationProperty durationProperty = DurationProperty.builder()
     *         .unit("unit")
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-duration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-duration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.DurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A unit of time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-duration.html#cfn-appmesh-route-duration-unit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-duration.html#cfn-appmesh-route-duration-unit</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUnit();

        /**
         * A number of time units.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-duration.html#cfn-appmesh-route-duration-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-duration.html#cfn-appmesh-route-duration-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getValue();

        /**
         * @return a {@link Builder} of {@link DurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DurationProperty> {
            java.lang.String unit;
            java.lang.Number value;

            /**
             * Sets the value of {@link DurationProperty#getUnit}
             * @param unit A unit of time. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unit(java.lang.String unit) {
                this.unit = unit;
                return this;
            }

            /**
             * Sets the value of {@link DurationProperty#getValue}
             * @param value A number of time units. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DurationProperty {
            private final java.lang.String unit;
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.unit = software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.unit = java.util.Objects.requireNonNull(builder.unit, "unit is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getUnit() {
                return this.unit;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("unit", om.valueToTree(this.getUnit()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.DurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DurationProperty.Jsii$Proxy that = (DurationProperty.Jsii$Proxy) o;

                if (!unit.equals(that.unit)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.unit.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * An object that represents a retry policy.
     * <p>
     * Specify at least one value for at least one of the types of <code>RetryEvents</code> , a value for <code>maxRetries</code> , and a value for <code>perRetryTimeout</code> . Both <code>server-error</code> and <code>gateway-error</code> under <code>httpRetryEvents</code> include the Envoy <code>reset</code> policy. For more information on the <code>reset</code> policy, see the <a href="https://docs.aws.amazon.com/https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_filters/router_filter#x-envoy-retry-on">Envoy documentation</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GrpcRetryPolicyProperty grpcRetryPolicyProperty = GrpcRetryPolicyProperty.builder()
     *         .maxRetries(123)
     *         .perRetryTimeout(DurationProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         // the properties below are optional
     *         .grpcRetryEvents(List.of("grpcRetryEvents"))
     *         .httpRetryEvents(List.of("httpRetryEvents"))
     *         .tcpRetryEvents(List.of("tcpRetryEvents"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.GrpcRetryPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(GrpcRetryPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrpcRetryPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of retry attempts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-maxretries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-maxretries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxRetries();

        /**
         * The timeout for each retry attempt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-perretrytimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-perretrytimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPerRetryTimeout();

        /**
         * Specify at least one of the valid values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-grpcretryevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-grpcretryevents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGrpcRetryEvents() {
            return null;
        }

        /**
         * Specify at least one of the following values.
         * <p>
         * <ul>
         * <li><em>server-error</em> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511</li>
         * <li><em>gateway-error</em> – HTTP status codes 502, 503, and 504</li>
         * <li><em>client-error</em> – HTTP status code 409</li>
         * <li><em>stream-error</em> – Retry on refused stream</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-httpretryevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-httpretryevents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHttpRetryEvents() {
            return null;
        }

        /**
         * Specify a valid value.
         * <p>
         * The event occurs before any processing of a request has started and is encountered when the upstream is temporarily or permanently unavailable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-tcpretryevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcretrypolicy.html#cfn-appmesh-route-grpcretrypolicy-tcpretryevents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTcpRetryEvents() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GrpcRetryPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrpcRetryPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrpcRetryPolicyProperty> {
            java.lang.Number maxRetries;
            java.lang.Object perRetryTimeout;
            java.util.List<java.lang.String> grpcRetryEvents;
            java.util.List<java.lang.String> httpRetryEvents;
            java.util.List<java.lang.String> tcpRetryEvents;

            /**
             * Sets the value of {@link GrpcRetryPolicyProperty#getMaxRetries}
             * @param maxRetries The maximum number of retry attempts. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRetries(java.lang.Number maxRetries) {
                this.maxRetries = maxRetries;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRetryPolicyProperty#getPerRetryTimeout}
             * @param perRetryTimeout The timeout for each retry attempt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perRetryTimeout(software.amazon.awscdk.IResolvable perRetryTimeout) {
                this.perRetryTimeout = perRetryTimeout;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRetryPolicyProperty#getPerRetryTimeout}
             * @param perRetryTimeout The timeout for each retry attempt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perRetryTimeout(software.amazon.awscdk.services.appmesh.CfnRoute.DurationProperty perRetryTimeout) {
                this.perRetryTimeout = perRetryTimeout;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRetryPolicyProperty#getGrpcRetryEvents}
             * @param grpcRetryEvents Specify at least one of the valid values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grpcRetryEvents(java.util.List<java.lang.String> grpcRetryEvents) {
                this.grpcRetryEvents = grpcRetryEvents;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRetryPolicyProperty#getHttpRetryEvents}
             * @param httpRetryEvents Specify at least one of the following values.
             *                        <ul>
             *                        <li><em>server-error</em> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511</li>
             *                        <li><em>gateway-error</em> – HTTP status codes 502, 503, and 504</li>
             *                        <li><em>client-error</em> – HTTP status code 409</li>
             *                        <li><em>stream-error</em> – Retry on refused stream</li>
             *                        </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpRetryEvents(java.util.List<java.lang.String> httpRetryEvents) {
                this.httpRetryEvents = httpRetryEvents;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRetryPolicyProperty#getTcpRetryEvents}
             * @param tcpRetryEvents Specify a valid value.
             *                       The event occurs before any processing of a request has started and is encountered when the upstream is temporarily or permanently unavailable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tcpRetryEvents(java.util.List<java.lang.String> tcpRetryEvents) {
                this.tcpRetryEvents = tcpRetryEvents;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrpcRetryPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrpcRetryPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrpcRetryPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcRetryPolicyProperty {
            private final java.lang.Number maxRetries;
            private final java.lang.Object perRetryTimeout;
            private final java.util.List<java.lang.String> grpcRetryEvents;
            private final java.util.List<java.lang.String> httpRetryEvents;
            private final java.util.List<java.lang.String> tcpRetryEvents;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxRetries = software.amazon.jsii.Kernel.get(this, "maxRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.perRetryTimeout = software.amazon.jsii.Kernel.get(this, "perRetryTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.grpcRetryEvents = software.amazon.jsii.Kernel.get(this, "grpcRetryEvents", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.httpRetryEvents = software.amazon.jsii.Kernel.get(this, "httpRetryEvents", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.tcpRetryEvents = software.amazon.jsii.Kernel.get(this, "tcpRetryEvents", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxRetries = java.util.Objects.requireNonNull(builder.maxRetries, "maxRetries is required");
                this.perRetryTimeout = java.util.Objects.requireNonNull(builder.perRetryTimeout, "perRetryTimeout is required");
                this.grpcRetryEvents = builder.grpcRetryEvents;
                this.httpRetryEvents = builder.httpRetryEvents;
                this.tcpRetryEvents = builder.tcpRetryEvents;
            }

            @Override
            public final java.lang.Number getMaxRetries() {
                return this.maxRetries;
            }

            @Override
            public final java.lang.Object getPerRetryTimeout() {
                return this.perRetryTimeout;
            }

            @Override
            public final java.util.List<java.lang.String> getGrpcRetryEvents() {
                return this.grpcRetryEvents;
            }

            @Override
            public final java.util.List<java.lang.String> getHttpRetryEvents() {
                return this.httpRetryEvents;
            }

            @Override
            public final java.util.List<java.lang.String> getTcpRetryEvents() {
                return this.tcpRetryEvents;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxRetries", om.valueToTree(this.getMaxRetries()));
                data.set("perRetryTimeout", om.valueToTree(this.getPerRetryTimeout()));
                if (this.getGrpcRetryEvents() != null) {
                    data.set("grpcRetryEvents", om.valueToTree(this.getGrpcRetryEvents()));
                }
                if (this.getHttpRetryEvents() != null) {
                    data.set("httpRetryEvents", om.valueToTree(this.getHttpRetryEvents()));
                }
                if (this.getTcpRetryEvents() != null) {
                    data.set("tcpRetryEvents", om.valueToTree(this.getTcpRetryEvents()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.GrpcRetryPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrpcRetryPolicyProperty.Jsii$Proxy that = (GrpcRetryPolicyProperty.Jsii$Proxy) o;

                if (!maxRetries.equals(that.maxRetries)) return false;
                if (!perRetryTimeout.equals(that.perRetryTimeout)) return false;
                if (this.grpcRetryEvents != null ? !this.grpcRetryEvents.equals(that.grpcRetryEvents) : that.grpcRetryEvents != null) return false;
                if (this.httpRetryEvents != null ? !this.httpRetryEvents.equals(that.httpRetryEvents) : that.httpRetryEvents != null) return false;
                return this.tcpRetryEvents != null ? this.tcpRetryEvents.equals(that.tcpRetryEvents) : that.tcpRetryEvents == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxRetries.hashCode();
                result = 31 * result + (this.perRetryTimeout.hashCode());
                result = 31 * result + (this.grpcRetryEvents != null ? this.grpcRetryEvents.hashCode() : 0);
                result = 31 * result + (this.httpRetryEvents != null ? this.httpRetryEvents.hashCode() : 0);
                result = 31 * result + (this.tcpRetryEvents != null ? this.tcpRetryEvents.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the action to take if a match is determined.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GrpcRouteActionProperty grpcRouteActionProperty = GrpcRouteActionProperty.builder()
     *         .weightedTargets(List.of(WeightedTargetProperty.builder()
     *                 .virtualNode("virtualNode")
     *                 .weight(123)
     *                 // the properties below are optional
     *                 .port(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcrouteaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcrouteaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.GrpcRouteActionProperty")
    @software.amazon.jsii.Jsii.Proxy(GrpcRouteActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrpcRouteActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents the targets that traffic is routed to when a request matches the route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcrouteaction.html#cfn-appmesh-route-grpcrouteaction-weightedtargets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcrouteaction.html#cfn-appmesh-route-grpcrouteaction-weightedtargets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getWeightedTargets();

        /**
         * @return a {@link Builder} of {@link GrpcRouteActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrpcRouteActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrpcRouteActionProperty> {
            java.lang.Object weightedTargets;

            /**
             * Sets the value of {@link GrpcRouteActionProperty#getWeightedTargets}
             * @param weightedTargets An object that represents the targets that traffic is routed to when a request matches the route. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weightedTargets(software.amazon.awscdk.IResolvable weightedTargets) {
                this.weightedTargets = weightedTargets;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteActionProperty#getWeightedTargets}
             * @param weightedTargets An object that represents the targets that traffic is routed to when a request matches the route. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weightedTargets(java.util.List<? extends java.lang.Object> weightedTargets) {
                this.weightedTargets = weightedTargets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrpcRouteActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrpcRouteActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrpcRouteActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcRouteActionProperty {
            private final java.lang.Object weightedTargets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.weightedTargets = software.amazon.jsii.Kernel.get(this, "weightedTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.weightedTargets = java.util.Objects.requireNonNull(builder.weightedTargets, "weightedTargets is required");
            }

            @Override
            public final java.lang.Object getWeightedTargets() {
                return this.weightedTargets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("weightedTargets", om.valueToTree(this.getWeightedTargets()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.GrpcRouteActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrpcRouteActionProperty.Jsii$Proxy that = (GrpcRouteActionProperty.Jsii$Proxy) o;

                return this.weightedTargets.equals(that.weightedTargets);
            }

            @Override
            public final int hashCode() {
                int result = this.weightedTargets.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents the criteria for determining a request match.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GrpcRouteMatchProperty grpcRouteMatchProperty = GrpcRouteMatchProperty.builder()
     *         .metadata(List.of(GrpcRouteMetadataProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .invert(false)
     *                 .match(GrpcRouteMetadataMatchMethodProperty.builder()
     *                         .exact("exact")
     *                         .prefix("prefix")
     *                         .range(MatchRangeProperty.builder()
     *                                 .end(123)
     *                                 .start(123)
     *                                 .build())
     *                         .regex("regex")
     *                         .suffix("suffix")
     *                         .build())
     *                 .build()))
     *         .methodName("methodName")
     *         .port(123)
     *         .serviceName("serviceName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.GrpcRouteMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(GrpcRouteMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrpcRouteMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents the data to match from the request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html#cfn-appmesh-route-grpcroutematch-metadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html#cfn-appmesh-route-grpcroutematch-metadata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMetadata() {
            return null;
        }

        /**
         * The method name to match from the request.
         * <p>
         * If you specify a name, you must also specify a <code>serviceName</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html#cfn-appmesh-route-grpcroutematch-methodname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html#cfn-appmesh-route-grpcroutematch-methodname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMethodName() {
            return null;
        }

        /**
         * The port number to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html#cfn-appmesh-route-grpcroutematch-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html#cfn-appmesh-route-grpcroutematch-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * The fully qualified domain name for the service to match from the request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html#cfn-appmesh-route-grpcroutematch-servicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutematch.html#cfn-appmesh-route-grpcroutematch-servicename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GrpcRouteMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrpcRouteMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrpcRouteMatchProperty> {
            java.lang.Object metadata;
            java.lang.String methodName;
            java.lang.Number port;
            java.lang.String serviceName;

            /**
             * Sets the value of {@link GrpcRouteMatchProperty#getMetadata}
             * @param metadata An object that represents the data to match from the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadata(software.amazon.awscdk.IResolvable metadata) {
                this.metadata = metadata;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteMatchProperty#getMetadata}
             * @param metadata An object that represents the data to match from the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadata(java.util.List<? extends java.lang.Object> metadata) {
                this.metadata = metadata;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteMatchProperty#getMethodName}
             * @param methodName The method name to match from the request.
             *                   If you specify a name, you must also specify a <code>serviceName</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder methodName(java.lang.String methodName) {
                this.methodName = methodName;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteMatchProperty#getPort}
             * @param port The port number to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteMatchProperty#getServiceName}
             * @param serviceName The fully qualified domain name for the service to match from the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceName(java.lang.String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrpcRouteMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrpcRouteMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrpcRouteMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcRouteMatchProperty {
            private final java.lang.Object metadata;
            private final java.lang.String methodName;
            private final java.lang.Number port;
            private final java.lang.String serviceName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metadata = software.amazon.jsii.Kernel.get(this, "metadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.methodName = software.amazon.jsii.Kernel.get(this, "methodName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metadata = builder.metadata;
                this.methodName = builder.methodName;
                this.port = builder.port;
                this.serviceName = builder.serviceName;
            }

            @Override
            public final java.lang.Object getMetadata() {
                return this.metadata;
            }

            @Override
            public final java.lang.String getMethodName() {
                return this.methodName;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getServiceName() {
                return this.serviceName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMetadata() != null) {
                    data.set("metadata", om.valueToTree(this.getMetadata()));
                }
                if (this.getMethodName() != null) {
                    data.set("methodName", om.valueToTree(this.getMethodName()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getServiceName() != null) {
                    data.set("serviceName", om.valueToTree(this.getServiceName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.GrpcRouteMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrpcRouteMatchProperty.Jsii$Proxy that = (GrpcRouteMatchProperty.Jsii$Proxy) o;

                if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) return false;
                if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                return this.serviceName != null ? this.serviceName.equals(that.serviceName) : that.serviceName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metadata != null ? this.metadata.hashCode() : 0;
                result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the match method.
     * <p>
     * Specify one of the match values.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GrpcRouteMetadataMatchMethodProperty grpcRouteMetadataMatchMethodProperty = GrpcRouteMetadataMatchMethodProperty.builder()
     *         .exact("exact")
     *         .prefix("prefix")
     *         .range(MatchRangeProperty.builder()
     *                 .end(123)
     *                 .start(123)
     *                 .build())
     *         .regex("regex")
     *         .suffix("suffix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.GrpcRouteMetadataMatchMethodProperty")
    @software.amazon.jsii.Jsii.Proxy(GrpcRouteMetadataMatchMethodProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrpcRouteMetadataMatchMethodProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value sent by the client must match the specified value exactly.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-exact">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-exact</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExact() {
            return null;
        }

        /**
         * The value sent by the client must begin with the specified characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * An object that represents the range of values to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-range">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-range</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRange() {
            return null;
        }

        /**
         * The value sent by the client must include the specified characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-regex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-regex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegex() {
            return null;
        }

        /**
         * The value sent by the client must end with the specified characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-suffix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadatamatchmethod.html#cfn-appmesh-route-grpcroutemetadatamatchmethod-suffix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuffix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GrpcRouteMetadataMatchMethodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrpcRouteMetadataMatchMethodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrpcRouteMetadataMatchMethodProperty> {
            java.lang.String exact;
            java.lang.String prefix;
            java.lang.Object range;
            java.lang.String regex;
            java.lang.String suffix;

            /**
             * Sets the value of {@link GrpcRouteMetadataMatchMethodProperty#getExact}
             * @param exact The value sent by the client must match the specified value exactly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exact(java.lang.String exact) {
                this.exact = exact;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteMetadataMatchMethodProperty#getPrefix}
             * @param prefix The value sent by the client must begin with the specified characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteMetadataMatchMethodProperty#getRange}
             * @param range An object that represents the range of values to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder range(software.amazon.awscdk.IResolvable range) {
                this.range = range;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteMetadataMatchMethodProperty#getRange}
             * @param range An object that represents the range of values to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder range(software.amazon.awscdk.services.appmesh.CfnRoute.MatchRangeProperty range) {
                this.range = range;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteMetadataMatchMethodProperty#getRegex}
             * @param regex The value sent by the client must include the specified characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regex(java.lang.String regex) {
                this.regex = regex;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteMetadataMatchMethodProperty#getSuffix}
             * @param suffix The value sent by the client must end with the specified characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder suffix(java.lang.String suffix) {
                this.suffix = suffix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrpcRouteMetadataMatchMethodProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrpcRouteMetadataMatchMethodProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrpcRouteMetadataMatchMethodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcRouteMetadataMatchMethodProperty {
            private final java.lang.String exact;
            private final java.lang.String prefix;
            private final java.lang.Object range;
            private final java.lang.String regex;
            private final java.lang.String suffix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exact = software.amazon.jsii.Kernel.get(this, "exact", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.range = software.amazon.jsii.Kernel.get(this, "range", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.regex = software.amazon.jsii.Kernel.get(this, "regex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.suffix = software.amazon.jsii.Kernel.get(this, "suffix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exact = builder.exact;
                this.prefix = builder.prefix;
                this.range = builder.range;
                this.regex = builder.regex;
                this.suffix = builder.suffix;
            }

            @Override
            public final java.lang.String getExact() {
                return this.exact;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.Object getRange() {
                return this.range;
            }

            @Override
            public final java.lang.String getRegex() {
                return this.regex;
            }

            @Override
            public final java.lang.String getSuffix() {
                return this.suffix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExact() != null) {
                    data.set("exact", om.valueToTree(this.getExact()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getRange() != null) {
                    data.set("range", om.valueToTree(this.getRange()));
                }
                if (this.getRegex() != null) {
                    data.set("regex", om.valueToTree(this.getRegex()));
                }
                if (this.getSuffix() != null) {
                    data.set("suffix", om.valueToTree(this.getSuffix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.GrpcRouteMetadataMatchMethodProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrpcRouteMetadataMatchMethodProperty.Jsii$Proxy that = (GrpcRouteMetadataMatchMethodProperty.Jsii$Proxy) o;

                if (this.exact != null ? !this.exact.equals(that.exact) : that.exact != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                if (this.range != null ? !this.range.equals(that.range) : that.range != null) return false;
                if (this.regex != null ? !this.regex.equals(that.regex) : that.regex != null) return false;
                return this.suffix != null ? this.suffix.equals(that.suffix) : that.suffix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exact != null ? this.exact.hashCode() : 0;
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.range != null ? this.range.hashCode() : 0);
                result = 31 * result + (this.regex != null ? this.regex.hashCode() : 0);
                result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the match metadata for the route.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GrpcRouteMetadataProperty grpcRouteMetadataProperty = GrpcRouteMetadataProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .invert(false)
     *         .match(GrpcRouteMetadataMatchMethodProperty.builder()
     *                 .exact("exact")
     *                 .prefix("prefix")
     *                 .range(MatchRangeProperty.builder()
     *                         .end(123)
     *                         .start(123)
     *                         .build())
     *                 .regex("regex")
     *                 .suffix("suffix")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.GrpcRouteMetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(GrpcRouteMetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrpcRouteMetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html#cfn-appmesh-route-grpcroutemetadata-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html#cfn-appmesh-route-grpcroutemetadata-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Specify <code>True</code> to match anything except the match criteria.
         * <p>
         * The default value is <code>False</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html#cfn-appmesh-route-grpcroutemetadata-invert">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html#cfn-appmesh-route-grpcroutemetadata-invert</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInvert() {
            return null;
        }

        /**
         * An object that represents the data to match from the request.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html#cfn-appmesh-route-grpcroutemetadata-match">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroutemetadata.html#cfn-appmesh-route-grpcroutemetadata-match</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMatch() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GrpcRouteMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrpcRouteMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrpcRouteMetadataProperty> {
            java.lang.String name;
            java.lang.Object invert;
            java.lang.Object match;

            /**
             * Sets the value of {@link GrpcRouteMetadataProperty#getName}
             * @param name The name of the route. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteMetadataProperty#getInvert}
             * @param invert Specify <code>True</code> to match anything except the match criteria.
             *               The default value is <code>False</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invert(java.lang.Boolean invert) {
                this.invert = invert;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteMetadataProperty#getInvert}
             * @param invert Specify <code>True</code> to match anything except the match criteria.
             *               The default value is <code>False</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invert(software.amazon.awscdk.IResolvable invert) {
                this.invert = invert;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteMetadataProperty#getMatch}
             * @param match An object that represents the data to match from the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.IResolvable match) {
                this.match = match;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteMetadataProperty#getMatch}
             * @param match An object that represents the data to match from the request.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.services.appmesh.CfnRoute.GrpcRouteMetadataMatchMethodProperty match) {
                this.match = match;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrpcRouteMetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrpcRouteMetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrpcRouteMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcRouteMetadataProperty {
            private final java.lang.String name;
            private final java.lang.Object invert;
            private final java.lang.Object match;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.invert = software.amazon.jsii.Kernel.get(this, "invert", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.match = software.amazon.jsii.Kernel.get(this, "match", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.invert = builder.invert;
                this.match = builder.match;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getInvert() {
                return this.invert;
            }

            @Override
            public final java.lang.Object getMatch() {
                return this.match;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getInvert() != null) {
                    data.set("invert", om.valueToTree(this.getInvert()));
                }
                if (this.getMatch() != null) {
                    data.set("match", om.valueToTree(this.getMatch()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.GrpcRouteMetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrpcRouteMetadataProperty.Jsii$Proxy that = (GrpcRouteMetadataProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.invert != null ? !this.invert.equals(that.invert) : that.invert != null) return false;
                return this.match != null ? this.match.equals(that.match) : that.match == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.invert != null ? this.invert.hashCode() : 0);
                result = 31 * result + (this.match != null ? this.match.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a gRPC route type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GrpcRouteProperty grpcRouteProperty = GrpcRouteProperty.builder()
     *         .action(GrpcRouteActionProperty.builder()
     *                 .weightedTargets(List.of(WeightedTargetProperty.builder()
     *                         .virtualNode("virtualNode")
     *                         .weight(123)
     *                         // the properties below are optional
     *                         .port(123)
     *                         .build()))
     *                 .build())
     *         .match(GrpcRouteMatchProperty.builder()
     *                 .metadata(List.of(GrpcRouteMetadataProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .invert(false)
     *                         .match(GrpcRouteMetadataMatchMethodProperty.builder()
     *                                 .exact("exact")
     *                                 .prefix("prefix")
     *                                 .range(MatchRangeProperty.builder()
     *                                         .end(123)
     *                                         .start(123)
     *                                         .build())
     *                                 .regex("regex")
     *                                 .suffix("suffix")
     *                                 .build())
     *                         .build()))
     *                 .methodName("methodName")
     *                 .port(123)
     *                 .serviceName("serviceName")
     *                 .build())
     *         // the properties below are optional
     *         .retryPolicy(GrpcRetryPolicyProperty.builder()
     *                 .maxRetries(123)
     *                 .perRetryTimeout(DurationProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .grpcRetryEvents(List.of("grpcRetryEvents"))
     *                 .httpRetryEvents(List.of("httpRetryEvents"))
     *                 .tcpRetryEvents(List.of("tcpRetryEvents"))
     *                 .build())
     *         .timeout(GrpcTimeoutProperty.builder()
     *                 .idle(DurationProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .perRequest(DurationProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.GrpcRouteProperty")
    @software.amazon.jsii.Jsii.Proxy(GrpcRouteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrpcRouteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents the action to take if a match is determined.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAction();

        /**
         * An object that represents the criteria for determining a request match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-match">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-match</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMatch();

        /**
         * An object that represents a retry policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-retrypolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-retrypolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryPolicy() {
            return null;
        }

        /**
         * An object that represents types of timeouts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-timeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpcroute.html#cfn-appmesh-route-grpcroute-timeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GrpcRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrpcRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrpcRouteProperty> {
            java.lang.Object action;
            java.lang.Object match;
            java.lang.Object retryPolicy;
            java.lang.Object timeout;

            /**
             * Sets the value of {@link GrpcRouteProperty#getAction}
             * @param action An object that represents the action to take if a match is determined. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.IResolvable action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteProperty#getAction}
             * @param action An object that represents the action to take if a match is determined. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.services.appmesh.CfnRoute.GrpcRouteActionProperty action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteProperty#getMatch}
             * @param match An object that represents the criteria for determining a request match. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.IResolvable match) {
                this.match = match;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteProperty#getMatch}
             * @param match An object that represents the criteria for determining a request match. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.services.appmesh.CfnRoute.GrpcRouteMatchProperty match) {
                this.match = match;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteProperty#getRetryPolicy}
             * @param retryPolicy An object that represents a retry policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryPolicy(software.amazon.awscdk.IResolvable retryPolicy) {
                this.retryPolicy = retryPolicy;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteProperty#getRetryPolicy}
             * @param retryPolicy An object that represents a retry policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryPolicy(software.amazon.awscdk.services.appmesh.CfnRoute.GrpcRetryPolicyProperty retryPolicy) {
                this.retryPolicy = retryPolicy;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteProperty#getTimeout}
             * @param timeout An object that represents types of timeouts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(software.amazon.awscdk.IResolvable timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Sets the value of {@link GrpcRouteProperty#getTimeout}
             * @param timeout An object that represents types of timeouts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(software.amazon.awscdk.services.appmesh.CfnRoute.GrpcTimeoutProperty timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrpcRouteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrpcRouteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrpcRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcRouteProperty {
            private final java.lang.Object action;
            private final java.lang.Object match;
            private final java.lang.Object retryPolicy;
            private final java.lang.Object timeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.match = software.amazon.jsii.Kernel.get(this, "match", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryPolicy = software.amazon.jsii.Kernel.get(this, "retryPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.match = java.util.Objects.requireNonNull(builder.match, "match is required");
                this.retryPolicy = builder.retryPolicy;
                this.timeout = builder.timeout;
            }

            @Override
            public final java.lang.Object getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Object getMatch() {
                return this.match;
            }

            @Override
            public final java.lang.Object getRetryPolicy() {
                return this.retryPolicy;
            }

            @Override
            public final java.lang.Object getTimeout() {
                return this.timeout;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("match", om.valueToTree(this.getMatch()));
                if (this.getRetryPolicy() != null) {
                    data.set("retryPolicy", om.valueToTree(this.getRetryPolicy()));
                }
                if (this.getTimeout() != null) {
                    data.set("timeout", om.valueToTree(this.getTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.GrpcRouteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrpcRouteProperty.Jsii$Proxy that = (GrpcRouteProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!match.equals(that.match)) return false;
                if (this.retryPolicy != null ? !this.retryPolicy.equals(that.retryPolicy) : that.retryPolicy != null) return false;
                return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.match.hashCode());
                result = 31 * result + (this.retryPolicy != null ? this.retryPolicy.hashCode() : 0);
                result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents types of timeouts.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * GrpcTimeoutProperty grpcTimeoutProperty = GrpcTimeoutProperty.builder()
     *         .idle(DurationProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .perRequest(DurationProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpctimeout.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpctimeout.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.GrpcTimeoutProperty")
    @software.amazon.jsii.Jsii.Proxy(GrpcTimeoutProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GrpcTimeoutProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents an idle timeout.
         * <p>
         * An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpctimeout.html#cfn-appmesh-route-grpctimeout-idle">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpctimeout.html#cfn-appmesh-route-grpctimeout-idle</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIdle() {
            return null;
        }

        /**
         * An object that represents a per request timeout.
         * <p>
         * The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15 seconds for the source and destination virtual node and the route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpctimeout.html#cfn-appmesh-route-grpctimeout-perrequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-grpctimeout.html#cfn-appmesh-route-grpctimeout-perrequest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPerRequest() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GrpcTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GrpcTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GrpcTimeoutProperty> {
            java.lang.Object idle;
            java.lang.Object perRequest;

            /**
             * Sets the value of {@link GrpcTimeoutProperty#getIdle}
             * @param idle An object that represents an idle timeout.
             *             An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idle(software.amazon.awscdk.IResolvable idle) {
                this.idle = idle;
                return this;
            }

            /**
             * Sets the value of {@link GrpcTimeoutProperty#getIdle}
             * @param idle An object that represents an idle timeout.
             *             An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idle(software.amazon.awscdk.services.appmesh.CfnRoute.DurationProperty idle) {
                this.idle = idle;
                return this;
            }

            /**
             * Sets the value of {@link GrpcTimeoutProperty#getPerRequest}
             * @param perRequest An object that represents a per request timeout.
             *                   The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15 seconds for the source and destination virtual node and the route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perRequest(software.amazon.awscdk.IResolvable perRequest) {
                this.perRequest = perRequest;
                return this;
            }

            /**
             * Sets the value of {@link GrpcTimeoutProperty#getPerRequest}
             * @param perRequest An object that represents a per request timeout.
             *                   The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15 seconds for the source and destination virtual node and the route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perRequest(software.amazon.awscdk.services.appmesh.CfnRoute.DurationProperty perRequest) {
                this.perRequest = perRequest;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GrpcTimeoutProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GrpcTimeoutProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GrpcTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrpcTimeoutProperty {
            private final java.lang.Object idle;
            private final java.lang.Object perRequest;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idle = software.amazon.jsii.Kernel.get(this, "idle", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.perRequest = software.amazon.jsii.Kernel.get(this, "perRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idle = builder.idle;
                this.perRequest = builder.perRequest;
            }

            @Override
            public final java.lang.Object getIdle() {
                return this.idle;
            }

            @Override
            public final java.lang.Object getPerRequest() {
                return this.perRequest;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIdle() != null) {
                    data.set("idle", om.valueToTree(this.getIdle()));
                }
                if (this.getPerRequest() != null) {
                    data.set("perRequest", om.valueToTree(this.getPerRequest()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.GrpcTimeoutProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GrpcTimeoutProperty.Jsii$Proxy that = (GrpcTimeoutProperty.Jsii$Proxy) o;

                if (this.idle != null ? !this.idle.equals(that.idle) : that.idle != null) return false;
                return this.perRequest != null ? this.perRequest.equals(that.perRequest) : that.perRequest == null;
            }

            @Override
            public final int hashCode() {
                int result = this.idle != null ? this.idle.hashCode() : 0;
                result = 31 * result + (this.perRequest != null ? this.perRequest.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the method and value to match with the header value sent in a request.
     * <p>
     * Specify one match method.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HeaderMatchMethodProperty headerMatchMethodProperty = HeaderMatchMethodProperty.builder()
     *         .exact("exact")
     *         .prefix("prefix")
     *         .range(MatchRangeProperty.builder()
     *                 .end(123)
     *                 .start(123)
     *                 .build())
     *         .regex("regex")
     *         .suffix("suffix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.HeaderMatchMethodProperty")
    @software.amazon.jsii.Jsii.Proxy(HeaderMatchMethodProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HeaderMatchMethodProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value sent by the client must match the specified value exactly.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-exact">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-exact</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExact() {
            return null;
        }

        /**
         * The value sent by the client must begin with the specified characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * An object that represents the range of values to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-range">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-range</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRange() {
            return null;
        }

        /**
         * The value sent by the client must include the specified characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-regex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-regex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegex() {
            return null;
        }

        /**
         * The value sent by the client must end with the specified characters.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-suffix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-headermatchmethod.html#cfn-appmesh-route-headermatchmethod-suffix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSuffix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HeaderMatchMethodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HeaderMatchMethodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HeaderMatchMethodProperty> {
            java.lang.String exact;
            java.lang.String prefix;
            java.lang.Object range;
            java.lang.String regex;
            java.lang.String suffix;

            /**
             * Sets the value of {@link HeaderMatchMethodProperty#getExact}
             * @param exact The value sent by the client must match the specified value exactly.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exact(java.lang.String exact) {
                this.exact = exact;
                return this;
            }

            /**
             * Sets the value of {@link HeaderMatchMethodProperty#getPrefix}
             * @param prefix The value sent by the client must begin with the specified characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link HeaderMatchMethodProperty#getRange}
             * @param range An object that represents the range of values to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder range(software.amazon.awscdk.IResolvable range) {
                this.range = range;
                return this;
            }

            /**
             * Sets the value of {@link HeaderMatchMethodProperty#getRange}
             * @param range An object that represents the range of values to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder range(software.amazon.awscdk.services.appmesh.CfnRoute.MatchRangeProperty range) {
                this.range = range;
                return this;
            }

            /**
             * Sets the value of {@link HeaderMatchMethodProperty#getRegex}
             * @param regex The value sent by the client must include the specified characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regex(java.lang.String regex) {
                this.regex = regex;
                return this;
            }

            /**
             * Sets the value of {@link HeaderMatchMethodProperty#getSuffix}
             * @param suffix The value sent by the client must end with the specified characters.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder suffix(java.lang.String suffix) {
                this.suffix = suffix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HeaderMatchMethodProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HeaderMatchMethodProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HeaderMatchMethodProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HeaderMatchMethodProperty {
            private final java.lang.String exact;
            private final java.lang.String prefix;
            private final java.lang.Object range;
            private final java.lang.String regex;
            private final java.lang.String suffix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exact = software.amazon.jsii.Kernel.get(this, "exact", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.range = software.amazon.jsii.Kernel.get(this, "range", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.regex = software.amazon.jsii.Kernel.get(this, "regex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.suffix = software.amazon.jsii.Kernel.get(this, "suffix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exact = builder.exact;
                this.prefix = builder.prefix;
                this.range = builder.range;
                this.regex = builder.regex;
                this.suffix = builder.suffix;
            }

            @Override
            public final java.lang.String getExact() {
                return this.exact;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.Object getRange() {
                return this.range;
            }

            @Override
            public final java.lang.String getRegex() {
                return this.regex;
            }

            @Override
            public final java.lang.String getSuffix() {
                return this.suffix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExact() != null) {
                    data.set("exact", om.valueToTree(this.getExact()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getRange() != null) {
                    data.set("range", om.valueToTree(this.getRange()));
                }
                if (this.getRegex() != null) {
                    data.set("regex", om.valueToTree(this.getRegex()));
                }
                if (this.getSuffix() != null) {
                    data.set("suffix", om.valueToTree(this.getSuffix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.HeaderMatchMethodProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HeaderMatchMethodProperty.Jsii$Proxy that = (HeaderMatchMethodProperty.Jsii$Proxy) o;

                if (this.exact != null ? !this.exact.equals(that.exact) : that.exact != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                if (this.range != null ? !this.range.equals(that.range) : that.range != null) return false;
                if (this.regex != null ? !this.regex.equals(that.regex) : that.regex != null) return false;
                return this.suffix != null ? this.suffix.equals(that.suffix) : that.suffix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exact != null ? this.exact.hashCode() : 0;
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.range != null ? this.range.hashCode() : 0);
                result = 31 * result + (this.regex != null ? this.regex.hashCode() : 0);
                result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object representing the path to match in the request.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpPathMatchProperty httpPathMatchProperty = HttpPathMatchProperty.builder()
     *         .exact("exact")
     *         .regex("regex")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httppathmatch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httppathmatch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.HttpPathMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpPathMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpPathMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The exact path to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httppathmatch.html#cfn-appmesh-route-httppathmatch-exact">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httppathmatch.html#cfn-appmesh-route-httppathmatch-exact</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExact() {
            return null;
        }

        /**
         * The regex used to match the path.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httppathmatch.html#cfn-appmesh-route-httppathmatch-regex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httppathmatch.html#cfn-appmesh-route-httppathmatch-regex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegex() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpPathMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpPathMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpPathMatchProperty> {
            java.lang.String exact;
            java.lang.String regex;

            /**
             * Sets the value of {@link HttpPathMatchProperty#getExact}
             * @param exact The exact path to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exact(java.lang.String exact) {
                this.exact = exact;
                return this;
            }

            /**
             * Sets the value of {@link HttpPathMatchProperty#getRegex}
             * @param regex The regex used to match the path.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder regex(java.lang.String regex) {
                this.regex = regex;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpPathMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpPathMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpPathMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpPathMatchProperty {
            private final java.lang.String exact;
            private final java.lang.String regex;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exact = software.amazon.jsii.Kernel.get(this, "exact", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.regex = software.amazon.jsii.Kernel.get(this, "regex", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exact = builder.exact;
                this.regex = builder.regex;
            }

            @Override
            public final java.lang.String getExact() {
                return this.exact;
            }

            @Override
            public final java.lang.String getRegex() {
                return this.regex;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExact() != null) {
                    data.set("exact", om.valueToTree(this.getExact()));
                }
                if (this.getRegex() != null) {
                    data.set("regex", om.valueToTree(this.getRegex()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.HttpPathMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpPathMatchProperty.Jsii$Proxy that = (HttpPathMatchProperty.Jsii$Proxy) o;

                if (this.exact != null ? !this.exact.equals(that.exact) : that.exact != null) return false;
                return this.regex != null ? this.regex.equals(that.regex) : that.regex == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exact != null ? this.exact.hashCode() : 0;
                result = 31 * result + (this.regex != null ? this.regex.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object representing the query parameter to match.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpQueryParameterMatchProperty httpQueryParameterMatchProperty = HttpQueryParameterMatchProperty.builder()
     *         .exact("exact")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpqueryparametermatch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpqueryparametermatch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.HttpQueryParameterMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpQueryParameterMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpQueryParameterMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The exact query parameter to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpqueryparametermatch.html#cfn-appmesh-route-httpqueryparametermatch-exact">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpqueryparametermatch.html#cfn-appmesh-route-httpqueryparametermatch-exact</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExact() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpQueryParameterMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpQueryParameterMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpQueryParameterMatchProperty> {
            java.lang.String exact;

            /**
             * Sets the value of {@link HttpQueryParameterMatchProperty#getExact}
             * @param exact The exact query parameter to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exact(java.lang.String exact) {
                this.exact = exact;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpQueryParameterMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpQueryParameterMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpQueryParameterMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpQueryParameterMatchProperty {
            private final java.lang.String exact;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exact = software.amazon.jsii.Kernel.get(this, "exact", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exact = builder.exact;
            }

            @Override
            public final java.lang.String getExact() {
                return this.exact;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExact() != null) {
                    data.set("exact", om.valueToTree(this.getExact()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.HttpQueryParameterMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpQueryParameterMatchProperty.Jsii$Proxy that = (HttpQueryParameterMatchProperty.Jsii$Proxy) o;

                return this.exact != null ? this.exact.equals(that.exact) : that.exact == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exact != null ? this.exact.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents a retry policy.
     * <p>
     * Specify at least one value for at least one of the types of <code>RetryEvents</code> , a value for <code>maxRetries</code> , and a value for <code>perRetryTimeout</code> . Both <code>server-error</code> and <code>gateway-error</code> under <code>httpRetryEvents</code> include the Envoy <code>reset</code> policy. For more information on the <code>reset</code> policy, see the <a href="https://docs.aws.amazon.com/https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_filters/router_filter#x-envoy-retry-on">Envoy documentation</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpRetryPolicyProperty httpRetryPolicyProperty = HttpRetryPolicyProperty.builder()
     *         .maxRetries(123)
     *         .perRetryTimeout(DurationProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         // the properties below are optional
     *         .httpRetryEvents(List.of("httpRetryEvents"))
     *         .tcpRetryEvents(List.of("tcpRetryEvents"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.HttpRetryPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpRetryPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpRetryPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of retry attempts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-maxretries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-maxretries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxRetries();

        /**
         * The timeout for each retry attempt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-perretrytimeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-perretrytimeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPerRetryTimeout();

        /**
         * Specify at least one of the following values.
         * <p>
         * <ul>
         * <li><em>server-error</em> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511</li>
         * <li><em>gateway-error</em> – HTTP status codes 502, 503, and 504</li>
         * <li><em>client-error</em> – HTTP status code 409</li>
         * <li><em>stream-error</em> – Retry on refused stream</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-httpretryevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-httpretryevents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHttpRetryEvents() {
            return null;
        }

        /**
         * Specify a valid value.
         * <p>
         * The event occurs before any processing of a request has started and is encountered when the upstream is temporarily or permanently unavailable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-tcpretryevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httpretrypolicy.html#cfn-appmesh-route-httpretrypolicy-tcpretryevents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTcpRetryEvents() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpRetryPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpRetryPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpRetryPolicyProperty> {
            java.lang.Number maxRetries;
            java.lang.Object perRetryTimeout;
            java.util.List<java.lang.String> httpRetryEvents;
            java.util.List<java.lang.String> tcpRetryEvents;

            /**
             * Sets the value of {@link HttpRetryPolicyProperty#getMaxRetries}
             * @param maxRetries The maximum number of retry attempts. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRetries(java.lang.Number maxRetries) {
                this.maxRetries = maxRetries;
                return this;
            }

            /**
             * Sets the value of {@link HttpRetryPolicyProperty#getPerRetryTimeout}
             * @param perRetryTimeout The timeout for each retry attempt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perRetryTimeout(software.amazon.awscdk.IResolvable perRetryTimeout) {
                this.perRetryTimeout = perRetryTimeout;
                return this;
            }

            /**
             * Sets the value of {@link HttpRetryPolicyProperty#getPerRetryTimeout}
             * @param perRetryTimeout The timeout for each retry attempt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perRetryTimeout(software.amazon.awscdk.services.appmesh.CfnRoute.DurationProperty perRetryTimeout) {
                this.perRetryTimeout = perRetryTimeout;
                return this;
            }

            /**
             * Sets the value of {@link HttpRetryPolicyProperty#getHttpRetryEvents}
             * @param httpRetryEvents Specify at least one of the following values.
             *                        <ul>
             *                        <li><em>server-error</em> – HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511</li>
             *                        <li><em>gateway-error</em> – HTTP status codes 502, 503, and 504</li>
             *                        <li><em>client-error</em> – HTTP status code 409</li>
             *                        <li><em>stream-error</em> – Retry on refused stream</li>
             *                        </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpRetryEvents(java.util.List<java.lang.String> httpRetryEvents) {
                this.httpRetryEvents = httpRetryEvents;
                return this;
            }

            /**
             * Sets the value of {@link HttpRetryPolicyProperty#getTcpRetryEvents}
             * @param tcpRetryEvents Specify a valid value.
             *                       The event occurs before any processing of a request has started and is encountered when the upstream is temporarily or permanently unavailable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tcpRetryEvents(java.util.List<java.lang.String> tcpRetryEvents) {
                this.tcpRetryEvents = tcpRetryEvents;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpRetryPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpRetryPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpRetryPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpRetryPolicyProperty {
            private final java.lang.Number maxRetries;
            private final java.lang.Object perRetryTimeout;
            private final java.util.List<java.lang.String> httpRetryEvents;
            private final java.util.List<java.lang.String> tcpRetryEvents;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxRetries = software.amazon.jsii.Kernel.get(this, "maxRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.perRetryTimeout = software.amazon.jsii.Kernel.get(this, "perRetryTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.httpRetryEvents = software.amazon.jsii.Kernel.get(this, "httpRetryEvents", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.tcpRetryEvents = software.amazon.jsii.Kernel.get(this, "tcpRetryEvents", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxRetries = java.util.Objects.requireNonNull(builder.maxRetries, "maxRetries is required");
                this.perRetryTimeout = java.util.Objects.requireNonNull(builder.perRetryTimeout, "perRetryTimeout is required");
                this.httpRetryEvents = builder.httpRetryEvents;
                this.tcpRetryEvents = builder.tcpRetryEvents;
            }

            @Override
            public final java.lang.Number getMaxRetries() {
                return this.maxRetries;
            }

            @Override
            public final java.lang.Object getPerRetryTimeout() {
                return this.perRetryTimeout;
            }

            @Override
            public final java.util.List<java.lang.String> getHttpRetryEvents() {
                return this.httpRetryEvents;
            }

            @Override
            public final java.util.List<java.lang.String> getTcpRetryEvents() {
                return this.tcpRetryEvents;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxRetries", om.valueToTree(this.getMaxRetries()));
                data.set("perRetryTimeout", om.valueToTree(this.getPerRetryTimeout()));
                if (this.getHttpRetryEvents() != null) {
                    data.set("httpRetryEvents", om.valueToTree(this.getHttpRetryEvents()));
                }
                if (this.getTcpRetryEvents() != null) {
                    data.set("tcpRetryEvents", om.valueToTree(this.getTcpRetryEvents()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.HttpRetryPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpRetryPolicyProperty.Jsii$Proxy that = (HttpRetryPolicyProperty.Jsii$Proxy) o;

                if (!maxRetries.equals(that.maxRetries)) return false;
                if (!perRetryTimeout.equals(that.perRetryTimeout)) return false;
                if (this.httpRetryEvents != null ? !this.httpRetryEvents.equals(that.httpRetryEvents) : that.httpRetryEvents != null) return false;
                return this.tcpRetryEvents != null ? this.tcpRetryEvents.equals(that.tcpRetryEvents) : that.tcpRetryEvents == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxRetries.hashCode();
                result = 31 * result + (this.perRetryTimeout.hashCode());
                result = 31 * result + (this.httpRetryEvents != null ? this.httpRetryEvents.hashCode() : 0);
                result = 31 * result + (this.tcpRetryEvents != null ? this.tcpRetryEvents.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the action to take if a match is determined.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpRouteActionProperty httpRouteActionProperty = HttpRouteActionProperty.builder()
     *         .weightedTargets(List.of(WeightedTargetProperty.builder()
     *                 .virtualNode("virtualNode")
     *                 .weight(123)
     *                 // the properties below are optional
     *                 .port(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.HttpRouteActionProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpRouteActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpRouteActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents the targets that traffic is routed to when a request matches the route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteaction.html#cfn-appmesh-route-httprouteaction-weightedtargets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteaction.html#cfn-appmesh-route-httprouteaction-weightedtargets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getWeightedTargets();

        /**
         * @return a {@link Builder} of {@link HttpRouteActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpRouteActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpRouteActionProperty> {
            java.lang.Object weightedTargets;

            /**
             * Sets the value of {@link HttpRouteActionProperty#getWeightedTargets}
             * @param weightedTargets An object that represents the targets that traffic is routed to when a request matches the route. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weightedTargets(software.amazon.awscdk.IResolvable weightedTargets) {
                this.weightedTargets = weightedTargets;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteActionProperty#getWeightedTargets}
             * @param weightedTargets An object that represents the targets that traffic is routed to when a request matches the route. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weightedTargets(java.util.List<? extends java.lang.Object> weightedTargets) {
                this.weightedTargets = weightedTargets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpRouteActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpRouteActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpRouteActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpRouteActionProperty {
            private final java.lang.Object weightedTargets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.weightedTargets = software.amazon.jsii.Kernel.get(this, "weightedTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.weightedTargets = java.util.Objects.requireNonNull(builder.weightedTargets, "weightedTargets is required");
            }

            @Override
            public final java.lang.Object getWeightedTargets() {
                return this.weightedTargets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("weightedTargets", om.valueToTree(this.getWeightedTargets()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.HttpRouteActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpRouteActionProperty.Jsii$Proxy that = (HttpRouteActionProperty.Jsii$Proxy) o;

                return this.weightedTargets.equals(that.weightedTargets);
            }

            @Override
            public final int hashCode() {
                int result = this.weightedTargets.hashCode();
                return result;
            }
        }
    }
    /**
     * An object that represents the HTTP header in the request.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpRouteHeaderProperty httpRouteHeaderProperty = HttpRouteHeaderProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .invert(false)
     *         .match(HeaderMatchMethodProperty.builder()
     *                 .exact("exact")
     *                 .prefix("prefix")
     *                 .range(MatchRangeProperty.builder()
     *                         .end(123)
     *                         .start(123)
     *                         .build())
     *                 .regex("regex")
     *                 .suffix("suffix")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.HttpRouteHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpRouteHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpRouteHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the HTTP header in the client request that will be matched on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html#cfn-appmesh-route-httprouteheader-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html#cfn-appmesh-route-httprouteheader-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Specify <code>True</code> to match anything except the match criteria.
         * <p>
         * The default value is <code>False</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html#cfn-appmesh-route-httprouteheader-invert">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html#cfn-appmesh-route-httprouteheader-invert</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInvert() {
            return null;
        }

        /**
         * The <code>HeaderMatchMethod</code> object.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html#cfn-appmesh-route-httprouteheader-match">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httprouteheader.html#cfn-appmesh-route-httprouteheader-match</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMatch() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpRouteHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpRouteHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpRouteHeaderProperty> {
            java.lang.String name;
            java.lang.Object invert;
            java.lang.Object match;

            /**
             * Sets the value of {@link HttpRouteHeaderProperty#getName}
             * @param name A name for the HTTP header in the client request that will be matched on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteHeaderProperty#getInvert}
             * @param invert Specify <code>True</code> to match anything except the match criteria.
             *               The default value is <code>False</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invert(java.lang.Boolean invert) {
                this.invert = invert;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteHeaderProperty#getInvert}
             * @param invert Specify <code>True</code> to match anything except the match criteria.
             *               The default value is <code>False</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder invert(software.amazon.awscdk.IResolvable invert) {
                this.invert = invert;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteHeaderProperty#getMatch}
             * @param match The <code>HeaderMatchMethod</code> object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.IResolvable match) {
                this.match = match;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteHeaderProperty#getMatch}
             * @param match The <code>HeaderMatchMethod</code> object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.services.appmesh.CfnRoute.HeaderMatchMethodProperty match) {
                this.match = match;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpRouteHeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpRouteHeaderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpRouteHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpRouteHeaderProperty {
            private final java.lang.String name;
            private final java.lang.Object invert;
            private final java.lang.Object match;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.invert = software.amazon.jsii.Kernel.get(this, "invert", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.match = software.amazon.jsii.Kernel.get(this, "match", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.invert = builder.invert;
                this.match = builder.match;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getInvert() {
                return this.invert;
            }

            @Override
            public final java.lang.Object getMatch() {
                return this.match;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getInvert() != null) {
                    data.set("invert", om.valueToTree(this.getInvert()));
                }
                if (this.getMatch() != null) {
                    data.set("match", om.valueToTree(this.getMatch()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.HttpRouteHeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpRouteHeaderProperty.Jsii$Proxy that = (HttpRouteHeaderProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.invert != null ? !this.invert.equals(that.invert) : that.invert != null) return false;
                return this.match != null ? this.match.equals(that.match) : that.match == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.invert != null ? this.invert.hashCode() : 0);
                result = 31 * result + (this.match != null ? this.match.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the requirements for a route to match HTTP requests for a virtual router.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpRouteMatchProperty httpRouteMatchProperty = HttpRouteMatchProperty.builder()
     *         .headers(List.of(HttpRouteHeaderProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .invert(false)
     *                 .match(HeaderMatchMethodProperty.builder()
     *                         .exact("exact")
     *                         .prefix("prefix")
     *                         .range(MatchRangeProperty.builder()
     *                                 .end(123)
     *                                 .start(123)
     *                                 .build())
     *                         .regex("regex")
     *                         .suffix("suffix")
     *                         .build())
     *                 .build()))
     *         .method("method")
     *         .path(HttpPathMatchProperty.builder()
     *                 .exact("exact")
     *                 .regex("regex")
     *                 .build())
     *         .port(123)
     *         .prefix("prefix")
     *         .queryParameters(List.of(QueryParameterProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .match(HttpQueryParameterMatchProperty.builder()
     *                         .exact("exact")
     *                         .build())
     *                 .build()))
     *         .scheme("scheme")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.HttpRouteMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpRouteMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpRouteMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The client request headers to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-headers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-headers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHeaders() {
            return null;
        }

        /**
         * The client request method to match on.
         * <p>
         * Specify only one.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-method">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-method</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMethod() {
            return null;
        }

        /**
         * The client request path to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-path</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPath() {
            return null;
        }

        /**
         * The port number to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * Specifies the path to match requests with.
         * <p>
         * This parameter must always start with <code>/</code> , which by itself matches all requests to the virtual service name. You can also match for path-based routing of requests. For example, if your virtual service name is <code>my-service.local</code> and you want the route to match requests to <code>my-service.local/metrics</code> , your prefix should be <code>/metrics</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-prefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * The client request query parameters to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-queryparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-queryparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getQueryParameters() {
            return null;
        }

        /**
         * The client request scheme to match on.
         * <p>
         * Specify only one. Applicable only for HTTP2 routes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-scheme">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproutematch.html#cfn-appmesh-route-httproutematch-scheme</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScheme() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpRouteMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpRouteMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpRouteMatchProperty> {
            java.lang.Object headers;
            java.lang.String method;
            java.lang.Object path;
            java.lang.Number port;
            java.lang.String prefix;
            java.lang.Object queryParameters;
            java.lang.String scheme;

            /**
             * Sets the value of {@link HttpRouteMatchProperty#getHeaders}
             * @param headers The client request headers to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(software.amazon.awscdk.IResolvable headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteMatchProperty#getHeaders}
             * @param headers The client request headers to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(java.util.List<? extends java.lang.Object> headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteMatchProperty#getMethod}
             * @param method The client request method to match on.
             *               Specify only one.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder method(java.lang.String method) {
                this.method = method;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteMatchProperty#getPath}
             * @param path The client request path to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(software.amazon.awscdk.IResolvable path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteMatchProperty#getPath}
             * @param path The client request path to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(software.amazon.awscdk.services.appmesh.CfnRoute.HttpPathMatchProperty path) {
                this.path = path;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteMatchProperty#getPort}
             * @param port The port number to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteMatchProperty#getPrefix}
             * @param prefix Specifies the path to match requests with.
             *               This parameter must always start with <code>/</code> , which by itself matches all requests to the virtual service name. You can also match for path-based routing of requests. For example, if your virtual service name is <code>my-service.local</code> and you want the route to match requests to <code>my-service.local/metrics</code> , your prefix should be <code>/metrics</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteMatchProperty#getQueryParameters}
             * @param queryParameters The client request query parameters to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryParameters(software.amazon.awscdk.IResolvable queryParameters) {
                this.queryParameters = queryParameters;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteMatchProperty#getQueryParameters}
             * @param queryParameters The client request query parameters to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryParameters(java.util.List<? extends java.lang.Object> queryParameters) {
                this.queryParameters = queryParameters;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteMatchProperty#getScheme}
             * @param scheme The client request scheme to match on.
             *               Specify only one. Applicable only for HTTP2 routes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheme(java.lang.String scheme) {
                this.scheme = scheme;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpRouteMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpRouteMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpRouteMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpRouteMatchProperty {
            private final java.lang.Object headers;
            private final java.lang.String method;
            private final java.lang.Object path;
            private final java.lang.Number port;
            private final java.lang.String prefix;
            private final java.lang.Object queryParameters;
            private final java.lang.String scheme;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.queryParameters = software.amazon.jsii.Kernel.get(this, "queryParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scheme = software.amazon.jsii.Kernel.get(this, "scheme", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.headers = builder.headers;
                this.method = builder.method;
                this.path = builder.path;
                this.port = builder.port;
                this.prefix = builder.prefix;
                this.queryParameters = builder.queryParameters;
                this.scheme = builder.scheme;
            }

            @Override
            public final java.lang.Object getHeaders() {
                return this.headers;
            }

            @Override
            public final java.lang.String getMethod() {
                return this.method;
            }

            @Override
            public final java.lang.Object getPath() {
                return this.path;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public final java.lang.Object getQueryParameters() {
                return this.queryParameters;
            }

            @Override
            public final java.lang.String getScheme() {
                return this.scheme;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHeaders() != null) {
                    data.set("headers", om.valueToTree(this.getHeaders()));
                }
                if (this.getMethod() != null) {
                    data.set("method", om.valueToTree(this.getMethod()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }
                if (this.getQueryParameters() != null) {
                    data.set("queryParameters", om.valueToTree(this.getQueryParameters()));
                }
                if (this.getScheme() != null) {
                    data.set("scheme", om.valueToTree(this.getScheme()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.HttpRouteMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpRouteMatchProperty.Jsii$Proxy that = (HttpRouteMatchProperty.Jsii$Proxy) o;

                if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) return false;
                if (this.method != null ? !this.method.equals(that.method) : that.method != null) return false;
                if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                if (this.prefix != null ? !this.prefix.equals(that.prefix) : that.prefix != null) return false;
                if (this.queryParameters != null ? !this.queryParameters.equals(that.queryParameters) : that.queryParameters != null) return false;
                return this.scheme != null ? this.scheme.equals(that.scheme) : that.scheme == null;
            }

            @Override
            public final int hashCode() {
                int result = this.headers != null ? this.headers.hashCode() : 0;
                result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                result = 31 * result + (this.queryParameters != null ? this.queryParameters.hashCode() : 0);
                result = 31 * result + (this.scheme != null ? this.scheme.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents an HTTP or HTTP/2 route type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpRouteProperty httpRouteProperty = HttpRouteProperty.builder()
     *         .action(HttpRouteActionProperty.builder()
     *                 .weightedTargets(List.of(WeightedTargetProperty.builder()
     *                         .virtualNode("virtualNode")
     *                         .weight(123)
     *                         // the properties below are optional
     *                         .port(123)
     *                         .build()))
     *                 .build())
     *         .match(HttpRouteMatchProperty.builder()
     *                 .headers(List.of(HttpRouteHeaderProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .invert(false)
     *                         .match(HeaderMatchMethodProperty.builder()
     *                                 .exact("exact")
     *                                 .prefix("prefix")
     *                                 .range(MatchRangeProperty.builder()
     *                                         .end(123)
     *                                         .start(123)
     *                                         .build())
     *                                 .regex("regex")
     *                                 .suffix("suffix")
     *                                 .build())
     *                         .build()))
     *                 .method("method")
     *                 .path(HttpPathMatchProperty.builder()
     *                         .exact("exact")
     *                         .regex("regex")
     *                         .build())
     *                 .port(123)
     *                 .prefix("prefix")
     *                 .queryParameters(List.of(QueryParameterProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .match(HttpQueryParameterMatchProperty.builder()
     *                                 .exact("exact")
     *                                 .build())
     *                         .build()))
     *                 .scheme("scheme")
     *                 .build())
     *         // the properties below are optional
     *         .retryPolicy(HttpRetryPolicyProperty.builder()
     *                 .maxRetries(123)
     *                 .perRetryTimeout(DurationProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 // the properties below are optional
     *                 .httpRetryEvents(List.of("httpRetryEvents"))
     *                 .tcpRetryEvents(List.of("tcpRetryEvents"))
     *                 .build())
     *         .timeout(HttpTimeoutProperty.builder()
     *                 .idle(DurationProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .perRequest(DurationProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.HttpRouteProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpRouteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpRouteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents the action to take if a match is determined.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAction();

        /**
         * An object that represents the criteria for determining a request match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-match">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-match</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMatch();

        /**
         * An object that represents a retry policy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-retrypolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-retrypolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryPolicy() {
            return null;
        }

        /**
         * An object that represents types of timeouts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-timeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httproute.html#cfn-appmesh-route-httproute-timeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpRouteProperty> {
            java.lang.Object action;
            java.lang.Object match;
            java.lang.Object retryPolicy;
            java.lang.Object timeout;

            /**
             * Sets the value of {@link HttpRouteProperty#getAction}
             * @param action An object that represents the action to take if a match is determined. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.IResolvable action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteProperty#getAction}
             * @param action An object that represents the action to take if a match is determined. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteActionProperty action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteProperty#getMatch}
             * @param match An object that represents the criteria for determining a request match. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.IResolvable match) {
                this.match = match;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteProperty#getMatch}
             * @param match An object that represents the criteria for determining a request match. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteMatchProperty match) {
                this.match = match;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteProperty#getRetryPolicy}
             * @param retryPolicy An object that represents a retry policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryPolicy(software.amazon.awscdk.IResolvable retryPolicy) {
                this.retryPolicy = retryPolicy;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteProperty#getRetryPolicy}
             * @param retryPolicy An object that represents a retry policy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryPolicy(software.amazon.awscdk.services.appmesh.CfnRoute.HttpRetryPolicyProperty retryPolicy) {
                this.retryPolicy = retryPolicy;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteProperty#getTimeout}
             * @param timeout An object that represents types of timeouts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(software.amazon.awscdk.IResolvable timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Sets the value of {@link HttpRouteProperty#getTimeout}
             * @param timeout An object that represents types of timeouts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(software.amazon.awscdk.services.appmesh.CfnRoute.HttpTimeoutProperty timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpRouteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpRouteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpRouteProperty {
            private final java.lang.Object action;
            private final java.lang.Object match;
            private final java.lang.Object retryPolicy;
            private final java.lang.Object timeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.match = software.amazon.jsii.Kernel.get(this, "match", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retryPolicy = software.amazon.jsii.Kernel.get(this, "retryPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.match = java.util.Objects.requireNonNull(builder.match, "match is required");
                this.retryPolicy = builder.retryPolicy;
                this.timeout = builder.timeout;
            }

            @Override
            public final java.lang.Object getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Object getMatch() {
                return this.match;
            }

            @Override
            public final java.lang.Object getRetryPolicy() {
                return this.retryPolicy;
            }

            @Override
            public final java.lang.Object getTimeout() {
                return this.timeout;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("match", om.valueToTree(this.getMatch()));
                if (this.getRetryPolicy() != null) {
                    data.set("retryPolicy", om.valueToTree(this.getRetryPolicy()));
                }
                if (this.getTimeout() != null) {
                    data.set("timeout", om.valueToTree(this.getTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.HttpRouteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpRouteProperty.Jsii$Proxy that = (HttpRouteProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!match.equals(that.match)) return false;
                if (this.retryPolicy != null ? !this.retryPolicy.equals(that.retryPolicy) : that.retryPolicy != null) return false;
                return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.match.hashCode());
                result = 31 * result + (this.retryPolicy != null ? this.retryPolicy.hashCode() : 0);
                result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents types of timeouts.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * HttpTimeoutProperty httpTimeoutProperty = HttpTimeoutProperty.builder()
     *         .idle(DurationProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .perRequest(DurationProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httptimeout.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httptimeout.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.HttpTimeoutProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpTimeoutProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpTimeoutProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents an idle timeout.
         * <p>
         * An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httptimeout.html#cfn-appmesh-route-httptimeout-idle">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httptimeout.html#cfn-appmesh-route-httptimeout-idle</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIdle() {
            return null;
        }

        /**
         * An object that represents a per request timeout.
         * <p>
         * The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15 seconds for the source and destination virtual node and the route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httptimeout.html#cfn-appmesh-route-httptimeout-perrequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-httptimeout.html#cfn-appmesh-route-httptimeout-perrequest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPerRequest() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpTimeoutProperty> {
            java.lang.Object idle;
            java.lang.Object perRequest;

            /**
             * Sets the value of {@link HttpTimeoutProperty#getIdle}
             * @param idle An object that represents an idle timeout.
             *             An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idle(software.amazon.awscdk.IResolvable idle) {
                this.idle = idle;
                return this;
            }

            /**
             * Sets the value of {@link HttpTimeoutProperty#getIdle}
             * @param idle An object that represents an idle timeout.
             *             An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idle(software.amazon.awscdk.services.appmesh.CfnRoute.DurationProperty idle) {
                this.idle = idle;
                return this;
            }

            /**
             * Sets the value of {@link HttpTimeoutProperty#getPerRequest}
             * @param perRequest An object that represents a per request timeout.
             *                   The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15 seconds for the source and destination virtual node and the route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perRequest(software.amazon.awscdk.IResolvable perRequest) {
                this.perRequest = perRequest;
                return this;
            }

            /**
             * Sets the value of {@link HttpTimeoutProperty#getPerRequest}
             * @param perRequest An object that represents a per request timeout.
             *                   The default value is 15 seconds. If you set a higher timeout, then make sure that the higher value is set for each App Mesh resource in a conversation. For example, if a virtual node backend uses a virtual router provider to route to another virtual node, then the timeout should be greater than 15 seconds for the source and destination virtual node and the route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perRequest(software.amazon.awscdk.services.appmesh.CfnRoute.DurationProperty perRequest) {
                this.perRequest = perRequest;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpTimeoutProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpTimeoutProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpTimeoutProperty {
            private final java.lang.Object idle;
            private final java.lang.Object perRequest;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idle = software.amazon.jsii.Kernel.get(this, "idle", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.perRequest = software.amazon.jsii.Kernel.get(this, "perRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idle = builder.idle;
                this.perRequest = builder.perRequest;
            }

            @Override
            public final java.lang.Object getIdle() {
                return this.idle;
            }

            @Override
            public final java.lang.Object getPerRequest() {
                return this.perRequest;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIdle() != null) {
                    data.set("idle", om.valueToTree(this.getIdle()));
                }
                if (this.getPerRequest() != null) {
                    data.set("perRequest", om.valueToTree(this.getPerRequest()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.HttpTimeoutProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpTimeoutProperty.Jsii$Proxy that = (HttpTimeoutProperty.Jsii$Proxy) o;

                if (this.idle != null ? !this.idle.equals(that.idle) : that.idle != null) return false;
                return this.perRequest != null ? this.perRequest.equals(that.perRequest) : that.perRequest == null;
            }

            @Override
            public final int hashCode() {
                int result = this.idle != null ? this.idle.hashCode() : 0;
                result = 31 * result + (this.perRequest != null ? this.perRequest.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the range of values to match on.
     * <p>
     * The first character of the range is included in the range, though the last character is not. For example, if the range specified were 1-100, only values 1-99 would be matched.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * MatchRangeProperty matchRangeProperty = MatchRangeProperty.builder()
     *         .end(123)
     *         .start(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-matchrange.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-matchrange.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.MatchRangeProperty")
    @software.amazon.jsii.Jsii.Proxy(MatchRangeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MatchRangeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The end of the range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-matchrange.html#cfn-appmesh-route-matchrange-end">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-matchrange.html#cfn-appmesh-route-matchrange-end</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getEnd();

        /**
         * The start of the range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-matchrange.html#cfn-appmesh-route-matchrange-start">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-matchrange.html#cfn-appmesh-route-matchrange-start</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getStart();

        /**
         * @return a {@link Builder} of {@link MatchRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MatchRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MatchRangeProperty> {
            java.lang.Number end;
            java.lang.Number start;

            /**
             * Sets the value of {@link MatchRangeProperty#getEnd}
             * @param end The end of the range. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder end(java.lang.Number end) {
                this.end = end;
                return this;
            }

            /**
             * Sets the value of {@link MatchRangeProperty#getStart}
             * @param start The start of the range. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder start(java.lang.Number start) {
                this.start = start;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MatchRangeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MatchRangeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MatchRangeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MatchRangeProperty {
            private final java.lang.Number end;
            private final java.lang.Number start;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.end = software.amazon.jsii.Kernel.get(this, "end", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.start = software.amazon.jsii.Kernel.get(this, "start", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.end = java.util.Objects.requireNonNull(builder.end, "end is required");
                this.start = java.util.Objects.requireNonNull(builder.start, "start is required");
            }

            @Override
            public final java.lang.Number getEnd() {
                return this.end;
            }

            @Override
            public final java.lang.Number getStart() {
                return this.start;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("end", om.valueToTree(this.getEnd()));
                data.set("start", om.valueToTree(this.getStart()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.MatchRangeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MatchRangeProperty.Jsii$Proxy that = (MatchRangeProperty.Jsii$Proxy) o;

                if (!end.equals(that.end)) return false;
                return this.start.equals(that.start);
            }

            @Override
            public final int hashCode() {
                int result = this.end.hashCode();
                result = 31 * result + (this.start.hashCode());
                return result;
            }
        }
    }
    /**
     * An object that represents the query parameter in the request.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * QueryParameterProperty queryParameterProperty = QueryParameterProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .match(HttpQueryParameterMatchProperty.builder()
     *                 .exact("exact")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-queryparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-queryparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.QueryParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(QueryParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the query parameter that will be matched on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-queryparameter.html#cfn-appmesh-route-queryparameter-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-queryparameter.html#cfn-appmesh-route-queryparameter-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The query parameter to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-queryparameter.html#cfn-appmesh-route-queryparameter-match">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-queryparameter.html#cfn-appmesh-route-queryparameter-match</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMatch() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link QueryParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueryParameterProperty> {
            java.lang.String name;
            java.lang.Object match;

            /**
             * Sets the value of {@link QueryParameterProperty#getName}
             * @param name A name for the query parameter that will be matched on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link QueryParameterProperty#getMatch}
             * @param match The query parameter to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.IResolvable match) {
                this.match = match;
                return this;
            }

            /**
             * Sets the value of {@link QueryParameterProperty#getMatch}
             * @param match The query parameter to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.services.appmesh.CfnRoute.HttpQueryParameterMatchProperty match) {
                this.match = match;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueryParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueryParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryParameterProperty {
            private final java.lang.String name;
            private final java.lang.Object match;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.match = software.amazon.jsii.Kernel.get(this, "match", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.match = builder.match;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getMatch() {
                return this.match;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getMatch() != null) {
                    data.set("match", om.valueToTree(this.getMatch()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.QueryParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryParameterProperty.Jsii$Proxy that = (QueryParameterProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.match != null ? this.match.equals(that.match) : that.match == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.match != null ? this.match.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents a route specification.
     * <p>
     * Specify one route type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * RouteSpecProperty routeSpecProperty = RouteSpecProperty.builder()
     *         .grpcRoute(GrpcRouteProperty.builder()
     *                 .action(GrpcRouteActionProperty.builder()
     *                         .weightedTargets(List.of(WeightedTargetProperty.builder()
     *                                 .virtualNode("virtualNode")
     *                                 .weight(123)
     *                                 // the properties below are optional
     *                                 .port(123)
     *                                 .build()))
     *                         .build())
     *                 .match(GrpcRouteMatchProperty.builder()
     *                         .metadata(List.of(GrpcRouteMetadataProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .invert(false)
     *                                 .match(GrpcRouteMetadataMatchMethodProperty.builder()
     *                                         .exact("exact")
     *                                         .prefix("prefix")
     *                                         .range(MatchRangeProperty.builder()
     *                                                 .end(123)
     *                                                 .start(123)
     *                                                 .build())
     *                                         .regex("regex")
     *                                         .suffix("suffix")
     *                                         .build())
     *                                 .build()))
     *                         .methodName("methodName")
     *                         .port(123)
     *                         .serviceName("serviceName")
     *                         .build())
     *                 // the properties below are optional
     *                 .retryPolicy(GrpcRetryPolicyProperty.builder()
     *                         .maxRetries(123)
     *                         .perRetryTimeout(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .grpcRetryEvents(List.of("grpcRetryEvents"))
     *                         .httpRetryEvents(List.of("httpRetryEvents"))
     *                         .tcpRetryEvents(List.of("tcpRetryEvents"))
     *                         .build())
     *                 .timeout(GrpcTimeoutProperty.builder()
     *                         .idle(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .perRequest(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .http2Route(HttpRouteProperty.builder()
     *                 .action(HttpRouteActionProperty.builder()
     *                         .weightedTargets(List.of(WeightedTargetProperty.builder()
     *                                 .virtualNode("virtualNode")
     *                                 .weight(123)
     *                                 // the properties below are optional
     *                                 .port(123)
     *                                 .build()))
     *                         .build())
     *                 .match(HttpRouteMatchProperty.builder()
     *                         .headers(List.of(HttpRouteHeaderProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .invert(false)
     *                                 .match(HeaderMatchMethodProperty.builder()
     *                                         .exact("exact")
     *                                         .prefix("prefix")
     *                                         .range(MatchRangeProperty.builder()
     *                                                 .end(123)
     *                                                 .start(123)
     *                                                 .build())
     *                                         .regex("regex")
     *                                         .suffix("suffix")
     *                                         .build())
     *                                 .build()))
     *                         .method("method")
     *                         .path(HttpPathMatchProperty.builder()
     *                                 .exact("exact")
     *                                 .regex("regex")
     *                                 .build())
     *                         .port(123)
     *                         .prefix("prefix")
     *                         .queryParameters(List.of(QueryParameterProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .match(HttpQueryParameterMatchProperty.builder()
     *                                         .exact("exact")
     *                                         .build())
     *                                 .build()))
     *                         .scheme("scheme")
     *                         .build())
     *                 // the properties below are optional
     *                 .retryPolicy(HttpRetryPolicyProperty.builder()
     *                         .maxRetries(123)
     *                         .perRetryTimeout(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .httpRetryEvents(List.of("httpRetryEvents"))
     *                         .tcpRetryEvents(List.of("tcpRetryEvents"))
     *                         .build())
     *                 .timeout(HttpTimeoutProperty.builder()
     *                         .idle(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .perRequest(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .httpRoute(HttpRouteProperty.builder()
     *                 .action(HttpRouteActionProperty.builder()
     *                         .weightedTargets(List.of(WeightedTargetProperty.builder()
     *                                 .virtualNode("virtualNode")
     *                                 .weight(123)
     *                                 // the properties below are optional
     *                                 .port(123)
     *                                 .build()))
     *                         .build())
     *                 .match(HttpRouteMatchProperty.builder()
     *                         .headers(List.of(HttpRouteHeaderProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .invert(false)
     *                                 .match(HeaderMatchMethodProperty.builder()
     *                                         .exact("exact")
     *                                         .prefix("prefix")
     *                                         .range(MatchRangeProperty.builder()
     *                                                 .end(123)
     *                                                 .start(123)
     *                                                 .build())
     *                                         .regex("regex")
     *                                         .suffix("suffix")
     *                                         .build())
     *                                 .build()))
     *                         .method("method")
     *                         .path(HttpPathMatchProperty.builder()
     *                                 .exact("exact")
     *                                 .regex("regex")
     *                                 .build())
     *                         .port(123)
     *                         .prefix("prefix")
     *                         .queryParameters(List.of(QueryParameterProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .match(HttpQueryParameterMatchProperty.builder()
     *                                         .exact("exact")
     *                                         .build())
     *                                 .build()))
     *                         .scheme("scheme")
     *                         .build())
     *                 // the properties below are optional
     *                 .retryPolicy(HttpRetryPolicyProperty.builder()
     *                         .maxRetries(123)
     *                         .perRetryTimeout(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         // the properties below are optional
     *                         .httpRetryEvents(List.of("httpRetryEvents"))
     *                         .tcpRetryEvents(List.of("tcpRetryEvents"))
     *                         .build())
     *                 .timeout(HttpTimeoutProperty.builder()
     *                         .idle(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .perRequest(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .priority(123)
     *         .tcpRoute(TcpRouteProperty.builder()
     *                 .action(TcpRouteActionProperty.builder()
     *                         .weightedTargets(List.of(WeightedTargetProperty.builder()
     *                                 .virtualNode("virtualNode")
     *                                 .weight(123)
     *                                 // the properties below are optional
     *                                 .port(123)
     *                                 .build()))
     *                         .build())
     *                 // the properties below are optional
     *                 .match(TcpRouteMatchProperty.builder()
     *                         .port(123)
     *                         .build())
     *                 .timeout(TcpTimeoutProperty.builder()
     *                         .idle(DurationProperty.builder()
     *                                 .unit("unit")
     *                                 .value(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.RouteSpecProperty")
    @software.amazon.jsii.Jsii.Proxy(RouteSpecProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RouteSpecProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents the specification of a gRPC route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-grpcroute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-grpcroute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGrpcRoute() {
            return null;
        }

        /**
         * An object that represents the specification of an HTTP/2 route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-http2route">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-http2route</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttp2Route() {
            return null;
        }

        /**
         * An object that represents the specification of an HTTP route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-httproute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-httproute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttpRoute() {
            return null;
        }

        /**
         * The priority for the route.
         * <p>
         * Routes are matched based on the specified value, where 0 is the highest priority.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-priority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-priority</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPriority() {
            return null;
        }

        /**
         * An object that represents the specification of a TCP route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-tcproute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-routespec.html#cfn-appmesh-route-routespec-tcproute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTcpRoute() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RouteSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RouteSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RouteSpecProperty> {
            java.lang.Object grpcRoute;
            java.lang.Object http2Route;
            java.lang.Object httpRoute;
            java.lang.Number priority;
            java.lang.Object tcpRoute;

            /**
             * Sets the value of {@link RouteSpecProperty#getGrpcRoute}
             * @param grpcRoute An object that represents the specification of a gRPC route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grpcRoute(software.amazon.awscdk.IResolvable grpcRoute) {
                this.grpcRoute = grpcRoute;
                return this;
            }

            /**
             * Sets the value of {@link RouteSpecProperty#getGrpcRoute}
             * @param grpcRoute An object that represents the specification of a gRPC route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder grpcRoute(software.amazon.awscdk.services.appmesh.CfnRoute.GrpcRouteProperty grpcRoute) {
                this.grpcRoute = grpcRoute;
                return this;
            }

            /**
             * Sets the value of {@link RouteSpecProperty#getHttp2Route}
             * @param http2Route An object that represents the specification of an HTTP/2 route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http2Route(software.amazon.awscdk.IResolvable http2Route) {
                this.http2Route = http2Route;
                return this;
            }

            /**
             * Sets the value of {@link RouteSpecProperty#getHttp2Route}
             * @param http2Route An object that represents the specification of an HTTP/2 route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder http2Route(software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteProperty http2Route) {
                this.http2Route = http2Route;
                return this;
            }

            /**
             * Sets the value of {@link RouteSpecProperty#getHttpRoute}
             * @param httpRoute An object that represents the specification of an HTTP route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpRoute(software.amazon.awscdk.IResolvable httpRoute) {
                this.httpRoute = httpRoute;
                return this;
            }

            /**
             * Sets the value of {@link RouteSpecProperty#getHttpRoute}
             * @param httpRoute An object that represents the specification of an HTTP route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpRoute(software.amazon.awscdk.services.appmesh.CfnRoute.HttpRouteProperty httpRoute) {
                this.httpRoute = httpRoute;
                return this;
            }

            /**
             * Sets the value of {@link RouteSpecProperty#getPriority}
             * @param priority The priority for the route.
             *                 Routes are matched based on the specified value, where 0 is the highest priority.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priority(java.lang.Number priority) {
                this.priority = priority;
                return this;
            }

            /**
             * Sets the value of {@link RouteSpecProperty#getTcpRoute}
             * @param tcpRoute An object that represents the specification of a TCP route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tcpRoute(software.amazon.awscdk.IResolvable tcpRoute) {
                this.tcpRoute = tcpRoute;
                return this;
            }

            /**
             * Sets the value of {@link RouteSpecProperty#getTcpRoute}
             * @param tcpRoute An object that represents the specification of a TCP route.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tcpRoute(software.amazon.awscdk.services.appmesh.CfnRoute.TcpRouteProperty tcpRoute) {
                this.tcpRoute = tcpRoute;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RouteSpecProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RouteSpecProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RouteSpecProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RouteSpecProperty {
            private final java.lang.Object grpcRoute;
            private final java.lang.Object http2Route;
            private final java.lang.Object httpRoute;
            private final java.lang.Number priority;
            private final java.lang.Object tcpRoute;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.grpcRoute = software.amazon.jsii.Kernel.get(this, "grpcRoute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.http2Route = software.amazon.jsii.Kernel.get(this, "http2Route", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.httpRoute = software.amazon.jsii.Kernel.get(this, "httpRoute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.tcpRoute = software.amazon.jsii.Kernel.get(this, "tcpRoute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.grpcRoute = builder.grpcRoute;
                this.http2Route = builder.http2Route;
                this.httpRoute = builder.httpRoute;
                this.priority = builder.priority;
                this.tcpRoute = builder.tcpRoute;
            }

            @Override
            public final java.lang.Object getGrpcRoute() {
                return this.grpcRoute;
            }

            @Override
            public final java.lang.Object getHttp2Route() {
                return this.http2Route;
            }

            @Override
            public final java.lang.Object getHttpRoute() {
                return this.httpRoute;
            }

            @Override
            public final java.lang.Number getPriority() {
                return this.priority;
            }

            @Override
            public final java.lang.Object getTcpRoute() {
                return this.tcpRoute;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGrpcRoute() != null) {
                    data.set("grpcRoute", om.valueToTree(this.getGrpcRoute()));
                }
                if (this.getHttp2Route() != null) {
                    data.set("http2Route", om.valueToTree(this.getHttp2Route()));
                }
                if (this.getHttpRoute() != null) {
                    data.set("httpRoute", om.valueToTree(this.getHttpRoute()));
                }
                if (this.getPriority() != null) {
                    data.set("priority", om.valueToTree(this.getPriority()));
                }
                if (this.getTcpRoute() != null) {
                    data.set("tcpRoute", om.valueToTree(this.getTcpRoute()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.RouteSpecProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RouteSpecProperty.Jsii$Proxy that = (RouteSpecProperty.Jsii$Proxy) o;

                if (this.grpcRoute != null ? !this.grpcRoute.equals(that.grpcRoute) : that.grpcRoute != null) return false;
                if (this.http2Route != null ? !this.http2Route.equals(that.http2Route) : that.http2Route != null) return false;
                if (this.httpRoute != null ? !this.httpRoute.equals(that.httpRoute) : that.httpRoute != null) return false;
                if (this.priority != null ? !this.priority.equals(that.priority) : that.priority != null) return false;
                return this.tcpRoute != null ? this.tcpRoute.equals(that.tcpRoute) : that.tcpRoute == null;
            }

            @Override
            public final int hashCode() {
                int result = this.grpcRoute != null ? this.grpcRoute.hashCode() : 0;
                result = 31 * result + (this.http2Route != null ? this.http2Route.hashCode() : 0);
                result = 31 * result + (this.httpRoute != null ? this.httpRoute.hashCode() : 0);
                result = 31 * result + (this.priority != null ? this.priority.hashCode() : 0);
                result = 31 * result + (this.tcpRoute != null ? this.tcpRoute.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the action to take if a match is determined.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * TcpRouteActionProperty tcpRouteActionProperty = TcpRouteActionProperty.builder()
     *         .weightedTargets(List.of(WeightedTargetProperty.builder()
     *                 .virtualNode("virtualNode")
     *                 .weight(123)
     *                 // the properties below are optional
     *                 .port(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcprouteaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcprouteaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.TcpRouteActionProperty")
    @software.amazon.jsii.Jsii.Proxy(TcpRouteActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TcpRouteActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents the targets that traffic is routed to when a request matches the route.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcprouteaction.html#cfn-appmesh-route-tcprouteaction-weightedtargets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcprouteaction.html#cfn-appmesh-route-tcprouteaction-weightedtargets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getWeightedTargets();

        /**
         * @return a {@link Builder} of {@link TcpRouteActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TcpRouteActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TcpRouteActionProperty> {
            java.lang.Object weightedTargets;

            /**
             * Sets the value of {@link TcpRouteActionProperty#getWeightedTargets}
             * @param weightedTargets An object that represents the targets that traffic is routed to when a request matches the route. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weightedTargets(software.amazon.awscdk.IResolvable weightedTargets) {
                this.weightedTargets = weightedTargets;
                return this;
            }

            /**
             * Sets the value of {@link TcpRouteActionProperty#getWeightedTargets}
             * @param weightedTargets An object that represents the targets that traffic is routed to when a request matches the route. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weightedTargets(java.util.List<? extends java.lang.Object> weightedTargets) {
                this.weightedTargets = weightedTargets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TcpRouteActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TcpRouteActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TcpRouteActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TcpRouteActionProperty {
            private final java.lang.Object weightedTargets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.weightedTargets = software.amazon.jsii.Kernel.get(this, "weightedTargets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.weightedTargets = java.util.Objects.requireNonNull(builder.weightedTargets, "weightedTargets is required");
            }

            @Override
            public final java.lang.Object getWeightedTargets() {
                return this.weightedTargets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("weightedTargets", om.valueToTree(this.getWeightedTargets()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.TcpRouteActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TcpRouteActionProperty.Jsii$Proxy that = (TcpRouteActionProperty.Jsii$Proxy) o;

                return this.weightedTargets.equals(that.weightedTargets);
            }

            @Override
            public final int hashCode() {
                int result = this.weightedTargets.hashCode();
                return result;
            }
        }
    }
    /**
     * An object representing the TCP route to match.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * TcpRouteMatchProperty tcpRouteMatchProperty = TcpRouteMatchProperty.builder()
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproutematch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproutematch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.TcpRouteMatchProperty")
    @software.amazon.jsii.Jsii.Proxy(TcpRouteMatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TcpRouteMatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The port number to match on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproutematch.html#cfn-appmesh-route-tcproutematch-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproutematch.html#cfn-appmesh-route-tcproutematch-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TcpRouteMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TcpRouteMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TcpRouteMatchProperty> {
            java.lang.Number port;

            /**
             * Sets the value of {@link TcpRouteMatchProperty#getPort}
             * @param port The port number to match on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TcpRouteMatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TcpRouteMatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TcpRouteMatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TcpRouteMatchProperty {
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.port = builder.port;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.TcpRouteMatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TcpRouteMatchProperty.Jsii$Proxy that = (TcpRouteMatchProperty.Jsii$Proxy) o;

                return this.port != null ? this.port.equals(that.port) : that.port == null;
            }

            @Override
            public final int hashCode() {
                int result = this.port != null ? this.port.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents a TCP route type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * TcpRouteProperty tcpRouteProperty = TcpRouteProperty.builder()
     *         .action(TcpRouteActionProperty.builder()
     *                 .weightedTargets(List.of(WeightedTargetProperty.builder()
     *                         .virtualNode("virtualNode")
     *                         .weight(123)
     *                         // the properties below are optional
     *                         .port(123)
     *                         .build()))
     *                 .build())
     *         // the properties below are optional
     *         .match(TcpRouteMatchProperty.builder()
     *                 .port(123)
     *                 .build())
     *         .timeout(TcpTimeoutProperty.builder()
     *                 .idle(DurationProperty.builder()
     *                         .unit("unit")
     *                         .value(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproute.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.TcpRouteProperty")
    @software.amazon.jsii.Jsii.Proxy(TcpRouteProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TcpRouteProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to take if a match is determined.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproute.html#cfn-appmesh-route-tcproute-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproute.html#cfn-appmesh-route-tcproute-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAction();

        /**
         * An object that represents the criteria for determining a request match.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproute.html#cfn-appmesh-route-tcproute-match">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproute.html#cfn-appmesh-route-tcproute-match</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMatch() {
            return null;
        }

        /**
         * An object that represents types of timeouts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproute.html#cfn-appmesh-route-tcproute-timeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcproute.html#cfn-appmesh-route-tcproute-timeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeout() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TcpRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TcpRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TcpRouteProperty> {
            java.lang.Object action;
            java.lang.Object match;
            java.lang.Object timeout;

            /**
             * Sets the value of {@link TcpRouteProperty#getAction}
             * @param action The action to take if a match is determined. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.IResolvable action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link TcpRouteProperty#getAction}
             * @param action The action to take if a match is determined. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.services.appmesh.CfnRoute.TcpRouteActionProperty action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link TcpRouteProperty#getMatch}
             * @param match An object that represents the criteria for determining a request match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.IResolvable match) {
                this.match = match;
                return this;
            }

            /**
             * Sets the value of {@link TcpRouteProperty#getMatch}
             * @param match An object that represents the criteria for determining a request match.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder match(software.amazon.awscdk.services.appmesh.CfnRoute.TcpRouteMatchProperty match) {
                this.match = match;
                return this;
            }

            /**
             * Sets the value of {@link TcpRouteProperty#getTimeout}
             * @param timeout An object that represents types of timeouts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(software.amazon.awscdk.IResolvable timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Sets the value of {@link TcpRouteProperty#getTimeout}
             * @param timeout An object that represents types of timeouts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(software.amazon.awscdk.services.appmesh.CfnRoute.TcpTimeoutProperty timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TcpRouteProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TcpRouteProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TcpRouteProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TcpRouteProperty {
            private final java.lang.Object action;
            private final java.lang.Object match;
            private final java.lang.Object timeout;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.match = software.amazon.jsii.Kernel.get(this, "match", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.match = builder.match;
                this.timeout = builder.timeout;
            }

            @Override
            public final java.lang.Object getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Object getMatch() {
                return this.match;
            }

            @Override
            public final java.lang.Object getTimeout() {
                return this.timeout;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                if (this.getMatch() != null) {
                    data.set("match", om.valueToTree(this.getMatch()));
                }
                if (this.getTimeout() != null) {
                    data.set("timeout", om.valueToTree(this.getTimeout()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.TcpRouteProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TcpRouteProperty.Jsii$Proxy that = (TcpRouteProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (this.match != null ? !this.match.equals(that.match) : that.match != null) return false;
                return this.timeout != null ? this.timeout.equals(that.timeout) : that.timeout == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.match != null ? this.match.hashCode() : 0);
                result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents types of timeouts.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * TcpTimeoutProperty tcpTimeoutProperty = TcpTimeoutProperty.builder()
     *         .idle(DurationProperty.builder()
     *                 .unit("unit")
     *                 .value(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcptimeout.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcptimeout.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.TcpTimeoutProperty")
    @software.amazon.jsii.Jsii.Proxy(TcpTimeoutProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TcpTimeoutProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object that represents an idle timeout.
         * <p>
         * An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcptimeout.html#cfn-appmesh-route-tcptimeout-idle">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-tcptimeout.html#cfn-appmesh-route-tcptimeout-idle</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIdle() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TcpTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TcpTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TcpTimeoutProperty> {
            java.lang.Object idle;

            /**
             * Sets the value of {@link TcpTimeoutProperty#getIdle}
             * @param idle An object that represents an idle timeout.
             *             An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idle(software.amazon.awscdk.IResolvable idle) {
                this.idle = idle;
                return this;
            }

            /**
             * Sets the value of {@link TcpTimeoutProperty#getIdle}
             * @param idle An object that represents an idle timeout.
             *             An idle timeout bounds the amount of time that a connection may be idle. The default value is none.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idle(software.amazon.awscdk.services.appmesh.CfnRoute.DurationProperty idle) {
                this.idle = idle;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TcpTimeoutProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TcpTimeoutProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TcpTimeoutProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TcpTimeoutProperty {
            private final java.lang.Object idle;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idle = software.amazon.jsii.Kernel.get(this, "idle", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idle = builder.idle;
            }

            @Override
            public final java.lang.Object getIdle() {
                return this.idle;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIdle() != null) {
                    data.set("idle", om.valueToTree(this.getIdle()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.TcpTimeoutProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TcpTimeoutProperty.Jsii$Proxy that = (TcpTimeoutProperty.Jsii$Proxy) o;

                return this.idle != null ? this.idle.equals(that.idle) : that.idle == null;
            }

            @Override
            public final int hashCode() {
                int result = this.idle != null ? this.idle.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents a target and its relative weight.
     * <p>
     * Traffic is distributed across targets according to their relative weight. For example, a weighted target with a relative weight of 50 receives five times as much traffic as one with a relative weight of 10. The total weight for all targets combined must be less than or equal to 100.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appmesh.*;
     * WeightedTargetProperty weightedTargetProperty = WeightedTargetProperty.builder()
     *         .virtualNode("virtualNode")
     *         .weight(123)
     *         // the properties below are optional
     *         .port(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-weightedtarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-weightedtarget.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnRoute.WeightedTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(WeightedTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WeightedTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The virtual node to associate with the weighted target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-weightedtarget.html#cfn-appmesh-route-weightedtarget-virtualnode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-weightedtarget.html#cfn-appmesh-route-weightedtarget-virtualnode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVirtualNode();

        /**
         * The relative weight of the weighted target.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-weightedtarget.html#cfn-appmesh-route-weightedtarget-weight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-weightedtarget.html#cfn-appmesh-route-weightedtarget-weight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getWeight();

        /**
         * The targeted port of the weighted object.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-weightedtarget.html#cfn-appmesh-route-weightedtarget-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appmesh-route-weightedtarget.html#cfn-appmesh-route-weightedtarget-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WeightedTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WeightedTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WeightedTargetProperty> {
            java.lang.String virtualNode;
            java.lang.Number weight;
            java.lang.Number port;

            /**
             * Sets the value of {@link WeightedTargetProperty#getVirtualNode}
             * @param virtualNode The virtual node to associate with the weighted target. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder virtualNode(java.lang.String virtualNode) {
                this.virtualNode = virtualNode;
                return this;
            }

            /**
             * Sets the value of {@link WeightedTargetProperty#getWeight}
             * @param weight The relative weight of the weighted target. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Sets the value of {@link WeightedTargetProperty#getPort}
             * @param port The targeted port of the weighted object.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WeightedTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WeightedTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WeightedTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WeightedTargetProperty {
            private final java.lang.String virtualNode;
            private final java.lang.Number weight;
            private final java.lang.Number port;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.virtualNode = software.amazon.jsii.Kernel.get(this, "virtualNode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.virtualNode = java.util.Objects.requireNonNull(builder.virtualNode, "virtualNode is required");
                this.weight = java.util.Objects.requireNonNull(builder.weight, "weight is required");
                this.port = builder.port;
            }

            @Override
            public final java.lang.String getVirtualNode() {
                return this.virtualNode;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("virtualNode", om.valueToTree(this.getVirtualNode()));
                data.set("weight", om.valueToTree(this.getWeight()));
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnRoute.WeightedTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WeightedTargetProperty.Jsii$Proxy that = (WeightedTargetProperty.Jsii$Proxy) o;

                if (!virtualNode.equals(that.virtualNode)) return false;
                if (!weight.equals(that.weight)) return false;
                return this.port != null ? this.port.equals(that.port) : that.port == null;
            }

            @Override
            public final int hashCode() {
                int result = this.virtualNode.hashCode();
                result = 31 * result + (this.weight.hashCode());
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appmesh.CfnRoute}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appmesh.CfnRoute> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appmesh.CfnRouteProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appmesh.CfnRouteProps.Builder();
        }

        /**
         * The name of the service mesh to create the route in.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshname</a>
         * @param meshName The name of the service mesh to create the route in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshName(final java.lang.String meshName) {
            this.props.meshName(meshName);
            return this;
        }

        /**
         * The route specification to apply.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-spec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-spec</a>
         * @param spec The route specification to apply. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spec(final software.amazon.awscdk.IResolvable spec) {
            this.props.spec(spec);
            return this;
        }
        /**
         * The route specification to apply.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-spec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-spec</a>
         * @param spec The route specification to apply. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spec(final software.amazon.awscdk.services.appmesh.CfnRoute.RouteSpecProperty spec) {
            this.props.spec(spec);
            return this;
        }

        /**
         * The name of the virtual router in which to create the route.
         * <p>
         * If the virtual router is in a shared mesh, then you must be the owner of the virtual router resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-virtualroutername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-virtualroutername</a>
         * @param virtualRouterName The name of the virtual router in which to create the route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualRouterName(final java.lang.String virtualRouterName) {
            this.props.virtualRouterName(virtualRouterName);
            return this;
        }

        /**
         * The AWS IAM account ID of the service mesh owner.
         * <p>
         * If the account ID is not your own, then the account that you specify must share the mesh with your account before you can create the resource in the service mesh. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-meshowner</a>
         * @param meshOwner The AWS IAM account ID of the service mesh owner. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshOwner(final java.lang.String meshOwner) {
            this.props.meshOwner(meshOwner);
            return this;
        }

        /**
         * The name to use for the route.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-routename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-routename</a>
         * @param routeName The name to use for the route. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder routeName(final java.lang.String routeName) {
            this.props.routeName(routeName);
            return this;
        }

        /**
         * Optional metadata that you can apply to the route to assist with categorization and organization.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-route.html#cfn-appmesh-route-tags</a>
         * @param tags Optional metadata that you can apply to the route to assist with categorization and organization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appmesh.CfnRoute}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appmesh.CfnRoute build() {
            return new software.amazon.awscdk.services.appmesh.CfnRoute(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
