package software.amazon.awscdk.services.appsync;

/**
 * A class used to generate resource arns for AppSync Event APIs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * AppSyncEventResource appSyncEventResource = AppSyncEventResource.all();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:11.353Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AppSyncEventResource")
public class AppSyncEventResource extends software.amazon.jsii.JsiiObject {

    protected AppSyncEventResource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AppSyncEventResource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Generate the resource names that accepts all types: <code>*</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppSyncEventResource all() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.AppSyncEventResource.class, "all", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncEventResource.class));
    }

    /**
     * Generate the resource names that accepts all channel namespaces: <code>*</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppSyncEventResource allChannelNamespaces() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.AppSyncEventResource.class, "allChannelNamespaces", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncEventResource.class));
    }

    /**
     * Generate a resource for the calling API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppSyncEventResource forAPI() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.AppSyncEventResource.class, "forAPI", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncEventResource.class));
    }

    /**
     * Generate the resource names given a channel namespace.
     * <p>
     * @param channelNamespace The channel namespace that needs to be allowed. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AppSyncEventResource ofChannelNamespace(final @org.jetbrains.annotations.NotNull java.lang.String channelNamespace) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.AppSyncEventResource.class, "ofChannelNamespace", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AppSyncEventResource.class), new Object[] { java.util.Objects.requireNonNull(channelNamespace, "channelNamespace is required") });
    }

    /**
     * Return the Resource ARN.
     * <p>
     * @param api The AppSync API to give permissions. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> resourceArns(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.EventApiBase api) {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "resourceArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(api, "api is required") }));
    }
}
