package software.amazon.awscdk.services.appsync;

/**
 * Represents source code for an AppSync Function or Resolver.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EventApi api;
 * AppSyncLambdaDataSource lambdaDataSource;
 * // Lambda data source for publish handler
 * api.addChannelNamespace("lambda-ns", ChannelNamespaceOptions.builder()
 *         .code(Code.fromInline("/* event handler code here.*&#47;"))
 *         .publishHandlerConfig(HandlerConfig.builder()
 *                 .dataSource(lambdaDataSource)
 *                 .build())
 *         .build());
 * // Direct Lambda data source for publish handler
 * api.addChannelNamespace("lambda-direct-ns", ChannelNamespaceOptions.builder()
 *         .publishHandlerConfig(HandlerConfig.builder()
 *                 .dataSource(lambdaDataSource)
 *                 .direct(true)
 *                 .build())
 *         .build());
 * api.addChannelNamespace("lambda-direct-async-ns", ChannelNamespaceOptions.builder()
 *         .publishHandlerConfig(HandlerConfig.builder()
 *                 .dataSource(lambdaDataSource)
 *                 .direct(true)
 *                 .lambdaInvokeType(LambdaInvokeType.EVENT)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:11.457Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.Code")
public abstract class Code extends software.amazon.jsii.JsiiObject {

    protected Code(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Code(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Code() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Loads the function code from a local disk path.
     * <p>
     * @param path The path to the source code file. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AssetCode fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Code.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AssetCode.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * Loads the function code from a local disk path.
     * <p>
     * @param path The path to the source code file. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AssetCode fromAsset(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Code.class, "fromAsset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AssetCode.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Inline code for AppSync function.
     * <p>
     * @return <code>InlineCode</code> with inline code.
     * @param code The actual handler code (the resulting zip file cannot exceed 4MB). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.InlineCode fromInline(final @org.jetbrains.annotations.NotNull java.lang.String code) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Code.class, "fromInline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.InlineCode.class), new Object[] { java.util.Objects.requireNonNull(code, "code is required") });
    }

    /**
     * Bind source code to an AppSync Function or resolver.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appsync.Code {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Bind source code to an AppSync Function or resolver.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.CodeConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.CodeConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
