package software.amazon.awscdk.services.appsync;

/**
 * MappingTemplates for AppSync resolvers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Build a data source for AppSync to access the database.
 * GraphqlApi api;
 * // Create username and password secret for DB Cluster
 * DatabaseSecret secret = DatabaseSecret.Builder.create(this, "AuroraSecret")
 *         .username("clusteradmin")
 *         .build();
 * // The VPC to place the cluster in
 * Vpc vpc = new Vpc(this, "AuroraVpc");
 * // Create the serverless cluster, provide all values needed to customise the database.
 * ServerlessCluster cluster = ServerlessCluster.Builder.create(this, "AuroraCluster")
 *         .engine(DatabaseClusterEngine.AURORA_MYSQL)
 *         .vpc(vpc)
 *         .credentials(Map.of("username", "clusteradmin"))
 *         .clusterIdentifier("db-endpoint-test")
 *         .defaultDatabaseName("demos")
 *         .build();
 * RdsDataSource rdsDS = api.addRdsDataSource("rds", cluster, secret, "demos");
 * // Set up a resolver for an RDS query.
 * rdsDS.createResolver("QueryGetDemosRdsResolver", BaseResolverProps.builder()
 *         .typeName("Query")
 *         .fieldName("getDemosRds")
 *         .requestMappingTemplate(MappingTemplate.fromString("\n  {\n    \"version\": \"2018-05-29\",\n    \"statements\": [\n      \"SELECT * FROM demos\"\n    ]\n  }\n  "))
 *         .responseMappingTemplate(MappingTemplate.fromString("\n    $utils.toJson($utils.rds.toJsonObject($ctx.result)[0])\n  "))
 *         .build());
 * // Set up a resolver for an RDS mutation.
 * rdsDS.createResolver("MutationAddDemoRdsResolver", BaseResolverProps.builder()
 *         .typeName("Mutation")
 *         .fieldName("addDemoRds")
 *         .requestMappingTemplate(MappingTemplate.fromString("\n  {\n    \"version\": \"2018-05-29\",\n    \"statements\": [\n      \"INSERT INTO demos VALUES (:id, :version)\",\n      \"SELECT * WHERE id = :id\"\n    ],\n    \"variableMap\": {\n      \":id\": $util.toJson($util.autoId()),\n      \":version\": $util.toJson($ctx.args.version)\n    }\n  }\n  "))
 *         .responseMappingTemplate(MappingTemplate.fromString("\n    $utils.toJson($utils.rds.toJsonObject($ctx.result)[1][0])\n  "))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:11.519Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.MappingTemplate")
public abstract class MappingTemplate extends software.amazon.jsii.JsiiObject {

    protected MappingTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MappingTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected MappingTemplate() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Mapping template to delete a single item from a DynamoDB table.
     * <p>
     * @param keyName the name of the hash key field. This parameter is required.
     * @param idArg the name of the Mutation argument. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MappingTemplate dynamoDbDeleteItem(final @org.jetbrains.annotations.NotNull java.lang.String keyName, final @org.jetbrains.annotations.NotNull java.lang.String idArg) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.MappingTemplate.class, "dynamoDbDeleteItem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class), new Object[] { java.util.Objects.requireNonNull(keyName, "keyName is required"), java.util.Objects.requireNonNull(idArg, "idArg is required") });
    }

    /**
     * Mapping template to get a single item from a DynamoDB table.
     * <p>
     * @param keyName the name of the hash key field. This parameter is required.
     * @param idArg the name of the Query argument. This parameter is required.
     * @param consistentRead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MappingTemplate dynamoDbGetItem(final @org.jetbrains.annotations.NotNull java.lang.String keyName, final @org.jetbrains.annotations.NotNull java.lang.String idArg, final @org.jetbrains.annotations.Nullable java.lang.Boolean consistentRead) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.MappingTemplate.class, "dynamoDbGetItem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class), new Object[] { java.util.Objects.requireNonNull(keyName, "keyName is required"), java.util.Objects.requireNonNull(idArg, "idArg is required"), consistentRead });
    }

    /**
     * Mapping template to get a single item from a DynamoDB table.
     * <p>
     * @param keyName the name of the hash key field. This parameter is required.
     * @param idArg the name of the Query argument. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MappingTemplate dynamoDbGetItem(final @org.jetbrains.annotations.NotNull java.lang.String keyName, final @org.jetbrains.annotations.NotNull java.lang.String idArg) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.MappingTemplate.class, "dynamoDbGetItem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class), new Object[] { java.util.Objects.requireNonNull(keyName, "keyName is required"), java.util.Objects.requireNonNull(idArg, "idArg is required") });
    }

    /**
     * Mapping template to save a single item to a DynamoDB table.
     * <p>
     * @param key the assigment of Mutation values to the primary key. This parameter is required.
     * @param values the assignment of Mutation values to the table attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MappingTemplate dynamoDbPutItem(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.PrimaryKey key, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AttributeValues values) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.MappingTemplate.class, "dynamoDbPutItem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class), new Object[] { java.util.Objects.requireNonNull(key, "key is required"), java.util.Objects.requireNonNull(values, "values is required") });
    }

    /**
     * Mapping template to query a set of items from a DynamoDB table.
     * <p>
     * @param cond the key condition for the query. This parameter is required.
     * @param indexName
     * @param consistentRead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MappingTemplate dynamoDbQuery(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.KeyCondition cond, final @org.jetbrains.annotations.Nullable java.lang.String indexName, final @org.jetbrains.annotations.Nullable java.lang.Boolean consistentRead) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.MappingTemplate.class, "dynamoDbQuery", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class), new Object[] { java.util.Objects.requireNonNull(cond, "cond is required"), indexName, consistentRead });
    }

    /**
     * Mapping template to query a set of items from a DynamoDB table.
     * <p>
     * @param cond the key condition for the query. This parameter is required.
     * @param indexName
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MappingTemplate dynamoDbQuery(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.KeyCondition cond, final @org.jetbrains.annotations.Nullable java.lang.String indexName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.MappingTemplate.class, "dynamoDbQuery", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class), new Object[] { java.util.Objects.requireNonNull(cond, "cond is required"), indexName });
    }

    /**
     * Mapping template to query a set of items from a DynamoDB table.
     * <p>
     * @param cond the key condition for the query. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MappingTemplate dynamoDbQuery(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.KeyCondition cond) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.MappingTemplate.class, "dynamoDbQuery", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class), new Object[] { java.util.Objects.requireNonNull(cond, "cond is required") });
    }

    /**
     * Mapping template for a single result item from DynamoDB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MappingTemplate dynamoDbResultItem() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.MappingTemplate.class, "dynamoDbResultItem", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class));
    }

    /**
     * Mapping template for a result list from DynamoDB.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MappingTemplate dynamoDbResultList() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.MappingTemplate.class, "dynamoDbResultList", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class));
    }

    /**
     * Mapping template to scan a DynamoDB table to fetch all entries.
     * <p>
     * @param consistentRead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MappingTemplate dynamoDbScanTable(final @org.jetbrains.annotations.Nullable java.lang.Boolean consistentRead) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.MappingTemplate.class, "dynamoDbScanTable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class), new Object[] { consistentRead });
    }

    /**
     * Mapping template to scan a DynamoDB table to fetch all entries.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MappingTemplate dynamoDbScanTable() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.MappingTemplate.class, "dynamoDbScanTable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class));
    }

    /**
     * Create a mapping template from the given file.
     * <p>
     * @param fileName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MappingTemplate fromFile(final @org.jetbrains.annotations.NotNull java.lang.String fileName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.MappingTemplate.class, "fromFile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class), new Object[] { java.util.Objects.requireNonNull(fileName, "fileName is required") });
    }

    /**
     * Create a mapping template from the given string.
     * <p>
     * @param template This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MappingTemplate fromString(final @org.jetbrains.annotations.NotNull java.lang.String template) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.MappingTemplate.class, "fromString", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class), new Object[] { java.util.Objects.requireNonNull(template, "template is required") });
    }

    /**
     * Mapping template to invoke a Lambda function.
     * <p>
     * @param payload the VTL template snippet of the payload to send to the lambda.
     * @param operation the type of operation AppSync should perform on the data source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MappingTemplate lambdaRequest(final @org.jetbrains.annotations.Nullable java.lang.String payload, final @org.jetbrains.annotations.Nullable java.lang.String operation) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.MappingTemplate.class, "lambdaRequest", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class), new Object[] { payload, operation });
    }

    /**
     * Mapping template to invoke a Lambda function.
     * <p>
     * @param payload the VTL template snippet of the payload to send to the lambda.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MappingTemplate lambdaRequest(final @org.jetbrains.annotations.Nullable java.lang.String payload) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.MappingTemplate.class, "lambdaRequest", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class), new Object[] { payload });
    }

    /**
     * Mapping template to invoke a Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MappingTemplate lambdaRequest() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.MappingTemplate.class, "lambdaRequest", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class));
    }

    /**
     * Mapping template to return the Lambda result to the caller.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.MappingTemplate lambdaResult() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.MappingTemplate.class, "lambdaResult", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class));
    }

    /**
     * this is called to render the mapping template to a VTL string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String renderTemplate();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appsync.MappingTemplate {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * this is called to render the mapping template to a VTL string.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull java.lang.String renderTemplate() {
            return software.amazon.jsii.Kernel.call(this, "renderTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }
    }
}
