package software.amazon.awscdk.services.apptest;

/**
 * Creates a test case for an application.
 * <p>
 * For more information about test cases, see <a href="https://docs.aws.amazon.com/m2/latest/userguide/testing-test-cases.html">Test cases</a> and <a href="https://docs.aws.amazon.com/m2/latest/userguide/concepts-apptest.html">Application Testing concepts</a> in the <em>AWS Mainframe Modernization User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apptest.*;
 * CfnTestCase cfnTestCase = CfnTestCase.Builder.create(this, "MyCfnTestCase")
 *         .name("name")
 *         .steps(List.of(StepProperty.builder()
 *                 .action(StepActionProperty.builder()
 *                         .compareAction(CompareActionProperty.builder()
 *                                 .input(InputProperty.builder()
 *                                         .file(InputFileProperty.builder()
 *                                                 .fileMetadata(FileMetadataProperty.builder()
 *                                                         .databaseCdc(DatabaseCDCProperty.builder()
 *                                                                 .sourceMetadata(SourceDatabaseMetadataProperty.builder()
 *                                                                         .captureTool("captureTool")
 *                                                                         .type("type")
 *                                                                         .build())
 *                                                                 .targetMetadata(TargetDatabaseMetadataProperty.builder()
 *                                                                         .captureTool("captureTool")
 *                                                                         .type("type")
 *                                                                         .build())
 *                                                                 .build())
 *                                                         .dataSets(List.of(DataSetProperty.builder()
 *                                                                 .ccsid("ccsid")
 *                                                                 .format("format")
 *                                                                 .length(123)
 *                                                                 .name("name")
 *                                                                 .type("type")
 *                                                                 .build()))
 *                                                         .build())
 *                                                 .sourceLocation("sourceLocation")
 *                                                 .targetLocation("targetLocation")
 *                                                 .build())
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .output(OutputProperty.builder()
 *                                         .file(OutputFileProperty.builder()
 *                                                 .fileLocation("fileLocation")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .mainframeAction(MainframeActionProperty.builder()
 *                                 .actionType(MainframeActionTypeProperty.builder()
 *                                         .batch(BatchProperty.builder()
 *                                                 .batchJobName("batchJobName")
 *                                                 // the properties below are optional
 *                                                 .batchJobParameters(Map.of(
 *                                                         "batchJobParametersKey", "batchJobParameters"))
 *                                                 .exportDataSetNames(List.of("exportDataSetNames"))
 *                                                 .build())
 *                                         .tn3270(TN3270Property.builder()
 *                                                 .script(ScriptProperty.builder()
 *                                                         .scriptLocation("scriptLocation")
 *                                                         .type("type")
 *                                                         .build())
 *                                                 // the properties below are optional
 *                                                 .exportDataSetNames(List.of("exportDataSetNames"))
 *                                                 .build())
 *                                         .build())
 *                                 .resource("resource")
 *                                 // the properties below are optional
 *                                 .properties(MainframeActionPropertiesProperty.builder()
 *                                         .dmsTaskArn("dmsTaskArn")
 *                                         .build())
 *                                 .build())
 *                         .resourceAction(ResourceActionProperty.builder()
 *                                 .cloudFormationAction(CloudFormationActionProperty.builder()
 *                                         .resource("resource")
 *                                         // the properties below are optional
 *                                         .actionType("actionType")
 *                                         .build())
 *                                 .m2ManagedApplicationAction(M2ManagedApplicationActionProperty.builder()
 *                                         .actionType("actionType")
 *                                         .resource("resource")
 *                                         // the properties below are optional
 *                                         .properties(M2ManagedActionPropertiesProperty.builder()
 *                                                 .forceStop(false)
 *                                                 .importDataSetLocation("importDataSetLocation")
 *                                                 .build())
 *                                         .build())
 *                                 .m2NonManagedApplicationAction(M2NonManagedApplicationActionProperty.builder()
 *                                         .actionType("actionType")
 *                                         .resource("resource")
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .name("name")
 *                 // the properties below are optional
 *                 .description("description")
 *                 .build()))
 *         // the properties below are optional
 *         .description("description")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:11.539Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase")
public class CfnTestCase extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnTestCase(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTestCase(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apptest.CfnTestCase.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTestCase(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apptest.CfnTestCaseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The creation time of the test case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The last update time of the test case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLastUpdateTime() {
        return software.amazon.jsii.Kernel.get(this, "attrLastUpdateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrLatestVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrLatestVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The status of the test case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the test case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTestCaseArn() {
        return software.amazon.jsii.Kernel.get(this, "attrTestCaseArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The response test case ID of the test case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTestCaseId() {
        return software.amazon.jsii.Kernel.get(this, "attrTestCaseId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the test case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrTestCaseVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrTestCaseVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the test case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the test case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The steps in the test case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSteps() {
        return software.amazon.jsii.Kernel.get(this, "steps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The steps in the test case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSteps(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "steps", java.util.Objects.requireNonNull(value, "steps is required"));
    }

    /**
     * The steps in the test case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSteps(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.apptest.CfnTestCase.StepProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.apptest.CfnTestCase.StepProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "steps", java.util.Objects.requireNonNull(value, "steps is required"));
    }

    /**
     * The description of the test case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the test case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The specified tags of the test case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The specified tags of the test case.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Defines a batch.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * BatchProperty batchProperty = BatchProperty.builder()
     *         .batchJobName("batchJobName")
     *         // the properties below are optional
     *         .batchJobParameters(Map.of(
     *                 "batchJobParametersKey", "batchJobParameters"))
     *         .exportDataSetNames(List.of("exportDataSetNames"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-batch.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-batch.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.BatchProperty")
    @software.amazon.jsii.Jsii.Proxy(BatchProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BatchProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The job name of the batch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-batch.html#cfn-apptest-testcase-batch-batchjobname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-batch.html#cfn-apptest-testcase-batch-batchjobname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBatchJobName();

        /**
         * The batch job parameters of the batch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-batch.html#cfn-apptest-testcase-batch-batchjobparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-batch.html#cfn-apptest-testcase-batch-batchjobparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBatchJobParameters() {
            return null;
        }

        /**
         * The export data set names of the batch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-batch.html#cfn-apptest-testcase-batch-exportdatasetnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-batch.html#cfn-apptest-testcase-batch-exportdatasetnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExportDataSetNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BatchProperty> {
            java.lang.String batchJobName;
            java.lang.Object batchJobParameters;
            java.util.List<java.lang.String> exportDataSetNames;

            /**
             * Sets the value of {@link BatchProperty#getBatchJobName}
             * @param batchJobName The job name of the batch. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchJobName(java.lang.String batchJobName) {
                this.batchJobName = batchJobName;
                return this;
            }

            /**
             * Sets the value of {@link BatchProperty#getBatchJobParameters}
             * @param batchJobParameters The batch job parameters of the batch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchJobParameters(java.util.Map<java.lang.String, java.lang.String> batchJobParameters) {
                this.batchJobParameters = batchJobParameters;
                return this;
            }

            /**
             * Sets the value of {@link BatchProperty#getBatchJobParameters}
             * @param batchJobParameters The batch job parameters of the batch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batchJobParameters(software.amazon.awscdk.IResolvable batchJobParameters) {
                this.batchJobParameters = batchJobParameters;
                return this;
            }

            /**
             * Sets the value of {@link BatchProperty#getExportDataSetNames}
             * @param exportDataSetNames The export data set names of the batch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportDataSetNames(java.util.List<java.lang.String> exportDataSetNames) {
                this.exportDataSetNames = exportDataSetNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BatchProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BatchProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BatchProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BatchProperty {
            private final java.lang.String batchJobName;
            private final java.lang.Object batchJobParameters;
            private final java.util.List<java.lang.String> exportDataSetNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.batchJobName = software.amazon.jsii.Kernel.get(this, "batchJobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.batchJobParameters = software.amazon.jsii.Kernel.get(this, "batchJobParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.exportDataSetNames = software.amazon.jsii.Kernel.get(this, "exportDataSetNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.batchJobName = java.util.Objects.requireNonNull(builder.batchJobName, "batchJobName is required");
                this.batchJobParameters = builder.batchJobParameters;
                this.exportDataSetNames = builder.exportDataSetNames;
            }

            @Override
            public final java.lang.String getBatchJobName() {
                return this.batchJobName;
            }

            @Override
            public final java.lang.Object getBatchJobParameters() {
                return this.batchJobParameters;
            }

            @Override
            public final java.util.List<java.lang.String> getExportDataSetNames() {
                return this.exportDataSetNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("batchJobName", om.valueToTree(this.getBatchJobName()));
                if (this.getBatchJobParameters() != null) {
                    data.set("batchJobParameters", om.valueToTree(this.getBatchJobParameters()));
                }
                if (this.getExportDataSetNames() != null) {
                    data.set("exportDataSetNames", om.valueToTree(this.getExportDataSetNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.BatchProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BatchProperty.Jsii$Proxy that = (BatchProperty.Jsii$Proxy) o;

                if (!batchJobName.equals(that.batchJobName)) return false;
                if (this.batchJobParameters != null ? !this.batchJobParameters.equals(that.batchJobParameters) : that.batchJobParameters != null) return false;
                return this.exportDataSetNames != null ? this.exportDataSetNames.equals(that.exportDataSetNames) : that.exportDataSetNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.batchJobName.hashCode();
                result = 31 * result + (this.batchJobParameters != null ? this.batchJobParameters.hashCode() : 0);
                result = 31 * result + (this.exportDataSetNames != null ? this.exportDataSetNames.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the CloudFormation action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * CloudFormationActionProperty cloudFormationActionProperty = CloudFormationActionProperty.builder()
     *         .resource("resource")
     *         // the properties below are optional
     *         .actionType("actionType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-cloudformationaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-cloudformationaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.CloudFormationActionProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudFormationActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudFormationActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The resource of the CloudFormation action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-cloudformationaction.html#cfn-apptest-testcase-cloudformationaction-resource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-cloudformationaction.html#cfn-apptest-testcase-cloudformationaction-resource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResource();

        /**
         * The action type of the CloudFormation action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-cloudformationaction.html#cfn-apptest-testcase-cloudformationaction-actiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-cloudformationaction.html#cfn-apptest-testcase-cloudformationaction-actiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getActionType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudFormationActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudFormationActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudFormationActionProperty> {
            java.lang.String resource;
            java.lang.String actionType;

            /**
             * Sets the value of {@link CloudFormationActionProperty#getResource}
             * @param resource The resource of the CloudFormation action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resource(java.lang.String resource) {
                this.resource = resource;
                return this;
            }

            /**
             * Sets the value of {@link CloudFormationActionProperty#getActionType}
             * @param actionType The action type of the CloudFormation action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionType(java.lang.String actionType) {
                this.actionType = actionType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudFormationActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudFormationActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudFormationActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudFormationActionProperty {
            private final java.lang.String resource;
            private final java.lang.String actionType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resource = software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.actionType = software.amazon.jsii.Kernel.get(this, "actionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resource = java.util.Objects.requireNonNull(builder.resource, "resource is required");
                this.actionType = builder.actionType;
            }

            @Override
            public final java.lang.String getResource() {
                return this.resource;
            }

            @Override
            public final java.lang.String getActionType() {
                return this.actionType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resource", om.valueToTree(this.getResource()));
                if (this.getActionType() != null) {
                    data.set("actionType", om.valueToTree(this.getActionType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.CloudFormationActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudFormationActionProperty.Jsii$Proxy that = (CloudFormationActionProperty.Jsii$Proxy) o;

                if (!resource.equals(that.resource)) return false;
                return this.actionType != null ? this.actionType.equals(that.actionType) : that.actionType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resource.hashCode();
                result = 31 * result + (this.actionType != null ? this.actionType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Compares the action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * CompareActionProperty compareActionProperty = CompareActionProperty.builder()
     *         .input(InputProperty.builder()
     *                 .file(InputFileProperty.builder()
     *                         .fileMetadata(FileMetadataProperty.builder()
     *                                 .databaseCdc(DatabaseCDCProperty.builder()
     *                                         .sourceMetadata(SourceDatabaseMetadataProperty.builder()
     *                                                 .captureTool("captureTool")
     *                                                 .type("type")
     *                                                 .build())
     *                                         .targetMetadata(TargetDatabaseMetadataProperty.builder()
     *                                                 .captureTool("captureTool")
     *                                                 .type("type")
     *                                                 .build())
     *                                         .build())
     *                                 .dataSets(List.of(DataSetProperty.builder()
     *                                         .ccsid("ccsid")
     *                                         .format("format")
     *                                         .length(123)
     *                                         .name("name")
     *                                         .type("type")
     *                                         .build()))
     *                                 .build())
     *                         .sourceLocation("sourceLocation")
     *                         .targetLocation("targetLocation")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .output(OutputProperty.builder()
     *                 .file(OutputFileProperty.builder()
     *                         .fileLocation("fileLocation")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-compareaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-compareaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.CompareActionProperty")
    @software.amazon.jsii.Jsii.Proxy(CompareActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CompareActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The input of the compare action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-compareaction.html#cfn-apptest-testcase-compareaction-input">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-compareaction.html#cfn-apptest-testcase-compareaction-input</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getInput();

        /**
         * The output of the compare action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-compareaction.html#cfn-apptest-testcase-compareaction-output">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-compareaction.html#cfn-apptest-testcase-compareaction-output</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CompareActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CompareActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CompareActionProperty> {
            java.lang.Object input;
            java.lang.Object output;

            /**
             * Sets the value of {@link CompareActionProperty#getInput}
             * @param input The input of the compare action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(software.amazon.awscdk.IResolvable input) {
                this.input = input;
                return this;
            }

            /**
             * Sets the value of {@link CompareActionProperty#getInput}
             * @param input The input of the compare action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(software.amazon.awscdk.services.apptest.CfnTestCase.InputProperty input) {
                this.input = input;
                return this;
            }

            /**
             * Sets the value of {@link CompareActionProperty#getOutput}
             * @param output The output of the compare action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder output(software.amazon.awscdk.IResolvable output) {
                this.output = output;
                return this;
            }

            /**
             * Sets the value of {@link CompareActionProperty#getOutput}
             * @param output The output of the compare action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder output(software.amazon.awscdk.services.apptest.CfnTestCase.OutputProperty output) {
                this.output = output;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CompareActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CompareActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CompareActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CompareActionProperty {
            private final java.lang.Object input;
            private final java.lang.Object output;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.output = software.amazon.jsii.Kernel.get(this, "output", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.input = java.util.Objects.requireNonNull(builder.input, "input is required");
                this.output = builder.output;
            }

            @Override
            public final java.lang.Object getInput() {
                return this.input;
            }

            @Override
            public final java.lang.Object getOutput() {
                return this.output;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("input", om.valueToTree(this.getInput()));
                if (this.getOutput() != null) {
                    data.set("output", om.valueToTree(this.getOutput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.CompareActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CompareActionProperty.Jsii$Proxy that = (CompareActionProperty.Jsii$Proxy) o;

                if (!input.equals(that.input)) return false;
                return this.output != null ? this.output.equals(that.output) : that.output == null;
            }

            @Override
            public final int hashCode() {
                int result = this.input.hashCode();
                result = 31 * result + (this.output != null ? this.output.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines a data set.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * DataSetProperty dataSetProperty = DataSetProperty.builder()
     *         .ccsid("ccsid")
     *         .format("format")
     *         .length(123)
     *         .name("name")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-dataset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-dataset.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.DataSetProperty")
    @software.amazon.jsii.Jsii.Proxy(DataSetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataSetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CCSID of the data set.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-dataset.html#cfn-apptest-testcase-dataset-ccsid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-dataset.html#cfn-apptest-testcase-dataset-ccsid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCcsid();

        /**
         * The format of the data set.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-dataset.html#cfn-apptest-testcase-dataset-format">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-dataset.html#cfn-apptest-testcase-dataset-format</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFormat();

        /**
         * The length of the data set.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-dataset.html#cfn-apptest-testcase-dataset-length">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-dataset.html#cfn-apptest-testcase-dataset-length</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getLength();

        /**
         * The name of the data set.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-dataset.html#cfn-apptest-testcase-dataset-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-dataset.html#cfn-apptest-testcase-dataset-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The type of the data set.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-dataset.html#cfn-apptest-testcase-dataset-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-dataset.html#cfn-apptest-testcase-dataset-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link DataSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataSetProperty> {
            java.lang.String ccsid;
            java.lang.String format;
            java.lang.Number length;
            java.lang.String name;
            java.lang.String type;

            /**
             * Sets the value of {@link DataSetProperty#getCcsid}
             * @param ccsid The CCSID of the data set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ccsid(java.lang.String ccsid) {
                this.ccsid = ccsid;
                return this;
            }

            /**
             * Sets the value of {@link DataSetProperty#getFormat}
             * @param format The format of the data set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder format(java.lang.String format) {
                this.format = format;
                return this;
            }

            /**
             * Sets the value of {@link DataSetProperty#getLength}
             * @param length The length of the data set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder length(java.lang.Number length) {
                this.length = length;
                return this;
            }

            /**
             * Sets the value of {@link DataSetProperty#getName}
             * @param name The name of the data set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DataSetProperty#getType}
             * @param type The type of the data set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataSetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataSetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataSetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataSetProperty {
            private final java.lang.String ccsid;
            private final java.lang.String format;
            private final java.lang.Number length;
            private final java.lang.String name;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ccsid = software.amazon.jsii.Kernel.get(this, "ccsid", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.length = software.amazon.jsii.Kernel.get(this, "length", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ccsid = java.util.Objects.requireNonNull(builder.ccsid, "ccsid is required");
                this.format = java.util.Objects.requireNonNull(builder.format, "format is required");
                this.length = java.util.Objects.requireNonNull(builder.length, "length is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getCcsid() {
                return this.ccsid;
            }

            @Override
            public final java.lang.String getFormat() {
                return this.format;
            }

            @Override
            public final java.lang.Number getLength() {
                return this.length;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("ccsid", om.valueToTree(this.getCcsid()));
                data.set("format", om.valueToTree(this.getFormat()));
                data.set("length", om.valueToTree(this.getLength()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.DataSetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataSetProperty.Jsii$Proxy that = (DataSetProperty.Jsii$Proxy) o;

                if (!ccsid.equals(that.ccsid)) return false;
                if (!format.equals(that.format)) return false;
                if (!length.equals(that.length)) return false;
                if (!name.equals(that.name)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.ccsid.hashCode();
                result = 31 * result + (this.format.hashCode());
                result = 31 * result + (this.length.hashCode());
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Defines the Change Data Capture (CDC) of the database.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * DatabaseCDCProperty databaseCDCProperty = DatabaseCDCProperty.builder()
     *         .sourceMetadata(SourceDatabaseMetadataProperty.builder()
     *                 .captureTool("captureTool")
     *                 .type("type")
     *                 .build())
     *         .targetMetadata(TargetDatabaseMetadataProperty.builder()
     *                 .captureTool("captureTool")
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-databasecdc.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-databasecdc.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.DatabaseCDCProperty")
    @software.amazon.jsii.Jsii.Proxy(DatabaseCDCProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatabaseCDCProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source metadata of the database CDC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-databasecdc.html#cfn-apptest-testcase-databasecdc-sourcemetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-databasecdc.html#cfn-apptest-testcase-databasecdc-sourcemetadata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSourceMetadata();

        /**
         * The target metadata of the database CDC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-databasecdc.html#cfn-apptest-testcase-databasecdc-targetmetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-databasecdc.html#cfn-apptest-testcase-databasecdc-targetmetadata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTargetMetadata();

        /**
         * @return a {@link Builder} of {@link DatabaseCDCProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatabaseCDCProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatabaseCDCProperty> {
            java.lang.Object sourceMetadata;
            java.lang.Object targetMetadata;

            /**
             * Sets the value of {@link DatabaseCDCProperty#getSourceMetadata}
             * @param sourceMetadata The source metadata of the database CDC. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceMetadata(software.amazon.awscdk.IResolvable sourceMetadata) {
                this.sourceMetadata = sourceMetadata;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseCDCProperty#getSourceMetadata}
             * @param sourceMetadata The source metadata of the database CDC. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceMetadata(software.amazon.awscdk.services.apptest.CfnTestCase.SourceDatabaseMetadataProperty sourceMetadata) {
                this.sourceMetadata = sourceMetadata;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseCDCProperty#getTargetMetadata}
             * @param targetMetadata The target metadata of the database CDC. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetMetadata(software.amazon.awscdk.IResolvable targetMetadata) {
                this.targetMetadata = targetMetadata;
                return this;
            }

            /**
             * Sets the value of {@link DatabaseCDCProperty#getTargetMetadata}
             * @param targetMetadata The target metadata of the database CDC. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetMetadata(software.amazon.awscdk.services.apptest.CfnTestCase.TargetDatabaseMetadataProperty targetMetadata) {
                this.targetMetadata = targetMetadata;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatabaseCDCProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatabaseCDCProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatabaseCDCProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatabaseCDCProperty {
            private final java.lang.Object sourceMetadata;
            private final java.lang.Object targetMetadata;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceMetadata = software.amazon.jsii.Kernel.get(this, "sourceMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.targetMetadata = software.amazon.jsii.Kernel.get(this, "targetMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceMetadata = java.util.Objects.requireNonNull(builder.sourceMetadata, "sourceMetadata is required");
                this.targetMetadata = java.util.Objects.requireNonNull(builder.targetMetadata, "targetMetadata is required");
            }

            @Override
            public final java.lang.Object getSourceMetadata() {
                return this.sourceMetadata;
            }

            @Override
            public final java.lang.Object getTargetMetadata() {
                return this.targetMetadata;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceMetadata", om.valueToTree(this.getSourceMetadata()));
                data.set("targetMetadata", om.valueToTree(this.getTargetMetadata()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.DatabaseCDCProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatabaseCDCProperty.Jsii$Proxy that = (DatabaseCDCProperty.Jsii$Proxy) o;

                if (!sourceMetadata.equals(that.sourceMetadata)) return false;
                return this.targetMetadata.equals(that.targetMetadata);
            }

            @Override
            public final int hashCode() {
                int result = this.sourceMetadata.hashCode();
                result = 31 * result + (this.targetMetadata.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies a file metadata.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * FileMetadataProperty fileMetadataProperty = FileMetadataProperty.builder()
     *         .databaseCdc(DatabaseCDCProperty.builder()
     *                 .sourceMetadata(SourceDatabaseMetadataProperty.builder()
     *                         .captureTool("captureTool")
     *                         .type("type")
     *                         .build())
     *                 .targetMetadata(TargetDatabaseMetadataProperty.builder()
     *                         .captureTool("captureTool")
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .dataSets(List.of(DataSetProperty.builder()
     *                 .ccsid("ccsid")
     *                 .format("format")
     *                 .length(123)
     *                 .name("name")
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-filemetadata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-filemetadata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.FileMetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(FileMetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FileMetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The database CDC of the file metadata.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-filemetadata.html#cfn-apptest-testcase-filemetadata-databasecdc">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-filemetadata.html#cfn-apptest-testcase-filemetadata-databasecdc</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatabaseCdc() {
            return null;
        }

        /**
         * The data sets of the file metadata.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-filemetadata.html#cfn-apptest-testcase-filemetadata-datasets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-filemetadata.html#cfn-apptest-testcase-filemetadata-datasets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataSets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FileMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FileMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FileMetadataProperty> {
            java.lang.Object databaseCdc;
            java.lang.Object dataSets;

            /**
             * Sets the value of {@link FileMetadataProperty#getDatabaseCdc}
             * @param databaseCdc The database CDC of the file metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseCdc(software.amazon.awscdk.IResolvable databaseCdc) {
                this.databaseCdc = databaseCdc;
                return this;
            }

            /**
             * Sets the value of {@link FileMetadataProperty#getDatabaseCdc}
             * @param databaseCdc The database CDC of the file metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseCdc(software.amazon.awscdk.services.apptest.CfnTestCase.DatabaseCDCProperty databaseCdc) {
                this.databaseCdc = databaseCdc;
                return this;
            }

            /**
             * Sets the value of {@link FileMetadataProperty#getDataSets}
             * @param dataSets The data sets of the file metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSets(software.amazon.awscdk.IResolvable dataSets) {
                this.dataSets = dataSets;
                return this;
            }

            /**
             * Sets the value of {@link FileMetadataProperty#getDataSets}
             * @param dataSets The data sets of the file metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSets(java.util.List<? extends java.lang.Object> dataSets) {
                this.dataSets = dataSets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FileMetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FileMetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FileMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FileMetadataProperty {
            private final java.lang.Object databaseCdc;
            private final java.lang.Object dataSets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseCdc = software.amazon.jsii.Kernel.get(this, "databaseCdc", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataSets = software.amazon.jsii.Kernel.get(this, "dataSets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseCdc = builder.databaseCdc;
                this.dataSets = builder.dataSets;
            }

            @Override
            public final java.lang.Object getDatabaseCdc() {
                return this.databaseCdc;
            }

            @Override
            public final java.lang.Object getDataSets() {
                return this.dataSets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDatabaseCdc() != null) {
                    data.set("databaseCdc", om.valueToTree(this.getDatabaseCdc()));
                }
                if (this.getDataSets() != null) {
                    data.set("dataSets", om.valueToTree(this.getDataSets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.FileMetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FileMetadataProperty.Jsii$Proxy that = (FileMetadataProperty.Jsii$Proxy) o;

                if (this.databaseCdc != null ? !this.databaseCdc.equals(that.databaseCdc) : that.databaseCdc != null) return false;
                return this.dataSets != null ? this.dataSets.equals(that.dataSets) : that.dataSets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.databaseCdc != null ? this.databaseCdc.hashCode() : 0;
                result = 31 * result + (this.dataSets != null ? this.dataSets.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the input file.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * InputFileProperty inputFileProperty = InputFileProperty.builder()
     *         .fileMetadata(FileMetadataProperty.builder()
     *                 .databaseCdc(DatabaseCDCProperty.builder()
     *                         .sourceMetadata(SourceDatabaseMetadataProperty.builder()
     *                                 .captureTool("captureTool")
     *                                 .type("type")
     *                                 .build())
     *                         .targetMetadata(TargetDatabaseMetadataProperty.builder()
     *                                 .captureTool("captureTool")
     *                                 .type("type")
     *                                 .build())
     *                         .build())
     *                 .dataSets(List.of(DataSetProperty.builder()
     *                         .ccsid("ccsid")
     *                         .format("format")
     *                         .length(123)
     *                         .name("name")
     *                         .type("type")
     *                         .build()))
     *                 .build())
     *         .sourceLocation("sourceLocation")
     *         .targetLocation("targetLocation")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-inputfile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-inputfile.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.InputFileProperty")
    @software.amazon.jsii.Jsii.Proxy(InputFileProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputFileProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The file metadata of the input file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-inputfile.html#cfn-apptest-testcase-inputfile-filemetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-inputfile.html#cfn-apptest-testcase-inputfile-filemetadata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFileMetadata();

        /**
         * The source location of the input file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-inputfile.html#cfn-apptest-testcase-inputfile-sourcelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-inputfile.html#cfn-apptest-testcase-inputfile-sourcelocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceLocation();

        /**
         * The target location of the input file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-inputfile.html#cfn-apptest-testcase-inputfile-targetlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-inputfile.html#cfn-apptest-testcase-inputfile-targetlocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetLocation();

        /**
         * @return a {@link Builder} of {@link InputFileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputFileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputFileProperty> {
            java.lang.Object fileMetadata;
            java.lang.String sourceLocation;
            java.lang.String targetLocation;

            /**
             * Sets the value of {@link InputFileProperty#getFileMetadata}
             * @param fileMetadata The file metadata of the input file. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileMetadata(software.amazon.awscdk.IResolvable fileMetadata) {
                this.fileMetadata = fileMetadata;
                return this;
            }

            /**
             * Sets the value of {@link InputFileProperty#getFileMetadata}
             * @param fileMetadata The file metadata of the input file. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileMetadata(software.amazon.awscdk.services.apptest.CfnTestCase.FileMetadataProperty fileMetadata) {
                this.fileMetadata = fileMetadata;
                return this;
            }

            /**
             * Sets the value of {@link InputFileProperty#getSourceLocation}
             * @param sourceLocation The source location of the input file. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceLocation(java.lang.String sourceLocation) {
                this.sourceLocation = sourceLocation;
                return this;
            }

            /**
             * Sets the value of {@link InputFileProperty#getTargetLocation}
             * @param targetLocation The target location of the input file. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetLocation(java.lang.String targetLocation) {
                this.targetLocation = targetLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputFileProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputFileProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputFileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputFileProperty {
            private final java.lang.Object fileMetadata;
            private final java.lang.String sourceLocation;
            private final java.lang.String targetLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fileMetadata = software.amazon.jsii.Kernel.get(this, "fileMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sourceLocation = software.amazon.jsii.Kernel.get(this, "sourceLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetLocation = software.amazon.jsii.Kernel.get(this, "targetLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fileMetadata = java.util.Objects.requireNonNull(builder.fileMetadata, "fileMetadata is required");
                this.sourceLocation = java.util.Objects.requireNonNull(builder.sourceLocation, "sourceLocation is required");
                this.targetLocation = java.util.Objects.requireNonNull(builder.targetLocation, "targetLocation is required");
            }

            @Override
            public final java.lang.Object getFileMetadata() {
                return this.fileMetadata;
            }

            @Override
            public final java.lang.String getSourceLocation() {
                return this.sourceLocation;
            }

            @Override
            public final java.lang.String getTargetLocation() {
                return this.targetLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fileMetadata", om.valueToTree(this.getFileMetadata()));
                data.set("sourceLocation", om.valueToTree(this.getSourceLocation()));
                data.set("targetLocation", om.valueToTree(this.getTargetLocation()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.InputFileProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputFileProperty.Jsii$Proxy that = (InputFileProperty.Jsii$Proxy) o;

                if (!fileMetadata.equals(that.fileMetadata)) return false;
                if (!sourceLocation.equals(that.sourceLocation)) return false;
                return this.targetLocation.equals(that.targetLocation);
            }

            @Override
            public final int hashCode() {
                int result = this.fileMetadata.hashCode();
                result = 31 * result + (this.sourceLocation.hashCode());
                result = 31 * result + (this.targetLocation.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the input.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * InputProperty inputProperty = InputProperty.builder()
     *         .file(InputFileProperty.builder()
     *                 .fileMetadata(FileMetadataProperty.builder()
     *                         .databaseCdc(DatabaseCDCProperty.builder()
     *                                 .sourceMetadata(SourceDatabaseMetadataProperty.builder()
     *                                         .captureTool("captureTool")
     *                                         .type("type")
     *                                         .build())
     *                                 .targetMetadata(TargetDatabaseMetadataProperty.builder()
     *                                         .captureTool("captureTool")
     *                                         .type("type")
     *                                         .build())
     *                                 .build())
     *                         .dataSets(List.of(DataSetProperty.builder()
     *                                 .ccsid("ccsid")
     *                                 .format("format")
     *                                 .length(123)
     *                                 .name("name")
     *                                 .type("type")
     *                                 .build()))
     *                         .build())
     *                 .sourceLocation("sourceLocation")
     *                 .targetLocation("targetLocation")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-input.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-input.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.InputProperty")
    @software.amazon.jsii.Jsii.Proxy(InputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The file in the input.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-input.html#cfn-apptest-testcase-input-file">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-input.html#cfn-apptest-testcase-input-file</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFile();

        /**
         * @return a {@link Builder} of {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputProperty> {
            java.lang.Object file;

            /**
             * Sets the value of {@link InputProperty#getFile}
             * @param file The file in the input. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.IResolvable file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link InputProperty#getFile}
             * @param file The file in the input. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.services.apptest.CfnTestCase.InputFileProperty file) {
                this.file = file;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputProperty {
            private final java.lang.Object file;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.file = java.util.Objects.requireNonNull(builder.file, "file is required");
            }

            @Override
            public final java.lang.Object getFile() {
                return this.file;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("file", om.valueToTree(this.getFile()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.InputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputProperty.Jsii$Proxy that = (InputProperty.Jsii$Proxy) o;

                return this.file.equals(that.file);
            }

            @Override
            public final int hashCode() {
                int result = this.file.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the Mainframe Modernization managed action properties.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * M2ManagedActionPropertiesProperty m2ManagedActionPropertiesProperty = M2ManagedActionPropertiesProperty.builder()
     *         .forceStop(false)
     *         .importDataSetLocation("importDataSetLocation")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2managedactionproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2managedactionproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.M2ManagedActionPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(M2ManagedActionPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface M2ManagedActionPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Force stops the Mainframe Modernization managed action properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2managedactionproperties.html#cfn-apptest-testcase-m2managedactionproperties-forcestop">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2managedactionproperties.html#cfn-apptest-testcase-m2managedactionproperties-forcestop</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForceStop() {
            return null;
        }

        /**
         * The import data set location of the Mainframe Modernization managed action properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2managedactionproperties.html#cfn-apptest-testcase-m2managedactionproperties-importdatasetlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2managedactionproperties.html#cfn-apptest-testcase-m2managedactionproperties-importdatasetlocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getImportDataSetLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link M2ManagedActionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link M2ManagedActionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<M2ManagedActionPropertiesProperty> {
            java.lang.Object forceStop;
            java.lang.String importDataSetLocation;

            /**
             * Sets the value of {@link M2ManagedActionPropertiesProperty#getForceStop}
             * @param forceStop Force stops the Mainframe Modernization managed action properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forceStop(java.lang.Boolean forceStop) {
                this.forceStop = forceStop;
                return this;
            }

            /**
             * Sets the value of {@link M2ManagedActionPropertiesProperty#getForceStop}
             * @param forceStop Force stops the Mainframe Modernization managed action properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forceStop(software.amazon.awscdk.IResolvable forceStop) {
                this.forceStop = forceStop;
                return this;
            }

            /**
             * Sets the value of {@link M2ManagedActionPropertiesProperty#getImportDataSetLocation}
             * @param importDataSetLocation The import data set location of the Mainframe Modernization managed action properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder importDataSetLocation(java.lang.String importDataSetLocation) {
                this.importDataSetLocation = importDataSetLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link M2ManagedActionPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public M2ManagedActionPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link M2ManagedActionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements M2ManagedActionPropertiesProperty {
            private final java.lang.Object forceStop;
            private final java.lang.String importDataSetLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.forceStop = software.amazon.jsii.Kernel.get(this, "forceStop", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.importDataSetLocation = software.amazon.jsii.Kernel.get(this, "importDataSetLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.forceStop = builder.forceStop;
                this.importDataSetLocation = builder.importDataSetLocation;
            }

            @Override
            public final java.lang.Object getForceStop() {
                return this.forceStop;
            }

            @Override
            public final java.lang.String getImportDataSetLocation() {
                return this.importDataSetLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getForceStop() != null) {
                    data.set("forceStop", om.valueToTree(this.getForceStop()));
                }
                if (this.getImportDataSetLocation() != null) {
                    data.set("importDataSetLocation", om.valueToTree(this.getImportDataSetLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.M2ManagedActionPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                M2ManagedActionPropertiesProperty.Jsii$Proxy that = (M2ManagedActionPropertiesProperty.Jsii$Proxy) o;

                if (this.forceStop != null ? !this.forceStop.equals(that.forceStop) : that.forceStop != null) return false;
                return this.importDataSetLocation != null ? this.importDataSetLocation.equals(that.importDataSetLocation) : that.importDataSetLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.forceStop != null ? this.forceStop.hashCode() : 0;
                result = 31 * result + (this.importDataSetLocation != null ? this.importDataSetLocation.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the Mainframe Modernization managed application action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * M2ManagedApplicationActionProperty m2ManagedApplicationActionProperty = M2ManagedApplicationActionProperty.builder()
     *         .actionType("actionType")
     *         .resource("resource")
     *         // the properties below are optional
     *         .properties(M2ManagedActionPropertiesProperty.builder()
     *                 .forceStop(false)
     *                 .importDataSetLocation("importDataSetLocation")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2managedapplicationaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2managedapplicationaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.M2ManagedApplicationActionProperty")
    @software.amazon.jsii.Jsii.Proxy(M2ManagedApplicationActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface M2ManagedApplicationActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action type of the Mainframe Modernization managed application action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2managedapplicationaction.html#cfn-apptest-testcase-m2managedapplicationaction-actiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2managedapplicationaction.html#cfn-apptest-testcase-m2managedapplicationaction-actiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getActionType();

        /**
         * The resource of the Mainframe Modernization managed application action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2managedapplicationaction.html#cfn-apptest-testcase-m2managedapplicationaction-resource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2managedapplicationaction.html#cfn-apptest-testcase-m2managedapplicationaction-resource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResource();

        /**
         * The properties of the Mainframe Modernization managed application action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2managedapplicationaction.html#cfn-apptest-testcase-m2managedapplicationaction-properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2managedapplicationaction.html#cfn-apptest-testcase-m2managedapplicationaction-properties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link M2ManagedApplicationActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link M2ManagedApplicationActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<M2ManagedApplicationActionProperty> {
            java.lang.String actionType;
            java.lang.String resource;
            java.lang.Object properties;

            /**
             * Sets the value of {@link M2ManagedApplicationActionProperty#getActionType}
             * @param actionType The action type of the Mainframe Modernization managed application action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionType(java.lang.String actionType) {
                this.actionType = actionType;
                return this;
            }

            /**
             * Sets the value of {@link M2ManagedApplicationActionProperty#getResource}
             * @param resource The resource of the Mainframe Modernization managed application action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resource(java.lang.String resource) {
                this.resource = resource;
                return this;
            }

            /**
             * Sets the value of {@link M2ManagedApplicationActionProperty#getProperties}
             * @param properties The properties of the Mainframe Modernization managed application action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.IResolvable properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link M2ManagedApplicationActionProperty#getProperties}
             * @param properties The properties of the Mainframe Modernization managed application action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.apptest.CfnTestCase.M2ManagedActionPropertiesProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link M2ManagedApplicationActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public M2ManagedApplicationActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link M2ManagedApplicationActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements M2ManagedApplicationActionProperty {
            private final java.lang.String actionType;
            private final java.lang.String resource;
            private final java.lang.Object properties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actionType = software.amazon.jsii.Kernel.get(this, "actionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resource = software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actionType = java.util.Objects.requireNonNull(builder.actionType, "actionType is required");
                this.resource = java.util.Objects.requireNonNull(builder.resource, "resource is required");
                this.properties = builder.properties;
            }

            @Override
            public final java.lang.String getActionType() {
                return this.actionType;
            }

            @Override
            public final java.lang.String getResource() {
                return this.resource;
            }

            @Override
            public final java.lang.Object getProperties() {
                return this.properties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actionType", om.valueToTree(this.getActionType()));
                data.set("resource", om.valueToTree(this.getResource()));
                if (this.getProperties() != null) {
                    data.set("properties", om.valueToTree(this.getProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.M2ManagedApplicationActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                M2ManagedApplicationActionProperty.Jsii$Proxy that = (M2ManagedApplicationActionProperty.Jsii$Proxy) o;

                if (!actionType.equals(that.actionType)) return false;
                if (!resource.equals(that.resource)) return false;
                return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actionType.hashCode();
                result = 31 * result + (this.resource.hashCode());
                result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the Mainframe Modernization non-managed application action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * M2NonManagedApplicationActionProperty m2NonManagedApplicationActionProperty = M2NonManagedApplicationActionProperty.builder()
     *         .actionType("actionType")
     *         .resource("resource")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2nonmanagedapplicationaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2nonmanagedapplicationaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.M2NonManagedApplicationActionProperty")
    @software.amazon.jsii.Jsii.Proxy(M2NonManagedApplicationActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface M2NonManagedApplicationActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action type of the Mainframe Modernization non-managed application action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2nonmanagedapplicationaction.html#cfn-apptest-testcase-m2nonmanagedapplicationaction-actiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2nonmanagedapplicationaction.html#cfn-apptest-testcase-m2nonmanagedapplicationaction-actiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getActionType();

        /**
         * The resource of the Mainframe Modernization non-managed application action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2nonmanagedapplicationaction.html#cfn-apptest-testcase-m2nonmanagedapplicationaction-resource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-m2nonmanagedapplicationaction.html#cfn-apptest-testcase-m2nonmanagedapplicationaction-resource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResource();

        /**
         * @return a {@link Builder} of {@link M2NonManagedApplicationActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link M2NonManagedApplicationActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<M2NonManagedApplicationActionProperty> {
            java.lang.String actionType;
            java.lang.String resource;

            /**
             * Sets the value of {@link M2NonManagedApplicationActionProperty#getActionType}
             * @param actionType The action type of the Mainframe Modernization non-managed application action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionType(java.lang.String actionType) {
                this.actionType = actionType;
                return this;
            }

            /**
             * Sets the value of {@link M2NonManagedApplicationActionProperty#getResource}
             * @param resource The resource of the Mainframe Modernization non-managed application action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resource(java.lang.String resource) {
                this.resource = resource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link M2NonManagedApplicationActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public M2NonManagedApplicationActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link M2NonManagedApplicationActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements M2NonManagedApplicationActionProperty {
            private final java.lang.String actionType;
            private final java.lang.String resource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actionType = software.amazon.jsii.Kernel.get(this, "actionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.resource = software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actionType = java.util.Objects.requireNonNull(builder.actionType, "actionType is required");
                this.resource = java.util.Objects.requireNonNull(builder.resource, "resource is required");
            }

            @Override
            public final java.lang.String getActionType() {
                return this.actionType;
            }

            @Override
            public final java.lang.String getResource() {
                return this.resource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actionType", om.valueToTree(this.getActionType()));
                data.set("resource", om.valueToTree(this.getResource()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.M2NonManagedApplicationActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                M2NonManagedApplicationActionProperty.Jsii$Proxy that = (M2NonManagedApplicationActionProperty.Jsii$Proxy) o;

                if (!actionType.equals(that.actionType)) return false;
                return this.resource.equals(that.resource);
            }

            @Override
            public final int hashCode() {
                int result = this.actionType.hashCode();
                result = 31 * result + (this.resource.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the mainframe action properties.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * MainframeActionPropertiesProperty mainframeActionPropertiesProperty = MainframeActionPropertiesProperty.builder()
     *         .dmsTaskArn("dmsTaskArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeactionproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeactionproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.MainframeActionPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(MainframeActionPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MainframeActionPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The DMS task ARN of the mainframe action properties.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeactionproperties.html#cfn-apptest-testcase-mainframeactionproperties-dmstaskarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeactionproperties.html#cfn-apptest-testcase-mainframeactionproperties-dmstaskarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDmsTaskArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MainframeActionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MainframeActionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MainframeActionPropertiesProperty> {
            java.lang.String dmsTaskArn;

            /**
             * Sets the value of {@link MainframeActionPropertiesProperty#getDmsTaskArn}
             * @param dmsTaskArn The DMS task ARN of the mainframe action properties.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dmsTaskArn(java.lang.String dmsTaskArn) {
                this.dmsTaskArn = dmsTaskArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MainframeActionPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MainframeActionPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MainframeActionPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MainframeActionPropertiesProperty {
            private final java.lang.String dmsTaskArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dmsTaskArn = software.amazon.jsii.Kernel.get(this, "dmsTaskArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dmsTaskArn = builder.dmsTaskArn;
            }

            @Override
            public final java.lang.String getDmsTaskArn() {
                return this.dmsTaskArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDmsTaskArn() != null) {
                    data.set("dmsTaskArn", om.valueToTree(this.getDmsTaskArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.MainframeActionPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MainframeActionPropertiesProperty.Jsii$Proxy that = (MainframeActionPropertiesProperty.Jsii$Proxy) o;

                return this.dmsTaskArn != null ? this.dmsTaskArn.equals(that.dmsTaskArn) : that.dmsTaskArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dmsTaskArn != null ? this.dmsTaskArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the mainframe action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * MainframeActionProperty mainframeActionProperty = MainframeActionProperty.builder()
     *         .actionType(MainframeActionTypeProperty.builder()
     *                 .batch(BatchProperty.builder()
     *                         .batchJobName("batchJobName")
     *                         // the properties below are optional
     *                         .batchJobParameters(Map.of(
     *                                 "batchJobParametersKey", "batchJobParameters"))
     *                         .exportDataSetNames(List.of("exportDataSetNames"))
     *                         .build())
     *                 .tn3270(TN3270Property.builder()
     *                         .script(ScriptProperty.builder()
     *                                 .scriptLocation("scriptLocation")
     *                                 .type("type")
     *                                 .build())
     *                         // the properties below are optional
     *                         .exportDataSetNames(List.of("exportDataSetNames"))
     *                         .build())
     *                 .build())
     *         .resource("resource")
     *         // the properties below are optional
     *         .properties(MainframeActionPropertiesProperty.builder()
     *                 .dmsTaskArn("dmsTaskArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.MainframeActionProperty")
    @software.amazon.jsii.Jsii.Proxy(MainframeActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MainframeActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action type of the mainframe action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeaction.html#cfn-apptest-testcase-mainframeaction-actiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeaction.html#cfn-apptest-testcase-mainframeaction-actiontype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getActionType();

        /**
         * The resource of the mainframe action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeaction.html#cfn-apptest-testcase-mainframeaction-resource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeaction.html#cfn-apptest-testcase-mainframeaction-resource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResource();

        /**
         * The properties of the mainframe action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeaction.html#cfn-apptest-testcase-mainframeaction-properties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeaction.html#cfn-apptest-testcase-mainframeaction-properties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MainframeActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MainframeActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MainframeActionProperty> {
            java.lang.Object actionType;
            java.lang.String resource;
            java.lang.Object properties;

            /**
             * Sets the value of {@link MainframeActionProperty#getActionType}
             * @param actionType The action type of the mainframe action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionType(software.amazon.awscdk.IResolvable actionType) {
                this.actionType = actionType;
                return this;
            }

            /**
             * Sets the value of {@link MainframeActionProperty#getActionType}
             * @param actionType The action type of the mainframe action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionType(software.amazon.awscdk.services.apptest.CfnTestCase.MainframeActionTypeProperty actionType) {
                this.actionType = actionType;
                return this;
            }

            /**
             * Sets the value of {@link MainframeActionProperty#getResource}
             * @param resource The resource of the mainframe action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resource(java.lang.String resource) {
                this.resource = resource;
                return this;
            }

            /**
             * Sets the value of {@link MainframeActionProperty#getProperties}
             * @param properties The properties of the mainframe action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.IResolvable properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Sets the value of {@link MainframeActionProperty#getProperties}
             * @param properties The properties of the mainframe action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder properties(software.amazon.awscdk.services.apptest.CfnTestCase.MainframeActionPropertiesProperty properties) {
                this.properties = properties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MainframeActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MainframeActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MainframeActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MainframeActionProperty {
            private final java.lang.Object actionType;
            private final java.lang.String resource;
            private final java.lang.Object properties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actionType = software.amazon.jsii.Kernel.get(this, "actionType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resource = software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.properties = software.amazon.jsii.Kernel.get(this, "properties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actionType = java.util.Objects.requireNonNull(builder.actionType, "actionType is required");
                this.resource = java.util.Objects.requireNonNull(builder.resource, "resource is required");
                this.properties = builder.properties;
            }

            @Override
            public final java.lang.Object getActionType() {
                return this.actionType;
            }

            @Override
            public final java.lang.String getResource() {
                return this.resource;
            }

            @Override
            public final java.lang.Object getProperties() {
                return this.properties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actionType", om.valueToTree(this.getActionType()));
                data.set("resource", om.valueToTree(this.getResource()));
                if (this.getProperties() != null) {
                    data.set("properties", om.valueToTree(this.getProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.MainframeActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MainframeActionProperty.Jsii$Proxy that = (MainframeActionProperty.Jsii$Proxy) o;

                if (!actionType.equals(that.actionType)) return false;
                if (!resource.equals(that.resource)) return false;
                return this.properties != null ? this.properties.equals(that.properties) : that.properties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actionType.hashCode();
                result = 31 * result + (this.resource.hashCode());
                result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the mainframe action type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * MainframeActionTypeProperty mainframeActionTypeProperty = MainframeActionTypeProperty.builder()
     *         .batch(BatchProperty.builder()
     *                 .batchJobName("batchJobName")
     *                 // the properties below are optional
     *                 .batchJobParameters(Map.of(
     *                         "batchJobParametersKey", "batchJobParameters"))
     *                 .exportDataSetNames(List.of("exportDataSetNames"))
     *                 .build())
     *         .tn3270(TN3270Property.builder()
     *                 .script(ScriptProperty.builder()
     *                         .scriptLocation("scriptLocation")
     *                         .type("type")
     *                         .build())
     *                 // the properties below are optional
     *                 .exportDataSetNames(List.of("exportDataSetNames"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeactiontype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeactiontype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.MainframeActionTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(MainframeActionTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MainframeActionTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The batch of the mainframe action type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeactiontype.html#cfn-apptest-testcase-mainframeactiontype-batch">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeactiontype.html#cfn-apptest-testcase-mainframeactiontype-batch</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBatch() {
            return null;
        }

        /**
         * The tn3270 port of the mainframe action type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeactiontype.html#cfn-apptest-testcase-mainframeactiontype-tn3270">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-mainframeactiontype.html#cfn-apptest-testcase-mainframeactiontype-tn3270</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTn3270() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MainframeActionTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MainframeActionTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MainframeActionTypeProperty> {
            java.lang.Object batch;
            java.lang.Object tn3270;

            /**
             * Sets the value of {@link MainframeActionTypeProperty#getBatch}
             * @param batch The batch of the mainframe action type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batch(software.amazon.awscdk.IResolvable batch) {
                this.batch = batch;
                return this;
            }

            /**
             * Sets the value of {@link MainframeActionTypeProperty#getBatch}
             * @param batch The batch of the mainframe action type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder batch(software.amazon.awscdk.services.apptest.CfnTestCase.BatchProperty batch) {
                this.batch = batch;
                return this;
            }

            /**
             * Sets the value of {@link MainframeActionTypeProperty#getTn3270}
             * @param tn3270 The tn3270 port of the mainframe action type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tn3270(software.amazon.awscdk.IResolvable tn3270) {
                this.tn3270 = tn3270;
                return this;
            }

            /**
             * Sets the value of {@link MainframeActionTypeProperty#getTn3270}
             * @param tn3270 The tn3270 port of the mainframe action type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tn3270(software.amazon.awscdk.services.apptest.CfnTestCase.TN3270Property tn3270) {
                this.tn3270 = tn3270;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MainframeActionTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MainframeActionTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MainframeActionTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MainframeActionTypeProperty {
            private final java.lang.Object batch;
            private final java.lang.Object tn3270;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.batch = software.amazon.jsii.Kernel.get(this, "batch", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tn3270 = software.amazon.jsii.Kernel.get(this, "tn3270", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.batch = builder.batch;
                this.tn3270 = builder.tn3270;
            }

            @Override
            public final java.lang.Object getBatch() {
                return this.batch;
            }

            @Override
            public final java.lang.Object getTn3270() {
                return this.tn3270;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBatch() != null) {
                    data.set("batch", om.valueToTree(this.getBatch()));
                }
                if (this.getTn3270() != null) {
                    data.set("tn3270", om.valueToTree(this.getTn3270()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.MainframeActionTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MainframeActionTypeProperty.Jsii$Proxy that = (MainframeActionTypeProperty.Jsii$Proxy) o;

                if (this.batch != null ? !this.batch.equals(that.batch) : that.batch != null) return false;
                return this.tn3270 != null ? this.tn3270.equals(that.tn3270) : that.tn3270 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.batch != null ? this.batch.hashCode() : 0;
                result = 31 * result + (this.tn3270 != null ? this.tn3270.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an output file.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * OutputFileProperty outputFileProperty = OutputFileProperty.builder()
     *         .fileLocation("fileLocation")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-outputfile.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-outputfile.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.OutputFileProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputFileProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputFileProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The file location of the output file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-outputfile.html#cfn-apptest-testcase-outputfile-filelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-outputfile.html#cfn-apptest-testcase-outputfile-filelocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFileLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputFileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputFileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputFileProperty> {
            java.lang.String fileLocation;

            /**
             * Sets the value of {@link OutputFileProperty#getFileLocation}
             * @param fileLocation The file location of the output file.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileLocation(java.lang.String fileLocation) {
                this.fileLocation = fileLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputFileProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputFileProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputFileProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputFileProperty {
            private final java.lang.String fileLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fileLocation = software.amazon.jsii.Kernel.get(this, "fileLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fileLocation = builder.fileLocation;
            }

            @Override
            public final java.lang.String getFileLocation() {
                return this.fileLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getFileLocation() != null) {
                    data.set("fileLocation", om.valueToTree(this.getFileLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.OutputFileProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputFileProperty.Jsii$Proxy that = (OutputFileProperty.Jsii$Proxy) o;

                return this.fileLocation != null ? this.fileLocation.equals(that.fileLocation) : that.fileLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fileLocation != null ? this.fileLocation.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies an output.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * OutputProperty outputProperty = OutputProperty.builder()
     *         .file(OutputFileProperty.builder()
     *                 .fileLocation("fileLocation")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-output.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-output.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.OutputProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The file of the output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-output.html#cfn-apptest-testcase-output-file">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-output.html#cfn-apptest-testcase-output-file</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFile();

        /**
         * @return a {@link Builder} of {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputProperty> {
            java.lang.Object file;

            /**
             * Sets the value of {@link OutputProperty#getFile}
             * @param file The file of the output. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.IResolvable file) {
                this.file = file;
                return this;
            }

            /**
             * Sets the value of {@link OutputProperty#getFile}
             * @param file The file of the output. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder file(software.amazon.awscdk.services.apptest.CfnTestCase.OutputFileProperty file) {
                this.file = file;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputProperty {
            private final java.lang.Object file;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.file = software.amazon.jsii.Kernel.get(this, "file", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.file = java.util.Objects.requireNonNull(builder.file, "file is required");
            }

            @Override
            public final java.lang.Object getFile() {
                return this.file;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("file", om.valueToTree(this.getFile()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.OutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputProperty.Jsii$Proxy that = (OutputProperty.Jsii$Proxy) o;

                return this.file.equals(that.file);
            }

            @Override
            public final int hashCode() {
                int result = this.file.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies a resource action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * ResourceActionProperty resourceActionProperty = ResourceActionProperty.builder()
     *         .cloudFormationAction(CloudFormationActionProperty.builder()
     *                 .resource("resource")
     *                 // the properties below are optional
     *                 .actionType("actionType")
     *                 .build())
     *         .m2ManagedApplicationAction(M2ManagedApplicationActionProperty.builder()
     *                 .actionType("actionType")
     *                 .resource("resource")
     *                 // the properties below are optional
     *                 .properties(M2ManagedActionPropertiesProperty.builder()
     *                         .forceStop(false)
     *                         .importDataSetLocation("importDataSetLocation")
     *                         .build())
     *                 .build())
     *         .m2NonManagedApplicationAction(M2NonManagedApplicationActionProperty.builder()
     *                 .actionType("actionType")
     *                 .resource("resource")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-resourceaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-resourceaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.ResourceActionProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CloudFormation action of the resource action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-resourceaction.html#cfn-apptest-testcase-resourceaction-cloudformationaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-resourceaction.html#cfn-apptest-testcase-resourceaction-cloudformationaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudFormationAction() {
            return null;
        }

        /**
         * The Mainframe Modernization managed application action of the resource action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-resourceaction.html#cfn-apptest-testcase-resourceaction-m2managedapplicationaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-resourceaction.html#cfn-apptest-testcase-resourceaction-m2managedapplicationaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getM2ManagedApplicationAction() {
            return null;
        }

        /**
         * The Mainframe Modernization non-managed application action of the resource action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-resourceaction.html#cfn-apptest-testcase-resourceaction-m2nonmanagedapplicationaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-resourceaction.html#cfn-apptest-testcase-resourceaction-m2nonmanagedapplicationaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getM2NonManagedApplicationAction() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceActionProperty> {
            java.lang.Object cloudFormationAction;
            java.lang.Object m2ManagedApplicationAction;
            java.lang.Object m2NonManagedApplicationAction;

            /**
             * Sets the value of {@link ResourceActionProperty#getCloudFormationAction}
             * @param cloudFormationAction The CloudFormation action of the resource action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudFormationAction(software.amazon.awscdk.IResolvable cloudFormationAction) {
                this.cloudFormationAction = cloudFormationAction;
                return this;
            }

            /**
             * Sets the value of {@link ResourceActionProperty#getCloudFormationAction}
             * @param cloudFormationAction The CloudFormation action of the resource action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudFormationAction(software.amazon.awscdk.services.apptest.CfnTestCase.CloudFormationActionProperty cloudFormationAction) {
                this.cloudFormationAction = cloudFormationAction;
                return this;
            }

            /**
             * Sets the value of {@link ResourceActionProperty#getM2ManagedApplicationAction}
             * @param m2ManagedApplicationAction The Mainframe Modernization managed application action of the resource action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder m2ManagedApplicationAction(software.amazon.awscdk.IResolvable m2ManagedApplicationAction) {
                this.m2ManagedApplicationAction = m2ManagedApplicationAction;
                return this;
            }

            /**
             * Sets the value of {@link ResourceActionProperty#getM2ManagedApplicationAction}
             * @param m2ManagedApplicationAction The Mainframe Modernization managed application action of the resource action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder m2ManagedApplicationAction(software.amazon.awscdk.services.apptest.CfnTestCase.M2ManagedApplicationActionProperty m2ManagedApplicationAction) {
                this.m2ManagedApplicationAction = m2ManagedApplicationAction;
                return this;
            }

            /**
             * Sets the value of {@link ResourceActionProperty#getM2NonManagedApplicationAction}
             * @param m2NonManagedApplicationAction The Mainframe Modernization non-managed application action of the resource action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder m2NonManagedApplicationAction(software.amazon.awscdk.IResolvable m2NonManagedApplicationAction) {
                this.m2NonManagedApplicationAction = m2NonManagedApplicationAction;
                return this;
            }

            /**
             * Sets the value of {@link ResourceActionProperty#getM2NonManagedApplicationAction}
             * @param m2NonManagedApplicationAction The Mainframe Modernization non-managed application action of the resource action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder m2NonManagedApplicationAction(software.amazon.awscdk.services.apptest.CfnTestCase.M2NonManagedApplicationActionProperty m2NonManagedApplicationAction) {
                this.m2NonManagedApplicationAction = m2NonManagedApplicationAction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceActionProperty {
            private final java.lang.Object cloudFormationAction;
            private final java.lang.Object m2ManagedApplicationAction;
            private final java.lang.Object m2NonManagedApplicationAction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudFormationAction = software.amazon.jsii.Kernel.get(this, "cloudFormationAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.m2ManagedApplicationAction = software.amazon.jsii.Kernel.get(this, "m2ManagedApplicationAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.m2NonManagedApplicationAction = software.amazon.jsii.Kernel.get(this, "m2NonManagedApplicationAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudFormationAction = builder.cloudFormationAction;
                this.m2ManagedApplicationAction = builder.m2ManagedApplicationAction;
                this.m2NonManagedApplicationAction = builder.m2NonManagedApplicationAction;
            }

            @Override
            public final java.lang.Object getCloudFormationAction() {
                return this.cloudFormationAction;
            }

            @Override
            public final java.lang.Object getM2ManagedApplicationAction() {
                return this.m2ManagedApplicationAction;
            }

            @Override
            public final java.lang.Object getM2NonManagedApplicationAction() {
                return this.m2NonManagedApplicationAction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudFormationAction() != null) {
                    data.set("cloudFormationAction", om.valueToTree(this.getCloudFormationAction()));
                }
                if (this.getM2ManagedApplicationAction() != null) {
                    data.set("m2ManagedApplicationAction", om.valueToTree(this.getM2ManagedApplicationAction()));
                }
                if (this.getM2NonManagedApplicationAction() != null) {
                    data.set("m2NonManagedApplicationAction", om.valueToTree(this.getM2NonManagedApplicationAction()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.ResourceActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceActionProperty.Jsii$Proxy that = (ResourceActionProperty.Jsii$Proxy) o;

                if (this.cloudFormationAction != null ? !this.cloudFormationAction.equals(that.cloudFormationAction) : that.cloudFormationAction != null) return false;
                if (this.m2ManagedApplicationAction != null ? !this.m2ManagedApplicationAction.equals(that.m2ManagedApplicationAction) : that.m2ManagedApplicationAction != null) return false;
                return this.m2NonManagedApplicationAction != null ? this.m2NonManagedApplicationAction.equals(that.m2NonManagedApplicationAction) : that.m2NonManagedApplicationAction == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudFormationAction != null ? this.cloudFormationAction.hashCode() : 0;
                result = 31 * result + (this.m2ManagedApplicationAction != null ? this.m2ManagedApplicationAction.hashCode() : 0);
                result = 31 * result + (this.m2NonManagedApplicationAction != null ? this.m2NonManagedApplicationAction.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the script.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * ScriptProperty scriptProperty = ScriptProperty.builder()
     *         .scriptLocation("scriptLocation")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-script.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-script.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.ScriptProperty")
    @software.amazon.jsii.Jsii.Proxy(ScriptProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScriptProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The script location of the scripts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-script.html#cfn-apptest-testcase-script-scriptlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-script.html#cfn-apptest-testcase-script-scriptlocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScriptLocation();

        /**
         * The type of the scripts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-script.html#cfn-apptest-testcase-script-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-script.html#cfn-apptest-testcase-script-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link ScriptProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScriptProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScriptProperty> {
            java.lang.String scriptLocation;
            java.lang.String type;

            /**
             * Sets the value of {@link ScriptProperty#getScriptLocation}
             * @param scriptLocation The script location of the scripts. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scriptLocation(java.lang.String scriptLocation) {
                this.scriptLocation = scriptLocation;
                return this;
            }

            /**
             * Sets the value of {@link ScriptProperty#getType}
             * @param type The type of the scripts. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScriptProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScriptProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScriptProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScriptProperty {
            private final java.lang.String scriptLocation;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scriptLocation = software.amazon.jsii.Kernel.get(this, "scriptLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scriptLocation = java.util.Objects.requireNonNull(builder.scriptLocation, "scriptLocation is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getScriptLocation() {
                return this.scriptLocation;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scriptLocation", om.valueToTree(this.getScriptLocation()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.ScriptProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScriptProperty.Jsii$Proxy that = (ScriptProperty.Jsii$Proxy) o;

                if (!scriptLocation.equals(that.scriptLocation)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.scriptLocation.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the source database metadata.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * SourceDatabaseMetadataProperty sourceDatabaseMetadataProperty = SourceDatabaseMetadataProperty.builder()
     *         .captureTool("captureTool")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-sourcedatabasemetadata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-sourcedatabasemetadata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.SourceDatabaseMetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceDatabaseMetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceDatabaseMetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The capture tool of the source database metadata.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-sourcedatabasemetadata.html#cfn-apptest-testcase-sourcedatabasemetadata-capturetool">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-sourcedatabasemetadata.html#cfn-apptest-testcase-sourcedatabasemetadata-capturetool</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCaptureTool();

        /**
         * The type of the source database metadata.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-sourcedatabasemetadata.html#cfn-apptest-testcase-sourcedatabasemetadata-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-sourcedatabasemetadata.html#cfn-apptest-testcase-sourcedatabasemetadata-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link SourceDatabaseMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceDatabaseMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceDatabaseMetadataProperty> {
            java.lang.String captureTool;
            java.lang.String type;

            /**
             * Sets the value of {@link SourceDatabaseMetadataProperty#getCaptureTool}
             * @param captureTool The capture tool of the source database metadata. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureTool(java.lang.String captureTool) {
                this.captureTool = captureTool;
                return this;
            }

            /**
             * Sets the value of {@link SourceDatabaseMetadataProperty#getType}
             * @param type The type of the source database metadata. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceDatabaseMetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceDatabaseMetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceDatabaseMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceDatabaseMetadataProperty {
            private final java.lang.String captureTool;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.captureTool = software.amazon.jsii.Kernel.get(this, "captureTool", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.captureTool = java.util.Objects.requireNonNull(builder.captureTool, "captureTool is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getCaptureTool() {
                return this.captureTool;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("captureTool", om.valueToTree(this.getCaptureTool()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.SourceDatabaseMetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceDatabaseMetadataProperty.Jsii$Proxy that = (SourceDatabaseMetadataProperty.Jsii$Proxy) o;

                if (!captureTool.equals(that.captureTool)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.captureTool.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies a step action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * StepActionProperty stepActionProperty = StepActionProperty.builder()
     *         .compareAction(CompareActionProperty.builder()
     *                 .input(InputProperty.builder()
     *                         .file(InputFileProperty.builder()
     *                                 .fileMetadata(FileMetadataProperty.builder()
     *                                         .databaseCdc(DatabaseCDCProperty.builder()
     *                                                 .sourceMetadata(SourceDatabaseMetadataProperty.builder()
     *                                                         .captureTool("captureTool")
     *                                                         .type("type")
     *                                                         .build())
     *                                                 .targetMetadata(TargetDatabaseMetadataProperty.builder()
     *                                                         .captureTool("captureTool")
     *                                                         .type("type")
     *                                                         .build())
     *                                                 .build())
     *                                         .dataSets(List.of(DataSetProperty.builder()
     *                                                 .ccsid("ccsid")
     *                                                 .format("format")
     *                                                 .length(123)
     *                                                 .name("name")
     *                                                 .type("type")
     *                                                 .build()))
     *                                         .build())
     *                                 .sourceLocation("sourceLocation")
     *                                 .targetLocation("targetLocation")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .output(OutputProperty.builder()
     *                         .file(OutputFileProperty.builder()
     *                                 .fileLocation("fileLocation")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .mainframeAction(MainframeActionProperty.builder()
     *                 .actionType(MainframeActionTypeProperty.builder()
     *                         .batch(BatchProperty.builder()
     *                                 .batchJobName("batchJobName")
     *                                 // the properties below are optional
     *                                 .batchJobParameters(Map.of(
     *                                         "batchJobParametersKey", "batchJobParameters"))
     *                                 .exportDataSetNames(List.of("exportDataSetNames"))
     *                                 .build())
     *                         .tn3270(TN3270Property.builder()
     *                                 .script(ScriptProperty.builder()
     *                                         .scriptLocation("scriptLocation")
     *                                         .type("type")
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .exportDataSetNames(List.of("exportDataSetNames"))
     *                                 .build())
     *                         .build())
     *                 .resource("resource")
     *                 // the properties below are optional
     *                 .properties(MainframeActionPropertiesProperty.builder()
     *                         .dmsTaskArn("dmsTaskArn")
     *                         .build())
     *                 .build())
     *         .resourceAction(ResourceActionProperty.builder()
     *                 .cloudFormationAction(CloudFormationActionProperty.builder()
     *                         .resource("resource")
     *                         // the properties below are optional
     *                         .actionType("actionType")
     *                         .build())
     *                 .m2ManagedApplicationAction(M2ManagedApplicationActionProperty.builder()
     *                         .actionType("actionType")
     *                         .resource("resource")
     *                         // the properties below are optional
     *                         .properties(M2ManagedActionPropertiesProperty.builder()
     *                                 .forceStop(false)
     *                                 .importDataSetLocation("importDataSetLocation")
     *                                 .build())
     *                         .build())
     *                 .m2NonManagedApplicationAction(M2NonManagedApplicationActionProperty.builder()
     *                         .actionType("actionType")
     *                         .resource("resource")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-stepaction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-stepaction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.StepActionProperty")
    @software.amazon.jsii.Jsii.Proxy(StepActionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StepActionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The compare action of the step action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-stepaction.html#cfn-apptest-testcase-stepaction-compareaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-stepaction.html#cfn-apptest-testcase-stepaction-compareaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCompareAction() {
            return null;
        }

        /**
         * The mainframe action of the step action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-stepaction.html#cfn-apptest-testcase-stepaction-mainframeaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-stepaction.html#cfn-apptest-testcase-stepaction-mainframeaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMainframeAction() {
            return null;
        }

        /**
         * The resource action of the step action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-stepaction.html#cfn-apptest-testcase-stepaction-resourceaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-stepaction.html#cfn-apptest-testcase-stepaction-resourceaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResourceAction() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StepActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StepActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StepActionProperty> {
            java.lang.Object compareAction;
            java.lang.Object mainframeAction;
            java.lang.Object resourceAction;

            /**
             * Sets the value of {@link StepActionProperty#getCompareAction}
             * @param compareAction The compare action of the step action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compareAction(software.amazon.awscdk.IResolvable compareAction) {
                this.compareAction = compareAction;
                return this;
            }

            /**
             * Sets the value of {@link StepActionProperty#getCompareAction}
             * @param compareAction The compare action of the step action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compareAction(software.amazon.awscdk.services.apptest.CfnTestCase.CompareActionProperty compareAction) {
                this.compareAction = compareAction;
                return this;
            }

            /**
             * Sets the value of {@link StepActionProperty#getMainframeAction}
             * @param mainframeAction The mainframe action of the step action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mainframeAction(software.amazon.awscdk.IResolvable mainframeAction) {
                this.mainframeAction = mainframeAction;
                return this;
            }

            /**
             * Sets the value of {@link StepActionProperty#getMainframeAction}
             * @param mainframeAction The mainframe action of the step action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mainframeAction(software.amazon.awscdk.services.apptest.CfnTestCase.MainframeActionProperty mainframeAction) {
                this.mainframeAction = mainframeAction;
                return this;
            }

            /**
             * Sets the value of {@link StepActionProperty#getResourceAction}
             * @param resourceAction The resource action of the step action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAction(software.amazon.awscdk.IResolvable resourceAction) {
                this.resourceAction = resourceAction;
                return this;
            }

            /**
             * Sets the value of {@link StepActionProperty#getResourceAction}
             * @param resourceAction The resource action of the step action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceAction(software.amazon.awscdk.services.apptest.CfnTestCase.ResourceActionProperty resourceAction) {
                this.resourceAction = resourceAction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StepActionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StepActionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StepActionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepActionProperty {
            private final java.lang.Object compareAction;
            private final java.lang.Object mainframeAction;
            private final java.lang.Object resourceAction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.compareAction = software.amazon.jsii.Kernel.get(this, "compareAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.mainframeAction = software.amazon.jsii.Kernel.get(this, "mainframeAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resourceAction = software.amazon.jsii.Kernel.get(this, "resourceAction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.compareAction = builder.compareAction;
                this.mainframeAction = builder.mainframeAction;
                this.resourceAction = builder.resourceAction;
            }

            @Override
            public final java.lang.Object getCompareAction() {
                return this.compareAction;
            }

            @Override
            public final java.lang.Object getMainframeAction() {
                return this.mainframeAction;
            }

            @Override
            public final java.lang.Object getResourceAction() {
                return this.resourceAction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCompareAction() != null) {
                    data.set("compareAction", om.valueToTree(this.getCompareAction()));
                }
                if (this.getMainframeAction() != null) {
                    data.set("mainframeAction", om.valueToTree(this.getMainframeAction()));
                }
                if (this.getResourceAction() != null) {
                    data.set("resourceAction", om.valueToTree(this.getResourceAction()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.StepActionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StepActionProperty.Jsii$Proxy that = (StepActionProperty.Jsii$Proxy) o;

                if (this.compareAction != null ? !this.compareAction.equals(that.compareAction) : that.compareAction != null) return false;
                if (this.mainframeAction != null ? !this.mainframeAction.equals(that.mainframeAction) : that.mainframeAction != null) return false;
                return this.resourceAction != null ? this.resourceAction.equals(that.resourceAction) : that.resourceAction == null;
            }

            @Override
            public final int hashCode() {
                int result = this.compareAction != null ? this.compareAction.hashCode() : 0;
                result = 31 * result + (this.mainframeAction != null ? this.mainframeAction.hashCode() : 0);
                result = 31 * result + (this.resourceAction != null ? this.resourceAction.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines a step.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * StepProperty stepProperty = StepProperty.builder()
     *         .action(StepActionProperty.builder()
     *                 .compareAction(CompareActionProperty.builder()
     *                         .input(InputProperty.builder()
     *                                 .file(InputFileProperty.builder()
     *                                         .fileMetadata(FileMetadataProperty.builder()
     *                                                 .databaseCdc(DatabaseCDCProperty.builder()
     *                                                         .sourceMetadata(SourceDatabaseMetadataProperty.builder()
     *                                                                 .captureTool("captureTool")
     *                                                                 .type("type")
     *                                                                 .build())
     *                                                         .targetMetadata(TargetDatabaseMetadataProperty.builder()
     *                                                                 .captureTool("captureTool")
     *                                                                 .type("type")
     *                                                                 .build())
     *                                                         .build())
     *                                                 .dataSets(List.of(DataSetProperty.builder()
     *                                                         .ccsid("ccsid")
     *                                                         .format("format")
     *                                                         .length(123)
     *                                                         .name("name")
     *                                                         .type("type")
     *                                                         .build()))
     *                                                 .build())
     *                                         .sourceLocation("sourceLocation")
     *                                         .targetLocation("targetLocation")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .output(OutputProperty.builder()
     *                                 .file(OutputFileProperty.builder()
     *                                         .fileLocation("fileLocation")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .mainframeAction(MainframeActionProperty.builder()
     *                         .actionType(MainframeActionTypeProperty.builder()
     *                                 .batch(BatchProperty.builder()
     *                                         .batchJobName("batchJobName")
     *                                         // the properties below are optional
     *                                         .batchJobParameters(Map.of(
     *                                                 "batchJobParametersKey", "batchJobParameters"))
     *                                         .exportDataSetNames(List.of("exportDataSetNames"))
     *                                         .build())
     *                                 .tn3270(TN3270Property.builder()
     *                                         .script(ScriptProperty.builder()
     *                                                 .scriptLocation("scriptLocation")
     *                                                 .type("type")
     *                                                 .build())
     *                                         // the properties below are optional
     *                                         .exportDataSetNames(List.of("exportDataSetNames"))
     *                                         .build())
     *                                 .build())
     *                         .resource("resource")
     *                         // the properties below are optional
     *                         .properties(MainframeActionPropertiesProperty.builder()
     *                                 .dmsTaskArn("dmsTaskArn")
     *                                 .build())
     *                         .build())
     *                 .resourceAction(ResourceActionProperty.builder()
     *                         .cloudFormationAction(CloudFormationActionProperty.builder()
     *                                 .resource("resource")
     *                                 // the properties below are optional
     *                                 .actionType("actionType")
     *                                 .build())
     *                         .m2ManagedApplicationAction(M2ManagedApplicationActionProperty.builder()
     *                                 .actionType("actionType")
     *                                 .resource("resource")
     *                                 // the properties below are optional
     *                                 .properties(M2ManagedActionPropertiesProperty.builder()
     *                                         .forceStop(false)
     *                                         .importDataSetLocation("importDataSetLocation")
     *                                         .build())
     *                                 .build())
     *                         .m2NonManagedApplicationAction(M2NonManagedApplicationActionProperty.builder()
     *                                 .actionType("actionType")
     *                                 .resource("resource")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .name("name")
     *         // the properties below are optional
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-step.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-step.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.StepProperty")
    @software.amazon.jsii.Jsii.Proxy(StepProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StepProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action of the step.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-step.html#cfn-apptest-testcase-step-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-step.html#cfn-apptest-testcase-step-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAction();

        /**
         * The name of the step.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-step.html#cfn-apptest-testcase-step-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-step.html#cfn-apptest-testcase-step-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The description of the step.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-step.html#cfn-apptest-testcase-step-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-step.html#cfn-apptest-testcase-step-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StepProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StepProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StepProperty> {
            java.lang.Object action;
            java.lang.String name;
            java.lang.String description;

            /**
             * Sets the value of {@link StepProperty#getAction}
             * @param action The action of the step. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.IResolvable action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link StepProperty#getAction}
             * @param action The action of the step. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(software.amazon.awscdk.services.apptest.CfnTestCase.StepActionProperty action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link StepProperty#getName}
             * @param name The name of the step. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link StepProperty#getDescription}
             * @param description The description of the step.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StepProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StepProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StepProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepProperty {
            private final java.lang.Object action;
            private final java.lang.String name;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.description = builder.description;
            }

            @Override
            public final java.lang.Object getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.StepProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StepProperty.Jsii$Proxy that = (StepProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!name.equals(that.name)) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the TN3270 protocol.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * TN3270Property tN3270Property = TN3270Property.builder()
     *         .script(ScriptProperty.builder()
     *                 .scriptLocation("scriptLocation")
     *                 .type("type")
     *                 .build())
     *         // the properties below are optional
     *         .exportDataSetNames(List.of("exportDataSetNames"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-tn3270.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-tn3270.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.TN3270Property")
    @software.amazon.jsii.Jsii.Proxy(TN3270Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TN3270Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * The script of the TN3270 protocol.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-tn3270.html#cfn-apptest-testcase-tn3270-script">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-tn3270.html#cfn-apptest-testcase-tn3270-script</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getScript();

        /**
         * The data set names of the TN3270 protocol.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-tn3270.html#cfn-apptest-testcase-tn3270-exportdatasetnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-tn3270.html#cfn-apptest-testcase-tn3270-exportdatasetnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExportDataSetNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TN3270Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TN3270Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TN3270Property> {
            java.lang.Object script;
            java.util.List<java.lang.String> exportDataSetNames;

            /**
             * Sets the value of {@link TN3270Property#getScript}
             * @param script The script of the TN3270 protocol. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder script(software.amazon.awscdk.IResolvable script) {
                this.script = script;
                return this;
            }

            /**
             * Sets the value of {@link TN3270Property#getScript}
             * @param script The script of the TN3270 protocol. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder script(software.amazon.awscdk.services.apptest.CfnTestCase.ScriptProperty script) {
                this.script = script;
                return this;
            }

            /**
             * Sets the value of {@link TN3270Property#getExportDataSetNames}
             * @param exportDataSetNames The data set names of the TN3270 protocol.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportDataSetNames(java.util.List<java.lang.String> exportDataSetNames) {
                this.exportDataSetNames = exportDataSetNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TN3270Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TN3270Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TN3270Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TN3270Property {
            private final java.lang.Object script;
            private final java.util.List<java.lang.String> exportDataSetNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.script = software.amazon.jsii.Kernel.get(this, "script", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.exportDataSetNames = software.amazon.jsii.Kernel.get(this, "exportDataSetNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.script = java.util.Objects.requireNonNull(builder.script, "script is required");
                this.exportDataSetNames = builder.exportDataSetNames;
            }

            @Override
            public final java.lang.Object getScript() {
                return this.script;
            }

            @Override
            public final java.util.List<java.lang.String> getExportDataSetNames() {
                return this.exportDataSetNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("script", om.valueToTree(this.getScript()));
                if (this.getExportDataSetNames() != null) {
                    data.set("exportDataSetNames", om.valueToTree(this.getExportDataSetNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.TN3270Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TN3270Property.Jsii$Proxy that = (TN3270Property.Jsii$Proxy) o;

                if (!script.equals(that.script)) return false;
                return this.exportDataSetNames != null ? this.exportDataSetNames.equals(that.exportDataSetNames) : that.exportDataSetNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.script.hashCode();
                result = 31 * result + (this.exportDataSetNames != null ? this.exportDataSetNames.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies a target database metadata.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * TargetDatabaseMetadataProperty targetDatabaseMetadataProperty = TargetDatabaseMetadataProperty.builder()
     *         .captureTool("captureTool")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-targetdatabasemetadata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-targetdatabasemetadata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.TargetDatabaseMetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(TargetDatabaseMetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TargetDatabaseMetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The capture tool of the target database metadata.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-targetdatabasemetadata.html#cfn-apptest-testcase-targetdatabasemetadata-capturetool">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-targetdatabasemetadata.html#cfn-apptest-testcase-targetdatabasemetadata-capturetool</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCaptureTool();

        /**
         * The type of the target database metadata.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-targetdatabasemetadata.html#cfn-apptest-testcase-targetdatabasemetadata-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-targetdatabasemetadata.html#cfn-apptest-testcase-targetdatabasemetadata-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link TargetDatabaseMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TargetDatabaseMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TargetDatabaseMetadataProperty> {
            java.lang.String captureTool;
            java.lang.String type;

            /**
             * Sets the value of {@link TargetDatabaseMetadataProperty#getCaptureTool}
             * @param captureTool The capture tool of the target database metadata. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder captureTool(java.lang.String captureTool) {
                this.captureTool = captureTool;
                return this;
            }

            /**
             * Sets the value of {@link TargetDatabaseMetadataProperty#getType}
             * @param type The type of the target database metadata. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TargetDatabaseMetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TargetDatabaseMetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TargetDatabaseMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TargetDatabaseMetadataProperty {
            private final java.lang.String captureTool;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.captureTool = software.amazon.jsii.Kernel.get(this, "captureTool", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.captureTool = java.util.Objects.requireNonNull(builder.captureTool, "captureTool is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getCaptureTool() {
                return this.captureTool;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("captureTool", om.valueToTree(this.getCaptureTool()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.TargetDatabaseMetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TargetDatabaseMetadataProperty.Jsii$Proxy that = (TargetDatabaseMetadataProperty.Jsii$Proxy) o;

                if (!captureTool.equals(that.captureTool)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.captureTool.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies the latest version of a test case.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.apptest.*;
     * TestCaseLatestVersionProperty testCaseLatestVersionProperty = TestCaseLatestVersionProperty.builder()
     *         .status("status")
     *         .version(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-testcaselatestversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-testcaselatestversion.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apptest.CfnTestCase.TestCaseLatestVersionProperty")
    @software.amazon.jsii.Jsii.Proxy(TestCaseLatestVersionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TestCaseLatestVersionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The status of the test case latest version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-testcaselatestversion.html#cfn-apptest-testcase-testcaselatestversion-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-testcaselatestversion.html#cfn-apptest-testcase-testcaselatestversion-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStatus();

        /**
         * The version of the test case latest version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-testcaselatestversion.html#cfn-apptest-testcase-testcaselatestversion-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apptest-testcase-testcaselatestversion.html#cfn-apptest-testcase-testcaselatestversion-version</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getVersion();

        /**
         * @return a {@link Builder} of {@link TestCaseLatestVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TestCaseLatestVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TestCaseLatestVersionProperty> {
            java.lang.String status;
            java.lang.Number version;

            /**
             * Sets the value of {@link TestCaseLatestVersionProperty#getStatus}
             * @param status The status of the test case latest version. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link TestCaseLatestVersionProperty#getVersion}
             * @param version The version of the test case latest version. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.Number version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TestCaseLatestVersionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TestCaseLatestVersionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TestCaseLatestVersionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TestCaseLatestVersionProperty {
            private final java.lang.String status;
            private final java.lang.Number version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.status = java.util.Objects.requireNonNull(builder.status, "status is required");
                this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.lang.Number getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("status", om.valueToTree(this.getStatus()));
                data.set("version", om.valueToTree(this.getVersion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apptest.CfnTestCase.TestCaseLatestVersionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TestCaseLatestVersionProperty.Jsii$Proxy that = (TestCaseLatestVersionProperty.Jsii$Proxy) o;

                if (!status.equals(that.status)) return false;
                return this.version.equals(that.version);
            }

            @Override
            public final int hashCode() {
                int result = this.status.hashCode();
                result = 31 * result + (this.version.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apptest.CfnTestCase}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apptest.CfnTestCase> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apptest.CfnTestCaseProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apptest.CfnTestCaseProps.Builder();
        }

        /**
         * The name of the test case.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-name</a>
         * @param name The name of the test case. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The steps in the test case.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-steps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-steps</a>
         * @param steps The steps in the test case. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder steps(final software.amazon.awscdk.IResolvable steps) {
            this.props.steps(steps);
            return this;
        }
        /**
         * The steps in the test case.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-steps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-steps</a>
         * @param steps The steps in the test case. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder steps(final java.util.List<? extends java.lang.Object> steps) {
            this.props.steps(steps);
            return this;
        }

        /**
         * The description of the test case.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-description</a>
         * @param description The description of the test case. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The specified tags of the test case.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apptest-testcase.html#cfn-apptest-testcase-tags</a>
         * @param tags The specified tags of the test case. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apptest.CfnTestCase}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apptest.CfnTestCase build() {
            return new software.amazon.awscdk.services.apptest.CfnTestCase(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
