package software.amazon.awscdk.services.autoscaling;

/**
 * EC2 Heath checks options.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.MICRO))
 *         .machineImage(MachineImage.latestAmazonLinux2())
 *         .healthChecks(HealthChecks.ec2(Ec2HealthChecksOptions.builder()
 *                 .gracePeriod(Duration.seconds(100))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:11.766Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.Ec2HealthChecksOptions")
@software.amazon.jsii.Jsii.Proxy(Ec2HealthChecksOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface Ec2HealthChecksOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specified the time Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check.
     * <p>
     * Default: Duration.seconds(0)
     * <p>
     * @see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html">https://docs.aws.amazon.com/autoscaling/ec2/userguide/health-check-grace-period.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getGracePeriod() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link Ec2HealthChecksOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link Ec2HealthChecksOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<Ec2HealthChecksOptions> {
        software.amazon.awscdk.Duration gracePeriod;

        /**
         * Sets the value of {@link Ec2HealthChecksOptions#getGracePeriod}
         * @param gracePeriod Specified the time Auto Scaling waits before checking the health status of an EC2 instance that has come into service and marking it unhealthy due to a failed health check.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gracePeriod(software.amazon.awscdk.Duration gracePeriod) {
            this.gracePeriod = gracePeriod;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link Ec2HealthChecksOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public Ec2HealthChecksOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link Ec2HealthChecksOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Ec2HealthChecksOptions {
        private final software.amazon.awscdk.Duration gracePeriod;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.gracePeriod = software.amazon.jsii.Kernel.get(this, "gracePeriod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.gracePeriod = builder.gracePeriod;
        }

        @Override
        public final software.amazon.awscdk.Duration getGracePeriod() {
            return this.gracePeriod;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getGracePeriod() != null) {
                data.set("gracePeriod", om.valueToTree(this.getGracePeriod()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.Ec2HealthChecksOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            Ec2HealthChecksOptions.Jsii$Proxy that = (Ec2HealthChecksOptions.Jsii$Proxy) o;

            return this.gracePeriod != null ? this.gracePeriod.equals(that.gracePeriod) : that.gracePeriod == null;
        }

        @Override
        public final int hashCode() {
            int result = this.gracePeriod != null ? this.gracePeriod.hashCode() : 0;
            return result;
        }
    }
}
