package software.amazon.awscdk.services.batch;

/**
 * Creates a Host volume.
 * <p>
 * This volume will persist on the host at the specified <code>hostPath</code>.
 * If the <code>hostPath</code> is not specified, Docker will choose the host path. In this case,
 * the data may not persist after the containers that use it stop running.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * HostVolume hostVolume = HostVolume.Builder.create()
 *         .containerPath("containerPath")
 *         .name("name")
 *         // the properties below are optional
 *         .hostPath("hostPath")
 *         .readonly(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:12.075Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.HostVolume")
public class HostVolume extends software.amazon.awscdk.services.batch.EcsVolume {

    protected HostVolume(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HostVolume(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HostVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.HostVolumeOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * returns <code>true</code> if <code>x</code> is a <code>HostVolume</code>, <code>false</code> otherwise.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isHostVolume(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.HostVolume.class, "isHostVolume", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * The path on the host machine this container will have access to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getHostPath() {
        return software.amazon.jsii.Kernel.get(this, "hostPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.HostVolume}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.HostVolume> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.batch.HostVolumeOptions.Builder options;

        private Builder() {
            this.options = new software.amazon.awscdk.services.batch.HostVolumeOptions.Builder();
        }

        /**
         * the path on the container where this volume is mounted.
         * <p>
         * @return {@code this}
         * @param containerPath the path on the container where this volume is mounted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerPath(final java.lang.String containerPath) {
            this.options.containerPath(containerPath);
            return this;
        }

        /**
         * the name of this volume.
         * <p>
         * @return {@code this}
         * @param name the name of this volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.options.name(name);
            return this;
        }

        /**
         * if set, the container will have readonly access to the volume.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param readonly if set, the container will have readonly access to the volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonly(final java.lang.Boolean readonly) {
            this.options.readonly(readonly);
            return this;
        }

        /**
         * The path on the host machine this container will have access to.
         * <p>
         * Default: - Docker will choose the host path.
         * The data may not persist after the containers that use it stop running.
         * <p>
         * @return {@code this}
         * @param hostPath The path on the host machine this container will have access to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hostPath(final java.lang.String hostPath) {
            this.options.hostPath(hostPath);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.HostVolume}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.HostVolume build() {
            return new software.amazon.awscdk.services.batch.HostVolume(
                this.options.build()
            );
        }
    }
}
