package software.amazon.awscdk.services.batch;

/**
 * The properties for defining Linux-specific options that are applied to the container.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.batch.*;
 * Size size;
 * LinuxParametersProps linuxParametersProps = LinuxParametersProps.builder()
 *         .initProcessEnabled(false)
 *         .maxSwap(size)
 *         .sharedMemorySize(size)
 *         .swappiness(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:12.112Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.LinuxParametersProps")
@software.amazon.jsii.Jsii.Proxy(LinuxParametersProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LinuxParametersProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies whether to run an init process inside the container that forwards signals and reaps processes.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getInitProcessEnabled() {
        return null;
    }

    /**
     * The total amount of swap memory a container can use.
     * <p>
     * This parameter
     * will be translated to the --memory-swap option to docker run.
     * <p>
     * This parameter is only supported when you are using the EC2 launch type.
     * Accepted values are positive integers.
     * <p>
     * Default: No swap.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getMaxSwap() {
        return null;
    }

    /**
     * The value for the size of the /dev/shm volume.
     * <p>
     * Default: No shared memory.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Size getSharedMemorySize() {
        return null;
    }

    /**
     * This allows you to tune a container's memory swappiness behavior.
     * <p>
     * This parameter
     * maps to the --memory-swappiness option to docker run. The swappiness relates
     * to the kernel's tendency to swap memory. A value of 0 will cause swapping to
     * not happen unless absolutely necessary. A value of 100 will cause pages to
     * be swapped very aggressively.
     * <p>
     * This parameter is only supported when you are using the EC2 launch type.
     * Accepted values are whole numbers between 0 and 100. If a value is not
     * specified for maxSwap then this parameter is ignored.
     * <p>
     * Default: 60
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSwappiness() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LinuxParametersProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LinuxParametersProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LinuxParametersProps> {
        java.lang.Boolean initProcessEnabled;
        software.amazon.awscdk.Size maxSwap;
        software.amazon.awscdk.Size sharedMemorySize;
        java.lang.Number swappiness;

        /**
         * Sets the value of {@link LinuxParametersProps#getInitProcessEnabled}
         * @param initProcessEnabled Specifies whether to run an init process inside the container that forwards signals and reaps processes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initProcessEnabled(java.lang.Boolean initProcessEnabled) {
            this.initProcessEnabled = initProcessEnabled;
            return this;
        }

        /**
         * Sets the value of {@link LinuxParametersProps#getMaxSwap}
         * @param maxSwap The total amount of swap memory a container can use.
         *                This parameter
         *                will be translated to the --memory-swap option to docker run.
         *                <p>
         *                This parameter is only supported when you are using the EC2 launch type.
         *                Accepted values are positive integers.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSwap(software.amazon.awscdk.Size maxSwap) {
            this.maxSwap = maxSwap;
            return this;
        }

        /**
         * Sets the value of {@link LinuxParametersProps#getSharedMemorySize}
         * @param sharedMemorySize The value for the size of the /dev/shm volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sharedMemorySize(software.amazon.awscdk.Size sharedMemorySize) {
            this.sharedMemorySize = sharedMemorySize;
            return this;
        }

        /**
         * Sets the value of {@link LinuxParametersProps#getSwappiness}
         * @param swappiness This allows you to tune a container's memory swappiness behavior.
         *                   This parameter
         *                   maps to the --memory-swappiness option to docker run. The swappiness relates
         *                   to the kernel's tendency to swap memory. A value of 0 will cause swapping to
         *                   not happen unless absolutely necessary. A value of 100 will cause pages to
         *                   be swapped very aggressively.
         *                   <p>
         *                   This parameter is only supported when you are using the EC2 launch type.
         *                   Accepted values are whole numbers between 0 and 100. If a value is not
         *                   specified for maxSwap then this parameter is ignored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder swappiness(java.lang.Number swappiness) {
            this.swappiness = swappiness;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LinuxParametersProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LinuxParametersProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LinuxParametersProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LinuxParametersProps {
        private final java.lang.Boolean initProcessEnabled;
        private final software.amazon.awscdk.Size maxSwap;
        private final software.amazon.awscdk.Size sharedMemorySize;
        private final java.lang.Number swappiness;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.initProcessEnabled = software.amazon.jsii.Kernel.get(this, "initProcessEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.maxSwap = software.amazon.jsii.Kernel.get(this, "maxSwap", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.sharedMemorySize = software.amazon.jsii.Kernel.get(this, "sharedMemorySize", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.swappiness = software.amazon.jsii.Kernel.get(this, "swappiness", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.initProcessEnabled = builder.initProcessEnabled;
            this.maxSwap = builder.maxSwap;
            this.sharedMemorySize = builder.sharedMemorySize;
            this.swappiness = builder.swappiness;
        }

        @Override
        public final java.lang.Boolean getInitProcessEnabled() {
            return this.initProcessEnabled;
        }

        @Override
        public final software.amazon.awscdk.Size getMaxSwap() {
            return this.maxSwap;
        }

        @Override
        public final software.amazon.awscdk.Size getSharedMemorySize() {
            return this.sharedMemorySize;
        }

        @Override
        public final java.lang.Number getSwappiness() {
            return this.swappiness;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getInitProcessEnabled() != null) {
                data.set("initProcessEnabled", om.valueToTree(this.getInitProcessEnabled()));
            }
            if (this.getMaxSwap() != null) {
                data.set("maxSwap", om.valueToTree(this.getMaxSwap()));
            }
            if (this.getSharedMemorySize() != null) {
                data.set("sharedMemorySize", om.valueToTree(this.getSharedMemorySize()));
            }
            if (this.getSwappiness() != null) {
                data.set("swappiness", om.valueToTree(this.getSwappiness()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.LinuxParametersProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LinuxParametersProps.Jsii$Proxy that = (LinuxParametersProps.Jsii$Proxy) o;

            if (this.initProcessEnabled != null ? !this.initProcessEnabled.equals(that.initProcessEnabled) : that.initProcessEnabled != null) return false;
            if (this.maxSwap != null ? !this.maxSwap.equals(that.maxSwap) : that.maxSwap != null) return false;
            if (this.sharedMemorySize != null ? !this.sharedMemorySize.equals(that.sharedMemorySize) : that.sharedMemorySize != null) return false;
            return this.swappiness != null ? this.swappiness.equals(that.swappiness) : that.swappiness == null;
        }

        @Override
        public final int hashCode() {
            int result = this.initProcessEnabled != null ? this.initProcessEnabled.hashCode() : 0;
            result = 31 * result + (this.maxSwap != null ? this.maxSwap.hashCode() : 0);
            result = 31 * result + (this.sharedMemorySize != null ? this.sharedMemorySize.hashCode() : 0);
            result = 31 * result + (this.swappiness != null ? this.swappiness.hashCode() : 0);
            return result;
        }
    }
}
