package software.amazon.awscdk.services.batch;

/**
 * Define how Jobs using this JobDefinition respond to different exit conditions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EcsJobDefinition jobDefn = EcsJobDefinition.Builder.create(this, "JobDefn")
 *         .container(EcsEc2ContainerDefinition.Builder.create(this, "containerDefn")
 *                 .image(ContainerImage.fromRegistry("public.ecr.aws/amazonlinux/amazonlinux:latest"))
 *                 .memory(Size.mebibytes(2048))
 *                 .cpu(256)
 *                 .build())
 *         .retryAttempts(5)
 *         .retryStrategies(List.of(RetryStrategy.of(Action.EXIT, Reason.CANNOT_PULL_CONTAINER)))
 *         .build();
 * jobDefn.addRetryStrategy(RetryStrategy.of(Action.EXIT, Reason.SPOT_INSTANCE_RECLAIMED));
 * jobDefn.addRetryStrategy(RetryStrategy.of(Action.EXIT, Reason.CANNOT_PULL_CONTAINER));
 * jobDefn.addRetryStrategy(RetryStrategy.of(Action.EXIT, Reason.custom(CustomReason.builder()
 *         .onExitCode("40*")
 *         .onReason("some reason")
 *         .build())));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:12.137Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.RetryStrategy")
public class RetryStrategy extends software.amazon.jsii.JsiiObject {

    protected RetryStrategy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RetryStrategy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param action This parameter is required.
     * @param on This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public RetryStrategy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Action action, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Reason on) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(action, "action is required"), java.util.Objects.requireNonNull(on, "on is required") });
    }

    /**
     * Create a new RetryStrategy.
     * <p>
     * @param action This parameter is required.
     * @param on This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.RetryStrategy of(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Action action, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Reason on) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.RetryStrategy.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.RetryStrategy.class), new Object[] { java.util.Objects.requireNonNull(action, "action is required"), java.util.Objects.requireNonNull(on, "on is required") });
    }

    /**
     * The action to take when the job exits with the Reason specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Action getAction() {
        return software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Action.class));
    }

    /**
     * If the job exits with this Reason it will trigger the specified Action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.Reason getOn() {
        return software.amazon.jsii.Kernel.get(this, "on", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.Reason.class));
    }
}
