package software.amazon.awscdk.services.cloudformation;

/**
 * Properties for defining a <code>CfnGuardHook</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudformation.*;
 * CfnGuardHookProps cfnGuardHookProps = CfnGuardHookProps.builder()
 *         .alias("alias")
 *         .executionRole("executionRole")
 *         .failureMode("failureMode")
 *         .hookStatus("hookStatus")
 *         .ruleLocation(S3LocationProperty.builder()
 *                 .uri("uri")
 *                 // the properties below are optional
 *                 .versionId("versionId")
 *                 .build())
 *         .targetOperations(List.of("targetOperations"))
 *         // the properties below are optional
 *         .logBucket("logBucket")
 *         .options(OptionsProperty.builder()
 *                 .inputParams(S3LocationProperty.builder()
 *                         .uri("uri")
 *                         // the properties below are optional
 *                         .versionId("versionId")
 *                         .build())
 *                 .build())
 *         .stackFilters(StackFiltersProperty.builder()
 *                 .filteringCriteria("filteringCriteria")
 *                 // the properties below are optional
 *                 .stackNames(StackNamesProperty.builder()
 *                         .exclude(List.of("exclude"))
 *                         .include(List.of("include"))
 *                         .build())
 *                 .stackRoles(StackRolesProperty.builder()
 *                         .exclude(List.of("exclude"))
 *                         .include(List.of("include"))
 *                         .build())
 *                 .build())
 *         .targetFilters(TargetFiltersProperty.builder()
 *                 .targets(List.of(HookTargetProperty.builder()
 *                         .action("action")
 *                         .invocationPoint("invocationPoint")
 *                         .targetName("targetName")
 *                         .build()))
 *                 // the properties below are optional
 *                 .actions(List.of("actions"))
 *                 .invocationPoints(List.of("invocationPoints"))
 *                 .targetNames(List.of("targetNames"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:12.632Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudformation.CfnGuardHookProps")
@software.amazon.jsii.Jsii.Proxy(CfnGuardHookProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGuardHookProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type name alias for the Hook. This alias must be unique per account and Region.
     * <p>
     * The alias must be in the form <code>Name1::Name2::Name3</code> and must not begin with <code>AWS</code> . For example, <code>Private::Guard::MyTestHook</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-alias">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-alias</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAlias();

    /**
     * The IAM role that the Hook assumes to retrieve your Guard rules from S3 and optionally write a detailed Guard output report back.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-executionrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-executionrole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getExecutionRole();

    /**
     * Specifies how the Hook responds when rules fail their evaluation.
     * <p>
     * <ul>
     * <li><code>FAIL</code> : Prevents the action from proceeding. This is helpful for enforcing strict compliance or security policies.</li>
     * <li><code>WARN</code> : Issues warnings to users but allows actions to continue. This is useful for non-critical validations or informational checks.</li>
     * </ul>
     * <p>
     * Default: - "WARN"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-failuremode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-failuremode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFailureMode();

    /**
     * Specifies if the Hook is <code>ENABLED</code> or <code>DISABLED</code> .
     * <p>
     * Default: - "DISABLED"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-hookstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-hookstatus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getHookStatus();

    /**
     * Specifies the S3 location of your Guard rules.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-rulelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-rulelocation</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getRuleLocation();

    /**
     * Specifies the list of operations the Hook is run against.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/hooks-userguide/hooks-concepts.html#hook-terms-hook-target">Hook targets</a> in the <em>AWS CloudFormation Hooks User Guide</em> .
     * <p>
     * Valid values: <code>STACK</code> | <code>RESOURCE</code> | <code>CHANGE_SET</code> | <code>CLOUD_CONTROL</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-targetoperations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-targetoperations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getTargetOperations();

    /**
     * Specifies the name of an S3 bucket to store the Guard output report.
     * <p>
     * This report contains the results of your Guard rule validations.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-logbucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-logbucket</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogBucket() {
        return null;
    }

    /**
     * Specifies the S3 location of your input parameters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-options</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOptions() {
        return null;
    }

    /**
     * Specifies the stack level filters for the Hook.
     * <p>
     * Example stack level filter in JSON:
     * <p>
     * <code>"StackFilters": {"FilteringCriteria": "ALL", "StackNames": {"Exclude": [ "stack-1", "stack-2"]}}</code>
     * <p>
     * Example stack level filter in YAML:
     * <p>
     * <code>StackFilters: FilteringCriteria: ALL StackNames: Exclude: - stack-1 - stack-2</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-stackfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-stackfilters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStackFilters() {
        return null;
    }

    /**
     * Specifies the target filters for the Hook.
     * <p>
     * Example target filter in JSON:
     * <p>
     * <code>"TargetFilters": {"Actions": [ "Create", "Update", "Delete" ]}</code>
     * <p>
     * Example target filter in YAML:
     * <p>
     * <code>TargetFilters: Actions: - CREATE - UPDATE - DELETE</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-targetfilters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudformation-guardhook.html#cfn-cloudformation-guardhook-targetfilters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTargetFilters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGuardHookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGuardHookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGuardHookProps> {
        java.lang.String alias;
        java.lang.String executionRole;
        java.lang.String failureMode;
        java.lang.String hookStatus;
        java.lang.Object ruleLocation;
        java.util.List<java.lang.String> targetOperations;
        java.lang.String logBucket;
        java.lang.Object options;
        java.lang.Object stackFilters;
        java.lang.Object targetFilters;

        /**
         * Sets the value of {@link CfnGuardHookProps#getAlias}
         * @param alias The type name alias for the Hook. This alias must be unique per account and Region. This parameter is required.
         *              The alias must be in the form <code>Name1::Name2::Name3</code> and must not begin with <code>AWS</code> . For example, <code>Private::Guard::MyTestHook</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alias(java.lang.String alias) {
            this.alias = alias;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardHookProps#getExecutionRole}
         * @param executionRole The IAM role that the Hook assumes to retrieve your Guard rules from S3 and optionally write a detailed Guard output report back. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRole(java.lang.String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardHookProps#getFailureMode}
         * @param failureMode Specifies how the Hook responds when rules fail their evaluation. This parameter is required.
         *                    <ul>
         *                    <li><code>FAIL</code> : Prevents the action from proceeding. This is helpful for enforcing strict compliance or security policies.</li>
         *                    <li><code>WARN</code> : Issues warnings to users but allows actions to continue. This is useful for non-critical validations or informational checks.</li>
         *                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failureMode(java.lang.String failureMode) {
            this.failureMode = failureMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardHookProps#getHookStatus}
         * @param hookStatus Specifies if the Hook is <code>ENABLED</code> or <code>DISABLED</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hookStatus(java.lang.String hookStatus) {
            this.hookStatus = hookStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardHookProps#getRuleLocation}
         * @param ruleLocation Specifies the S3 location of your Guard rules. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleLocation(software.amazon.awscdk.IResolvable ruleLocation) {
            this.ruleLocation = ruleLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardHookProps#getRuleLocation}
         * @param ruleLocation Specifies the S3 location of your Guard rules. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleLocation(software.amazon.awscdk.services.cloudformation.CfnGuardHook.S3LocationProperty ruleLocation) {
            this.ruleLocation = ruleLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardHookProps#getTargetOperations}
         * @param targetOperations Specifies the list of operations the Hook is run against. This parameter is required.
         *                         For more information, see <a href="https://docs.aws.amazon.com/cloudformation-cli/latest/hooks-userguide/hooks-concepts.html#hook-terms-hook-target">Hook targets</a> in the <em>AWS CloudFormation Hooks User Guide</em> .
         *                         <p>
         *                         Valid values: <code>STACK</code> | <code>RESOURCE</code> | <code>CHANGE_SET</code> | <code>CLOUD_CONTROL</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetOperations(java.util.List<java.lang.String> targetOperations) {
            this.targetOperations = targetOperations;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardHookProps#getLogBucket}
         * @param logBucket Specifies the name of an S3 bucket to store the Guard output report.
         *                  This report contains the results of your Guard rule validations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logBucket(java.lang.String logBucket) {
            this.logBucket = logBucket;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardHookProps#getOptions}
         * @param options Specifies the S3 location of your input parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.IResolvable options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardHookProps#getOptions}
         * @param options Specifies the S3 location of your input parameters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.services.cloudformation.CfnGuardHook.OptionsProperty options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardHookProps#getStackFilters}
         * @param stackFilters Specifies the stack level filters for the Hook.
         *                     Example stack level filter in JSON:
         *                     <p>
         *                     <code>"StackFilters": {"FilteringCriteria": "ALL", "StackNames": {"Exclude": [ "stack-1", "stack-2"]}}</code>
         *                     <p>
         *                     Example stack level filter in YAML:
         *                     <p>
         *                     <code>StackFilters: FilteringCriteria: ALL StackNames: Exclude: - stack-1 - stack-2</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackFilters(software.amazon.awscdk.IResolvable stackFilters) {
            this.stackFilters = stackFilters;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardHookProps#getStackFilters}
         * @param stackFilters Specifies the stack level filters for the Hook.
         *                     Example stack level filter in JSON:
         *                     <p>
         *                     <code>"StackFilters": {"FilteringCriteria": "ALL", "StackNames": {"Exclude": [ "stack-1", "stack-2"]}}</code>
         *                     <p>
         *                     Example stack level filter in YAML:
         *                     <p>
         *                     <code>StackFilters: FilteringCriteria: ALL StackNames: Exclude: - stack-1 - stack-2</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackFilters(software.amazon.awscdk.services.cloudformation.CfnGuardHook.StackFiltersProperty stackFilters) {
            this.stackFilters = stackFilters;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardHookProps#getTargetFilters}
         * @param targetFilters Specifies the target filters for the Hook.
         *                      Example target filter in JSON:
         *                      <p>
         *                      <code>"TargetFilters": {"Actions": [ "Create", "Update", "Delete" ]}</code>
         *                      <p>
         *                      Example target filter in YAML:
         *                      <p>
         *                      <code>TargetFilters: Actions: - CREATE - UPDATE - DELETE</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetFilters(software.amazon.awscdk.IResolvable targetFilters) {
            this.targetFilters = targetFilters;
            return this;
        }

        /**
         * Sets the value of {@link CfnGuardHookProps#getTargetFilters}
         * @param targetFilters Specifies the target filters for the Hook.
         *                      Example target filter in JSON:
         *                      <p>
         *                      <code>"TargetFilters": {"Actions": [ "Create", "Update", "Delete" ]}</code>
         *                      <p>
         *                      Example target filter in YAML:
         *                      <p>
         *                      <code>TargetFilters: Actions: - CREATE - UPDATE - DELETE</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetFilters(software.amazon.awscdk.services.cloudformation.CfnGuardHook.TargetFiltersProperty targetFilters) {
            this.targetFilters = targetFilters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGuardHookProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGuardHookProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGuardHookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGuardHookProps {
        private final java.lang.String alias;
        private final java.lang.String executionRole;
        private final java.lang.String failureMode;
        private final java.lang.String hookStatus;
        private final java.lang.Object ruleLocation;
        private final java.util.List<java.lang.String> targetOperations;
        private final java.lang.String logBucket;
        private final java.lang.Object options;
        private final java.lang.Object stackFilters;
        private final java.lang.Object targetFilters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.alias = software.amazon.jsii.Kernel.get(this, "alias", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionRole = software.amazon.jsii.Kernel.get(this, "executionRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.failureMode = software.amazon.jsii.Kernel.get(this, "failureMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.hookStatus = software.amazon.jsii.Kernel.get(this, "hookStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ruleLocation = software.amazon.jsii.Kernel.get(this, "ruleLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.targetOperations = software.amazon.jsii.Kernel.get(this, "targetOperations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.logBucket = software.amazon.jsii.Kernel.get(this, "logBucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.stackFilters = software.amazon.jsii.Kernel.get(this, "stackFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.targetFilters = software.amazon.jsii.Kernel.get(this, "targetFilters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.alias = java.util.Objects.requireNonNull(builder.alias, "alias is required");
            this.executionRole = java.util.Objects.requireNonNull(builder.executionRole, "executionRole is required");
            this.failureMode = java.util.Objects.requireNonNull(builder.failureMode, "failureMode is required");
            this.hookStatus = java.util.Objects.requireNonNull(builder.hookStatus, "hookStatus is required");
            this.ruleLocation = java.util.Objects.requireNonNull(builder.ruleLocation, "ruleLocation is required");
            this.targetOperations = java.util.Objects.requireNonNull(builder.targetOperations, "targetOperations is required");
            this.logBucket = builder.logBucket;
            this.options = builder.options;
            this.stackFilters = builder.stackFilters;
            this.targetFilters = builder.targetFilters;
        }

        @Override
        public final java.lang.String getAlias() {
            return this.alias;
        }

        @Override
        public final java.lang.String getExecutionRole() {
            return this.executionRole;
        }

        @Override
        public final java.lang.String getFailureMode() {
            return this.failureMode;
        }

        @Override
        public final java.lang.String getHookStatus() {
            return this.hookStatus;
        }

        @Override
        public final java.lang.Object getRuleLocation() {
            return this.ruleLocation;
        }

        @Override
        public final java.util.List<java.lang.String> getTargetOperations() {
            return this.targetOperations;
        }

        @Override
        public final java.lang.String getLogBucket() {
            return this.logBucket;
        }

        @Override
        public final java.lang.Object getOptions() {
            return this.options;
        }

        @Override
        public final java.lang.Object getStackFilters() {
            return this.stackFilters;
        }

        @Override
        public final java.lang.Object getTargetFilters() {
            return this.targetFilters;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("alias", om.valueToTree(this.getAlias()));
            data.set("executionRole", om.valueToTree(this.getExecutionRole()));
            data.set("failureMode", om.valueToTree(this.getFailureMode()));
            data.set("hookStatus", om.valueToTree(this.getHookStatus()));
            data.set("ruleLocation", om.valueToTree(this.getRuleLocation()));
            data.set("targetOperations", om.valueToTree(this.getTargetOperations()));
            if (this.getLogBucket() != null) {
                data.set("logBucket", om.valueToTree(this.getLogBucket()));
            }
            if (this.getOptions() != null) {
                data.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getStackFilters() != null) {
                data.set("stackFilters", om.valueToTree(this.getStackFilters()));
            }
            if (this.getTargetFilters() != null) {
                data.set("targetFilters", om.valueToTree(this.getTargetFilters()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudformation.CfnGuardHookProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGuardHookProps.Jsii$Proxy that = (CfnGuardHookProps.Jsii$Proxy) o;

            if (!alias.equals(that.alias)) return false;
            if (!executionRole.equals(that.executionRole)) return false;
            if (!failureMode.equals(that.failureMode)) return false;
            if (!hookStatus.equals(that.hookStatus)) return false;
            if (!ruleLocation.equals(that.ruleLocation)) return false;
            if (!targetOperations.equals(that.targetOperations)) return false;
            if (this.logBucket != null ? !this.logBucket.equals(that.logBucket) : that.logBucket != null) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            if (this.stackFilters != null ? !this.stackFilters.equals(that.stackFilters) : that.stackFilters != null) return false;
            return this.targetFilters != null ? this.targetFilters.equals(that.targetFilters) : that.targetFilters == null;
        }

        @Override
        public final int hashCode() {
            int result = this.alias.hashCode();
            result = 31 * result + (this.executionRole.hashCode());
            result = 31 * result + (this.failureMode.hashCode());
            result = 31 * result + (this.hookStatus.hashCode());
            result = 31 * result + (this.ruleLocation.hashCode());
            result = 31 * result + (this.targetOperations.hashCode());
            result = 31 * result + (this.logBucket != null ? this.logBucket.hashCode() : 0);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.stackFilters != null ? this.stackFilters.hashCode() : 0);
            result = 31 * result + (this.targetFilters != null ? this.targetFilters.hashCode() : 0);
            return result;
        }
    }
}
