package software.amazon.awscdk.services.cloudwatch.actions;

/**
 * Types of OpsItem category available.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Alarm alarm;
 * // Create an OpsItem with specific severity and category when alarm triggers
 * alarm.addAlarmAction(
 * new SsmAction(OpsItemSeverity.CRITICAL, OpsItemCategory.PERFORMANCE));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:13.190Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch_actions.OpsItemCategory")
public enum OpsItemCategory {
    /**
     * Set the category to availability.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AVAILABILITY,
    /**
     * Set the category to cost.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COST,
    /**
     * Set the category to performance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PERFORMANCE,
    /**
     * Set the category to recovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RECOVERY,
    /**
     * Set the category to security.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SECURITY,
}
