package software.amazon.awscdk.services.codeartifact;

/**
 * Properties for defining a <code>CfnPackageGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codeartifact.*;
 * CfnPackageGroupProps cfnPackageGroupProps = CfnPackageGroupProps.builder()
 *         .domainName("domainName")
 *         .pattern("pattern")
 *         // the properties below are optional
 *         .contactInfo("contactInfo")
 *         .description("description")
 *         .domainOwner("domainOwner")
 *         .originConfiguration(OriginConfigurationProperty.builder()
 *                 .restrictions(RestrictionsProperty.builder()
 *                         .externalUpstream(RestrictionTypeProperty.builder()
 *                                 .restrictionMode("restrictionMode")
 *                                 // the properties below are optional
 *                                 .repositories(List.of("repositories"))
 *                                 .build())
 *                         .internalUpstream(RestrictionTypeProperty.builder()
 *                                 .restrictionMode("restrictionMode")
 *                                 // the properties below are optional
 *                                 .repositories(List.of("repositories"))
 *                                 .build())
 *                         .publish(RestrictionTypeProperty.builder()
 *                                 .restrictionMode("restrictionMode")
 *                                 // the properties below are optional
 *                                 .repositories(List.of("repositories"))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:13.197Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codeartifact.CfnPackageGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnPackageGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnPackageGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The domain that contains the package group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-domainname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * The pattern of the package group.
     * <p>
     * The pattern determines which packages are associated with the package group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-pattern">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-pattern</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPattern();

    /**
     * The contact information of the package group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-contactinfo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-contactinfo</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getContactInfo() {
        return null;
    }

    /**
     * The description of the package group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The 12-digit account number of the AWS account that owns the domain.
     * <p>
     * It does not include dashes or spaces.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-domainowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-domainowner</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomainOwner() {
        return null;
    }

    /**
     * Details about the package origin configuration of a package group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-originconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-originconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOriginConfiguration() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to the package group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codeartifact-packagegroup.html#cfn-codeartifact-packagegroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnPackageGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnPackageGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnPackageGroupProps> {
        java.lang.String domainName;
        java.lang.String pattern;
        java.lang.String contactInfo;
        java.lang.String description;
        java.lang.String domainOwner;
        java.lang.Object originConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnPackageGroupProps#getDomainName}
         * @param domainName The domain that contains the package group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackageGroupProps#getPattern}
         * @param pattern The pattern of the package group. This parameter is required.
         *                The pattern determines which packages are associated with the package group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pattern(java.lang.String pattern) {
            this.pattern = pattern;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackageGroupProps#getContactInfo}
         * @param contactInfo The contact information of the package group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contactInfo(java.lang.String contactInfo) {
            this.contactInfo = contactInfo;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackageGroupProps#getDescription}
         * @param description The description of the package group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackageGroupProps#getDomainOwner}
         * @param domainOwner The 12-digit account number of the AWS account that owns the domain.
         *                    It does not include dashes or spaces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainOwner(java.lang.String domainOwner) {
            this.domainOwner = domainOwner;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackageGroupProps#getOriginConfiguration}
         * @param originConfiguration Details about the package origin configuration of a package group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originConfiguration(software.amazon.awscdk.IResolvable originConfiguration) {
            this.originConfiguration = originConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackageGroupProps#getOriginConfiguration}
         * @param originConfiguration Details about the package origin configuration of a package group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originConfiguration(software.amazon.awscdk.services.codeartifact.CfnPackageGroup.OriginConfigurationProperty originConfiguration) {
            this.originConfiguration = originConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnPackageGroupProps#getTags}
         * @param tags An array of key-value pairs to apply to the package group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnPackageGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnPackageGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnPackageGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnPackageGroupProps {
        private final java.lang.String domainName;
        private final java.lang.String pattern;
        private final java.lang.String contactInfo;
        private final java.lang.String description;
        private final java.lang.String domainOwner;
        private final java.lang.Object originConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pattern = software.amazon.jsii.Kernel.get(this, "pattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contactInfo = software.amazon.jsii.Kernel.get(this, "contactInfo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainOwner = software.amazon.jsii.Kernel.get(this, "domainOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.originConfiguration = software.amazon.jsii.Kernel.get(this, "originConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.pattern = java.util.Objects.requireNonNull(builder.pattern, "pattern is required");
            this.contactInfo = builder.contactInfo;
            this.description = builder.description;
            this.domainOwner = builder.domainOwner;
            this.originConfiguration = builder.originConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.String getPattern() {
            return this.pattern;
        }

        @Override
        public final java.lang.String getContactInfo() {
            return this.contactInfo;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDomainOwner() {
            return this.domainOwner;
        }

        @Override
        public final java.lang.Object getOriginConfiguration() {
            return this.originConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("domainName", om.valueToTree(this.getDomainName()));
            data.set("pattern", om.valueToTree(this.getPattern()));
            if (this.getContactInfo() != null) {
                data.set("contactInfo", om.valueToTree(this.getContactInfo()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDomainOwner() != null) {
                data.set("domainOwner", om.valueToTree(this.getDomainOwner()));
            }
            if (this.getOriginConfiguration() != null) {
                data.set("originConfiguration", om.valueToTree(this.getOriginConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codeartifact.CfnPackageGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnPackageGroupProps.Jsii$Proxy that = (CfnPackageGroupProps.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (!pattern.equals(that.pattern)) return false;
            if (this.contactInfo != null ? !this.contactInfo.equals(that.contactInfo) : that.contactInfo != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.domainOwner != null ? !this.domainOwner.equals(that.domainOwner) : that.domainOwner != null) return false;
            if (this.originConfiguration != null ? !this.originConfiguration.equals(that.originConfiguration) : that.originConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.pattern.hashCode());
            result = 31 * result + (this.contactInfo != null ? this.contactInfo.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.domainOwner != null ? this.domainOwner.hashCode() : 0);
            result = 31 * result + (this.originConfiguration != null ? this.originConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
