package software.amazon.awscdk.services.codepipeline;

/**
 * Specifies the constraints on the number of input and output artifacts an action can have.
 * <p>
 * The constraints for each action type are documented on the
 * <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html">Pipeline Structure Reference</a> page.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // MyAction is some action type that produces variables, like EcrSourceAction
 * MyAction myAction = new MyAction(new MyActionProps()
 *         // ...
 *         .actionName("myAction")
 *         );
 * new OtherAction(new OtherActionProps()
 *         // ...
 *         .config(myAction.getVariables().getMyVariable())
 *         .actionName("otherAction")
 *         );
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:13.496Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.ActionArtifactBounds")
@software.amazon.jsii.Jsii.Proxy(ActionArtifactBounds.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ActionArtifactBounds extends software.amazon.jsii.JsiiSerializable {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxInputs();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMaxOutputs();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMinInputs();

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getMinOutputs();

    /**
     * @return a {@link Builder} of {@link ActionArtifactBounds}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ActionArtifactBounds}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ActionArtifactBounds> {
        java.lang.Number maxInputs;
        java.lang.Number maxOutputs;
        java.lang.Number minInputs;
        java.lang.Number minOutputs;

        /**
         * Sets the value of {@link ActionArtifactBounds#getMaxInputs}
         * @param maxInputs the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxInputs(java.lang.Number maxInputs) {
            this.maxInputs = maxInputs;
            return this;
        }

        /**
         * Sets the value of {@link ActionArtifactBounds#getMaxOutputs}
         * @param maxOutputs the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxOutputs(java.lang.Number maxOutputs) {
            this.maxOutputs = maxOutputs;
            return this;
        }

        /**
         * Sets the value of {@link ActionArtifactBounds#getMinInputs}
         * @param minInputs the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minInputs(java.lang.Number minInputs) {
            this.minInputs = minInputs;
            return this;
        }

        /**
         * Sets the value of {@link ActionArtifactBounds#getMinOutputs}
         * @param minOutputs the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minOutputs(java.lang.Number minOutputs) {
            this.minOutputs = minOutputs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ActionArtifactBounds}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ActionArtifactBounds build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ActionArtifactBounds}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionArtifactBounds {
        private final java.lang.Number maxInputs;
        private final java.lang.Number maxOutputs;
        private final java.lang.Number minInputs;
        private final java.lang.Number minOutputs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxInputs = software.amazon.jsii.Kernel.get(this, "maxInputs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxOutputs = software.amazon.jsii.Kernel.get(this, "maxOutputs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minInputs = software.amazon.jsii.Kernel.get(this, "minInputs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minOutputs = software.amazon.jsii.Kernel.get(this, "minOutputs", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxInputs = java.util.Objects.requireNonNull(builder.maxInputs, "maxInputs is required");
            this.maxOutputs = java.util.Objects.requireNonNull(builder.maxOutputs, "maxOutputs is required");
            this.minInputs = java.util.Objects.requireNonNull(builder.minInputs, "minInputs is required");
            this.minOutputs = java.util.Objects.requireNonNull(builder.minOutputs, "minOutputs is required");
        }

        @Override
        public final java.lang.Number getMaxInputs() {
            return this.maxInputs;
        }

        @Override
        public final java.lang.Number getMaxOutputs() {
            return this.maxOutputs;
        }

        @Override
        public final java.lang.Number getMinInputs() {
            return this.minInputs;
        }

        @Override
        public final java.lang.Number getMinOutputs() {
            return this.minOutputs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("maxInputs", om.valueToTree(this.getMaxInputs()));
            data.set("maxOutputs", om.valueToTree(this.getMaxOutputs()));
            data.set("minInputs", om.valueToTree(this.getMinInputs()));
            data.set("minOutputs", om.valueToTree(this.getMinOutputs()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.ActionArtifactBounds"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ActionArtifactBounds.Jsii$Proxy that = (ActionArtifactBounds.Jsii$Proxy) o;

            if (!maxInputs.equals(that.maxInputs)) return false;
            if (!maxOutputs.equals(that.maxOutputs)) return false;
            if (!minInputs.equals(that.minInputs)) return false;
            return this.minOutputs.equals(that.minOutputs);
        }

        @Override
        public final int hashCode() {
            int result = this.maxInputs.hashCode();
            result = 31 * result + (this.maxOutputs.hashCode());
            result = 31 * result + (this.minInputs.hashCode());
            result = 31 * result + (this.minOutputs.hashCode());
            return result;
        }
    }
}
