package software.amazon.awscdk.services.codepipeline;

/**
 * The <code>AWS::CodePipeline::Pipeline</code> resource creates a CodePipeline pipeline that describes how software changes go through a release process.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/welcome.html">What Is CodePipeline?</a> in the <em>CodePipeline User Guide</em> .
 * <p>
 * For an example in YAML and JSON that contains the parameters in this reference, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#aws-resource-codepipeline-pipeline--examples">Examples</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.*;
 * Object configuration;
 * CfnPipeline cfnPipeline = CfnPipeline.Builder.create(this, "MyCfnPipeline")
 *         .roleArn("roleArn")
 *         .stages(List.of(StageDeclarationProperty.builder()
 *                 .actions(List.of(ActionDeclarationProperty.builder()
 *                         .actionTypeId(ActionTypeIdProperty.builder()
 *                                 .category("category")
 *                                 .owner("owner")
 *                                 .provider("provider")
 *                                 .version("version")
 *                                 .build())
 *                         .name("name")
 *                         // the properties below are optional
 *                         .commands(List.of("commands"))
 *                         .configuration(configuration)
 *                         .environmentVariables(List.of(EnvironmentVariableProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 // the properties below are optional
 *                                 .type("type")
 *                                 .build()))
 *                         .inputArtifacts(List.of(InputArtifactProperty.builder()
 *                                 .name("name")
 *                                 .build()))
 *                         .namespace("namespace")
 *                         .outputArtifacts(List.of(OutputArtifactProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .files(List.of("files"))
 *                                 .build()))
 *                         .outputVariables(List.of("outputVariables"))
 *                         .region("region")
 *                         .roleArn("roleArn")
 *                         .runOrder(123)
 *                         .timeoutInMinutes(123)
 *                         .build()))
 *                 .name("name")
 *                 // the properties below are optional
 *                 .beforeEntry(BeforeEntryConditionsProperty.builder()
 *                         .conditions(List.of(ConditionProperty.builder()
 *                                 .result("result")
 *                                 .rules(List.of(RuleDeclarationProperty.builder()
 *                                         .commands(List.of("commands"))
 *                                         .configuration(configuration)
 *                                         .inputArtifacts(List.of(InputArtifactProperty.builder()
 *                                                 .name("name")
 *                                                 .build()))
 *                                         .name("name")
 *                                         .region("region")
 *                                         .roleArn("roleArn")
 *                                         .ruleTypeId(RuleTypeIdProperty.builder()
 *                                                 .category("category")
 *                                                 .owner("owner")
 *                                                 .provider("provider")
 *                                                 .version("version")
 *                                                 .build())
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .blockers(List.of(BlockerDeclarationProperty.builder()
 *                         .name("name")
 *                         .type("type")
 *                         .build()))
 *                 .onFailure(FailureConditionsProperty.builder()
 *                         .conditions(List.of(ConditionProperty.builder()
 *                                 .result("result")
 *                                 .rules(List.of(RuleDeclarationProperty.builder()
 *                                         .commands(List.of("commands"))
 *                                         .configuration(configuration)
 *                                         .inputArtifacts(List.of(InputArtifactProperty.builder()
 *                                                 .name("name")
 *                                                 .build()))
 *                                         .name("name")
 *                                         .region("region")
 *                                         .roleArn("roleArn")
 *                                         .ruleTypeId(RuleTypeIdProperty.builder()
 *                                                 .category("category")
 *                                                 .owner("owner")
 *                                                 .provider("provider")
 *                                                 .version("version")
 *                                                 .build())
 *                                         .build()))
 *                                 .build()))
 *                         .result("result")
 *                         .retryConfiguration(RetryConfigurationProperty.builder()
 *                                 .retryMode("retryMode")
 *                                 .build())
 *                         .build())
 *                 .onSuccess(SuccessConditionsProperty.builder()
 *                         .conditions(List.of(ConditionProperty.builder()
 *                                 .result("result")
 *                                 .rules(List.of(RuleDeclarationProperty.builder()
 *                                         .commands(List.of("commands"))
 *                                         .configuration(configuration)
 *                                         .inputArtifacts(List.of(InputArtifactProperty.builder()
 *                                                 .name("name")
 *                                                 .build()))
 *                                         .name("name")
 *                                         .region("region")
 *                                         .roleArn("roleArn")
 *                                         .ruleTypeId(RuleTypeIdProperty.builder()
 *                                                 .category("category")
 *                                                 .owner("owner")
 *                                                 .provider("provider")
 *                                                 .version("version")
 *                                                 .build())
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         // the properties below are optional
 *         .artifactStore(ArtifactStoreProperty.builder()
 *                 .location("location")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .encryptionKey(EncryptionKeyProperty.builder()
 *                         .id("id")
 *                         .type("type")
 *                         .build())
 *                 .build())
 *         .artifactStores(List.of(ArtifactStoreMapProperty.builder()
 *                 .artifactStore(ArtifactStoreProperty.builder()
 *                         .location("location")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .encryptionKey(EncryptionKeyProperty.builder()
 *                                 .id("id")
 *                                 .type("type")
 *                                 .build())
 *                         .build())
 *                 .region("region")
 *                 .build()))
 *         .disableInboundStageTransitions(List.of(StageTransitionProperty.builder()
 *                 .reason("reason")
 *                 .stageName("stageName")
 *                 .build()))
 *         .executionMode("executionMode")
 *         .name("name")
 *         .pipelineType("pipelineType")
 *         .restartExecutionOnUpdate(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .triggers(List.of(PipelineTriggerDeclarationProperty.builder()
 *                 .providerType("providerType")
 *                 // the properties below are optional
 *                 .gitConfiguration(GitConfigurationProperty.builder()
 *                         .sourceActionName("sourceActionName")
 *                         // the properties below are optional
 *                         .pullRequest(List.of(GitPullRequestFilterProperty.builder()
 *                                 .branches(GitBranchFilterCriteriaProperty.builder()
 *                                         .excludes(List.of("excludes"))
 *                                         .includes(List.of("includes"))
 *                                         .build())
 *                                 .events(List.of("events"))
 *                                 .filePaths(GitFilePathFilterCriteriaProperty.builder()
 *                                         .excludes(List.of("excludes"))
 *                                         .includes(List.of("includes"))
 *                                         .build())
 *                                 .build()))
 *                         .push(List.of(GitPushFilterProperty.builder()
 *                                 .branches(GitBranchFilterCriteriaProperty.builder()
 *                                         .excludes(List.of("excludes"))
 *                                         .includes(List.of("includes"))
 *                                         .build())
 *                                 .filePaths(GitFilePathFilterCriteriaProperty.builder()
 *                                         .excludes(List.of("excludes"))
 *                                         .includes(List.of("includes"))
 *                                         .build())
 *                                 .tags(GitTagFilterCriteriaProperty.builder()
 *                                         .excludes(List.of("excludes"))
 *                                         .includes(List.of("includes"))
 *                                         .build())
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .variables(List.of(VariableDeclarationProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .defaultValue("defaultValue")
 *                 .description("description")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:13.516Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline")
public class CfnPipeline extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnPipeline(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPipeline(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codepipeline.CfnPipeline.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPipeline(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.CfnPipelineProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The version of the pipeline.
     * <p>
     * <blockquote>
     * <p>
     * A new pipeline is always assigned a version number of 1. This number increments when a pipeline is updated.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no <code>actionRoleArn</code> , or to use to assume roles for actions with an <code>actionRoleArn</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no <code>actionRoleArn</code> , or to use to assume roles for actions with an <code>actionRoleArn</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * Represents information about a stage and its definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getStages() {
        return software.amazon.jsii.Kernel.get(this, "stages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Represents information about a stage and its definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStages(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "stages", java.util.Objects.requireNonNull(value, "stages is required"));
    }

    /**
     * Represents information about a stage and its definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStages(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.codepipeline.CfnPipeline.StageDeclarationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.codepipeline.CfnPipeline.StageDeclarationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "stages", java.util.Objects.requireNonNull(value, "stages is required"));
    }

    /**
     * The S3 bucket where artifacts for the pipeline are stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getArtifactStore() {
        return software.amazon.jsii.Kernel.get(this, "artifactStore", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The S3 bucket where artifacts for the pipeline are stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifactStore(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "artifactStore", value);
    }

    /**
     * The S3 bucket where artifacts for the pipeline are stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifactStore(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.CfnPipeline.ArtifactStoreProperty value) {
        software.amazon.jsii.Kernel.set(this, "artifactStore", value);
    }

    /**
     * A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getArtifactStores() {
        return software.amazon.jsii.Kernel.get(this, "artifactStores", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifactStores(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "artifactStores", value);
    }

    /**
     * A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifactStores(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.codepipeline.CfnPipeline.ArtifactStoreMapProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.codepipeline.CfnPipeline.ArtifactStoreMapProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "artifactStores", value);
    }

    /**
     * Represents the input of a <code>DisableStageTransition</code> action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDisableInboundStageTransitions() {
        return software.amazon.jsii.Kernel.get(this, "disableInboundStageTransitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Represents the input of a <code>DisableStageTransition</code> action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisableInboundStageTransitions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "disableInboundStageTransitions", value);
    }

    /**
     * Represents the input of a <code>DisableStageTransition</code> action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisableInboundStageTransitions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.codepipeline.CfnPipeline.StageTransitionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.codepipeline.CfnPipeline.StageTransitionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "disableInboundStageTransitions", value);
    }

    /**
     * The method that the pipeline will use to handle multiple executions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExecutionMode() {
        return software.amazon.jsii.Kernel.get(this, "executionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The method that the pipeline will use to handle multiple executions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExecutionMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "executionMode", value);
    }

    /**
     * The name of the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * CodePipeline provides the following pipeline types, which differ in characteristics and price, so that you can tailor your pipeline features and cost to the needs of your applications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPipelineType() {
        return software.amazon.jsii.Kernel.get(this, "pipelineType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * CodePipeline provides the following pipeline types, which differ in characteristics and price, so that you can tailor your pipeline features and cost to the needs of your applications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPipelineType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "pipelineType", value);
    }

    /**
     * Indicates whether to rerun the CodePipeline pipeline after you update it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRestartExecutionOnUpdate() {
        return software.amazon.jsii.Kernel.get(this, "restartExecutionOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether to rerun the CodePipeline pipeline after you update it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestartExecutionOnUpdate(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "restartExecutionOnUpdate", value);
    }

    /**
     * Indicates whether to rerun the CodePipeline pipeline after you update it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestartExecutionOnUpdate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "restartExecutionOnUpdate", value);
    }

    /**
     * Specifies the tags applied to the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Specifies the tags applied to the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTriggers() {
        return software.amazon.jsii.Kernel.get(this, "triggers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggers(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "triggers", value);
    }

    /**
     * The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.codepipeline.CfnPipeline.PipelineTriggerDeclarationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.codepipeline.CfnPipeline.PipelineTriggerDeclarationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "triggers", value);
    }

    /**
     * A list that defines the pipeline variables for a pipeline resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVariables() {
        return software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list that defines the pipeline variables for a pipeline resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVariables(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "variables", value);
    }

    /**
     * A list that defines the pipeline variables for a pipeline resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVariables(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.codepipeline.CfnPipeline.VariableDeclarationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.codepipeline.CfnPipeline.VariableDeclarationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "variables", value);
    }
    /**
     * Represents information about an action declaration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * Object configuration;
     * ActionDeclarationProperty actionDeclarationProperty = ActionDeclarationProperty.builder()
     *         .actionTypeId(ActionTypeIdProperty.builder()
     *                 .category("category")
     *                 .owner("owner")
     *                 .provider("provider")
     *                 .version("version")
     *                 .build())
     *         .name("name")
     *         // the properties below are optional
     *         .commands(List.of("commands"))
     *         .configuration(configuration)
     *         .environmentVariables(List.of(EnvironmentVariableProperty.builder()
     *                 .name("name")
     *                 .value("value")
     *                 // the properties below are optional
     *                 .type("type")
     *                 .build()))
     *         .inputArtifacts(List.of(InputArtifactProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .namespace("namespace")
     *         .outputArtifacts(List.of(OutputArtifactProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .files(List.of("files"))
     *                 .build()))
     *         .outputVariables(List.of("outputVariables"))
     *         .region("region")
     *         .roleArn("roleArn")
     *         .runOrder(123)
     *         .timeoutInMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.ActionDeclarationProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionDeclarationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionDeclarationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the action type and the provider of the action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-actiontypeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-actiontypeid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getActionTypeId();

        /**
         * The action declaration's name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The shell commands to run with your compute action in CodePipeline.
         * <p>
         * All commands are supported except multi-line formats. While CodeBuild logs and permissions are used, you do not need to create any resources in CodeBuild.
         * <p>
         * <blockquote>
         * <p>
         * Using compute time for this action will incur separate charges in AWS CodeBuild .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-commands">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-commands</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommands() {
            return null;
        }

        /**
         * The action's configuration.
         * <p>
         * These are key-value pairs that specify input values for an action. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements">Action Structure Requirements in CodePipeline</a> . For the list of configuration properties for the AWS CloudFormation action type in CodePipeline, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-action-reference.html">Configuration Properties Reference</a> in the <em>AWS CloudFormation User Guide</em> . For template snippets with examples, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-parameter-override-functions.html">Using Parameter Override Functions with CodePipeline Pipelines</a> in the <em>AWS CloudFormation User Guide</em> .
         * <p>
         * The values can be represented in either JSON or YAML format. For example, the JSON configuration item format is as follows:
         * <p>
         * <em>JSON:</em>
         * <p>
         * <code>"Configuration" : { Key : Value },</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
            return null;
        }

        /**
         * The environment variables for the action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-environmentvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-environmentvariables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnvironmentVariables() {
            return null;
        }

        /**
         * The name or ID of the artifact consumed by the action, such as a test or build artifact.
         * <p>
         * While the field is not a required parameter, most actions have an action configuration that requires a specified quantity of input artifacts. To refer to the action configuration specification by action provider, see the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html">Action structure reference</a> in the <em>AWS CodePipeline User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * For a CodeBuild action with multiple input artifacts, one of your input sources must be designated the PrimarySource. For more information, see the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeBuild.html">CodeBuild action reference page</a> in the <em>AWS CodePipeline User Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-inputartifacts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-inputartifacts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputArtifacts() {
            return null;
        }

        /**
         * The variable namespace associated with the action.
         * <p>
         * All variables produced as output by this action fall under this namespace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * The name or ID of the result of the action declaration, such as a test or build artifact.
         * <p>
         * While the field is not a required parameter, most actions have an action configuration that requires a specified quantity of output artifacts. To refer to the action configuration specification by action provider, see the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html">Action structure reference</a> in the <em>AWS CodePipeline User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-outputartifacts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-outputartifacts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputArtifacts() {
            return null;
        }

        /**
         * The list of variables that are to be exported from the compute action.
         * <p>
         * This is specifically CodeBuild environment variables as used for that action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-outputvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-outputvariables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOutputVariables() {
            return null;
        }

        /**
         * The action declaration's AWS Region, such as us-east-1.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * The ARN of the IAM service role that performs the declared action.
         * <p>
         * This is assumed through the roleArn for the pipeline.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * The order in which actions are run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-runorder">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-runorder</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRunOrder() {
            return null;
        }

        /**
         * A timeout duration in minutes that can be applied against the ActionType’s default timeout value specified in <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/limits.html">Quotas for AWS CodePipeline</a> . This attribute is available only to the manual approval ActionType.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-timeoutinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiondeclaration.html#cfn-codepipeline-pipeline-actiondeclaration-timeoutinminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionDeclarationProperty> {
            java.lang.Object actionTypeId;
            java.lang.String name;
            java.util.List<java.lang.String> commands;
            java.lang.Object configuration;
            java.lang.Object environmentVariables;
            java.lang.Object inputArtifacts;
            java.lang.String namespace;
            java.lang.Object outputArtifacts;
            java.util.List<java.lang.String> outputVariables;
            java.lang.String region;
            java.lang.String roleArn;
            java.lang.Number runOrder;
            java.lang.Number timeoutInMinutes;

            /**
             * Sets the value of {@link ActionDeclarationProperty#getActionTypeId}
             * @param actionTypeId Specifies the action type and the provider of the action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionTypeId(software.amazon.awscdk.IResolvable actionTypeId) {
                this.actionTypeId = actionTypeId;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getActionTypeId}
             * @param actionTypeId Specifies the action type and the provider of the action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionTypeId(software.amazon.awscdk.services.codepipeline.CfnPipeline.ActionTypeIdProperty actionTypeId) {
                this.actionTypeId = actionTypeId;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getName}
             * @param name The action declaration's name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getCommands}
             * @param commands The shell commands to run with your compute action in CodePipeline.
             *                 All commands are supported except multi-line formats. While CodeBuild logs and permissions are used, you do not need to create any resources in CodeBuild.
             *                 <p>
             *                 <blockquote>
             *                 <p>
             *                 Using compute time for this action will incur separate charges in AWS CodeBuild .
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder commands(java.util.List<java.lang.String> commands) {
                this.commands = commands;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getConfiguration}
             * @param configuration The action's configuration.
             *                      These are key-value pairs that specify input values for an action. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements">Action Structure Requirements in CodePipeline</a> . For the list of configuration properties for the AWS CloudFormation action type in CodePipeline, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-action-reference.html">Configuration Properties Reference</a> in the <em>AWS CloudFormation User Guide</em> . For template snippets with examples, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-parameter-override-functions.html">Using Parameter Override Functions with CodePipeline Pipelines</a> in the <em>AWS CloudFormation User Guide</em> .
             *                      <p>
             *                      The values can be represented in either JSON or YAML format. For example, the JSON configuration item format is as follows:
             *                      <p>
             *                      <em>JSON:</em>
             *                      <p>
             *                      <code>"Configuration" : { Key : Value },</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(java.lang.Object configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getEnvironmentVariables}
             * @param environmentVariables The environment variables for the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentVariables(software.amazon.awscdk.IResolvable environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getEnvironmentVariables}
             * @param environmentVariables The environment variables for the action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder environmentVariables(java.util.List<? extends java.lang.Object> environmentVariables) {
                this.environmentVariables = environmentVariables;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getInputArtifacts}
             * @param inputArtifacts The name or ID of the artifact consumed by the action, such as a test or build artifact.
             *                       While the field is not a required parameter, most actions have an action configuration that requires a specified quantity of input artifacts. To refer to the action configuration specification by action provider, see the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html">Action structure reference</a> in the <em>AWS CodePipeline User Guide</em> .
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       For a CodeBuild action with multiple input artifacts, one of your input sources must be designated the PrimarySource. For more information, see the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeBuild.html">CodeBuild action reference page</a> in the <em>AWS CodePipeline User Guide</em> .
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputArtifacts(software.amazon.awscdk.IResolvable inputArtifacts) {
                this.inputArtifacts = inputArtifacts;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getInputArtifacts}
             * @param inputArtifacts The name or ID of the artifact consumed by the action, such as a test or build artifact.
             *                       While the field is not a required parameter, most actions have an action configuration that requires a specified quantity of input artifacts. To refer to the action configuration specification by action provider, see the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html">Action structure reference</a> in the <em>AWS CodePipeline User Guide</em> .
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       For a CodeBuild action with multiple input artifacts, one of your input sources must be designated the PrimarySource. For more information, see the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeBuild.html">CodeBuild action reference page</a> in the <em>AWS CodePipeline User Guide</em> .
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputArtifacts(java.util.List<? extends java.lang.Object> inputArtifacts) {
                this.inputArtifacts = inputArtifacts;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getNamespace}
             * @param namespace The variable namespace associated with the action.
             *                  All variables produced as output by this action fall under this namespace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getOutputArtifacts}
             * @param outputArtifacts The name or ID of the result of the action declaration, such as a test or build artifact.
             *                        While the field is not a required parameter, most actions have an action configuration that requires a specified quantity of output artifacts. To refer to the action configuration specification by action provider, see the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html">Action structure reference</a> in the <em>AWS CodePipeline User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputArtifacts(software.amazon.awscdk.IResolvable outputArtifacts) {
                this.outputArtifacts = outputArtifacts;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getOutputArtifacts}
             * @param outputArtifacts The name or ID of the result of the action declaration, such as a test or build artifact.
             *                        While the field is not a required parameter, most actions have an action configuration that requires a specified quantity of output artifacts. To refer to the action configuration specification by action provider, see the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference.html">Action structure reference</a> in the <em>AWS CodePipeline User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputArtifacts(java.util.List<? extends java.lang.Object> outputArtifacts) {
                this.outputArtifacts = outputArtifacts;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getOutputVariables}
             * @param outputVariables The list of variables that are to be exported from the compute action.
             *                        This is specifically CodeBuild environment variables as used for that action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputVariables(java.util.List<java.lang.String> outputVariables) {
                this.outputVariables = outputVariables;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getRegion}
             * @param region The action declaration's AWS Region, such as us-east-1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getRoleArn}
             * @param roleArn The ARN of the IAM service role that performs the declared action.
             *                This is assumed through the roleArn for the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getRunOrder}
             * @param runOrder The order in which actions are run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runOrder(java.lang.Number runOrder) {
                this.runOrder = runOrder;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getTimeoutInMinutes}
             * @param timeoutInMinutes A timeout duration in minutes that can be applied against the ActionType’s default timeout value specified in <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/limits.html">Quotas for AWS CodePipeline</a> . This attribute is available only to the manual approval ActionType.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutInMinutes(java.lang.Number timeoutInMinutes) {
                this.timeoutInMinutes = timeoutInMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionDeclarationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionDeclarationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionDeclarationProperty {
            private final java.lang.Object actionTypeId;
            private final java.lang.String name;
            private final java.util.List<java.lang.String> commands;
            private final java.lang.Object configuration;
            private final java.lang.Object environmentVariables;
            private final java.lang.Object inputArtifacts;
            private final java.lang.String namespace;
            private final java.lang.Object outputArtifacts;
            private final java.util.List<java.lang.String> outputVariables;
            private final java.lang.String region;
            private final java.lang.String roleArn;
            private final java.lang.Number runOrder;
            private final java.lang.Number timeoutInMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actionTypeId = software.amazon.jsii.Kernel.get(this, "actionTypeId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.commands = software.amazon.jsii.Kernel.get(this, "commands", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.environmentVariables = software.amazon.jsii.Kernel.get(this, "environmentVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputArtifacts = software.amazon.jsii.Kernel.get(this, "inputArtifacts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputArtifacts = software.amazon.jsii.Kernel.get(this, "outputArtifacts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputVariables = software.amazon.jsii.Kernel.get(this, "outputVariables", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timeoutInMinutes = software.amazon.jsii.Kernel.get(this, "timeoutInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actionTypeId = java.util.Objects.requireNonNull(builder.actionTypeId, "actionTypeId is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.commands = builder.commands;
                this.configuration = builder.configuration;
                this.environmentVariables = builder.environmentVariables;
                this.inputArtifacts = builder.inputArtifacts;
                this.namespace = builder.namespace;
                this.outputArtifacts = builder.outputArtifacts;
                this.outputVariables = builder.outputVariables;
                this.region = builder.region;
                this.roleArn = builder.roleArn;
                this.runOrder = builder.runOrder;
                this.timeoutInMinutes = builder.timeoutInMinutes;
            }

            @Override
            public final java.lang.Object getActionTypeId() {
                return this.actionTypeId;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.List<java.lang.String> getCommands() {
                return this.commands;
            }

            @Override
            public final java.lang.Object getConfiguration() {
                return this.configuration;
            }

            @Override
            public final java.lang.Object getEnvironmentVariables() {
                return this.environmentVariables;
            }

            @Override
            public final java.lang.Object getInputArtifacts() {
                return this.inputArtifacts;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final java.lang.Object getOutputArtifacts() {
                return this.outputArtifacts;
            }

            @Override
            public final java.util.List<java.lang.String> getOutputVariables() {
                return this.outputVariables;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Number getRunOrder() {
                return this.runOrder;
            }

            @Override
            public final java.lang.Number getTimeoutInMinutes() {
                return this.timeoutInMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actionTypeId", om.valueToTree(this.getActionTypeId()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getCommands() != null) {
                    data.set("commands", om.valueToTree(this.getCommands()));
                }
                if (this.getConfiguration() != null) {
                    data.set("configuration", om.valueToTree(this.getConfiguration()));
                }
                if (this.getEnvironmentVariables() != null) {
                    data.set("environmentVariables", om.valueToTree(this.getEnvironmentVariables()));
                }
                if (this.getInputArtifacts() != null) {
                    data.set("inputArtifacts", om.valueToTree(this.getInputArtifacts()));
                }
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }
                if (this.getOutputArtifacts() != null) {
                    data.set("outputArtifacts", om.valueToTree(this.getOutputArtifacts()));
                }
                if (this.getOutputVariables() != null) {
                    data.set("outputVariables", om.valueToTree(this.getOutputVariables()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getRunOrder() != null) {
                    data.set("runOrder", om.valueToTree(this.getRunOrder()));
                }
                if (this.getTimeoutInMinutes() != null) {
                    data.set("timeoutInMinutes", om.valueToTree(this.getTimeoutInMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.ActionDeclarationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionDeclarationProperty.Jsii$Proxy that = (ActionDeclarationProperty.Jsii$Proxy) o;

                if (!actionTypeId.equals(that.actionTypeId)) return false;
                if (!name.equals(that.name)) return false;
                if (this.commands != null ? !this.commands.equals(that.commands) : that.commands != null) return false;
                if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
                if (this.environmentVariables != null ? !this.environmentVariables.equals(that.environmentVariables) : that.environmentVariables != null) return false;
                if (this.inputArtifacts != null ? !this.inputArtifacts.equals(that.inputArtifacts) : that.inputArtifacts != null) return false;
                if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
                if (this.outputArtifacts != null ? !this.outputArtifacts.equals(that.outputArtifacts) : that.outputArtifacts != null) return false;
                if (this.outputVariables != null ? !this.outputVariables.equals(that.outputVariables) : that.outputVariables != null) return false;
                if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
                return this.timeoutInMinutes != null ? this.timeoutInMinutes.equals(that.timeoutInMinutes) : that.timeoutInMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actionTypeId.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.commands != null ? this.commands.hashCode() : 0);
                result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
                result = 31 * result + (this.environmentVariables != null ? this.environmentVariables.hashCode() : 0);
                result = 31 * result + (this.inputArtifacts != null ? this.inputArtifacts.hashCode() : 0);
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                result = 31 * result + (this.outputArtifacts != null ? this.outputArtifacts.hashCode() : 0);
                result = 31 * result + (this.outputVariables != null ? this.outputVariables.hashCode() : 0);
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
                result = 31 * result + (this.timeoutInMinutes != null ? this.timeoutInMinutes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents information about an action type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * ActionTypeIdProperty actionTypeIdProperty = ActionTypeIdProperty.builder()
     *         .category("category")
     *         .owner("owner")
     *         .provider("provider")
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiontypeid.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiontypeid.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.ActionTypeIdProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionTypeIdProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionTypeIdProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A category defines what kind of action can be taken in the stage, and constrains the provider type for the action.
         * <p>
         * Valid categories are limited to one of the values below.
         * <p>
         * <ul>
         * <li><code>Source</code></li>
         * <li><code>Build</code></li>
         * <li><code>Test</code></li>
         * <li><code>Deploy</code></li>
         * <li><code>Invoke</code></li>
         * <li><code>Approval</code></li>
         * <li><code>Compute</code></li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiontypeid.html#cfn-codepipeline-pipeline-actiontypeid-category">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiontypeid.html#cfn-codepipeline-pipeline-actiontypeid-category</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCategory();

        /**
         * The creator of the action being called.
         * <p>
         * There are three valid values for the <code>Owner</code> field in the action category section within your pipeline structure: <code>AWS</code> , <code>ThirdParty</code> , and <code>Custom</code> . For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers">Valid Action Types and Providers in CodePipeline</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiontypeid.html#cfn-codepipeline-pipeline-actiontypeid-owner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiontypeid.html#cfn-codepipeline-pipeline-actiontypeid-owner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOwner();

        /**
         * The provider of the service being called by the action.
         * <p>
         * Valid providers are determined by the action category. For example, an action in the Deploy category type might have a provider of CodeDeploy, which would be specified as <code>CodeDeploy</code> . For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers">Valid Action Types and Providers in CodePipeline</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiontypeid.html#cfn-codepipeline-pipeline-actiontypeid-provider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiontypeid.html#cfn-codepipeline-pipeline-actiontypeid-provider</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProvider();

        /**
         * A string that describes the action version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiontypeid.html#cfn-codepipeline-pipeline-actiontypeid-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-actiontypeid.html#cfn-codepipeline-pipeline-actiontypeid-version</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVersion();

        /**
         * @return a {@link Builder} of {@link ActionTypeIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionTypeIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionTypeIdProperty> {
            java.lang.String category;
            java.lang.String owner;
            java.lang.String provider;
            java.lang.String version;

            /**
             * Sets the value of {@link ActionTypeIdProperty#getCategory}
             * @param category A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. This parameter is required.
             *                 Valid categories are limited to one of the values below.
             *                 <p>
             *                 <ul>
             *                 <li><code>Source</code></li>
             *                 <li><code>Build</code></li>
             *                 <li><code>Test</code></li>
             *                 <li><code>Deploy</code></li>
             *                 <li><code>Invoke</code></li>
             *                 <li><code>Approval</code></li>
             *                 <li><code>Compute</code></li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder category(java.lang.String category) {
                this.category = category;
                return this;
            }

            /**
             * Sets the value of {@link ActionTypeIdProperty#getOwner}
             * @param owner The creator of the action being called. This parameter is required.
             *              There are three valid values for the <code>Owner</code> field in the action category section within your pipeline structure: <code>AWS</code> , <code>ThirdParty</code> , and <code>Custom</code> . For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers">Valid Action Types and Providers in CodePipeline</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder owner(java.lang.String owner) {
                this.owner = owner;
                return this;
            }

            /**
             * Sets the value of {@link ActionTypeIdProperty#getProvider}
             * @param provider The provider of the service being called by the action. This parameter is required.
             *                 Valid providers are determined by the action category. For example, an action in the Deploy category type might have a provider of CodeDeploy, which would be specified as <code>CodeDeploy</code> . For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers">Valid Action Types and Providers in CodePipeline</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provider(java.lang.String provider) {
                this.provider = provider;
                return this;
            }

            /**
             * Sets the value of {@link ActionTypeIdProperty#getVersion}
             * @param version A string that describes the action version. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionTypeIdProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionTypeIdProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionTypeIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionTypeIdProperty {
            private final java.lang.String category;
            private final java.lang.String owner;
            private final java.lang.String provider;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.category = software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.owner = software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.category = java.util.Objects.requireNonNull(builder.category, "category is required");
                this.owner = java.util.Objects.requireNonNull(builder.owner, "owner is required");
                this.provider = java.util.Objects.requireNonNull(builder.provider, "provider is required");
                this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            }

            @Override
            public final java.lang.String getCategory() {
                return this.category;
            }

            @Override
            public final java.lang.String getOwner() {
                return this.owner;
            }

            @Override
            public final java.lang.String getProvider() {
                return this.provider;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("category", om.valueToTree(this.getCategory()));
                data.set("owner", om.valueToTree(this.getOwner()));
                data.set("provider", om.valueToTree(this.getProvider()));
                data.set("version", om.valueToTree(this.getVersion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.ActionTypeIdProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionTypeIdProperty.Jsii$Proxy that = (ActionTypeIdProperty.Jsii$Proxy) o;

                if (!category.equals(that.category)) return false;
                if (!owner.equals(that.owner)) return false;
                if (!provider.equals(that.provider)) return false;
                return this.version.equals(that.version);
            }

            @Override
            public final int hashCode() {
                int result = this.category.hashCode();
                result = 31 * result + (this.owner.hashCode());
                result = 31 * result + (this.provider.hashCode());
                result = 31 * result + (this.version.hashCode());
                return result;
            }
        }
    }
    /**
     * A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions.
     * <p>
     * There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
     * <p>
     * <blockquote>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * ArtifactStoreMapProperty artifactStoreMapProperty = ArtifactStoreMapProperty.builder()
     *         .artifactStore(ArtifactStoreProperty.builder()
     *                 .location("location")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .encryptionKey(EncryptionKeyProperty.builder()
     *                         .id("id")
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .region("region")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstoremap.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstoremap.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.ArtifactStoreMapProperty")
    @software.amazon.jsii.Jsii.Proxy(ArtifactStoreMapProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArtifactStoreMapProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Represents information about the S3 bucket where artifacts are stored for the pipeline.
         * <p>
         * <blockquote>
         * <p>
         * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstoremap.html#cfn-codepipeline-pipeline-artifactstoremap-artifactstore">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstoremap.html#cfn-codepipeline-pipeline-artifactstoremap-artifactstore</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getArtifactStore();

        /**
         * The action declaration's AWS Region, such as us-east-1.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstoremap.html#cfn-codepipeline-pipeline-artifactstoremap-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstoremap.html#cfn-codepipeline-pipeline-artifactstoremap-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRegion();

        /**
         * @return a {@link Builder} of {@link ArtifactStoreMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArtifactStoreMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArtifactStoreMapProperty> {
            java.lang.Object artifactStore;
            java.lang.String region;

            /**
             * Sets the value of {@link ArtifactStoreMapProperty#getArtifactStore}
             * @param artifactStore Represents information about the S3 bucket where artifacts are stored for the pipeline. This parameter is required.
             *                      <blockquote>
             *                      <p>
             *                      You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder artifactStore(software.amazon.awscdk.IResolvable artifactStore) {
                this.artifactStore = artifactStore;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactStoreMapProperty#getArtifactStore}
             * @param artifactStore Represents information about the S3 bucket where artifacts are stored for the pipeline. This parameter is required.
             *                      <blockquote>
             *                      <p>
             *                      You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder artifactStore(software.amazon.awscdk.services.codepipeline.CfnPipeline.ArtifactStoreProperty artifactStore) {
                this.artifactStore = artifactStore;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactStoreMapProperty#getRegion}
             * @param region The action declaration's AWS Region, such as us-east-1. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArtifactStoreMapProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArtifactStoreMapProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArtifactStoreMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArtifactStoreMapProperty {
            private final java.lang.Object artifactStore;
            private final java.lang.String region;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.artifactStore = software.amazon.jsii.Kernel.get(this, "artifactStore", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.artifactStore = java.util.Objects.requireNonNull(builder.artifactStore, "artifactStore is required");
                this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
            }

            @Override
            public final java.lang.Object getArtifactStore() {
                return this.artifactStore;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("artifactStore", om.valueToTree(this.getArtifactStore()));
                data.set("region", om.valueToTree(this.getRegion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.ArtifactStoreMapProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArtifactStoreMapProperty.Jsii$Proxy that = (ArtifactStoreMapProperty.Jsii$Proxy) o;

                if (!artifactStore.equals(that.artifactStore)) return false;
                return this.region.equals(that.region);
            }

            @Override
            public final int hashCode() {
                int result = this.artifactStore.hashCode();
                result = 31 * result + (this.region.hashCode());
                return result;
            }
        }
    }
    /**
     * The S3 bucket where artifacts for the pipeline are stored.
     * <p>
     * <blockquote>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * ArtifactStoreProperty artifactStoreProperty = ArtifactStoreProperty.builder()
     *         .location("location")
     *         .type("type")
     *         // the properties below are optional
     *         .encryptionKey(EncryptionKeyProperty.builder()
     *                 .id("id")
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.ArtifactStoreProperty")
    @software.amazon.jsii.Jsii.Proxy(ArtifactStoreProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArtifactStoreProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 bucket used for storing the artifacts for a pipeline.
         * <p>
         * You can specify the name of an S3 bucket but not a folder in the bucket. A folder to contain the pipeline artifacts is created for you based on the name of the pipeline. You can use any S3 bucket in the same AWS Region as the pipeline to store your pipeline artifacts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore.html#cfn-codepipeline-pipeline-artifactstore-location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore.html#cfn-codepipeline-pipeline-artifactstore-location</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocation();

        /**
         * The type of the artifact store, such as S3.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore.html#cfn-codepipeline-pipeline-artifactstore-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore.html#cfn-codepipeline-pipeline-artifactstore-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service ( AWS KMS) key.
         * <p>
         * If this is undefined, the default key for Amazon S3 is used. To see an example artifact store encryption key field, see the example structure here: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html">AWS::CodePipeline::Pipeline</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore.html#cfn-codepipeline-pipeline-artifactstore-encryptionkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore.html#cfn-codepipeline-pipeline-artifactstore-encryptionkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArtifactStoreProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArtifactStoreProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArtifactStoreProperty> {
            java.lang.String location;
            java.lang.String type;
            java.lang.Object encryptionKey;

            /**
             * Sets the value of {@link ArtifactStoreProperty#getLocation}
             * @param location The S3 bucket used for storing the artifacts for a pipeline. This parameter is required.
             *                 You can specify the name of an S3 bucket but not a folder in the bucket. A folder to contain the pipeline artifacts is created for you based on the name of the pipeline. You can use any S3 bucket in the same AWS Region as the pipeline to store your pipeline artifacts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactStoreProperty#getType}
             * @param type The type of the artifact store, such as S3. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactStoreProperty#getEncryptionKey}
             * @param encryptionKey The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service ( AWS KMS) key.
             *                      If this is undefined, the default key for Amazon S3 is used. To see an example artifact store encryption key field, see the example structure here: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html">AWS::CodePipeline::Pipeline</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKey(software.amazon.awscdk.IResolvable encryptionKey) {
                this.encryptionKey = encryptionKey;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactStoreProperty#getEncryptionKey}
             * @param encryptionKey The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service ( AWS KMS) key.
             *                      If this is undefined, the default key for Amazon S3 is used. To see an example artifact store encryption key field, see the example structure here: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html">AWS::CodePipeline::Pipeline</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKey(software.amazon.awscdk.services.codepipeline.CfnPipeline.EncryptionKeyProperty encryptionKey) {
                this.encryptionKey = encryptionKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArtifactStoreProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArtifactStoreProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArtifactStoreProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArtifactStoreProperty {
            private final java.lang.String location;
            private final java.lang.String type;
            private final java.lang.Object encryptionKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.location = java.util.Objects.requireNonNull(builder.location, "location is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.encryptionKey = builder.encryptionKey;
            }

            @Override
            public final java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getEncryptionKey() {
                return this.encryptionKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("location", om.valueToTree(this.getLocation()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getEncryptionKey() != null) {
                    data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.ArtifactStoreProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArtifactStoreProperty.Jsii$Proxy that = (ArtifactStoreProperty.Jsii$Proxy) o;

                if (!location.equals(that.location)) return false;
                if (!type.equals(that.type)) return false;
                return this.encryptionKey != null ? this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.location.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The conditions for making checks for entry to a stage.
     * <p>
     * For more information about conditions, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/stage-conditions.html">Stage conditions</a> and <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts-how-it-works-conditions.html">How do stage conditions work?</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * Object configuration;
     * BeforeEntryConditionsProperty beforeEntryConditionsProperty = BeforeEntryConditionsProperty.builder()
     *         .conditions(List.of(ConditionProperty.builder()
     *                 .result("result")
     *                 .rules(List.of(RuleDeclarationProperty.builder()
     *                         .commands(List.of("commands"))
     *                         .configuration(configuration)
     *                         .inputArtifacts(List.of(InputArtifactProperty.builder()
     *                                 .name("name")
     *                                 .build()))
     *                         .name("name")
     *                         .region("region")
     *                         .roleArn("roleArn")
     *                         .ruleTypeId(RuleTypeIdProperty.builder()
     *                                 .category("category")
     *                                 .owner("owner")
     *                                 .provider("provider")
     *                                 .version("version")
     *                                 .build())
     *                         .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-beforeentryconditions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-beforeentryconditions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.BeforeEntryConditionsProperty")
    @software.amazon.jsii.Jsii.Proxy(BeforeEntryConditionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BeforeEntryConditionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The conditions that are configured as entry conditions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-beforeentryconditions.html#cfn-codepipeline-pipeline-beforeentryconditions-conditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-beforeentryconditions.html#cfn-codepipeline-pipeline-beforeentryconditions-conditions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConditions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BeforeEntryConditionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BeforeEntryConditionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BeforeEntryConditionsProperty> {
            java.lang.Object conditions;

            /**
             * Sets the value of {@link BeforeEntryConditionsProperty#getConditions}
             * @param conditions The conditions that are configured as entry conditions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(software.amazon.awscdk.IResolvable conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Sets the value of {@link BeforeEntryConditionsProperty#getConditions}
             * @param conditions The conditions that are configured as entry conditions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(java.util.List<? extends java.lang.Object> conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BeforeEntryConditionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BeforeEntryConditionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BeforeEntryConditionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BeforeEntryConditionsProperty {
            private final java.lang.Object conditions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.conditions = builder.conditions;
            }

            @Override
            public final java.lang.Object getConditions() {
                return this.conditions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConditions() != null) {
                    data.set("conditions", om.valueToTree(this.getConditions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.BeforeEntryConditionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BeforeEntryConditionsProperty.Jsii$Proxy that = (BeforeEntryConditionsProperty.Jsii$Proxy) o;

                return this.conditions != null ? this.conditions.equals(that.conditions) : that.conditions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.conditions != null ? this.conditions.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Reserved for future use.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * BlockerDeclarationProperty blockerDeclarationProperty = BlockerDeclarationProperty.builder()
     *         .name("name")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-blockerdeclaration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-blockerdeclaration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.BlockerDeclarationProperty")
    @software.amazon.jsii.Jsii.Proxy(BlockerDeclarationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BlockerDeclarationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Reserved for future use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-blockerdeclaration.html#cfn-codepipeline-pipeline-blockerdeclaration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-blockerdeclaration.html#cfn-codepipeline-pipeline-blockerdeclaration-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Reserved for future use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-blockerdeclaration.html#cfn-codepipeline-pipeline-blockerdeclaration-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-blockerdeclaration.html#cfn-codepipeline-pipeline-blockerdeclaration-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link BlockerDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BlockerDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BlockerDeclarationProperty> {
            java.lang.String name;
            java.lang.String type;

            /**
             * Sets the value of {@link BlockerDeclarationProperty#getName}
             * @param name Reserved for future use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link BlockerDeclarationProperty#getType}
             * @param type Reserved for future use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockerDeclarationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BlockerDeclarationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BlockerDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlockerDeclarationProperty {
            private final java.lang.String name;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.BlockerDeclarationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlockerDeclarationProperty.Jsii$Proxy that = (BlockerDeclarationProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * The condition for the stage.
     * <p>
     * A condition is made up of the rules and the result for the condition. For more information about conditions, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/stage-conditions.html">Stage conditions</a> and <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts-how-it-works-conditions.html">How do stage conditions work?</a> .. For more information about rules, see the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html">AWS CodePipeline rule reference</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * Object configuration;
     * ConditionProperty conditionProperty = ConditionProperty.builder()
     *         .result("result")
     *         .rules(List.of(RuleDeclarationProperty.builder()
     *                 .commands(List.of("commands"))
     *                 .configuration(configuration)
     *                 .inputArtifacts(List.of(InputArtifactProperty.builder()
     *                         .name("name")
     *                         .build()))
     *                 .name("name")
     *                 .region("region")
     *                 .roleArn("roleArn")
     *                 .ruleTypeId(RuleTypeIdProperty.builder()
     *                         .category("category")
     *                         .owner("owner")
     *                         .provider("provider")
     *                         .version("version")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-condition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-condition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.ConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(ConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to be done when the condition is met.
         * <p>
         * For example, rolling back an execution for a failure condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-condition.html#cfn-codepipeline-pipeline-condition-result">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-condition.html#cfn-codepipeline-pipeline-condition-result</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResult() {
            return null;
        }

        /**
         * The rules that make up the condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-condition.html#cfn-codepipeline-pipeline-condition-rules">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-condition.html#cfn-codepipeline-pipeline-condition-rules</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRules() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConditionProperty> {
            java.lang.String result;
            java.lang.Object rules;

            /**
             * Sets the value of {@link ConditionProperty#getResult}
             * @param result The action to be done when the condition is met.
             *               For example, rolling back an execution for a failure condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder result(java.lang.String result) {
                this.result = result;
                return this;
            }

            /**
             * Sets the value of {@link ConditionProperty#getRules}
             * @param rules The rules that make up the condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(software.amazon.awscdk.IResolvable rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Sets the value of {@link ConditionProperty#getRules}
             * @param rules The rules that make up the condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rules(java.util.List<? extends java.lang.Object> rules) {
                this.rules = rules;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConditionProperty {
            private final java.lang.String result;
            private final java.lang.Object rules;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.result = software.amazon.jsii.Kernel.get(this, "result", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rules = software.amazon.jsii.Kernel.get(this, "rules", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.result = builder.result;
                this.rules = builder.rules;
            }

            @Override
            public final java.lang.String getResult() {
                return this.result;
            }

            @Override
            public final java.lang.Object getRules() {
                return this.rules;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getResult() != null) {
                    data.set("result", om.valueToTree(this.getResult()));
                }
                if (this.getRules() != null) {
                    data.set("rules", om.valueToTree(this.getRules()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.ConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConditionProperty.Jsii$Proxy that = (ConditionProperty.Jsii$Proxy) o;

                if (this.result != null ? !this.result.equals(that.result) : that.result != null) return false;
                return this.rules != null ? this.rules.equals(that.rules) : that.rules == null;
            }

            @Override
            public final int hashCode() {
                int result = this.result != null ? this.result.hashCode() : 0;
                result = 31 * result + (this.rules != null ? this.rules.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents information about the key used to encrypt data in the artifact store, such as an AWS Key Management Service ( AWS KMS) key.
     * <p>
     * <code>EncryptionKey</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore.html">ArtifactStore</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * EncryptionKeyProperty encryptionKeyProperty = EncryptionKeyProperty.builder()
     *         .id("id")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-encryptionkey.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-encryptionkey.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.EncryptionKeyProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionKeyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionKeyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID used to identify the key.
         * <p>
         * For an AWS KMS key, you can use the key ID, the key ARN, or the alias ARN.
         * <p>
         * <blockquote>
         * <p>
         * Aliases are recognized only in the account that created the AWS KMS key. For cross-account actions, you can only use the key ID or key ARN to identify the key. Cross-account actions involve using the role from the other account (AccountB), so specifying the key ID will use the key from the other account (AccountB).
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-encryptionkey.html#cfn-codepipeline-pipeline-encryptionkey-id">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-encryptionkey.html#cfn-codepipeline-pipeline-encryptionkey-id</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The type of encryption key, such as an AWS KMS key.
         * <p>
         * When creating or updating a pipeline, the value must be set to 'KMS'.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-encryptionkey.html#cfn-codepipeline-pipeline-encryptionkey-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-encryptionkey.html#cfn-codepipeline-pipeline-encryptionkey-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link EncryptionKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionKeyProperty> {
            java.lang.String id;
            java.lang.String type;

            /**
             * Sets the value of {@link EncryptionKeyProperty#getId}
             * @param id The ID used to identify the key. This parameter is required.
             *           For an AWS KMS key, you can use the key ID, the key ARN, or the alias ARN.
             *           <p>
             *           <blockquote>
             *           <p>
             *           Aliases are recognized only in the account that created the AWS KMS key. For cross-account actions, you can only use the key ID or key ARN to identify the key. Cross-account actions involve using the role from the other account (AccountB), so specifying the key ID will use the key from the other account (AccountB).
             *           <p>
             *           </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionKeyProperty#getType}
             * @param type The type of encryption key, such as an AWS KMS key. This parameter is required.
             *             When creating or updating a pipeline, the value must be set to 'KMS'.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionKeyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionKeyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionKeyProperty {
            private final java.lang.String id;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.EncryptionKeyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionKeyProperty.Jsii$Proxy that = (EncryptionKeyProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * The environment variables for the action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * EnvironmentVariableProperty environmentVariableProperty = EnvironmentVariableProperty.builder()
     *         .name("name")
     *         .value("value")
     *         // the properties below are optional
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-environmentvariable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-environmentvariable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.EnvironmentVariableProperty")
    @software.amazon.jsii.Jsii.Proxy(EnvironmentVariableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EnvironmentVariableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The environment variable name in the key-value pair.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-environmentvariable.html#cfn-codepipeline-pipeline-environmentvariable-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-environmentvariable.html#cfn-codepipeline-pipeline-environmentvariable-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The environment variable value in the key-value pair.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-environmentvariable.html#cfn-codepipeline-pipeline-environmentvariable-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-environmentvariable.html#cfn-codepipeline-pipeline-environmentvariable-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * Specifies the type of use for the environment variable value.
         * <p>
         * The value can be either <code>PLAINTEXT</code> or <code>SECRETS_MANAGER</code> . If the value is <code>SECRETS_MANAGER</code> , provide the Secrets reference in the EnvironmentVariable value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-environmentvariable.html#cfn-codepipeline-pipeline-environmentvariable-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-environmentvariable.html#cfn-codepipeline-pipeline-environmentvariable-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EnvironmentVariableProperty> {
            java.lang.String name;
            java.lang.String value;
            java.lang.String type;

            /**
             * Sets the value of {@link EnvironmentVariableProperty#getName}
             * @param name The environment variable name in the key-value pair. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentVariableProperty#getValue}
             * @param value The environment variable value in the key-value pair. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Sets the value of {@link EnvironmentVariableProperty#getType}
             * @param type Specifies the type of use for the environment variable value.
             *             The value can be either <code>PLAINTEXT</code> or <code>SECRETS_MANAGER</code> . If the value is <code>SECRETS_MANAGER</code> , provide the Secrets reference in the EnvironmentVariable value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EnvironmentVariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EnvironmentVariableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EnvironmentVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentVariableProperty {
            private final java.lang.String name;
            private final java.lang.String value;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("value", om.valueToTree(this.getValue()));
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.EnvironmentVariableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EnvironmentVariableProperty.Jsii$Proxy that = (EnvironmentVariableProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!value.equals(that.value)) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.value.hashCode());
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration that specifies the result, such as rollback, to occur upon stage failure.
     * <p>
     * For more information about conditions, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/stage-conditions.html">Stage conditions</a> and <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts-how-it-works-conditions.html">How do stage conditions work?</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * Object configuration;
     * FailureConditionsProperty failureConditionsProperty = FailureConditionsProperty.builder()
     *         .conditions(List.of(ConditionProperty.builder()
     *                 .result("result")
     *                 .rules(List.of(RuleDeclarationProperty.builder()
     *                         .commands(List.of("commands"))
     *                         .configuration(configuration)
     *                         .inputArtifacts(List.of(InputArtifactProperty.builder()
     *                                 .name("name")
     *                                 .build()))
     *                         .name("name")
     *                         .region("region")
     *                         .roleArn("roleArn")
     *                         .ruleTypeId(RuleTypeIdProperty.builder()
     *                                 .category("category")
     *                                 .owner("owner")
     *                                 .provider("provider")
     *                                 .version("version")
     *                                 .build())
     *                         .build()))
     *                 .build()))
     *         .result("result")
     *         .retryConfiguration(RetryConfigurationProperty.builder()
     *                 .retryMode("retryMode")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-failureconditions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-failureconditions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.FailureConditionsProperty")
    @software.amazon.jsii.Jsii.Proxy(FailureConditionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FailureConditionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The conditions that are configured as failure conditions.
         * <p>
         * For more information about conditions, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/stage-conditions.html">Stage conditions</a> and <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts-how-it-works-conditions.html">How do stage conditions work?</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-failureconditions.html#cfn-codepipeline-pipeline-failureconditions-conditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-failureconditions.html#cfn-codepipeline-pipeline-failureconditions-conditions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConditions() {
            return null;
        }

        /**
         * The specified result for when the failure conditions are met, such as rolling back the stage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-failureconditions.html#cfn-codepipeline-pipeline-failureconditions-result">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-failureconditions.html#cfn-codepipeline-pipeline-failureconditions-result</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResult() {
            return null;
        }

        /**
         * The retry configuration specifies automatic retry for a failed stage, along with the configured retry mode.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-failureconditions.html#cfn-codepipeline-pipeline-failureconditions-retryconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-failureconditions.html#cfn-codepipeline-pipeline-failureconditions-retryconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetryConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FailureConditionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FailureConditionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FailureConditionsProperty> {
            java.lang.Object conditions;
            java.lang.String result;
            java.lang.Object retryConfiguration;

            /**
             * Sets the value of {@link FailureConditionsProperty#getConditions}
             * @param conditions The conditions that are configured as failure conditions.
             *                   For more information about conditions, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/stage-conditions.html">Stage conditions</a> and <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts-how-it-works-conditions.html">How do stage conditions work?</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(software.amazon.awscdk.IResolvable conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Sets the value of {@link FailureConditionsProperty#getConditions}
             * @param conditions The conditions that are configured as failure conditions.
             *                   For more information about conditions, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/stage-conditions.html">Stage conditions</a> and <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts-how-it-works-conditions.html">How do stage conditions work?</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(java.util.List<? extends java.lang.Object> conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Sets the value of {@link FailureConditionsProperty#getResult}
             * @param result The specified result for when the failure conditions are met, such as rolling back the stage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder result(java.lang.String result) {
                this.result = result;
                return this;
            }

            /**
             * Sets the value of {@link FailureConditionsProperty#getRetryConfiguration}
             * @param retryConfiguration The retry configuration specifies automatic retry for a failed stage, along with the configured retry mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryConfiguration(software.amazon.awscdk.IResolvable retryConfiguration) {
                this.retryConfiguration = retryConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link FailureConditionsProperty#getRetryConfiguration}
             * @param retryConfiguration The retry configuration specifies automatic retry for a failed stage, along with the configured retry mode.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryConfiguration(software.amazon.awscdk.services.codepipeline.CfnPipeline.RetryConfigurationProperty retryConfiguration) {
                this.retryConfiguration = retryConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FailureConditionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FailureConditionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FailureConditionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FailureConditionsProperty {
            private final java.lang.Object conditions;
            private final java.lang.String result;
            private final java.lang.Object retryConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.result = software.amazon.jsii.Kernel.get(this, "result", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.retryConfiguration = software.amazon.jsii.Kernel.get(this, "retryConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.conditions = builder.conditions;
                this.result = builder.result;
                this.retryConfiguration = builder.retryConfiguration;
            }

            @Override
            public final java.lang.Object getConditions() {
                return this.conditions;
            }

            @Override
            public final java.lang.String getResult() {
                return this.result;
            }

            @Override
            public final java.lang.Object getRetryConfiguration() {
                return this.retryConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConditions() != null) {
                    data.set("conditions", om.valueToTree(this.getConditions()));
                }
                if (this.getResult() != null) {
                    data.set("result", om.valueToTree(this.getResult()));
                }
                if (this.getRetryConfiguration() != null) {
                    data.set("retryConfiguration", om.valueToTree(this.getRetryConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.FailureConditionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FailureConditionsProperty.Jsii$Proxy that = (FailureConditionsProperty.Jsii$Proxy) o;

                if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) return false;
                if (this.result != null ? !this.result.equals(that.result) : that.result != null) return false;
                return this.retryConfiguration != null ? this.retryConfiguration.equals(that.retryConfiguration) : that.retryConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.conditions != null ? this.conditions.hashCode() : 0;
                result = 31 * result + (this.result != null ? this.result.hashCode() : 0);
                result = 31 * result + (this.retryConfiguration != null ? this.retryConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Git repository branches specified as filter criteria to start the pipeline.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * GitBranchFilterCriteriaProperty gitBranchFilterCriteriaProperty = GitBranchFilterCriteriaProperty.builder()
     *         .excludes(List.of("excludes"))
     *         .includes(List.of("includes"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitbranchfiltercriteria.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitbranchfiltercriteria.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.GitBranchFilterCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(GitBranchFilterCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GitBranchFilterCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitbranchfiltercriteria.html#cfn-codepipeline-pipeline-gitbranchfiltercriteria-excludes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitbranchfiltercriteria.html#cfn-codepipeline-pipeline-gitbranchfiltercriteria-excludes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludes() {
            return null;
        }

        /**
         * The list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitbranchfiltercriteria.html#cfn-codepipeline-pipeline-gitbranchfiltercriteria-includes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitbranchfiltercriteria.html#cfn-codepipeline-pipeline-gitbranchfiltercriteria-includes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GitBranchFilterCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GitBranchFilterCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GitBranchFilterCriteriaProperty> {
            java.util.List<java.lang.String> excludes;
            java.util.List<java.lang.String> includes;

            /**
             * Sets the value of {@link GitBranchFilterCriteriaProperty#getExcludes}
             * @param excludes The list of patterns of Git branches that, when a commit is pushed, are to be excluded from starting the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludes(java.util.List<java.lang.String> excludes) {
                this.excludes = excludes;
                return this;
            }

            /**
             * Sets the value of {@link GitBranchFilterCriteriaProperty#getIncludes}
             * @param includes The list of patterns of Git branches that, when a commit is pushed, are to be included as criteria that starts the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includes(java.util.List<java.lang.String> includes) {
                this.includes = includes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GitBranchFilterCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GitBranchFilterCriteriaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GitBranchFilterCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitBranchFilterCriteriaProperty {
            private final java.util.List<java.lang.String> excludes;
            private final java.util.List<java.lang.String> includes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.excludes = software.amazon.jsii.Kernel.get(this, "excludes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.includes = software.amazon.jsii.Kernel.get(this, "includes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.excludes = builder.excludes;
                this.includes = builder.includes;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludes() {
                return this.excludes;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludes() {
                return this.includes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExcludes() != null) {
                    data.set("excludes", om.valueToTree(this.getExcludes()));
                }
                if (this.getIncludes() != null) {
                    data.set("includes", om.valueToTree(this.getIncludes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.GitBranchFilterCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GitBranchFilterCriteriaProperty.Jsii$Proxy that = (GitBranchFilterCriteriaProperty.Jsii$Proxy) o;

                if (this.excludes != null ? !this.excludes.equals(that.excludes) : that.excludes != null) return false;
                return this.includes != null ? this.includes.equals(that.includes) : that.includes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.excludes != null ? this.excludes.hashCode() : 0;
                result = 31 * result + (this.includes != null ? this.includes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A type of trigger configuration for Git-based source actions.
     * <p>
     * <blockquote>
     * <p>
     * You can specify the Git configuration trigger type for all third-party Git-based source actions that are supported by the <code>CodeStarSourceConnection</code> action type.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * GitConfigurationProperty gitConfigurationProperty = GitConfigurationProperty.builder()
     *         .sourceActionName("sourceActionName")
     *         // the properties below are optional
     *         .pullRequest(List.of(GitPullRequestFilterProperty.builder()
     *                 .branches(GitBranchFilterCriteriaProperty.builder()
     *                         .excludes(List.of("excludes"))
     *                         .includes(List.of("includes"))
     *                         .build())
     *                 .events(List.of("events"))
     *                 .filePaths(GitFilePathFilterCriteriaProperty.builder()
     *                         .excludes(List.of("excludes"))
     *                         .includes(List.of("includes"))
     *                         .build())
     *                 .build()))
     *         .push(List.of(GitPushFilterProperty.builder()
     *                 .branches(GitBranchFilterCriteriaProperty.builder()
     *                         .excludes(List.of("excludes"))
     *                         .includes(List.of("includes"))
     *                         .build())
     *                 .filePaths(GitFilePathFilterCriteriaProperty.builder()
     *                         .excludes(List.of("excludes"))
     *                         .includes(List.of("includes"))
     *                         .build())
     *                 .tags(GitTagFilterCriteriaProperty.builder()
     *                         .excludes(List.of("excludes"))
     *                         .includes(List.of("includes"))
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.GitConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(GitConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GitConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the pipeline source action where the trigger configuration, such as Git tags, is specified.
         * <p>
         * The trigger configuration will start the pipeline upon the specified change only.
         * <p>
         * <blockquote>
         * <p>
         * You can only specify one trigger configuration per source action.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitconfiguration.html#cfn-codepipeline-pipeline-gitconfiguration-sourceactionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitconfiguration.html#cfn-codepipeline-pipeline-gitconfiguration-sourceactionname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceActionName();

        /**
         * The field where the repository event that will start the pipeline is specified as pull requests.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitconfiguration.html#cfn-codepipeline-pipeline-gitconfiguration-pullrequest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitconfiguration.html#cfn-codepipeline-pipeline-gitconfiguration-pullrequest</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPullRequest() {
            return null;
        }

        /**
         * The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitconfiguration.html#cfn-codepipeline-pipeline-gitconfiguration-push">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitconfiguration.html#cfn-codepipeline-pipeline-gitconfiguration-push</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPush() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GitConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GitConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GitConfigurationProperty> {
            java.lang.String sourceActionName;
            java.lang.Object pullRequest;
            java.lang.Object push;

            /**
             * Sets the value of {@link GitConfigurationProperty#getSourceActionName}
             * @param sourceActionName The name of the pipeline source action where the trigger configuration, such as Git tags, is specified. This parameter is required.
             *                         The trigger configuration will start the pipeline upon the specified change only.
             *                         <p>
             *                         <blockquote>
             *                         <p>
             *                         You can only specify one trigger configuration per source action.
             *                         <p>
             *                         </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceActionName(java.lang.String sourceActionName) {
                this.sourceActionName = sourceActionName;
                return this;
            }

            /**
             * Sets the value of {@link GitConfigurationProperty#getPullRequest}
             * @param pullRequest The field where the repository event that will start the pipeline is specified as pull requests.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pullRequest(software.amazon.awscdk.IResolvable pullRequest) {
                this.pullRequest = pullRequest;
                return this;
            }

            /**
             * Sets the value of {@link GitConfigurationProperty#getPullRequest}
             * @param pullRequest The field where the repository event that will start the pipeline is specified as pull requests.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pullRequest(java.util.List<? extends java.lang.Object> pullRequest) {
                this.pullRequest = pullRequest;
                return this;
            }

            /**
             * Sets the value of {@link GitConfigurationProperty#getPush}
             * @param push The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder push(software.amazon.awscdk.IResolvable push) {
                this.push = push;
                return this;
            }

            /**
             * Sets the value of {@link GitConfigurationProperty#getPush}
             * @param push The field where the repository event that will start the pipeline, such as pushing Git tags, is specified with details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder push(java.util.List<? extends java.lang.Object> push) {
                this.push = push;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GitConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GitConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GitConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitConfigurationProperty {
            private final java.lang.String sourceActionName;
            private final java.lang.Object pullRequest;
            private final java.lang.Object push;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceActionName = software.amazon.jsii.Kernel.get(this, "sourceActionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pullRequest = software.amazon.jsii.Kernel.get(this, "pullRequest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.push = software.amazon.jsii.Kernel.get(this, "push", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceActionName = java.util.Objects.requireNonNull(builder.sourceActionName, "sourceActionName is required");
                this.pullRequest = builder.pullRequest;
                this.push = builder.push;
            }

            @Override
            public final java.lang.String getSourceActionName() {
                return this.sourceActionName;
            }

            @Override
            public final java.lang.Object getPullRequest() {
                return this.pullRequest;
            }

            @Override
            public final java.lang.Object getPush() {
                return this.push;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceActionName", om.valueToTree(this.getSourceActionName()));
                if (this.getPullRequest() != null) {
                    data.set("pullRequest", om.valueToTree(this.getPullRequest()));
                }
                if (this.getPush() != null) {
                    data.set("push", om.valueToTree(this.getPush()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.GitConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GitConfigurationProperty.Jsii$Proxy that = (GitConfigurationProperty.Jsii$Proxy) o;

                if (!sourceActionName.equals(that.sourceActionName)) return false;
                if (this.pullRequest != null ? !this.pullRequest.equals(that.pullRequest) : that.pullRequest != null) return false;
                return this.push != null ? this.push.equals(that.push) : that.push == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceActionName.hashCode();
                result = 31 * result + (this.pullRequest != null ? this.pullRequest.hashCode() : 0);
                result = 31 * result + (this.push != null ? this.push.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Git repository file paths specified as filter criteria to start the pipeline.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * GitFilePathFilterCriteriaProperty gitFilePathFilterCriteriaProperty = GitFilePathFilterCriteriaProperty.builder()
     *         .excludes(List.of("excludes"))
     *         .includes(List.of("includes"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitfilepathfiltercriteria.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitfilepathfiltercriteria.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.GitFilePathFilterCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(GitFilePathFilterCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GitFilePathFilterCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitfilepathfiltercriteria.html#cfn-codepipeline-pipeline-gitfilepathfiltercriteria-excludes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitfilepathfiltercriteria.html#cfn-codepipeline-pipeline-gitfilepathfiltercriteria-excludes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludes() {
            return null;
        }

        /**
         * The list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitfilepathfiltercriteria.html#cfn-codepipeline-pipeline-gitfilepathfiltercriteria-includes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitfilepathfiltercriteria.html#cfn-codepipeline-pipeline-gitfilepathfiltercriteria-includes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GitFilePathFilterCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GitFilePathFilterCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GitFilePathFilterCriteriaProperty> {
            java.util.List<java.lang.String> excludes;
            java.util.List<java.lang.String> includes;

            /**
             * Sets the value of {@link GitFilePathFilterCriteriaProperty#getExcludes}
             * @param excludes The list of patterns of Git repository file paths that, when a commit is pushed, are to be excluded from starting the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludes(java.util.List<java.lang.String> excludes) {
                this.excludes = excludes;
                return this;
            }

            /**
             * Sets the value of {@link GitFilePathFilterCriteriaProperty#getIncludes}
             * @param includes The list of patterns of Git repository file paths that, when a commit is pushed, are to be included as criteria that starts the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includes(java.util.List<java.lang.String> includes) {
                this.includes = includes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GitFilePathFilterCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GitFilePathFilterCriteriaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GitFilePathFilterCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitFilePathFilterCriteriaProperty {
            private final java.util.List<java.lang.String> excludes;
            private final java.util.List<java.lang.String> includes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.excludes = software.amazon.jsii.Kernel.get(this, "excludes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.includes = software.amazon.jsii.Kernel.get(this, "includes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.excludes = builder.excludes;
                this.includes = builder.includes;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludes() {
                return this.excludes;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludes() {
                return this.includes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExcludes() != null) {
                    data.set("excludes", om.valueToTree(this.getExcludes()));
                }
                if (this.getIncludes() != null) {
                    data.set("includes", om.valueToTree(this.getIncludes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.GitFilePathFilterCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GitFilePathFilterCriteriaProperty.Jsii$Proxy that = (GitFilePathFilterCriteriaProperty.Jsii$Proxy) o;

                if (this.excludes != null ? !this.excludes.equals(that.excludes) : that.excludes != null) return false;
                return this.includes != null ? this.includes.equals(that.includes) : that.includes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.excludes != null ? this.excludes.hashCode() : 0;
                result = 31 * result + (this.includes != null ? this.includes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The event criteria for the pull request trigger configuration, such as the lists of branches or file paths to include and exclude.
     * <p>
     * The following are valid values for the events for this filter:
     * <p>
     * <ul>
     * <li>CLOSED</li>
     * <li>OPEN</li>
     * <li>UPDATED</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * GitPullRequestFilterProperty gitPullRequestFilterProperty = GitPullRequestFilterProperty.builder()
     *         .branches(GitBranchFilterCriteriaProperty.builder()
     *                 .excludes(List.of("excludes"))
     *                 .includes(List.of("includes"))
     *                 .build())
     *         .events(List.of("events"))
     *         .filePaths(GitFilePathFilterCriteriaProperty.builder()
     *                 .excludes(List.of("excludes"))
     *                 .includes(List.of("includes"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitpullrequestfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitpullrequestfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.GitPullRequestFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(GitPullRequestFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GitPullRequestFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The field that specifies to filter on branches for the pull request trigger configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitpullrequestfilter.html#cfn-codepipeline-pipeline-gitpullrequestfilter-branches">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitpullrequestfilter.html#cfn-codepipeline-pipeline-gitpullrequestfilter-branches</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBranches() {
            return null;
        }

        /**
         * The field that specifies which pull request events to filter on (OPEN, UPDATED, CLOSED) for the trigger configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitpullrequestfilter.html#cfn-codepipeline-pipeline-gitpullrequestfilter-events">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitpullrequestfilter.html#cfn-codepipeline-pipeline-gitpullrequestfilter-events</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEvents() {
            return null;
        }

        /**
         * The field that specifies to filter on file paths for the pull request trigger configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitpullrequestfilter.html#cfn-codepipeline-pipeline-gitpullrequestfilter-filepaths">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitpullrequestfilter.html#cfn-codepipeline-pipeline-gitpullrequestfilter-filepaths</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilePaths() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GitPullRequestFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GitPullRequestFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GitPullRequestFilterProperty> {
            java.lang.Object branches;
            java.util.List<java.lang.String> events;
            java.lang.Object filePaths;

            /**
             * Sets the value of {@link GitPullRequestFilterProperty#getBranches}
             * @param branches The field that specifies to filter on branches for the pull request trigger configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder branches(software.amazon.awscdk.IResolvable branches) {
                this.branches = branches;
                return this;
            }

            /**
             * Sets the value of {@link GitPullRequestFilterProperty#getBranches}
             * @param branches The field that specifies to filter on branches for the pull request trigger configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder branches(software.amazon.awscdk.services.codepipeline.CfnPipeline.GitBranchFilterCriteriaProperty branches) {
                this.branches = branches;
                return this;
            }

            /**
             * Sets the value of {@link GitPullRequestFilterProperty#getEvents}
             * @param events The field that specifies which pull request events to filter on (OPEN, UPDATED, CLOSED) for the trigger configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder events(java.util.List<java.lang.String> events) {
                this.events = events;
                return this;
            }

            /**
             * Sets the value of {@link GitPullRequestFilterProperty#getFilePaths}
             * @param filePaths The field that specifies to filter on file paths for the pull request trigger configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filePaths(software.amazon.awscdk.IResolvable filePaths) {
                this.filePaths = filePaths;
                return this;
            }

            /**
             * Sets the value of {@link GitPullRequestFilterProperty#getFilePaths}
             * @param filePaths The field that specifies to filter on file paths for the pull request trigger configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filePaths(software.amazon.awscdk.services.codepipeline.CfnPipeline.GitFilePathFilterCriteriaProperty filePaths) {
                this.filePaths = filePaths;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GitPullRequestFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GitPullRequestFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GitPullRequestFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitPullRequestFilterProperty {
            private final java.lang.Object branches;
            private final java.util.List<java.lang.String> events;
            private final java.lang.Object filePaths;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.branches = software.amazon.jsii.Kernel.get(this, "branches", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.events = software.amazon.jsii.Kernel.get(this, "events", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.filePaths = software.amazon.jsii.Kernel.get(this, "filePaths", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.branches = builder.branches;
                this.events = builder.events;
                this.filePaths = builder.filePaths;
            }

            @Override
            public final java.lang.Object getBranches() {
                return this.branches;
            }

            @Override
            public final java.util.List<java.lang.String> getEvents() {
                return this.events;
            }

            @Override
            public final java.lang.Object getFilePaths() {
                return this.filePaths;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBranches() != null) {
                    data.set("branches", om.valueToTree(this.getBranches()));
                }
                if (this.getEvents() != null) {
                    data.set("events", om.valueToTree(this.getEvents()));
                }
                if (this.getFilePaths() != null) {
                    data.set("filePaths", om.valueToTree(this.getFilePaths()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.GitPullRequestFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GitPullRequestFilterProperty.Jsii$Proxy that = (GitPullRequestFilterProperty.Jsii$Proxy) o;

                if (this.branches != null ? !this.branches.equals(that.branches) : that.branches != null) return false;
                if (this.events != null ? !this.events.equals(that.events) : that.events != null) return false;
                return this.filePaths != null ? this.filePaths.equals(that.filePaths) : that.filePaths == null;
            }

            @Override
            public final int hashCode() {
                int result = this.branches != null ? this.branches.hashCode() : 0;
                result = 31 * result + (this.events != null ? this.events.hashCode() : 0);
                result = 31 * result + (this.filePaths != null ? this.filePaths.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The event criteria that specify when a specified repository event will start the pipeline for the specified trigger configuration, such as the lists of Git tags to include and exclude.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * GitPushFilterProperty gitPushFilterProperty = GitPushFilterProperty.builder()
     *         .branches(GitBranchFilterCriteriaProperty.builder()
     *                 .excludes(List.of("excludes"))
     *                 .includes(List.of("includes"))
     *                 .build())
     *         .filePaths(GitFilePathFilterCriteriaProperty.builder()
     *                 .excludes(List.of("excludes"))
     *                 .includes(List.of("includes"))
     *                 .build())
     *         .tags(GitTagFilterCriteriaProperty.builder()
     *                 .excludes(List.of("excludes"))
     *                 .includes(List.of("includes"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitpushfilter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitpushfilter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.GitPushFilterProperty")
    @software.amazon.jsii.Jsii.Proxy(GitPushFilterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GitPushFilterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The field that specifies to filter on branches for the push trigger configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitpushfilter.html#cfn-codepipeline-pipeline-gitpushfilter-branches">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitpushfilter.html#cfn-codepipeline-pipeline-gitpushfilter-branches</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBranches() {
            return null;
        }

        /**
         * The field that specifies to filter on file paths for the push trigger configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitpushfilter.html#cfn-codepipeline-pipeline-gitpushfilter-filepaths">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitpushfilter.html#cfn-codepipeline-pipeline-gitpushfilter-filepaths</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFilePaths() {
            return null;
        }

        /**
         * The field that contains the details for the Git tags trigger configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitpushfilter.html#cfn-codepipeline-pipeline-gitpushfilter-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gitpushfilter.html#cfn-codepipeline-pipeline-gitpushfilter-tags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.CfnPipeline.GitTagFilterCriteriaProperty getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GitPushFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GitPushFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GitPushFilterProperty> {
            java.lang.Object branches;
            java.lang.Object filePaths;
            software.amazon.awscdk.services.codepipeline.CfnPipeline.GitTagFilterCriteriaProperty tags;

            /**
             * Sets the value of {@link GitPushFilterProperty#getBranches}
             * @param branches The field that specifies to filter on branches for the push trigger configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder branches(software.amazon.awscdk.IResolvable branches) {
                this.branches = branches;
                return this;
            }

            /**
             * Sets the value of {@link GitPushFilterProperty#getBranches}
             * @param branches The field that specifies to filter on branches for the push trigger configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder branches(software.amazon.awscdk.services.codepipeline.CfnPipeline.GitBranchFilterCriteriaProperty branches) {
                this.branches = branches;
                return this;
            }

            /**
             * Sets the value of {@link GitPushFilterProperty#getFilePaths}
             * @param filePaths The field that specifies to filter on file paths for the push trigger configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filePaths(software.amazon.awscdk.IResolvable filePaths) {
                this.filePaths = filePaths;
                return this;
            }

            /**
             * Sets the value of {@link GitPushFilterProperty#getFilePaths}
             * @param filePaths The field that specifies to filter on file paths for the push trigger configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filePaths(software.amazon.awscdk.services.codepipeline.CfnPipeline.GitFilePathFilterCriteriaProperty filePaths) {
                this.filePaths = filePaths;
                return this;
            }

            /**
             * Sets the value of {@link GitPushFilterProperty#getTags}
             * @param tags The field that contains the details for the Git tags trigger configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tags(software.amazon.awscdk.services.codepipeline.CfnPipeline.GitTagFilterCriteriaProperty tags) {
                this.tags = tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GitPushFilterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GitPushFilterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GitPushFilterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitPushFilterProperty {
            private final java.lang.Object branches;
            private final java.lang.Object filePaths;
            private final software.amazon.awscdk.services.codepipeline.CfnPipeline.GitTagFilterCriteriaProperty tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.branches = software.amazon.jsii.Kernel.get(this, "branches", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filePaths = software.amazon.jsii.Kernel.get(this, "filePaths", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.CfnPipeline.GitTagFilterCriteriaProperty.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.branches = builder.branches;
                this.filePaths = builder.filePaths;
                this.tags = builder.tags;
            }

            @Override
            public final java.lang.Object getBranches() {
                return this.branches;
            }

            @Override
            public final java.lang.Object getFilePaths() {
                return this.filePaths;
            }

            @Override
            public final software.amazon.awscdk.services.codepipeline.CfnPipeline.GitTagFilterCriteriaProperty getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBranches() != null) {
                    data.set("branches", om.valueToTree(this.getBranches()));
                }
                if (this.getFilePaths() != null) {
                    data.set("filePaths", om.valueToTree(this.getFilePaths()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.GitPushFilterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GitPushFilterProperty.Jsii$Proxy that = (GitPushFilterProperty.Jsii$Proxy) o;

                if (this.branches != null ? !this.branches.equals(that.branches) : that.branches != null) return false;
                if (this.filePaths != null ? !this.filePaths.equals(that.filePaths) : that.filePaths != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.branches != null ? this.branches.hashCode() : 0;
                result = 31 * result + (this.filePaths != null ? this.filePaths.hashCode() : 0);
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Git tags specified as filter criteria for whether a Git tag repository event will start the pipeline.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * GitTagFilterCriteriaProperty gitTagFilterCriteriaProperty = GitTagFilterCriteriaProperty.builder()
     *         .excludes(List.of("excludes"))
     *         .includes(List.of("includes"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gittagfiltercriteria.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gittagfiltercriteria.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.GitTagFilterCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(GitTagFilterCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GitTagFilterCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gittagfiltercriteria.html#cfn-codepipeline-pipeline-gittagfiltercriteria-excludes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gittagfiltercriteria.html#cfn-codepipeline-pipeline-gittagfiltercriteria-excludes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludes() {
            return null;
        }

        /**
         * The list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gittagfiltercriteria.html#cfn-codepipeline-pipeline-gittagfiltercriteria-includes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-gittagfiltercriteria.html#cfn-codepipeline-pipeline-gittagfiltercriteria-includes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIncludes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GitTagFilterCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GitTagFilterCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GitTagFilterCriteriaProperty> {
            java.util.List<java.lang.String> excludes;
            java.util.List<java.lang.String> includes;

            /**
             * Sets the value of {@link GitTagFilterCriteriaProperty#getExcludes}
             * @param excludes The list of patterns of Git tags that, when pushed, are to be excluded from starting the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludes(java.util.List<java.lang.String> excludes) {
                this.excludes = excludes;
                return this;
            }

            /**
             * Sets the value of {@link GitTagFilterCriteriaProperty#getIncludes}
             * @param includes The list of patterns of Git tags that, when pushed, are to be included as criteria that starts the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includes(java.util.List<java.lang.String> includes) {
                this.includes = includes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GitTagFilterCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GitTagFilterCriteriaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GitTagFilterCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GitTagFilterCriteriaProperty {
            private final java.util.List<java.lang.String> excludes;
            private final java.util.List<java.lang.String> includes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.excludes = software.amazon.jsii.Kernel.get(this, "excludes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.includes = software.amazon.jsii.Kernel.get(this, "includes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.excludes = builder.excludes;
                this.includes = builder.includes;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludes() {
                return this.excludes;
            }

            @Override
            public final java.util.List<java.lang.String> getIncludes() {
                return this.includes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExcludes() != null) {
                    data.set("excludes", om.valueToTree(this.getExcludes()));
                }
                if (this.getIncludes() != null) {
                    data.set("includes", om.valueToTree(this.getIncludes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.GitTagFilterCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GitTagFilterCriteriaProperty.Jsii$Proxy that = (GitTagFilterCriteriaProperty.Jsii$Proxy) o;

                if (this.excludes != null ? !this.excludes.equals(that.excludes) : that.excludes != null) return false;
                return this.includes != null ? this.includes.equals(that.includes) : that.includes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.excludes != null ? this.excludes.hashCode() : 0;
                result = 31 * result + (this.includes != null ? this.includes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents information about an artifact to be worked on, such as a test or build artifact.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * InputArtifactProperty inputArtifactProperty = InputArtifactProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-inputartifact.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-inputartifact.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.InputArtifactProperty")
    @software.amazon.jsii.Jsii.Proxy(InputArtifactProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputArtifactProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the artifact to be worked on (for example, "My App").
         * <p>
         * Artifacts are the files that are worked on by actions in the pipeline. See the action configuration for each action for details about artifact parameters. For example, the S3 source action input artifact is a file name (or file path), and the files are generally provided as a ZIP file. Example artifact name: SampleApp_Windows.zip
         * <p>
         * The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-inputartifact.html#cfn-codepipeline-pipeline-inputartifact-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-inputartifact.html#cfn-codepipeline-pipeline-inputartifact-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link InputArtifactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputArtifactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputArtifactProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link InputArtifactProperty#getName}
             * @param name The name of the artifact to be worked on (for example, "My App"). This parameter is required.
             *             Artifacts are the files that are worked on by actions in the pipeline. See the action configuration for each action for details about artifact parameters. For example, the S3 source action input artifact is a file name (or file path), and the files are generally provided as a ZIP file. Example artifact name: SampleApp_Windows.zip
             *             <p>
             *             The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputArtifactProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputArtifactProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputArtifactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputArtifactProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.InputArtifactProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputArtifactProperty.Jsii$Proxy that = (InputArtifactProperty.Jsii$Proxy) o;

                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                return result;
            }
        }
    }
    /**
     * Represents information about the output of an action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * OutputArtifactProperty outputArtifactProperty = OutputArtifactProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .files(List.of("files"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-outputartifact.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-outputartifact.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.OutputArtifactProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputArtifactProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputArtifactProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the output of an artifact, such as "My App".
         * <p>
         * The output artifact name must exactly match the input artifact declared for a downstream action. However, the downstream action's input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
         * <p>
         * Output artifact names must be unique within a pipeline.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-outputartifact.html#cfn-codepipeline-pipeline-outputartifact-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-outputartifact.html#cfn-codepipeline-pipeline-outputartifact-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The files that you want to associate with the output artifact that will be exported from the compute action.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-outputartifact.html#cfn-codepipeline-pipeline-outputartifact-files">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-outputartifact.html#cfn-codepipeline-pipeline-outputartifact-files</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFiles() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OutputArtifactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputArtifactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputArtifactProperty> {
            java.lang.String name;
            java.util.List<java.lang.String> files;

            /**
             * Sets the value of {@link OutputArtifactProperty#getName}
             * @param name The name of the output of an artifact, such as "My App". This parameter is required.
             *             The output artifact name must exactly match the input artifact declared for a downstream action. However, the downstream action's input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
             *             <p>
             *             Output artifact names must be unique within a pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link OutputArtifactProperty#getFiles}
             * @param files The files that you want to associate with the output artifact that will be exported from the compute action.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder files(java.util.List<java.lang.String> files) {
                this.files = files;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputArtifactProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputArtifactProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputArtifactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputArtifactProperty {
            private final java.lang.String name;
            private final java.util.List<java.lang.String> files;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.files = software.amazon.jsii.Kernel.get(this, "files", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.files = builder.files;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.util.List<java.lang.String> getFiles() {
                return this.files;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getFiles() != null) {
                    data.set("files", om.valueToTree(this.getFiles()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.OutputArtifactProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputArtifactProperty.Jsii$Proxy that = (OutputArtifactProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.files != null ? this.files.equals(that.files) : that.files == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.files != null ? this.files.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents information about the specified trigger configuration, such as the filter criteria and the source stage for the action that contains the trigger.
     * <p>
     * <blockquote>
     * <p>
     * This is only supported for the <code>CodeStarSourceConnection</code> action type. &gt; When a trigger configuration is specified, default change detection for repository and branch commits is disabled.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * PipelineTriggerDeclarationProperty pipelineTriggerDeclarationProperty = PipelineTriggerDeclarationProperty.builder()
     *         .providerType("providerType")
     *         // the properties below are optional
     *         .gitConfiguration(GitConfigurationProperty.builder()
     *                 .sourceActionName("sourceActionName")
     *                 // the properties below are optional
     *                 .pullRequest(List.of(GitPullRequestFilterProperty.builder()
     *                         .branches(GitBranchFilterCriteriaProperty.builder()
     *                                 .excludes(List.of("excludes"))
     *                                 .includes(List.of("includes"))
     *                                 .build())
     *                         .events(List.of("events"))
     *                         .filePaths(GitFilePathFilterCriteriaProperty.builder()
     *                                 .excludes(List.of("excludes"))
     *                                 .includes(List.of("includes"))
     *                                 .build())
     *                         .build()))
     *                 .push(List.of(GitPushFilterProperty.builder()
     *                         .branches(GitBranchFilterCriteriaProperty.builder()
     *                                 .excludes(List.of("excludes"))
     *                                 .includes(List.of("includes"))
     *                                 .build())
     *                         .filePaths(GitFilePathFilterCriteriaProperty.builder()
     *                                 .excludes(List.of("excludes"))
     *                                 .includes(List.of("includes"))
     *                                 .build())
     *                         .tags(GitTagFilterCriteriaProperty.builder()
     *                                 .excludes(List.of("excludes"))
     *                                 .includes(List.of("includes"))
     *                                 .build())
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-pipelinetriggerdeclaration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-pipelinetriggerdeclaration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.PipelineTriggerDeclarationProperty")
    @software.amazon.jsii.Jsii.Proxy(PipelineTriggerDeclarationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PipelineTriggerDeclarationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source provider for the event, such as connections configured for a repository with Git tags, for the specified trigger configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-pipelinetriggerdeclaration.html#cfn-codepipeline-pipeline-pipelinetriggerdeclaration-providertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-pipelinetriggerdeclaration.html#cfn-codepipeline-pipeline-pipelinetriggerdeclaration-providertype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProviderType();

        /**
         * Provides the filter criteria and the source stage for the repository event that starts the pipeline, such as Git tags.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-pipelinetriggerdeclaration.html#cfn-codepipeline-pipeline-pipelinetriggerdeclaration-gitconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-pipelinetriggerdeclaration.html#cfn-codepipeline-pipeline-pipelinetriggerdeclaration-gitconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGitConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PipelineTriggerDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PipelineTriggerDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PipelineTriggerDeclarationProperty> {
            java.lang.String providerType;
            java.lang.Object gitConfiguration;

            /**
             * Sets the value of {@link PipelineTriggerDeclarationProperty#getProviderType}
             * @param providerType The source provider for the event, such as connections configured for a repository with Git tags, for the specified trigger configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder providerType(java.lang.String providerType) {
                this.providerType = providerType;
                return this;
            }

            /**
             * Sets the value of {@link PipelineTriggerDeclarationProperty#getGitConfiguration}
             * @param gitConfiguration Provides the filter criteria and the source stage for the repository event that starts the pipeline, such as Git tags.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gitConfiguration(software.amazon.awscdk.IResolvable gitConfiguration) {
                this.gitConfiguration = gitConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PipelineTriggerDeclarationProperty#getGitConfiguration}
             * @param gitConfiguration Provides the filter criteria and the source stage for the repository event that starts the pipeline, such as Git tags.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder gitConfiguration(software.amazon.awscdk.services.codepipeline.CfnPipeline.GitConfigurationProperty gitConfiguration) {
                this.gitConfiguration = gitConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PipelineTriggerDeclarationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PipelineTriggerDeclarationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PipelineTriggerDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PipelineTriggerDeclarationProperty {
            private final java.lang.String providerType;
            private final java.lang.Object gitConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.providerType = software.amazon.jsii.Kernel.get(this, "providerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.gitConfiguration = software.amazon.jsii.Kernel.get(this, "gitConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.providerType = java.util.Objects.requireNonNull(builder.providerType, "providerType is required");
                this.gitConfiguration = builder.gitConfiguration;
            }

            @Override
            public final java.lang.String getProviderType() {
                return this.providerType;
            }

            @Override
            public final java.lang.Object getGitConfiguration() {
                return this.gitConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("providerType", om.valueToTree(this.getProviderType()));
                if (this.getGitConfiguration() != null) {
                    data.set("gitConfiguration", om.valueToTree(this.getGitConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.PipelineTriggerDeclarationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PipelineTriggerDeclarationProperty.Jsii$Proxy that = (PipelineTriggerDeclarationProperty.Jsii$Proxy) o;

                if (!providerType.equals(that.providerType)) return false;
                return this.gitConfiguration != null ? this.gitConfiguration.equals(that.gitConfiguration) : that.gitConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.providerType.hashCode();
                result = 31 * result + (this.gitConfiguration != null ? this.gitConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The retry configuration specifies automatic retry for a failed stage, along with the configured retry mode.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * RetryConfigurationProperty retryConfigurationProperty = RetryConfigurationProperty.builder()
     *         .retryMode("retryMode")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-retryconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-retryconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.RetryConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RetryConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetryConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The method that you want to configure for automatic stage retry on stage failure.
         * <p>
         * You can specify to retry only failed action in the stage or all actions in the stage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-retryconfiguration.html#cfn-codepipeline-pipeline-retryconfiguration-retrymode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-retryconfiguration.html#cfn-codepipeline-pipeline-retryconfiguration-retrymode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRetryMode() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetryConfigurationProperty> {
            java.lang.String retryMode;

            /**
             * Sets the value of {@link RetryConfigurationProperty#getRetryMode}
             * @param retryMode The method that you want to configure for automatic stage retry on stage failure.
             *                  You can specify to retry only failed action in the stage or all actions in the stage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retryMode(java.lang.String retryMode) {
                this.retryMode = retryMode;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetryConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetryConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetryConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetryConfigurationProperty {
            private final java.lang.String retryMode;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.retryMode = software.amazon.jsii.Kernel.get(this, "retryMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.retryMode = builder.retryMode;
            }

            @Override
            public final java.lang.String getRetryMode() {
                return this.retryMode;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRetryMode() != null) {
                    data.set("retryMode", om.valueToTree(this.getRetryMode()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.RetryConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetryConfigurationProperty.Jsii$Proxy that = (RetryConfigurationProperty.Jsii$Proxy) o;

                return this.retryMode != null ? this.retryMode.equals(that.retryMode) : that.retryMode == null;
            }

            @Override
            public final int hashCode() {
                int result = this.retryMode != null ? this.retryMode.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Represents information about the rule to be created for an associated condition.
     * <p>
     * An example would be creating a new rule for an entry condition, such as a rule that checks for a test result before allowing the run to enter the deployment stage. For more information about conditions, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/stage-conditions.html">Stage conditions</a> and <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts-how-it-works-conditions.html">How do stage conditions work?</a> . For more information about rules, see the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html">AWS CodePipeline rule reference</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * Object configuration;
     * RuleDeclarationProperty ruleDeclarationProperty = RuleDeclarationProperty.builder()
     *         .commands(List.of("commands"))
     *         .configuration(configuration)
     *         .inputArtifacts(List.of(InputArtifactProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .name("name")
     *         .region("region")
     *         .roleArn("roleArn")
     *         .ruleTypeId(RuleTypeIdProperty.builder()
     *                 .category("category")
     *                 .owner("owner")
     *                 .provider("provider")
     *                 .version("version")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.RuleDeclarationProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleDeclarationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleDeclarationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The shell commands to run with your commands rule in CodePipeline.
         * <p>
         * All commands are supported except multi-line formats. While CodeBuild logs and permissions are used, you do not need to create any resources in CodeBuild.
         * <p>
         * <blockquote>
         * <p>
         * Using compute time for this action will incur separate charges in AWS CodeBuild .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-commands">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-commands</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCommands() {
            return null;
        }

        /**
         * The action configuration fields for the rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
            return null;
        }

        /**
         * The input artifacts fields for the rule, such as specifying an input file for the rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-inputartifacts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-inputartifacts</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputArtifacts() {
            return null;
        }

        /**
         * The name of the rule that is created for the condition, such as <code>VariableCheck</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The Region for the condition associated with the rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-region</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * The pipeline role ARN associated with the rule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * The ID for the rule type, which is made up of the combined values for category, owner, provider, and version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-ruletypeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruledeclaration.html#cfn-codepipeline-pipeline-ruledeclaration-ruletypeid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRuleTypeId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleDeclarationProperty> {
            java.util.List<java.lang.String> commands;
            java.lang.Object configuration;
            java.lang.Object inputArtifacts;
            java.lang.String name;
            java.lang.String region;
            java.lang.String roleArn;
            java.lang.Object ruleTypeId;

            /**
             * Sets the value of {@link RuleDeclarationProperty#getCommands}
             * @param commands The shell commands to run with your commands rule in CodePipeline.
             *                 All commands are supported except multi-line formats. While CodeBuild logs and permissions are used, you do not need to create any resources in CodeBuild.
             *                 <p>
             *                 <blockquote>
             *                 <p>
             *                 Using compute time for this action will incur separate charges in AWS CodeBuild .
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder commands(java.util.List<java.lang.String> commands) {
                this.commands = commands;
                return this;
            }

            /**
             * Sets the value of {@link RuleDeclarationProperty#getConfiguration}
             * @param configuration The action configuration fields for the rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(java.lang.Object configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link RuleDeclarationProperty#getInputArtifacts}
             * @param inputArtifacts The input artifacts fields for the rule, such as specifying an input file for the rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputArtifacts(software.amazon.awscdk.IResolvable inputArtifacts) {
                this.inputArtifacts = inputArtifacts;
                return this;
            }

            /**
             * Sets the value of {@link RuleDeclarationProperty#getInputArtifacts}
             * @param inputArtifacts The input artifacts fields for the rule, such as specifying an input file for the rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputArtifacts(java.util.List<? extends java.lang.Object> inputArtifacts) {
                this.inputArtifacts = inputArtifacts;
                return this;
            }

            /**
             * Sets the value of {@link RuleDeclarationProperty#getName}
             * @param name The name of the rule that is created for the condition, such as <code>VariableCheck</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link RuleDeclarationProperty#getRegion}
             * @param region The Region for the condition associated with the rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link RuleDeclarationProperty#getRoleArn}
             * @param roleArn The pipeline role ARN associated with the rule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link RuleDeclarationProperty#getRuleTypeId}
             * @param ruleTypeId The ID for the rule type, which is made up of the combined values for category, owner, provider, and version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleTypeId(software.amazon.awscdk.IResolvable ruleTypeId) {
                this.ruleTypeId = ruleTypeId;
                return this;
            }

            /**
             * Sets the value of {@link RuleDeclarationProperty#getRuleTypeId}
             * @param ruleTypeId The ID for the rule type, which is made up of the combined values for category, owner, provider, and version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ruleTypeId(software.amazon.awscdk.services.codepipeline.CfnPipeline.RuleTypeIdProperty ruleTypeId) {
                this.ruleTypeId = ruleTypeId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleDeclarationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleDeclarationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleDeclarationProperty {
            private final java.util.List<java.lang.String> commands;
            private final java.lang.Object configuration;
            private final java.lang.Object inputArtifacts;
            private final java.lang.String name;
            private final java.lang.String region;
            private final java.lang.String roleArn;
            private final java.lang.Object ruleTypeId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.commands = software.amazon.jsii.Kernel.get(this, "commands", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputArtifacts = software.amazon.jsii.Kernel.get(this, "inputArtifacts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ruleTypeId = software.amazon.jsii.Kernel.get(this, "ruleTypeId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.commands = builder.commands;
                this.configuration = builder.configuration;
                this.inputArtifacts = builder.inputArtifacts;
                this.name = builder.name;
                this.region = builder.region;
                this.roleArn = builder.roleArn;
                this.ruleTypeId = builder.ruleTypeId;
            }

            @Override
            public final java.util.List<java.lang.String> getCommands() {
                return this.commands;
            }

            @Override
            public final java.lang.Object getConfiguration() {
                return this.configuration;
            }

            @Override
            public final java.lang.Object getInputArtifacts() {
                return this.inputArtifacts;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getRuleTypeId() {
                return this.ruleTypeId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCommands() != null) {
                    data.set("commands", om.valueToTree(this.getCommands()));
                }
                if (this.getConfiguration() != null) {
                    data.set("configuration", om.valueToTree(this.getConfiguration()));
                }
                if (this.getInputArtifacts() != null) {
                    data.set("inputArtifacts", om.valueToTree(this.getInputArtifacts()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getRuleTypeId() != null) {
                    data.set("ruleTypeId", om.valueToTree(this.getRuleTypeId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.RuleDeclarationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleDeclarationProperty.Jsii$Proxy that = (RuleDeclarationProperty.Jsii$Proxy) o;

                if (this.commands != null ? !this.commands.equals(that.commands) : that.commands != null) return false;
                if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
                if (this.inputArtifacts != null ? !this.inputArtifacts.equals(that.inputArtifacts) : that.inputArtifacts != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                return this.ruleTypeId != null ? this.ruleTypeId.equals(that.ruleTypeId) : that.ruleTypeId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.commands != null ? this.commands.hashCode() : 0;
                result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
                result = 31 * result + (this.inputArtifacts != null ? this.inputArtifacts.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                result = 31 * result + (this.ruleTypeId != null ? this.ruleTypeId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The ID for the rule type, which is made up of the combined values for category, owner, provider, and version.
     * <p>
     * For more information about conditions, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/stage-conditions.html">Stage conditions</a> . For more information about rules, see the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html">AWS CodePipeline rule reference</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * RuleTypeIdProperty ruleTypeIdProperty = RuleTypeIdProperty.builder()
     *         .category("category")
     *         .owner("owner")
     *         .provider("provider")
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruletypeid.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruletypeid.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.RuleTypeIdProperty")
    @software.amazon.jsii.Jsii.Proxy(RuleTypeIdProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RuleTypeIdProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A category defines what kind of rule can be run in the stage, and constrains the provider type for the rule.
         * <p>
         * The valid category is <code>Rule</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruletypeid.html#cfn-codepipeline-pipeline-ruletypeid-category">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruletypeid.html#cfn-codepipeline-pipeline-ruletypeid-category</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCategory() {
            return null;
        }

        /**
         * The creator of the rule being called.
         * <p>
         * The valid value for the <code>Owner</code> field in the rule category is <code>AWS</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruletypeid.html#cfn-codepipeline-pipeline-ruletypeid-owner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruletypeid.html#cfn-codepipeline-pipeline-ruletypeid-owner</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOwner() {
            return null;
        }

        /**
         * The rule provider, such as the <code>DeploymentWindow</code> rule.
         * <p>
         * For a list of rule provider names, see the rules listed in the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html">AWS CodePipeline rule reference</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruletypeid.html#cfn-codepipeline-pipeline-ruletypeid-provider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruletypeid.html#cfn-codepipeline-pipeline-ruletypeid-provider</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProvider() {
            return null;
        }

        /**
         * A string that describes the rule version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruletypeid.html#cfn-codepipeline-pipeline-ruletypeid-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-ruletypeid.html#cfn-codepipeline-pipeline-ruletypeid-version</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RuleTypeIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RuleTypeIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RuleTypeIdProperty> {
            java.lang.String category;
            java.lang.String owner;
            java.lang.String provider;
            java.lang.String version;

            /**
             * Sets the value of {@link RuleTypeIdProperty#getCategory}
             * @param category A category defines what kind of rule can be run in the stage, and constrains the provider type for the rule.
             *                 The valid category is <code>Rule</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder category(java.lang.String category) {
                this.category = category;
                return this;
            }

            /**
             * Sets the value of {@link RuleTypeIdProperty#getOwner}
             * @param owner The creator of the rule being called.
             *              The valid value for the <code>Owner</code> field in the rule category is <code>AWS</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder owner(java.lang.String owner) {
                this.owner = owner;
                return this;
            }

            /**
             * Sets the value of {@link RuleTypeIdProperty#getProvider}
             * @param provider The rule provider, such as the <code>DeploymentWindow</code> rule.
             *                 For a list of rule provider names, see the rules listed in the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/rule-reference.html">AWS CodePipeline rule reference</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provider(java.lang.String provider) {
                this.provider = provider;
                return this;
            }

            /**
             * Sets the value of {@link RuleTypeIdProperty#getVersion}
             * @param version A string that describes the rule version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RuleTypeIdProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RuleTypeIdProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RuleTypeIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RuleTypeIdProperty {
            private final java.lang.String category;
            private final java.lang.String owner;
            private final java.lang.String provider;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.category = software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.owner = software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.category = builder.category;
                this.owner = builder.owner;
                this.provider = builder.provider;
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getCategory() {
                return this.category;
            }

            @Override
            public final java.lang.String getOwner() {
                return this.owner;
            }

            @Override
            public final java.lang.String getProvider() {
                return this.provider;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCategory() != null) {
                    data.set("category", om.valueToTree(this.getCategory()));
                }
                if (this.getOwner() != null) {
                    data.set("owner", om.valueToTree(this.getOwner()));
                }
                if (this.getProvider() != null) {
                    data.set("provider", om.valueToTree(this.getProvider()));
                }
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.RuleTypeIdProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RuleTypeIdProperty.Jsii$Proxy that = (RuleTypeIdProperty.Jsii$Proxy) o;

                if (this.category != null ? !this.category.equals(that.category) : that.category != null) return false;
                if (this.owner != null ? !this.owner.equals(that.owner) : that.owner != null) return false;
                if (this.provider != null ? !this.provider.equals(that.provider) : that.provider != null) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.category != null ? this.category.hashCode() : 0;
                result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
                result = 31 * result + (this.provider != null ? this.provider.hashCode() : 0);
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents information about a stage and its definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * Object configuration;
     * StageDeclarationProperty stageDeclarationProperty = StageDeclarationProperty.builder()
     *         .actions(List.of(ActionDeclarationProperty.builder()
     *                 .actionTypeId(ActionTypeIdProperty.builder()
     *                         .category("category")
     *                         .owner("owner")
     *                         .provider("provider")
     *                         .version("version")
     *                         .build())
     *                 .name("name")
     *                 // the properties below are optional
     *                 .commands(List.of("commands"))
     *                 .configuration(configuration)
     *                 .environmentVariables(List.of(EnvironmentVariableProperty.builder()
     *                         .name("name")
     *                         .value("value")
     *                         // the properties below are optional
     *                         .type("type")
     *                         .build()))
     *                 .inputArtifacts(List.of(InputArtifactProperty.builder()
     *                         .name("name")
     *                         .build()))
     *                 .namespace("namespace")
     *                 .outputArtifacts(List.of(OutputArtifactProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .files(List.of("files"))
     *                         .build()))
     *                 .outputVariables(List.of("outputVariables"))
     *                 .region("region")
     *                 .roleArn("roleArn")
     *                 .runOrder(123)
     *                 .timeoutInMinutes(123)
     *                 .build()))
     *         .name("name")
     *         // the properties below are optional
     *         .beforeEntry(BeforeEntryConditionsProperty.builder()
     *                 .conditions(List.of(ConditionProperty.builder()
     *                         .result("result")
     *                         .rules(List.of(RuleDeclarationProperty.builder()
     *                                 .commands(List.of("commands"))
     *                                 .configuration(configuration)
     *                                 .inputArtifacts(List.of(InputArtifactProperty.builder()
     *                                         .name("name")
     *                                         .build()))
     *                                 .name("name")
     *                                 .region("region")
     *                                 .roleArn("roleArn")
     *                                 .ruleTypeId(RuleTypeIdProperty.builder()
     *                                         .category("category")
     *                                         .owner("owner")
     *                                         .provider("provider")
     *                                         .version("version")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .blockers(List.of(BlockerDeclarationProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 .build()))
     *         .onFailure(FailureConditionsProperty.builder()
     *                 .conditions(List.of(ConditionProperty.builder()
     *                         .result("result")
     *                         .rules(List.of(RuleDeclarationProperty.builder()
     *                                 .commands(List.of("commands"))
     *                                 .configuration(configuration)
     *                                 .inputArtifacts(List.of(InputArtifactProperty.builder()
     *                                         .name("name")
     *                                         .build()))
     *                                 .name("name")
     *                                 .region("region")
     *                                 .roleArn("roleArn")
     *                                 .ruleTypeId(RuleTypeIdProperty.builder()
     *                                         .category("category")
     *                                         .owner("owner")
     *                                         .provider("provider")
     *                                         .version("version")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 .result("result")
     *                 .retryConfiguration(RetryConfigurationProperty.builder()
     *                         .retryMode("retryMode")
     *                         .build())
     *                 .build())
     *         .onSuccess(SuccessConditionsProperty.builder()
     *                 .conditions(List.of(ConditionProperty.builder()
     *                         .result("result")
     *                         .rules(List.of(RuleDeclarationProperty.builder()
     *                                 .commands(List.of("commands"))
     *                                 .configuration(configuration)
     *                                 .inputArtifacts(List.of(InputArtifactProperty.builder()
     *                                         .name("name")
     *                                         .build()))
     *                                 .name("name")
     *                                 .region("region")
     *                                 .roleArn("roleArn")
     *                                 .ruleTypeId(RuleTypeIdProperty.builder()
     *                                         .category("category")
     *                                         .owner("owner")
     *                                         .provider("provider")
     *                                         .version("version")
     *                                         .build())
     *                                 .build()))
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagedeclaration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagedeclaration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.StageDeclarationProperty")
    @software.amazon.jsii.Jsii.Proxy(StageDeclarationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StageDeclarationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The actions included in a stage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagedeclaration.html#cfn-codepipeline-pipeline-stagedeclaration-actions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagedeclaration.html#cfn-codepipeline-pipeline-stagedeclaration-actions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getActions();

        /**
         * The name of the stage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagedeclaration.html#cfn-codepipeline-pipeline-stagedeclaration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagedeclaration.html#cfn-codepipeline-pipeline-stagedeclaration-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The method to use when a stage allows entry.
         * <p>
         * For example, configuring this field for conditions will allow entry to the stage when the conditions are met.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagedeclaration.html#cfn-codepipeline-pipeline-stagedeclaration-beforeentry">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagedeclaration.html#cfn-codepipeline-pipeline-stagedeclaration-beforeentry</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBeforeEntry() {
            return null;
        }

        /**
         * Reserved for future use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagedeclaration.html#cfn-codepipeline-pipeline-stagedeclaration-blockers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagedeclaration.html#cfn-codepipeline-pipeline-stagedeclaration-blockers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockers() {
            return null;
        }

        /**
         * The method to use when a stage has not completed successfully.
         * <p>
         * For example, configuring this field for rollback will roll back a failed stage automatically to the last successful pipeline execution in the stage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagedeclaration.html#cfn-codepipeline-pipeline-stagedeclaration-onfailure">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagedeclaration.html#cfn-codepipeline-pipeline-stagedeclaration-onfailure</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOnFailure() {
            return null;
        }

        /**
         * The method to use when a stage has succeeded.
         * <p>
         * For example, configuring this field for conditions will allow the stage to succeed when the conditions are met.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagedeclaration.html#cfn-codepipeline-pipeline-stagedeclaration-onsuccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagedeclaration.html#cfn-codepipeline-pipeline-stagedeclaration-onsuccess</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOnSuccess() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StageDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StageDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StageDeclarationProperty> {
            java.lang.Object actions;
            java.lang.String name;
            java.lang.Object beforeEntry;
            java.lang.Object blockers;
            java.lang.Object onFailure;
            java.lang.Object onSuccess;

            /**
             * Sets the value of {@link StageDeclarationProperty#getActions}
             * @param actions The actions included in a stage. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.IResolvable actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link StageDeclarationProperty#getActions}
             * @param actions The actions included in a stage. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<? extends java.lang.Object> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link StageDeclarationProperty#getName}
             * @param name The name of the stage. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link StageDeclarationProperty#getBeforeEntry}
             * @param beforeEntry The method to use when a stage allows entry.
             *                    For example, configuring this field for conditions will allow entry to the stage when the conditions are met.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder beforeEntry(software.amazon.awscdk.IResolvable beforeEntry) {
                this.beforeEntry = beforeEntry;
                return this;
            }

            /**
             * Sets the value of {@link StageDeclarationProperty#getBeforeEntry}
             * @param beforeEntry The method to use when a stage allows entry.
             *                    For example, configuring this field for conditions will allow entry to the stage when the conditions are met.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder beforeEntry(software.amazon.awscdk.services.codepipeline.CfnPipeline.BeforeEntryConditionsProperty beforeEntry) {
                this.beforeEntry = beforeEntry;
                return this;
            }

            /**
             * Sets the value of {@link StageDeclarationProperty#getBlockers}
             * @param blockers Reserved for future use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockers(software.amazon.awscdk.IResolvable blockers) {
                this.blockers = blockers;
                return this;
            }

            /**
             * Sets the value of {@link StageDeclarationProperty#getBlockers}
             * @param blockers Reserved for future use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockers(java.util.List<? extends java.lang.Object> blockers) {
                this.blockers = blockers;
                return this;
            }

            /**
             * Sets the value of {@link StageDeclarationProperty#getOnFailure}
             * @param onFailure The method to use when a stage has not completed successfully.
             *                  For example, configuring this field for rollback will roll back a failed stage automatically to the last successful pipeline execution in the stage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onFailure(software.amazon.awscdk.IResolvable onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            /**
             * Sets the value of {@link StageDeclarationProperty#getOnFailure}
             * @param onFailure The method to use when a stage has not completed successfully.
             *                  For example, configuring this field for rollback will roll back a failed stage automatically to the last successful pipeline execution in the stage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onFailure(software.amazon.awscdk.services.codepipeline.CfnPipeline.FailureConditionsProperty onFailure) {
                this.onFailure = onFailure;
                return this;
            }

            /**
             * Sets the value of {@link StageDeclarationProperty#getOnSuccess}
             * @param onSuccess The method to use when a stage has succeeded.
             *                  For example, configuring this field for conditions will allow the stage to succeed when the conditions are met.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onSuccess(software.amazon.awscdk.IResolvable onSuccess) {
                this.onSuccess = onSuccess;
                return this;
            }

            /**
             * Sets the value of {@link StageDeclarationProperty#getOnSuccess}
             * @param onSuccess The method to use when a stage has succeeded.
             *                  For example, configuring this field for conditions will allow the stage to succeed when the conditions are met.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder onSuccess(software.amazon.awscdk.services.codepipeline.CfnPipeline.SuccessConditionsProperty onSuccess) {
                this.onSuccess = onSuccess;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StageDeclarationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StageDeclarationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StageDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StageDeclarationProperty {
            private final java.lang.Object actions;
            private final java.lang.String name;
            private final java.lang.Object beforeEntry;
            private final java.lang.Object blockers;
            private final java.lang.Object onFailure;
            private final java.lang.Object onSuccess;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.beforeEntry = software.amazon.jsii.Kernel.get(this, "beforeEntry", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.blockers = software.amazon.jsii.Kernel.get(this, "blockers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onFailure = software.amazon.jsii.Kernel.get(this, "onFailure", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.onSuccess = software.amazon.jsii.Kernel.get(this, "onSuccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.beforeEntry = builder.beforeEntry;
                this.blockers = builder.blockers;
                this.onFailure = builder.onFailure;
                this.onSuccess = builder.onSuccess;
            }

            @Override
            public final java.lang.Object getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getBeforeEntry() {
                return this.beforeEntry;
            }

            @Override
            public final java.lang.Object getBlockers() {
                return this.blockers;
            }

            @Override
            public final java.lang.Object getOnFailure() {
                return this.onFailure;
            }

            @Override
            public final java.lang.Object getOnSuccess() {
                return this.onSuccess;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getBeforeEntry() != null) {
                    data.set("beforeEntry", om.valueToTree(this.getBeforeEntry()));
                }
                if (this.getBlockers() != null) {
                    data.set("blockers", om.valueToTree(this.getBlockers()));
                }
                if (this.getOnFailure() != null) {
                    data.set("onFailure", om.valueToTree(this.getOnFailure()));
                }
                if (this.getOnSuccess() != null) {
                    data.set("onSuccess", om.valueToTree(this.getOnSuccess()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.StageDeclarationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StageDeclarationProperty.Jsii$Proxy that = (StageDeclarationProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                if (!name.equals(that.name)) return false;
                if (this.beforeEntry != null ? !this.beforeEntry.equals(that.beforeEntry) : that.beforeEntry != null) return false;
                if (this.blockers != null ? !this.blockers.equals(that.blockers) : that.blockers != null) return false;
                if (this.onFailure != null ? !this.onFailure.equals(that.onFailure) : that.onFailure != null) return false;
                return this.onSuccess != null ? this.onSuccess.equals(that.onSuccess) : that.onSuccess == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.beforeEntry != null ? this.beforeEntry.hashCode() : 0);
                result = 31 * result + (this.blockers != null ? this.blockers.hashCode() : 0);
                result = 31 * result + (this.onFailure != null ? this.onFailure.hashCode() : 0);
                result = 31 * result + (this.onSuccess != null ? this.onSuccess.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * StageTransitionProperty stageTransitionProperty = StageTransitionProperty.builder()
     *         .reason("reason")
     *         .stageName("stageName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagetransition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagetransition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.StageTransitionProperty")
    @software.amazon.jsii.Jsii.Proxy(StageTransitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StageTransitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests.
         * <p>
         * This message is displayed in the pipeline console UI.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagetransition.html#cfn-codepipeline-pipeline-stagetransition-reason">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagetransition.html#cfn-codepipeline-pipeline-stagetransition-reason</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getReason();

        /**
         * The name of the stage where you want to disable the inbound or outbound transition of artifacts.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagetransition.html#cfn-codepipeline-pipeline-stagetransition-stagename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-stagetransition.html#cfn-codepipeline-pipeline-stagetransition-stagename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStageName();

        /**
         * @return a {@link Builder} of {@link StageTransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StageTransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StageTransitionProperty> {
            java.lang.String reason;
            java.lang.String stageName;

            /**
             * Sets the value of {@link StageTransitionProperty#getReason}
             * @param reason The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests. This parameter is required.
             *               This message is displayed in the pipeline console UI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reason(java.lang.String reason) {
                this.reason = reason;
                return this;
            }

            /**
             * Sets the value of {@link StageTransitionProperty#getStageName}
             * @param stageName The name of the stage where you want to disable the inbound or outbound transition of artifacts. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stageName(java.lang.String stageName) {
                this.stageName = stageName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StageTransitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StageTransitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StageTransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StageTransitionProperty {
            private final java.lang.String reason;
            private final java.lang.String stageName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.reason = software.amazon.jsii.Kernel.get(this, "reason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stageName = software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.reason = java.util.Objects.requireNonNull(builder.reason, "reason is required");
                this.stageName = java.util.Objects.requireNonNull(builder.stageName, "stageName is required");
            }

            @Override
            public final java.lang.String getReason() {
                return this.reason;
            }

            @Override
            public final java.lang.String getStageName() {
                return this.stageName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("reason", om.valueToTree(this.getReason()));
                data.set("stageName", om.valueToTree(this.getStageName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.StageTransitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StageTransitionProperty.Jsii$Proxy that = (StageTransitionProperty.Jsii$Proxy) o;

                if (!reason.equals(that.reason)) return false;
                return this.stageName.equals(that.stageName);
            }

            @Override
            public final int hashCode() {
                int result = this.reason.hashCode();
                result = 31 * result + (this.stageName.hashCode());
                return result;
            }
        }
    }
    /**
     * The conditions for making checks that, if met, succeed a stage.
     * <p>
     * For more information about conditions, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/stage-conditions.html">Stage conditions</a> and <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/concepts-how-it-works-conditions.html">How do stage conditions work?</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * Object configuration;
     * SuccessConditionsProperty successConditionsProperty = SuccessConditionsProperty.builder()
     *         .conditions(List.of(ConditionProperty.builder()
     *                 .result("result")
     *                 .rules(List.of(RuleDeclarationProperty.builder()
     *                         .commands(List.of("commands"))
     *                         .configuration(configuration)
     *                         .inputArtifacts(List.of(InputArtifactProperty.builder()
     *                                 .name("name")
     *                                 .build()))
     *                         .name("name")
     *                         .region("region")
     *                         .roleArn("roleArn")
     *                         .ruleTypeId(RuleTypeIdProperty.builder()
     *                                 .category("category")
     *                                 .owner("owner")
     *                                 .provider("provider")
     *                                 .version("version")
     *                                 .build())
     *                         .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-successconditions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-successconditions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.SuccessConditionsProperty")
    @software.amazon.jsii.Jsii.Proxy(SuccessConditionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SuccessConditionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The conditions that are success conditions.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-successconditions.html#cfn-codepipeline-pipeline-successconditions-conditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-successconditions.html#cfn-codepipeline-pipeline-successconditions-conditions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConditions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SuccessConditionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SuccessConditionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SuccessConditionsProperty> {
            java.lang.Object conditions;

            /**
             * Sets the value of {@link SuccessConditionsProperty#getConditions}
             * @param conditions The conditions that are success conditions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(software.amazon.awscdk.IResolvable conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Sets the value of {@link SuccessConditionsProperty#getConditions}
             * @param conditions The conditions that are success conditions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(java.util.List<? extends java.lang.Object> conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SuccessConditionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SuccessConditionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SuccessConditionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SuccessConditionsProperty {
            private final java.lang.Object conditions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.conditions = builder.conditions;
            }

            @Override
            public final java.lang.Object getConditions() {
                return this.conditions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConditions() != null) {
                    data.set("conditions", om.valueToTree(this.getConditions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.SuccessConditionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SuccessConditionsProperty.Jsii$Proxy that = (SuccessConditionsProperty.Jsii$Proxy) o;

                return this.conditions != null ? this.conditions.equals(that.conditions) : that.conditions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.conditions != null ? this.conditions.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * A variable declared at the pipeline level.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * VariableDeclarationProperty variableDeclarationProperty = VariableDeclarationProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .defaultValue("defaultValue")
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-variabledeclaration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-variabledeclaration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.VariableDeclarationProperty")
    @software.amazon.jsii.Jsii.Proxy(VariableDeclarationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VariableDeclarationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of a pipeline-level variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-variabledeclaration.html#cfn-codepipeline-pipeline-variabledeclaration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-variabledeclaration.html#cfn-codepipeline-pipeline-variabledeclaration-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The value of a pipeline-level variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-variabledeclaration.html#cfn-codepipeline-pipeline-variabledeclaration-defaultvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-variabledeclaration.html#cfn-codepipeline-pipeline-variabledeclaration-defaultvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultValue() {
            return null;
        }

        /**
         * The description of a pipeline-level variable.
         * <p>
         * It's used to add additional context about the variable, and not being used at time when pipeline executes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-variabledeclaration.html#cfn-codepipeline-pipeline-variabledeclaration-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-variabledeclaration.html#cfn-codepipeline-pipeline-variabledeclaration-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VariableDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VariableDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VariableDeclarationProperty> {
            java.lang.String name;
            java.lang.String defaultValue;
            java.lang.String description;

            /**
             * Sets the value of {@link VariableDeclarationProperty#getName}
             * @param name The name of a pipeline-level variable. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link VariableDeclarationProperty#getDefaultValue}
             * @param defaultValue The value of a pipeline-level variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(java.lang.String defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Sets the value of {@link VariableDeclarationProperty#getDescription}
             * @param description The description of a pipeline-level variable.
             *                    It's used to add additional context about the variable, and not being used at time when pipeline executes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VariableDeclarationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VariableDeclarationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VariableDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VariableDeclarationProperty {
            private final java.lang.String name;
            private final java.lang.String defaultValue;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultValue = software.amazon.jsii.Kernel.get(this, "defaultValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.defaultValue = builder.defaultValue;
                this.description = builder.description;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getDefaultValue() {
                return this.defaultValue;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getDefaultValue() != null) {
                    data.set("defaultValue", om.valueToTree(this.getDefaultValue()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.VariableDeclarationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VariableDeclarationProperty.Jsii$Proxy that = (VariableDeclarationProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) return false;
                return this.description != null ? this.description.equals(that.description) : that.description == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.CfnPipeline}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.CfnPipeline> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codepipeline.CfnPipelineProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codepipeline.CfnPipelineProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no <code>actionRoleArn</code> , or to use to assume roles for actions with an <code>actionRoleArn</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-rolearn</a>
         * @param roleArn The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no <code>actionRoleArn</code> , or to use to assume roles for actions with an <code>actionRoleArn</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * Represents information about a stage and its definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-stages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-stages</a>
         * @param stages Represents information about a stage and its definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stages(final software.amazon.awscdk.IResolvable stages) {
            this.props.stages(stages);
            return this;
        }
        /**
         * Represents information about a stage and its definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-stages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-stages</a>
         * @param stages Represents information about a stage and its definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stages(final java.util.List<? extends java.lang.Object> stages) {
            this.props.stages(stages);
            return this;
        }

        /**
         * The S3 bucket where artifacts for the pipeline are stored.
         * <p>
         * <blockquote>
         * <p>
         * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-artifactstore">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-artifactstore</a>
         * @param artifactStore The S3 bucket where artifacts for the pipeline are stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactStore(final software.amazon.awscdk.IResolvable artifactStore) {
            this.props.artifactStore(artifactStore);
            return this;
        }
        /**
         * The S3 bucket where artifacts for the pipeline are stored.
         * <p>
         * <blockquote>
         * <p>
         * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-artifactstore">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-artifactstore</a>
         * @param artifactStore The S3 bucket where artifacts for the pipeline are stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactStore(final software.amazon.awscdk.services.codepipeline.CfnPipeline.ArtifactStoreProperty artifactStore) {
            this.props.artifactStore(artifactStore);
            return this;
        }

        /**
         * A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions.
         * <p>
         * There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
         * <p>
         * <blockquote>
         * <p>
         * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-artifactstores">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-artifactstores</a>
         * @param artifactStores A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactStores(final software.amazon.awscdk.IResolvable artifactStores) {
            this.props.artifactStores(artifactStores);
            return this;
        }
        /**
         * A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions.
         * <p>
         * There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
         * <p>
         * <blockquote>
         * <p>
         * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-artifactstores">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-artifactstores</a>
         * @param artifactStores A mapping of <code>artifactStore</code> objects and their corresponding AWS Regions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactStores(final java.util.List<? extends java.lang.Object> artifactStores) {
            this.props.artifactStores(artifactStores);
            return this;
        }

        /**
         * Represents the input of a <code>DisableStageTransition</code> action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-disableinboundstagetransitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-disableinboundstagetransitions</a>
         * @param disableInboundStageTransitions Represents the input of a <code>DisableStageTransition</code> action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableInboundStageTransitions(final software.amazon.awscdk.IResolvable disableInboundStageTransitions) {
            this.props.disableInboundStageTransitions(disableInboundStageTransitions);
            return this;
        }
        /**
         * Represents the input of a <code>DisableStageTransition</code> action.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-disableinboundstagetransitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-disableinboundstagetransitions</a>
         * @param disableInboundStageTransitions Represents the input of a <code>DisableStageTransition</code> action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableInboundStageTransitions(final java.util.List<? extends java.lang.Object> disableInboundStageTransitions) {
            this.props.disableInboundStageTransitions(disableInboundStageTransitions);
            return this;
        }

        /**
         * The method that the pipeline will use to handle multiple executions.
         * <p>
         * The default mode is SUPERSEDED.
         * <p>
         * Default: - "SUPERSEDED"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-executionmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-executionmode</a>
         * @param executionMode The method that the pipeline will use to handle multiple executions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionMode(final java.lang.String executionMode) {
            this.props.executionMode(executionMode);
            return this;
        }

        /**
         * The name of the pipeline.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-name</a>
         * @param name The name of the pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * CodePipeline provides the following pipeline types, which differ in characteristics and price, so that you can tailor your pipeline features and cost to the needs of your applications.
         * <p>
         * <ul>
         * <li>V1 type pipelines have a JSON structure that contains standard pipeline, stage, and action-level parameters.</li>
         * <li>V2 type pipelines have the same structure as a V1 type, along with additional parameters for release safety and trigger configuration.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Including V2 parameters, such as triggers on Git tags, in the pipeline JSON when creating or updating a pipeline will result in the pipeline having the V2 type of pipeline and the associated costs.
         * <p>
         * </blockquote>
         * <p>
         * For information about pricing for CodePipeline, see <a href="https://docs.aws.amazon.com/codepipeline/pricing/">Pricing</a> .
         * <p>
         * For information about which type of pipeline to choose, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/pipeline-types-planning.html">What type of pipeline is right for me?</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-pipelinetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-pipelinetype</a>
         * @param pipelineType CodePipeline provides the following pipeline types, which differ in characteristics and price, so that you can tailor your pipeline features and cost to the needs of your applications. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pipelineType(final java.lang.String pipelineType) {
            this.props.pipelineType(pipelineType);
            return this;
        }

        /**
         * Indicates whether to rerun the CodePipeline pipeline after you update it.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-restartexecutiononupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-restartexecutiononupdate</a>
         * @param restartExecutionOnUpdate Indicates whether to rerun the CodePipeline pipeline after you update it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartExecutionOnUpdate(final java.lang.Boolean restartExecutionOnUpdate) {
            this.props.restartExecutionOnUpdate(restartExecutionOnUpdate);
            return this;
        }
        /**
         * Indicates whether to rerun the CodePipeline pipeline after you update it.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-restartexecutiononupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-restartexecutiononupdate</a>
         * @param restartExecutionOnUpdate Indicates whether to rerun the CodePipeline pipeline after you update it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartExecutionOnUpdate(final software.amazon.awscdk.IResolvable restartExecutionOnUpdate) {
            this.props.restartExecutionOnUpdate(restartExecutionOnUpdate);
            return this;
        }

        /**
         * Specifies the tags applied to the pipeline.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-tags</a>
         * @param tags Specifies the tags applied to the pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline.
         * <p>
         * <blockquote>
         * <p>
         * When a trigger configuration is specified, default change detection for repository and branch commits is disabled.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-triggers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-triggers</a>
         * @param triggers The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(final software.amazon.awscdk.IResolvable triggers) {
            this.props.triggers(triggers);
            return this;
        }
        /**
         * The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline.
         * <p>
         * <blockquote>
         * <p>
         * When a trigger configuration is specified, default change detection for repository and branch commits is disabled.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-triggers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-triggers</a>
         * @param triggers The trigger configuration specifying a type of event, such as Git tags, that starts the pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggers(final java.util.List<? extends java.lang.Object> triggers) {
            this.props.triggers(triggers);
            return this;
        }

        /**
         * A list that defines the pipeline variables for a pipeline resource.
         * <p>
         * Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9&#64;\-_]+</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-variables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-variables</a>
         * @param variables A list that defines the pipeline variables for a pipeline resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variables(final software.amazon.awscdk.IResolvable variables) {
            this.props.variables(variables);
            return this;
        }
        /**
         * A list that defines the pipeline variables for a pipeline resource.
         * <p>
         * Variable names can have alphanumeric and underscore characters, and the values must match <code>[A-Za-z0-9&#64;\-_]+</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-variables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html#cfn-codepipeline-pipeline-variables</a>
         * @param variables A list that defines the pipeline variables for a pipeline resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variables(final java.util.List<? extends java.lang.Object> variables) {
            this.props.variables(variables);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.CfnPipeline}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.CfnPipeline build() {
            return new software.amazon.awscdk.services.codepipeline.CfnPipeline(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
