package software.amazon.awscdk.services.codepipeline.actions;

/**
 * Properties for configuring self-managed permissions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IRole existingAdminRole = Role.fromRoleName(this, "AdminRole", "AWSCloudFormationStackSetAdministrationRole");
 * StackSetDeploymentModel deploymentModel = StackSetDeploymentModel.selfManaged(SelfManagedDeploymentProps.builder()
 *         // Use an existing Role. Leave this out to create a new Role.
 *         .administrationRole(existingAdminRole)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:13.707Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.SelfManagedDeploymentProps")
@software.amazon.jsii.Jsii.Proxy(SelfManagedDeploymentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SelfManagedDeploymentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The IAM role in the administrator account used to assume execution roles in the target accounts.
     * <p>
     * You must create this role before using the StackSet action.
     * <p>
     * The role needs to be assumable by CloudFormation, and it needs to be able
     * to <code>sts:AssumeRole</code> each of the execution roles (whose names are specified
     * in the <code>executionRoleName</code> parameter) in each of the target accounts.
     * <p>
     * If you do not specify the role, we assume you have created a role named
     * <code>AWSCloudFormationStackSetAdministrationRole</code>.
     * <p>
     * Default: - Assume an existing role named `AWSCloudFormationStackSetAdministrationRole` in the same account as the pipeline.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getAdministrationRole() {
        return null;
    }

    /**
     * The name of the IAM role in the target accounts used to perform stack set operations.
     * <p>
     * You must create these roles in each of the target accounts before using the
     * StackSet action.
     * <p>
     * The roles need to be assumable by by the <code>administrationRole</code>, and need to
     * have the permissions necessary to successfully create and modify the
     * resources that the subsequent CloudFormation deployments need.
     * Administrator permissions would be commonly granted to these, but if you can
     * scope the permissions down frome there you would be safer.
     * <p>
     * Default: AWSCloudFormationStackSetExecutionRole
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-prereqs-self-managed.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SelfManagedDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SelfManagedDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SelfManagedDeploymentProps> {
        software.amazon.awscdk.services.iam.IRole administrationRole;
        java.lang.String executionRoleName;

        /**
         * Sets the value of {@link SelfManagedDeploymentProps#getAdministrationRole}
         * @param administrationRole The IAM role in the administrator account used to assume execution roles in the target accounts.
         *                           You must create this role before using the StackSet action.
         *                           <p>
         *                           The role needs to be assumable by CloudFormation, and it needs to be able
         *                           to <code>sts:AssumeRole</code> each of the execution roles (whose names are specified
         *                           in the <code>executionRoleName</code> parameter) in each of the target accounts.
         *                           <p>
         *                           If you do not specify the role, we assume you have created a role named
         *                           <code>AWSCloudFormationStackSetAdministrationRole</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder administrationRole(software.amazon.awscdk.services.iam.IRole administrationRole) {
            this.administrationRole = administrationRole;
            return this;
        }

        /**
         * Sets the value of {@link SelfManagedDeploymentProps#getExecutionRoleName}
         * @param executionRoleName The name of the IAM role in the target accounts used to perform stack set operations.
         *                          You must create these roles in each of the target accounts before using the
         *                          StackSet action.
         *                          <p>
         *                          The roles need to be assumable by by the <code>administrationRole</code>, and need to
         *                          have the permissions necessary to successfully create and modify the
         *                          resources that the subsequent CloudFormation deployments need.
         *                          Administrator permissions would be commonly granted to these, but if you can
         *                          scope the permissions down frome there you would be safer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleName(java.lang.String executionRoleName) {
            this.executionRoleName = executionRoleName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SelfManagedDeploymentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SelfManagedDeploymentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SelfManagedDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SelfManagedDeploymentProps {
        private final software.amazon.awscdk.services.iam.IRole administrationRole;
        private final java.lang.String executionRoleName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.administrationRole = software.amazon.jsii.Kernel.get(this, "administrationRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.executionRoleName = software.amazon.jsii.Kernel.get(this, "executionRoleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.administrationRole = builder.administrationRole;
            this.executionRoleName = builder.executionRoleName;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getAdministrationRole() {
            return this.administrationRole;
        }

        @Override
        public final java.lang.String getExecutionRoleName() {
            return this.executionRoleName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAdministrationRole() != null) {
                data.set("administrationRole", om.valueToTree(this.getAdministrationRole()));
            }
            if (this.getExecutionRoleName() != null) {
                data.set("executionRoleName", om.valueToTree(this.getExecutionRoleName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.SelfManagedDeploymentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SelfManagedDeploymentProps.Jsii$Proxy that = (SelfManagedDeploymentProps.Jsii$Proxy) o;

            if (this.administrationRole != null ? !this.administrationRole.equals(that.administrationRole) : that.administrationRole != null) return false;
            return this.executionRoleName != null ? this.executionRoleName.equals(that.executionRoleName) : that.executionRoleName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.administrationRole != null ? this.administrationRole.hashCode() : 0;
            result = 31 * result + (this.executionRoleName != null ? this.executionRoleName.hashCode() : 0);
            return result;
        }
    }
}
