package software.amazon.awscdk.services.cognito.identitypool;

/**
 * Keys for Login Providers - each correspond to the client IDs of their respective federation Identity Providers.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl;
 * IdentityPool.Builder.create(this, "myidentitypool")
 *         .identityPoolName("myidentitypool")
 *         .roleMappings(List.of(IdentityPoolRoleMapping.builder()
 *                 .providerUrl(IdentityPoolProviderUrl.custom("my-custom-provider.com"))
 *                 .useToken(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:13.956Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito_identitypool.IdentityPoolProviderUrl")
public class IdentityPoolProviderUrl extends software.amazon.jsii.JsiiObject {

    protected IdentityPoolProviderUrl(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected IdentityPoolProviderUrl(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        AMAZON = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "AMAZON", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class));
        APPLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "APPLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class));
        FACEBOOK = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "FACEBOOK", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class));
        GOOGLE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "GOOGLE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class));
        TWITTER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "TWITTER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class));
    }

    /**
     * @param type The type of Identity Pool Provider. This parameter is required.
     * @param value The value of the Identity Pool Provider. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public IdentityPoolProviderUrl(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderType type, final @org.jetbrains.annotations.NotNull java.lang.String value) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(type, "type is required"), java.util.Objects.requireNonNull(value, "value is required") });
    }

    /**
     * Custom Provider url.
     * <p>
     * @param url This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl custom(final @org.jetbrains.annotations.NotNull java.lang.String url) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class), new Object[] { java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * OpenId Provider url.
     * <p>
     * @param url This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl openId(final @org.jetbrains.annotations.NotNull java.lang.String url) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "openId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class), new Object[] { java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * Saml Provider url.
     * <p>
     * @param url This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl saml(final @org.jetbrains.annotations.NotNull java.lang.String url) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "saml", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class), new Object[] { java.util.Objects.requireNonNull(url, "url is required") });
    }

    /**
     * User Pool Provider Url.
     * <p>
     * @param userPool This parameter is required.
     * @param userPoolClient This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl userPool(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPool userPool, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPoolClient userPoolClient) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class, "userPool", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl.class), new Object[] { java.util.Objects.requireNonNull(userPool, "userPool is required"), java.util.Objects.requireNonNull(userPoolClient, "userPoolClient is required") });
    }

    /**
     * Amazon Provider url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl AMAZON;

    /**
     * Apple Provider url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl APPLE;

    /**
     * Facebook Provider url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl FACEBOOK;

    /**
     * Google Provider url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl GOOGLE;

    /**
     * Twitter Provider url.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderUrl TWITTER;

    /**
     * The type of Identity Pool Provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.identitypool.IdentityPoolProviderType.class));
    }

    /**
     * The value of the Identity Pool Provider.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getValue() {
        return software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
