package software.amazon.awscdk.services.comprehend;

/**
 * Properties for defining a <code>CfnDocumentClassifier</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.comprehend.*;
 * CfnDocumentClassifierProps cfnDocumentClassifierProps = CfnDocumentClassifierProps.builder()
 *         .dataAccessRoleArn("dataAccessRoleArn")
 *         .documentClassifierName("documentClassifierName")
 *         .inputDataConfig(DocumentClassifierInputDataConfigProperty.builder()
 *                 .augmentedManifests(List.of(AugmentedManifestsListItemProperty.builder()
 *                         .attributeNames(List.of("attributeNames"))
 *                         .s3Uri("s3Uri")
 *                         // the properties below are optional
 *                         .split("split")
 *                         .build()))
 *                 .dataFormat("dataFormat")
 *                 .documentReaderConfig(DocumentReaderConfigProperty.builder()
 *                         .documentReadAction("documentReadAction")
 *                         // the properties below are optional
 *                         .documentReadMode("documentReadMode")
 *                         .featureTypes(List.of("featureTypes"))
 *                         .build())
 *                 .documents(DocumentClassifierDocumentsProperty.builder()
 *                         .s3Uri("s3Uri")
 *                         // the properties below are optional
 *                         .testS3Uri("testS3Uri")
 *                         .build())
 *                 .documentType("documentType")
 *                 .labelDelimiter("labelDelimiter")
 *                 .s3Uri("s3Uri")
 *                 .testS3Uri("testS3Uri")
 *                 .build())
 *         .languageCode("languageCode")
 *         // the properties below are optional
 *         .mode("mode")
 *         .modelKmsKeyId("modelKmsKeyId")
 *         .modelPolicy("modelPolicy")
 *         .outputDataConfig(DocumentClassifierOutputDataConfigProperty.builder()
 *                 .kmsKeyId("kmsKeyId")
 *                 .s3Uri("s3Uri")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .versionName("versionName")
 *         .volumeKmsKeyId("volumeKmsKeyId")
 *         .vpcConfig(VpcConfigProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnets(List.of("subnets"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:13.985Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_comprehend.CfnDocumentClassifierProps")
@software.amazon.jsii.Jsii.Proxy(CfnDocumentClassifierProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDocumentClassifierProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-dataaccessrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-dataaccessrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataAccessRoleArn();

    /**
     * The name of the document classifier.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-documentclassifiername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-documentclassifiername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDocumentClassifierName();

    /**
     * Specifies the format and location of the input data for the job.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-inputdataconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-inputdataconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getInputDataConfig();

    /**
     * The language of the input documents.
     * <p>
     * You can specify any of the languages supported by Amazon Comprehend. All documents must be in the same language.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-languagecode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-languagecode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getLanguageCode();

    /**
     * Indicates the mode in which the classifier will be trained.
     * <p>
     * The classifier can be trained in multi-class (single-label) mode or multi-label mode. Multi-class mode identifies a single class label for each document and multi-label mode identifies one or more class labels for each document. Multiple labels for an individual document are separated by a delimiter. The default delimiter between labels is a pipe (|).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-mode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-mode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMode() {
        return null;
    }

    /**
     * ID for the AWS KMS key that Amazon Comprehend uses to encrypt trained custom models.
     * <p>
     * The ModelKmsKeyId can be either of the following formats:
     * <p>
     * <ul>
     * <li>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code></li>
     * <li>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-modelkmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-modelkmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getModelKmsKeyId() {
        return null;
    }

    /**
     * The resource-based policy to attach to your custom document classifier model.
     * <p>
     * You can use this policy to allow another AWS account to import your custom model.
     * <p>
     * Provide your policy as a JSON body that you enter as a UTF-8 encoded string without line breaks. To provide valid JSON, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:
     * <p>
     * <code>"{\"attribute\": \"value\", \"attribute\": [\"value\"]}"</code>
     * <p>
     * To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:
     * <p>
     * <code>'{"attribute": "value", "attribute": ["value"]}'</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-modelpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-modelpolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getModelPolicy() {
        return null;
    }

    /**
     * Provides output results configuration parameters for custom classifier jobs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-outputdataconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-outputdataconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOutputDataConfig() {
        return null;
    }

    /**
     * Tags to associate with the document classifier.
     * <p>
     * A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The version name given to the newly created classifier.
     * <p>
     * Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same classifier name in the AWS account / AWS Region .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-versionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-versionname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersionName() {
        return null;
    }

    /**
     * ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job.
     * <p>
     * The VolumeKmsKeyId can be either of the following formats:
     * <p>
     * <ul>
     * <li>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code></li>
     * <li>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-volumekmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-volumekmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVolumeKmsKeyId() {
        return null;
    }

    /**
     * Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-vpcconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-comprehend-documentclassifier.html#cfn-comprehend-documentclassifier-vpcconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDocumentClassifierProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDocumentClassifierProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDocumentClassifierProps> {
        java.lang.String dataAccessRoleArn;
        java.lang.String documentClassifierName;
        java.lang.Object inputDataConfig;
        java.lang.String languageCode;
        java.lang.String mode;
        java.lang.String modelKmsKeyId;
        java.lang.String modelPolicy;
        java.lang.Object outputDataConfig;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String versionName;
        java.lang.String volumeKmsKeyId;
        java.lang.Object vpcConfig;

        /**
         * Sets the value of {@link CfnDocumentClassifierProps#getDataAccessRoleArn}
         * @param dataAccessRoleArn The Amazon Resource Name (ARN) of the IAM role that grants Amazon Comprehend read access to your input data. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataAccessRoleArn(java.lang.String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentClassifierProps#getDocumentClassifierName}
         * @param documentClassifierName The name of the document classifier. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentClassifierName(java.lang.String documentClassifierName) {
            this.documentClassifierName = documentClassifierName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentClassifierProps#getInputDataConfig}
         * @param inputDataConfig Specifies the format and location of the input data for the job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputDataConfig(software.amazon.awscdk.IResolvable inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentClassifierProps#getInputDataConfig}
         * @param inputDataConfig Specifies the format and location of the input data for the job. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputDataConfig(software.amazon.awscdk.services.comprehend.CfnDocumentClassifier.DocumentClassifierInputDataConfigProperty inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentClassifierProps#getLanguageCode}
         * @param languageCode The language of the input documents. This parameter is required.
         *                     You can specify any of the languages supported by Amazon Comprehend. All documents must be in the same language.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder languageCode(java.lang.String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentClassifierProps#getMode}
         * @param mode Indicates the mode in which the classifier will be trained.
         *             The classifier can be trained in multi-class (single-label) mode or multi-label mode. Multi-class mode identifies a single class label for each document and multi-label mode identifies one or more class labels for each document. Multiple labels for an individual document are separated by a delimiter. The default delimiter between labels is a pipe (|).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mode(java.lang.String mode) {
            this.mode = mode;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentClassifierProps#getModelKmsKeyId}
         * @param modelKmsKeyId ID for the AWS KMS key that Amazon Comprehend uses to encrypt trained custom models.
         *                      The ModelKmsKeyId can be either of the following formats:
         *                      <p>
         *                      <ul>
         *                      <li>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code></li>
         *                      <li>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code></li>
         *                      </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelKmsKeyId(java.lang.String modelKmsKeyId) {
            this.modelKmsKeyId = modelKmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentClassifierProps#getModelPolicy}
         * @param modelPolicy The resource-based policy to attach to your custom document classifier model.
         *                    You can use this policy to allow another AWS account to import your custom model.
         *                    <p>
         *                    Provide your policy as a JSON body that you enter as a UTF-8 encoded string without line breaks. To provide valid JSON, enclose the attribute names and values in double quotes. If the JSON body is also enclosed in double quotes, then you must escape the double quotes that are inside the policy:
         *                    <p>
         *                    <code>"{\"attribute\": \"value\", \"attribute\": [\"value\"]}"</code>
         *                    <p>
         *                    To avoid escaping quotes, you can use single quotes to enclose the policy and double quotes to enclose the JSON names and values:
         *                    <p>
         *                    <code>'{"attribute": "value", "attribute": ["value"]}'</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelPolicy(java.lang.String modelPolicy) {
            this.modelPolicy = modelPolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentClassifierProps#getOutputDataConfig}
         * @param outputDataConfig Provides output results configuration parameters for custom classifier jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputDataConfig(software.amazon.awscdk.IResolvable outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentClassifierProps#getOutputDataConfig}
         * @param outputDataConfig Provides output results configuration parameters for custom classifier jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputDataConfig(software.amazon.awscdk.services.comprehend.CfnDocumentClassifier.DocumentClassifierOutputDataConfigProperty outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentClassifierProps#getTags}
         * @param tags Tags to associate with the document classifier.
         *             A tag is a key-value pair that adds as a metadata to a resource used by Amazon Comprehend. For example, a tag with "Sales" as the key might be added to a resource to indicate its use by the sales department.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentClassifierProps#getVersionName}
         * @param versionName The version name given to the newly created classifier.
         *                    Version names can have a maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores (_) are allowed. The version name must be unique among all models with the same classifier name in the AWS account / AWS Region .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionName(java.lang.String versionName) {
            this.versionName = versionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentClassifierProps#getVolumeKmsKeyId}
         * @param volumeKmsKeyId ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses to encrypt data on the storage volume attached to the ML compute instance(s) that process the analysis job.
         *                       The VolumeKmsKeyId can be either of the following formats:
         *                       <p>
         *                       <ul>
         *                       <li>KMS Key ID: <code>"1234abcd-12ab-34cd-56ef-1234567890ab"</code></li>
         *                       <li>Amazon Resource Name (ARN) of a KMS Key: <code>"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"</code></li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeKmsKeyId(java.lang.String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentClassifierProps#getVpcConfig}
         * @param vpcConfig Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier.
         *                  For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(software.amazon.awscdk.IResolvable vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnDocumentClassifierProps#getVpcConfig}
         * @param vpcConfig Configuration parameters for a private Virtual Private Cloud (VPC) containing the resources you are using for your custom classifier.
         *                  For more information, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html">Amazon VPC</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(software.amazon.awscdk.services.comprehend.CfnDocumentClassifier.VpcConfigProperty vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDocumentClassifierProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDocumentClassifierProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDocumentClassifierProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDocumentClassifierProps {
        private final java.lang.String dataAccessRoleArn;
        private final java.lang.String documentClassifierName;
        private final java.lang.Object inputDataConfig;
        private final java.lang.String languageCode;
        private final java.lang.String mode;
        private final java.lang.String modelKmsKeyId;
        private final java.lang.String modelPolicy;
        private final java.lang.Object outputDataConfig;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String versionName;
        private final java.lang.String volumeKmsKeyId;
        private final java.lang.Object vpcConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataAccessRoleArn = software.amazon.jsii.Kernel.get(this, "dataAccessRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.documentClassifierName = software.amazon.jsii.Kernel.get(this, "documentClassifierName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inputDataConfig = software.amazon.jsii.Kernel.get(this, "inputDataConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.languageCode = software.amazon.jsii.Kernel.get(this, "languageCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mode = software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelKmsKeyId = software.amazon.jsii.Kernel.get(this, "modelKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelPolicy = software.amazon.jsii.Kernel.get(this, "modelPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputDataConfig = software.amazon.jsii.Kernel.get(this, "outputDataConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.versionName = software.amazon.jsii.Kernel.get(this, "versionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volumeKmsKeyId = software.amazon.jsii.Kernel.get(this, "volumeKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcConfig = software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataAccessRoleArn = java.util.Objects.requireNonNull(builder.dataAccessRoleArn, "dataAccessRoleArn is required");
            this.documentClassifierName = java.util.Objects.requireNonNull(builder.documentClassifierName, "documentClassifierName is required");
            this.inputDataConfig = java.util.Objects.requireNonNull(builder.inputDataConfig, "inputDataConfig is required");
            this.languageCode = java.util.Objects.requireNonNull(builder.languageCode, "languageCode is required");
            this.mode = builder.mode;
            this.modelKmsKeyId = builder.modelKmsKeyId;
            this.modelPolicy = builder.modelPolicy;
            this.outputDataConfig = builder.outputDataConfig;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.versionName = builder.versionName;
            this.volumeKmsKeyId = builder.volumeKmsKeyId;
            this.vpcConfig = builder.vpcConfig;
        }

        @Override
        public final java.lang.String getDataAccessRoleArn() {
            return this.dataAccessRoleArn;
        }

        @Override
        public final java.lang.String getDocumentClassifierName() {
            return this.documentClassifierName;
        }

        @Override
        public final java.lang.Object getInputDataConfig() {
            return this.inputDataConfig;
        }

        @Override
        public final java.lang.String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final java.lang.String getMode() {
            return this.mode;
        }

        @Override
        public final java.lang.String getModelKmsKeyId() {
            return this.modelKmsKeyId;
        }

        @Override
        public final java.lang.String getModelPolicy() {
            return this.modelPolicy;
        }

        @Override
        public final java.lang.Object getOutputDataConfig() {
            return this.outputDataConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getVersionName() {
            return this.versionName;
        }

        @Override
        public final java.lang.String getVolumeKmsKeyId() {
            return this.volumeKmsKeyId;
        }

        @Override
        public final java.lang.Object getVpcConfig() {
            return this.vpcConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataAccessRoleArn", om.valueToTree(this.getDataAccessRoleArn()));
            data.set("documentClassifierName", om.valueToTree(this.getDocumentClassifierName()));
            data.set("inputDataConfig", om.valueToTree(this.getInputDataConfig()));
            data.set("languageCode", om.valueToTree(this.getLanguageCode()));
            if (this.getMode() != null) {
                data.set("mode", om.valueToTree(this.getMode()));
            }
            if (this.getModelKmsKeyId() != null) {
                data.set("modelKmsKeyId", om.valueToTree(this.getModelKmsKeyId()));
            }
            if (this.getModelPolicy() != null) {
                data.set("modelPolicy", om.valueToTree(this.getModelPolicy()));
            }
            if (this.getOutputDataConfig() != null) {
                data.set("outputDataConfig", om.valueToTree(this.getOutputDataConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVersionName() != null) {
                data.set("versionName", om.valueToTree(this.getVersionName()));
            }
            if (this.getVolumeKmsKeyId() != null) {
                data.set("volumeKmsKeyId", om.valueToTree(this.getVolumeKmsKeyId()));
            }
            if (this.getVpcConfig() != null) {
                data.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_comprehend.CfnDocumentClassifierProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDocumentClassifierProps.Jsii$Proxy that = (CfnDocumentClassifierProps.Jsii$Proxy) o;

            if (!dataAccessRoleArn.equals(that.dataAccessRoleArn)) return false;
            if (!documentClassifierName.equals(that.documentClassifierName)) return false;
            if (!inputDataConfig.equals(that.inputDataConfig)) return false;
            if (!languageCode.equals(that.languageCode)) return false;
            if (this.mode != null ? !this.mode.equals(that.mode) : that.mode != null) return false;
            if (this.modelKmsKeyId != null ? !this.modelKmsKeyId.equals(that.modelKmsKeyId) : that.modelKmsKeyId != null) return false;
            if (this.modelPolicy != null ? !this.modelPolicy.equals(that.modelPolicy) : that.modelPolicy != null) return false;
            if (this.outputDataConfig != null ? !this.outputDataConfig.equals(that.outputDataConfig) : that.outputDataConfig != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.versionName != null ? !this.versionName.equals(that.versionName) : that.versionName != null) return false;
            if (this.volumeKmsKeyId != null ? !this.volumeKmsKeyId.equals(that.volumeKmsKeyId) : that.volumeKmsKeyId != null) return false;
            return this.vpcConfig != null ? this.vpcConfig.equals(that.vpcConfig) : that.vpcConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataAccessRoleArn.hashCode();
            result = 31 * result + (this.documentClassifierName.hashCode());
            result = 31 * result + (this.inputDataConfig.hashCode());
            result = 31 * result + (this.languageCode.hashCode());
            result = 31 * result + (this.mode != null ? this.mode.hashCode() : 0);
            result = 31 * result + (this.modelKmsKeyId != null ? this.modelKmsKeyId.hashCode() : 0);
            result = 31 * result + (this.modelPolicy != null ? this.modelPolicy.hashCode() : 0);
            result = 31 * result + (this.outputDataConfig != null ? this.outputDataConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.versionName != null ? this.versionName.hashCode() : 0);
            result = 31 * result + (this.volumeKmsKeyId != null ? this.volumeKmsKeyId.hashCode() : 0);
            result = 31 * result + (this.vpcConfig != null ? this.vpcConfig.hashCode() : 0);
            return result;
        }
    }
}
